/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.io;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.List;

public class WKTFileReader {
    private File file = null;
    private Reader reader;
    private WKTReader wktReader;
    private int count = 0;
    private int limit = -1;
    private int offset = 0;
    private static final int MAX_LOOKAHEAD = 1000;

    public WKTFileReader(File file2, WKTReader wktReader) {
        this.file = file2;
        this.wktReader = wktReader;
    }

    public WKTFileReader(String filename2, WKTReader wktReader) {
        this(new File(filename2), wktReader);
    }

    public WKTFileReader(Reader reader, WKTReader wktReader) {
        this.reader = reader;
        this.wktReader = wktReader;
    }

    public void setLimit(int limit2) {
        this.limit = limit2;
    }

    public void setOffset(int offset2) {
        this.offset = offset2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List read() throws IOException, ParseException {
        if (this.file != null) {
            this.reader = new FileReader(this.file);
        }
        this.count = 0;
        try {
            List list2;
            BufferedReader bufferedReader = new BufferedReader(this.reader);
            try {
                list2 = this.read(bufferedReader);
            }
            catch (Throwable throwable) {
                bufferedReader.close();
                throw throwable;
            }
            bufferedReader.close();
            return list2;
        }
        finally {
            this.reader.close();
        }
    }

    private List read(BufferedReader bufferedReader) throws IOException, ParseException {
        ArrayList<Geometry> geoms = new ArrayList<Geometry>();
        while (!this.isAtEndOfFile(bufferedReader) && !this.isAtLimit(geoms)) {
            Geometry g = this.wktReader.read(bufferedReader);
            if (this.count >= this.offset) {
                geoms.add(g);
            }
            ++this.count;
        }
        return geoms;
    }

    private boolean isAtLimit(List geoms) {
        if (this.limit < 0) {
            return false;
        }
        return geoms.size() >= this.limit;
    }

    private boolean isAtEndOfFile(BufferedReader bufferedReader) throws IOException {
        bufferedReader.mark(1000);
        StreamTokenizer tokenizer = new StreamTokenizer(bufferedReader);
        int type2 = tokenizer.nextToken();
        if (type2 == -1) {
            return true;
        }
        bufferedReader.reset();
        return false;
    }
}

