/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.io;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.CoordinateSequences;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.ByteArrayInStream;
import com.vividsolutions.jts.io.ByteOrderDataInStream;
import com.vividsolutions.jts.io.InStream;
import com.vividsolutions.jts.io.ParseException;
import java.io.IOException;

public class WKBReader {
    private static final String INVALID_GEOM_TYPE_MSG = "Invalid geometry type encountered in ";
    private GeometryFactory factory;
    private CoordinateSequenceFactory csFactory;
    private PrecisionModel precisionModel;
    private int inputDimension = 2;
    private boolean hasSRID = false;
    private int SRID = 0;
    private boolean isRepairRings = false;
    private ByteOrderDataInStream dis = new ByteOrderDataInStream();
    private double[] ordValues;

    public static byte[] hexToBytes(String hex2) {
        int byteLen = hex2.length() / 2;
        byte[] bytes2 = new byte[byteLen];
        for (int i2 = 0; i2 < hex2.length() / 2; ++i2) {
            byte b;
            int i22 = 2 * i2;
            if (i22 + 1 > hex2.length()) {
                throw new IllegalArgumentException("Hex string has odd length");
            }
            int nib1 = WKBReader.hexToInt(hex2.charAt(i22));
            int nib0 = WKBReader.hexToInt(hex2.charAt(i22 + 1));
            bytes2[i2] = b = (byte)((nib1 << 4) + (byte)nib0);
        }
        return bytes2;
    }

    private static int hexToInt(char hex2) {
        int nib = Character.digit(hex2, 16);
        if (nib < 0) {
            throw new IllegalArgumentException("Invalid hex digit: '" + hex2 + "'");
        }
        return nib;
    }

    public WKBReader() {
        this(new GeometryFactory());
    }

    public WKBReader(GeometryFactory geometryFactory) {
        this.factory = geometryFactory;
        this.precisionModel = this.factory.getPrecisionModel();
        this.csFactory = this.factory.getCoordinateSequenceFactory();
    }

    public Geometry read(byte[] bytes2) throws ParseException {
        try {
            return this.read(new ByteArrayInStream(bytes2));
        }
        catch (IOException ex) {
            throw new RuntimeException("Unexpected IOException caught: " + ex.getMessage());
        }
    }

    public Geometry read(InStream is) throws IOException, ParseException {
        this.dis.setInStream(is);
        Geometry g = this.readGeometry();
        return g;
    }

    private Geometry readGeometry() throws IOException, ParseException {
        byte byteOrder = this.dis.readByte();
        if (byteOrder == 1) {
            this.dis.setOrder(2);
        }
        int typeInt = this.dis.readInt();
        int geometryType = typeInt & 0xFF;
        boolean hasZ = (typeInt & Integer.MIN_VALUE) != 0;
        this.inputDimension = hasZ ? 3 : 2;
        this.hasSRID = (typeInt & 0x20000000) != 0;
        int SRID = 0;
        if (this.hasSRID) {
            SRID = this.dis.readInt();
        }
        if (this.ordValues == null || this.ordValues.length < this.inputDimension) {
            this.ordValues = new double[this.inputDimension];
        }
        Geometry geom = null;
        switch (geometryType) {
            case 1: {
                geom = this.readPoint();
                break;
            }
            case 2: {
                geom = this.readLineString();
                break;
            }
            case 3: {
                geom = this.readPolygon();
                break;
            }
            case 4: {
                geom = this.readMultiPoint();
                break;
            }
            case 5: {
                geom = this.readMultiLineString();
                break;
            }
            case 6: {
                geom = this.readMultiPolygon();
                break;
            }
            case 7: {
                geom = this.readGeometryCollection();
                break;
            }
            default: {
                throw new ParseException("Unknown WKB type " + geometryType);
            }
        }
        this.setSRID(geom, SRID);
        return geom;
    }

    private Geometry setSRID(Geometry g, int SRID) {
        if (SRID != 0) {
            g.setSRID(SRID);
        }
        return g;
    }

    private Point readPoint() throws IOException {
        CoordinateSequence pts = this.readCoordinateSequence(1);
        return this.factory.createPoint(pts);
    }

    private LineString readLineString() throws IOException {
        int size2 = this.dis.readInt();
        CoordinateSequence pts = this.readCoordinateSequence(size2);
        return this.factory.createLineString(pts);
    }

    private LinearRing readLinearRing() throws IOException {
        int size2 = this.dis.readInt();
        CoordinateSequence pts = this.readCoordinateSequenceRing(size2);
        return this.factory.createLinearRing(pts);
    }

    private Polygon readPolygon() throws IOException {
        int numRings = this.dis.readInt();
        LinearRing[] holes = null;
        if (numRings > 1) {
            holes = new LinearRing[numRings - 1];
        }
        LinearRing shell = this.readLinearRing();
        for (int i2 = 0; i2 < numRings - 1; ++i2) {
            holes[i2] = this.readLinearRing();
        }
        return this.factory.createPolygon(shell, holes);
    }

    private MultiPoint readMultiPoint() throws IOException, ParseException {
        int numGeom = this.dis.readInt();
        Point[] geoms = new Point[numGeom];
        for (int i2 = 0; i2 < numGeom; ++i2) {
            Geometry g = this.readGeometry();
            if (!(g instanceof Point)) {
                throw new ParseException("Invalid geometry type encountered in MultiPoint");
            }
            geoms[i2] = (Point)g;
        }
        return this.factory.createMultiPoint(geoms);
    }

    private MultiLineString readMultiLineString() throws IOException, ParseException {
        int numGeom = this.dis.readInt();
        LineString[] geoms = new LineString[numGeom];
        for (int i2 = 0; i2 < numGeom; ++i2) {
            Geometry g = this.readGeometry();
            if (!(g instanceof LineString)) {
                throw new ParseException("Invalid geometry type encountered in MultiLineString");
            }
            geoms[i2] = (LineString)g;
        }
        return this.factory.createMultiLineString(geoms);
    }

    private MultiPolygon readMultiPolygon() throws IOException, ParseException {
        int numGeom = this.dis.readInt();
        Polygon[] geoms = new Polygon[numGeom];
        for (int i2 = 0; i2 < numGeom; ++i2) {
            Geometry g = this.readGeometry();
            if (!(g instanceof Polygon)) {
                throw new ParseException("Invalid geometry type encountered in MultiPolygon");
            }
            geoms[i2] = (Polygon)g;
        }
        return this.factory.createMultiPolygon(geoms);
    }

    private GeometryCollection readGeometryCollection() throws IOException, ParseException {
        int numGeom = this.dis.readInt();
        Geometry[] geoms = new Geometry[numGeom];
        for (int i2 = 0; i2 < numGeom; ++i2) {
            geoms[i2] = this.readGeometry();
        }
        return this.factory.createGeometryCollection(geoms);
    }

    private CoordinateSequence readCoordinateSequence(int size2) throws IOException {
        CoordinateSequence seq = this.csFactory.create(size2, this.inputDimension);
        int targetDim = seq.getDimension();
        if (targetDim > this.inputDimension) {
            targetDim = this.inputDimension;
        }
        for (int i2 = 0; i2 < size2; ++i2) {
            this.readCoordinate();
            for (int j = 0; j < targetDim; ++j) {
                seq.setOrdinate(i2, j, this.ordValues[j]);
            }
        }
        return seq;
    }

    private CoordinateSequence readCoordinateSequenceRing(int size2) throws IOException {
        CoordinateSequence seq = this.readCoordinateSequence(size2);
        if (!this.isRepairRings) {
            return seq;
        }
        if (CoordinateSequences.isRing(seq)) {
            return seq;
        }
        return CoordinateSequences.ensureValidRing(this.csFactory, seq);
    }

    private void readCoordinate() throws IOException {
        for (int i2 = 0; i2 < this.inputDimension; ++i2) {
            this.ordValues[i2] = i2 <= 1 ? this.precisionModel.makePrecise(this.dis.readDouble()) : this.dis.readDouble();
        }
    }
}

