/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.quadtree;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.index.quadtree.DoubleBits;

public class Key {
    private Coordinate pt = new Coordinate();
    private int level = 0;
    private Envelope env = null;

    public static int computeQuadLevel(Envelope env) {
        double dy;
        double dx = env.getWidth();
        double dMax = dx > (dy = env.getHeight()) ? dx : dy;
        int level2 = DoubleBits.exponent(dMax) + 1;
        return level2;
    }

    public Key(Envelope itemEnv) {
        this.computeKey(itemEnv);
    }

    public Coordinate getPoint() {
        return this.pt;
    }

    public int getLevel() {
        return this.level;
    }

    public Envelope getEnvelope() {
        return this.env;
    }

    public Coordinate getCentre() {
        return new Coordinate((this.env.getMinX() + this.env.getMaxX()) / 2.0, (this.env.getMinY() + this.env.getMaxY()) / 2.0);
    }

    public void computeKey(Envelope itemEnv) {
        this.level = Key.computeQuadLevel(itemEnv);
        this.env = new Envelope();
        this.computeKey(this.level, itemEnv);
        while (!this.env.contains(itemEnv)) {
            ++this.level;
            this.computeKey(this.level, itemEnv);
        }
    }

    private void computeKey(int level2, Envelope itemEnv) {
        double quadSize = DoubleBits.powerOf2(level2);
        this.pt.x = Math.floor(itemEnv.getMinX() / quadSize) * quadSize;
        this.pt.y = Math.floor(itemEnv.getMinY() / quadSize) * quadSize;
        this.env.init(this.pt.x, this.pt.x + quadSize, this.pt.y, this.pt.y + quadSize);
    }
}

