/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.kdtree;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.index.kdtree.KdNode;
import java.util.ArrayList;
import java.util.List;

public class KdTree {
    private KdNode root = null;
    private KdNode last = null;
    private long numberOfNodes;
    private double tolerance;

    public KdTree() {
        this(0.0);
    }

    public KdTree(double tolerance) {
        this.tolerance = tolerance;
    }

    public KdNode insert(Coordinate p2) {
        return this.insert(p2, null);
    }

    public KdNode insert(Coordinate p2, Object data2) {
        if (this.root == null) {
            this.root = new KdNode(p2, data2);
            return this.root;
        }
        KdNode currentNode = this.root;
        KdNode leafNode = this.root;
        boolean isOddLevel = true;
        boolean isLessThan = true;
        while (currentNode != this.last) {
            isLessThan = isOddLevel ? p2.x < currentNode.getX() : p2.y < currentNode.getY();
            leafNode = currentNode;
            currentNode = isLessThan ? currentNode.getLeft() : currentNode.getRight();
            if (currentNode != null) {
                boolean isInTolerance;
                boolean bl = isInTolerance = p2.distance(currentNode.getCoordinate()) <= this.tolerance;
                if (isInTolerance) {
                    currentNode.increment();
                    return currentNode;
                }
            }
            isOddLevel = !isOddLevel;
        }
        ++this.numberOfNodes;
        KdNode node = new KdNode(p2, data2);
        node.setLeft(this.last);
        node.setRight(this.last);
        if (isLessThan) {
            leafNode.setLeft(node);
        } else {
            leafNode.setRight(node);
        }
        return node;
    }

    private void queryNode(KdNode currentNode, KdNode bottomNode, Envelope queryEnv, boolean odd, List result2) {
        boolean searchRight;
        double discriminant;
        double max2;
        double min2;
        if (currentNode == bottomNode) {
            return;
        }
        if (odd) {
            min2 = queryEnv.getMinX();
            max2 = queryEnv.getMaxX();
            discriminant = currentNode.getX();
        } else {
            min2 = queryEnv.getMinY();
            max2 = queryEnv.getMaxY();
            discriminant = currentNode.getY();
        }
        boolean searchLeft = min2 < discriminant;
        boolean bl = searchRight = discriminant <= max2;
        if (searchLeft) {
            this.queryNode(currentNode.getLeft(), bottomNode, queryEnv, !odd, result2);
        }
        if (queryEnv.contains(currentNode.getCoordinate())) {
            result2.add(currentNode);
        }
        if (searchRight) {
            this.queryNode(currentNode.getRight(), bottomNode, queryEnv, !odd, result2);
        }
    }

    public List query(Envelope queryEnv) {
        ArrayList result2 = new ArrayList();
        this.queryNode(this.root, this.last, queryEnv, true, result2);
        return result2;
    }

    public void query(Envelope queryEnv, List result2) {
        this.queryNode(this.root, this.last, queryEnv, true, result2);
    }
}

