/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.chain;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geomgraph.Quadrant;
import com.vividsolutions.jts.index.chain.MonotoneChain;
import java.util.ArrayList;
import java.util.List;

public class MonotoneChainBuilder {
    public static int[] toIntArray(List list2) {
        int[] array = new int[list2.size()];
        for (int i2 = 0; i2 < array.length; ++i2) {
            array[i2] = (Integer)list2.get(i2);
        }
        return array;
    }

    public static List getChains(Coordinate[] pts) {
        return MonotoneChainBuilder.getChains(pts, null);
    }

    public static List getChains(Coordinate[] pts, Object context) {
        ArrayList<MonotoneChain> mcList = new ArrayList<MonotoneChain>();
        int[] startIndex = MonotoneChainBuilder.getChainStartIndices(pts);
        for (int i2 = 0; i2 < startIndex.length - 1; ++i2) {
            MonotoneChain mc = new MonotoneChain(pts, startIndex[i2], startIndex[i2 + 1], context);
            mcList.add(mc);
        }
        return mcList;
    }

    public static int[] getChainStartIndices(Coordinate[] pts) {
        int last2;
        int start2 = 0;
        ArrayList<Integer> startIndexList = new ArrayList<Integer>();
        startIndexList.add(new Integer(start2));
        do {
            last2 = MonotoneChainBuilder.findChainEnd(pts, start2);
            startIndexList.add(new Integer(last2));
        } while ((start2 = last2) < pts.length - 1);
        int[] startIndex = MonotoneChainBuilder.toIntArray(startIndexList);
        return startIndex;
    }

    private static int findChainEnd(Coordinate[] pts, int start2) {
        int quad;
        int last2;
        int safeStart;
        for (safeStart = start2; safeStart < pts.length - 1 && pts[safeStart].equals2D(pts[safeStart + 1]); ++safeStart) {
        }
        if (safeStart >= pts.length - 1) {
            return pts.length - 1;
        }
        int chainQuad = Quadrant.quadrant(pts[safeStart], pts[safeStart + 1]);
        for (last2 = start2 + 1; last2 < pts.length && (pts[last2 - 1].equals2D(pts[last2]) || (quad = Quadrant.quadrant(pts[last2 - 1], pts[last2])) == chainQuad); ++last2) {
        }
        return last2 - 1;
    }
}

