/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.bintree;

import com.vividsolutions.jts.index.bintree.Interval;
import com.vividsolutions.jts.index.bintree.Key;
import com.vividsolutions.jts.index.bintree.NodeBase;
import com.vividsolutions.jts.util.Assert;

public class Node
extends NodeBase {
    private Interval interval;
    private double centre;
    private int level;

    public static Node createNode(Interval itemInterval) {
        Key key2 = new Key(itemInterval);
        Node node = new Node(key2.getInterval(), key2.getLevel());
        return node;
    }

    public static Node createExpanded(Node node, Interval addInterval) {
        Interval expandInt = new Interval(addInterval);
        if (node != null) {
            expandInt.expandToInclude(node.interval);
        }
        Node largerNode = Node.createNode(expandInt);
        if (node != null) {
            largerNode.insert(node);
        }
        return largerNode;
    }

    public Node(Interval interval, int level2) {
        this.interval = interval;
        this.level = level2;
        this.centre = (interval.getMin() + interval.getMax()) / 2.0;
    }

    public Interval getInterval() {
        return this.interval;
    }

    protected boolean isSearchMatch(Interval itemInterval) {
        return itemInterval.overlaps(this.interval);
    }

    public Node getNode(Interval searchInterval) {
        int subnodeIndex = Node.getSubnodeIndex(searchInterval, this.centre);
        if (subnodeIndex != -1) {
            Node node = this.getSubnode(subnodeIndex);
            return node.getNode(searchInterval);
        }
        return this;
    }

    public NodeBase find(Interval searchInterval) {
        int subnodeIndex = Node.getSubnodeIndex(searchInterval, this.centre);
        if (subnodeIndex == -1) {
            return this;
        }
        if (this.subnode[subnodeIndex] != null) {
            Node node = this.subnode[subnodeIndex];
            return node.find(searchInterval);
        }
        return this;
    }

    void insert(Node node) {
        Assert.isTrue(this.interval == null || this.interval.contains(node.interval));
        int index2 = Node.getSubnodeIndex(node.interval, this.centre);
        if (node.level == this.level - 1) {
            this.subnode[index2] = node;
        } else {
            Node childNode = this.createSubnode(index2);
            childNode.insert(node);
            this.subnode[index2] = childNode;
        }
    }

    private Node getSubnode(int index2) {
        if (this.subnode[index2] == null) {
            this.subnode[index2] = this.createSubnode(index2);
        }
        return this.subnode[index2];
    }

    private Node createSubnode(int index2) {
        double min2 = 0.0;
        double max2 = 0.0;
        switch (index2) {
            case 0: {
                min2 = this.interval.getMin();
                max2 = this.centre;
                break;
            }
            case 1: {
                min2 = this.centre;
                max2 = this.interval.getMax();
            }
        }
        Interval subInt = new Interval(min2, max2);
        Node node = new Node(subInt, this.level - 1);
        return node;
    }
}

