/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.noding.OrientedCoordinateArray;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class EdgeList {
    private List edges = new ArrayList();
    private Map ocaMap = new TreeMap();

    public void add(Edge e) {
        this.edges.add(e);
        OrientedCoordinateArray oca = new OrientedCoordinateArray(e.getCoordinates());
        this.ocaMap.put(oca, e);
    }

    public void addAll(Collection edgeColl) {
        Iterator i2 = edgeColl.iterator();
        while (i2.hasNext()) {
            this.add((Edge)i2.next());
        }
    }

    public List getEdges() {
        return this.edges;
    }

    public Edge findEqualEdge(Edge e) {
        OrientedCoordinateArray oca = new OrientedCoordinateArray(e.getCoordinates());
        Edge matchEdge = (Edge)this.ocaMap.get(oca);
        return matchEdge;
    }

    public Iterator iterator() {
        return this.edges.iterator();
    }

    public Edge get(int i2) {
        return (Edge)this.edges.get(i2);
    }

    public int findEdgeIndex(Edge e) {
        for (int i2 = 0; i2 < this.edges.size(); ++i2) {
            if (!((Edge)this.edges.get(i2)).equals(e)) continue;
            return i2;
        }
        return -1;
    }

    public void print(PrintStream out) {
        out.print("MULTILINESTRING ( ");
        for (int j = 0; j < this.edges.size(); ++j) {
            Edge e = (Edge)this.edges.get(j);
            if (j > 0) {
                out.print(",");
            }
            out.print("(");
            Coordinate[] pts = e.getCoordinates();
            for (int i2 = 0; i2 < pts.length; ++i2) {
                if (i2 > 0) {
                    out.print(",");
                }
                out.print(pts[i2].x + " " + pts[i2].y);
            }
            out.println(")");
        }
        out.print(")  ");
    }
}

