/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.impl;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.impl.PackedCoordinateSequence;

public class PackedCoordinateSequenceFactory
implements CoordinateSequenceFactory {
    public static final int DOUBLE = 0;
    public static final int FLOAT = 1;
    public static final PackedCoordinateSequenceFactory DOUBLE_FACTORY = new PackedCoordinateSequenceFactory(0);
    public static final PackedCoordinateSequenceFactory FLOAT_FACTORY = new PackedCoordinateSequenceFactory(1);
    private int type = 0;
    private int dimension = 3;

    public PackedCoordinateSequenceFactory() {
        this(0);
    }

    public PackedCoordinateSequenceFactory(int type2) {
        this(type2, 3);
    }

    public PackedCoordinateSequenceFactory(int type2, int dimension) {
        this.setType(type2);
        this.setDimension(dimension);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type2) {
        if (type2 != 0 && type2 != 1) {
            throw new IllegalArgumentException("Unknown type " + type2);
        }
        this.type = type2;
    }

    public int getDimension() {
        return this.dimension;
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    public CoordinateSequence create(Coordinate[] coordinates) {
        if (this.type == 0) {
            return new PackedCoordinateSequence.Double(coordinates, this.dimension);
        }
        return new PackedCoordinateSequence.Float(coordinates, this.dimension);
    }

    public CoordinateSequence create(CoordinateSequence coordSeq) {
        if (this.type == 0) {
            return new PackedCoordinateSequence.Double(coordSeq.toCoordinateArray(), this.dimension);
        }
        return new PackedCoordinateSequence.Float(coordSeq.toCoordinateArray(), this.dimension);
    }

    public CoordinateSequence create(double[] packedCoordinates, int dimension) {
        if (this.type == 0) {
            return new PackedCoordinateSequence.Double(packedCoordinates, dimension);
        }
        return new PackedCoordinateSequence.Float(packedCoordinates, dimension);
    }

    public CoordinateSequence create(float[] packedCoordinates, int dimension) {
        if (this.type == 0) {
            return new PackedCoordinateSequence.Double(packedCoordinates, dimension);
        }
        return new PackedCoordinateSequence.Float(packedCoordinates, dimension);
    }

    public CoordinateSequence create(int size2, int dimension) {
        if (this.type == 0) {
            return new PackedCoordinateSequence.Double(size2, dimension);
        }
        return new PackedCoordinateSequence.Float(size2, dimension);
    }
}

