/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;

public class InteriorPointArea {
    private GeometryFactory factory;
    private Coordinate interiorPoint = null;
    private double maxWidth = 0.0;

    private static double avg(double a, double b) {
        return (a + b) / 2.0;
    }

    public InteriorPointArea(Geometry g) {
        this.factory = g.getFactory();
        this.add(g);
    }

    public Coordinate getInteriorPoint() {
        return this.interiorPoint;
    }

    private void add(Geometry geom) {
        if (geom instanceof Polygon) {
            this.addPolygon(geom);
        } else if (geom instanceof GeometryCollection) {
            GeometryCollection gc2 = (GeometryCollection)geom;
            for (int i2 = 0; i2 < gc2.getNumGeometries(); ++i2) {
                this.add(gc2.getGeometryN(i2));
            }
        }
    }

    public void addPolygon(Geometry geometry) {
        LineString bisector = this.horizontalBisector(geometry);
        Geometry intersections = bisector.intersection(geometry);
        Geometry widestIntersection = this.widestGeometry(intersections);
        double width = widestIntersection.getEnvelopeInternal().getWidth();
        if (this.interiorPoint == null || width > this.maxWidth) {
            this.interiorPoint = this.centre(widestIntersection.getEnvelopeInternal());
            this.maxWidth = width;
        }
    }

    protected Geometry widestGeometry(Geometry geometry) {
        if (!(geometry instanceof GeometryCollection)) {
            return geometry;
        }
        return this.widestGeometry((GeometryCollection)geometry);
    }

    private Geometry widestGeometry(GeometryCollection gc2) {
        if (gc2.isEmpty()) {
            return gc2;
        }
        Geometry widestGeometry = gc2.getGeometryN(0);
        for (int i2 = 1; i2 < gc2.getNumGeometries(); ++i2) {
            if (!(gc2.getGeometryN(i2).getEnvelopeInternal().getWidth() > widestGeometry.getEnvelopeInternal().getWidth())) continue;
            widestGeometry = gc2.getGeometryN(i2);
        }
        return widestGeometry;
    }

    protected LineString horizontalBisector(Geometry geometry) {
        Envelope envelope = geometry.getEnvelopeInternal();
        double avgY = InteriorPointArea.avg(envelope.getMinY(), envelope.getMaxY());
        return this.factory.createLineString(new Coordinate[]{new Coordinate(envelope.getMinX(), avgY), new Coordinate(envelope.getMaxX(), avgY)});
    }

    public Coordinate centre(Envelope envelope) {
        return new Coordinate(InteriorPointArea.avg(envelope.getMinX(), envelope.getMaxX()), InteriorPointArea.avg(envelope.getMinY(), envelope.getMaxY()));
    }
}

