/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.schematron;

import com.thaiopensource.util.Localizer;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class OutputHandler
extends DefaultHandler {
    private final ErrorHandler eh;
    private int lineNumber = -1;
    private String systemId = null;
    private final StringBuffer message = new StringBuffer();
    private boolean inMessage = false;
    private final String lineSeparator;
    private static final String indent = "  ";
    private final Localizer localizer = new Localizer(class$com$thaiopensource$validate$schematron$OutputHandler == null ? (class$com$thaiopensource$validate$schematron$OutputHandler = OutputHandler.class$("com.thaiopensource.validate.schematron.OutputHandler")) : class$com$thaiopensource$validate$schematron$OutputHandler);
    static /* synthetic */ Class class$com$thaiopensource$validate$schematron$OutputHandler;

    OutputHandler(ErrorHandler errorHandler) {
        this.eh = errorHandler;
        this.lineSeparator = System.getProperty("line.separator");
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.inMessage) {
            block3: for (int j = 0; j < n2; ++j) {
                char c = cArray[n + j];
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        if (this.message.length() != 0 && this.message.charAt(this.message.length() - 1) == ' ') continue block3;
                        this.message.append(' ');
                        continue block3;
                    }
                    default: {
                        this.message.append(c);
                    }
                }
            }
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.characters(cArray, n, n2);
    }

    public void startElement(String string2, String string3, String string4, Attributes attributes) throws SAXException {
        if (string3.equals("failed-assertion") || string3.equals("report")) {
            String string5 = attributes.getValue("", "line-number");
            if (string5 == null) {
                this.lineNumber = -1;
            } else {
                try {
                    this.lineNumber = Integer.parseInt(string5);
                }
                catch (NumberFormatException numberFormatException) {
                    this.lineNumber = -1;
                }
            }
            string5 = attributes.getValue("", "system-id");
            if (string5 != null && string5.equals("")) {
                string5 = null;
            }
            this.systemId = string5;
            this.message.append(this.localizer.message(string3.equals("failed-assertion") ? "failed_assertion" : "report"));
        } else if (string3.equals("statement") || string3.equals("diagnostic")) {
            this.inMessage = true;
            this.message.append(this.lineSeparator);
            this.message.append(indent);
        }
    }

    public void endElement(String string2, String string3, String string4) throws SAXException {
        if (string3.equals("statement") || string3.equals("diagnostic")) {
            if (this.message.length() > 0 && this.message.charAt(this.message.length() - 1) == ' ') {
                this.message.setLength(this.message.length() - 1);
            }
            this.inMessage = false;
        } else if (string3.equals("failed-assertion") || string3.equals("report")) {
            this.eh.error(new SAXParseException(this.message.toString(), null, this.systemId, this.lineNumber, -1));
            this.message.setLength(0);
        }
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

