/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.picl;

import com.thaiopensource.validate.picl.Constraint;
import com.thaiopensource.validate.picl.ErrorContext;
import com.thaiopensource.validate.picl.Pattern;
import com.thaiopensource.validate.picl.PatternManager;
import com.thaiopensource.validate.picl.SelectedValueHandler;
import com.thaiopensource.validate.picl.ValueSelectionHandler;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.Locator;

class KeyConstraint
implements Constraint {
    private final Pattern key;

    KeyConstraint(Pattern pattern) {
        this.key = pattern;
    }

    public void activate(PatternManager patternManager) {
        this.activate(patternManager, new KeyIndex());
    }

    void activate(PatternManager patternManager, KeyIndex keyIndex) {
        patternManager.registerPattern(this.key, new ValueSelectionHandler(new KeySelectionHandler(keyIndex)));
    }

    static class KeySelectionHandler
    extends SelectedValueHandler {
        private final KeyIndex index;

        KeySelectionHandler(KeyIndex keyIndex) {
            this.index = keyIndex;
        }

        void select(ErrorContext errorContext, Locator locator, Object object, String string2) {
            KeyInfo keyInfo = this.index.lookupCreate(object);
            if (keyInfo.firstKeyLocator == null) {
                if (locator == null) {
                    locator = errorContext.saveLocator();
                }
                keyInfo.firstKeyLocator = locator;
                keyInfo.pendingRefLocators = null;
                keyInfo.representation = string2;
            } else {
                errorContext.error(locator, "duplicate_key", string2);
            }
        }
    }

    static class KeyInfo {
        String representation;
        Locator firstKeyLocator;
        Vector pendingRefLocators;

        KeyInfo() {
        }
    }

    static class KeyIndex {
        private final Hashtable table = new Hashtable();

        KeyIndex() {
        }

        KeyInfo lookupCreate(Object object) {
            KeyInfo keyInfo = (KeyInfo)this.table.get(object);
            if (keyInfo == null) {
                keyInfo = new KeyInfo();
                this.table.put(object, keyInfo);
            }
            return keyInfo;
        }

        Enumeration keys() {
            return this.table.keys();
        }
    }
}

