/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.nrl;

import com.thaiopensource.validate.nrl.ActionSet;
import com.thaiopensource.validate.nrl.AttributeActionSet;
import java.util.Enumeration;
import java.util.Hashtable;
import org.xml.sax.Locator;
import org.xml.sax.helpers.LocatorImpl;

class Mode {
    static final String ANY_NAMESPACE = "##any";
    static final int ATTRIBUTE_PROCESSING_NONE = 0;
    static final int ATTRIBUTE_PROCESSING_QUALIFIED = 1;
    static final int ATTRIBUTE_PROCESSING_FULL = 2;
    static final Mode CURRENT = new Mode("#current", null);
    private final String name;
    private Mode baseMode;
    private boolean defined;
    private Locator whereDefined;
    private Locator whereUsed;
    private final Hashtable elementMap = new Hashtable();
    private final Hashtable attributeMap = new Hashtable();
    private int attributeProcessing = -1;

    Mode(String string2, Mode mode2) {
        this.name = string2;
        this.baseMode = mode2;
    }

    String getName() {
        return this.name;
    }

    Mode getBaseMode() {
        return this.baseMode;
    }

    void setBaseMode(Mode mode2) {
        this.baseMode = mode2;
    }

    ActionSet getElementActions(String string2) {
        ActionSet actionSet = this.getElementActionsExplicit(string2);
        if (actionSet == null) {
            actionSet = this.getElementActionsExplicit(ANY_NAMESPACE);
        }
        return actionSet;
    }

    private ActionSet getElementActionsExplicit(String string2) {
        ActionSet actionSet = (ActionSet)this.elementMap.get(string2);
        if (actionSet == null && this.baseMode != null && (actionSet = this.baseMode.getElementActionsExplicit(string2)) != null) {
            actionSet = actionSet.changeCurrentMode(this);
            this.elementMap.put(string2, actionSet);
        }
        return actionSet;
    }

    AttributeActionSet getAttributeActions(String string2) {
        AttributeActionSet attributeActionSet = this.getAttributeActionsExplicit(string2);
        if (attributeActionSet == null) {
            attributeActionSet = this.getAttributeActionsExplicit(ANY_NAMESPACE);
        }
        return attributeActionSet;
    }

    private AttributeActionSet getAttributeActionsExplicit(String string2) {
        AttributeActionSet attributeActionSet = (AttributeActionSet)this.attributeMap.get(string2);
        if (attributeActionSet == null && this.baseMode != null && (attributeActionSet = this.baseMode.getAttributeActionsExplicit(string2)) != null) {
            this.attributeMap.put(string2, attributeActionSet);
        }
        return attributeActionSet;
    }

    int getAttributeProcessing() {
        if (this.attributeProcessing == -1) {
            this.attributeProcessing = this.baseMode != null ? this.baseMode.getAttributeProcessing() : 0;
            Enumeration enumeration = this.attributeMap.keys();
            while (enumeration.hasMoreElements() && this.attributeProcessing != 2) {
                String string2 = (String)enumeration.nextElement();
                AttributeActionSet attributeActionSet = (AttributeActionSet)this.attributeMap.get(string2);
                if (attributeActionSet.getAttach() && !attributeActionSet.getReject() && attributeActionSet.getSchemas().length <= 0) continue;
                this.attributeProcessing = string2.equals("") || string2.equals(ANY_NAMESPACE) ? 2 : 1;
            }
        }
        return this.attributeProcessing;
    }

    Locator getWhereDefined() {
        return this.whereDefined;
    }

    boolean isDefined() {
        return this.defined;
    }

    Locator getWhereUsed() {
        return this.whereUsed;
    }

    void noteUsed(Locator locator) {
        if (this.whereUsed == null && locator != null) {
            this.whereUsed = new LocatorImpl(locator);
        }
    }

    void noteDefined(Locator locator) {
        this.defined = true;
        if (this.whereDefined == null && locator != null) {
            this.whereDefined = new LocatorImpl(locator);
        }
    }

    boolean bindElement(String string2, ActionSet actionSet) {
        if (this.elementMap.get(string2) != null) {
            return false;
        }
        this.elementMap.put(string2, actionSet);
        return true;
    }

    boolean bindAttribute(String string2, AttributeActionSet attributeActionSet) {
        if (this.attributeMap.get(string2) != null) {
            return false;
        }
        this.attributeMap.put(string2, attributeActionSet);
        return true;
    }
}

