/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.util;

import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.Flag;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.ValidationDriver;
import com.thaiopensource.validate.prop.rng.RngProperty;
import com.thaiopensource.validate.prop.schematron.SchematronProperty;
import com.thaiopensource.validate.rng.CompactSchemaReader;
import com.thaiopensource.xml.sax.ErrorHandlerImpl;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JingTask
extends Task {
    private File schemaFile;
    private File src;
    private final Vector filesets = new Vector();
    private PropertyMapBuilder properties = new PropertyMapBuilder();
    private boolean failOnError = true;
    private SchemaReader schemaReader = null;

    public JingTask() {
        RngProperty.CHECK_ID_IDREF.add(this.properties);
    }

    public void execute() throws BuildException {
        if (this.schemaFile == null) {
            throw new BuildException("There must be an rngFile or schemaFile attribute", this.getLocation());
        }
        if (this.src == null && this.filesets.size() == 0) {
            throw new BuildException("There must be a file attribute or a fileset child element", this.getLocation());
        }
        LogErrorHandler logErrorHandler = new LogErrorHandler();
        boolean bl = false;
        try {
            ValidationDriver validationDriver = new ValidationDriver(this.properties.toPropertyMap(), this.schemaReader);
            if (!validationDriver.loadSchema(ValidationDriver.fileInputSource(this.schemaFile))) {
                bl = true;
            } else {
                if (this.src != null && !validationDriver.validate(ValidationDriver.fileInputSource(this.src))) {
                    bl = true;
                }
                for (int j = 0; j < this.filesets.size(); ++j) {
                    FileSet fileSet = (FileSet)this.filesets.elementAt(j);
                    DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
                    File file2 = fileSet.getDir(this.getProject());
                    String[] stringArray = directoryScanner.getIncludedFiles();
                    for (int k = 0; k < stringArray.length; ++k) {
                        if (validationDriver.validate(ValidationDriver.fileInputSource(new File(file2, stringArray[k])))) continue;
                        bl = true;
                    }
                }
            }
        }
        catch (SAXException sAXException) {
            bl = true;
            ((ErrorHandlerImpl)logErrorHandler).printException(sAXException);
        }
        catch (IOException iOException) {
            bl = true;
            ((ErrorHandlerImpl)logErrorHandler).printException(iOException);
        }
        if (bl && this.failOnError) {
            throw new BuildException("Validation failed, messages should have been provided.", this.getLocation());
        }
    }

    public void setRngfile(String string2) {
        this.schemaFile = this.getProject().resolveFile(string2);
    }

    public void setSchemafile(String string2) {
        this.schemaFile = this.getProject().resolveFile(string2);
    }

    public void setFile(File file2) {
        this.src = file2;
    }

    public void setCheckid(boolean bl) {
        this.properties.put(RngProperty.CHECK_ID_IDREF, bl ? Flag.PRESENT : null);
    }

    public void setCompactsyntax(boolean bl) {
        this.schemaReader = bl ? CompactSchemaReader.getInstance() : null;
    }

    public void setFeasible(boolean bl) {
        this.properties.put(RngProperty.FEASIBLE, bl ? Flag.PRESENT : null);
    }

    public void setPhase(String string2) {
        SchematronProperty.PHASE.put(this.properties, string2);
    }

    public void setFailonerror(boolean bl) {
        this.failOnError = bl;
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    private class LogErrorHandler
    extends ErrorHandlerImpl {
        int logLevel = 0;

        private LogErrorHandler() {
        }

        public void warning(SAXParseException sAXParseException) throws SAXParseException {
            this.logLevel = 1;
            super.warning(sAXParseException);
        }

        public void error(SAXParseException sAXParseException) {
            this.logLevel = 0;
            super.error(sAXParseException);
        }

        public void printException(Throwable throwable) {
            this.logLevel = 0;
            super.printException(throwable);
        }

        public void print(String string2) {
            JingTask.this.log(string2, this.logLevel);
        }
    }
}

