/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.AbstractPatternFunction;
import com.thaiopensource.relaxng.impl.BinaryPattern;
import com.thaiopensource.relaxng.impl.ChoicePattern;
import com.thaiopensource.relaxng.impl.ElementPattern;
import com.thaiopensource.relaxng.impl.GroupPattern;
import com.thaiopensource.relaxng.impl.InterleavePattern;
import com.thaiopensource.relaxng.impl.OneOrMorePattern;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.ValidatorPatternBuilder;
import com.thaiopensource.xml.util.Name;
import java.util.Hashtable;

class FindElementFunction
extends AbstractPatternFunction {
    private final ValidatorPatternBuilder builder;
    private final Name name;
    private final Hashtable processed = new Hashtable();
    private int specificity = -1;
    private Pattern pattern = null;

    public static Pattern findElement(ValidatorPatternBuilder validatorPatternBuilder, Name name2, Pattern pattern) {
        FindElementFunction findElementFunction = new FindElementFunction(validatorPatternBuilder, name2);
        pattern.apply(findElementFunction);
        if (findElementFunction.pattern == null) {
            return validatorPatternBuilder.makeNotAllowed();
        }
        return findElementFunction.pattern;
    }

    private FindElementFunction(ValidatorPatternBuilder validatorPatternBuilder, Name name2) {
        this.builder = validatorPatternBuilder;
        this.name = name2;
    }

    private boolean haveProcessed(Pattern pattern) {
        if (this.processed.get(pattern) != null) {
            return true;
        }
        this.processed.put(pattern, pattern);
        return false;
    }

    private Object caseBinary(BinaryPattern binaryPattern) {
        if (!this.haveProcessed(binaryPattern)) {
            binaryPattern.getOperand1().apply(this);
            binaryPattern.getOperand2().apply(this);
        }
        return null;
    }

    public Object caseGroup(GroupPattern groupPattern) {
        return this.caseBinary(groupPattern);
    }

    public Object caseInterleave(InterleavePattern interleavePattern) {
        return this.caseBinary(interleavePattern);
    }

    public Object caseChoice(ChoicePattern choicePattern) {
        return this.caseBinary(choicePattern);
    }

    public Object caseOneOrMore(OneOrMorePattern oneOrMorePattern) {
        if (!this.haveProcessed(oneOrMorePattern)) {
            oneOrMorePattern.getOperand().apply(this);
        }
        return null;
    }

    public Object caseElement(ElementPattern elementPattern) {
        if (!this.haveProcessed(elementPattern)) {
            int n = elementPattern.getNameClass().containsSpecificity(this.name);
            if (n > this.specificity) {
                this.specificity = n;
                this.pattern = elementPattern.getContent();
            } else if (n == this.specificity && n != -1) {
                this.pattern = this.builder.makeChoice(this.pattern, elementPattern.getContent());
            }
            elementPattern.getContent().apply(this);
        }
        return null;
    }

    public Object caseOther(Pattern pattern) {
        return null;
    }
}

