/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.datatype.xsd;

import com.thaiopensource.datatype.Datatype2;
import com.thaiopensource.datatype.xsd.Measure;
import com.thaiopensource.datatype.xsd.OrderRelation;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.DatatypeStreamingValidator;
import org.relaxng.datatype.ValidationContext;
import org.relaxng.datatype.helpers.StreamingValidatorImpl;

abstract class DatatypeBase
implements Datatype2 {
    private final int whiteSpace;
    static final int WHITE_SPACE_PRESERVE = 0;
    static final int WHITE_SPACE_REPLACE = 1;
    static final int WHITE_SPACE_COLLAPSE = 2;

    abstract boolean lexicallyAllows(String var1);

    DatatypeBase() {
        this.whiteSpace = 2;
    }

    DatatypeBase(int n) {
        this.whiteSpace = n;
    }

    int getWhiteSpace() {
        return this.whiteSpace;
    }

    public boolean isValid(String string2, ValidationContext validationContext) {
        return this.lexicallyAllows(string2 = this.normalizeWhiteSpace(string2)) && this.allowsValue(string2, validationContext);
    }

    public void checkValid(String string2, ValidationContext validationContext) throws DatatypeException {
        if (!this.isValid(string2, validationContext)) {
            throw new DatatypeException();
        }
    }

    public Object createValue(String string2, ValidationContext validationContext) {
        if (!this.lexicallyAllows(string2 = this.normalizeWhiteSpace(string2))) {
            return null;
        }
        return this.getValue(string2, validationContext);
    }

    final String normalizeWhiteSpace(String string2) {
        switch (this.whiteSpace) {
            case 2: {
                return DatatypeBase.collapseWhiteSpace(string2);
            }
            case 1: {
                return DatatypeBase.replaceWhiteSpace(string2);
            }
        }
        return string2;
    }

    boolean allowsValue(String string2, ValidationContext validationContext) {
        return true;
    }

    abstract Object getValue(String var1, ValidationContext var2);

    OrderRelation getOrderRelation() {
        return null;
    }

    Measure getMeasure() {
        return null;
    }

    private static final String collapseWhiteSpace(String string2) {
        int n = DatatypeBase.collapseStart(string2);
        if (n < 0) {
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer(string2.substring(0, n));
        boolean bl = n == 0 || string2.charAt(n - 1) == ' ';
        int n2 = string2.length();
        while (n < n2) {
            char c = string2.charAt(n);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (bl) break;
                    stringBuffer.append(' ');
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == ' ') {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    private static final int collapseStart(String string2) {
        int n = string2.length();
        block4: for (int j = 0; j < n; ++j) {
            switch (string2.charAt(j)) {
                case ' ': {
                    if (j != 0 && string2.charAt(j - 1) != ' ' && j != n - 1) continue block4;
                    return j;
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    return j;
                }
            }
        }
        return -1;
    }

    private static final String replaceWhiteSpace(String string2) {
        int n = string2.length();
        for (int j = 0; j < n; ++j) {
            switch (string2.charAt(j)) {
                case '\t': 
                case '\n': 
                case '\r': {
                    char[] cArray = string2.toCharArray();
                    cArray[j] = 32;
                    ++j;
                    while (j < n) {
                        switch (cArray[j]) {
                            case '\t': 
                            case '\n': 
                            case '\r': {
                                cArray[j] = 32;
                            }
                        }
                        ++j;
                    }
                    return new String(cArray);
                }
            }
        }
        return string2;
    }

    DatatypeBase getPrimitive() {
        return this;
    }

    public boolean isContextDependent() {
        return false;
    }

    public boolean alwaysValid() {
        return false;
    }

    public int getIdType() {
        return 0;
    }

    public int valueHashCode(Object object) {
        return object.hashCode();
    }

    public boolean sameValue(Object object, Object object2) {
        return object.equals(object2);
    }

    public DatatypeStreamingValidator createStreamingValidator(ValidationContext validationContext) {
        return new StreamingValidatorImpl(this, validationContext);
    }
}

