/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Function;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class NativeLibrary {
    private long handle;
    private final String libraryName;
    private final String libraryPath;
    private final Map functions = new HashMap();
    final int callFlags;
    final Map options;
    private static final Map libraries = new HashMap();
    private static final Map searchPaths = Collections.synchronizedMap(new HashMap());
    private static final List librarySearchPath = new LinkedList();
    static /* synthetic */ Class class$com$sun$jna$LastErrorException;

    private static String functionKey(String name2, int flags) {
        return name2 + "|" + flags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NativeLibrary(String libraryName, String libraryPath, long handle, Map options2) {
        int callingConvention;
        this.libraryName = this.getLibraryName(libraryName);
        this.libraryPath = libraryPath;
        this.handle = handle;
        Object option = options2.get("calling-convention");
        this.callFlags = callingConvention = option instanceof Integer ? (Integer)option : 0;
        this.options = options2;
        if (Platform.isWindows() && "kernel32".equals(this.libraryName.toLowerCase())) {
            Map map = this.functions;
            synchronized (map) {
                Function f = new Function(this, "GetLastError", 1){

                    Object invoke(Object[] args2, Class returnType, boolean b) {
                        return new Integer(Native.getLastError());
                    }
                };
                this.functions.put(NativeLibrary.functionKey("GetLastError", this.callFlags), f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NativeLibrary loadLibrary(String libraryName, Map options2) {
        long handle;
        String libraryPath;
        block23: {
            List customPaths;
            LinkedList<String> searchPath = new LinkedList<String>();
            String webstartPath = Native.getWebStartLibraryPath(libraryName);
            if (webstartPath != null) {
                searchPath.add(webstartPath);
            }
            if ((customPaths = (List)searchPaths.get(libraryName)) != null) {
                List list2 = customPaths;
                synchronized (list2) {
                    searchPath.addAll(0, customPaths);
                }
            }
            searchPath.addAll(NativeLibrary.initPaths("jna.library.path"));
            libraryPath = NativeLibrary.findLibraryPath(libraryName, searchPath);
            handle = 0L;
            try {
                handle = Native.open(libraryPath);
            }
            catch (UnsatisfiedLinkError e) {
                searchPath.addAll(librarySearchPath);
            }
            try {
                if (handle == 0L) {
                    libraryPath = NativeLibrary.findLibraryPath(libraryName, searchPath);
                    handle = Native.open(libraryPath);
                }
            }
            catch (UnsatisfiedLinkError e) {
                if (Platform.isLinux()) {
                    libraryPath = NativeLibrary.matchLibrary(libraryName, searchPath);
                    if (libraryPath != null) {
                        try {
                            handle = Native.open(libraryPath);
                        }
                        catch (UnsatisfiedLinkError e2) {
                            e = e2;
                        }
                    }
                } else if (Platform.isMac() && !libraryName.endsWith(".dylib")) {
                    libraryPath = "/System/Library/Frameworks/" + libraryName + ".framework/" + libraryName;
                    if (new File(libraryPath).exists()) {
                        try {
                            handle = Native.open(libraryPath);
                        }
                        catch (UnsatisfiedLinkError e2) {
                            e = e2;
                        }
                    }
                } else if (Platform.isWindows()) {
                    libraryPath = NativeLibrary.findLibraryPath("lib" + libraryName, searchPath);
                    try {
                        handle = Native.open(libraryPath);
                    }
                    catch (UnsatisfiedLinkError e2) {
                        e = e2;
                    }
                }
                if (handle != 0L) break block23;
                throw new UnsatisfiedLinkError("Unable to load library '" + libraryName + "': " + e.getMessage());
            }
        }
        return new NativeLibrary(libraryName, libraryPath, handle, options2);
    }

    private String getLibraryName(String libraryName) {
        String suffix;
        int suffixStart;
        String simplified = libraryName;
        String BASE = "---";
        String template = NativeLibrary.mapLibraryName("---");
        int prefixEnd = template.indexOf("---");
        if (prefixEnd > 0 && simplified.startsWith(template.substring(0, prefixEnd))) {
            simplified = simplified.substring(prefixEnd);
        }
        if ((suffixStart = simplified.indexOf(suffix = template.substring(prefixEnd + "---".length()))) != -1) {
            simplified = simplified.substring(0, suffixStart);
        }
        return simplified;
    }

    public static final NativeLibrary getInstance(String libraryName) {
        return NativeLibrary.getInstance(libraryName, Collections.EMPTY_MAP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final NativeLibrary getInstance(String libraryName, Map options2) {
        if ((options2 = new HashMap<String, Integer>(options2)).get("calling-convention") == null) {
            options2.put("calling-convention", new Integer(0));
        }
        if (Platform.isLinux() && "c".equals(libraryName)) {
            libraryName = null;
        }
        Map map = libraries;
        synchronized (map) {
            NativeLibrary library2;
            WeakReference<NativeLibrary> ref = (WeakReference<NativeLibrary>)libraries.get(libraryName + options2);
            NativeLibrary nativeLibrary = library2 = ref != null ? (NativeLibrary)ref.get() : null;
            if (library2 == null) {
                library2 = libraryName == null ? new NativeLibrary("<process>", null, Native.open(null), options2) : NativeLibrary.loadLibrary(libraryName, options2);
                ref = new WeakReference<NativeLibrary>(library2);
                libraries.put(library2.getName() + options2, ref);
                File file2 = library2.getFile();
                if (file2 != null) {
                    libraries.put(file2.getAbsolutePath() + options2, ref);
                    libraries.put(file2.getName() + options2, ref);
                }
            }
            return library2;
        }
    }

    public static final synchronized NativeLibrary getProcess() {
        return NativeLibrary.getInstance(null);
    }

    public static final synchronized NativeLibrary getProcess(Map options2) {
        return NativeLibrary.getInstance(null, options2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void addSearchPath(String libraryName, String path2) {
        Map map = searchPaths;
        synchronized (map) {
            List<String> customPaths = (List<String>)searchPaths.get(libraryName);
            if (customPaths == null) {
                customPaths = Collections.synchronizedList(new LinkedList());
                searchPaths.put(libraryName, customPaths);
            }
            customPaths.add(path2);
        }
    }

    public Function getFunction(String functionName) {
        return this.getFunction(functionName, this.callFlags);
    }

    Function getFunction(String name2, Method method2) {
        int flags = this.callFlags;
        Class<?>[] etypes = method2.getExceptionTypes();
        for (int i2 = 0; i2 < etypes.length; ++i2) {
            if (!(class$com$sun$jna$LastErrorException == null ? NativeLibrary.class$("com.sun.jna.LastErrorException") : class$com$sun$jna$LastErrorException).isAssignableFrom(etypes[i2])) continue;
            flags |= 4;
        }
        return this.getFunction(name2, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Function getFunction(String functionName, int callFlags) {
        if (functionName == null) {
            throw new NullPointerException("Function name may not be null");
        }
        Map map = this.functions;
        synchronized (map) {
            String key2 = NativeLibrary.functionKey(functionName, callFlags);
            Function function = (Function)this.functions.get(key2);
            if (function == null) {
                function = new Function(this, functionName, callFlags);
                this.functions.put(key2, function);
            }
            return function;
        }
    }

    public Map getOptions() {
        return this.options;
    }

    public Pointer getGlobalVariableAddress(String symbolName) {
        try {
            return new Pointer(this.getSymbolAddress(symbolName));
        }
        catch (UnsatisfiedLinkError e) {
            throw new UnsatisfiedLinkError("Error looking up '" + symbolName + "': " + e.getMessage());
        }
    }

    long getSymbolAddress(String name2) {
        if (this.handle == 0L) {
            throw new UnsatisfiedLinkError("Library has been unloaded");
        }
        return Native.findSymbol(this.handle, name2);
    }

    public String toString() {
        return "Native Library <" + this.libraryPath + "@" + this.handle + ">";
    }

    public String getName() {
        return this.libraryName;
    }

    public File getFile() {
        if (this.libraryPath == null) {
            return null;
        }
        return new File(this.libraryPath);
    }

    protected void finalize() {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disposeAll() {
        HashSet values2;
        Map map = libraries;
        synchronized (map) {
            values2 = new HashSet(libraries.values());
        }
        Iterator i2 = values2.iterator();
        while (i2.hasNext()) {
            WeakReference ref = (WeakReference)i2.next();
            NativeLibrary lib = (NativeLibrary)ref.get();
            if (lib == null) continue;
            lib.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = libraries;
        synchronized (object) {
            libraries.remove(this.getName() + this.options);
            File file2 = this.getFile();
            if (file2 != null) {
                libraries.remove(file2.getAbsolutePath() + this.options);
                libraries.remove(file2.getName() + this.options);
            }
        }
        object = this;
        synchronized (object) {
            if (this.handle != 0L) {
                Native.close(this.handle);
                this.handle = 0L;
            }
        }
    }

    private static List initPaths(String key2) {
        String value2 = System.getProperty(key2, "");
        if ("".equals(value2)) {
            return Collections.EMPTY_LIST;
        }
        StringTokenizer st = new StringTokenizer(value2, File.pathSeparator);
        ArrayList<String> list2 = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String path2 = st.nextToken();
            if ("".equals(path2)) continue;
            list2.add(path2);
        }
        return list2;
    }

    private static String findLibraryPath(String libName, List searchPath) {
        if (new File(libName).isAbsolute()) {
            return libName;
        }
        String name2 = NativeLibrary.mapLibraryName(libName);
        Iterator it = searchPath.iterator();
        while (it.hasNext()) {
            String path2 = (String)it.next();
            File file2 = new File(path2, name2);
            if (file2.exists()) {
                return file2.getAbsolutePath();
            }
            if (!Platform.isMac() || !name2.endsWith(".dylib") || !(file2 = new File(path2, name2.substring(0, name2.lastIndexOf(".dylib")) + ".jnilib")).exists()) continue;
            return file2.getAbsolutePath();
        }
        return name2;
    }

    private static String mapLibraryName(String libName) {
        if (Platform.isMac()) {
            if (libName.startsWith("lib") && (libName.endsWith(".dylib") || libName.endsWith(".jnilib"))) {
                return libName;
            }
            String name2 = System.mapLibraryName(libName);
            if (name2.endsWith(".jnilib")) {
                return name2.substring(0, name2.lastIndexOf(".jnilib")) + ".dylib";
            }
            return name2;
        }
        if (Platform.isLinux() ? NativeLibrary.isVersionedName(libName) || libName.endsWith(".so") : Platform.isWindows() && (libName.endsWith(".drv") || libName.endsWith(".dll"))) {
            return libName;
        }
        return System.mapLibraryName(libName);
    }

    private static boolean isVersionedName(String name2) {
        int so;
        if (name2.startsWith("lib") && (so = name2.lastIndexOf(".so.")) != -1 && so + 4 < name2.length()) {
            for (int i2 = so + 4; i2 < name2.length(); ++i2) {
                char ch = name2.charAt(i2);
                if (Character.isDigit(ch) || ch == '.') continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static String matchLibrary(final String libName, List searchPath) {
        File lib = new File(libName);
        if (lib.isAbsolute()) {
            searchPath = Arrays.asList(lib.getParent());
        }
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String filename2) {
                return (filename2.startsWith("lib" + libName + ".so") || filename2.startsWith(libName + ".so") && libName.startsWith("lib")) && NativeLibrary.isVersionedName(filename2);
            }
        };
        LinkedList<File> matches = new LinkedList<File>();
        Iterator<String> it = searchPath.iterator();
        while (it.hasNext()) {
            File[] files = new File(it.next()).listFiles(filter);
            if (files == null || files.length <= 0) continue;
            matches.addAll(Arrays.asList(files));
        }
        double bestVersion = -1.0;
        String bestMatch = null;
        Iterator it2 = matches.iterator();
        while (it2.hasNext()) {
            String path2 = ((File)it2.next()).getAbsolutePath();
            String ver2 = path2.substring(path2.lastIndexOf(".so.") + 4);
            double version = NativeLibrary.parseVersion(ver2);
            if (!(version > bestVersion)) continue;
            bestVersion = version;
            bestMatch = path2;
        }
        return bestMatch;
    }

    static double parseVersion(String ver2) {
        double v = 0.0;
        double divisor = 1.0;
        int dot = ver2.indexOf(".");
        while (ver2 != null) {
            String num;
            if (dot != -1) {
                num = ver2.substring(0, dot);
                ver2 = ver2.substring(dot + 1);
                dot = ver2.indexOf(".");
            } else {
                num = ver2;
                ver2 = null;
            }
            try {
                v += (double)Integer.parseInt(num) / divisor;
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
            divisor *= 100.0;
        }
        return v;
    }

    static {
        if (Native.POINTER_SIZE == 0) {
            throw new Error("Native library not initialized");
        }
        String webstartPath = Native.getWebStartLibraryPath("jnidispatch");
        if (webstartPath != null) {
            librarySearchPath.add(webstartPath);
        }
        if (System.getProperty("jna.platform.library.path") == null && !Platform.isWindows()) {
            String platformPath = "";
            String sep = "";
            String archPath = "";
            if (Platform.isLinux() || Platform.isSolaris() || Platform.isFreeBSD()) {
                archPath = (Platform.isSolaris() ? "/" : "") + Pointer.SIZE * 8;
            }
            String[] paths = new String[]{"/usr/lib" + archPath, "/lib" + archPath, "/usr/lib", "/lib"};
            if (Platform.isLinux() && Pointer.SIZE == 8) {
                paths = new String[]{"/usr/lib" + archPath, "/lib" + archPath};
            }
            for (int i2 = 0; i2 < paths.length; ++i2) {
                File dir = new File(paths[i2]);
                if (!dir.exists() || !dir.isDirectory()) continue;
                platformPath = platformPath + sep + paths[i2];
                sep = File.pathSeparator;
            }
            if (!"".equals(platformPath)) {
                System.setProperty("jna.platform.library.path", platformPath);
            }
        }
        librarySearchPath.addAll(NativeLibrary.initPaths("jna.platform.library.path"));
    }
}

