/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

public class Memory
extends Pointer {
    private static Map buffers = Collections.synchronizedMap(new WeakHashMap());
    protected long size;

    public static void purge() {
        buffers.size();
    }

    public Memory(long size2) {
        this.size = size2;
        if (size2 <= 0L) {
            throw new IllegalArgumentException("Allocation size must be greater than zero");
        }
        this.peer = Memory.malloc(size2);
        if (this.peer == 0L) {
            throw new OutOfMemoryError("Cannot allocate " + size2 + " bytes");
        }
    }

    protected Memory() {
    }

    public Pointer share(long offset2) {
        return this.share(offset2, this.getSize() - offset2);
    }

    public Pointer share(long offset2, long sz) {
        if (offset2 == 0L && sz == this.getSize()) {
            return this;
        }
        this.boundsCheck(offset2, sz);
        return new SharedMemory(offset2);
    }

    public Memory align(int byteBoundary) {
        if (byteBoundary <= 0) {
            throw new IllegalArgumentException("Byte boundary must be positive: " + byteBoundary);
        }
        for (int i2 = 0; i2 < 32; ++i2) {
            if (byteBoundary != 1 << i2) continue;
            long mask = (long)byteBoundary - 1L ^ 0xFFFFFFFFFFFFFFFFL;
            if ((this.peer & mask) != this.peer) {
                long newPeer = this.peer + (long)byteBoundary - 1L & mask;
                long newSize = this.peer + this.size - newPeer;
                if (newSize <= 0L) {
                    throw new IllegalArgumentException("Insufficient memory to align to the requested boundary");
                }
                return (Memory)this.share(newPeer - this.peer, newSize);
            }
            return this;
        }
        throw new IllegalArgumentException("Byte boundary must be a power of two");
    }

    protected void finalize() {
        this.dispose();
    }

    protected synchronized void dispose() {
        Memory.free(this.peer);
        this.peer = 0L;
    }

    public void clear() {
        this.clear(this.size);
    }

    public boolean isValid() {
        return this.valid();
    }

    public boolean valid() {
        return this.peer != 0L;
    }

    public long size() {
        return this.size;
    }

    public long getSize() {
        return this.size();
    }

    protected void boundsCheck(long off, long sz) {
        if (off < 0L) {
            throw new IndexOutOfBoundsException("Invalid offset: " + off);
        }
        if (off + sz > this.size) {
            String msg = "Bounds exceeds available space : size=" + this.size + ", offset=" + (off + sz);
            throw new IndexOutOfBoundsException(msg);
        }
    }

    public void read(long bOff, byte[] buf, int index2, int length2) {
        this.boundsCheck(bOff, (long)length2 * 1L);
        super.read(bOff, buf, index2, length2);
    }

    public void read(long bOff, short[] buf, int index2, int length2) {
        this.boundsCheck(bOff, (long)length2 * 2L);
        super.read(bOff, buf, index2, length2);
    }

    public void read(long bOff, char[] buf, int index2, int length2) {
        this.boundsCheck(bOff, (long)length2 * 2L);
        super.read(bOff, buf, index2, length2);
    }

    public void read(long bOff, int[] buf, int index2, int length2) {
        this.boundsCheck(bOff, (long)length2 * 4L);
        super.read(bOff, buf, index2, length2);
    }

    public void read(long bOff, long[] buf, int index2, int length2) {
        this.boundsCheck(bOff, (long)length2 * 8L);
        super.read(bOff, buf, index2, length2);
    }

    public void read(long bOff, float[] buf, int index2, int length2) {
        this.boundsCheck(bOff, (long)length2 * 4L);
        super.read(bOff, buf, index2, length2);
    }

    public void read(long bOff, double[] buf, int index2, int length2) {
        this.boundsCheck(bOff, (long)length2 * 8L);
        super.read(bOff, buf, index2, length2);
    }

    public void write(long bOff, byte[] buf, int index2, int length2) {
        this.boundsCheck(bOff, (long)length2 * 1L);
        super.write(bOff, buf, index2, length2);
    }

    public void write(long bOff, short[] buf, int index2, int length2) {
        this.boundsCheck(bOff, (long)length2 * 2L);
        super.write(bOff, buf, index2, length2);
    }

    public void write(long bOff, char[] buf, int index2, int length2) {
        this.boundsCheck(bOff, (long)length2 * 2L);
        super.write(bOff, buf, index2, length2);
    }

    public void write(long bOff, int[] buf, int index2, int length2) {
        this.boundsCheck(bOff, (long)length2 * 4L);
        super.write(bOff, buf, index2, length2);
    }

    public void write(long bOff, long[] buf, int index2, int length2) {
        this.boundsCheck(bOff, (long)length2 * 8L);
        super.write(bOff, buf, index2, length2);
    }

    public void write(long bOff, float[] buf, int index2, int length2) {
        this.boundsCheck(bOff, (long)length2 * 4L);
        super.write(bOff, buf, index2, length2);
    }

    public void write(long bOff, double[] buf, int index2, int length2) {
        this.boundsCheck(bOff, (long)length2 * 8L);
        super.write(bOff, buf, index2, length2);
    }

    public byte getByte(long offset2) {
        this.boundsCheck(offset2, 1L);
        return super.getByte(offset2);
    }

    public char getChar(long offset2) {
        this.boundsCheck(offset2, 1L);
        return super.getChar(offset2);
    }

    public short getShort(long offset2) {
        this.boundsCheck(offset2, 2L);
        return super.getShort(offset2);
    }

    public int getInt(long offset2) {
        this.boundsCheck(offset2, 4L);
        return super.getInt(offset2);
    }

    public long getLong(long offset2) {
        this.boundsCheck(offset2, 8L);
        return super.getLong(offset2);
    }

    public float getFloat(long offset2) {
        this.boundsCheck(offset2, 4L);
        return super.getFloat(offset2);
    }

    public double getDouble(long offset2) {
        this.boundsCheck(offset2, 8L);
        return super.getDouble(offset2);
    }

    public Pointer getPointer(long offset2) {
        this.boundsCheck(offset2, Pointer.SIZE);
        return super.getPointer(offset2);
    }

    public ByteBuffer getByteBuffer(long offset2, long length2) {
        this.boundsCheck(offset2, length2);
        ByteBuffer b = super.getByteBuffer(offset2, length2);
        buffers.put(b, this);
        return b;
    }

    public String getString(long offset2, boolean wide) {
        this.boundsCheck(offset2, 0L);
        return super.getString(offset2, wide);
    }

    public void setByte(long offset2, byte value2) {
        this.boundsCheck(offset2, 1L);
        super.setByte(offset2, value2);
    }

    public void setChar(long offset2, char value2) {
        this.boundsCheck(offset2, Native.WCHAR_SIZE);
        super.setChar(offset2, value2);
    }

    public void setShort(long offset2, short value2) {
        this.boundsCheck(offset2, 2L);
        super.setShort(offset2, value2);
    }

    public void setInt(long offset2, int value2) {
        this.boundsCheck(offset2, 4L);
        super.setInt(offset2, value2);
    }

    public void setLong(long offset2, long value2) {
        this.boundsCheck(offset2, 8L);
        super.setLong(offset2, value2);
    }

    public void setFloat(long offset2, float value2) {
        this.boundsCheck(offset2, 4L);
        super.setFloat(offset2, value2);
    }

    public void setDouble(long offset2, double value2) {
        this.boundsCheck(offset2, 8L);
        super.setDouble(offset2, value2);
    }

    public void setPointer(long offset2, Pointer value2) {
        this.boundsCheck(offset2, Pointer.SIZE);
        super.setPointer(offset2, value2);
    }

    public void setString(long offset2, String value2, boolean wide) {
        if (wide) {
            this.boundsCheck(offset2, ((long)value2.length() + 1L) * (long)Native.WCHAR_SIZE);
        } else {
            this.boundsCheck(offset2, (long)value2.getBytes().length + 1L);
        }
        super.setString(offset2, value2, wide);
    }

    public String toString() {
        return "allocated@0x" + Long.toHexString(this.peer) + " (" + this.size + " bytes)";
    }

    protected static void free(long p2) {
        Native.free(p2);
    }

    protected static long malloc(long size2) {
        return Native.malloc(size2);
    }

    private class SharedMemory
    extends Memory {
        public SharedMemory(long offset2) {
            this.size = Memory.this.size - offset2;
            this.peer = Memory.this.peer + offset2;
        }

        protected void finalize() {
        }

        protected void boundsCheck(long off, long sz) {
            Memory.this.boundsCheck(this.peer - Memory.this.peer + off, sz);
        }

        public String toString() {
            return super.toString() + " (shared from " + Memory.this.toString() + ")";
        }
    }
}

