/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.shape.impl;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.distance.DistanceUtils;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.SpatialRelation;
import com.spatial4j.core.shape.impl.PointImpl;

public class RectangleImpl
implements Rectangle {
    private final SpatialContext ctx;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;

    public RectangleImpl(double minX, double maxX, double minY, double maxY, SpatialContext ctx) {
        this.ctx = ctx;
        this.reset(minX, maxX, minY, maxY);
    }

    public RectangleImpl(Point lowerLeft, Point upperRight, SpatialContext ctx) {
        this(lowerLeft.getX(), upperRight.getX(), lowerLeft.getY(), upperRight.getY(), ctx);
    }

    public RectangleImpl(Rectangle r, SpatialContext ctx) {
        this(r.getMinX(), r.getMaxX(), r.getMinY(), r.getMaxY(), ctx);
    }

    @Override
    public void reset(double minX, double maxX, double minY, double maxY) {
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        assert (minY <= maxY);
    }

    @Override
    public boolean hasArea() {
        return this.maxX != this.minX && this.maxY != this.minY;
    }

    @Override
    public double getArea(SpatialContext ctx) {
        if (ctx == null) {
            return this.getWidth() * this.getHeight();
        }
        return ctx.getDistCalc().area(this);
    }

    @Override
    public boolean getCrossesDateLine() {
        return this.minX > this.maxX;
    }

    @Override
    public double getHeight() {
        return this.maxY - this.minY;
    }

    @Override
    public double getWidth() {
        double w = this.maxX - this.minX;
        if (w < 0.0) assert ((w += 360.0) >= 0.0);
        return w;
    }

    @Override
    public double getMaxX() {
        return this.maxX;
    }

    @Override
    public double getMaxY() {
        return this.maxY;
    }

    @Override
    public double getMinX() {
        return this.minX;
    }

    @Override
    public double getMinY() {
        return this.minY;
    }

    @Override
    public Rectangle getBoundingBox() {
        return this;
    }

    @Override
    public SpatialRelation relate(Shape other) {
        if (other instanceof Point) {
            return this.relate((Point)other);
        }
        if (other instanceof Rectangle) {
            return this.relate((Rectangle)other);
        }
        return other.relate(this).transpose();
    }

    public SpatialRelation relate(Point point) {
        if (point.getY() > this.getMaxY() || point.getY() < this.getMinY()) {
            return SpatialRelation.DISJOINT;
        }
        double minX = this.minX;
        double maxX = this.maxX;
        double pX = point.getX();
        if (this.ctx.isGeo()) {
            double rawWidth = maxX - minX;
            if (rawWidth < 0.0) {
                maxX = minX + (rawWidth + 360.0);
            }
            if (pX < minX) {
                pX += 360.0;
            } else if (pX > maxX) {
                pX -= 360.0;
            } else {
                return SpatialRelation.CONTAINS;
            }
        }
        if (pX < minX || pX > maxX) {
            return SpatialRelation.DISJOINT;
        }
        return SpatialRelation.CONTAINS;
    }

    public SpatialRelation relate(Rectangle rect2) {
        SpatialRelation yIntersect = this.relateYRange(rect2.getMinY(), rect2.getMaxY());
        if (yIntersect == SpatialRelation.DISJOINT) {
            return SpatialRelation.DISJOINT;
        }
        SpatialRelation xIntersect = this.relateXRange(rect2.getMinX(), rect2.getMaxX());
        if (xIntersect == SpatialRelation.DISJOINT) {
            return SpatialRelation.DISJOINT;
        }
        if (xIntersect == yIntersect) {
            return xIntersect;
        }
        if (this.getMinX() == rect2.getMinX() && this.getMaxX() == rect2.getMaxX()) {
            return yIntersect;
        }
        if (this.getMinY() == rect2.getMinY() && this.getMaxY() == rect2.getMaxY()) {
            return xIntersect;
        }
        return SpatialRelation.INTERSECTS;
    }

    private static SpatialRelation relate_range(double int_min, double int_max, double ext_min, double ext_max) {
        if (ext_min > int_max || ext_max < int_min) {
            return SpatialRelation.DISJOINT;
        }
        if (ext_min >= int_min && ext_max <= int_max) {
            return SpatialRelation.CONTAINS;
        }
        if (ext_min <= int_min && ext_max >= int_max) {
            return SpatialRelation.WITHIN;
        }
        return SpatialRelation.INTERSECTS;
    }

    @Override
    public SpatialRelation relateYRange(double ext_minY, double ext_maxY) {
        return RectangleImpl.relate_range(this.minY, this.maxY, ext_minY, ext_maxY);
    }

    @Override
    public SpatialRelation relateXRange(double ext_minX, double ext_maxX) {
        double minX = this.minX;
        double maxX = this.maxX;
        if (this.ctx.isGeo()) {
            double ext_rawWidth;
            double rawWidth = maxX - minX;
            if (rawWidth == 360.0) {
                return SpatialRelation.CONTAINS;
            }
            if (rawWidth < 0.0) {
                maxX = minX + (rawWidth + 360.0);
            }
            if ((ext_rawWidth = ext_maxX - ext_minX) == 360.0) {
                return SpatialRelation.WITHIN;
            }
            if (ext_rawWidth < 0.0) {
                ext_maxX = ext_minX + (ext_rawWidth + 360.0);
            }
            if (maxX < ext_minX) {
                minX += 360.0;
                maxX += 360.0;
            } else if (ext_maxX < minX) {
                ext_minX += 360.0;
                ext_maxX += 360.0;
            }
        }
        return RectangleImpl.relate_range(minX, maxX, ext_minX, ext_maxX);
    }

    public String toString() {
        return "Rect(minX=" + this.minX + ",maxX=" + this.maxX + ",minY=" + this.minY + ",maxY=" + this.maxY + ")";
    }

    @Override
    public Point getCenter() {
        double y = this.getHeight() / 2.0 + this.minY;
        double x = this.getWidth() / 2.0 + this.minX;
        if (this.minX > this.maxX) {
            x = DistanceUtils.normLonDEG(x);
        }
        return new PointImpl(x, y, this.ctx);
    }

    public boolean equals(Object obj) {
        return RectangleImpl.equals(this, obj);
    }

    public static boolean equals(Rectangle thiz, Object o) {
        assert (thiz != null);
        if (thiz == o) {
            return true;
        }
        if (!(o instanceof Rectangle)) {
            return false;
        }
        RectangleImpl rectangle = (RectangleImpl)o;
        if (Double.compare(rectangle.getMaxX(), thiz.getMaxX()) != 0) {
            return false;
        }
        if (Double.compare(rectangle.getMaxY(), thiz.getMaxY()) != 0) {
            return false;
        }
        if (Double.compare(rectangle.getMinX(), thiz.getMinX()) != 0) {
            return false;
        }
        return Double.compare(rectangle.getMinY(), thiz.getMinY()) == 0;
    }

    public int hashCode() {
        return RectangleImpl.hashCode(this);
    }

    public static int hashCode(Rectangle thiz) {
        long temp = thiz.getMinX() != 0.0 ? Double.doubleToLongBits(thiz.getMinX()) : 0L;
        int result2 = (int)(temp ^ temp >>> 32);
        temp = thiz.getMaxX() != 0.0 ? Double.doubleToLongBits(thiz.getMaxX()) : 0L;
        result2 = 31 * result2 + (int)(temp ^ temp >>> 32);
        temp = thiz.getMinY() != 0.0 ? Double.doubleToLongBits(thiz.getMinY()) : 0L;
        result2 = 31 * result2 + (int)(temp ^ temp >>> 32);
        temp = thiz.getMaxY() != 0.0 ? Double.doubleToLongBits(thiz.getMaxY()) : 0L;
        result2 = 31 * result2 + (int)(temp ^ temp >>> 32);
        return result2;
    }
}

