/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.context;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.distance.CartesianDistCalc;
import com.spatial4j.core.distance.DistanceCalculator;
import com.spatial4j.core.distance.GeodesicSphereDistCalc;
import com.spatial4j.core.shape.Rectangle;
import java.util.Map;

public class SpatialContextFactory {
    protected Map<String, String> args;
    protected ClassLoader classLoader;
    protected boolean geo = true;
    protected DistanceCalculator calculator;
    protected Rectangle worldBounds;

    public static SpatialContext makeSpatialContext(Map<String, String> args2, ClassLoader classLoader) {
        SpatialContextFactory instance;
        String cname = args2.get("spatialContextFactory");
        if (cname == null) {
            cname = System.getProperty("SpatialContextFactory");
        }
        if (cname == null) {
            instance = new SpatialContextFactory();
        } else {
            try {
                Class<?> c = classLoader.loadClass(cname);
                instance = (SpatialContextFactory)c.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        instance.init(args2, classLoader);
        return instance.newSpatialContext();
    }

    protected SpatialContextFactory() {
    }

    protected void init(Map<String, String> args2, ClassLoader classLoader) {
        this.args = args2;
        this.classLoader = classLoader;
        this.initUnits();
        this.initCalculator();
        this.initWorldBounds();
    }

    protected void initUnits() {
        String geoStr = this.args.get("geo");
        if (geoStr != null) {
            this.geo = Boolean.valueOf(geoStr);
        }
    }

    protected void initCalculator() {
        String calcStr = this.args.get("distCalculator");
        if (calcStr == null) {
            return;
        }
        if (calcStr.equalsIgnoreCase("haversine")) {
            this.calculator = new GeodesicSphereDistCalc.Haversine();
        } else if (calcStr.equalsIgnoreCase("lawOfCosines")) {
            this.calculator = new GeodesicSphereDistCalc.LawOfCosines();
        } else if (calcStr.equalsIgnoreCase("vincentySphere")) {
            this.calculator = new GeodesicSphereDistCalc.Vincenty();
        } else if (calcStr.equalsIgnoreCase("cartesian")) {
            this.calculator = new CartesianDistCalc();
        } else if (calcStr.equalsIgnoreCase("cartesian^2")) {
            this.calculator = new CartesianDistCalc(true);
        } else {
            throw new RuntimeException("Unknown calculator: " + calcStr);
        }
    }

    protected void initWorldBounds() {
        String worldBoundsStr = this.args.get("worldBounds");
        if (worldBoundsStr == null) {
            return;
        }
        SpatialContext simpleCtx = new SpatialContext(this.geo, this.calculator, null);
        this.worldBounds = (Rectangle)simpleCtx.readShape(worldBoundsStr);
    }

    protected SpatialContext newSpatialContext() {
        return new SpatialContext(this.geo, this.calculator, this.worldBounds);
    }
}

