/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.ExceptionInterceptor;
import com.mysql.jdbc.Messages;
import com.mysql.jdbc.MySQLConnection;
import com.mysql.jdbc.SQLError;
import com.mysql.jdbc.SingleByteCharsetConverter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtils {
    private static final int BYTE_RANGE = 256;
    private static byte[] allBytes = new byte[256];
    private static char[] byteToChars = new char[256];
    private static Method toPlainStringMethod;
    static final int WILD_COMPARE_MATCH_NO_WILD = 0;
    static final int WILD_COMPARE_MATCH_WITH_WILD = 1;
    static final int WILD_COMPARE_NO_MATCH = -1;
    private static final ConcurrentHashMap<String, Charset> charsetsByAlias;
    private static final String platformEncoding;
    private static final String VALID_ID_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIGKLMNOPQRSTUVWXYZ0123456789$_#@";

    static Charset findCharset(String alias2) throws UnsupportedEncodingException {
        try {
            Charset cs = charsetsByAlias.get(alias2);
            if (cs == null) {
                cs = Charset.forName(alias2);
                charsetsByAlias.putIfAbsent(alias2, cs);
            }
            return cs;
        }
        catch (UnsupportedCharsetException uce) {
            throw new UnsupportedEncodingException(alias2);
        }
        catch (IllegalCharsetNameException icne) {
            throw new UnsupportedEncodingException(alias2);
        }
        catch (IllegalArgumentException iae) {
            throw new UnsupportedEncodingException(alias2);
        }
    }

    public static String consistentToString(BigDecimal decimal) {
        if (decimal == null) {
            return null;
        }
        if (toPlainStringMethod != null) {
            try {
                return (String)toPlainStringMethod.invoke((Object)decimal, (Object[])null);
            }
            catch (InvocationTargetException invokeEx) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return decimal.toString();
    }

    public static final String dumpAsHex(byte[] byteBuffer, int length2) {
        int i2;
        StringBuffer outputBuf = new StringBuffer(length2 * 4);
        int p2 = 0;
        int rows = length2 / 8;
        for (int i3 = 0; i3 < rows && p2 < length2; ++i3) {
            int j;
            int ptemp = p2;
            for (j = 0; j < 8; ++j) {
                String hexVal = Integer.toHexString(byteBuffer[ptemp] & 0xFF);
                if (hexVal.length() == 1) {
                    hexVal = "0" + hexVal;
                }
                outputBuf.append(hexVal + " ");
                ++ptemp;
            }
            outputBuf.append("    ");
            for (j = 0; j < 8; ++j) {
                int b = 0xFF & byteBuffer[p2];
                if (b > 32 && b < 127) {
                    outputBuf.append((char)b + " ");
                } else {
                    outputBuf.append(". ");
                }
                ++p2;
            }
            outputBuf.append("\n");
        }
        int n = 0;
        for (i2 = p2; i2 < length2; ++i2) {
            String hexVal = Integer.toHexString(byteBuffer[i2] & 0xFF);
            if (hexVal.length() == 1) {
                hexVal = "0" + hexVal;
            }
            outputBuf.append(hexVal + " ");
            ++n;
        }
        for (i2 = n; i2 < 8; ++i2) {
            outputBuf.append("   ");
        }
        outputBuf.append("    ");
        for (i2 = p2; i2 < length2; ++i2) {
            int b = 0xFF & byteBuffer[i2];
            if (b > 32 && b < 127) {
                outputBuf.append((char)b + " ");
                continue;
            }
            outputBuf.append(". ");
        }
        outputBuf.append("\n");
        return outputBuf.toString();
    }

    private static boolean endsWith(byte[] dataFrom, String suffix) {
        for (int i2 = 1; i2 <= suffix.length(); ++i2) {
            int dfOffset = dataFrom.length - i2;
            int suffixOffset = suffix.length() - i2;
            if (dataFrom[dfOffset] == suffix.charAt(suffixOffset)) continue;
            return false;
        }
        return true;
    }

    public static byte[] escapeEasternUnicodeByteStream(byte[] origBytes, String origString, int offset2, int length2) {
        if (origBytes == null || origBytes.length == 0) {
            return origBytes;
        }
        int bytesLen = origBytes.length;
        int bufIndex = 0;
        int strIndex = 0;
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream(bytesLen);
        while (true) {
            if (origString.charAt(strIndex) == '\\') {
                bytesOut.write(origBytes[bufIndex++]);
            } else {
                int hiByte;
                int loByte = origBytes[bufIndex];
                if (loByte < 0) {
                    loByte += 256;
                }
                bytesOut.write(loByte);
                if (loByte >= 128) {
                    if (bufIndex < bytesLen - 1) {
                        hiByte = origBytes[bufIndex + 1];
                        if (hiByte < 0) {
                            hiByte += 256;
                        }
                        bytesOut.write(hiByte);
                        ++bufIndex;
                        if (hiByte == 92) {
                            bytesOut.write(hiByte);
                        }
                    }
                } else if (loByte == 92 && bufIndex < bytesLen - 1) {
                    hiByte = origBytes[bufIndex + 1];
                    if (hiByte < 0) {
                        hiByte += 256;
                    }
                    if (hiByte == 98) {
                        bytesOut.write(92);
                        bytesOut.write(98);
                        ++bufIndex;
                    }
                }
                ++bufIndex;
            }
            if (bufIndex >= bytesLen) break;
            ++strIndex;
        }
        return bytesOut.toByteArray();
    }

    public static char firstNonWsCharUc(String searchIn) {
        return StringUtils.firstNonWsCharUc(searchIn, 0);
    }

    public static char firstNonWsCharUc(String searchIn, int startAt) {
        if (searchIn == null) {
            return '\u0000';
        }
        int length2 = searchIn.length();
        for (int i2 = startAt; i2 < length2; ++i2) {
            char c = searchIn.charAt(i2);
            if (Character.isWhitespace(c)) continue;
            return Character.toUpperCase(c);
        }
        return '\u0000';
    }

    public static char firstAlphaCharUc(String searchIn, int startAt) {
        if (searchIn == null) {
            return '\u0000';
        }
        int length2 = searchIn.length();
        for (int i2 = startAt; i2 < length2; ++i2) {
            char c = searchIn.charAt(i2);
            if (!Character.isLetter(c)) continue;
            return Character.toUpperCase(c);
        }
        return '\u0000';
    }

    public static final String fixDecimalExponent(String dString) {
        char maybeMinusChar;
        int ePos = dString.indexOf("E");
        if (ePos == -1) {
            ePos = dString.indexOf("e");
        }
        if (ePos != -1 && dString.length() > ePos + 1 && (maybeMinusChar = dString.charAt(ePos + 1)) != '-' && maybeMinusChar != '+') {
            StringBuffer buf = new StringBuffer(dString.length() + 1);
            buf.append(dString.substring(0, ePos + 1));
            buf.append('+');
            buf.append(dString.substring(ePos + 1, dString.length()));
            dString = buf.toString();
        }
        return dString;
    }

    public static final byte[] getBytes(char[] c, SingleByteCharsetConverter converter, String encoding2, String serverEncoding, boolean parserKnowsUnicode, ExceptionInterceptor exceptionInterceptor) throws SQLException {
        try {
            byte[] b = null;
            if (converter != null) {
                b = converter.toBytes(c);
            } else if (encoding2 == null) {
                b = new String(c).getBytes();
            } else {
                String s2 = new String(c);
                b = s2.getBytes(encoding2);
                if (!parserKnowsUnicode && (encoding2.equalsIgnoreCase("SJIS") || encoding2.equalsIgnoreCase("BIG5") || encoding2.equalsIgnoreCase("GBK")) && !encoding2.equalsIgnoreCase(serverEncoding)) {
                    b = StringUtils.escapeEasternUnicodeByteStream(b, s2, 0, s2.length());
                }
            }
            return b;
        }
        catch (UnsupportedEncodingException uee) {
            throw SQLError.createSQLException(Messages.getString("StringUtils.5") + encoding2 + Messages.getString("StringUtils.6"), "S1009", exceptionInterceptor);
        }
    }

    public static final byte[] getBytes(char[] c, SingleByteCharsetConverter converter, String encoding2, String serverEncoding, int offset2, int length2, boolean parserKnowsUnicode, ExceptionInterceptor exceptionInterceptor) throws SQLException {
        try {
            byte[] b = null;
            if (converter != null) {
                b = converter.toBytes(c, offset2, length2);
            } else if (encoding2 == null) {
                byte[] temp = new String(c, offset2, length2).getBytes();
                length2 = temp.length;
                b = new byte[length2];
                System.arraycopy(temp, 0, b, 0, length2);
            } else {
                String s2 = new String(c, offset2, length2);
                byte[] temp = s2.getBytes(encoding2);
                length2 = temp.length;
                b = new byte[length2];
                System.arraycopy(temp, 0, b, 0, length2);
                if (!parserKnowsUnicode && (encoding2.equalsIgnoreCase("SJIS") || encoding2.equalsIgnoreCase("BIG5") || encoding2.equalsIgnoreCase("GBK")) && !encoding2.equalsIgnoreCase(serverEncoding)) {
                    b = StringUtils.escapeEasternUnicodeByteStream(b, s2, offset2, length2);
                }
            }
            return b;
        }
        catch (UnsupportedEncodingException uee) {
            throw SQLError.createSQLException(Messages.getString("StringUtils.10") + encoding2 + Messages.getString("StringUtils.11"), "S1009", exceptionInterceptor);
        }
    }

    public static final byte[] getBytes(char[] c, String encoding2, String serverEncoding, boolean parserKnowsUnicode, MySQLConnection conn, ExceptionInterceptor exceptionInterceptor) throws SQLException {
        try {
            SingleByteCharsetConverter converter = null;
            converter = conn != null ? conn.getCharsetConverter(encoding2) : SingleByteCharsetConverter.getInstance(encoding2, null);
            return StringUtils.getBytes(c, converter, encoding2, serverEncoding, parserKnowsUnicode, exceptionInterceptor);
        }
        catch (UnsupportedEncodingException uee) {
            throw SQLError.createSQLException(Messages.getString("StringUtils.0") + encoding2 + Messages.getString("StringUtils.1"), "S1009", exceptionInterceptor);
        }
    }

    public static final byte[] getBytes(String s2, SingleByteCharsetConverter converter, String encoding2, String serverEncoding, boolean parserKnowsUnicode, ExceptionInterceptor exceptionInterceptor) throws SQLException {
        try {
            byte[] b = null;
            if (converter != null) {
                b = converter.toBytes(s2);
            } else if (encoding2 == null) {
                b = s2.getBytes();
            } else {
                b = s2.getBytes(encoding2);
                if (!parserKnowsUnicode && (encoding2.equalsIgnoreCase("SJIS") || encoding2.equalsIgnoreCase("BIG5") || encoding2.equalsIgnoreCase("GBK")) && !encoding2.equalsIgnoreCase(serverEncoding)) {
                    b = StringUtils.escapeEasternUnicodeByteStream(b, s2, 0, s2.length());
                }
            }
            return b;
        }
        catch (UnsupportedEncodingException uee) {
            throw SQLError.createSQLException(Messages.getString("StringUtils.5") + encoding2 + Messages.getString("StringUtils.6"), "S1009", exceptionInterceptor);
        }
    }

    public static final byte[] getBytesWrapped(String s2, char beginWrap, char endWrap, SingleByteCharsetConverter converter, String encoding2, String serverEncoding, boolean parserKnowsUnicode, ExceptionInterceptor exceptionInterceptor) throws SQLException {
        try {
            byte[] b = null;
            if (converter != null) {
                b = converter.toBytesWrapped(s2, beginWrap, endWrap);
            } else if (encoding2 == null) {
                StringBuffer buf = new StringBuffer(s2.length() + 2);
                buf.append(beginWrap);
                buf.append(s2);
                buf.append(endWrap);
                b = buf.toString().getBytes();
            } else {
                StringBuffer buf = new StringBuffer(s2.length() + 2);
                buf.append(beginWrap);
                buf.append(s2);
                buf.append(endWrap);
                s2 = buf.toString();
                b = s2.getBytes(encoding2);
                if (!parserKnowsUnicode && (encoding2.equalsIgnoreCase("SJIS") || encoding2.equalsIgnoreCase("BIG5") || encoding2.equalsIgnoreCase("GBK")) && !encoding2.equalsIgnoreCase(serverEncoding)) {
                    b = StringUtils.escapeEasternUnicodeByteStream(b, s2, 0, s2.length());
                }
            }
            return b;
        }
        catch (UnsupportedEncodingException uee) {
            throw SQLError.createSQLException(Messages.getString("StringUtils.5") + encoding2 + Messages.getString("StringUtils.6"), "S1009", exceptionInterceptor);
        }
    }

    public static final byte[] getBytes(String s2, SingleByteCharsetConverter converter, String encoding2, String serverEncoding, int offset2, int length2, boolean parserKnowsUnicode, ExceptionInterceptor exceptionInterceptor) throws SQLException {
        try {
            byte[] b = null;
            if (converter != null) {
                b = converter.toBytes(s2, offset2, length2);
            } else if (encoding2 == null) {
                byte[] temp = s2.substring(offset2, offset2 + length2).getBytes();
                length2 = temp.length;
                b = new byte[length2];
                System.arraycopy(temp, 0, b, 0, length2);
            } else {
                byte[] temp = s2.substring(offset2, offset2 + length2).getBytes(encoding2);
                length2 = temp.length;
                b = new byte[length2];
                System.arraycopy(temp, 0, b, 0, length2);
                if (!parserKnowsUnicode && (encoding2.equalsIgnoreCase("SJIS") || encoding2.equalsIgnoreCase("BIG5") || encoding2.equalsIgnoreCase("GBK")) && !encoding2.equalsIgnoreCase(serverEncoding)) {
                    b = StringUtils.escapeEasternUnicodeByteStream(b, s2, offset2, length2);
                }
            }
            return b;
        }
        catch (UnsupportedEncodingException uee) {
            throw SQLError.createSQLException(Messages.getString("StringUtils.10") + encoding2 + Messages.getString("StringUtils.11"), "S1009", exceptionInterceptor);
        }
    }

    public static final byte[] getBytes(String s2, String encoding2, String serverEncoding, boolean parserKnowsUnicode, MySQLConnection conn, ExceptionInterceptor exceptionInterceptor) throws SQLException {
        try {
            SingleByteCharsetConverter converter = null;
            converter = conn != null ? conn.getCharsetConverter(encoding2) : SingleByteCharsetConverter.getInstance(encoding2, null);
            return StringUtils.getBytes(s2, converter, encoding2, serverEncoding, parserKnowsUnicode, exceptionInterceptor);
        }
        catch (UnsupportedEncodingException uee) {
            throw SQLError.createSQLException(Messages.getString("StringUtils.0") + encoding2 + Messages.getString("StringUtils.1"), "S1009", exceptionInterceptor);
        }
    }

    public static int getInt(byte[] buf, int offset2, int endPos) throws NumberFormatException {
        int s2;
        char base = '\n';
        for (s2 = offset2; Character.isWhitespace((char)buf[s2]) && s2 < endPos; ++s2) {
        }
        if (s2 == endPos) {
            throw new NumberFormatException(StringUtils.toString(buf));
        }
        boolean negative = false;
        if ((char)buf[s2] == '-') {
            negative = true;
            ++s2;
        } else if ((char)buf[s2] == '+') {
            ++s2;
        }
        int save = s2;
        int cutoff = Integer.MAX_VALUE / base;
        int cutlim = Integer.MAX_VALUE % base;
        if (negative) {
            ++cutlim;
        }
        boolean overflow = false;
        int i2 = 0;
        while (s2 < endPos) {
            char c = (char)buf[s2];
            if (Character.isDigit(c)) {
                c = (char)(c - 48);
            } else {
                if (!Character.isLetter(c)) break;
                c = (char)(Character.toUpperCase(c) - 65 + 10);
            }
            if (c >= base) break;
            if (i2 > cutoff || i2 == cutoff && c > cutlim) {
                overflow = true;
            } else {
                i2 *= base;
                i2 += c;
            }
            ++s2;
        }
        if (s2 == save) {
            throw new NumberFormatException(StringUtils.toString(buf));
        }
        if (overflow) {
            throw new NumberFormatException(StringUtils.toString(buf));
        }
        return negative ? -i2 : i2;
    }

    public static int getInt(byte[] buf) throws NumberFormatException {
        return StringUtils.getInt(buf, 0, buf.length);
    }

    public static long getLong(byte[] buf) throws NumberFormatException {
        return StringUtils.getLong(buf, 0, buf.length);
    }

    public static long getLong(byte[] buf, int offset2, int endpos) throws NumberFormatException {
        int s2;
        char base = '\n';
        for (s2 = offset2; Character.isWhitespace((char)buf[s2]) && s2 < endpos; ++s2) {
        }
        if (s2 == endpos) {
            throw new NumberFormatException(StringUtils.toString(buf));
        }
        boolean negative = false;
        if ((char)buf[s2] == '-') {
            negative = true;
            ++s2;
        } else if ((char)buf[s2] == '+') {
            ++s2;
        }
        int save = s2;
        long cutoff = Long.MAX_VALUE / (long)base;
        long cutlim = (int)(Long.MAX_VALUE % (long)base);
        if (negative) {
            ++cutlim;
        }
        boolean overflow = false;
        long i2 = 0L;
        while (s2 < endpos) {
            char c = (char)buf[s2];
            if (Character.isDigit(c)) {
                c = (char)(c - 48);
            } else {
                if (!Character.isLetter(c)) break;
                c = (char)(Character.toUpperCase(c) - 65 + 10);
            }
            if (c >= base) break;
            if (i2 > cutoff || i2 == cutoff && (long)c > cutlim) {
                overflow = true;
            } else {
                i2 *= (long)base;
                i2 += (long)c;
            }
            ++s2;
        }
        if (s2 == save) {
            throw new NumberFormatException(StringUtils.toString(buf));
        }
        if (overflow) {
            throw new NumberFormatException(StringUtils.toString(buf));
        }
        return negative ? -i2 : i2;
    }

    public static short getShort(byte[] buf) throws NumberFormatException {
        int s2;
        char base = '\n';
        for (s2 = 0; Character.isWhitespace((char)buf[s2]) && s2 < buf.length; ++s2) {
        }
        if (s2 == buf.length) {
            throw new NumberFormatException(StringUtils.toString(buf));
        }
        boolean negative = false;
        if ((char)buf[s2] == '-') {
            negative = true;
            ++s2;
        } else if ((char)buf[s2] == '+') {
            ++s2;
        }
        int save = s2;
        short cutoff = (short)(Short.MAX_VALUE / base);
        short cutlim = (short)(Short.MAX_VALUE % base);
        if (negative) {
            cutlim = (short)(cutlim + 1);
        }
        boolean overflow = false;
        short i2 = 0;
        while (s2 < buf.length) {
            char c = (char)buf[s2];
            if (Character.isDigit(c)) {
                c = (char)(c - 48);
            } else {
                if (!Character.isLetter(c)) break;
                c = (char)(Character.toUpperCase(c) - 65 + 10);
            }
            if (c >= base) break;
            if (i2 > cutoff || i2 == cutoff && c > cutlim) {
                overflow = true;
            } else {
                i2 = (short)(i2 * base);
                i2 = (short)(i2 + c);
            }
            ++s2;
        }
        if (s2 == save) {
            throw new NumberFormatException(StringUtils.toString(buf));
        }
        if (overflow) {
            throw new NumberFormatException(StringUtils.toString(buf));
        }
        return negative ? (short)(-i2) : i2;
    }

    public static final int indexOfIgnoreCase(int startingPosition, String searchIn, String searchFor) {
        if (searchIn == null || searchFor == null || startingPosition > searchIn.length()) {
            return -1;
        }
        int patternLength = searchFor.length();
        int stringLength = searchIn.length();
        int stopSearchingAt = stringLength - patternLength;
        if (patternLength == 0) {
            return -1;
        }
        char firstCharOfPatternUc = Character.toUpperCase(searchFor.charAt(0));
        char firstCharOfPatternLc = Character.toLowerCase(searchFor.charAt(0));
        for (int i2 = startingPosition; i2 <= stopSearchingAt; ++i2) {
            if (StringUtils.isNotEqualIgnoreCharCase(searchIn, firstCharOfPatternUc, firstCharOfPatternLc, i2)) {
                while (++i2 <= stopSearchingAt && StringUtils.isNotEqualIgnoreCharCase(searchIn, firstCharOfPatternUc, firstCharOfPatternLc, i2)) {
                }
            }
            if (i2 > stopSearchingAt) continue;
            int j = i2 + 1;
            int end2 = j + patternLength - 1;
            int k = 1;
            while (j < end2 && (Character.toLowerCase(searchIn.charAt(j)) == Character.toLowerCase(searchFor.charAt(k)) || Character.toUpperCase(searchIn.charAt(j)) == Character.toUpperCase(searchFor.charAt(k)))) {
                ++j;
                ++k;
            }
            if (j != end2) continue;
            return i2;
        }
        return -1;
    }

    private static final boolean isNotEqualIgnoreCharCase(String searchIn, char firstCharOfPatternUc, char firstCharOfPatternLc, int i2) {
        return Character.toLowerCase(searchIn.charAt(i2)) != firstCharOfPatternLc && Character.toUpperCase(searchIn.charAt(i2)) != firstCharOfPatternUc;
    }

    public static final int indexOfIgnoreCase(String searchIn, String searchFor) {
        return StringUtils.indexOfIgnoreCase(0, searchIn, searchFor);
    }

    public static int indexOfIgnoreCaseRespectMarker(int startAt, String src, String target, String marker, String markerCloses, boolean allowBackslashEscapes) {
        char contextMarker = '\u0000';
        boolean escaped = false;
        int markerTypeFound = 0;
        int srcLength = src.length();
        int ind = 0;
        for (int i2 = startAt; i2 < srcLength; ++i2) {
            char c = src.charAt(i2);
            if (allowBackslashEscapes && c == '\\') {
                escaped = !escaped;
                continue;
            }
            if (contextMarker != '\u0000' && c == markerCloses.charAt(markerTypeFound) && !escaped) {
                contextMarker = '\u0000';
                continue;
            }
            ind = marker.indexOf(c);
            if (ind != -1 && !escaped && contextMarker == '\u0000') {
                markerTypeFound = ind;
                contextMarker = c;
                continue;
            }
            if (Character.toUpperCase(c) != Character.toUpperCase(target.charAt(0)) && Character.toLowerCase(c) != Character.toLowerCase(target.charAt(0)) || escaped || contextMarker != '\u0000' || !StringUtils.startsWithIgnoreCase(src, i2, target)) continue;
            return i2;
        }
        return -1;
    }

    public static int indexOfIgnoreCaseRespectQuotes(int startAt, String src, String target, char quoteChar, boolean allowBackslashEscapes) {
        char contextMarker = '\u0000';
        boolean escaped = false;
        int srcLength = src.length();
        for (int i2 = startAt; i2 < srcLength; ++i2) {
            char c = src.charAt(i2);
            if (allowBackslashEscapes && c == '\\') {
                escaped = !escaped;
                continue;
            }
            if (c == contextMarker && !escaped) {
                contextMarker = '\u0000';
                continue;
            }
            if (c == quoteChar && !escaped && contextMarker == '\u0000') {
                contextMarker = c;
                continue;
            }
            if (Character.toUpperCase(c) != Character.toUpperCase(target.charAt(0)) && Character.toLowerCase(c) != Character.toLowerCase(target.charAt(0)) || escaped || contextMarker != '\u0000' || !StringUtils.startsWithIgnoreCase(src, i2, target)) continue;
            return i2;
        }
        return -1;
    }

    public static final List<String> split(String stringToSplit, String delimitter, boolean trim) {
        if (stringToSplit == null) {
            return new ArrayList<String>();
        }
        if (delimitter == null) {
            throw new IllegalArgumentException();
        }
        StringTokenizer tokenizer = new StringTokenizer(stringToSplit, delimitter, false);
        ArrayList<String> splitTokens = new ArrayList<String>(tokenizer.countTokens());
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (trim) {
                token = token.trim();
            }
            splitTokens.add(token);
        }
        return splitTokens;
    }

    public static final List<String> split(String stringToSplit, String delimiter, String markers, String markerCloses, boolean trim) {
        String token;
        if (stringToSplit == null) {
            return new ArrayList<String>();
        }
        if (delimiter == null) {
            throw new IllegalArgumentException();
        }
        int delimPos = 0;
        int currentPos = 0;
        ArrayList<String> splitTokens = new ArrayList<String>();
        while ((delimPos = StringUtils.indexOfIgnoreCaseRespectMarker(currentPos, stringToSplit, delimiter, markers, markerCloses, false)) != -1) {
            token = stringToSplit.substring(currentPos, delimPos);
            if (trim) {
                token = token.trim();
            }
            splitTokens.add(token);
            currentPos = delimPos + 1;
        }
        if (currentPos < stringToSplit.length()) {
            token = stringToSplit.substring(currentPos);
            if (trim) {
                token = token.trim();
            }
            splitTokens.add(token);
        }
        return splitTokens;
    }

    private static boolean startsWith(byte[] dataFrom, String chars2) {
        for (int i2 = 0; i2 < chars2.length(); ++i2) {
            if (dataFrom[i2] == chars2.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWithIgnoreCase(String searchIn, int startAt, String searchFor) {
        return searchIn.regionMatches(true, startAt, searchFor, 0, searchFor.length());
    }

    public static boolean startsWithIgnoreCase(String searchIn, String searchFor) {
        return StringUtils.startsWithIgnoreCase(searchIn, 0, searchFor);
    }

    public static boolean startsWithIgnoreCaseAndNonAlphaNumeric(String searchIn, String searchFor) {
        char c;
        if (searchIn == null) {
            return searchFor == null;
        }
        int beginPos = 0;
        int inLength = searchIn.length();
        for (beginPos = 0; beginPos < inLength && !Character.isLetterOrDigit(c = searchIn.charAt(beginPos)); ++beginPos) {
        }
        return StringUtils.startsWithIgnoreCase(searchIn, beginPos, searchFor);
    }

    public static boolean startsWithIgnoreCaseAndWs(String searchIn, String searchFor) {
        return StringUtils.startsWithIgnoreCaseAndWs(searchIn, searchFor, 0);
    }

    public static boolean startsWithIgnoreCaseAndWs(String searchIn, String searchFor, int beginPos) {
        if (searchIn == null) {
            return searchFor == null;
        }
        int inLength = searchIn.length();
        while (beginPos < inLength && Character.isWhitespace(searchIn.charAt(beginPos))) {
            ++beginPos;
        }
        return StringUtils.startsWithIgnoreCase(searchIn, beginPos, searchFor);
    }

    public static byte[] stripEnclosure(byte[] source2, String prefix, String suffix) {
        if (source2.length >= prefix.length() + suffix.length() && StringUtils.startsWith(source2, prefix) && StringUtils.endsWith(source2, suffix)) {
            int totalToStrip = prefix.length() + suffix.length();
            int enclosedLength = source2.length - totalToStrip;
            byte[] enclosed = new byte[enclosedLength];
            int startPos = prefix.length();
            int numToCopy = enclosed.length;
            System.arraycopy(source2, startPos, enclosed, 0, numToCopy);
            return enclosed;
        }
        return source2;
    }

    public static final String toAsciiString(byte[] buffer) {
        return StringUtils.toAsciiString(buffer, 0, buffer.length);
    }

    public static final String toAsciiString(byte[] buffer, int startPos, int length2) {
        char[] charArray = new char[length2];
        int readpoint = startPos;
        for (int i2 = 0; i2 < length2; ++i2) {
            charArray[i2] = (char)buffer[readpoint];
            ++readpoint;
        }
        return new String(charArray);
    }

    public static int wildCompare(String searchIn, String searchForWildcard) {
        if (searchIn == null || searchForWildcard == null) {
            return -1;
        }
        if (searchForWildcard.equals("%")) {
            return 1;
        }
        int result2 = -1;
        char wildcardMany = '%';
        char wildcardOne = '_';
        char wildcardEscape = '\\';
        int searchForPos = 0;
        int searchForEnd = searchForWildcard.length();
        int searchInPos = 0;
        int searchInEnd = searchIn.length();
        while (searchForPos != searchForEnd) {
            char wildstrChar = searchForWildcard.charAt(searchForPos);
            while (searchForWildcard.charAt(searchForPos) != wildcardMany && wildstrChar != wildcardOne) {
                if (searchForWildcard.charAt(searchForPos) == wildcardEscape && searchForPos + 1 != searchForEnd) {
                    ++searchForPos;
                }
                if (searchInPos == searchInEnd || Character.toUpperCase(searchForWildcard.charAt(searchForPos++)) != Character.toUpperCase(searchIn.charAt(searchInPos++))) {
                    return 1;
                }
                if (searchForPos == searchForEnd) {
                    return searchInPos != searchInEnd ? 1 : 0;
                }
                result2 = 1;
            }
            if (searchForWildcard.charAt(searchForPos) == wildcardOne) {
                do {
                    if (searchInPos == searchInEnd) {
                        return result2;
                    }
                    ++searchInPos;
                } while (++searchForPos < searchForEnd && searchForWildcard.charAt(searchForPos) == wildcardOne);
                if (searchForPos == searchForEnd) break;
            }
            if (searchForWildcard.charAt(searchForPos) != wildcardMany) continue;
            ++searchForPos;
            while (searchForPos != searchForEnd) {
                if (searchForWildcard.charAt(searchForPos) != wildcardMany) {
                    if (searchForWildcard.charAt(searchForPos) != wildcardOne) break;
                    if (searchInPos == searchInEnd) {
                        return -1;
                    }
                    ++searchInPos;
                }
                ++searchForPos;
            }
            if (searchForPos == searchForEnd) {
                return 0;
            }
            if (searchInPos == searchInEnd) {
                return -1;
            }
            char cmp2 = searchForWildcard.charAt(searchForPos);
            if (cmp2 == wildcardEscape && searchForPos + 1 != searchForEnd) {
                cmp2 = searchForWildcard.charAt(++searchForPos);
            }
            ++searchForPos;
            while (true) {
                if (searchInPos != searchInEnd && Character.toUpperCase(searchIn.charAt(searchInPos)) != Character.toUpperCase(cmp2)) {
                    ++searchInPos;
                    continue;
                }
                if (searchInPos++ == searchInEnd) {
                    return -1;
                }
                int tmp = StringUtils.wildCompare(searchIn, searchForWildcard);
                if (tmp <= 0) {
                    return tmp;
                }
                if (searchInPos == searchInEnd || searchForWildcard.charAt(0) == wildcardMany) break;
            }
            return -1;
        }
        return searchInPos != searchInEnd ? 1 : 0;
    }

    static byte[] s2b(String s2, MySQLConnection conn) throws SQLException {
        if (s2 == null) {
            return null;
        }
        if (conn != null && conn.getUseUnicode()) {
            try {
                String encoding2 = conn.getEncoding();
                if (encoding2 == null) {
                    return s2.getBytes();
                }
                SingleByteCharsetConverter converter = conn.getCharsetConverter(encoding2);
                if (converter != null) {
                    return converter.toBytes(s2);
                }
                return s2.getBytes(encoding2);
            }
            catch (UnsupportedEncodingException E) {
                return s2.getBytes();
            }
        }
        return s2.getBytes();
    }

    public static int lastIndexOf(byte[] s2, char c) {
        if (s2 == null) {
            return -1;
        }
        for (int i2 = s2.length - 1; i2 >= 0; --i2) {
            if (s2[i2] != c) continue;
            return i2;
        }
        return -1;
    }

    public static int indexOf(byte[] s2, char c) {
        if (s2 == null) {
            return -1;
        }
        int length2 = s2.length;
        for (int i2 = 0; i2 < length2; ++i2) {
            if (s2[i2] != c) continue;
            return i2;
        }
        return -1;
    }

    public static boolean isNullOrEmpty(String toTest) {
        return toTest == null || toTest.length() == 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String stripComments(String src, String stringOpens, String stringCloses, boolean slashStarComments, boolean slashSlashComments, boolean hashComments, boolean dashDashComments) {
        if (src == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(src.length());
        StringReader sourceReader = new StringReader(src);
        char contextMarker = '\u0000';
        boolean escaped = false;
        int markerTypeFound = -1;
        int ind = 0;
        char currentChar = '\u0000';
        try {
            block2: while ((currentChar = sourceReader.read()) != '\uffffffff') {
                char prevChar;
                block22: {
                    block23: {
                        block20: {
                            block21: {
                                if (markerTypeFound != -1 && currentChar == stringCloses.charAt(markerTypeFound) && !escaped) {
                                    contextMarker = '\u0000';
                                    markerTypeFound = -1;
                                } else {
                                    ind = stringOpens.indexOf(currentChar);
                                    if (ind != -1 && !escaped && contextMarker == '\u0000') {
                                        markerTypeFound = ind;
                                        contextMarker = currentChar;
                                    }
                                }
                                if (contextMarker != '\u0000' || currentChar != '/' || !slashSlashComments && !slashStarComments) break block20;
                                currentChar = sourceReader.read();
                                if (currentChar != '*' || !slashStarComments) break block21;
                                prevChar = '\u0000';
                                break block22;
                            }
                            if (currentChar == '/' && slashSlashComments) {
                                while ((currentChar = sourceReader.read()) != '\n' && currentChar != '\r' && currentChar >= '\u0000') {
                                }
                            }
                            break block23;
                        }
                        if (contextMarker == '\u0000' && currentChar == '#' && hashComments) {
                            while ((currentChar = sourceReader.read()) != '\n' && currentChar != '\r' && currentChar >= '\u0000') {
                            }
                        } else if (contextMarker == '\u0000' && currentChar == '-' && dashDashComments) {
                            currentChar = sourceReader.read();
                            if (currentChar == '\uffffffff' || currentChar != '-') {
                                buf.append('-');
                                if (currentChar == '\uffffffff') continue;
                                buf.append((int)currentChar);
                                continue;
                            }
                            while ((currentChar = sourceReader.read()) != '\n' && currentChar != '\r' && currentChar >= '\u0000') {
                            }
                        }
                    }
                    if (currentChar == '\uffffffff') continue;
                    buf.append(currentChar);
                    continue;
                }
                while ((currentChar = sourceReader.read()) != '/' || prevChar != '*') {
                    if (currentChar == '\r') {
                        currentChar = sourceReader.read();
                        if (currentChar == '\n') {
                            currentChar = sourceReader.read();
                        }
                    } else if (currentChar == '\n') {
                        currentChar = sourceReader.read();
                    }
                    if (currentChar < '\u0000') continue block2;
                    prevChar = currentChar;
                }
            }
            return buf.toString();
        }
        catch (IOException ioEx) {
            // empty catch block
        }
        return buf.toString();
    }

    public static String sanitizeProcOrFuncName(String src) {
        if (src == null || src.equals("%")) {
            return null;
        }
        return src;
    }

    public static List<String> splitDBdotName(String src, String cat, String quotId, boolean isNoBslashEscSet) {
        if (src == null || src.equals("%")) {
            return new ArrayList<String>();
        }
        boolean isQuoted = StringUtils.indexOfIgnoreCase(0, src, quotId) > -1;
        String retval = src;
        String tmpCat = cat;
        int trueDotIndex = -1;
        trueDotIndex = !" ".equals(quotId) ? (isQuoted ? StringUtils.indexOfIgnoreCase(0, retval, quotId + "." + quotId) : StringUtils.indexOfIgnoreCase(0, retval, ".")) : retval.indexOf(".");
        ArrayList<String> retTokens = new ArrayList<String>(2);
        if (trueDotIndex != -1) {
            if (isQuoted) {
                tmpCat = StringUtils.toString(StringUtils.stripEnclosure(retval.substring(0, trueDotIndex + 1).getBytes(), quotId, quotId));
                if (StringUtils.startsWithIgnoreCaseAndWs(tmpCat, quotId)) {
                    tmpCat = tmpCat.substring(1, tmpCat.length() - 1);
                }
                retval = retval.substring(trueDotIndex + 2);
                retval = StringUtils.toString(StringUtils.stripEnclosure(retval.getBytes(), quotId, quotId));
            } else {
                tmpCat = retval.substring(0, trueDotIndex);
                retval = retval.substring(trueDotIndex + 1);
            }
        } else {
            retval = StringUtils.toString(StringUtils.stripEnclosure(retval.getBytes(), quotId, quotId));
        }
        retTokens.add(tmpCat);
        retTokens.add(retval);
        return retTokens;
    }

    public static final boolean isEmptyOrWhitespaceOnly(String str) {
        if (str == null || str.length() == 0) {
            return true;
        }
        int length2 = str.length();
        for (int i2 = 0; i2 < length2; ++i2) {
            if (Character.isWhitespace(str.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static String escapeQuote(String src, String quotChar) {
        if (src == null) {
            return null;
        }
        src = StringUtils.toString(StringUtils.stripEnclosure(src.getBytes(), quotChar, quotChar));
        int lastNdx = src.indexOf(quotChar);
        String tmpSrc = src.substring(0, lastNdx);
        tmpSrc = tmpSrc + quotChar + quotChar;
        String tmpRest = src.substring(lastNdx + 1, src.length());
        lastNdx = tmpRest.indexOf(quotChar);
        while (lastNdx > -1) {
            tmpSrc = tmpSrc + tmpRest.substring(0, lastNdx);
            tmpSrc = tmpSrc + quotChar + quotChar;
            tmpRest = tmpRest.substring(lastNdx + 1, tmpRest.length());
            lastNdx = tmpRest.indexOf(quotChar);
        }
        src = tmpSrc = tmpSrc + tmpRest;
        return src;
    }

    public static String toString(byte[] value2, int offset2, int length2, String encoding2) throws UnsupportedEncodingException {
        Charset cs = StringUtils.findCharset(encoding2);
        return cs.decode(ByteBuffer.wrap(value2, offset2, length2)).toString();
    }

    public static String toString(byte[] value2, String encoding2) throws UnsupportedEncodingException {
        Charset cs = StringUtils.findCharset(encoding2);
        return cs.decode(ByteBuffer.wrap(value2)).toString();
    }

    public static String toString(byte[] value2, int offset2, int length2) {
        try {
            Charset cs = StringUtils.findCharset(platformEncoding);
            return cs.decode(ByteBuffer.wrap(value2, offset2, length2)).toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static String toString(byte[] value2) {
        try {
            Charset cs = StringUtils.findCharset(platformEncoding);
            return cs.decode(ByteBuffer.wrap(value2)).toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static byte[] getBytes(String value2, String encoding2) throws UnsupportedEncodingException {
        Charset cs = StringUtils.findCharset(encoding2);
        ByteBuffer buf = cs.encode(value2);
        int encodedLen = buf.limit();
        byte[] asBytes = new byte[encodedLen];
        buf.get(asBytes, 0, encodedLen);
        return asBytes;
    }

    public static byte[] getBytes(String value2) {
        try {
            Charset cs = StringUtils.findCharset(platformEncoding);
            ByteBuffer buf = cs.encode(value2);
            int encodedLen = buf.limit();
            byte[] asBytes = new byte[encodedLen];
            buf.get(asBytes, 0, encodedLen);
            return asBytes;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static final boolean isValidIdChar(char c) {
        return VALID_ID_CHARS.indexOf(c) != -1;
    }

    static {
        charsetsByAlias = new ConcurrentHashMap();
        platformEncoding = System.getProperty("file.encoding");
        for (int i2 = -128; i2 <= 127; ++i2) {
            StringUtils.allBytes[i2 - -128] = (byte)i2;
        }
        String allBytesString = new String(allBytes, 0, 255);
        int allBytesStringLen = allBytesString.length();
        for (int i3 = 0; i3 < 255 && i3 < allBytesStringLen; ++i3) {
            StringUtils.byteToChars[i3] = allBytesString.charAt(i3);
        }
        try {
            toPlainStringMethod = BigDecimal.class.getMethod("toPlainString", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

