/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Connection;
import com.mysql.jdbc.StringUtils;
import com.mysql.jdbc.Util;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Security {
    private static final char PVERSION41_CHAR = '*';
    private static final int SHA1_HASH_SIZE = 20;

    private static int charVal(char c) {
        return c >= '0' && c <= '9' ? c - 48 : (c >= 'A' && c <= 'Z' ? c - 65 + 10 : c - 97 + 10);
    }

    static byte[] createKeyFromOldPassword(String passwd2) throws NoSuchAlgorithmException {
        passwd2 = Security.makeScrambledPassword(passwd2);
        int[] salt = Security.getSaltFromPassword(passwd2);
        return Security.getBinaryPassword(salt, false);
    }

    static byte[] getBinaryPassword(int[] salt, boolean usingNewPasswords) throws NoSuchAlgorithmException {
        int val = 0;
        byte[] binaryPassword = new byte[20];
        if (usingNewPasswords) {
            int pos2 = 0;
            for (int i2 = 0; i2 < 4; ++i2) {
                val = salt[i2];
                for (int t = 3; t >= 0; --t) {
                    binaryPassword[pos2++] = (byte)(val & 0xFF);
                    val >>= 8;
                }
            }
            return binaryPassword;
        }
        int offset2 = 0;
        for (int i3 = 0; i3 < 2; ++i3) {
            val = salt[i3];
            for (int t = 3; t >= 0; --t) {
                binaryPassword[t + offset2] = (byte)(val % 256);
                val >>= 8;
            }
            offset2 += 4;
        }
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        md.update(binaryPassword, 0, 8);
        return md.digest();
    }

    private static int[] getSaltFromPassword(String password) {
        int[] result2 = new int[6];
        if (password == null || password.length() == 0) {
            return result2;
        }
        if (password.charAt(0) == '*') {
            String saltInHex = password.substring(1, 5);
            int val = 0;
            for (int i2 = 0; i2 < 4; ++i2) {
                val = (val << 4) + Security.charVal(saltInHex.charAt(i2));
            }
            return result2;
        }
        int resultPos = 0;
        int pos2 = 0;
        int length2 = password.length();
        while (pos2 < length2) {
            int val = 0;
            for (int i3 = 0; i3 < 8; ++i3) {
                val = (val << 4) + Security.charVal(password.charAt(pos2++));
            }
            result2[resultPos++] = val;
        }
        return result2;
    }

    private static String longToHex(long val) {
        String longHex = Long.toHexString(val);
        int length2 = longHex.length();
        if (length2 < 8) {
            int padding = 8 - length2;
            StringBuffer buf = new StringBuffer();
            for (int i2 = 0; i2 < padding; ++i2) {
                buf.append("0");
            }
            buf.append(longHex);
            return buf.toString();
        }
        return longHex.substring(0, 8);
    }

    static String makeScrambledPassword(String password) throws NoSuchAlgorithmException {
        long[] passwordHash = Util.newHash(password);
        StringBuffer scramble = new StringBuffer();
        scramble.append(Security.longToHex(passwordHash[0]));
        scramble.append(Security.longToHex(passwordHash[1]));
        return scramble.toString();
    }

    static void passwordCrypt(byte[] from, byte[] to, byte[] password, int length2) {
        for (int pos2 = 0; pos2 < from.length && pos2 < length2; ++pos2) {
            to[pos2] = (byte)(from[pos2] ^ password[pos2]);
        }
    }

    static byte[] passwordHashStage1(String password) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        StringBuffer cleansedPassword = new StringBuffer();
        int passwordLength = password.length();
        for (int i2 = 0; i2 < passwordLength; ++i2) {
            char c = password.charAt(i2);
            if (c == ' ' || c == '\t') continue;
            cleansedPassword.append(c);
        }
        return md.digest(StringUtils.getBytes(cleansedPassword.toString()));
    }

    static byte[] passwordHashStage2(byte[] hashedPassword, byte[] salt) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        md.update(salt, 0, 4);
        md.update(hashedPassword, 0, 20);
        return md.digest();
    }

    public static byte[] scramble411(String password, String seed2, Connection conn) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        String passwordEncoding = conn.getPasswordCharacterEncoding();
        byte[] passwordHashStage1 = md.digest(passwordEncoding == null || passwordEncoding.length() == 0 ? StringUtils.getBytes(password) : StringUtils.getBytes(password, passwordEncoding));
        md.reset();
        byte[] passwordHashStage2 = md.digest(passwordHashStage1);
        md.reset();
        byte[] seedAsBytes = StringUtils.getBytes(seed2, "ASCII");
        md.update(seedAsBytes);
        md.update(passwordHashStage2);
        byte[] toBeXord = md.digest();
        int numToXor = toBeXord.length;
        for (int i2 = 0; i2 < numToXor; ++i2) {
            toBeXord[i2] = (byte)(toBeXord[i2] ^ passwordHashStage1[i2]);
        }
        return toBeXord;
    }

    private Security() {
    }
}

