import java.io.*;
import java.util.*;
import java.util.zip.CRC32;

/* localstore */
public class scachestore extends localstore
{

	/* smartcache */
	private String scacheroot;
	private int swap_level1_dirs,swap_level2_dirs;
	private LRUHashtable <String,minicachedir> dircache;

	public scachestore(String cfg[])
	{
		super(cfg);
	}

	protected void localinit()
	{
		swap_level1_dirs=swap_level2_dirs=4;
		scacheroot="store";
		smartcacheconfig(arg[0]);
		dircache=new LRUHashtable <String,minicachedir>(25);
	}

	public String toString()
	{
		return "Smart Cache directory storage";
	}

	public boolean isReadOnly()
	{
		return true;
	}

	public void close()
	{
		dircache=null;
	}

	public localurl getURL(String URL) throws java.net.MalformedURLException
	{
		// 0. parse URL
		String[] parsed=parseURL(URL);

		// 1. get local directory
		String locdir=getLocalDir(parsed[0],parsed[1],parsed[2],parsed[4]);

		// 2. get cache directory
		minicachedir dir=null;
		synchronized(this)
		{
			dir=dircache.get(locdir);
			if(dir==null)
			{
				dir=new minicachedir(locdir);
				dircache.put(locdir,dir);
			}
		}

		return dir.getObject(parsed[3]);
	}

	private final void smartcacheconfig(String cfgfile)
	{
		try
		{
			String line,token;
			StringTokenizer st;

			DataInputStream dis=new DataInputStream(new BufferedInputStream(new FileInputStream(cfgfile)));
			System.err.println("[CONFIG] Processing Smart_Cache config file "+cfgfile);
			while ( (line = dis.readLine()) != null)
			{
				if(line.startsWith("#")) continue;
				st=new StringTokenizer(line);
				if(st.hasMoreTokens()==false) continue;
				token=st.nextToken().toLowerCase();

				if(token.equals("swap_level1_dirs")) {swap_level1_dirs=Integer.valueOf(st.nextToken());
				continue;
				}

				if(token.equals("swap_level2_dirs")) {swap_level2_dirs=Integer.valueOf(st.nextToken());
				continue;
				}

				if(token.equals("cache_dir") ||
						token.equals("cacheroot")
				) {  scacheroot=st.nextToken();
				if(scacheroot.charAt(1)!=':'
					&&
					scacheroot.charAt(0)!=File.separatorChar
				)
					System.err.println("[CONFIG_WARNING] SmartCache root is not absolute path, may not work");
				continue;
				}
			}

			// musime znat swap dirs levels
			if(scacheroot!=null && ( swap_level1_dirs==0 || swap_level2_dirs==0) ) scacheroot=null;
			dis.close();
		}
		catch (IOException fnf)
		{
			throw new IllegalArgumentException("Can not read Smart Cache config file: "+cfgfile);
		}

		//System.err.println("[CONFIG_DEBUG] smartcacheconfig Proxy configured: "+proxydefined);
		//System.err.println("[CONFIG_DEBUG] smartcacheconfig CacheRoot: "+scacheroot+" ("+swap_level1_dirs+"/"+swap_level2_dirs+")");
	}

	/**
  Vrati lokalni adresar k zadanym parametrum
	 */
	final private String getLocalDir(String host,String port,String urldir,String proto)
	{
		StringBuffer result=new StringBuffer(80);
		result.append(scacheroot);
		// String result=cache_dir;
		int i;

		/* 1. spocitat hash z host stringu */
		CRC32 crc=new CRC32();

		crc.update(host.getBytes());

		/* mame hash - rozdelime ho na adresar */
		/* zacneme budovat cestu */
		i=(int)(crc.getValue()/(0x100000000L/(swap_level1_dirs*swap_level2_dirs)));
		result.append(File.separator+(i/swap_level2_dirs)+File.separator+(i % swap_level2_dirs)+File.separator+host);

		/* pridame port */
		if(port!=null)
		{result.append('_');
		result.append(port);
		}

		/* add protocol */
		if(proto!=null)
		{
			result.append('^');
			result.append(proto);
		}

		/* pridame adresar */
		if(File.separatorChar!='/') urldir=urldir.replace('/',File.separatorChar);

		/* *************************************************** */
		/* ALERT: Synchronize by hand with garbage.encodechars */
		/* *************************************************** */
		/* nahrazujeme nepratelske znaky */
		// urldir=urldir.replace(':','_');
		// zde to neni nutne, neb muze byt jen v portu

		//  urldir=urldir.replace('*','@');
		//  urldir=urldir.replace('?','#');
		// urldir=urldir.replace('~','-');

		// these two are not needed. Browsers sends &lt; &gt;
		// urldir=urldir.replace('>','}');
		// urldir=urldir.replace('<','{');
		urldir=urldir.replace('|','!');

		result.append(urldir);
		return result.toString();
	}

}
