import java.util.*;
import java.io.*;
import java.net.*;
import java.util.regex.Matcher;

public final class loader implements Runnable
{
 private final static float MAX_QPRIO=9999.99f;
 public static final int IO_BUFFER=4096;

 public static final String PROG_VERSION="0.31";
 public static final String PROG_NAME="Smart Cache Loader";
 public static final String PROG_URL="http://scloader.sourceforge.net";
 public static final String PROG_COPYRIGHT="Copyright (c) Radim Kolar 1998-2007. Open source software; There is NO warranty.\n"+
 "See the GNU General Public Licence version 2 for copying conditions.";

 public static final int  THREADS=8; // like in Opera

 public static final char EXPANDCHAR='@';   // include this file as argz
 public static final char STARTURLCHAR='^'; // start URL for known location
 public static final char CONFIGCHAR='#'; // also comment in include file
 public static final char OPTIONCHAR='-'; // command line option
 public static final char VISITEDCHAR=':'; // already visited
 public static final char DEFAULTURLCHAR='%'; // configure this url as default

 public static final String DEFAULTCFG="loader.cnf";

 public static byte maxretry=3;
 public static float retryprio=-1f;

 public static location loc[];
 public static location def;

 public static String useragent="User-Agent: Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.3) Gecko/20060601 Firefox/2.0.0.3 "+PROG_NAME+"/"+PROG_VERSION+"\r\n";

 public static InetAddress proxyserver;
 public static int proxyport;

 public static boolean readonly;
 public static localstore store;

 public static priorityqueue pq;
 private static Hashtable visited;
 private static Hashtable referers;

 // thread control
 public static short maxThreads=THREADS;
 public static volatile int now;

 // worker non-static data
 public request r;
 private Socket s;

 public static void main(String argv[]) throws IOException
 {
  System.err.println(PROG_NAME+" "+PROG_VERSION+" "+PROG_URL+"\n"+PROG_COPYRIGHT+"\n");

  store=new nullstore(new String[0]);
  if(argv.length>0)
   if(argv[0].charAt(0)!=CONFIGCHAR) configloader(DEFAULTCFG);
   else ;
  else
   configloader(DEFAULTCFG);

  init(argv);
  try
  {
    pq.peek();
    start();
    store.close();
    System.err.println(PROG_NAME+" "+PROG_VERSION+" - end of job.");
  }
  catch (NoSuchElementException nse)
  {
    System.err.println("\n[LOADER] No active servers - nothing done.");
  }
 }

 public loader(request r)
 {
    this.r=r;
 }

 public static final void init(String argv[])
 {
  // program init
  pq=new priorityqueue(5,10);
  visited=new Hashtable(50);
  referers=new Hashtable(100);
  now=0;

  // expand command line include arguments
  Vector argz;
  argz=new Vector(argv.length,5);
  boolean alldefault=false;

  exparg:
    for(int i=0;i<argv.length;i++)
    {
      String s;
      s=argv[i];
      if(s.length()==0) continue;
      if(s.charAt(0)==EXPANDCHAR)
        insertFile(s.substring(1),argz,false);
        else
         if(s.charAt(0)==VISITEDCHAR) {
           if(s.length()<2) continue;
	     else if(s.charAt(1)==EXPANDCHAR)
                    insertFile(s.substring(2),argz,true);
         }  else // normal argument
             argz.addElement(s);
    }
    argv=null;

  argscan:for(int i=0;i<argz.size();i++)
  {
   String s;
   s=(String)argz.elementAt(i);
   if(s==null || s.length()==0) continue; // NULL size option ??
   /* special chars stuff */
   if(s.charAt(0)==OPTIONCHAR && s.length()>1)
   {
     for(int j=1;j<s.length();j++)
     {
	 char c;
	 c=s.charAt(j);
	 switch(c)
	 {
	     case 'd':
		 alldefault=true;
		 break;
	     default:
                 System.err.println("[PARAMETER_ERROR] Option '"+c+"' is not known.");
		 break;
	 }
     }
     continue;
   }
   if(s.charAt(0)==CONFIGCHAR) {
                           if(i!=0) System.err.println("[PARAMETER_ERROR] Config file must be the first parameter. All previous parameters are overwritten by it.");
                           configloader(s.substring(1));
                           continue;
                         }
   if(s.charAt(0)==VISITEDCHAR)
    {
     String z;
     z=s.substring(1);
     try
      {
       new URL(z);
       visited.put(z,z);
      }
     catch (MalformedURLException ignore)
     {}
     finally
      {continue;}
    }
   /* URL on commandline ? */
   if(
        s.indexOf("://")>0 &&
      ( s.indexOf("=")>s.indexOf("://") || s.indexOf("=")==-1)
     )
   {
     if(s.charAt(0)==STARTURLCHAR)
     {
      /* Add new start URL to known site */
      location ol;
      String z=s.substring(1);
      ol=findLocation(z);
      if(ol==null)
	  System.err.println("[PARAMETER_ERROR] URL "+z+" is not from known location.");
      else
      {
	  ol.addStartURL(z);ol.passive=false;
      }
      continue;
     }
     /* configure new site as */
     location ol=null;

     if(s.charAt(0)==DEFAULTURLCHAR) {
                                       ol=def;
				       s=s.substring(1);
				     }
     if(s.indexOf("#")>10)
     {
       String z=s.substring(s.indexOf("#")+1,s.length());
       s=s.substring(0,s.indexOf("#"));
       for(int j=loc.length-1;j>=0;j--)
       {
          if(z.equalsIgnoreCase(loc[j].name)) { ol=loc[j];break;}
       }
     }
     URL u;
     /* fix no ending slash after hostname problem */
     try
     {
       u=new URL(s);
       s=u.toString();
     }
     catch (MalformedURLException grrr)
     {
	 continue;
     }
     if(ol==null && alldefault==true) ol=def;
     // inject new site

     location site;
     boolean fixdepth;
     fixdepth=false;
     /* find matching location, if needed */
     if(ol==null) {
	 ol=findLocation(s);
	 fixdepth=true;
     }
     //System.err.println("Old loc="+ol+" url="+s);
     /* strip filename from location */
     site=createNewLocation(u.getProtocol()+"://"+u.getHost()+util.getDirname(u.getFile()),ol);
     /* set depth to default */
     if(fixdepth)
     {
	 site.depth=def.depth;
	 site.priority=def.priority;
     }
     /* transfer masks */
     if(ol!=null && ol!=def)
     {
        site.ctmasks=ol.ctmasks;
        site.urlmasks=ol.urlmasks;
     }
     /* transfer default referer */
     if(ol!=null && ol!=def)
     {
         site.referer=ol.referer;
	 //System.err.println("transfering non-default referer");
     }
     if(site.referer==null)
     {
	 site.referer=def.referer;
	 def.referer=null;
     }

     site.passive=false;
     site.masks=site.content=site.action=location.INCLUDING_DEFAULTS;

     // add pending DNS aliases
     site.transferAliases(def);

     // startURL fun
     site.addStartURL(s);
     site.transferStartURL(def);

     loc=util.addLocationToArray(site,loc);
     continue; // new site injected
     }

     /* option on commandline ? */
     if(s.indexOf("=",0)>-1)
     {
       StringTokenizer st=new StringTokenizer(s);
       String opt=st.nextToken("=");
       opt=opt.toLowerCase().trim();
       if(opt.equals("scandepth")|| opt.equals("depth"))
       {
          short c=(short)Integer.valueOf(st.nextToken()).intValue();
          def.setDepth(c);
          continue;
       }
       else if(opt.equals("threads"))
        {
          maxThreads=(short)Integer.valueOf(st.nextToken()).intValue();
	  if(maxThreads<=0) maxThreads=THREADS;
          continue;
        }
       else if(opt.equals("retry"))
        {
          maxretry=(byte)Integer.valueOf(st.nextToken()).intValue();
          continue;
        }
       else if(opt.equals("retrypriority"))
        {
          retryprio=Float.valueOf(st.nextToken()).floatValue();
          continue;
        }
       else if(opt.equals("delay"))
        {
          def.setDelay(util.timestring(st.nextToken()));
          continue;
        }
       else if(opt.equals("crawltime"))
        {
          def.setCrawlTime(util.timestring(st.nextToken()));
          continue;
        }
       else if(opt.equals("options"))
         {
           options o=new options(s);
           def.serveroptions(o);
           continue;
         }
       else if(opt.equals("priority"))
         {
           float c=Float.valueOf(st.nextToken()).floatValue();
           def.setPriority(c);
           continue;
         }
       else if(opt.equals("locationalias") || opt.equals("alias"))
       {
         do
         {
           String z;
           z=st.nextToken(" ,&\t\r\n");
           def.addAlias(z);
         }
         while(st.hasMoreTokens());
         continue;
       }
       else if(opt.equals("starturl"))
        {
         def.addStartURL(st.nextToken());
         continue;
        }
       else if(opt.equals("log"))
       {
         options o=new options(s);
         def.addActions(o,true);
         continue;
       }
       else if(opt.equals("upd"))
        {
         options o=new options(s);
         def.addActions(o,true);
         continue;
        }
       else if(opt.equals("referer") || opt.equals("ref"))
        {
         if(st.hasMoreTokens()) def.referer=st.nextToken();
         continue;
        }
       else
        System.err.println("[PARAMETER_ERROR] Unknown option "+opt);
       continue;
      }

   // scan for alias
   boolean neg;
   if(s.charAt(0)=='!') { neg=true; s=s.substring(1);} else neg=false;
   for(int j=loc.length-1;j>=0;j--)
    {
     if(s.equalsIgnoreCase(loc[j].name)) { loc[j].passive=neg;continue argscan;}
    }
   System.err.println("[PARAMETER_ERROR] Location named '"+s+"' was not found.");
  } /* argscan loop */
  readonly=store.isReadOnly();

  // add ACTIVE sites to QUEUE
  for(int j=loc.length-1;j>=0;j--)
    if(loc[j].passive==false)
      if(loc[j].starturl==null)
         addToQueue(new request(loc[j].locbase,loc[j]),MAX_QPRIO,loc[j].referer);
       else
         for(int z=loc[j].starturl.length-1;z>=0;z--)
           addToQueue(new request(loc[j].starturl[z],loc[j]),MAX_QPRIO,loc[j].referer);

}

private final static void insertFile(String filename,Vector v,boolean vis)
{
 try
   {
	  // insert argz from file;
	  BufferedReader br=new BufferedReader(new FileReader(filename));
	  while(true)
	  {
	    String l;
	    boolean vv;
	    vv=vis;
	    l=br.readLine();
	    if(l==null) break;
	    if(l.length()==0) continue;
	    l=l.trim();
	    if(l.charAt(0)=='#') continue; // komentar
	    else
	    if(l.charAt(0)==VISITEDCHAR)
	       if(l.length()>1) { vv=true;l=l.substring(1).trim();}
	          else
	        continue; // missing URL
	    else
	    if(l.charAt(0)==EXPANDCHAR)
	     {
	       String fn=l.substring(1);
	       if(!visited.contains(fn))
	         {
		  visited.put(fn,fn);
		  insertFile(fn,v,vv);
		 }
	       continue;
	     }
	    StringTokenizer st;
	    st=new StringTokenizer(l);
	    while(st.hasMoreTokens())
	    {
            if(vv==true)  v.addElement(":"+st.nextToken());
	             else v.addElement(st.nextToken());
	    }
	  }
	  br.close();
   }	
   catch (IOException z)
    {}
}	
/*     m a i n    l o o p      */

 public final void run()
 {
  try
  {
    DataInputStream dis;
    boolean compressed=false;
    DataOutputStream dos=null;
    URL target=new URL(r.url);
    String line;
    localurl local;
    long curtime;
    
    /* check if we can still crawl location */
    if(r.loc.lastrequest < 0)
    {
       /* init lastrequest */	
       curtime=System.currentTimeMillis();
       r.loc.lastrequest = curtime + Math.abs(r.loc.lastrequest);
    } else 
    if (r.loc.lastrequest > 0)
    {
       curtime=System.currentTimeMillis();
       if (curtime > r.loc.lastrequest)
       {
	   done();
	   return;
       }
    }

    if(r.log==mask.LOG_SERVERDEFAULT)
      r.log=(r.loc.defaultmask.log==mask.LOG_SERVERDEFAULT?
         mask.LOG_DEFAULT:r.loc.defaultmask.log);

    log("Processing",mask.LOG_QUEUE);

    if(r.act==mask.ACT_REJECT)
    {
	log("Rejecting",mask.LOG_REJECT);
	done();
	return;
    }

    local=store.getURL(r.url);

// test zda nahravat ze serveru nebo z local filesystemu
if(
 /* test na norefresh/noreparse */
 ((r.update==mask.UPD_NOREFRESH || r.update==mask.UPD_NOREPARSE) && local.exists())  ||
/* test na update/forceupdate */
 ((r.update==mask.UPD_UPDATE || r.update==mask.UPD_FORCEUPDATE) &&
   (local.exists() && local.getDate()+r.updatelimit<System.currentTimeMillis())
    )
)
{
 try
 {
  /* Loading from local filesystem */
  log("Stored",mask.LOG_STORED);
  if(local.getLocation()!=null)
  {
       /* add redirect to queue */
       request nr=(request)r.clone();
       nr.url=new URL(target,local.getLocation()).toString();
       addToQueue(nr,r.loc.priority,r.url);
  }
  if(r.update==mask.UPD_NOREPARSE || !local.isParseable())
           { done();return;} // no need to load it

  dis=
     new DataInputStream (
    new BufferedInputStream(local.getInputStream(),IO_BUFFER)
    );
 }
 catch (IOException iof)
  {
   System.err.println("Reading from localfile failed, turning update off.");
   r.update=mask.UPD_LOAD;
   throw iof;
  }
}
else
{
    /* check if we can send new request */
    while(true)
    {	
       curtime=System.currentTimeMillis();
       if(r.loc.nextrequest<=curtime)
       {
	   /* we can send new request NOW */
	   r.loc.nextrequest=curtime+r.loc.crawldelay;
	   break;
       }
       else
       {
	   try
	   {
              Thread.sleep(r.loc.nextrequest-curtime);
	   }
	   catch (InterruptedException ouha) { done();return;}
       }
    }
    log("Loading",mask.LOG_LOAD);
    // connect to TCP/IP data source
    if(proxyserver==null||r.act==mask.ACT_NOPROXY)
      {
        // Direct connection to remote server
        String proto=target.getProtocol();

       if(!proto.equalsIgnoreCase("http"))
        {
          log("Unsupported protocol",mask.LOG_FATALERR);
	  done();
	  return;
        };
       int p=target.getPort();
       sendHTTPrequest(InetAddress.getByName(target.getHost()),p==-1? 80: p,target.getHost(),target.getFile());
      }
     else
       // Send request to proxy
       sendHTTPrequest(proxyserver,proxyport,null,r.url);

    if(r.act==mask.ACT_FASTCLOSE) {s.close();done();return;}

    // otevrit data input stream z http serveru
    dis=new DataInputStream(new BufferedInputStream(s.getInputStream(),IO_BUFFER));
    /* HTTP-HEADER PARSING START */
    int ctsize=-1;
    int httprc;
    // String ctype="application/octet-stream";
    line=dis.readLine(); /* HTTP/1.0 XX OK */
    if(line==null) {
	log("Connection closed",mask.LOG_ERR);
	s.close();
	throw new EOFException("Connection closed");
    }

    /* precteme si tedy httprc kod */
    StringTokenizer st;
    st=new StringTokenizer(line);

    /* WARN: tady to spadne pri remote HTTP 0.9 serveru */
    try
    {
      st.nextToken(); /* http/1.0 - nezajimave */
      httprc=Integer.valueOf(st.nextToken()).intValue();
    }
     catch (Exception http09)
    {
      log("HTTP 0.9 response",mask.LOG_FATALERR);
      s.close();done();return;
    }

 /* cteme hlavicky */
  while(true)
  {
      int j;
      String s1,s2;
      line=dis.readLine();
      if(line==null) break;
      if(line.length()==0) break;

    j=line.indexOf(':',0);
    if(j==-1) continue;
    s1=line.substring(0,j).toLowerCase();
    s2=line.substring(j+1).trim();
    if(s1.equals("content-length"))
             try
              {
                 ctsize=Integer.valueOf(s2).intValue();
              }
              catch (Exception ignore)
              {}
              finally
              { continue;}

    if(s1.equals("content-type") && !s2.toLowerCase().startsWith("text/html"))
     {
      if(r.act==mask.ACT_CLOSE) {s.close();done();return;}
       else
      r.act=mask.ACT_NOPARSE;
      continue;
     }
    if(s1.equals("content-encoding") && s2.toLowerCase().indexOf("gzip")>-1)
    {
     compressed=true;
     continue;
    }
    if(s1.equals("location"))
     {
       /* Location: handler */
       request nr=(request)r.clone();
       nr.url=new URL(target,s2).toString();
       addToQueue(nr,r.loc.priority,r.url);
       continue;
      }

  } /* hlavicky */
 if(httprc!=200) {s.close();
                  done();
                  log("Error "+httprc,mask.LOG_ERR);
                  return;
                 }

 /* ***** SAVE as ******** */
 if( r.act!=mask.ACT_NOSAVE && readonly==false)
 {
   try
   {
     dos=new DataOutputStream(new BufferedOutputStream(local.getOutputStream(),IO_BUFFER));
     log("Saving",mask.LOG_SAVE);
    }
   catch (IOException iof)
   {
      log("Save error",mask.LOG_ERR);
      dos=null;
   }
 } /* open file 4 save stuff */
} /* end if load from hadr */

 // muzeme tedy zacit zpracovavat data
 if(r.act==mask.ACT_NOPARSE || r.depth==-1)
  {
   // jen ulozit a ahoj :)
   saver(dis,dos);
   done();
   return;
  }

  /* **** P A R S E     E N G I N E **** */
  /* (hacked from watchit)               */

  htmlscanner hscan;
  if(!compressed) 
      hscan=new htmlscanner(dis,dos);
  else 
      hscan=new htmlscanner(new java.util.zip.GZIPInputStream(dis,4096),dos);

  log("Parsing",mask.LOG_PARSE);

  Vector urls=new Vector();
  Vector srcs=new Vector();
  StringBuffer content=new StringBuffer(15000);
  boolean anyframe=false;
  while(true)
    {
      Hashtable x;
      String s1;
      try{
        x=hscan.getElement();
      if(x==null) break; // EOF?
      line=(String)x.get("");
      if(line==null) continue; // null tag? TODO: can it ever hapen?
      
      s1=(String)x.get(htmlscanner.CONTENT);

      if (s1 != null)
      {
	  content.append(" ");
	  content.append(s1);
      }

      //System.out.println("tag="+line+", content="+s1);

      if(line.equals("FRAME")) anyframe=true;

      /* META - REFRESH HANDLER */
      if(line.equals("META"))
      {
        s1=(String)x.get("HTTP-EQUIV");
        if(s1==null) continue;
        s1=s1.trim();
        if(!s1.equalsIgnoreCase("Refresh")) continue;
        s1=(String)x.get("CONTENT");
        if(s1==null) continue;
        s1=s1.trim();
        int j;
        j=s1.indexOf(';');
        if(j==-1) continue;
        try
        {
         j=Integer.valueOf(s1.substring(0,j)).intValue();
        }
        catch (NumberFormatException z)
         {
          continue;
         }
        /* vice nez XX sekund - ignorujeme to */
        if(j>45) continue;
        j=s1.indexOf('=');
        if(j==-1) continue;

        s1=s1.substring(j+1).trim();
        URL url2;
        try{
            url2=new URL(target,s1);
           }
        catch (MalformedURLException e)
         { continue;}

        urls.addElement(url2);
        srcs.addElement("REFRESH");
        anyframe=true;

        // System.out.println("Redirecting (via REFRESH) : "+this.URL+" to "+s);

        continue;

      } /* end: META html redirect */
      else if(line.equals("BODY"))
      {
         s1=(String)x.get("BACKGROUND");
         if(s1==null) continue;
	 line="IMG"; /* CHECK: cheat it as IMG ?! */
         // System.out.println("BODY...BG="+s);
      }
      else if(line.equals("BASE"))
      {
         s1=(String)x.get("HREF");
         if(s1==null) continue;
	 try{
		target=new URL(s1);
	     }
	 catch (MalformedURLException e)
	     { }
	 continue;
      }
      else
      {
        /* SRC a HREF generic handler */
        s1=(String)x.get("SRC");
        if(s1==null) {
                      s1=(String)x.get("HREF");
                      if(s1==null) continue;
                    }
      }
      /* vyrob URL */
      URL url2;
      url2=null;
      try{
            url2=new URL(target,s1);
         }
      catch (MalformedURLException e)
         {
	     continue;
	 }

      urls.addElement(url2);
      srcs.addElement(line);
      // System.out.println("added URL:"+url2);
      }
      catch (EOFException e) {break;}
    }
    hscan.close();
    /* HTML parse hotovo */
   
   if(r.loc.extractmasks != null)
   {
       /* Dekodovat content */
       content=new StringBuffer(Translate.decode(content));
       /* Nazbirat URL z textu */
       for(int i=0;i<r.loc.extractmasks.length;i++)
       {
	   Matcher m,m2;
	   StringBuffer newurl;

	   m=r.loc.extractmasks[i].matcher(content);
	   while(m.find())
	   {
	       if(r.loc.extractreplaces[i] == null)
	       {
		  // System.out.println("Extracted URL="+m.group());
		  urls.addElement(m.group());
		  srcs.addElement("CONTENT");
	       } else
	       {
		  m2=r.loc.extractmasks[i].matcher(m.group());
		  if (! m2.find())
		     continue;
		  newurl=new StringBuffer(120);
		  m2.appendReplacement(newurl, r.loc.extractreplaces[i]);
		  // System.out.println("Extract/replaced URL"+newurl);
		  urls.addElement(newurl);
		  srcs.addElement("CONTENT");
	       }
	   }
       }
   }
   if(anyframe==true) r.depth++;

   /* prebrat nazbirana URL */
   /*    odstranit mailto:*
         odstranit  #neco
         resolvnout MOJE (location) DNS aliasy

         predelat Vector na Stringy ....
   */

   vectscan:for(int i=urls.size()-1;i>=0;i--)
    {
     line=urls.elementAt(i).toString();
     if(line.startsWith("mailto"))
       { urls.removeElementAt(i);srcs.removeElementAt(i);continue;}
     if(r.loc.aliases!=null)
      {
       //unaliasing
       findalias:for(int x=r.loc.aliases.length-1;x>=0;x--)
        if(line.startsWith(r.loc.aliases[x]))
         {
	
           // System.out.println("URL: "+line);
	   line=r.loc.locbase+line.substring(r.loc.aliases[x].length());
           // System.out.println("\tdealiased as "+line);
          // urls.setElementAt(line,i);
           break findalias;
         }

      } /* dealiasing */
      byte v[];
      int ln=line.length();
      v=new byte[ln];
      line.getBytes(0,ln,v,0);

     scanhash:for(int z=0;z<ln;z++)
      switch(v[z])
      {
       case 0x23:
       case 0x0d:
       case 0x0a:
       case 0x20:
        line=line.substring(0,z);break scanhash;
      }

     urls.setElementAt(line,i);
    }

    // zpracovat URLs
    for(int i=urls.size()-1;i>=0;i--)
    {
     String mybase=target.getProtocol()+"://"+target.getHost();
     String mydir=util.getDirname(target.getFile());
     line=(String)urls.elementAt(i);
     if(visited.get(line)!=null) continue; // already visited
     if(r.loc.rememberseen) visited.put(line,line);
     if(r.loc.processURL(mybase,mydir,r.depth,r.depthset,line,(String)srcs.elementAt(i)))
     {
	 /* insert it to referers also */
         visited.put(line,line);
	 referers.put(line,r.url);
     }
    }

    // dump print URLs
    /*
    for(int i=urls.size()-1;i>=0;i--)
    {
       System.out.println(srcs.elementAt(i)+" = "+urls.elementAt(i));
    }
    */

  }
  catch (Exception ignore)
  {
   System.err.print("Loader got "+ignore+" when loading "+r.url);
   if(!(ignore instanceof java.io.IOException)) ignore.printStackTrace();
   if(!(ignore instanceof java.net.MalformedURLException))
   {
      if(r.retry++<maxretry)
      {
         System.err.print(", re-inserting to queue for retry");
         pq.push(r,retryprio);
      }
   }
   System.err.println("");

  }

  // release lock
  synchronized(pq)
  {
   now--;
   pq.notify();
  }
 }

private final void sendHTTPrequest(InetAddress adr,int port,String host,String request) throws IOException
{
   s=new Socket(adr,port);
   DataOutputStream dos;
   String rf;
   // otevrit data output stream
   dos=new DataOutputStream(new BufferedOutputStream(s.getOutputStream(),1024));

   // send request
   StringBuffer sb;
   sb=new StringBuffer(1024);
   sb.append("GET ");
   sb.append(request);
   sb.append(" HTTP/1.0\r\nAccept: */*\r\nAccept-encoding: gzip\r\n"+useragent);
   if (host != null) sb.append("Host: "+host+"\r\n");
   if (r.update==mask.UPD_RELOAD|| r.update==mask.UPD_FORCEUPDATE)
        sb.append("Pragma: no-cache\r\n");
   rf=(String)referers.get(request);
   if (rf!=null)
   {
       sb.append("Referer: ");
       sb.append(rf);
       sb.append("\r\n");
       // System.out.println(rf+" -> "+request);
   }
   sb.append("\r\n");
   dos.writeBytes(sb.toString());
   dos.flush();
   // System.gc();
}

private final static void done()
{
   // release lock
  synchronized(pq)
  {
   now--;
   pq.notify();
  }
}

 private final static void addToQueue(request r,float prio,String referer)
 {
  if(-1==pq.search(r) && visited.get(r.url)==null)
  {
          //System.err.println("puting to queue");
           visited.put(r.url,r.url);
	   pq.push(r,prio);
	   if(referer!=null) referers.put(r.url,referer);
  }
 }

 public final static void start()
 {
  //System.out.println("Starting main loop.");
  Thread.currentThread().setPriority(Thread.MAX_PRIORITY-2);
  synchronized(pq)
  {

  runloop:while(true)
  {
       if(maxThreads==now)
           try {
                 pq.wait();
               }
           catch (InterruptedException leaveUsAlonePlease) {}
       else
       {
          // musime spustit dalsi
          request r;
          try
          {
            r=(request)pq.pop();
          }
          catch (NoSuchElementException nse)
          {
             if(now>0)  // fronta prazdna a nejake jeste bezi...
                 try 
		 {
                     pq.wait();  // wait for one runner exit
                 }
                 catch (InterruptedException leaveUsAlonePlease) {}
             else break; /* no runners anymore, exit loop */
             continue; // don't start new thread
          }

          // RUN NEW REQUEST
          // System.out.println("Starting thread to fetch "+r.url);
          Thread t;
          t=new Thread(new loader(r));
          t.setPriority(Thread.NORM_PRIORITY);
          t.start();
          now++;
       }
  } /* runloop */
  } /* sync lock */
 }

 private final static void saver(DataInputStream sin,DataOutputStream out) throws IOException
 {
 /* otocime to, cteme data ze serveru a posilame je klientu */
 while(true)
 {
  byte b[]=new byte[IO_BUFFER];
  int rb;
  rb=sin.read(b);
  if(rb==-1) break; /* konec dat! */
  if(out!=null) out.write(b,0,rb);
 }
 if(out!=null) out.close();
 sin.close();
 }

 private final void log(String what,short msk)
 {
   if( (this.r.log&msk)>0 )
     {
       if( (this.r.log&mask.LOG_URLONLY)>0 )
	       System.out.println(r.url);
       else
       {
	         
		 System.out.print(what);
		 if( (this.r.log&mask.LOG_DEPTH)>0 )
		     System.out.print(",depth "+this.r.depth);
		 System.out.println(": "+r.url);
       }
     }
 }

 private final static void configloader(String cfgfile)
 {
  configloader cfg;
  try
  {
    cfg=new configloader(cfgfile);
  }
  catch (IOException grrrr)
   { System.err.println("[CONFIG_ERROR] Error reading config file "+cfgfile);
     loc=new location[0];
     return;
   }

  /* loader init */
  loc=cfg.getLocations();
  def=cfg.getDefaultLocation();
  maxThreads=cfg.getThreads();
  maxretry=cfg.getMaxretry();
  retryprio=cfg.getRetryPriority();

  /* proxy */
  proxyserver=cfg.getProxyServer();
  proxyport=cfg.getProxyPort();

  store=cfg.getLocalStore();
 }

 private final static location createNewLocation(String baseurl,location ol)
 {
   // search
   location nl;
   if(ol==null) return new location(baseurl,def);
   System.err.println("Location "+baseurl+" configured as "+ol.locbase);
   nl=new location(baseurl,ol);
   return nl;
 }

 private final static location findLocation(String baseurl)
 {
   // search
   location nl;
   for(int i=0;i<loc.length;i++)
   {
    if(baseurl.indexOf(loc[i].locbase)==0)
        return loc[i];
    if(loc[i].aliases==null) continue;
    for(int j=0;j<loc[i].aliases.length;j++)
      if(baseurl.indexOf(loc[i].aliases[j])==0) return loc[i];
   }	
  return null;
 }
}
