/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.StringTokenizer;
import java.util.zip.CRC32;

public class scachestore
extends localstore {
    private String scacheroot;
    private int swap_level1_dirs;
    private int swap_level2_dirs;
    private LruHashtable dircache;

    protected void localinit() {
        this.swap_level2_dirs = 4;
        this.swap_level1_dirs = 4;
        this.scacheroot = "store";
        this.smartcacheconfig(this.arg[0]);
        this.dircache = new LruHashtable(25);
    }

    public String toString() {
        return "Smart Cache directory storage";
    }

    public boolean isReadOnly() {
        return true;
    }

    public void close() {
        if (this.dircache == null) {
            return;
        }
        this.dircache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public localurl getURL(String string) throws MalformedURLException {
        String[] stringArray = scachestore.parseURL(string);
        String string2 = this.getLocalDir(stringArray[0], stringArray[1], stringArray[2], stringArray[4]);
        minicachedir minicachedir2 = null;
        scachestore scachestore2 = this;
        synchronized (scachestore2) {
            minicachedir2 = (minicachedir)this.dircache.get(string2);
            if (minicachedir2 != null) return minicachedir2.getObject(stringArray[3]);
            minicachedir2 = new minicachedir(string2);
            this.dircache.put(string2, minicachedir2);
            return minicachedir2.getObject(stringArray[3]);
        }
    }

    private final void smartcacheconfig(String string) {
        try {
            String string2;
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(string)));
            System.err.println("[CONFIG] Processing Smart_Cache config file " + string);
            while ((string2 = dataInputStream.readLine()) != null) {
                StringTokenizer stringTokenizer;
                if (string2.startsWith("#") || !(stringTokenizer = new StringTokenizer(string2)).hasMoreTokens()) continue;
                String string3 = stringTokenizer.nextToken().toLowerCase();
                if (string3.equals("swap_level1_dirs")) {
                    this.swap_level1_dirs = Integer.valueOf(stringTokenizer.nextToken());
                    continue;
                }
                if (string3.equals("swap_level2_dirs")) {
                    this.swap_level2_dirs = Integer.valueOf(stringTokenizer.nextToken());
                    continue;
                }
                if (!string3.equals("cache_dir") && !string3.equals("cacheroot")) continue;
                this.scacheroot = stringTokenizer.nextToken();
                if (this.scacheroot.charAt(1) == ':' || this.scacheroot.charAt(0) == File.separatorChar) continue;
                System.err.println("[CONFIG_WARNING] SmartCache root is not absolute path, may not work");
            }
            if (this.scacheroot != null && (this.swap_level1_dirs == 0 || this.swap_level2_dirs == 0)) {
                this.scacheroot = null;
            }
            dataInputStream.close();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Can not read Smart Cache config file: " + string);
        }
    }

    private final String getLocalDir(String string, String string2, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer(80);
        stringBuffer.append(this.scacheroot);
        CRC32 cRC32 = new CRC32();
        cRC32.update(string.getBytes());
        int n = (int)(cRC32.getValue() / (0x100000000L / (long)(this.swap_level1_dirs * this.swap_level2_dirs)));
        stringBuffer.append(File.separator + n / this.swap_level2_dirs + File.separator + n % this.swap_level2_dirs + File.separator + string);
        if (string2 != null) {
            stringBuffer.append('_');
            stringBuffer.append(string2);
        }
        if (string4 != null) {
            stringBuffer.append('^');
            stringBuffer.append(string4);
        }
        if (File.separatorChar != '/') {
            string3 = string3.replace('/', File.separatorChar);
        }
        string3 = string3.replace('|', '!');
        stringBuffer.append(string3);
        return stringBuffer.toString();
    }

    public scachestore(String[] stringArray) {
        super(stringArray);
    }
}

