#
# @file    TestSpeciesConcentrationRule.py
# @brief   SpeciesConcentrationRule unit tests
#
# @author  Akiya Jouraku (Python conversion)
# @author  Ben Bornstein 
#
# $Id: TestSpeciesConcentrationRule.py 11368 2010-07-02 21:38:11Z mhucka $
# $HeadURL: http://sbml.svn.sourceforge.net/svnroot/sbml/trunk/libsbml/src/bindings/python/test/sbml/TestSpeciesConcentrationRule.py $
#
# ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
#
# DO NOT EDIT THIS FILE.
#
# This file was generated automatically by converting the file located at
# src/sbml/test/TestSpeciesConcentrationRule.c
# using the conversion program dev/utilities/translateTests/translateTests.pl.
# Any changes made here will be lost the next time the file is regenerated.
#
# -----------------------------------------------------------------------------
# This file is part of libSBML.  Please visit http://sbml.org for more
# information about SBML, and the latest version of libSBML.
#
# Copyright 2005-2010 California Institute of Technology.
# Copyright 2002-2005 California Institute of Technology and
#                     Japan Science and Technology Corporation.
# 
# This library is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation.  A copy of the license agreement is provided
# in the file named "LICENSE.txt" included with this software distribution
# and also available online as http://sbml.org/software/libsbml/license.html
# -----------------------------------------------------------------------------

import sys
import unittest
import libsbml


class TestSpeciesConcentrationRule(unittest.TestCase):

  global SCR
  SCR = None

  def setUp(self):
    self.SCR = libsbml.AssignmentRule(1,2)
    self.SCR.setL1TypeCode(libsbml.SBML_SPECIES_CONCENTRATION_RULE)
    if (self.SCR == None):
      pass    
    pass  

  def tearDown(self):
    _dummyList = [ self.SCR ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SpeciesConcentrationRule_create(self):
    self.assert_( self.SCR.getTypeCode() == libsbml.SBML_ASSIGNMENT_RULE )
    self.assert_( self.SCR.getL1TypeCode() == libsbml.SBML_SPECIES_CONCENTRATION_RULE )
    self.assert_( self.SCR.getNotes() == None )
    self.assert_( self.SCR.getAnnotation() == None )
    self.assert_( self.SCR.getFormula() == "" )
    self.assert_( self.SCR.getType() == libsbml.RULE_TYPE_SCALAR )
    self.assert_( self.SCR.getVariable() == "" )
    self.assertEqual( False, self.SCR.isSetVariable() )
    pass  

  def test_SpeciesConcentrationRule_free_NULL(self):
    _dummyList = [ None ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SpeciesConcentrationRule_setSpecies(self):
    species =  "s2";
    self.SCR.setVariable(species)
    self.assert_(( species == self.SCR.getVariable() ))
    self.assertEqual( True, self.SCR.isSetVariable() )
    if (self.SCR.getVariable() == species):
      pass    
    s = self.SCR.getVariable()
    self.SCR.setVariable(s)
    self.assert_(( species == self.SCR.getVariable() ))
    self.SCR.setVariable("")
    self.assertEqual( False, self.SCR.isSetVariable() )
    if (self.SCR.getVariable() != None):
      pass    
    pass  

def suite():
  suite = unittest.TestSuite()
  suite.addTest(unittest.makeSuite(TestSpeciesConcentrationRule))

  return suite

if __name__ == "__main__":
  if unittest.TextTestRunner(verbosity=1).run(suite()).wasSuccessful() :
    sys.exit(0)
  else:
    sys.exit(1)
