/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.0
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * Methods for checking syntax of SBML identifiers and other strings.
 * <p>
 * <em style='color: #555'>
This class of objects is defined by libSBML only and has no direct
equivalent in terms of SBML components.  This class is not prescribed by
the SBML specifications, although it is used to implement features
defined in SBML.
</em>

 * <p>
 * This utility class provides static methods for checking the syntax of
 * identifiers and other text used in an SBML model.  The methods allow
 * callers to verify that strings such as SBML identifiers and XHTML notes
 * text conform to the SBML specifications.
 */

public class SyntaxChecker {
   private long swigCPtr;
   protected boolean swigCMemOwn;

   protected SyntaxChecker(long cPtr, boolean cMemoryOwn)
   {
     swigCMemOwn = cMemoryOwn;
     swigCPtr    = cPtr;
   }

   protected static long getCPtr(SyntaxChecker obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (SyntaxChecker obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_SyntaxChecker(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  
  /**
   * Returns true <code>true</code> or <code>false</code> depending on whether the argument
   * string conforms to the syntax of SBML identifiers.
   * <p>
   * In SBML, identifiers that are the values of <code>id</code> attributes
   * on objects must conform to a data type called <code>SId</code> in the
   * SBML specifications.  LibSBML does not provide an explicit
   * <code>SId</code> data type; instead, it tests for identifier validity
   * at various times, such as when reading in models from files and data
   * streams.  To enable calling programs to test that the identifiers they
   * generate also conform to the SBML identifier syntax, libSBML provides
   * this method.
   * <p>
   * @param sid string to be checked for conformance to SBML identifier
   * syntax.
   * <p>
   * @return <code>true</code> if the string conforms to type SBML data type
   * <code>SId</code>, <code>false</code> otherwise.
   * <p>
   * @note The following is a summary of the definition of the SBML identifier type 
<code>SId</code>, which defines the permitted syntax of identifiers.  We
express the syntax using an extended form of BNF notation: 
<p>
<code style='margin-left: 2em'>letter .= 'a'..'z','A'..'Z'</code><br>
<code style='margin-left: 2em'>digit  .= '0'..'9'</code><br>
<code style='margin-left: 2em'>idChar .= letter | digit | '_'</code><br>
<code style='margin-left: 2em'>SId    .= ( letter | '_' ) idChar*</code><br>
<p>
The characters <code>(</code> and <code>)</code> are used for grouping, the
character <code>*</code> 'zero or more times', and the character
<code>|</code> indicates logical 'or'.  The equality of SBML identifiers is
determined by an exact character sequence match; i.e., comparisons must be
performed in a case-sensitive manner.  In addition, there are a few
conditions for the uniqueness of identifiers in an SBML model.  Please
consult the SBML specifications for the exact formulations.
<p>

   * <p>
   * @see #isValidUnitSId(String sid)
   * @see #isValidXMLID(String sid)
   */
 public static boolean isValidSBMLSId(String sid) {
    return libsbmlJNI.SyntaxChecker_isValidSBMLSId(sid);
  }

  
  /**
   * Returns <code>true</code> or <code>false</code> depending on whether the argument string
   * conforms to the XML data type <code>ID</code>.
   * <p>
   * In SBML, identifiers that are the values of <code>metaid</code>
   * attributes on objects must conform to the <a target='_blank' 
   * href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a> data type.  LibSBML
   * does not provide an explicit XML <code>ID</code> data type; instead,
   * it tests for identifier validity at various times, such as when
   * reading in models from files and data streams.  To enable calling
   * programs to test that the identifiers they generate also conform to
   * the SBML identifier syntax, libSBML provides this method.
   * <p>
   * @param id string to be checked for conformance to the syntax of
   * <a target='_blank' href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>.
   * <p>
   * @return <code>true</code> if the string is a syntactically-valid value for the
   * XML type <a target='_blank'
   * href='http://www.w3.org/TR/REC-xml/#id'>ID</a>, <code>false</code> otherwise.
   * <p>
   * @note The following is a summary of the definition of the XML&nbsp;1.0 data type
<a target='_blank' href='http://www.w3.org/TR/REC-xml/#id'>ID</a>.  We
express the syntax using an extended form of BNF notation:
<p>
<nobr><code style='margin-left: 2em'>NCNameChar .= letter | digit | '.' | '-' | '_' | ':' | CombiningChar | Extender</code><br></nobr>
<code style='margin-left: 2em'>ID .= ( letter | '_' | ':' ) NCNameChar*</code><br>
<p>
The characters <code>(</code> and <code>)</code> are used for grouping, the
character <code>*</code> means 'zero or more times', and the character
<code>|</code> indicates logical 'or'. The production <code>letter</code>
consists of the basic upper and lower case alphabetic characters of the
Latin alphabet along with a large number of related characters defined by
Unicode&nbsp;2.0; similarly, the production <code>digit</code> consists of
the numerals <code>0..9</code> along with related Unicode&nbsp;2.0
characters.  The <code>CombiningChar</code> production is a list of
characters that add such things as accents to the preceding character. (For
example, the Unicode character <code>\#x030A</code> when combined with
<code>a</code> produces <code>a</code>.)  The <code>Extender</code>
production is a list of characters that extend the shape of the preceding
character.  Please consult the <a target='_blank'
href='http://www.w3.org/TR/2004/REC-xml-20040204/'>XML&nbsp;1.0
specification</a> for the complete definitions of <code>letter</code>,
<code>digit</code>, <code>CombiningChar</code>, and <code>Extender</code>.
<p>

   * <p>
   * @see #isValidSBMLSId(String sid)
   * @see #isValidUnitSId(String sid)
   */
 public static boolean isValidXMLID(String id) {
    return libsbmlJNI.SyntaxChecker_isValidXMLID(id);
  }

  
  /**
   * Returns <code>true</code> or <code>false</code> depending on whether the argument string
   * conforms to the syntax of SBML unit identifiers.
   * <p>
   * In SBML, the identifiers of units (of both the predefined units and
   * user-defined units) must conform to a data type called
   * <code>UnitSId</code> in the SBML specifications.  LibSBML does not
   * provide an explicit <code>UnitSId</code> data type; instead, it tests
   * for identifier validity at various times, such as when reading in
   * models from files and data streams.  To enable calling programs to
   * test that the unit identifiers they generate also conform to the SBML
   * identifier syntax, libSBML provides this method.
   * <p>
   * @param units string to be checked for conformance to SBML unit
   * identifier syntax.
   * <p>
   * @return <code>true</code> if the string conforms to type SBML data type
   * <code>UnitSId</code>, <code>false</code> otherwise.
   * <p>
   * @note The following is a summary of the definition of the SBML identifier type
<code>UnitSId</code>, which defines the permitted syntax of identifiers.
We express the syntax using an extended form of BNF notation:
<p>
<code style='margin-left: 2em'>letter .= 'a'..'z','A'..'Z'</code><br>
<code style='margin-left: 2em'>digit  .= '0'..'9'</code><br>
<code style='margin-left: 2em'>idChar .= letter | digit | '_'</code><br>
<code style='margin-left: 2em'>SId    .= ( letter | '_' ) idChar*</code><br>
<p>
The characters <code>(</code> and <code>)</code> are used for grouping, the
character <code>*</code> 'zero or more times', and the character
<code>|</code> indicates logical 'or'.  The equality of SBML unit
identifiers is determined by an exact character sequence match; i.e.,
comparisons must be performed in a case-sensitive manner.  In addition,
there are a few conditions for the uniqueness of unit identifiers in an
SBML model.  Please consult the SBML specifications for the exact
formulations.
<p>

   * <p>
   * @see #isValidSBMLSId(String sid)
   * @see #isValidXMLID(String sid)
   */
 public static boolean isValidUnitSId(String units) {
    return libsbmlJNI.SyntaxChecker_isValidUnitSId(units);
  }

  
  /**
   * Returns <code>true</code> or <code>false</code> depending on whether the given {@link XMLNode}
   * object contains valid XHTML content.
   * <p>
   * In SBML, the content of the 'notes' subelement available on {@link SBase}, as
   * well as the 'message' subelement available on {@link Constraint}, must conform
   * to <a target='_blank'
   * href='http://www.w3.org/TR/xhtml1/'>XHTML&nbsp;1.0</a> (which is
   * simply an XML-ized version of HTML).  However, the content cannot be
   * <em>entirely</em> free-form; it must satisfy certain requirements defined in
   * the <a target='_blank'
   * href='http://sbml.org/Documents/Specifications'>SBML
   * specifications</a> for specific SBML Levels.  This method implements a
   * verification process that lets callers check whether the content of a
   * given {@link XMLNode} object conforms to the SBML requirements for 'notes' and
   * 'message' structure.
   * <p>
   * An aspect of XHTML validity is that the content is declared to be in
   * the XML namespace for XHTML&nbsp;1.0.  There is more than one way in
   * which this can be done in XML.  In particular, a model might not
   * contain the declaration within the 'notes' or 'message' subelement
   * itself, but might instead place the declaration on an enclosing
   * element and use an XML namespace prefix within the 'notes' element to
   * refer to it.  In other words, the following is valid:
   * <div class='fragment'><pre>
&lt;sbml xmlns='http://www.sbml.org/sbml/level2/version3' level='2' version='3'
      xmlns:xhtml='http://www.w3.org/1999/xhtml'&gt;
  &lt;model&gt;
    &lt;notes&gt;
      &lt;xhtml:body&gt;
        &lt;xhtml:center&gt;&lt;xhtml:h2&gt;A Simple Mitotic Oscillator&lt;/xhtml:h2&gt;&lt;/xhtml:center&gt;
        &lt;xhtml:p&gt;A minimal cascade model for the mitotic oscillator.&lt;/xhtml:p&gt;
      &lt;/xhtml:body&gt;
    &lt;/notes&gt;
  ... rest of model ...
&lt;/sbml&gt;
</pre></div>
   * Contrast the above with the following, self-contained version, which
   * places the XML namespace declaration within the <code>&lt;notes&gt;</code>
   * element itself:
   * <div class='fragment'><pre>
&lt;sbml xmlns='http://www.sbml.org/sbml/level2/version3' level='2' version='3'&gt;
  &lt;model&gt;
    &lt;notes&gt;
      &lt;html xmlns='http://www.w3.org/1999/xhtml'&gt;
        &lt;head&gt;
          &lt;title/&gt;
        &lt;/head&gt;
        &lt;body&gt;
          &lt;center&gt;&lt;h2&gt;A Simple Mitotic Oscillator&lt;/h2&gt;&lt;/center&gt;
          A minimal cascade model for the mitotic oscillator.&lt;/p&gt;
        &lt;/body&gt;
      &lt;/html&gt;
    &lt;/notes&gt;
  ... rest of model ...
&lt;/sbml&gt;
</pre></div>
   * <p>
   * Both of the above are valid XML.  The purpose of the <code>sbmlns</code>
   * argument to this method is to allow callers to check the validity of
   * 'notes' and 'message' subelements whose XML namespace declarations
   * have been put elsewhere in the manner illustrated above.  Callers can
   * can pass in the {@link SBMLNamespaces} object of a higher-level model
   * component if the {@link XMLNode} object does not itself have the XML namespace
   * declaration for XHTML&nbsp;1.0.
   * <p>
   * @param xhtml the {@link XMLNode} to be checked for conformance.
   * @param sbmlns the {@link SBMLNamespaces} associated with the object.
   * <p>
   * @return <code>true</code> if the {@link XMLNode} content conforms, <code>false</code> otherwise.
   * <p>
   * @docnote The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.

   */
 public static boolean hasExpectedXHTMLSyntax(XMLNode xhtml, SBMLNamespaces sbmlns) {
    return libsbmlJNI.SyntaxChecker_hasExpectedXHTMLSyntax__SWIG_0(XMLNode.getCPtr(xhtml), xhtml, SBMLNamespaces.getCPtr(sbmlns), sbmlns);
  }

  
  /**
   * Returns <code>true</code> or <code>false</code> depending on whether the given {@link XMLNode}
   * object contains valid XHTML content.
   * <p>
   * In SBML, the content of the 'notes' subelement available on {@link SBase}, as
   * well as the 'message' subelement available on {@link Constraint}, must conform
   * to <a target='_blank'
   * href='http://www.w3.org/TR/xhtml1/'>XHTML&nbsp;1.0</a> (which is
   * simply an XML-ized version of HTML).  However, the content cannot be
   * <em>entirely</em> free-form; it must satisfy certain requirements defined in
   * the <a target='_blank'
   * href='http://sbml.org/Documents/Specifications'>SBML
   * specifications</a> for specific SBML Levels.  This method implements a
   * verification process that lets callers check whether the content of a
   * given {@link XMLNode} object conforms to the SBML requirements for 'notes' and
   * 'message' structure.
   * <p>
   * An aspect of XHTML validity is that the content is declared to be in
   * the XML namespace for XHTML&nbsp;1.0.  There is more than one way in
   * which this can be done in XML.  In particular, a model might not
   * contain the declaration within the 'notes' or 'message' subelement
   * itself, but might instead place the declaration on an enclosing
   * element and use an XML namespace prefix within the 'notes' element to
   * refer to it.  In other words, the following is valid:
   * <div class='fragment'><pre>
&lt;sbml xmlns='http://www.sbml.org/sbml/level2/version3' level='2' version='3'
      xmlns:xhtml='http://www.w3.org/1999/xhtml'&gt;
  &lt;model&gt;
    &lt;notes&gt;
      &lt;xhtml:body&gt;
        &lt;xhtml:center&gt;&lt;xhtml:h2&gt;A Simple Mitotic Oscillator&lt;/xhtml:h2&gt;&lt;/xhtml:center&gt;
        &lt;xhtml:p&gt;A minimal cascade model for the mitotic oscillator.&lt;/xhtml:p&gt;
      &lt;/xhtml:body&gt;
    &lt;/notes&gt;
  ... rest of model ...
&lt;/sbml&gt;
</pre></div>
   * Contrast the above with the following, self-contained version, which
   * places the XML namespace declaration within the <code>&lt;notes&gt;</code>
   * element itself:
   * <div class='fragment'><pre>
&lt;sbml xmlns='http://www.sbml.org/sbml/level2/version3' level='2' version='3'&gt;
  &lt;model&gt;
    &lt;notes&gt;
      &lt;html xmlns='http://www.w3.org/1999/xhtml'&gt;
        &lt;head&gt;
          &lt;title/&gt;
        &lt;/head&gt;
        &lt;body&gt;
          &lt;center&gt;&lt;h2&gt;A Simple Mitotic Oscillator&lt;/h2&gt;&lt;/center&gt;
          A minimal cascade model for the mitotic oscillator.&lt;/p&gt;
        &lt;/body&gt;
      &lt;/html&gt;
    &lt;/notes&gt;
  ... rest of model ...
&lt;/sbml&gt;
</pre></div>
   * <p>
   * Both of the above are valid XML.  The purpose of the <code>sbmlns</code>
   * argument to this method is to allow callers to check the validity of
   * 'notes' and 'message' subelements whose XML namespace declarations
   * have been put elsewhere in the manner illustrated above.  Callers can
   * can pass in the {@link SBMLNamespaces} object of a higher-level model
   * component if the {@link XMLNode} object does not itself have the XML namespace
   * declaration for XHTML&nbsp;1.0.
   * <p>
   * @param xhtml the {@link XMLNode} to be checked for conformance.
   * @param sbmlns the {@link SBMLNamespaces} associated with the object.
   * <p>
   * @return <code>true</code> if the {@link XMLNode} content conforms, <code>false</code> otherwise.
   * <p>
   * @docnote The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.

   */
 public static boolean hasExpectedXHTMLSyntax(XMLNode xhtml) {
    return libsbmlJNI.SyntaxChecker_hasExpectedXHTMLSyntax__SWIG_1(XMLNode.getCPtr(xhtml), xhtml);
  }

  public SyntaxChecker() {
    this(libsbmlJNI.new_SyntaxChecker(), true);
  }

}
