/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.40
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * LibSBML implementation of SBML's Rule construct.
 * <p>
 * In SBML, <em>rules</em> provide additional ways to define the values of
 * variables in a model, their relationships, and the dynamical behaviors
 * of those variables.  They enable encoding relationships that cannot be
 * expressed using {@link Reaction} nor {@link InitialAssignment} objects alone.
 * <p>
 * The libSBML implementation of rules mirrors the SBML Level&nbsp;3
 * Version&nbsp;1 Core definition (which is in turn is very similar to the
 * Level&nbsp;2 Version&nbsp;4 definition), with {@link Rule} being the parent
 * class of three subclasses as explained below.  The {@link Rule} class itself
 * cannot be instantiated by user programs and has no constructor; only the
 * subclasses {@link AssignmentRule}, {@link AlgebraicRule} and {@link RateRule} can be
 * instantiated directly.
 * <p>
 * <h2>General summary of SBML rules</h2>
 * <p>
 * In SBML Level&nbsp;3 as well as Level&nbsp;2, rules are separated into
 * three subclasses for the benefit of model analysis software.  The three
 * subclasses are based on the following three different possible
 * functional forms (where <em>x</em> is a variable, <em>f</em> is some
 * arbitrary function returning a numerical result, <b><em>V</em></b> is a
 * vector of variables that does not include <em>x</em>, and
 * <b><em>W</em></b> is a vector of variables that may include <em>x</em>):
 * <p>
 * <center>
 * <table border='0' cellpadding='0' style='font-size: small'>
 * <tr><td width='120px'><em>Algebraic:</em></td><td width='250px'>left-hand side is zero</td><td><em>0 = f(<b>W</b>)</em></td></tr>
 * <tr><td><em>Assignment:</em></td><td>left-hand side is a scalar:</td><td><em>x = f(<b>V</b>)</em></td></tr>
 * <tr><td><em>Rate:</em></td><td>left-hand side is a rate-of-change:</td><td><em>dx/dt = f(<b>W</b>)</em></td></tr>
 * </table>
 * </center>
 * <p>
 * In their general form given above, there is little to distinguish
 * between <em>assignment</em> and <em>algebraic</em> rules.  They are treated as
 * separate cases for the following reasons:
 * <p>
 * <ul>
 * <li> <em>Assignment</em> rules can simply be evaluated to calculate
 * intermediate values for use in numerical methods.  They are statements
 * of equality that hold at all times.  (For assignments that are only
 * performed once, see {@link InitialAssignment}.)<p>
 * <p>
 * <li> SBML needs to place restrictions on assignment rules, for example
 * the restriction that assignment rules cannot contain algebraic loops.<p>
 * <p>
 * <li> Some simulators do not contain numerical solvers capable of solving
 * unconstrained algebraic equations, and providing more direct forms such
 * as assignment rules may enable those simulators to process models they
 * could not process if the same assignments were put in the form of
 * general algebraic equations;<p>
 * <p>
 * <li> Those simulators that <em>can</em> solve these algebraic equations make a
 * distinction between the different categories listed above; and<p>
 * <p>
 * <li> Some specialized numerical analyses of models may only be applicable
 * to models that do not contain <em>algebraic</em> rules.
 * </ul>
 * <p>
 * The approach taken to covering these cases in SBML is to define an
 * abstract {@link Rule} structure containing a subelement, 'math', to hold the
 * right-hand side expression, then to derive subtypes of {@link Rule} that add
 * attributes to distinguish the cases of algebraic, assignment and rate
 * rules.  The 'math' subelement must contain a MathML expression defining the
 * mathematical formula of the rule.  This MathML formula must return a
 * numerical value.  The formula can be an arbitrary expression referencing
 * the variables and other entities in an SBML model.
 * <p>
 * Each of the three subclasses of {@link Rule} (AssignmentRule, {@link AlgebraicRule},
 * {@link RateRule}) inherit the the 'math' subelement and other fields from {@link SBase}.
 * The {@link AssignmentRule} and {@link RateRule} classes add an additional attribute,
 * 'variable'.  See the definitions of {@link AssignmentRule}, {@link AlgebraicRule} and
 * {@link RateRule} for details about the structure and interpretation of each one.
 * <p>
 * <h2>Additional restrictions on SBML rules</h2>
 * <p>
 * An important design goal of SBML rule semantics is to ensure that a
 * model's simulation and analysis results will not be dependent on when or
 * how often rules are evaluated.  To achieve this, SBML needs to place two
 * restrictions on rule use.  The first concerns algebraic loops in the system
 * of assignments in a model, and the second concerns overdetermined systems.
 * <p>
 * <h3>A model must not contain algebraic loops</h3>
 * <p>
 * The combined set of {@link InitialAssignment}, {@link AssignmentRule} and {@link KineticLaw}
 * objects in a model constitute a set of assignment statements that should be
 * considered as a whole.  (A {@link KineticLaw} object is counted as an assignment
 * because it assigns a value to the symbol contained in the 'id' attribute of
 * the {@link Reaction} object in which it is defined.)  This combined set of
 * assignment statements must not contain algebraic loops&mdash;dependency
 * chains between these statements must terminate.  To put this more formally,
 * consider a directed graph in which nodes are assignment statements and
 * directed arcs exist for each occurrence of an SBML species, compartment or
 * parameter symbol in an assignment statement's 'math' subelement.  Let the
 * directed arcs point from the statement assigning the symbol to the
 * statements that contain the symbol in their 'math' subelement expressions.
 * This graph must be acyclic.
 * <p>
 * SBML does not specify when or how often rules should be evaluated.
 * Eliminating algebraic loops ensures that assignment statements can be
 * evaluated any number of times without the result of those evaluations
 * changing.  As an example, consider the set of equations <em>x = x + 1</em>,
 * <em>y = z + 200</em> and <em>z = y + 100</em>.  If this set of equations
 * were interpreted as a set of assignment statements, it would be invalid
 * because the rule for <em>x</em> refers to <em>x</em> (exhibiting one type
 * of loop), and the rule for <em>y</em> refers to <em>z</em> while the rule
 * for <em>z</em> refers back to <em>y</em> (exhibiting another type of loop).
 * Conversely, the following set of equations would constitute a valid set of
 * assignment statements: <em>x = 10</em>, <em>y = z + 200</em>, and <em>z = x
 * + 100</em>.
 * <p>
 * <h3>A model must not be overdetermined</h3>
 * <p>
 * An SBML model must not be overdetermined; that is, a model must not
 * define more equations than there are unknowns in a model.  An SBML model
 * that does not contain {@link AlgebraicRule} structures cannot be overdetermined.
 * <p>
 * LibSBML implements the static analysis procedure described in Appendix
 * B of the SBML Level&nbsp;3 Version&nbsp;1 Core specification for assessing
 * whether a model is overdetermined.
 * <p>
 * (In summary, assessing whether a given continuous, deterministic,
 * mathematical model is overdetermined does not require dynamic analysis; it
 * can be done by analyzing the system of equations created from the model.
 * One approach is to construct a bipartite graph in which one set of vertices
 * represents the variables and the other the set of vertices represents the
 * equations.  Place edges between vertices such that variables in the system
 * are linked to the equations that determine them.  For algebraic equations,
 * there will be edges between the equation and each variable occurring in the
 * equation.  For ordinary differential equations (such as those defined by
 * rate rules or implied by the reaction rate definitions), there will be a
 * single edge between the equation and the variable determined by that
 * differential equation.  A mathematical model is overdetermined if the
 * maximal matchings of the bipartite graph contain disconnected vertexes
 * representing equations.  If one maximal matching has this property, then
 * all the maximal matchings will have this property; i.e., it is only
 * necessary to find one maximal matching.)
 * <p>
 * <p>
 * <h2>RuleType_t for SBML Level 1</h2>
 * <p>
 * SBML Level 1 uses a different scheme than SBML Level&nbsp;2 and
 * Level&nbsp;3 for distinguishing rules; specifically, it uses an
 * attribute whose value is drawn from an enumeration.  LibSBML supports
 * this using methods that work with the #RuleType_t enumeration.
 * <p>
 * <p>
 * <center>
 * <table width='90%' cellspacing='1' cellpadding='1' border='0' class='normal-font'>
 *  <tr style='background: lightgray' class='normal-font'>
 *      <td><strong>Enumerator</strong></td>
 *      <td><strong>Meaning</strong></td>
 *  </tr>
 * <tr><td><em>@link RuleType_t#RULE_TYPE_RATE RULE_TYPE_RATE@endlink</em></td><td>Indicates the rule is a 'rate' rule.</td>
 * <tr><td><em>@link RuleType_t#RULE_TYPE_SCALAR RULE_TYPE_SCALAR@endlink</em></td><td>Indicates the rule is a 'scalar' rule.</td>
 * <tr><td><em>@link RuleType_t#RULE_TYPE_INVALID RULE_TYPE_INVALID@endlink</em></td><td>Indicates the rule type is unknown or not
 * yet set.</td>
 * </table>
 * </center>
 * <p>
 * <p>
 * <!-- leave this next break as-is to work around some doxygen bug -->
 */

public class Rule extends SBase {
   private long swigCPtr;

   protected Rule(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.SWIGRuleUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(Rule obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (Rule obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_Rule(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  
  /**
   * Copy constructor; creates a copy of this {@link Rule}.
   */
 public Rule(Rule orig) {
    this(libsbmlJNI.new_Rule(Rule.getCPtr(orig), orig), true);
  }

  
  /**
   * Creates and returns a deep copy of this {@link Rule}.
   * <p>
   * @return a (deep) copy of this {@link Rule}.
   */
 public Rule cloneObject() {
  return (Rule) libsbml.DowncastSBase(libsbmlJNI.Rule_cloneObject(swigCPtr, this), true);
}

  
  /**
   * Returns the mathematical expression of this {@link Rule} in text-string form.
   * <p>
   * The text string is produced by SBML_formulaToString(); please consult
   * the documentation for that function to find out more about the format
   * of the text-string formula.
   * <p>
   * @return the formula text string for this {@link Rule}.
   * <p>
   * @see #getMath()
   * <p>
   * @note The attribute 'formula' is specific to SBML Level&nbsp;1; in
   * higher Levels of SBML, it has been replaced with a subelement named
   * 'math'.  However, libSBML provides a unified interface to the
   * underlying math expression and this method can be used for models
   * of all Levels of SBML.
   */
 public String getFormula() {
    return libsbmlJNI.Rule_getFormula(swigCPtr, this);
  }

  
  /**
   * Get the mathematical formula of this {@link Rule} as an {@link ASTNode} tree.
   * <p>
   * @return an {@link ASTNode}, the value of the 'math' subelement of this {@link Rule}.
   * <p>
   * @see #getFormula()
   * <p>
   * @note The subelement 'math' is present in SBML Levels&nbsp;2
   * and&nbsp;3.  In SBML Level&nbsp;1, the equivalent construct is the
   * attribute named 'formula'.  LibSBML provides a unified interface to
   * the underlying math expression and this method can be used for models
   * of all Levels of SBML.
   */
 public ASTNode getMath() {
    long cPtr = libsbmlJNI.Rule_getMath(swigCPtr, this);
    return (cPtr == 0) ? null : new ASTNode(cPtr, false);
  }

  
  /**
   * Get the value of the 'variable' attribute of this {@link Rule} object.
   * <p>
   * In SBML Level&nbsp;1, the different rule types each have a different
   * name for the attribute holding the reference to the object
   * constituting the left-hand side of the rule.  (E.g., for
   * SpeciesConcentrationRule the attribute is 'species', for
   * CompartmentVolumeRule it is 'compartment', etc.)  In SBML
   * Levels&nbsp;2 and&nbsp;3, the only two types of {@link Rule} objects with a
   * left-hand side object reference are {@link AssignmentRule} and {@link RateRule}, and
   * both of them use the same name for attribute: 'variable'.  In order to
   * make it easier for application developers to work with all Levels of
   * SBML, libSBML uses a uniform name for all of such attributes, and it
   * is 'variable', regardless of whether Level&nbsp;1 rules or
   * Level&nbsp;2&ndash;3 rules are being used.
   * <p>
   * @return the identifier string stored as the 'variable' attribute value
   * in this {@link Rule}, or <code>NULL</code> if this object is an {@link AlgebraicRule} object.
   */
 public String getVariable() {
    return libsbmlJNI.Rule_getVariable(swigCPtr, this);
  }

  
  /**
   * Returns the units for the
   * mathematical formula of this {@link Rule}.
   * <p>
   * @return the identifier of the units for the expression of this {@link Rule}.
   * <p>
   * @note The attribute 'units' exists on SBML Level&nbsp;1 ParameterRule
   * objects only.  It is not present in SBML Levels&nbsp;2 and&nbsp;3.
   */
 public String getUnits() {
    return libsbmlJNI.Rule_getUnits(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> if this
   * {@link Rule}'s mathematical expression has been set.
   * <p>
   * This method is equivalent to isSetMath().  This version is present for
   * easier compatibility with SBML Level&nbsp;1, in which mathematical
   * formulas were written in text-string form.
   * <p>
   * @return <code>true</code> if the mathematical formula for this {@link Rule} has been
   * set, <code>false</code> otherwise.
   * <p>
   * @see #isSetMath()
   * <p>
   * @note The attribute 'formula' is specific to SBML Level&nbsp;1; in
   * higher Levels of SBML, it has been replaced with a subelement named
   * 'math'.  However, libSBML provides a unified interface to the
   * underlying math expression and this method can be used for models
   * of all Levels of SBML.
   */
 public boolean isSetFormula() {
    return libsbmlJNI.Rule_isSetFormula(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> if this
   * {@link Rule}'s mathematical expression has been set.
   * <p>
   * This method is equivalent to isSetFormula().
   * <p>
   * @return <code>true</code> if the formula (or equivalently the math) for this
   * {@link Rule} has been set, <code>false</code> otherwise.
   * <p>
   * @note The subelement 'math' is present in SBML Levels&nbsp;2
   * and&nbsp;3.  In SBML Level&nbsp;1, the equivalent construct is the
   * attribute named 'formula'.  LibSBML provides a unified interface to
   * the underlying math expression and this method can be used for models
   * of all Levels of SBML.
   */
 public boolean isSetMath() {
    return libsbmlJNI.Rule_isSetMath(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> if this
   * {@link Rule}'s 'variable' attribute has been set.
   * <p>
   * In SBML Level&nbsp;1, the different rule types each have a different
   * name for the attribute holding the reference to the object
   * constituting the left-hand side of the rule.  (E.g., for
   * SpeciesConcentrationRule the attribute is 'species', for
   * CompartmentVolumeRule it is 'compartment', etc.)  In SBML
   * Levels&nbsp;2 and&nbsp;3, the only two types of {@link Rule} objects with a
   * left-hand side object reference are {@link AssignmentRule} and {@link RateRule}, and
   * both of them use the same name for attribute: 'variable'.  In order to
   * make it easier for application developers to work with all Levels of
   * SBML, libSBML uses a uniform name for all such attributes, and it is
   * 'variable', regardless of whether Level&nbsp;1 rules or
   * Level&nbsp;2&ndash;3 rules are being used.
   * <p>
   * @return <code>true</code> if the 'variable' attribute value of this {@link Rule} has
   * been set, <code>false</code> otherwise.
   */
 public boolean isSetVariable() {
    return libsbmlJNI.Rule_isSetVariable(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code>
   * if this {@link Rule}'s 'units' attribute has been set.
   * <p>
   * @return <code>true</code> if the units for this {@link Rule} has been set, <code>false</code>
   * otherwise
   * <p>
   * @note The attribute 'units' exists on SBML Level&nbsp;1 ParameterRule
   * objects only.  It is not present in SBML Levels&nbsp;2 and&nbsp;3.
   */
 public boolean isSetUnits() {
    return libsbmlJNI.Rule_isSetUnits(swigCPtr, this);
  }

  
  /**
   * Sets the 'math' subelement of this {@link Rule} to an expression in
   * text-string form.
   * <p>
   * This is equivalent to setMath().  The provision of using text-string
   * formulas is retained for easier SBML Level&nbsp;1 compatibility.  The
   * formula is converted to an {@link ASTNode} internally.
   * <p>
   * @param formula a mathematical formula in text-string form.
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT }
   * <p>
   * @note The attribute 'formula' is specific to SBML Level&nbsp;1; in
   * higher Levels of SBML, it has been replaced with a subelement named
   * 'math'.  However, libSBML provides a unified interface to the
   * underlying math expression and this method can be used for models
   * of all Levels of SBML.
   */
 public int setFormula(String formula) {
    return libsbmlJNI.Rule_setFormula(swigCPtr, this, formula);
  }

  
  /**
   * Sets the 'math' subelement of this {@link Rule} to a copy of the given
   * {@link ASTNode}.
   * <p>
   * @param math the {@link ASTNode} structure of the mathematical formula.
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT }
   * <p>
   * @note The subelement 'math' is present in SBML Levels&nbsp;2
   * and&nbsp;3.  In SBML Level&nbsp;1, the equivalent construct is the
   * attribute named 'formula'.  LibSBML provides a unified interface to
   * the underlying math expression and this method can be used for models
   * of all Levels of SBML.
   */
 public int setMath(ASTNode math) {
    return libsbmlJNI.Rule_setMath(swigCPtr, this, ASTNode.getCPtr(math), math);
  }

  
  /**
   * Sets the 'variable' attribute value of this {@link Rule} object.
   * <p>
   * In SBML Level&nbsp;1, the different rule types each have a different
   * name for the attribute holding the reference to the object
   * constituting the left-hand side of the rule.  (E.g., for
   * SpeciesConcentrationRule the attribute is 'species', for
   * CompartmentVolumeRule it is 'compartment', etc.)  In SBML
   * Levels&nbsp;2 and&nbsp;3, the only two types of {@link Rule} objects with a
   * left-hand side object reference are {@link AssignmentRule} and {@link RateRule}, and
   * both of them use the same name for attribute: 'variable'.  In order to
   * make it easier for application developers to work with all Levels of
   * SBML, libSBML uses a uniform name for all such attributes, and it is
   * 'variable', regardless of whether Level&nbsp;1 rules or
   * Level&nbsp;2&ndash;3 rules are being used.
   * <p>
   * @param sid the identifier of a {@link Compartment}, {@link Species} or {@link Parameter}
   * elsewhere in the enclosing {@link Model} object.
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE }
   * <li> {@link  libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE }
   */
 public int setVariable(String sid) {
    return libsbmlJNI.Rule_setVariable(swigCPtr, this, sid);
  }

  
  /**
   * Sets the units for this {@link Rule}.
   * <p>
   * @param sname the identifier of the units
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE }
   * <li> {@link  libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE }
   * <p>
   * @note The attribute 'units' exists on SBML Level&nbsp;1 ParameterRule
   * objects only.  It is not present in SBML Levels&nbsp;2 and&nbsp;3.
   */
 public int setUnits(String sname) {
    return libsbmlJNI.Rule_setUnits(swigCPtr, this, sname);
  }

  
  /**
   * Unsets the 'units' for this {@link Rule}.
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * <p>
   * @note The attribute 'units' exists on SBML Level&nbsp;1 ParameterRule
   * objects only.  It is not present in SBML Levels&nbsp;2 and&nbsp;3.
   */
 public int unsetUnits() {
    return libsbmlJNI.Rule_unsetUnits(swigCPtr, this);
  }

  
  /**
   * Calculates and returns a {@link UnitDefinition} that expresses the units of
   * measurement assumed for the 'math' expression of this {@link Rule}.
   * <p>
   * The units are calculated based on the mathematical expression in the
   * {@link Rule} and the model quantities referenced by <code>&lt;ci&gt;</code>
   * elements used within that expression.  The getDerivedUnitDefinition()
   * method returns the calculated units.
   * <p>
   * Note that the functionality that facilitates unit analysis depends 
   * on the model as a whole.  Thus, in cases where the object has not 
   * been added to a model or the model itself is incomplete,
   * unit analysis is not possible and this method will return <code>NULL</code>.
   * <p>
   * @warning Note that it is possible the 'math' expression in the {@link Rule}
   * contains pure numbers or parameters with undeclared units.  In those
   * cases, it is not possible to calculate the units of the overall
   * expression without making assumptions.  LibSBML does not make
   * assumptions about the units, and getDerivedUnitDefinition() only
   * returns the units as far as it is able to determine them.  For
   * example, in an expression <em>X + Y</em>, if <em>X</em> has
   * unambiguously-defined units and <em>Y</em> does not, it will return
   * the units of <em>X</em>.  <strong>It is important that callers also
   * invoke the method</strong> containsUndeclaredUnits() <strong>to
   * determine whether this situation holds</strong>.  Callers may wish to
   * take suitable actions in those scenarios.
   * <p>
   * @return a {@link UnitDefinition} that expresses the units of the math 
   * expression of this {@link Rule}, or <code>NULL</code> if one cannot be constructed.
   * <p>
   * @see #containsUndeclaredUnits()
   */
 public UnitDefinition getDerivedUnitDefinition() {
    long cPtr = libsbmlJNI.Rule_getDerivedUnitDefinition__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new UnitDefinition(cPtr, false);
  }

  
  /**
   * Predicate returning <code>true</code> if 
   * the math expression of this {@link Rule} contains
   * parameters/numbers with undeclared units.
   * <p>
   * @return <code>true</code> if the math expression of this {@link Rule}
   * includes parameters/numbers 
   * with undeclared units, <code>false</code> otherwise.
   * <p>
   * @note A return value of <code>true</code> indicates that the {@link UnitDefinition}
   * returned by getDerivedUnitDefinition() may not accurately represent
   * the units of the expression.
   * <p>
   * @see #getDerivedUnitDefinition()
   */
 public boolean containsUndeclaredUnits() {
    return libsbmlJNI.Rule_containsUndeclaredUnits__SWIG_0(swigCPtr, this);
  }

  
  /**
   * Get the type of rule this is.
   * <p>
   * @return the rule type (a value drawn from the enumeration <a
   * class='el' href='#RuleType_t'>RuleType_t</a>) of this {@link Rule}.  The value
   * will be either @link RuleType_t#RULE_TYPE_RATE RULE_TYPE_RATE@endlink
   * or @link RateRule_t#RULE_TYPE_SCALAR RULE_TYPE_SCALAR@endlink.
   * <p>
   * @note The attribute 'type' on {@link Rule} objects was present only in SBML
   * Level&nbsp;1.  In SBML Level&nbsp;2 and later, the type has been
   * replaced by subclassing the {@link Rule} object.
   */
 public int getType() {
    return libsbmlJNI.Rule_getType(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> if this
   * {@link Rule} is an {@link AlgebraicRule}.
   * <p>
   * @return <code>true</code> if this {@link Rule} is an {@link AlgebraicRule}, <code>false</code> otherwise.
   */
 public boolean isAlgebraic() {
    return libsbmlJNI.Rule_isAlgebraic(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> if this
   * {@link Rule} is an {@link AssignmentRule}.
   * <p>
   * @return <code>true</code> if this {@link Rule} is an {@link AssignmentRule}, <code>false</code> otherwise.
   */
 public boolean isAssignment() {
    return libsbmlJNI.Rule_isAssignment(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> if
   * this {@link Rule} is an CompartmentVolumeRule.
   * <p>
   * @return <code>true</code> if this {@link Rule} is a CompartmentVolumeRule, <code>false</code>
   * otherwise.
   */
 public boolean isCompartmentVolume() {
    return libsbmlJNI.Rule_isCompartmentVolume(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> if
   * this {@link Rule} is an ParameterRule.
   * <p>
   * @return <code>true</code> if this {@link Rule} is a ParameterRule, <code>false</code>
   * otherwise.
   */
 public boolean isParameter() {
    return libsbmlJNI.Rule_isParameter(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> if this {@link Rule}
   * is a {@link RateRule} (SBML Levels&nbsp;2&ndash;3) or has a 'type' attribute
   * value of <code>'rate'</code> (SBML Level&nbsp;1).
   * <p>
   * @return <code>true</code> if this {@link Rule} is a {@link RateRule} (Level&nbsp;2) or has
   * type 'rate' (Level&nbsp;1), <code>false</code> otherwise.
   */
 public boolean isRate() {
    return libsbmlJNI.Rule_isRate(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> if this {@link Rule}
   * is an {@link AssignmentRule} (SBML Levels&nbsp;2&ndash;3) or has a 'type'
   * attribute value of <code>'scalar'</code> (SBML Level&nbsp;1).
   * <p>
   * @return <code>true</code> if this {@link Rule} is an {@link AssignmentRule} (Level&nbsp;2) or has
   * type 'scalar' (Level&nbsp;1), <code>false</code> otherwise.
   */
 public boolean isScalar() {
    return libsbmlJNI.Rule_isScalar(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> if
   * this {@link Rule} is an SpeciesConcentrationRule.
   * <p>
   * @return <code>true</code> if this {@link Rule} is a SpeciesConcentrationRule, <code>false</code>
   * otherwise.
   */
 public boolean isSpeciesConcentration() {
    return libsbmlJNI.Rule_isSpeciesConcentration(swigCPtr, this);
  }

  
  /**
   * Returns the libSBML type code for this SBML object.
   * <p>
   * LibSBML attaches an
   * identifying code to every kind of SBML object.  These are known as
   * <em>SBML type codes</em>.  In other languages, the set of type codes
   * is stored in an enumeration; in the Java language interface for
   * libSBML, the type codes are defined as static integer constants in
   * interface class {@link libsbmlConstants}.  The names of the type codes
   * all begin with the characters <code>SBML_</code>. 
   * <p>
   * @return the SBML type code for this object, or @link
   * SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
   * <p>
   * @see #getElementName()
   */
 public int getTypeCode() {
    return libsbmlJNI.Rule_getTypeCode(swigCPtr, this);
  }

  
  /**
   * Returns the SBML Level&nbsp;1 type code for this {@link Rule} object.
   * <p>
   * This only applies to SBML Level&nbsp;1 model objects.  If this is not
   * an SBML Level&nbsp;1 rule object, this method will return @link
   * SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink.
   * <p>
   * @return the SBML Level&nbsp;1 type code for this {@link Rule} (namely, @link
   * SBMLTypeCode_t#SBML_COMPARTMENT_VOLUME_RULE
   * SBML_COMPARTMENT_VOLUME_RULE@endlink, @link
   * SBMLTypeCode_t#SBML_PARAMETER_RULE SBML_PARAMETER_RULE@endlink, @link
   * SBMLTypeCode_t#SBML_SPECIES_CONCENTRATION_RULE
   * SBML_SPECIES_CONCENTRATION_RULE@endlink, or @link
   * SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink).
   */
 public int getL1TypeCode() {
    return libsbmlJNI.Rule_getL1TypeCode(swigCPtr, this);
  }

  
  /**
   * Returns the XML element name of this object
   * <p>
   * The returned value can be any of a number of different strings,
   * depending on the SBML Level in use and the kind of {@link Rule} object this
   * is.  The rules as of libSBML 4.1.0 are the following:
   * <ul>
   * <li> (Level&nbsp;2 and&nbsp;3) RateRule: returns <code>'rateRule'</code>
   * <li> (Level&nbsp;2 and&nbsp;3) AssignmentRule: returns <code>'assignmentRule'</code> 
   * <li> (Level&nbsp;2 and&nbsp;3) AlgebraicRule: returns <code>'algebraicRule'</code>
   * <li> (Level&nbsp;1 Version&nbsp;1) SpecieConcentrationRule: returns <code>'specieConcentrationRule'</code>
   * <li> (Level&nbsp;1 Version&nbsp;2) SpeciesConcentrationRule: returns <code>'speciesConcentrationRule'</code>
   * <li> (Level&nbsp;1) CompartmentVolumeRule: returns <code>'compartmentVolumeRule'</code>
   * <li> (Level&nbsp;1) ParameterRule: returns <code>'parameterRule'</code>
   * <li> Unknown rule type: returns <code>'unknownRule'</code>
   * </ul>
   * <p>
   * Beware that the last (<code>'unknownRule'</code>) is not a valid SBML element
   * name.
   * <p>
   * @return the name of this element
   */
 public String getElementName() {
    return libsbmlJNI.Rule_getElementName(swigCPtr, this);
  }

  
  /**
   * Sets the SBML Level&nbsp;1 type code for this {@link Rule}.
   * <p>
   * @param type the SBML Level&nbsp;1 type code for this {@link Rule}, drawn from
   * the enumeration #SBMLTypeCode_t.  The allowable values are @link
   * SBMLTypeCode_t#SBML_COMPARTMENT_VOLUME_RULE
   * SBML_COMPARTMENT_VOLUME_RULE@endlink, @link
   * SBMLTypeCode_t#SBML_PARAMETER_RULE SBML_PARAMETER_RULE@endlink, and
   * @link SBMLTypeCode_t#SBML_SPECIES_CONCENTRATION_RULE
   * SBML_SPECIES_CONCENTRATION_RULE@endlink.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values returned by this function are:
   * <li> @link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * <li> @link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   * if given <code>type</code> value is not one of the above.
   * <p>
   */
 public int setL1TypeCode(int type) {
    return libsbmlJNI.Rule_setL1TypeCode(swigCPtr, this, type);
  }

  
  /**
   * Predicate returning <code>true</code> if all the
   * required elements for this {@link Rule} object have been set.
   * <p>
   * The only required element for a {@link Rule} object is the 'math' subelement.
   * <p>
   * @return a boolean value indicating whether all the required
   * elements for this object have been defined.
   */
 public boolean hasRequiredElements() {
    return libsbmlJNI.Rule_hasRequiredElements(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> if all the
   * required attributes for this {@link Rule} object have been set.
   * <p>
   * The required attributes for a {@link Rule} object depend on the type of {@link Rule}
   * it is.  For {@link AssignmentRule} and {@link RateRule} objects (and SBML
   * Level&nbsp1's SpeciesConcentrationRule, CompartmentVolumeRule, and
   * ParameterRule objects), the required attribute is 'variable'; for
   * {@link AlgebraicRule} objects, there is no required attribute.
   * <p>
   * @return a boolean value indicating whether all the required
   * elements for this object have been defined.
   */
 public boolean hasRequiredAttributes() {
    return libsbmlJNI.Rule_hasRequiredAttributes(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> if all the
   * required attributes for this {@link Rule} object have been set.
   * <p>
   * The required attributes for a {@link Rule} object depend on the type of {@link Rule}
   * it is.  For {@link AssignmentRule} and {@link RateRule} objects (and SBML
   * Level&nbsp1's SpeciesConcentrationRule, CompartmentVolumeRule, and
   * ParameterRule objects), the required attribute is 'variable'; for
   * {@link AlgebraicRule} objects, there is no required attribute.
   * <p>
   * @return a boolean value indicating whether all the required
   * elements for this object have been defined.
   <p>
 * @deprecated libSBML internal
 */
 public String getId() {
    return libsbmlJNI.Rule_getId(swigCPtr, this);
  }

}
