/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.40
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * LibSBML implementation of SBase, the base class of all SBML objects.
 * <p>
 * Most components in SBML are derived from a single abstract base type,
 * {@link SBase}.  In addition to serving as the parent class for most other
 * classes of objects in SBML, this base type is designed to allow a
 * modeler or a software package to attach arbitrary information to each
 * major element or list in an SBML model.
 * <p>
 * {@link SBase} has an optional subelement called 'notes'.  It is intended to
 * serve as a place for storing optional information intended to be seen by
 * humans.  An example use of the 'notes' element would be to contain
 * formatted user comments about the model element in which the 'notes'
 * element is enclosed.  There are certain conditions on the XHTML content
 * permitted inside the 'notes' element; these are described separately
 * below.
 * <p>
 * {@link SBase} has another optional subelement called 'annotation'.  Whereas the
 * 'notes' element described above is a container for content to be shown
 * directly to humans, the 'annotation' element is a container for optional
 * software-generated content <em>not</em> meant to be shown to humans.  The
 * element's content type is XML type <code>any</code>, allowing essentially
 * arbitrary data content.  SBML places only a few restrictions on the
 * organization of the content; these are intended to help software tools
 * read and write the data as well as help reduce conflicts between
 * annotations added by different tools.  They are described separately
 * below.
 * <p>
 * It is worth pointing out that the 'annotation' element in the definition
 * of {@link SBase} exists in order that software developers may attach optional
 * application-specific data to the elements in an SBML model.  However, it
 * is important that this facility not be misused.  In particular, it is
 * <em>critical</em> that data essential to a model definition or that can
 * be encoded in existing SBML elements is <em>not</em> stored in
 * 'annotation'. {@link Parameter} values, functional dependencies between model
 * elements, etc., should not be recorded as annotations.  It is crucial to
 * keep in mind the fact that data placed in annotations can be freely
 * ignored by software applications.  If such data affects the
 * interpretation of a model, then software interoperability is greatly
 * impeded.
 * <p>
 * Beginning with SBML Level 2, {@link SBase} also has an optional attribute named
 * 'metaid' for supporting metadata annotations using RDF (Resource
 * Description Format). The attribute value has the data type 
 * <a href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>, the
 * XML identifier type, which means each 'metaid' value must be globally
 * unique within an SBML file.  (Importantly, this uniqueness criterion
 * applies across any attribute with type 
 * <a href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>, not just the 'metaid'
 * attribute used by SBML&mdash;something to be aware of if your
 * application-specific XML content inside the 'annotation' subelement
 * happens to use <a href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>.)
 * The 'metaid' value serves to identify a model
 * component for purposes such as referencing that component from metadata
 * placed within 'annotation' subelements.
 * <p>
 * Beginning with SBML Level 2 Version 3, {@link SBase} also has an optional
 * attribute named 'sboTerm' for supporting the use of the Systems Biology
 * Ontology.  In SBML proper, the data type of the attribute is a string of
 * the form SBO:NNNNNNN, where NNNNNNN is a seven digit integer number;
 * libSBML simplifies the representation by only storing the NNNNNNN
 * integer portion.  Thus, in libSBML, the 'sboTerm' attribute on {@link SBase} has
 * data type <code>int</code>, and {@link SBO} identifiers are stored simply as integers.
 * {@link SBO} terms are a type of optional annotation, and each different class of
 * SBML object derived from {@link SBase} imposes its own requirements about the
 * values permitted for 'sboTerm'.  Please consult the SBML Level 2 Version
 * 4 specification for more information about the use of {@link SBO} and the
 * 'sboTerm' attribute.
 * <p>
 * Finally, note that, in the list of methods on {@link SBase}, there is no public
 * constructor because {@link SBase} is an abstract class.  The constructors reside
 * in the subclasses derived from {@link SBase}.
 * <p>
 * <p>
 * <h2>Requirements for the content of the 'notes' subelement</h2>
 * <p>
 * The content of 'notes' elements must be in XHTML 1.0 format.  (Plain
 * HTML would not be usable because whatever appears inside the 'notes'
 * element must be compatible with XML, which HTML is not, and in any case,
 * the requirement for using XHTML does not prevent users from entering
 * plain-text content ,which they can do using the standard <code>&lt;pre&gt;
 * ... &lt;/pre&gt;</code> elements of [X]HTML.)
 * <p>
 * The XML content of a 'notes' subelement must declare the use of the
 * XHTML XML namespace.  This can be done in multiple ways.  One way is to
 * place a namespace declaration for the appropriate namespace URI (which
 * for XHTML is <tt>'http://www.w3.org/1999/xhtml'</tt>) on the top-level
 * <code>sbml</code> element and then reference the namespace in the
 * 'notes' element content using a prefix.  The following example
 * illustrates this approach:
 * <div class='fragment'><pre>
&lt;sbml xmlns='http://www.sbml.org/sbml/level2/version4' level='2' version='4'
      xmlns:xhtml='http://www.w3.org/1999/xhtml'&gt;
  ...
  &lt;notes&gt;
    &lt;xhtml:body&gt;
      &lt;xhtml:center&gt;&lt;xhtml:h2&gt;A Simple Mitotic Oscillator&lt;/xhtml:h2&gt;&lt;/xhtml:center&gt;
      &lt;xhtml:p&gt;A minimal cascade model for the mitotic oscillator
      involving cyclin and cdc2 kinase&lt;/xhtml:p&gt;
    &lt;/xhtml:body&gt;
  &lt;/notes&gt;
  ...
</pre></div>
 * <p>
 * Another approach is to declare the XHTML namespace within the 'notes'
 * element content itself, as in the following example:
 * <div class='fragment'><pre>
...
&lt;notes&gt;
  &lt;body xmlns='http://www.w3.org/1999/xhtml'&gt;

    &lt;center&gt;&lt;h2&gt;A Simple Mitotic Oscillator&lt;/h2&gt;&lt;/center&gt;

    A minimal cascade model for the mitotic oscillator
    involving cyclin and cdc2 kinase&lt;/p&gt;

  &lt;/body&gt;
&lt;/notes&gt;
...
</pre></div>
 * <p>
 * The <code>xmlns='http://www.w3.org/1999/xhtml'</code> declaration on 
 * <code>body</code> as shown above changes the default XML namespace within it, such
 * that all of its content is by default in the XHTML namespace.  This is a
 * particularly convenient approach because it obviates the need to prefix
 * every element with a namespace prefix (i.e., <code>xhtml:</code>
 * in the previous case).  Other approaches are also possible.
 * <p>
 * SBML does not require the content of the 'notes' subelement to be any
 * particular XHTML element; the content can be almost any well-formed
 * XHTML content.  SBML Level 2 Versions 2, 3 and 4 added some small
 * restrictions and clarifications for the allowable content in order to
 * promote greater interoperability between software tools.  The first
 * restriction comes from the requirements of XML: the 'notes'
 * element must not contain an XML declaration nor a DOCTYPE declaration.
 * That is, 'notes' must <em>not</em> contain
 * <div class='fragment'><pre>
&lt;?xml version='1.0' encoding='UTF-8'?&gt;  
</pre></div>
 * nor (where the following is only one specific example of a DOCTYPE
 * declaration)
 * <div class='fragment'><pre>
&lt;!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Strict//EN'
      'http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd'&gt;
</pre></div>
 * <p>
 * The second restriction is intended to balance freedom of content with
 * the complexity of implementing software that can interpret the content.
 * The content of the 'notes' subelement in SBML can consist only of the
 * following possibilities:
 * <ul>
 * <li> A complete XHTML document (minus the XML and DOCTYPE declarations,
 * of course), that is, XHTML content beginning with the <code>html</code> tag.
 * <div class='fragment'><pre>
&lt;notes&gt;
  &lt;html xmlns='http://www.w3.org/1999/xhtml'&gt;
     ...
  &lt;/html&gt;
&lt;/notes&gt;
</pre></div>
 * <p>
 * <li> The <code>body</code> element from an XHTML document.  The following is an
 * example skeleton:
 * <div class='fragment'><pre>
&lt;notes&gt;
    &lt;body xmlns='http://www.w3.org/1999/xhtml'&gt;
      ...
    &lt;/body&gt;
&lt;/notes&gt;
</pre></div>
 * <p>
 * <li> Any XHTML content that would be permitted within a <code>body</code> element.
 * If this consists of multiple elements, each one must declare the XML
 * namespace separately.  The following is an example fragment:
 * <div class='fragment'><pre>
&lt;notes&gt;
    &lt;p xmlns='http://www.w3.org/1999/xhtml'&gt;
      ...
    &lt;/p&gt;
    &lt;p xmlns='http://www.w3.org/1999/xhtml'&gt;
      ...
    &lt;/p&gt;
&lt;/notes&gt;
</pre></div>
 * </ul>
 * <p>
 * Another way to summarize the restrictions above is simply to say that
 * the content of an SBML 'notes' element can be only be a complete <code>html</code>
 * element, a <code>body</code> element, or whatever is permitted inside a <code>body</code>
 * element.  In practice, this does not limit in any meaningful way what
 * can be placed inside a 'notes' element; for example, if an application
 * or modeler wants to put a complete XHTML page, including a <code>head</code>
 * element, it can be done by putting in everything starting with the 
 * <code>html</code> container.  However, the restrictions above do make it somewhat
 * simpler to write software that can read and write the 'notes' content.
 * <p>
 * <p>
 * <h2>Requirements for the content of the 'annotation' subelement</h2>
 * <p>
 * At the outset, software developers should keep in mind that multiple
 * software tools may attempt to read and write annotation content.  To
 * reduce the potential for collisions between annotations written by
 * different applications, SBML Level 2 stipulates that tools must use XML
 * namespaces to specify the intended vocabulary of every annotation.  The
 * application's developers must choose a URI (Universal Resource
 * Identifier) reference that uniquely identifies the vocabulary the
 * application will use, and a prefix string for the annotations.
 * <p>
 * A important requirement is that application-specific annotation data is
 * entirely contained inside a single <em>top-level element</em> within the
 * SBML 'annotation' subelement.  SBML Level 2 Versions 2, 3 and 4 place the
 * following restrictions on annotations:
 * <ul>
 * <li> Within a given SBML 'annotation' element, there can only be one
 * top-level element using a given namespace.  An annotation element can
 * contain multiple top-level elements but each must be in a different
 * namespace.
 * <p>
 * <li> No top-level element in an 'annotation' may use an SBML XML
 * namespace, either explicitly by referencing one of the SBML XML
 * namespace URIs or implicitly by failing to specify any namespace on the
 * annotation.
 * <p>
 * <li> The ordering of top-level elements within a given 'annotation'
 * element is <em>not</em> significant.  An application should not expect
 * that its annotation content appears first in the 'annotation' element,
 * nor in any other particular location.  Moreover, the ordering of
 * top-level annotation elements may be changed by different applications
 * as they read and write the same SBML file.
 * </ul>
 * <p>
 * The use of XML namespaces in this manner is intended to improve the
 * ability of multiple applications to place annotations on SBML model
 * elements with reduced risks of interference or name collisions.
 * Annotations stored by different simulation packages can therefore
 * coexist in the same model definition.  The rules governing the content
 * of 'annotation' elements are designed to enable applications to easily
 * add, change, and remove their annotations from SBML elements while
 * simultaneously preserving annotations inserted by other applications
 * when mapping SBML from input to output.
 * <p>
 * As a further simplification for developers of software and to improve
 * software interoperability, applications are only required to preserve
 * other annotations (i.e., annotations they do not recognize) when those
 * annotations are self-contained entirely within 'annotation', complete
 * with namespace declarations.  The following is an example:
 * <div class='fragment'><pre>
&lt;annotation&gt;
    &lt;topLevelElement xmlns:'URI'&gt;
       ... content in the namespace identified by 'URI' ...
    &lt;/topLevelElement&gt;
&lt;/annotation&gt;
</pre></div>
 * <p>
 * Some more examples hopefully will make these points more clear.  The
 * next example is invalid because it contains a top-level element in the
 * SBML XML namespace&mdash;this happens because no namespace is declared
 * for the <code>&lt;cytoplasm&gt;</code> element, which means by default it
 * falls into the enclosing SBML namespace:
 * <div class='fragment'><pre>
&lt;annotation&gt;
    &lt;cytoplasm/&gt;
&lt;/annotation&gt;
</pre></div>
 * <p>
 * The following example is also invalid, this time because it contains two
 * top-level elements using the same XML namespace.  Note that it does not
 * matter that these are two different top-level elements
 * (<code>&lt;nodecolors&gt;</code> and <code>&lt;textcolors&gt;</code>); 
 * what matters is that these separate elements are both in the same 
 * namespace rather than having been collected and placed inside one 
 * overall container element for that namespace.
 * <div class='fragment'><pre>
&lt;annotation&gt;
    &lt;mysim:nodecolors xmlns:mysim='http://www.mysim.org/ns'
        mysim:bgcolor='green' mysim:fgcolor='white'/&gt;
    &lt;mysim:textcolors xmlns:mysim='http://www.mysim.org/ns'
        mysim:bgcolor='green' mysim:fgcolor='white'/&gt;
&lt;/annotation&gt;
</pre></div>
 * <p>
 * On the other hand, the following example is valid:
 * <div class='fragment'><pre>
&lt;annotation&gt;
    &lt;mysim:geometry xmlns:mysim='http://www.mysim.org/ns'
             mysim:bgcolor='green' mysim:fgcolor='white'&gt;
        &lt;graph:node xmlns:graph='http://www.graph.org/ns' 
             graph:x='4' graph:y='5' /&gt;
    &lt;/mysim:geometry&gt;
    &lt;othersim:icon xmlns:othersim='http://www.othersim.com/'&gt;
        WS2002
    &lt;/othersim:icon&gt;
&lt;/annotation&gt;
</pre></div>
 * <p>
 * It is worth keeping in mind that although XML namespace names must be
 * URIs, they are (like all XML namespace names) <em>not required</em> to
 * be directly usable in the sense of identifying an actual, retrieval
 * document or resource on the Internet.  URIs such as
 * <code>'http://www.mysim.org/'</code> may appear as though they are
 * (e.g.) Internet addresses, but there are not the same thing.  This
 * style of URI strings, using a domain name and other parts, is only a
 * simple and commonly-used way of creating a unique name string.
 * <p>
 * <p>
 * <h2>Standard format for annotations linking data resources</h2>
 * <p>
 * SBML Level 2 Versions 2, 3 and 4 define a proposed regular format for
 * encoding two particular categories of annotations: (a) references to
 * controlled vocabulary terms and database identifiers which define and
 * describe biological and biochemical entities in a model; and (b)
 * descriptions of the provenance of a model, including its author(s) and
 * modification history.
 */

public class SBase {
   private long swigCPtr;
   protected boolean swigCMemOwn;

   protected SBase(long cPtr, boolean cMemoryOwn)
   {
     swigCMemOwn = cMemoryOwn;
     swigCPtr    = cPtr;
   }

   protected static long getCPtr(SBase obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (SBase obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_SBase(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  /**
   * Equality comparison method for SBase.
   * <p>
   * Because the Java methods for libSBML are actually wrappers around code
   * implemented in C++ and C, certain operations will not behave as
   * expected.  Equality comparison is one such case.  An instance of a
   * libSBML object class is actually a <em>proxy object</em>
   * wrapping the real underlying C/C++ object.  The normal <code>==</code>
   * equality operator in Java will <em>only compare the Java proxy objects</em>,
   * not the underlying native object.  The result is almost never what you
   * want in practical situations.  Unfortunately, Java does not provide a
   * way to override <code>==</code>.
   *  <p>
   * The alternative that must be followed is to use the
   * <code>equals()</code> method.  The <code>equals</code> method on this
   * class overrides the default java.lang.Object one, and performs an
   * intelligent comparison of instances of objects of this class.  The
   * result is an assessment of whether two libSBML Java objects are truly 
   * the same underlying native-code objects.
   *  <p>
   * The use of this method in practice is the same as the use of any other
   * Java <code>equals</code> method.  For example,
   * <em>a</em><code>.equals(</code><em>b</em><code>)</code> returns
   * <code>true</code> if <em>a</em> and <em>b</em> are references to the
   * same underlying object.
   *
   * @param sb a reference to an object to which the current object
   * instance will be compared
   *
   * @return <code>true</code> if <code>sb</code> refers to the same underlying 
   * native object as this one, <code>false</code> otherwise
   */
  public boolean equals(Object sb)
  {
    if ( this == sb ) 
    {
      return true;
    }
    return swigCPtr == getCPtr((SBase)(sb));
  }

  /**
   * Returns a hashcode for this SBase object.
   *
   * @return a hash code usable by Java methods that need them.
   */
  public int hashCode()
  {
    return (int)(swigCPtr^(swigCPtr>>>32));
  }

  
  /**
   * Creates and returns a deep copy of this {@link SBase} object.
   * <p>
   * @return a (deep) copy of this {@link SBase} object
   */
 public SBase cloneObject() {
  return libsbml.DowncastSBase(libsbmlJNI.SBase_cloneObject(swigCPtr, this), true);
}

  
  /**
   * Returns the value of the 'metaid' attribute of this object.
   * <p>
   * The optional attribute named 'metaid', present on every major SBML
   * component type, is for supporting metadata annotations using RDF
   * (Resource Description Format). The attribute value has the data type
   * <a href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>, the XML
   * identifier type, which means each 'metaid' value must be globally
   * unique within an SBML file.  (Importantly, this uniqueness criterion
   * applies across any attribute with type <a
   * href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>, not just the
   * 'metaid' attribute used by SBML&mdash;something to be aware of if your
   * application-specific XML content inside the 'annotation' subelement
   * happens to use <a href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>.)
   * The 'metaid' value serves to identify a model
   * component for purposes such as referencing that component from
   * metadata placed within 'annotation' subelements.
   * <p>
   * @return the metaid of this SBML object.
   * <p>
   * @see #isSetMetaId()
   * @see #setMetaId(String metaid)
   */
 public String getMetaId() {
    return libsbmlJNI.SBase_getMetaId(swigCPtr, this);
  }

  
  /**
   * Returns the value of the 'metaid' attribute of this object.
   * <p>
   * The optional attribute named 'metaid', present on every major SBML
   * component type, is for supporting metadata annotations using RDF
   * (Resource Description Format). The attribute value has the data type
   * <a href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>, the XML
   * identifier type, which means each 'metaid' value must be globally
   * unique within an SBML file.  (Importantly, this uniqueness criterion
   * applies across any attribute with type <a
   * href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>, not just the
   * 'metaid' attribute used by SBML&mdash;something to be aware of if your
   * application-specific XML content inside the 'annotation' subelement
   * happens to use <a href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>.)
   * The 'metaid' value serves to identify a model
   * component for purposes such as referencing that component from
   * metadata placed within 'annotation' subelements.
   * <p>
   * @return the metaid of this SBML object.
   * <p>
   * @see #isSetMetaId()
   * @see #setMetaId(String metaid)
   <p>
 * @deprecated libSBML internal
 */
 public String getId() {
    return libsbmlJNI.SBase_getId(swigCPtr, this);
  }

  
  /**
   * Returns the value of the 'metaid' attribute of this object.
   * <p>
   * The optional attribute named 'metaid', present on every major SBML
   * component type, is for supporting metadata annotations using RDF
   * (Resource Description Format). The attribute value has the data type
   * <a href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>, the XML
   * identifier type, which means each 'metaid' value must be globally
   * unique within an SBML file.  (Importantly, this uniqueness criterion
   * applies across any attribute with type <a
   * href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>, not just the
   * 'metaid' attribute used by SBML&mdash;something to be aware of if your
   * application-specific XML content inside the 'annotation' subelement
   * happens to use <a href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>.)
   * The 'metaid' value serves to identify a model
   * component for purposes such as referencing that component from
   * metadata placed within 'annotation' subelements.
   * <p>
   * @return the metaid of this SBML object.
   * <p>
   * @see #isSetMetaId()
   * @see #setMetaId(String metaid)
   <p>
 * @deprecated libSBML internal
 */
 public String getName() {
    return libsbmlJNI.SBase_getName(swigCPtr, this);
  }

  
  /**
   * Returns the content of the 'notes' subelement of this object as
   * a tree of XML nodes.
   * <p>
   * The optional element named 'notes', present on every major SBML
   * component type, is intended as a place for storing optional
   * information intended to be seen by humans.  An example use of the
   * 'notes' element would be to contain formatted user comments
   * about the model element in which the 'notes' element is
   * enclosed.  Every object derived directly or indirectly from type
   * {@link SBase} can have a separate value for 'notes', allowing users
   * considerable freedom when adding comments to their models.
   * The format of 'notes' elements must be XHTML 1.0.  The SBML
   * Level&nbsp;2 specification has considerable detail about how
   * 'notes' element content must be handled; please refer to the
   * specifications.
   * <p>
   * The 'notes' element content returned by this method will be in XML
   * form, but libSBML does not provide an object model specifically for
   * the content of notes.  Callers will need to traverse the XML tree
   * structure using the facilities available on {@link XMLNode} and related
   * objects.
   * <p>
   * @return the content of the 'notes' subelement of this SBML object.
   * <p>
   * @see #getNotesString()
   * @see #isSetNotes()
   * @see #setNotes(XMLNode  notes)
   * @see #setNotes(String notes)
   * @see #appendNotes(XMLNode  notes)
   * @see #appendNotes(String notes)
   * @see #unsetNotes()
   */
 public XMLNode getNotes() {
    long cPtr = libsbmlJNI.SBase_getNotes(swigCPtr, this);
    return (cPtr == 0) ? null : new XMLNode(cPtr, false);
  }

  
  /**
   * Returns the content of the 'notes' subelement of this object as a
   * string.
   * <p>
   * The optional element named 'notes', present on every major SBML
   * component type, is intended as a place for storing optional
   * information intended to be seen by humans.  An example use of the
   * 'notes' element would be to contain formatted user comments
   * about the model element in which the 'notes' element is
   * enclosed.  Every object derived directly or indirectly from type
   * {@link SBase} can have a separate value for 'notes', allowing users
   * considerable freedom when adding comments to their models.
   * The format of 'notes' elements must be XHTML 1.0.  The SBML
   * Level&nbsp;2 specification has considerable detail about how
   * 'notes' element content must be handled; please refer to the
   * specifications.
   * <p>
   * @return the content of the 'notes' subelement of this SBML object.
   * <p>
   * @see #getNotes()
   * @see #isSetNotes()
   * @see #setNotes(XMLNode  notes)
   * @see #setNotes(String notes)
   * @see #appendNotes(XMLNode  notes)
   * @see #appendNotes(String notes)
   * @see #unsetNotes()
   */
 public String getNotesString() {
    return libsbmlJNI.SBase_getNotesString(swigCPtr, this);
  }

  
  /**
   * Returns the content of the 'annotation' subelement of this object as
   * an XML node tree.
   * <p>
   * Whereas the {@link SBase} 'notes' subelement is a container for content to be
   * shown directly to humans, the 'annotation' element is a container for
   * optional software-generated content <em>not</em> meant to be shown to
   * humans.  Every object derived from {@link SBase} can have its own value for
   * 'annotation'.  The element's content type is XML type
   * <code>any</code>, allowing essentially arbitrary well-formed XML data
   * content.
   * <p>
   * SBML places a few restrictions on the organization of the content of
   * annotations; these are intended to help software tools read and write
   * the data as well as help reduce conflicts between annotations added by
   * different tools.  Please see the SBML specifications for more details.
   * <p>
   * The annotations returned by this method will be in XML form.  LibSBML
   * provides an object model and related interfaces for certain specific
   * kinds of annotations, namely model history information and RDF
   * content.  See the {@link ModelHistory}, {@link CVTerm} and RDFAnnotationParser classes
   * for more information about the facilities available.
   * <p>
   * @return the annotation of this SBML object as an {@link XMLNode}
   * <p>
   * @see #getAnnotationString()
   * @see #isSetAnnotation()
   * @see #setAnnotation(XMLNode  annotation)
   * @see #setAnnotation(String annotation)
   * @see #appendAnnotation(XMLNode  annotation)
   * @see #appendAnnotation(String annotation)
   * @see #unsetAnnotation()
   */
 public XMLNode getAnnotation() {
    long cPtr = libsbmlJNI.SBase_getAnnotation(swigCPtr, this);
    return (cPtr == 0) ? null : new XMLNode(cPtr, false);
  }

  
  /**
   * Returns the content of the 'annotation' subelement of this object as a
   * character string.
   * <p>
   * Whereas the {@link SBase} 'notes' subelement is a container for content to be
   * shown directly to humans, the 'annotation' element is a container for
   * optional software-generated content <em>not</em> meant to be shown to
   * humans.  Every object derived from {@link SBase} can have its own value for
   * 'annotation'.  The element's content type is XML type
   * <code>any</code>, allowing essentially arbitrary well-formed XML data
   * content.
   * <p>
   * SBML places a few restrictions on the organization of the content of
   * annotations; these are intended to help software tools read and write
   * the data as well as help reduce conflicts between annotations added by
   * different tools.  Please see the SBML specifications for more details.
   * <p>
   * The annotations returned by this method will be in string form.
   * <p>
   * @return the annotation string of this SBML object.
   * <p>
   * @see #getAnnotation()
   * @see #isSetAnnotation()
   * @see #setAnnotation(XMLNode  annotation)
   * @see #setAnnotation(String annotation)
   * @see #appendAnnotation(XMLNode  annotation)
   * @see #appendAnnotation(String annotation)
   * @see #unsetAnnotation()
   */
 public String getAnnotationString() {
    return libsbmlJNI.SBase_getAnnotationString(swigCPtr, this);
  }

  
  /**
   * Returns a list of the XML Namespaces declared on this SBML document.
   * <p>
   * @return the XML Namespaces associated with this SBML object
   */
 public XMLNamespaces getNamespaces() {
    long cPtr = libsbmlJNI.SBase_getNamespaces(swigCPtr, this);
    return (cPtr == 0) ? null : new XMLNamespaces(cPtr, false);
  }

  
  /**
   * Returns the parent {@link SBMLDocument} object.
   * <p>
   * LibSBML uses the class {@link SBMLDocument} as a top-level container for
   * storing SBML content and data associated with it (such as warnings and
   * error messages).  An SBML model in libSBML is contained inside an
   * {@link SBMLDocument} object.  {@link SBMLDocument} corresponds roughly to the class
   * <i>Sbml</i> defined in the SBML Level&nbsp;2 specification, but it
   * does not have a direct correspondence in SBML Level&nbsp;1.  (But, it
   * is created by libSBML no matter whether the model is Level&nbsp;1 or
   * Level&nbsp;2.)
   * <p>
   * This method allows the {@link SBMLDocument} for the current object to be
   * retrieved.
   * <p>
   * @return the parent {@link SBMLDocument} object of this SBML object.
   */
 public SBMLDocument getSBMLDocument() {
    long cPtr = libsbmlJNI.SBase_getSBMLDocument__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new SBMLDocument(cPtr, false);
  }

  
  /**
   * Returns the parent SBML object.
   * <p>
   * This method is convenient when holding an object nested inside
   * other objects in an SBML model.  It allows direct access to the
   * <code>&lt;model&gt;</code> element containing it.
   * <p>
   * @return the parent SBML object of this SBML object.
   */
 public SBase getParentSBMLObject() {
  return libsbml.DowncastSBase(libsbmlJNI.SBase_getParentSBMLObject(swigCPtr, this), false);
}

  
  /**
   * Returns the ancestor SBML object that corresponds to the 
   * given SBMLTypeCode_t.
   * <p>
   * This function allows any object to determine its exact
   * location/function within a model. For example a {@link StoichiometryMath}
   * object has ancestors of type {@link SpeciesReference},
   * ListOfProducts/ListOfReactants/ListOfModifiers, {@link Reaction},
   * {@link ListOfReactions} and {@link Model}; any of which can be accessed via this
   * function.
   * <p>
   * @param type the SBMLTypeCode_t of the ancestor to be returned.
   * <p>
   * @return the ancestor SBML object of this SBML object, that 
   * corresponds to the given SBMLTypeCode_t, NULL if none exists.
   */
 public SBase getAncestorOfType(int type) {
  return libsbml.DowncastSBase(libsbmlJNI.SBase_getAncestorOfType(swigCPtr, this, type), false);
}

  
  /**
   * Returns the integer portion of the value of the 'sboTerm' attribute of
   * this object.
   * <p>
   * In SBML Level 2 Versions 2, 3 and 4, the data type of the attribute is a
   * string of the form SBO:NNNNNNN, where NNNNNNN is a seven digit integer
   * number; libSBML simplifies the representation by only storing the
   * NNNNNNN integer portion.  Thus, in libSBML, the 'sboTerm' attribute on
   * {@link SBase} has data type <code>int</code>, and {@link SBO} identifiers are stored simply as
   * integers.  {@link SBO} terms are a type of optional annotation, and each
   * different class of SBML object derived from {@link SBase} imposes its own
   * requirements about the values permitted for 'sboTerm'.  Please consult
   * the SBML Level 2 Version 4 specification for more information about
   * the use of {@link SBO} and the 'sboTerm' attribute.
   * <p>
   * @return the value of the 'sboTerm' attribute as an integer, or <code>-1</code>
   * if the value is not set.
   */
 public int getSBOTerm() {
    return libsbmlJNI.SBase_getSBOTerm(swigCPtr, this);
  }

  
  /**
   * Returns the string representation of the 'sboTerm' attribute of
   * this object.
   * <p>
   * In SBML Level 2 Versions 2, 3 and 4, the data type of the attribute is a
   * string of the form SBO:NNNNNNN, where NNNNNNN is a seven digit integer
   * number; libSBML simplifies the representation by only storing the
   * NNNNNNN integer portion.  Thus, in libSBML, the 'sboTerm' attribute on
   * {@link SBase} has data type <code>int</code>, and {@link SBO} identifiers are stored simply as
   * integers.  This function recreates the string representation from the
   * stored value.  {@link SBO} terms are a type of optional annotation, and each
   * different class of SBML object derived from {@link SBase} imposes its own
   * requirements about the values permitted for 'sboTerm'.  Please consult
   * the SBML Level 2 Version 4 specification for more information about
   * the use of {@link SBO} and the 'sboTerm' attribute.
   * <p>
   * @return the value of the 'sboTerm' attribute as a string of the form
   * SBO:NNNNNNN, or  an empty string
   * if the value is not set.
   */
 public String getSBOTermID() {
    return libsbmlJNI.SBase_getSBOTermID(swigCPtr, this);
  }

  
  /**
   * Returns the line number on which this object first appears in the XML
   * representation of the SBML document.
   * <p>
   * @return the line number of this SBML object.
   * <p>
   * @see #getColumn()
   */
 public long getLine() {
    return libsbmlJNI.SBase_getLine(swigCPtr, this);
  }

  
  /**
   * Returns the column number on which this object first appears in the XML
   * representation of the SBML document.
   * <p>
   * @return the column number of this SBML object.
   * <p>
   * @see #getLine()
   */
 public long getColumn() {
    return libsbmlJNI.SBase_getColumn(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * object's 'metaid' attribute has been set.
   * <p>
   * The optional attribute named 'metaid', present on every major SBML
   * component type, is for supporting metadata annotations using RDF
   * (Resource Description Format). The attribute value has the data type
   * <a href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>, the XML
   * identifier type, which means each 'metaid' value must be globally
   * unique within an SBML file.  (Importantly, this uniqueness criterion
   * applies across any attribute with type <a
   * href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>, not just the
   * 'metaid' attribute used by SBML&mdash;something to be aware of if your
   * application-specific XML content inside the 'annotation' subelement
   * happens to use <a href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>.)
   * The 'metaid' value serves to identify a model
   * component for purposes such as referencing that component from
   * metadata placed within 'annotation' subelements.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @return <code>true</code> if the 'metaid' attribute of this SBML object has been
   * set, <code>false</code> otherwise.
   * <p>
   * @see #getMetaId()
   * @see #setMetaId(String metaid)
   */
 public boolean isSetMetaId() {
    return libsbmlJNI.SBase_isSetMetaId(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * object's 'metaid' attribute has been set.
   * <p>
   * The optional attribute named 'metaid', present on every major SBML
   * component type, is for supporting metadata annotations using RDF
   * (Resource Description Format). The attribute value has the data type
   * <a href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>, the XML
   * identifier type, which means each 'metaid' value must be globally
   * unique within an SBML file.  (Importantly, this uniqueness criterion
   * applies across any attribute with type <a
   * href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>, not just the
   * 'metaid' attribute used by SBML&mdash;something to be aware of if your
   * application-specific XML content inside the 'annotation' subelement
   * happens to use <a href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>.)
   * The 'metaid' value serves to identify a model
   * component for purposes such as referencing that component from
   * metadata placed within 'annotation' subelements.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @return <code>true</code> if the 'metaid' attribute of this SBML object has been
   * set, <code>false</code> otherwise.
   * <p>
   * @see #getMetaId()
   * @see #setMetaId(String metaid)
   <p>
 * @deprecated libSBML internal
 */
 public boolean isSetId() {
    return libsbmlJNI.SBase_isSetId(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * object's 'metaid' attribute has been set.
   * <p>
   * The optional attribute named 'metaid', present on every major SBML
   * component type, is for supporting metadata annotations using RDF
   * (Resource Description Format). The attribute value has the data type
   * <a href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>, the XML
   * identifier type, which means each 'metaid' value must be globally
   * unique within an SBML file.  (Importantly, this uniqueness criterion
   * applies across any attribute with type <a
   * href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>, not just the
   * 'metaid' attribute used by SBML&mdash;something to be aware of if your
   * application-specific XML content inside the 'annotation' subelement
   * happens to use <a href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>.)
   * The 'metaid' value serves to identify a model
   * component for purposes such as referencing that component from
   * metadata placed within 'annotation' subelements.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @return <code>true</code> if the 'metaid' attribute of this SBML object has been
   * set, <code>false</code> otherwise.
   * <p>
   * @see #getMetaId()
   * @see #setMetaId(String metaid)
   <p>
 * @deprecated libSBML internal
 */
 public boolean isSetName() {
    return libsbmlJNI.SBase_isSetName(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * object's 'notes' subelement exists and has content.
   * <p>
   * The optional element named 'notes', present on every major SBML
   * component type, is intended as a place for storing optional
   * information intended to be seen by humans.  An example use of the
   * 'notes' element would be to contain formatted user comments
   * about the model element in which the 'notes' element is
   * enclosed.  Every object derived directly or indirectly from type
   * {@link SBase} can have a separate value for 'notes', allowing users
   * considerable freedom when adding comments to their models.
   * The format of 'notes' elements must be XHTML 1.0.  The SBML
   * Level&nbsp;2 specification has considerable detail about how
   * 'notes' element content must be handled; please refer to the
   * specifications.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @return <code>true</code> if a 'notes' subelement exists, <code>false</code> otherwise.
   * <p>
   * @see #getNotes()
   * @see #getNotesString()
   * @see #setNotes(XMLNode  notes)
   * @see #setNotes(String notes)
   * @see #appendNotes(XMLNode  notes)
   * @see #appendNotes(String notes)
   * @see #unsetNotes()
   */
 public boolean isSetNotes() {
    return libsbmlJNI.SBase_isSetNotes(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * object's 'annotation' subelement exists and has content.
   * <p>
   * Whereas the {@link SBase} 'notes' subelement is a container for content to be
   * shown directly to humans, the 'annotation' element is a container for
   * optional software-generated content <em>not</em> meant to be shown to
   * humans.  Every object derived from {@link SBase} can have its own value for
   * 'annotation'.  The element's content type is XML type
   * <code>any</code>, allowing essentially arbitrary well-formed XML data
   * content.
   * <p>
   * SBML places a few restrictions on the organization of the content of
   * annotations; these are intended to help software tools read and write
   * the data as well as help reduce conflicts between annotations added by
   * different tools.  Please see the SBML specifications for more details.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @return <code>true</code> if a 'annotation' subelement exists, <code>false</code>
   * otherwise.
   * <p>
   * @see #getAnnotation()
   * @see #getAnnotationString()
   * @see #setAnnotation(XMLNode  annotation)
   * @see #setAnnotation(String annotation)
   * @see #appendAnnotation(XMLNode  annotation)
   * @see #appendAnnotation(String annotation)
   * @see #unsetAnnotation()
   */
 public boolean isSetAnnotation() {
    return libsbmlJNI.SBase_isSetAnnotation(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * object's 'sboTerm' attribute has been set.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @return <code>true</code> if the 'sboTerm' attribute of this SBML object has been
   * set, <code>false</code> otherwise.
   */
 public boolean isSetSBOTerm() {
    return libsbmlJNI.SBase_isSetSBOTerm(swigCPtr, this);
  }

  
  /**
   * Sets the value of the 'metaid' attribute of this object.
   * <p>
   * The string <code>metaid</code> is copied.  The value of <code>metaid</code> must be an
   * identifier conforming to the syntax defined by the XML 1.0 data type
   * <a href='http://www.w3.org/TR/REC-xml/#id'>ID</a>.  Among other
   * things, this type requires that a value is unique among all the values
   * of type XML ID in an {@link SBMLDocument}.  Although SBML only uses <a
   * href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a> for the 'metaid'
   * attribute, callers should be careful if they use
   * <a href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>'s in XML
   * portions of a model that are not defined by SBML, such as in the
   * application-specific content of the 'annotation' subelement.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @param metaid the identifier string to use as the value of the
   * 'metaid' attribute
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_INVALID_ATTRIBUTE_VALUE
   * <li> LIBSBML_UNEXPECTED_ATTRIBUTE
   * <p>
   * @see #getMetaId()
   * @see #isSetMetaId()
   */
 public int setMetaId(String metaid) {
    return libsbmlJNI.SBase_setMetaId(swigCPtr, this, metaid);
  }

  
  /**
   * Sets the value of the 'metaid' attribute of this object.
   * <p>
   * The string <code>metaid</code> is copied.  The value of <code>metaid</code> must be an
   * identifier conforming to the syntax defined by the XML 1.0 data type
   * <a href='http://www.w3.org/TR/REC-xml/#id'>ID</a>.  Among other
   * things, this type requires that a value is unique among all the values
   * of type XML ID in an {@link SBMLDocument}.  Although SBML only uses <a
   * href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a> for the 'metaid'
   * attribute, callers should be careful if they use
   * <a href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>'s in XML
   * portions of a model that are not defined by SBML, such as in the
   * application-specific content of the 'annotation' subelement.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @param metaid the identifier string to use as the value of the
   * 'metaid' attribute
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_INVALID_ATTRIBUTE_VALUE
   * <li> LIBSBML_UNEXPECTED_ATTRIBUTE
   * <p>
   * @see #getMetaId()
   * @see #isSetMetaId()
   <p>
 * @deprecated libSBML internal
 */
 public int setId(String sid) {
    return libsbmlJNI.SBase_setId(swigCPtr, this, sid);
  }

  
  /**
   * Sets the value of the 'metaid' attribute of this object.
   * <p>
   * The string <code>metaid</code> is copied.  The value of <code>metaid</code> must be an
   * identifier conforming to the syntax defined by the XML 1.0 data type
   * <a href='http://www.w3.org/TR/REC-xml/#id'>ID</a>.  Among other
   * things, this type requires that a value is unique among all the values
   * of type XML ID in an {@link SBMLDocument}.  Although SBML only uses <a
   * href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a> for the 'metaid'
   * attribute, callers should be careful if they use
   * <a href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>'s in XML
   * portions of a model that are not defined by SBML, such as in the
   * application-specific content of the 'annotation' subelement.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @param metaid the identifier string to use as the value of the
   * 'metaid' attribute
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_INVALID_ATTRIBUTE_VALUE
   * <li> LIBSBML_UNEXPECTED_ATTRIBUTE
   * <p>
   * @see #getMetaId()
   * @see #isSetMetaId()
   <p>
 * @deprecated libSBML internal
 */
 public int setName(String name) {
    return libsbmlJNI.SBase_setName(swigCPtr, this, name);
  }

  
  /**
   * Resets the value of the 'annotation' subelement of this SBML object to a
   * copy of <code>annotation</code>.
   * <p>
   * Whereas the {@link SBase} 'notes' subelement is a container for content to be
   * shown directly to humans, the 'annotation' element is a container for
   * optional software-generated content <em>not</em> meant to be shown to
   * humans.  Every object derived from {@link SBase} can have its own value for
   * 'annotation'.  The element's content type is XML type
   * <code>any</code>, allowing essentially arbitrary well-formed XML data
   * content.
   * <p>
   * SBML places a few restrictions on the organization of the content of
   * annotations; these are intended to help software tools read and write
   * the data as well as help reduce conflicts between annotations added by
   * different tools.  Please see the SBML specifications for more details.
   * <p>
   * Call this method will result in any existing content of the
   * 'annotation' subelement to be discarded.  Unless you have taken steps
   * to first copy and reconstitute any existing annotations into the 
   * <code>annotation</code> that is about to be assigned, it is likely that performing
   * such wholesale replacement is unfriendly towards other software
   * applications whose annotations are discarded.  An alternative may be
   * to use {@link SBase#appendAnnotation(XMLNode  annotation)} or
   * {@link SBase#appendAnnotation(String annotation)}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @param annotation an XML structure that is to be used as the new content
   * of the 'annotation' subelement of this object
   * <p>
   * @see #getAnnotationString()
   * @see #isSetAnnotation()
   * @see #setAnnotation(String annotation)
   * @see #appendAnnotation(XMLNode  annotation)
   * @see #appendAnnotation(String annotation)
   * @see #unsetAnnotation()
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <p>
   * @see #getAnnotationString()
   * @see #isSetAnnotation()
   * @see #setAnnotation(String annotation)
   * @see #appendAnnotation(XMLNode  annotation)
   * @see #appendAnnotation(String annotation)
   * @see #unsetAnnotation()
   */
 public int setAnnotation(XMLNode annotation) {
    return libsbmlJNI.SBase_setAnnotation__SWIG_0(swigCPtr, this, XMLNode.getCPtr(annotation), annotation);
  }

  
  /**
   * Sets the value of the 'annotation' subelement of this SBML object to a
   * copy of <code>annotation</code> given as a character string.
   * <p>
   * Whereas the {@link SBase} 'notes' subelement is a container for content to be
   * shown directly to humans, the 'annotation' element is a container for
   * optional software-generated content <em>not</em> meant to be shown to
   * humans.  Every object derived from {@link SBase} can have its own value for
   * 'annotation'.  The element's content type is XML type
   * <code>any</code>, allowing essentially arbitrary well-formed XML data
   * content.
   * <p>
   * SBML places a few restrictions on the organization of the content of
   * annotations; these are intended to help software tools read and write
   * the data as well as help reduce conflicts between annotations added by
   * different tools.  Please see the SBML specifications for more details.
   * <p>
   * Call this method will result in any existing content of the
   * 'annotation' subelement to be discarded.  Unless you have taken steps
   * to first copy and reconstitute any existing annotations into the 
   * <code>annotation</code> that is about to be assigned, it is likely that performing
   * such wholesale replacement is unfriendly towards other software
   * applications whose annotations are discarded.  An alternative may be
   * to use {@link SBase#appendAnnotation(XMLNode  annotation)} or
   * {@link SBase#appendAnnotation(String annotation)}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @param annotation an XML string that is to be used as the content
   * of the 'annotation' subelement of this object
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_OPERATION_FAILED
   * <p>
   * @see #getAnnotationString()
   * @see #isSetAnnotation()
   * @see #setAnnotation(XMLNode  annotation)
   * @see #appendAnnotation(XMLNode  annotation)
   * @see #appendAnnotation(String annotation)
   * @see #unsetAnnotation()
   */
 public int setAnnotation(String annotation) {
    return libsbmlJNI.SBase_setAnnotation__SWIG_1(swigCPtr, this, annotation);
  }

  
  /**
   * Appends the annotation content given by <code>annotation</code> to any existing
   * content in the 'annotation' subelement of this object.
   * <p>
   * Whereas the {@link SBase} 'notes' subelement is a container for content to be
   * shown directly to humans, the 'annotation' element is a container for
   * optional software-generated content <em>not</em> meant to be shown to
   * humans.  Every object derived from {@link SBase} can have its own value for
   * 'annotation'.  The element's content type is XML type
   * <code>any</code>, allowing essentially arbitrary well-formed XML data
   * content.
   * <p>
   * SBML places a few restrictions on the organization of the content of
   * annotations; these are intended to help software tools read and write
   * the data as well as help reduce conflicts between annotations added by
   * different tools.  Please see the SBML specifications for more details.
   * <p>
   * Unlike {@link SBase#setAnnotation(XMLNode  annotation)} or
   * {@link SBase#setAnnotation(String annotation)}, this method
   * allows other annotations to be preserved when an application adds its
   * own data.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @param annotation an XML structure that is to be copied and appended
   * to the content of the 'annotation' subelement of this object
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_OPERATION_FAILED
   * <p>
   * @see #getAnnotationString()
   * @see #isSetAnnotation()
   * @see #setAnnotation(XMLNode  annotation)
   * @see #setAnnotation(String annotation)
   * @see #appendAnnotation(String annotation)
   * @see #unsetAnnotation()
   */
 public int appendAnnotation(XMLNode annotation) {
    return libsbmlJNI.SBase_appendAnnotation__SWIG_0(swigCPtr, this, XMLNode.getCPtr(annotation), annotation);
  }

  
  /**
   * Appends the annotation content given by <code>annotation</code> to any existing
   * content in the 'annotation' subelement of this object.
   * <p>
   * Whereas the {@link SBase} 'notes' subelement is a container for content to be
   * shown directly to humans, the 'annotation' element is a container for
   * optional software-generated content <em>not</em> meant to be shown to
   * humans.  Every object derived from {@link SBase} can have its own value for
   * 'annotation'.  The element's content type is XML type
   * <code>any</code>, allowing essentially arbitrary well-formed XML data
   * content.
   * <p>
   * SBML places a few restrictions on the organization of the content of
   * annotations; these are intended to help software tools read and write
   * the data as well as help reduce conflicts between annotations added by
   * different tools.  Please see the SBML specifications for more details.
   * <p>
   * Unlike {@link SBase#setAnnotation(XMLNode  annotation)} or
   * {@link SBase#setAnnotation(String annotation)}, this method
   * allows other annotations to be preserved when an application adds its
   * own data.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @param annotation an XML string that is to be copied and appended
   * to the content of the 'annotation' subelement of this object
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_OPERATION_FAILED
   * <p>
   * @see #getAnnotationString()
   * @see #isSetAnnotation()
   * @see #setAnnotation(XMLNode  annotation)
   * @see #setAnnotation(String annotation)
   * @see #appendAnnotation(XMLNode  annotation)
   * @see #unsetAnnotation()
   */
 public int appendAnnotation(String annotation) {
    return libsbmlJNI.SBase_appendAnnotation__SWIG_1(swigCPtr, this, annotation);
  }

  
  /**
   * Sets the value of the 'notes' subelement of this SBML object to a copy
   * of the XML structure given by <code>notes</code>.
   * <p>
   * Any existing content of the 'notes' subelement is discarded.
   * <p>
   * The optional element named 'notes', present on every major SBML
   * component type, is intended as a place for storing optional
   * information intended to be seen by humans.  An example use of the
   * 'notes' element would be to contain formatted user comments
   * about the model element in which the 'notes' element is
   * enclosed.  Every object derived directly or indirectly from type
   * {@link SBase} can have a separate value for 'notes', allowing users
   * considerable freedom when adding comments to their models.
   * The format of 'notes' elements must be XHTML 1.0.  The SBML
   * Level&nbsp;2 specification has considerable detail about how
   * 'notes' element content must be handled; please refer to the
   * specifications.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @param notes an XML structure that is to be used as the content of the
   * 'notes' subelement of this object
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_INVALID_OBJECT
   * <p>
   * @see #getNotesString()
   * @see #isSetNotes()
   * @see #setNotes(String notes)
   * @see #appendNotes(XMLNode  notes)
   * @see #appendNotes(String notes)
   * @see #unsetNotes()
   */
 public int setNotes(XMLNode notes) {
    return libsbmlJNI.SBase_setNotes__SWIG_0(swigCPtr, this, XMLNode.getCPtr(notes), notes);
  }

  
  /**
   * Sets the value of the 'notes' subelement of this SBML object to a copy
   * of the string <code>notes</code>.
   * <p>
   * Any existing content of the 'notes' subelement is discarded.
   * <p>
   * The optional element named 'notes', present on every major SBML
   * component type, is intended as a place for storing optional
   * information intended to be seen by humans.  An example use of the
   * 'notes' element would be to contain formatted user comments
   * about the model element in which the 'notes' element is
   * enclosed.  Every object derived directly or indirectly from type
   * {@link SBase} can have a separate value for 'notes', allowing users
   * considerable freedom when adding comments to their models.
   * The format of 'notes' elements must be XHTML 1.0.  The SBML
   * Level&nbsp;2 specification has considerable detail about how
   * 'notes' element content must be handled; please refer to the
   * specifications.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @param notes an XML string that is to be used as the content of the
   * 'notes' subelement of this object
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_INVALID_OBJECT
   * <li> LIBSBML_OPERATION_FAILED
   * <p>
   * @see #getNotesString()
   * @see #isSetNotes()
   * @see #setNotes(XMLNode  notes)
   * @see #appendNotes(XMLNode  notes)
   * @see #appendNotes(String notes)
   * @see #unsetNotes()
   */
 public int setNotes(String notes) {
    return libsbmlJNI.SBase_setNotes__SWIG_1(swigCPtr, this, notes);
  }

  
  /**
   * Appends notes content to the 'notes' element attached to this
   * object.
   * <p>
   * The content in <code>notes</code> is copied.
   * <p>
   * The optional element named 'notes', present on every major SBML
   * component type, is intended as a place for storing optional
   * information intended to be seen by humans.  An example use of the
   * 'notes' element would be to contain formatted user comments
   * about the model element in which the 'notes' element is
   * enclosed.  Every object derived directly or indirectly from type
   * {@link SBase} can have a separate value for 'notes', allowing users
   * considerable freedom when adding comments to their models.
   * The format of 'notes' elements must be XHTML 1.0.  The SBML
   * Level&nbsp;2 specification has considerable detail about how
   * 'notes' element content must be handled; please refer to the
   * specifications.
   * <p>
   * @param notes an XML node structure that is to appended to the content
   * of the 'notes' subelement of this object
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_INVALID_OBJECT
   * <li> LIBSBML_OPERATION_FAILED
   * <p>
   * @see #getNotesString()
   * @see #isSetNotes()
   * @see #setNotes(XMLNode  notes)
   * @see #setNotes(String notes)
   * @see #appendNotes(String notes)
   * @see #unsetNotes()
   */
 public int appendNotes(XMLNode notes) {
    return libsbmlJNI.SBase_appendNotes__SWIG_0(swigCPtr, this, XMLNode.getCPtr(notes), notes);
  }

  
  /**
   * Appends notes content to the 'notes' element attached to this
   * object.
   * <p>
   * The content in <code>notes</code> is copied.
   * <p>
   * The optional element named 'notes', present on every major SBML
   * component type, is intended as a place for storing optional
   * information intended to be seen by humans.  An example use of the
   * 'notes' element would be to contain formatted user comments
   * about the model element in which the 'notes' element is
   * enclosed.  Every object derived directly or indirectly from type
   * {@link SBase} can have a separate value for 'notes', allowing users
   * considerable freedom when adding comments to their models.
   * The format of 'notes' elements must be XHTML 1.0.  The SBML
   * Level&nbsp;2 specification has considerable detail about how
   * 'notes' element content must be handled; please refer to the
   * specifications.
   * <p>
   * @param notes an XML string that is to appended to the content of
   * the 'notes' subelement of this object
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_INVALID_OBJECT
   * <li> LIBSBML_OPERATION_FAILED
   * <p>
   * @see #getNotesString()
   * @see #isSetNotes()
   * @see #setNotes(XMLNode  notes)
   * @see #setNotes(String notes)
   * @see #appendNotes(XMLNode  notes)
   * @see #unsetNotes()
   */
 public int appendNotes(String notes) {
    return libsbmlJNI.SBase_appendNotes__SWIG_1(swigCPtr, this, notes);
  }

  
  /**
   * Sets the value of the 'sboTerm' attribute.
   * <p>
   * In SBML Level 2 Versions 2, 3 and 4, the data type of the SBML 'sboTerm'
   * attribute is a string of the form SBO:NNNNNNN, where NNNNNNN is a
   * seven digit integer number; libSBML simplifies the representation by
   * only storing the NNNNNNN integer portion.  Thus, in libSBML, the
   * 'sboTerm' attribute on {@link SBase} has data type <code>int</code>, and {@link SBO} identifiers
   * are stored simply as integers.  {@link SBO} terms are a type of optional
   * annotation, and each different class of SBML object derived from {@link SBase}
   * imposes its own requirements about the values permitted for 'sboTerm'.
   * Please consult the SBML Level 2 Version 4 specification for more
   * information about the use of {@link SBO} and the 'sboTerm' attribute.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @param value the NNNNNNN integer portion of the {@link SBO} identifier
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_INVALID_ATTRIBUTE_VALUE
   * <li> LIBSBML_UNEXPECTED_ATTRIBUTE
   */
 public int setSBOTerm(int value) {
    return libsbmlJNI.SBase_setSBOTerm__SWIG_0(swigCPtr, this, value);
  }

  
  /**
   * Sets the value of the 'sboTerm' attribute.
   * <p>
   * In SBML Level 2 Versions 2, 3 and 4, the data type of the SBML 'sboTerm'
   * attribute is a string of the form SBO:NNNNNNN, where NNNNNNN is a
   * seven digit integer number; libSBML simplifies the representation by
   * only storing the NNNNNNN integer portion.  Thus, in libSBML, the
   * 'sboTerm' attribute on {@link SBase} has data type <code>int</code>, and {@link SBO} identifiers
   * are stored simply as integers.  {@link SBO} terms are a type of optional
   * annotation, and each different class of SBML object derived from {@link SBase}
   * imposes its own requirements about the values permitted for 'sboTerm'.
   * Please consult the SBML Level 2 Version 4 specification for more
   * information about the use of {@link SBO} and the 'sboTerm' attribute.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @param value the NNNNNNN integer portion of the {@link SBO} identifier
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_INVALID_ATTRIBUTE_VALUE
   * <li> LIBSBML_UNEXPECTED_ATTRIBUTE
   */
 public int setSBOTerm(String sboid) {
    return libsbmlJNI.SBase_setSBOTerm__SWIG_1(swigCPtr, this, sboid);
  }

  
  /**
   * Sets the namespaces relevant of this SBML object.
   * <p>
   * @param xmlns the namespaces to set
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   */
 public int setNamespaces(XMLNamespaces xmlns) {
    return libsbmlJNI.SBase_setNamespaces(swigCPtr, this, XMLNamespaces.getCPtr(xmlns), xmlns);
  }

  
  /**
   * Unsets the value of the 'metaid' attribute of this SBML object.
   * <p>
   * The optional attribute named 'metaid', present on every major SBML
   * component type, is for supporting metadata annotations using RDF
   * (Resource Description Format). The attribute value has the data type
   * <a href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>, the XML
   * identifier type, which means each 'metaid' value must be globally
   * unique within an SBML file.  (Importantly, this uniqueness criterion
   * applies across any attribute with type <a
   * href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>, not just the
   * 'metaid' attribute used by SBML&mdash;something to be aware of if your
   * application-specific XML content inside the 'annotation' subelement
   * happens to use <a href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>.)
   * The 'metaid' value serves to identify a model
   * component for purposes such as referencing that component from
   * metadata placed within 'annotation' subelements.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_OPERATION_FAILED
   */
 public int unsetMetaId() {
    return libsbmlJNI.SBase_unsetMetaId(swigCPtr, this);
  }

  
  /**
   * Unsets the value of the 'notes' subelement of this SBML object.
   * <p>
   * The optional element named 'notes', present on every major SBML
   * component type, is intended as a place for storing optional
   * information intended to be seen by humans.  An example use of the
   * 'notes' element would be to contain formatted user comments
   * about the model element in which the 'notes' element is
   * enclosed.  Every object derived directly or indirectly from type
   * {@link SBase} can have a separate value for 'notes', allowing users
   * considerable freedom when adding comments to their models.
   * The format of 'notes' elements must be XHTML 1.0.  The SBML
   * Level&nbsp;2 specification has considerable detail about how
   * 'notes' element content must be handled; please refer to the
   * specifications.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <p>
   * @see #getNotesString()
   * @see #isSetNotes()
   * @see #setNotes(XMLNode  notes)
   * @see #setNotes(String notes)
   * @see #appendNotes(XMLNode  notes)
   * @see #appendNotes(String notes)
   */
 public int unsetNotes() {
    return libsbmlJNI.SBase_unsetNotes(swigCPtr, this);
  }

  
  /**
   * Unsets the value of the 'annotation' subelement of this SBML object.
   * <p>
   * Whereas the {@link SBase} 'notes' subelement is a container for content to be
   * shown directly to humans, the 'annotation' element is a container for
   * optional software-generated content <em>not</em> meant to be shown to
   * humans.  Every object derived from {@link SBase} can have its own value for
   * 'annotation'.  The element's content type is XML type
   * <code>any</code>, allowing essentially arbitrary well-formed XML data
   * content.
   * <p>
   * SBML places a few restrictions on the organization of the content of
   * annotations; these are intended to help software tools read and write
   * the data as well as help reduce conflicts between annotations added by
   * different tools.  Please see the SBML specifications for more details.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <p>
   * @see #getAnnotation()
   * @see #getAnnotationString()
   * @see #isSetAnnotation()
   * @see #setAnnotation(XMLNode  annotation)
   * @see #setAnnotation(String annotation)
   * @see #appendAnnotation(XMLNode  annotation)
   * @see #appendAnnotation(String annotation)
   */
 public int unsetAnnotation() {
    return libsbmlJNI.SBase_unsetAnnotation(swigCPtr, this);
  }

  
  /**
   * Unsets the value of the 'sboTerm' attribute of this SBML object.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_UNEXPECTED_ATTRIBUTE
   */
 public int unsetSBOTerm() {
    return libsbmlJNI.SBase_unsetSBOTerm(swigCPtr, this);
  }

  
  /**
   * Adds a copy of the given {@link CVTerm} to this SBML object.
   * <p>
   * @param term the {@link CVTerm} to assign
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_OPERATION_FAILED
   * <li> LIBSBML_UNEXPECTED_ATTRIBUTE
   * <li> LIBSBML_INVALID_OBJECT
   * <p>
   * @note Since the CV Term uses the metaid of the object as a 
   * reference, if the object has no metaid set the {@link CVTerm} will
   * not be added.
   * <p>
   * @warning The fact that this method <em>copies</em> the object passed to it
   * means that the caller will be left holding a physically different
   * object instance than the one contained in <em>this</em> object.  Changes
   * made to the original object instance (such as resetting attribute
   * values) will <em>not affect the instance added here</em>.  In
   * addition, the caller should make sure to free the original object if
   * it is no longer being used, or else a memory leak will result.
   */
 public int addCVTerm(CVTerm term) {
    return libsbmlJNI.SBase_addCVTerm(swigCPtr, this, CVTerm.getCPtr(term), term);
  }

  
  /**
   * Returns a list of {@link CVTerm} objects in the annotations of this SBML
   * object.
   * <p>
   * @return the list of CVTerms for this SBML object.
   */
 public  CVTermList  getCVTerms() { 
  long cPtr = libsbmlJNI.SBase_getCVTerms__SWIG_0(swigCPtr, this);
  return (cPtr == 0) ? null : new  CVTermList(cPtr, true);
}

  
  /**
   * Returns the number of {@link CVTerm} objects in the annotations of this SBML
   * object.
   * <p>
   * @return the number of CVTerms for this SBML object.
   */
 public long getNumCVTerms() {
    return libsbmlJNI.SBase_getNumCVTerms(swigCPtr, this);
  }

  
  /**
   * Returns the nth {@link CVTerm} in the list of CVTerms of this SBML
   * object.
   * <p>
   * @param n long the index of the {@link CVTerm} to retrieve
   * <p>
   * @return the nth {@link CVTerm} in the list of CVTerms for this SBML object.
   */
 public CVTerm getCVTerm(long n) {
    long cPtr = libsbmlJNI.SBase_getCVTerm(swigCPtr, this, n);
    return (cPtr == 0) ? null : new CVTerm(cPtr, false);
  }

  
  /**
   * Clears the list of CVTerms of this SBML
   * object.
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_OPERATION_FAILED
   */
 public int unsetCVTerms() {
    return libsbmlJNI.SBase_unsetCVTerms(swigCPtr, this);
  }

  
  /**
   * Returns the BiologicalQualifier associated with this resource,
   * or BQB_UNKNOWN if the resource does not exist.
   * <p>
   * @param resource string representing the resource; e.g.,
   * 'http://www.geneontology.org/#GO:0005892'
   * <p>
   * @return the #BiolQualifierType_t value associated with the resource
   */
 public int getResourceBiologicalQualifier(String resource) {
    return libsbmlJNI.SBase_getResourceBiologicalQualifier(swigCPtr, this, resource);
  }

  
  /**
   * Returns the ModelQualifier associated with this resource,
   * or BQM_UNKNOWN if the resource does not exist.
   * <p>
   * @param resource string representing the resource; e.g.,
   * 'http://www.geneontology.org/#GO:0005892'
   * <p>
   * @return the #ModelQualifierType_t value associated with the resource
   */
 public int getResourceModelQualifier(String resource) {
    return libsbmlJNI.SBase_getResourceModelQualifier(swigCPtr, this, resource);
  }

  
  /**
   * Returns the {@link Model} object in which the current object is located.
   * <p>
   * @return the parent {@link Model} of this SBML object.
   */
 public Model getModel() {
    long cPtr = libsbmlJNI.SBase_getModel(swigCPtr, this);
    return (cPtr == 0) ? null : new Model(cPtr, false);
  }

  
  /**
   * Returns the SBML Level of the overall SBML document.
   * <p>
   * @return the SBML level of this SBML object.
   * <p>
   * @see #getVersion()
   */
 public long getLevel() {
    return libsbmlJNI.SBase_getLevel(swigCPtr, this);
  }

  
  /**
   * Returns the Version within the SBML Level of the overall SBML document.
   * <p>
   * @return the SBML version of this SBML object.
   * <p>
   * @see #getLevel()
   */
 public long getVersion() {
    return libsbmlJNI.SBase_getVersion(swigCPtr, this);
  }

  
  /**
   * Returns the libSBML type code for this object.
   * <p>
   * This method MAY return the typecode of this SBML object or it MAY
   * return SBML_UNKNOWN.  That is, subclasses of {@link SBase} are not required to
   * implement this method to return a typecode.  This method is meant
   * primarily for the LibSBML C interface where class and subclass
   * information is not readily available.
   * <p>
   * @return the #SBMLTypeCode_t value of this SBML object or SBML_UNKNOWN
   * (default).
   * <p>
   * @see #getElementName()
   */
 public int getTypeCode() {
    return libsbmlJNI.SBase_getTypeCode(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * object's level/version and namespace values correspond to a valid
   * SBML specification.
   * <p>
   * The valid combinations of SBML Level, Version and Namespace as of this release
   * of libSBML are the following: 
   * <ul>
   * <li> Level&nbsp;1 Version&nbsp;2 'http://www.sbml.org/sbml/level1'
   * <li> Level&nbsp;2 Version&nbsp;1 'http://www.sbml.org/sbml/level2'
   * <li> Level&nbsp;2 Version&nbsp;2 'http://www.sbml.org/sbml/level2/version2'
   * <li> Level&nbsp;2 Version&nbsp;3 'http://www.sbml.org/sbml/level2/version3'
   * <li> Level&nbsp;2 Version&nbsp;4 'http://www.sbml.org/sbml/level2/version4'
   * </ul>
   * <p>
   * @return <code>true</code> if the level, version and namespace values of this 
   * SBML object correspond to a valid set of values, <code>false</code> otherwise.
   */
 public boolean hasValidLevelVersionNamespaceCombination() {
    return libsbmlJNI.SBase_hasValidLevelVersionNamespaceCombination(swigCPtr, this);
  }

  
  /**
   * Returns the XML element name of this object.
   * <p>
   * This is overridden by subclasses to return a string appropriate to the
   * SBML component.  For example, {@link Model} defines it as returning 'model',
   * {@link CompartmentType} defines it as returning 'compartmentType', etc.
   */
 public String getElementName() {
    return libsbmlJNI.SBase_getElementName(swigCPtr, this);
  }

  
  /**
   * Returns a string that consists of the partial SBML describing this
   * object.  This is primarily provided for testing and debugging
   * purposes.  It may be removed in a future version of libSBML.
   * <p>
   * @return the partial SBML that describes this SBML object.
   */
 public String toSBML() {
    return libsbmlJNI.SBase_toSBML(swigCPtr, this);
  }

  
  /**
   * Subclasses should override this method to write out their contained
   * SBML objects as XML elements.  Be sure to call your parents
   * implementation of this method as well.  For example:
   * <p>
   *   {@link SBase#writeElements(stream)};
   *   mReactans.write(stream);
   *   mProducts.write(stream);
   *   ...
   <p>
 * @deprecated libSBML internal
 */
 public boolean hasRequiredAttributes() {
    return libsbmlJNI.SBase_hasRequiredAttributes(swigCPtr, this);
  }

  
  /**
   * Subclasses should override this method to write out their contained
   * SBML objects as XML elements.  Be sure to call your parents
   * implementation of this method as well.  For example:
   * <p>
   *   {@link SBase#writeElements(stream)};
   *   mReactans.write(stream);
   *   mProducts.write(stream);
   *   ...
   <p>
 * @deprecated libSBML internal
 */
 public boolean hasRequiredElements() {
    return libsbmlJNI.SBase_hasRequiredElements(swigCPtr, this);
  }

}
