/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.40
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * Methods for checking syntax of ids, metaids and units
 * <p>
 */

public class SyntaxChecker {
   private long swigCPtr;
   protected boolean swigCMemOwn;

   protected SyntaxChecker(long cPtr, boolean cMemoryOwn)
   {
     swigCMemOwn = cMemoryOwn;
     swigCPtr    = cPtr;
   }

   protected static long getCPtr(SyntaxChecker obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (SyntaxChecker obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_SyntaxChecker(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether the
   * argument string conforms to the SBML type SId. 
   * <p>
   * @param sid string to be checked for conformance
   * <p>
   * @return <code>true</code> if the string conforms to type SId, <code>false</code> otherwise.
   * <p>
   * @note The literal representation of SBML type SId consists of strings 
   * of characters restricted to:
   * <p>
   *  - letter .= 'a'..'z','A'..'Z'
   *  - digit  .= '0'..'9'
   *  - idChar .= letter | digit | '_'
   *  - SId    .= ( letter | '_' ) idChar*
   */
 public static boolean isValidSBMLSId(String sid) {
    return libsbmlJNI.SyntaxChecker_isValidSBMLSId(sid);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether the
   * argument string conforms to the XML 1.0 type ID. 
   * <p>
   * @param id string to be checked for conformance
   * <p>
   * @return <code>true</code> if the string conforms to type ID, <code>false</code> otherwise.
   * <p>
   * @note The literal representation of XML 1.0 type ID consists of strings 
   * of characters restricted to:
   * <p>
   *  - NCNameChar .= letter | digit | '.' | '-' | '_' | ':' | CombiningChar | Extender
   *  - ID .= ( letter | '_' | ':' ) NCNameChar*
   */
 public static boolean isValidXMLID(String id) {
    return libsbmlJNI.SyntaxChecker_isValidXMLID(id);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether the
   * argument string conforms to the SBML type UnitSId. 
   * <p>
   * @param units string to be checked for conformance
   * <p>
   * @return <code>true</code> if the string conforms to type UnitSId, 
   * <code>false</code> otherwise.
   * <p>
   * @note The literal representation of SBML type UniySId consists of strings 
   * of characters restricted to:
   * <p>
   *  - letter .= 'a'..'z','A'..'Z'
   *  - digit  .= '0'..'9'
   *  - idChar .= letter | digit | '_'
   *  - UnitSId    .= ( letter | '_' ) idChar*
   */
 public static boolean isValidUnitSId(String units) {
    return libsbmlJNI.SyntaxChecker_isValidUnitSId(units);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether the
   * argument {@link XMLNode} represents XHTML that conforms to the 
   * requirements of the SBML specification.
   * <p>
   * @param xhtml the {@link XMLNode} to be checked for conformance.
   * @param sbmlns the {@link SBMLNamespaces} associated with the object.
   * <p>
   * @return <code>true</code> if the {@link XMLNode} conforms, <code>false</code> otherwise.
   * <p>
   * @note the optional {@link SBMLNamespaces} argument can be used to
   * check for the declaration of the XHTML namespace at the top-level
   * within an {@link SBMLDocument}.
   */
 public static boolean hasExpectedXHTMLSyntax(XMLNode xhtml, SBMLNamespaces sbmlns) {
    return libsbmlJNI.SyntaxChecker_hasExpectedXHTMLSyntax__SWIG_0(XMLNode.getCPtr(xhtml), xhtml, SBMLNamespaces.getCPtr(sbmlns), sbmlns);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether the
   * argument {@link XMLNode} represents XHTML that conforms to the 
   * requirements of the SBML specification.
   * <p>
   * @param xhtml the {@link XMLNode} to be checked for conformance.
   * @param sbmlns the {@link SBMLNamespaces} associated with the object.
   * <p>
   * @return <code>true</code> if the {@link XMLNode} conforms, <code>false</code> otherwise.
   * <p>
   * @note the optional {@link SBMLNamespaces} argument can be used to
   * check for the declaration of the XHTML namespace at the top-level
   * within an {@link SBMLDocument}.
   */
 public static boolean hasExpectedXHTMLSyntax(XMLNode xhtml) {
    return libsbmlJNI.SyntaxChecker_hasExpectedXHTMLSyntax__SWIG_1(XMLNode.getCPtr(xhtml), xhtml);
  }

  public SyntaxChecker() {
    this(libsbmlJNI.new_SyntaxChecker(), true);
  }

}
