/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.40
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * Container for an SBML document and interface for global operations
 * on SBML documents.
 * <p>
 * LibSBML uses the class
 * {@link SBMLDocument} as a top-level container for storing SBML content and data
 * associated with it (such as warnings and error messages).  The two
 * primary means of reading an SBML model, {@link SBMLReader#readSBML(String
 * filename)} and {@link SBMLReader#readSBMLFromString(String xml)}, both return a
 * pointer to an {@link SBMLDocument} object.  From there, callers can inquire
 * about any errors encountered (e.g., using SBMLDocument.getNumErrors()),
 * access the {@link Model} object, and perform other actions such as
 * consistency-checking and model translation. 
 * <p>
 * When creating fresh models programmatically, the starting point is
 * typically the creation of an {@link SBMLDocument} object instance.  The
 * {@link SBMLDocument} constructor accepts arguments for the SBML Level and
 * Version of the model to be created.  After creating the {@link SBMLDocument}
 * object, calling programs then typically call SBMLDocument.createModel()
 * almost immediately, and then proceed to call the methods on the {@link Model}
 * object to fill out the model's contents.
 * <p>
 * {@link SBMLDocument} corresponds roughly to the class <i>Sbml</i> defined in the
 * SBML Level&nbsp;2 specification.  It does not have a direct
 * correspondence in SBML Level&nbsp;1.  (However, to make matters simpler
 * for applications, libSBML creates an {@link SBMLDocument} no matter whether the model
 * is Level&nbsp;1 or Level&nbsp;2.)  In its barest form, when written out
 * in XML format for SBML Level&nbsp;2 Version&nbsp;4, the corresponding
 * structure is the following:
 * <div class='fragment'><pre>
&lt;sbml xmlns='http://www.sbml.org/sbml/level2/version4' level='2' version='4'
  ...
&lt;/sbml&gt;
</pre></div>
 * <p>
 * {@link SBMLDocument} is derived from {@link SBase}, and therefore contains the usual {@link SBase}
 * attributes (in SBML Level&nbsp;2 Version&nbsp;4) of 'metaid' and 'sboTerm', as
 * well as the subelements 'notes' and 'annotation'.  It also contains the
 * attributes 'level' and 'version' indicating the Level and Version of the
 * SBML data structure.  These can be accessed using the methods defined by
 * the {@link SBase} class for that purpose.
 * <p>
 * <h2>Checking consistency and adherence to SBML specifications</h2>
 * <p>
 * One of the most important features of libSBML is its ability to perform
 * SBML validation to ensure that a model adheres to the SBML specification
 * for whatever Level+Version combination the model uses.  {@link SBMLDocument}
 * provides the methods for running consistency-checking and validation
 * rules on the SBML content.
 * <p>
 * First, a brief explanation of the rationale is in order.  In libSBML
 * versions up to and including the version 3.3.x series, the individual
 * methods for creating and setting attributes and other components are
 * quite lenient, and allow a caller to compose SBML entities that may not,
 * in the end, represent valid SBML.  This allows applications the freedom
 * to do things such as save incomplete models (which is useful when models
 * are being developed over long periods of time), but at the same time, it
 * means that a separate validation step is necessary when a calling
 * program finally wants to finish a complete SBML document.
 * <p>
 * The primary interface to this facility is {@link SBMLDocument}'s
 * SBMLDocument.checkInternalConsistency() and
 * SBMLDocument.checkConsistency().  The former verifies the basic
 * internal consistency and syntax of an SBML document, and the latter
 * implements more elaborate validation rules (both those defined by the
 * SBML specifications, as well as additional rules offered by libSBML).
 * <p>
 * The checks
 * performed by SBMLDocument.checkInternalConsistency() are hardwired and
 * cannot be changed by calling programs, but the validation performed by
 * SBMLDocument.checkConsistency() is under program control using the
 * method {@link SBMLDocument#setConsistencyChecks(int categ, boolean onoff)}.
 * Applications can selectively disable specific kinds of checks that they
 * may not be interested by calling {@link SBMLDocument#setConsistencyChecks(int
 * categ, boolean onoff)} with appropriate parameters. 
 * <p>
 * These methods have slightly different relevance depending on whether a
 * model is created programmaticaly from scratch, or whether it is read in
 * from a file or data stream.  The following table summarizes the possible
 * scenarios.
 * <p>
 * <center>
 * <table border='0' class='text-table width80 normal-font alt-row-colors'>
 *  <tr style='background: lightgray; font-size: 14px;'>
 *      <th align='left' width='200'>Scenario</th>
 *      <th align='left'>Relevant methods</th>
 *  </tr>
 * <tr><td>Creating a model from scratch</td>
 * <td>Before writing out the model:<ol>
 * <p>
 * <li style='margin-bottom: 0.5em'>Call
 * SBMLDocument.checkInternalConsistency(), then inquire about the results by
 * calling SBMLDocument.getNumErrors()</li>
 * <p>
 * <li style='margin-bottom: 0.5em'>
 * Call {@link SBMLDocument#setConsistencyChecks(int categ, boolean onoff)}  to configure which checks
 * will be performed by SBMLDocument.checkConsistency()</li>
 * <p>
 * <li>Call SBMLDocument.checkConsistency(), then inquire about the results by
 * calling SBMLDocument.getNumErrors()</li>
 * </ol>
 * </td>
 * <tr><td>Reading a model from a file or data stream</td>
 * <td>After reading the model:<ol>
 * <p>
 * <li style='margin-bottom: 0.5em'>Basic consistency checks will have been
 * performed automatically by libSBML upon reading the content&mdash;only need
 * to inquire about the results by using SBMLDocument.getNumErrors()</li>
 * <p>
 * <li style='margin-bottom: 0.5em'>
 * Call {@link SBMLDocument#setConsistencyChecks(int categ, boolean onoff)}  to configure which
 * checks are performed by SBMLDocument.checkConsistency()</li>
 * <p>
 * <li>Call SBMLDocument.checkConsistency(), then inquire about the results
 * by calling SBMLDocument.getNumErrors()</li>
 * </ol>
 * </td>
 * </table>
 * </center>
 * <p>
 * <p>
 * <p>
 * <h2>Converting documents between Levels and Versions of SBML</h2>
 * <p>
 * LibSBML provides facilities for limited translation of SBML between
 * Levels and Versions of the SBML specifications.  The method for doing is
 * is {@link SBMLDocument#setLevelAndVersion(long lev, long ver)} .  In 
 * general, models can be converted upward without difficulty (e.g., from
 * SBML Level&nbsp;1 to Level&nbsp;2, or from an earlier Version of
 * Level&nbsp;2 to the latest Version of Level&nbsp;2).  Sometimes models
 * can be translated downward as well, if they do not use constructs
 * specific to more advanced Levels of SBML.
 * <p>
 * Calling {@link SBMLDocument#setLevelAndVersion(long lev, long ver)}  will not <em>necessarily</em> lead
 * to a successful conversion.  The method will return a boolean value
 * to indicate success or failure.  Callers must check the error log (see 
 * next section) attached to the {@link SBMLDocument} object after calling
 * {@link SBMLDocument#setLevelAndVersion(long lev, long ver)}  in order to assess whether any
 * problems arose.
 * <p>
 * If an application is interested in translating to a lower Level and/or
 * Version of SBML within a Level, the following methods allow for prior
 * assessment of whether there is sufficient compatibility to make a
 * translation possible:
 * <p>
 * <li> SBMLDocument.checkL1Compatibility(),
 * <li> SBMLDocument.checkL2v1Compatibility(),
 * <li> SBMLDocument.checkL2v2Compatibility(),
 * <li> SBMLDocument.checkL2v3Compatibility(), and
 * <li> SBMLDocument.checkL2v4Compatibility().
 * <p>
 * Some changes between Versions of SBML Level&nbsp;2 may lead to
 * unexpected behaviors when attempting conversions in either direction.
 * For example, SBML Level&nbsp;2 Version&nbsp;4 relaxed the requirement
 * for consistency in units of measurement between expressions annd
 * quantities in a model.  As a result, a model written in Version&nbsp;4,
 * if converted to Version&nbsp;3 with no other changes, may fail
 * validation as a Version&nbsp;3 model because Version&nbsp;3 imposed
 * stricter requirements on unit consistency.
 * <p>
 * <h2>Error handling</h2>
 * <p>
 * Upon reading a model, {@link SBMLDocument} logs any problems encountered while
 * reading the model from the file or data stream.  The log contains
 * objects that record diagnostic information about any notable issues that
 * arose.  Whether the problems are warnings or errors, they are both
 * reported through a single common interface involving the object class
 * {@link SBMLError}.
 * <p>
 * The methods SBMLDocument.getNumErrors(), {@link SBMLDocument#getError(long n)}  and
 * SBMLDocument.printErrors() allow callers to interact with the warnings
 * or errors logged.  Alternatively, callers may retrieve the entire log as
 * an {@link SBMLErrorLog} object using the method SBMLDocument.getErrorLog().
 * The {@link SBMLErrorLog} object provides some alternative methods for
 * interacting with the set of errors and warnings.  In either case,
 * applications typically should first call SBMLDocument.getNumErrors() to
 * find out if any issues have been logged after specific libSBML
 * operations such as the ones discussed in the sections above.  If they
 * have, then an application will should proceed to inspect the individual
 * reports using either the direct interfaces on {@link SBMLDocument} or using the
 * methods on the {@link SBMLErrorLog} object.
 * <p>
 * <p>
 * <p>
 * <p>
 * <hr style='margin: 1em auto'>
 */

public class SBMLDocument extends SBase {
   private long swigCPtr;

   protected SBMLDocument(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.SWIGSBMLDocumentUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(SBMLDocument obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (SBMLDocument obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_SBMLDocument(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  
  /**
   * The default SBML Level of new {@link SBMLDocument} objects.
   * <p>
   * This 'default level' corresponds to the most recent SBML specification
   * Level available at the time this version of libSBML was released.  For
   * this copy of libSBML, the value is <code>2</code>.  The default Level
   * is used by {@link SBMLDocument} if no Level is explicitly specified at the
   * time of the construction of an {@link SBMLDocument} instance. 
   * <p>
   * @return an integer indicating the most recent SBML specification Level
   * <p>
   * @see #getDefaultVersion()
   */
 public static long getDefaultLevel() {
    return libsbmlJNI.SBMLDocument_getDefaultLevel();
  }

  
  /**
   * The default Version of new {@link SBMLDocument} objects.
   * <p>
   * This 'default version' corresponds to the most recent SBML Version
   * within the most recent Level of SBML available at the time this
   * version of libSBML was released.  For this copy of libSBML, the value
   * is <code>4</code>.  The default Version is used by {@link SBMLDocument} if no
   * Version is explicitly specified at the time of the construction of an
   * {@link SBMLDocument} instance.
   * <p>
   * @return an integer indicating the most recent SBML specification
   * Version
   * <p>
   * @see #getDefaultLevel()
   */
 public static long getDefaultVersion() {
    return libsbmlJNI.SBMLDocument_getDefaultVersion();
  }

  
  /**
   * Creates a new {@link SBMLDocument}, optionally with given values for the SBML
   * Level and Version.
   * <p>
   * If <em>both</em> the SBML Level and Version attributes are not
   * specified, the SBML document is treated as having the latest Level and
   * Version of SBML as determined by SBMLDocument.getDefaultLevel() and
   * SBMLDocument.getDefaultVersion(); <em>however</em>, the {@link SBMLDocument}
   * object is otherwise left blank.  In particular, the blank {@link SBMLDocument}
   * object has no associated XML attributes, including (but not limited
   * to) an XML namespace declaration.  The XML namespace declaration is
   * not added until the model is written out, <em>or</em> the method
   * {@link SBMLDocument#setLevelAndVersion(long lev, long ver)}  is called.  This may be important to keep in mind
   * if an application needs to add additional XML namespace declarations
   * on the <code>&lt;sbml&gt;</code> element.  Application writers should
   * either provide values for <code>level</code> and <code>version</code> on the call to this
   * constructor, or else call {@link SBMLDocument#setLevelAndVersion(long lev, long ver)}  shortly after creating
   * the {@link SBMLDocument} object.
   * <p>
   * @param level an integer for the SBML Level
   * <p>
   * @param version an integer for the Version within the SBML Level
   * <p>
   * @see SBMLDocument#setLevelAndVersion(long lev, long ver) 
   * @see #getDefaultLevel()
   * @see #getDefaultVersion()
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public SBMLDocument(long level, long version) {
    this(libsbmlJNI.new_SBMLDocument__SWIG_0(level, version), true);
  }

  
  /**
   * Creates a new {@link SBMLDocument}, optionally with given values for the SBML
   * Level and Version.
   * <p>
   * If <em>both</em> the SBML Level and Version attributes are not
   * specified, the SBML document is treated as having the latest Level and
   * Version of SBML as determined by SBMLDocument.getDefaultLevel() and
   * SBMLDocument.getDefaultVersion(); <em>however</em>, the {@link SBMLDocument}
   * object is otherwise left blank.  In particular, the blank {@link SBMLDocument}
   * object has no associated XML attributes, including (but not limited
   * to) an XML namespace declaration.  The XML namespace declaration is
   * not added until the model is written out, <em>or</em> the method
   * {@link SBMLDocument#setLevelAndVersion(long lev, long ver)}  is called.  This may be important to keep in mind
   * if an application needs to add additional XML namespace declarations
   * on the <code>&lt;sbml&gt;</code> element.  Application writers should
   * either provide values for <code>level</code> and <code>version</code> on the call to this
   * constructor, or else call {@link SBMLDocument#setLevelAndVersion(long lev, long ver)}  shortly after creating
   * the {@link SBMLDocument} object.
   * <p>
   * @param level an integer for the SBML Level
   * <p>
   * @param version an integer for the Version within the SBML Level
   * <p>
   * @see SBMLDocument#setLevelAndVersion(long lev, long ver) 
   * @see #getDefaultLevel()
   * @see #getDefaultVersion()
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public SBMLDocument(long level) {
    this(libsbmlJNI.new_SBMLDocument__SWIG_1(level), true);
  }

  
  /**
   * Creates a new {@link SBMLDocument}, optionally with given values for the SBML
   * Level and Version.
   * <p>
   * If <em>both</em> the SBML Level and Version attributes are not
   * specified, the SBML document is treated as having the latest Level and
   * Version of SBML as determined by SBMLDocument.getDefaultLevel() and
   * SBMLDocument.getDefaultVersion(); <em>however</em>, the {@link SBMLDocument}
   * object is otherwise left blank.  In particular, the blank {@link SBMLDocument}
   * object has no associated XML attributes, including (but not limited
   * to) an XML namespace declaration.  The XML namespace declaration is
   * not added until the model is written out, <em>or</em> the method
   * {@link SBMLDocument#setLevelAndVersion(long lev, long ver)}  is called.  This may be important to keep in mind
   * if an application needs to add additional XML namespace declarations
   * on the <code>&lt;sbml&gt;</code> element.  Application writers should
   * either provide values for <code>level</code> and <code>version</code> on the call to this
   * constructor, or else call {@link SBMLDocument#setLevelAndVersion(long lev, long ver)}  shortly after creating
   * the {@link SBMLDocument} object.
   * <p>
   * @param level an integer for the SBML Level
   * <p>
   * @param version an integer for the Version within the SBML Level
   * <p>
   * @see SBMLDocument#setLevelAndVersion(long lev, long ver) 
   * @see #getDefaultLevel()
   * @see #getDefaultVersion()
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public SBMLDocument() {
    this(libsbmlJNI.new_SBMLDocument__SWIG_2(), true);
  }

  
  /**
   * Copy constructor; creates a copy of this {@link SBMLDocument}.
   */
 public SBMLDocument(SBMLDocument rhs) {
    this(libsbmlJNI.new_SBMLDocument__SWIG_3(SBMLDocument.getCPtr(rhs), rhs), true);
  }

  
  /**
   * Creates and returns a deep copy of this {@link SBMLDocument}.
   * <p>
   * @return a (deep) copy of this {@link SBMLDocument}.
   */
 public SBMLDocument cloneObject() {
    long cPtr = libsbmlJNI.SBMLDocument_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new SBMLDocument(cPtr, true);
  }

  
  /**
   * Returns the {@link Model} object stored in this {@link SBMLDocument}.
   * <p>
   * It is important to note that this method <em>does not create</em> a
   * {@link Model} instance.  The model in the {@link SBMLDocument} must have been created
   * at some prior time, for example using SBMLDocument.createModel() 
   * or {@link SBMLDocument#setModel(Model m)} .
   * This method returns NULL if a model does not yet exist.
   * <p>
   * @return the {@link Model} contained in this {@link SBMLDocument}.
   * <p>
   * @see #createModel()
   */
 public Model getModel() {
    long cPtr = libsbmlJNI.SBMLDocument_getModel__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new Model(cPtr, false);
  }

  
  /**
   * Sets the SBML Level and Version of this {@link SBMLDocument} instance,
   * attempting to convert the model as needed.
   * <p>
   * This method is the principal way in libSBML to convert models between
   * Levels and Versions of SBML.  Generally, models can be converted
   * upward without difficulty (e.g., from SBML Level&nbsp;1 to
   * Level&nbsp;2, or from an earlier Version of Level&nbsp;2 to the latest
   * Version of Level&nbsp;2).  Sometimes models can be translated downward
   * as well, if they do not use constructs specific to more advanced
   * Levels of SBML.
   * <p>
   * Before calling this method, callers may check compatibility directly
   * using the methods SBMLDocument.checkL1Compatibility(),
   * SBMLDocument.checkL2v1Compatibility(),
   * SBMLDocument.checkL2v2Compatibility(),
   * SBMLDocument.checkL2v3Compatibility() and
   * SBMLDocument.checkL2v4Compatibility().
   * <p>
   * The valid combinations of SBML Level and Version as of this release
   * of libSBML are the following: 
   * <ul>
   * <li> Level&nbsp;1 Version&nbsp;2
   * <li> Level&nbsp;2 Version&nbsp;1
   * <li> Level&nbsp;2 Version&nbsp;2
   * <li> Level&nbsp;2 Version&nbsp;3
   * <li> Level&nbsp;2 Version&nbsp;4
   * </ul>
   * <p>
   * @param level the desired SBML Level
   * <p>
   * @param version the desired Version within the SBML Level
   * <p>
   * @param strict boolean indicating whether to check consistency
   * of both the source and target model when performing
   * conversion (defaults to <code> true <\code>)
   * <p>
   * @note Calling this method will not <em>necessarily</em> lead to a successful
   * conversion.  If the conversion fails, it will be logged in the error
   * list associated with this {@link SBMLDocument}.  Callers should consult
   * getNumErrors() to find out if the conversion succeeded without
   * problems.  For conversions from Level&nbsp;2 to Level&nbsp;1, callers
   * can also check the Level of the model after calling this method to
   * find out whether it is Level&nbsp;1.  (If the conversion to
   * Level&nbsp;1 failed, the Level of this model will be left unchanged.)
   * <p>
   * @see #checkL1Compatibility()
   * @see #checkL2v1Compatibility()
   * @see #checkL2v2Compatibility()
   * @see #checkL2v3Compatibility()
   * @see #checkL2v4Compatibility()
   * <p>
   * Strict conversion applies the additional criteria that both the source
   * and the target model must be consistent SBML.  Users can control the
   * consistency checks that are applied using the 
   * SBMLDocument.setConsistencyChecksForConversion function.  If either 
   * the source
   * or the potential target model have validation errors, the conversion
   * is not performed.  When a strict conversion is successful, the
   * underlying SBML object model is altered to reflect the new level
   * and version.  Thus information that cannot be converted (e.g. sboTerms)
   * will be lost.   
   */
 public boolean setLevelAndVersion(long level, long version, boolean strict) {
    return libsbmlJNI.SBMLDocument_setLevelAndVersion__SWIG_0(swigCPtr, this, level, version, strict);
  }

  
  /**
   * Sets the SBML Level and Version of this {@link SBMLDocument} instance,
   * attempting to convert the model as needed.
   * <p>
   * This method is the principal way in libSBML to convert models between
   * Levels and Versions of SBML.  Generally, models can be converted
   * upward without difficulty (e.g., from SBML Level&nbsp;1 to
   * Level&nbsp;2, or from an earlier Version of Level&nbsp;2 to the latest
   * Version of Level&nbsp;2).  Sometimes models can be translated downward
   * as well, if they do not use constructs specific to more advanced
   * Levels of SBML.
   * <p>
   * Before calling this method, callers may check compatibility directly
   * using the methods SBMLDocument.checkL1Compatibility(),
   * SBMLDocument.checkL2v1Compatibility(),
   * SBMLDocument.checkL2v2Compatibility(),
   * SBMLDocument.checkL2v3Compatibility() and
   * SBMLDocument.checkL2v4Compatibility().
   * <p>
   * The valid combinations of SBML Level and Version as of this release
   * of libSBML are the following: 
   * <ul>
   * <li> Level&nbsp;1 Version&nbsp;2
   * <li> Level&nbsp;2 Version&nbsp;1
   * <li> Level&nbsp;2 Version&nbsp;2
   * <li> Level&nbsp;2 Version&nbsp;3
   * <li> Level&nbsp;2 Version&nbsp;4
   * </ul>
   * <p>
   * @param level the desired SBML Level
   * <p>
   * @param version the desired Version within the SBML Level
   * <p>
   * @param strict boolean indicating whether to check consistency
   * of both the source and target model when performing
   * conversion (defaults to <code> true <\code>)
   * <p>
   * @note Calling this method will not <em>necessarily</em> lead to a successful
   * conversion.  If the conversion fails, it will be logged in the error
   * list associated with this {@link SBMLDocument}.  Callers should consult
   * getNumErrors() to find out if the conversion succeeded without
   * problems.  For conversions from Level&nbsp;2 to Level&nbsp;1, callers
   * can also check the Level of the model after calling this method to
   * find out whether it is Level&nbsp;1.  (If the conversion to
   * Level&nbsp;1 failed, the Level of this model will be left unchanged.)
   * <p>
   * @see #checkL1Compatibility()
   * @see #checkL2v1Compatibility()
   * @see #checkL2v2Compatibility()
   * @see #checkL2v3Compatibility()
   * @see #checkL2v4Compatibility()
   * <p>
   * Strict conversion applies the additional criteria that both the source
   * and the target model must be consistent SBML.  Users can control the
   * consistency checks that are applied using the 
   * SBMLDocument.setConsistencyChecksForConversion function.  If either 
   * the source
   * or the potential target model have validation errors, the conversion
   * is not performed.  When a strict conversion is successful, the
   * underlying SBML object model is altered to reflect the new level
   * and version.  Thus information that cannot be converted (e.g. sboTerms)
   * will be lost.   
   */
 public boolean setLevelAndVersion(long level, long version) {
    return libsbmlJNI.SBMLDocument_setLevelAndVersion__SWIG_1(swigCPtr, this, level, version);
  }

  
  /**
   * Sets the {@link Model} for this {@link SBMLDocument} to a copy of the given {@link Model}.
   * <p>
   * @param m the new {@link Model} to use.
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_LEVEL_MISMATCH
   * <li> LIBSBML_VERSION_MISMATCH
   * <p>
   * @see #createModel()
   * @see #getModel()
   */
 public int setModel(Model m) {
    return libsbmlJNI.SBMLDocument_setModel(swigCPtr, this, Model.getCPtr(m), m);
  }

  
  /**
   * Creates a new {@link Model} inside this {@link SBMLDocument}, and returns a pointer to
   * it.
   * <p>
   * In SBML Level&nbsp;2, the use of an identifier on a {@link Model} object is
   * optional.  This method takes an optional argument, <code>sid</code>, for setting
   * the identifier.  If not supplied, the identifier attribute on the
   * {@link Model} instance is not set.
   * <p>
   * @param sid the identifier of the new {@link Model} to create.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   * <p>
   * @see #getModel()
   * @see SBMLDocument#setModel(Model m) 
   */
 public Model createModel(String sid) {
    long cPtr = libsbmlJNI.SBMLDocument_createModel__SWIG_0(swigCPtr, this, sid);
    return (cPtr == 0) ? null : new Model(cPtr, false);
  }

  
  /**
   * Creates a new {@link Model} inside this {@link SBMLDocument}, and returns a pointer to
   * it.
   * <p>
   * In SBML Level&nbsp;2, the use of an identifier on a {@link Model} object is
   * optional.  This method takes an optional argument, <code>sid</code>, for setting
   * the identifier.  If not supplied, the identifier attribute on the
   * {@link Model} instance is not set.
   * <p>
   * @param sid the identifier of the new {@link Model} to create.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   * <p>
   * @see #getModel()
   * @see SBMLDocument#setModel(Model m) 
   */
 public Model createModel() {
    long cPtr = libsbmlJNI.SBMLDocument_createModel__SWIG_1(swigCPtr, this);
    return (cPtr == 0) ? null : new Model(cPtr, false);
  }

  
  /**
   * Controls the consistency checks that are performed when
   * SBMLDocument.checkConsistency() is called.
   * <p>
   * This method works by adding or subtracting consistency checks from the
   * set of all possible checks that SBMLDocument.checkConsistency() knows
   * how to perform.  This method may need to be called multiple times in
   * order to achieve the desired combination of checks.  The first
   * argument (<code>category</code>) in a call to this method indicates the category
   * of consistency/error checks that are to be turned on or off, and the
   * second argument (<code>apply</code>, a boolean) indicates whether to turn it on
   * (value of <code>true</code>) or off (value of <code>false</code>).
   * <p>
   * The possible categories (values to the argument <code>category</code>) are the
   * set of values from the enumeration #SBMLErrorCategory_t.  The
   * following are the possible choices in libSBML version&nbsp;3.3.x:
   * <p>
   * <li> <code>LIBSBML_CAT_GENERAL_CONSISTENCY</code>: Correctness and consistency of
   * specific SBML language constructs.  Performing this set of checks is
   * highly recommended.  With respect to the SBML specification, these
   * concern failures in applying the validation rules numbered 2xxxx in
   * the Level&nbsp;2 Versions&nbsp;2, 3 and&nbsp;4 specifications.
   * <p>
   * <li> <code>LIBSBML_CAT_IDENTIFIER_CONSISTENCY</code>: Correctness and consistency
   * of identifiers used for model entities.  An example of inconsistency
   * would be using a species identifier in a reaction rate formula without
   * first having declared the species.  With respect to the SBML
   * specification, these concern failures in applying the validation rules
   * numbered 103xx in the Level&nbsp;2 Versions&nbsp;2, 3 and&nbsp;4
   * specifications.
   * <p>
   * <li> <code>LIBSBML_CAT_UNITS_CONSISTENCY</code>: Consistency of measurement units
   * associated with quantities in a model.  With respect to the SBML
   * specification, these concern failures in applying the validation rules
   * numbered 105xx in the Level&nbsp;2 Versions&nbsp;2, 3 and&nbsp;4
   * specifications.
   * <p>
   * <li> <code>LIBSBML_CAT_MATHML_CONSISTENCY</code>: Syntax of MathML constructs.
   * With respect to the SBML specification, these concern failures in
   * applying the validation rules numbered 102xx in the Level&nbsp;2
   * Versions&nbsp;2, 3 and&nbsp;4 specifications.
   * <p>
   * <li> <code>LIBSBML_CAT_SBO_CONSISTENCY</code>: Consistency and validity of {@link SBO}
   * identifiers (if any) used in the model.  With respect to the SBML
   * specification, these concern failures in applying the validation rules
   * numbered 107xx in the Level&nbsp;2 Versions&nbsp;2, 3 and&nbsp;4
   * specifications.
   * <p>
   * <li> <code>LIBSBML_CAT_OVERDETERMINED_MODEL</code>: Static analysis of
   * whether the system of equations implied by a model is mathematically
   * overdetermined.  With respect to the SBML specification, this is
   * validation rule #10601 in the SBML Level&nbsp;2 Versions&nbsp;2, 3
   * and&nbsp;4 specifications.
   * <p>
   * <li> <code>LIBSBML_CAT_MODELING_PRACTICE</code>: Additional checks for
   * recommended good modeling practice. (These are tests performed by
   * libSBML and do not have equivalent SBML validation rules.)
   * <p>
   * <em>By default, all validation checks are applied</em> to the model in
   * an {@link SBMLDocument} object <em>unless</em> {@link SBMLDocument#setConsistencyChecks(int categ, boolean onoff)}  is called to
   * indicate that only a subset should be applied.  Further, this default
   * (i.e., performing all checks) applies separately to <em>each new
   * {@link SBMLDocument} object</em> created.  In other words, each time a model
   * is read using {@link SBMLReader#readSBML(String filename)} , {@link SBMLReader#readSBMLFromString(String xml)} ,
   * or the global functions readSBML() and readSBMLFromString(), a new
   * {@link SBMLDocument} is created and for that document, a call to
   * SBMLDocument.checkConsistency() will default to applying all possible checks.
   * Calling programs must invoke {@link SBMLDocument#setConsistencyChecks(int categ, boolean onoff)}  for each such new
   * model if they wish to change the consistency checks applied.
   * <p>
   * @param category a value drawn from #SBMLErrorCategory_t indicating the
   * consistency checking/validation to be turned on or off
   * <p>
   * @param apply a boolean indicating whether the checks indicated by
   * <code>category</code> should be applied or not.
   * <p>
   * @see SBMLDocument#checkConsistency()
   */
 public void setConsistencyChecks(int category, boolean apply) {
    libsbmlJNI.SBMLDocument_setConsistencyChecks(swigCPtr, this, category, apply);
  }

  
  /**
   * Controls the consistency checks that are performed when
   * {@link SBMLDocument#setLevelAndVersion(level, version)} is called.
   * <p>
   * This method works by adding or subtracting consistency checks from the
   * set of all possible checks that may be performed to avoid conversion
   * to or from an invalid document.  This method may need to be called 
   * multiple times in
   * order to achieve the desired combination of checks.  The first
   * argument (<code>category</code>) in a call to this method indicates the category
   * of consistency/error checks that are to be turned on or off, and the
   * second argument (<code>apply</code>, a boolean) indicates whether to turn it on
   * (value of <code>true</code>) or off (value of <code>false</code>).
   * <p>
   * The possible categories (values to the argument <code>category</code>) are the
   * set of values from the enumeration #SBMLErrorCategory_t.  The
   * following are the possible choices in libSBML version&nbsp;4.x.x:
   * <p>
   * <li> <code>LIBSBML_CAT_GENERAL_CONSISTENCY</code>: Correctness and consistency of
   * specific SBML language constructs.  Performing this set of checks is
   * highly recommended.  With respect to the SBML specification, these
   * concern failures in applying the validation rules numbered 2xxxx in
   * the Level&nbsp;2 Versions&nbsp;2, 3 and&nbsp;4 specifications.
   * <p>
   * <li> <code>LIBSBML_CAT_IDENTIFIER_CONSISTENCY</code>: Correctness and consistency
   * of identifiers used for model entities.  An example of inconsistency
   * would be using a species identifier in a reaction rate formula without
   * first having declared the species.  With respect to the SBML
   * specification, these concern failures in applying the validation rules
   * numbered 103xx in the Level&nbsp;2 Versions&nbsp;2, 3 and&nbsp;4
   * specifications.
   * <p>
   * <li> <code>LIBSBML_CAT_UNITS_CONSISTENCY</code>: Consistency of measurement units
   * associated with quantities in a model.  With respect to the SBML
   * specification, these concern failures in applying the validation rules
   * numbered 105xx in the Level&nbsp;2 Versions&nbsp;2, 3 and&nbsp;4
   * specifications.
   * <p>
   * <li> <code>LIBSBML_CAT_MATHML_CONSISTENCY</code>: Syntax of MathML constructs.
   * With respect to the SBML specification, these concern failures in
   * applying the validation rules numbered 102xx in the Level&nbsp;2
   * Versions&nbsp;2, 3 and&nbsp;4 specifications.
   * <p>
   * <li> <code>LIBSBML_CAT_SBO_CONSISTENCY</code>: Consistency and validity of {@link SBO}
   * identifiers (if any) used in the model.  With respect to the SBML
   * specification, these concern failures in applying the validation rules
   * numbered 107xx in the Level&nbsp;2 Versions&nbsp;2, 3 and&nbsp;4
   * specifications.
   * <p>
   * <li> <code>LIBSBML_CAT_OVERDETERMINED_MODEL</code>: Static analysis of
   * whether the system of equations implied by a model is mathematically
   * overdetermined.  With respect to the SBML specification, this is
   * validation rule #10601 in the SBML Level&nbsp;2 Versions&nbsp;2, 3
   * and&nbsp;4 specifications.
   * <p>
   * <li> <code>LIBSBML_CAT_MODELING_PRACTICE</code>: Additional checks for
   * recommended good modeling practice. (These are tests performed by
   * libSBML and do not have equivalent SBML validation rules.)
   * <p>
   * <em>By default, all validation checks are applied</em> to the model in
   * an {@link SBMLDocument} object <em>unless</em> {@link SBMLDocument#setConsistencyChecks(int categ, boolean onoff)}  is called to
   * indicate that only a subset should be applied.  Further, this default
   * (i.e., performing all checks) applies separately to <em>each new
   * {@link SBMLDocument} object</em> created.  In other words, each time a model
   * is read using {@link SBMLReader#readSBML(String filename)} , {@link SBMLReader#readSBMLFromString(String xml)} ,
   * or the global functions readSBML() and readSBMLFromString(), a new
   * {@link SBMLDocument} is created and for that document, a call to
   * SBMLDocument.checkConsistency() will default to applying all possible checks.
   * Calling programs must invoke {@link SBMLDocument#setConsistencyChecks(int categ, boolean onoff)}  for each such new
   * model if they wish to change the consistency checks applied.
   * <p>
   * @param category a value drawn from #SBMLErrorCategory_t indicating the
   * consistency checking/validation to be turned on or off
   * <p>
   * @param apply a boolean indicating whether the checks indicated by
   * <code>category</code> should be applied or not.
   * <p>
   * @see SBMLDocument#setLevelAndVersion()
   */
 public void setConsistencyChecksForConversion(int category, boolean apply) {
    libsbmlJNI.SBMLDocument_setConsistencyChecksForConversion(swigCPtr, this, category, apply);
  }

  
  /**
   * Performs consistency checking and validation on this SBML document.
   * <p>
   * If this method returns a nonzero value (meaning, one or more
   * consistency checks have failed for SBML document), the failures may be
   * due to warnings <em>or</em> errors.  Callers should inspect the severity
   * flag in the individual {@link SBMLError} objects returned by
   * {@link SBMLDocument#getError(long n)}  to determine the nature of the failures.
   * <p>
   * @return the number of failed checks (errors) encountered.
   * <p>
   * @see SBMLDocument#checkInternalConsistency()
   */
 public long checkConsistency() {
    return libsbmlJNI.SBMLDocument_checkConsistency(swigCPtr, this);
  }

  
  /**
   * Performs consistency checking on libSBML's internal representation of 
   * an SBML {@link Model}.
   * <p>
   * Callers should query the results of the consistency check by calling
   * {@link SBMLDocument#getError(long n)} .
   * <p>
   * @return the number of failed checks (errors) encountered.
   * <p>
   * The distinction between this method and
   * SBMLDocument.checkConsistency() is that this method reports on
   * fundamental syntactic and structural errors that violate the XML
   * Schema for SBML; by contrast, SBMLDocument.checkConsistency()
   * performs more elaborate model verifications and also validation
   * according to the validation rules written in the appendices of the
   * SBML Level&nbsp;2 Versions&nbsp;2&ndash;4 specification documents.
   * <p>
   * @see SBMLDocument#checkConsistency()
   */
 public long checkInternalConsistency() {
    return libsbmlJNI.SBMLDocument_checkInternalConsistency(swigCPtr, this);
  }

  
  /**
   * Performs a set of consistency checks on the document to establish
   * whether it is compatible with SBML Level&nbsp;1 and can be converted
   * to Level&nbsp;1.
   * <p>
   * Callers should query the results of the consistency check by calling
   * {@link SBMLDocument#getError(long n)} .
   * <p>
   * @return the number of failed checks (errors) encountered.
   */
 public long checkL1Compatibility() {
    return libsbmlJNI.SBMLDocument_checkL1Compatibility(swigCPtr, this);
  }

  
  /**
   * Performs a set of consistency checks on the document to establish
   * whether it is compatible with SBML Level&nbsp;2 Version&nbsp;1 and can
   * be converted to Level&nbsp;2 Version&nbsp;1.
   * <p>
   * Callers should query the results of the consistency check by calling
   * {@link SBMLDocument#getError(long n)} .
   * <p>
   * @return the number of failed checks (errors) encountered.
   */
 public long checkL2v1Compatibility() {
    return libsbmlJNI.SBMLDocument_checkL2v1Compatibility(swigCPtr, this);
  }

  
  /**
   * Performs a set of consistency checks on the document to establish
   * whether it is compatible with SBML Level&nbsp;2 Version&nbsp;2 and can
   * be converted to Level&nbsp;2 Version&nbsp;2.
   * <p>
   * Callers should query the results of the consistency check by calling
   * {@link SBMLDocument#getError(long n)} .
   * <p>
   * @return the number of failed checks (errors) encountered.
   */
 public long checkL2v2Compatibility() {
    return libsbmlJNI.SBMLDocument_checkL2v2Compatibility(swigCPtr, this);
  }

  
  /**
   * Performs a set of consistency checks on the document to establish
   * whether it is compatible with SBML Level&nbsp;2 Version&nbsp;3 and can
   * be converted to Level&nbsp;2 Version&nbsp;3.
   * <p>
   * Callers should query the results of the consistency check by calling
   * {@link SBMLDocument#getError(long n)} .
   * <p>
   * @return the number of failed checks (errors) encountered.
   */
 public long checkL2v3Compatibility() {
    return libsbmlJNI.SBMLDocument_checkL2v3Compatibility(swigCPtr, this);
  }

  
  /**
   * Performs a set of consistency checks on the document to establish
   * whether it is compatible with SBML Level&nbsp;2 Version&nbsp;4 and can
   * be converted to Level&nbsp;2 Version&nbsp;4.
   * <p>
   * Callers should query the results of the consistency check by calling
   * {@link SBMLDocument#getError(long n)} .
   * <p>
   * @return the number of failed checks (errors) encountered.
   */
 public long checkL2v4Compatibility() {
    return libsbmlJNI.SBMLDocument_checkL2v4Compatibility(swigCPtr, this);
  }

  
  /**
   * Returns the nth error or warning encountered during parsing,
   * consistency checking, or attempted translation of this model.
   * <p>
   * Callers can use method XMLError.getSeverity() on the result to assess
   * the severity of the problem.  The possible severity levels range from
   * informational messages to fatal errors.
   * <p>
   * @return the error or warning indexed by integer <code>n</code>, or return 
   * <code>NULL</code> if <code>n &gt; (getNumErrors() - 1)</code>.
   * <p>
   * @param n the integer index of the error sought.
   * <p>
   * @see SBMLDocument#getNumErrors()
   */
 public SBMLError getError(long n) {
    long cPtr = libsbmlJNI.SBMLDocument_getError(swigCPtr, this, n);
    return (cPtr == 0) ? null : new SBMLError(cPtr, false);
  }

  
  /**
   * Returns the number of errors or warnings encountered during parsing,
   * consistency checking, or attempted translation of this model.
   * <p>
   * @return the number of errors or warnings encountered
   */
 public long getNumErrors() {
    return libsbmlJNI.SBMLDocument_getNumErrors(swigCPtr, this);
  }

  
  /**
   * Prints to the given output stream all the errors or warnings
   * encountered during parsing, consistency checking, or attempted
   * translation of this model.
   * <p>
   * If no errors have occurred, i.e., <code>getNumErrors() == 0</code>, no
   * output will be sent to the stream.
   * <p>
   * The format of the output is:
   * <div class='fragment'><pre>
   N error(s):
     line NNN: (id) message
</pre></div>
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public void printErrors(OStream stream) {
    libsbmlJNI.SBMLDocument_printErrors__SWIG_0(swigCPtr, this, SWIGTYPE_p_std__ostream.getCPtr(stream.get_ostream()), stream);
  }

  
  /**
   * Prints to the given output stream all the errors or warnings
   * encountered during parsing, consistency checking, or attempted
   * translation of this model.
   * <p>
   * If no errors have occurred, i.e., <code>getNumErrors() == 0</code>, no
   * output will be sent to the stream.
   * <p>
   * The format of the output is:
   * <div class='fragment'><pre>
   N error(s):
     line NNN: (id) message
</pre></div>
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public void printErrors() {
    libsbmlJNI.SBMLDocument_printErrors__SWIG_1(swigCPtr, this);
  }

  
  /**
   * Returns the libSBML type code for this SBML object.
   * <p>
   * LibSBML attaches an
   * identifying code to every kind of SBML object.  These are known as
   * <em>SBML type codes</em>.  In other languages, the set of type codes
   * is stored in an enumeration; in the Java language interface for
   * libSBML, the type codes are defined as static integer constants in
   * interface class {@link libsbmlConstants}.  The names of the type codes
   * all begin with the characters <code>SBML_</code>. 
   * <p>
   * @return the SBML type code for this object, or <code>SBML_UNKNOWN</code> (default).
   * <p>
   * @see SBMLDocument#getElementName()
   */
 public int getTypeCode() {
    return libsbmlJNI.SBMLDocument_getTypeCode(swigCPtr, this);
  }

  
  /**
   * Returns the XML element name of this object, which for {@link SBMLDocument},
   * is always <code>'sbml'</code>.
   * <p>
   * @return the name of this element, i.e., <code>'sbml'</code>.
   */
 public String getElementName() {
    return libsbmlJNI.SBMLDocument_getElementName(swigCPtr, this);
  }

  
  /**
   * Returns the list of errors or warnings logged during parsing, 
   * consistency checking, or attempted translation of this model.
   * <p>
   * @return the {@link SBMLErrorLog} used for this {@link SBMLDocument}
   * <p>
   * @see SBMLDocument#getNumErrors()
   */
 public SBMLErrorLog getErrorLog() {
    long cPtr = libsbmlJNI.SBMLDocument_getErrorLog(swigCPtr, this);
    return (cPtr == 0) ? null : new SBMLErrorLog(cPtr, false);
  }

  
  /**
   * Returns a list of XML Namespaces associated with the XML content
   * of this SBML document.
   * <p>
   * @return the XML Namespaces associated with this SBML object
   */
 public XMLNamespaces getNamespaces() {
    long cPtr = libsbmlJNI.SBMLDocument_getNamespaces(swigCPtr, this);
    return (cPtr == 0) ? null : new XMLNamespaces(cPtr, false);
  }

}
