/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.40
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * LibSBML implementation of SBML's Constraint construct.
 * <p>
 * The {@link Constraint} object class was introduced in SBML Level 2 Version 2 as
 * a mechanism for stating the assumptions under which a model is designed
 * to operate.  The <em>constraints</em> are statements about permissible
 * values of different quantities in a model.  Constraints are not used to
 * compute dynamical values for simulation or analysis, but rather, they
 * serve an advisory role for simulation/analysis tools.
 * <p>
 * SBML's {@link Constraint} object class has one required attribute, 'id', to
 * give the parameter a unique identifier by which other parts of an SBML
 * model definition can refer to it.  A {@link Constraint} object can also have an
 * optional 'name' attribute of type <code>string</code>.  Identifiers and names must
 * be used according to the guidelines described in the SBML specification
 * (e.g., Section 3.3 in the Level 2 Version 4 specification).  
 * <p>
 * {@link Constraint} has one required subelement, 'math', containing a MathML
 * formula defining the condition of the constraint.  This formula must
 * return a boolean value of <code>true</code> when the model is a <em>valid</em>
 * state.  The formula can be an arbitrary expression referencing the
 * variables and other entities in an SBML model.  The evaluation of 'math'
 * and behavior of constraints are described in more detail below.
 * <p>
 * A {@link Constraint} structure also has an optional subelement called 'message'.
 * This can contain a message in XHTML format that may be displayed to the
 * user when the condition of the formula in the 'math' subelement
 * evaluates to a value of <code>false</code>.  Software tools are not required to
 * display the message, but it is recommended that they do so as a matter
 * of best practice.  The XHTML content within a 'message' subelement must
 * follow the same restrictions as for the 'notes' element on {@link SBase}
 * described in in the SBML Level 2 specification.  For example, 'message'
 * must not contain an XML declaration or a DOCTYPE declaration, and the
 * permitted content can only take one of the following general forms: (1)
 * a complete XHTML document beginning with the element
 * <code>&lt;html&gt;</code> and ending with <code>&lt;/xhtml&gt;</code>; 
 * (2) the body portion of a document beginning with the element
 * <code>&lt;body&gt;</code> and ending with <code>&lt;/body&gt;</code>; or
 * (3) XHTML content that is permitted within a <code>&lt;body&gt;</code> ...
 * <code>&lt;/body&gt;</code> elements.  The appendix of the SBML Level 2
 * Version 4 specification document describes one approach to reading the
 * 'message' subelement content.
 * <p>
 * {@link Constraint} was introduced in SBML Level 2 Version 2.  It is not
 * available in earlier versions of Level 2 nor in any version of Level 1.
 * <p>
 * <h2>Semantics of Constraints</h2>
 * <p>
 * In the context of a simulation, a {@link Constraint} has effect at all times
 * <em>t &#8805; 0</em>.  Each {@link Constraint}'s 'math' subelement is first
 * evaluated after any {@link InitialAssignment} definitions in a model at <em>t =
 * 0</em> and can conceivably trigger at that point.  (In other words, a
 * simulation could fail a constraint immediately.)
 * <p>
 * {@link Constraint} structures <em>cannot and should not</em> be used to compute
 * the dynamical behavior of a model as part of, for example, simulation.
 * Constraints may be used as input to non-dynamical analysis, for instance
 * by expressing flux constraints for flux balance analysis.
 * <p>
 * The results of a simulation of a model containing a constraint are
 * invalid from any simulation time at and after a point when the function
 * given by the 'math' subelement returns a value of <code>false</code>.  Invalid
 * simulation results do not make a prediction of the behavior of the
 * biochemical reaction network represented by the model.  The precise
 * behavior of simulation tools is left undefined with respect to
 * constraints.  If invalid results are detected with respect to a given
 * constraint, the 'message' subelement may optionally be displayed to the
 * user.  The simulation tool may also halt the simulation or clearly
 * delimit in output data the simulation time point at which the simulation
 * results become invalid.
 * <p>
 * SBML does not impose restrictions on duplicate {@link Constraint} definitions or
 * the order of evaluation of {@link Constraint} objects in a model.  It is
 * possible for a model to define multiple constraints all with the same
 * mathematical expression.  Since the failure of any constraint indicates
 * that the model simulation has entered an invalid state, a system is not
 * required to attempt to detect whether other constraints in the model
 * have failed once any one constraint has failed.
 * <p>
 * <!---------------------------------------------------------------------- -->
 * <p>
 */

public class Constraint extends SBase {
   private long swigCPtr;

   protected Constraint(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.SWIGConstraintUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(Constraint obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (Constraint obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_Constraint(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  
  /**
   * Creates a new {@link Constraint} using the given SBML <code>level</code> and <code>version</code>
   * values.
   * <p>
   * @param level a long integer, the SBML Level to assign to this {@link Constraint}
   * <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link Constraint}
   * <p>
   * @note Once a {@link Constraint} has been added to an {@link SBMLDocument}, the <code>level</code>,
   * <code>version</code> for the document <em>override</em> those used
   * to create the {@link Constraint}.  Despite this, the ability to supply the values
   * at creation time is an important aid to creating valid SBML.  Knowledge of
   * the intented SBML Level and Version determine whether it is valid to
   * assign a particular value to an attribute, or whether it is valid to add
   * an object to an existing {@link SBMLDocument}.
   */
 public Constraint(long level, long version) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_Constraint__SWIG_0(level, version), true);
  }

  
  /**
   * Creates a new {@link Constraint} using the given {@link SBMLNamespaces} object
   * <code>sbmlns</code>.
   * <p>
   * The {@link SBMLNamespaces} object encapsulates SBML Level/Version/namespaces
   * information.  It is used to communicate the SBML Level, Version, and
   * (in Level&nbsp;3) packages used in addition to SBML Level&nbsp; Core.
   * A common approach to using this class constructor is to create an
   * {@link SBMLNamespaces} object somewhere in a program, once, then pass it to
   * object constructors such as this one when needed.
   * <p>
   * @param sbmlns an {@link SBMLNamespaces} object.
   * <p>
   * @note Once a {@link Constraint} has been added to an {@link SBMLDocument}, the <code>level</code>,
   * <code>version</code> and <code>xmlns</code> namespaces for the document <em>override</em> those used
   * to create the {@link Constraint}.  Despite this, the ability to supply the values
   * at creation time is an important aid to creating valid SBML.  Knowledge of
   * the intented SBML Level and Version determine whether it is valid to
   * assign a particular value to an attribute, or whether it is valid to add
   * an object to an existing {@link SBMLDocument}.
   */
 public Constraint(SBMLNamespaces sbmlns) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_Constraint__SWIG_1(SBMLNamespaces.getCPtr(sbmlns), sbmlns), true);
  }

  
  /**
   * Copy constructor; creates a copy of this {@link Constraint}.
   */
 public Constraint(Constraint orig) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_Constraint__SWIG_2(Constraint.getCPtr(orig), orig), true);
  }

  
  /**
   * Creates and returns a deep copy of this {@link Constraint}.
   * <p>
   * @return a (deep) copy of this {@link Constraint}.
   */
 public Constraint cloneObject() {
    long cPtr = libsbmlJNI.Constraint_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new Constraint(cPtr, true);
  }

  
  /**
   * Get the message, if any, associated with this {@link Constraint}
   * <p>
   * @return the message for this {@link Constraint}, as an {@link XMLNode}.
   */
 public XMLNode getMessage() {
    long cPtr = libsbmlJNI.Constraint_getMessage(swigCPtr, this);
    return (cPtr == 0) ? null : new XMLNode(cPtr, false);
  }

  
  /**
   * Get the message string, if any, associated with this {@link Constraint}
   * <p>
   * @return the message for this {@link Constraint}, as a string.
   */
 public String getMessageString() {
    return libsbmlJNI.Constraint_getMessageString(swigCPtr, this);
  }

  
  /**
   * Get the mathematical expression of this {@link Constraint}
   * <p>
   * @return the math for this {@link Constraint}, as an {@link ASTNode}.
   */
 public ASTNode getMath() {
    long cPtr = libsbmlJNI.Constraint_getMath(swigCPtr, this);
    return (cPtr == 0) ? null : new ASTNode(cPtr, false);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether a
   * message has been defined for this {@link Constraint}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @return <code>true</code> if the message of this {@link Constraint} has been set,
   * <code>false</code> otherwise.
   */
 public boolean isSetMessage() {
    return libsbmlJNI.Constraint_isSetMessage(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether a
   * mathematical formula has been defined for this {@link Constraint}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @return <code>true</code> if the 'math' subelement for this {@link Constraint} has been
   * set, <code>false</code> otherwise.
   */
 public boolean isSetMath() {
    return libsbmlJNI.Constraint_isSetMath(swigCPtr, this);
  }

  
  /**
   * Sets the message of this {@link Constraint}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * The {@link XMLNode} tree passed in <code>xhtml</code> is copied.
   * <p>
   * @param xhtml an XML tree containing XHTML content.
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_INVALID_OBJECT
   */
 public int setMessage(XMLNode xhtml) {
    return libsbmlJNI.Constraint_setMessage(swigCPtr, this, XMLNode.getCPtr(xhtml), xhtml);
  }

  
  /**
   * Sets the mathematical expression of this {@link Constraint} to a copy of the
   * AST given as <code>math</code>.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @param math an {@link ASTNode} expression to be assigned as the 'math'
   * subelement of this {@link Constraint}
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_INVALID_OBJECT
   */
 public int setMath(ASTNode math) {
    return libsbmlJNI.Constraint_setMath(swigCPtr, this, ASTNode.getCPtr(math), math);
  }

  
  /**
   * Unsets the 'message' subelement of this {@link Constraint}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_OPERATION_FAILED
   */
 public int unsetMessage() {
    return libsbmlJNI.Constraint_unsetMessage(swigCPtr, this);
  }

  
  /**
   * Returns the libSBML type code for this SBML object.
   * <p>
   * LibSBML attaches an
   * identifying code to every kind of SBML object.  These are known as
   * <em>SBML type codes</em>.  In other languages, the set of type codes
   * is stored in an enumeration; in the Java language interface for
   * libSBML, the type codes are defined as static integer constants in
   * interface class {@link libsbmlConstants}.  The names of the type codes
   * all begin with the characters <code>SBML_</code>. 
   * <p>
   * @return the SBML type code for this object, or <code>SBML_UNKNOWN</code> (default).
   * <p>
   * @see #getElementName()
   */
 public int getTypeCode() {
    return libsbmlJNI.Constraint_getTypeCode(swigCPtr, this);
  }

  
  /**
   * Returns the XML element name of this object, which for {@link Constraint}, is
   * always <code>'constraint'</code>.
   * <p>
   * @return the name of this element, i.e., <code>'constraint'</code>.
   */
 public String getElementName() {
    return libsbmlJNI.Constraint_getElementName(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether
   * all the required elements for this {@link Constraint} object
   * have been set.
   * <p>
   * @note The required elements for a {@link Constraint} object are:
   * math
   * <p>
   * @return a boolean value indicating whether all the required
   * elements for this object have been defined.
   */
 public boolean hasRequiredElements() {
    return libsbmlJNI.Constraint_hasRequiredElements(swigCPtr, this);
  }

}
