# This file was automatically generated by SWIG (http://www.swig.org).
# Version 1.3.38
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

package LibSBML;
use base qw(Exporter);
use base qw(DynaLoader);
package LibSBMLc;
bootstrap LibSBML;
package LibSBML;
@EXPORT = qw();
=head1 NAME

LibSBML  -- interface to the libSBML library

=head1 SYNOPSIS

  # Change the following path to wherever your copy is installed.
  use lib '/usr/local/lib/perl5/site_perl';

  use File::Spec;
  use LibSBML;
  use strict;

  my $file     = File::Spec->rel2abs('FOO.xml');
  my $rd       = new LibSBML::SBMLReader;
  my $document = $rd->readSBML($file);
  
  # Check for reading errors:
  my $errors   = $document->getNumErrors();

  # Print errors, if any, to stderr.
  if ($errors > 0) {
    $document->printErrors();
    die "Errors while reading $file";
  }

  my $model = $document->getModel() || die "No Model found in $file";
  ... 

=head1 DESCRIPTION

The LibSBML.pm package gives access to almost all functions in libSBML
(http://sbml.org). The Perl wrapper is generated using SWIG
http://www.swig.org/ with relatively little manual intervention.  


=head1 AUTHORS

 Christoph Flamm <xtof@tbi.univie.ac.at>
 Rainer Machne   <raim@tbi.univie.ac.at>

=head1 FUNCTION INDEX

=over 8

=item getLibSBMLVersion

Returns the libSBML version as an integer: version 1.2.3 becomes 10203.
Returns the libSBML version as an integer: version 1.2.3 becomes 10203.


=item getLibSBMLDottedVersion

Returns the libSBML version as a string of the form "1.2.3".
Returns the libSBML version as a string of the form "1.2.3".


=item getLibSBMLVersionString

Returns the libSBML version as a string: version 1.2.3 becomes "10203".
Returns the libSBML version as a string: version 1.2.3 becomes "10203".


=back

=head2 SBMLReader

Methods for reading SBML from files and text strings.
@htmlinclude libsbml-not-sbml-warning.html
The SBMLReader class provides the main interface for reading SBML
content from files and strings.  The methods for reading SBML all return
an SBMLDocument object representing the results.
In the case of failures (such as if the SBML contains errors or a file
cannot be read), the errors will be recorded with the SBMLErrorLog object
kept in the SBMLDocument returned by SBMLReader.  Callers should check
for errors and warnings using the methods for this purpose provided on
SBMLDocument.

For convenience as well as easy access from other languages besides C++,
this file also defines two global functions, readSBML() and
readSBMLFromString().  They are equivalent to creating an SBMLReader
object and then calling
the @if clike SBMLReader::readSBML() @endif@if java SBMLReader::readSBML(String filename) @endif or
@if clike SBMLReader::readSBMLFromString() @endif@if java SBMLReader::readSBMLFromString(String xml)  @endif methods, respectively.


=over

=item SBMLReader::SBMLReader

Creates a new SBMLReader and returns it. 


=item SBMLReader::readSBML

Reads an SBML document from a file.
If the file named C<filename> does not exist or its content is not
valid SBML, one or more errors will be logged with the SBMLDocument
object returned by this method.  Callers can use the methods on
SBMLDocument such as SBMLDocument::getNumErrors() and
@if clike SBMLDocument::getError() @endif@if java SBMLDocument::getError(long n) @endif to get the errors.  The object returned by
@if clike SBMLDocument::getError() @endif@if java SBMLDocument::getError(long n) @endif is an SBMLError object, and it has methods to
get the error code, category, and severity level of the problem, as
well as a textual description of the problem.  The possible severity
levels range from informational messages to fatal errors; see the
documentation for SBMLError for more information.
If the file C<filename> could not be read, the file-reading error will
appear first.  The error code can provide a clue about what happened.
For example, a file might be unreadable (either because it does not
actually exist or because the user does not have the necessary access
priviledges to read it) or some sort of file operation error may have
bee reported by the underlying operating system.  Callers can check
for these situations using code such as the following:
C<ode>
SBMLReader  reader = new SBMLReader();
SBMLDocument  doc  = reader.readSBML(filename);
if (doc->getNumErrors() E<gt> 0)
{
if (doc->getError(0)->getId() == XMLError::FileUnreadable)
{
// Handle case of unreadable file here.
} 
else if (doc->getError(0)->getId() == XMLError::FileOperationError)
{
// Handle case of other file error here.
}
else
{
// Handle other cases -- see error codes defined in XMLErrorCode_t
// for other possible cases to check.
}
}
@endcode

If the given filename ends with the suffix C<">.gz" (for example, @c
"myfile.xml.gz"), the file is assumed to be compressed in I<gzip>
format and will be automatically decompressed upon reading.
Similarly, if the given filename ends with C<">.zip" or C<">.bz2", the
file is assumed to be compressed in I<zip> or I<bzip2> format
(respectively).  Files whose names lack these suffixes will be read
uncompressed.  Note that if the file is in I<zip> format but the
archive contains more than one file, only the first file in the
archive will be read and the rest ignored.
@param filename the name or full pathname of the file to be read.
Returns a pointer to the SBMLDocument created from the SBML content.
@see SBMLError
@note LibSBML versions 2.x and 3.x behave differently in error
handling in several respects.  One difference is how early some errors
are caught and whether libSBML continues processing a file in the face
of some early errors.  In general, libSBML 3.x stops parsing SBML
inputs sooner than libSBML 2.x in the face of XML errors because the
errors may invalidate any further SBML content.  For example, a
missing XML declaration at the beginning of the file was ignored by
libSBML 2.x but in version 3.x, it will cause libSBML to stop parsing
the rest of the input altogether.  While this behavior may seem more
severe and intolerant, it was necessary in order to provide uniform
behavior regardless of which underlying XML parser (Expat, Xerces,
libxml2) is being used by libSBML.  The XML parsers themselves behave
differently in their error reporting, and sometimes libSBML has to
resort to the lowest common denominator.
@note To read a gzip/zip file, libSBML needs to be configured and
linked with the <a href="http://www.zlib.net/">zlib</a> library at
compile time.  It also needs to be linked with the <a
href="">bzip2</a> library to read files in I<bzip2> format.  (Both of
these are the default configurations for libSBML.)  Errors about
unreadable files will be logged if a compressed filename is given and
libSBML was I<not> linked with the corresponding required library.
@note SBMLReader::hasZlib() and SBMLReader::hasBzip2() can be used to
check whether libSBML has been linked with each library.


=item SBMLReader::readSBMLFromString

Reads an SBML document from the given XML string.
This method is flexible with respect to the presence of an XML
declaration at the beginning of the string.  In particular, if the
string in C<xml> does not begin with the XML declaration
C<&lt;?xml version='1.0' encoding='UTF-8'?&gt;>, then this
method will automatically prepend the declaration to C<xml>.
This method will log a fatal error if the content given in the
parameter C<xml> is not SBML.  See the method documentation for
@if clike SBMLReader::readSBML() @endif@if java SBMLReader::readSBML(String filename) @endif for an example of code for testing the returned
error code.
@param xml a string containing a full SBML model
Returns a pointer to the SBMLDocument created from the SBML content.
@if clike @see SBMLReader::readSBML() @endif@if java @see SBMLReader::readSBML(String filename) @endif


=item SBMLReader::hasZlib

Predicate returning C<true> or C<false> depending on whether
libSBML is linked with zlib at compile time.
Returns C<true> if zlib is linked, C<false> otherwise.


=item SBMLReader::hasBzip2

Predicate returning C<true> or C<false> depending on whether
libSBML is linked with bzip2 at compile time.
Returns C<true> if bzip2 is linked, C<false> otherwise.


=item SBMLReader::readInternal

Used by readSBML() and readSBMLFromString().
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.

@deprecated libSBML internal


=item readSBML

Reads an SBML document from the given file C<filename>.
If C<filename> does not exist, or it is not an SBML file, an error will
be logged in the error log of the SBMLDocument object returned by this
method.  Calling programs can inspect this error log to determine
the nature of the problem.  Please refer to the definition of
SBMLDocument for more information about the error reporting mechanism.
Returns a pointer to the SBMLDocument read.


=item readSBMLFromString

Reads an SBML document from a string assumed to be in XML format.
If the string does not begin with XML declaration,
@verbatim
<?xml version='1.0' encoding='UTF-8'?>
@endverbatim
an XML declaration string will be prepended.
This method will report an error if the given string C<xml> is not SBML.
The error will be logged in the error log of the SBMLDocument object
returned by this method.  Calling programs can inspect this error log to
determine the nature of the problem.  Please refer to the definition of
SBMLDocument for more information about the error reporting mechanism.
Returns a pointer to the SBMLDocument read.


=back

=head2 SBMLWriter

Methods for writing SBML to files and text strings.
@htmlinclude libsbml-not-sbml-warning.html
The SBMLWriter class is the converse of SBMLReader, and provides the
main interface for serializing SBML models into XML and writing the
result to files and text strings.  The methods for writing SBML all take
an SBMLDocument object and a destination.  They return a boolean value
to indicate success or failure.


=over

=item SBMLWriter::SBMLWriter

Creates a new SBMLWriter.


=item SBMLWriter::setProgramName

Sets the name of this program, i.e., the program that is about to
write out the SBMLDocument.
If the program name and version are set (setProgramVersion()), the
following XML comment, intended for human consumption, will be written
at the beginning of the document:
@verbatim
<!-- Created by <program name> version <program version>
on yyyy-MM-dd HH:mm with libsbml version <libsbml version>. -->
@endverbatim
@param name the name of this program (where "this program" refers to
program in which libSBML is embedded, not libSBML itself!)
@see setProgramVersion(const std::string& version)


=item SBMLWriter::setProgramVersion

Sets the version of this program, i.e., the program that is about to
write out the SBMLDocument.
If the program version and name are set (setProgramName()), the
following XML comment, intended for human consumption, will be written
at the beginning of the document:
@verbatim
<!-- Created by <program name> version <program version>
on yyyy-MM-dd HH:mm with libsbml version <libsbml version>. -->
@endverbatim
@param version the version of this program (where "this program"
refers to program in which libSBML is embedded, not libSBML itself!)
@see setProgramName(const std::string& name)


=item SBMLWriter::writeSBML

Writes the given SBML document to filename.
If the given filename ends with the suffix C<">.gz" (for example, @c
"myfile.xml.gz"), libSBML assumes the caller wants the file to be
written compressed in I<gzip>.  Similarly, if the given filename ends
with C<">.zip" or C<">.bz2", libSBML assumes the caller wants the file
to be compressed in I<zip> or I<bzip2> format (respectively).  Files
whose names lack these suffixes will be written uncompressed.
<em>Special considerations for the zip format</em>: If the given
filename ends with C<">.zip", the file placed in the zip archive will
have the suffix C<">.xml" or C<">.sbml".  For example, the file in
the zip archive will be named C<"test>.xml" if the given filename is
C<"test>.xml.zip" or C<"test>.zip".  Similarly, the filename in the
archive will be C<"test>.sbml" if the given filename is @c
"test.sbml.zip".

@note To write a gzip/zip file, libSBML needs to be configured and
linked with the <a href="http://www.zlib.net/">zlib</a> library at
compile time.  It also needs to be linked with the <a
href="">bzip2</a> library to write files in I<bzip2> format.  (Both
of these are the default configurations for libSBML.)  Errors about
unreadable files will be logged and this method will return C<false>
if a compressed filename is given and libSBML was I<not> linked with
the corresponding required library.
@note SBMLReader::hasZlib() and SBMLReader::hasBzip2() can be used to
check whether libSBML has been linked with each library.
@param d the SBML document to be written
@param filename the name or full pathname of the file where the SBML
is to be written. 
Returns C<true> on success and C<false> if the filename could not be
opened for writing.


=item SBMLWriter::writeSBML

Writes the given SBML document to the output stream.
@param d the SBML document to be written
@param stream the stream object where the SBML is to be written.
Returns C<true> on success and C<false> if one of the underlying
parser components fail (rare).


=item SBMLWriter::writeToString

Writes the given SBML document to an in-memory string and returns a
pointer to it.
The string is owned by the caller and should be freed (with C<free>())
when no longer needed.
@param d the SBML document to be written
Returns the string on success and C<0> if one of the underlying parser
components fail.


=item SBMLWriter::hasZlib

Predicate returning C<true> or C<false> depending on whether
underlying libSBML is linked with zlib.
LibSBML supports reading and writing files compressed with either
bzip2 or zip/gzip compression.  The facility depends on libSBML having
been compiled with the necessary support libraries.  This method
allows a calling program to inquire whether that is the case for the
copy of libSBML it is running.
Returns C<true> if libSBML is linked with zlib, C<false> otherwise.


=item SBMLWriter::hasBzip2

Predicate returning C<true> or C<false> depending on whether
underlying libSBML is linked with bzip2.
LibSBML supports reading and writing files compressed with either
bzip2 or zip/gzip compression.  The facility depends on libSBML having
been compiled with the necessary support libraries.  This method
allows a calling program to inquire whether that is the case for the
copy of libSBML it is running.
Returns C<true> if libSBML is linked with bzip2, C<false> otherwise.


=item SBMLWriter::hasBzip2

Predicate returning C<true> or C<false> depending on whether
underlying libSBML is linked with bzip2.
LibSBML supports reading and writing files compressed with either
bzip2 or zip/gzip compression.  The facility depends on libSBML having
been compiled with the necessary support libraries.  This method
allows a calling program to inquire whether that is the case for the
copy of libSBML it is running.
Returns C<true> if libSBML is linked with bzip2, C<false> otherwise.
@deprecated libSBML internal


=item SBMLWriter::hasBzip2

Predicate returning C<true> or C<false> depending on whether
underlying libSBML is linked with bzip2.
LibSBML supports reading and writing files compressed with either
bzip2 or zip/gzip compression.  The facility depends on libSBML having
been compiled with the necessary support libraries.  This method
allows a calling program to inquire whether that is the case for the
copy of libSBML it is running.
Returns C<true> if libSBML is linked with bzip2, C<false> otherwise.
@deprecated libSBML internal


=item writeSBML

Writes the given SBML document to filename.  This convenience function
is functionally equivalent to:
SBMLWriter_writeSBML(SBMLWriter_create(), d, filename);
Returns non-zero on success and zero if the filename could not be opened
for writing.


=item writeSBMLToString

Writes the given SBML document to an in-memory string and returns a
pointer to it.  The string is owned by the caller and should be freed
(with free()) when no longer needed.  This convenience function is
functionally equivalent to:
SBMLWriter_writeSBMLToString(SBMLWriter_create(), d);
Returns the string on success and NULL if one of the underlying parser
components fail (rare).


=item SBMLTypeCode_toString

Returns a human readable name for the given #SBMLTypeCode_t.  The caller
does not own the returned string and is therefore not allowed to modify
it.



=back

=head2 SBase

LibSBML implementation of SBase, the base class of all SBML objects.
Most components in SBML are derived from a single abstract base type,
SBase.  In addition to serving as the parent class for most other
classes of objects in SBML, this base type is designed to allow a
modeler or a software package to attach arbitrary information to each
major element or list in an SBML model.
SBase has an optional subelement called "notes".  It is intended to
serve as a place for storing optional information intended to be seen by
humans.  An example use of the "notes" element would be to contain
formatted user comments about the model element in which the "notes"
element is enclosed.  There are certain conditions on the XHTML content
permitted inside the "notes" element; these are described separately
below.

SBase has another optional subelement called "annotation".  Whereas the
"notes" element described above is a container for content to be shown
directly to humans, the "annotation" element is a container for optional
software-generated content I<not> meant to be shown to humans.  The
element's content type is XML type C<any>, allowing essentially
arbitrary data content.  SBML places only a few restrictions on the
organization of the content; these are intended to help software tools
read and write the data as well as help reduce conflicts between
annotations added by different tools.  They are described separately
below.

It is worth pointing out that the "annotation" element in the definition
of SBase exists in order that software developers may attach optional
application-specific data to the elements in an SBML model.  However, it
is important that this facility not be misused.  In particular, it is
<em>critical</em> that data essential to a model definition or that can
be encoded in existing SBML elements is <em>not</em> stored in
"annotation". Parameter values, functional dependencies between model
elements, etc., should not be recorded as annotations.  It is crucial to
keep in mind the fact that data placed in annotations can be freely
ignored by software applications.  If such data affects the
interpretation of a model, then software interoperability is greatly
impeded.

Beginning with SBML Level 2, SBase also has an optional attribute named
"metaid" for supporting metadata annotations using RDF (Resource
Description Format). The attribute value has the data type XML ID, the
XML identifier type, which means each "metaid" value must be globally
unique within an SBML file.  (Importantly, this uniqueness criterion
applies across any attribute with type XML ID, not just the "metaid"
attribute used by SBML&mdash;something to be aware of if your
application-specific XML content inside the "annotation" subelement
happens to use XML ID.)  The "metaid" value serves to identify a model
component for purposes such as referencing that component from metadata
placed within "annotation" subelements.
Beginning with SBML Level 2 Version 3, SBase also has an optional
attribute named "sboTerm" for supporting the use of the Systems Biology
Ontology.  In SBML proper, the data type of the attribute is a string of
the form SBO:NNNNNNN, where NNNNNNN is a seven digit integer number;
libSBML simplifies the representation by only storing the NNNNNNN
integer portion.  Thus, in libSBML, the "sboTerm" attribute on SBase has
data type C<int>, and SBO identifiers are stored simply as integers.
SBO terms are a type of optional annotation, and each different class of
SBML object derived from SBase imposes its own requirements about the
values permitted for "sboTerm".  Please consult the SBML Level 2 Version
4 specification for more information about the use of SBO and the
"sboTerm" attribute.
Finally, note that, in the list of methods on SBase, there is no public
constructor because SBase is an abstract class.  The constructors reside
in the subclasses derived from SBase.
@section sbase-notes Requirements for the content of the "notes" subelement
The content of "notes" elements must be in XHTML 1.0 format.  (Plain
HTML would not be usable because whatever appears inside the "notes"
element must be compatible with XML, which HTML is not, and in any case,
the requirement for using XHTML does not prevent users from entering
plain-text content ,which they can do using the standard C<&lt;pre&gt;
... &lt;/pre&gt;> elements of [X]HTML.)
The XML content of a "notes" subelement must declare the use of the
XHTML XML namespace.  This can be done in multiple ways.  One way is to
place a namespace declaration for the appropriate namespace URI (which
for XHTML is <tt>"http://www.w3.org/1999/xhtml"</tt>) on the top-level
C<sbml> element and then reference the namespace in the
"notes" element content using a prefix.  The following example
illustrates this approach:
@verbatim
<sbml xmlns="http://www.sbml.org/sbml/level2/version4" level="2" version="4"
xmlns:xhtml="http://www.w3.org/1999/xhtml">
...
<notes>
<xhtml:body>
<xhtml:center><xhtml:h2>A Simple Mitotic Oscillator</xhtml:h2></xhtml:center>
<xhtml:p>A minimal cascade model for the mitotic oscillator
involving cyclin and cdc2 kinase</xhtml:p>
</xhtml:body>
</notes>
...
@endverbatim
Another approach is to declare the XHTML namespace within the "notes"
element content itself, as in the following example:
@verbatim
...
<notes>
<body xmlns="http://www.w3.org/1999/xhtml">
<center><h2>A Simple Mitotic Oscillator</h2></center>
<p>A minimal cascade model for the mitotic oscillator
involving cyclin and cdc2 kinase</p>
</body>
</notes>
...
@endverbatim
The C<xmlns="http://www.w3.org/1999/xhtml"> declaration on @c
body as shown above changes the default XML namespace within it, such
that all of its content is by default in the XHTML namespace.  This is a
particularly convenient approach because it obviates the need to prefix
every element with a namespace prefix (i.e., C<xhtml:>
in the previous case).  Other approaches are also possible.
SBML does not require the content of the "notes" subelement to be any
particular XHTML element; the content can be almost any well-formed
XHTML content.  SBML Level 2 Versions 2, 3 and 4 added some small
restrictions and clarifications for the allowable content in order to
promote greater interoperability between software tools.  The first
restriction comes from the requirements of XML: the "notes"
element must not contain an XML declaration nor a DOCTYPE declaration.
That is, "notes" must I<not> contain
@verbatim
<?xml version="1.0" encoding="UTF-8"?>  
@endverbatim
nor (where the following is only one specific example of a DOCTYPE
declaration)
@verbatim
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
@endverbatim
The second restriction is intended to balance freedom of content with
the complexity of implementing software that can interpret the content.
The content of the "notes" subelement in SBML can consist only of the
following possibilities:

=over


=item

A complete XHTML document (minus the XML and DOCTYPE declarations,
of course), that is, XHTML content beginning with the C<html> tag.
@verbatim
<notes>
<html xmlns="http://www.w3.org/1999/xhtml">
...
</html>
</notes>
@endverbatim

=item

The C<body> element from an XHTML document.  The following is an
example skeleton:
@verbatim
<notes>
<body xmlns="http://www.w3.org/1999/xhtml">
...
</body>
</notes>
@endverbatim

=item

Any XHTML content that would be permitted within a C<body> element.
If this consists of multiple elements, each one must declare the XML
namespace separately.  The following is an example fragment:
@verbatim
<notes>
<p xmlns="http://www.w3.org/1999/xhtml">
...
</p>
<p xmlns="http://www.w3.org/1999/xhtml">
...
</p>
</notes>
@endverbatim

=back


Another way to summarize the restrictions above is simply to say that
the content of an SBML "notes" element can be only be a complete C<html>
element, a C<body> element, or whatever is permitted inside a C<body>
element.  In practice, this does not limit in any meaningful way what
can be placed inside a "notes" element; for example, if an application
or modeler wants to put a complete XHTML page, including a C<head>
element, it can be done by putting in everything starting with the @c
html container.  However, the restrictions above do make it somewhat
simpler to write software that can read and write the "notes" content.
@section sbase-annotation Requirements for the content of the "annotation" subelement
At the outset, software developers should keep in mind that multiple
software tools may attempt to read and write annotation content.  To
reduce the potential for collisions between annotations written by
different applications, SBML Level 2 stipulates that tools must use XML
namespaces to specify the intended vocabulary of every annotation.  The
application's developers must choose a URI (Universal Resource
Identifier) reference that uniquely identifies the vocabulary the
application will use, and a prefix string for the annotations.
A important requirement is that application-specific annotation data is
entirely contained inside a single <em>top-level element</em> within the
SBML "annotation" subelement.  SBML Level 2 Versions 2, 3 and 4 place the
following restrictions on annotations:

=over


=item

Within a given SBML "annotation" element, there can only be one
top-level element using a given namespace.  An annotation element can
contain multiple top-level elements but each must be in a different
namespace.


=item

No top-level element in an "annotation" may use an SBML XML
namespace, either explicitly by referencing one of the SBML XML
namespace URIs or implicitly by failing to specify any namespace on the
annotation.


=item

The ordering of top-level elements within a given "annotation"
element is <em>not</em> significant.  An application should not expect
that its annotation content appears first in the "annotation" element,
nor in any other particular location.  Moreover, the ordering of
top-level annotation elements may be changed by different applications
as they read and write the same SBML file.

=back


The use of XML namespaces in this manner is intended to improve the
ability of multiple applications to place annotations on SBML model
elements with reduced risks of interference or name collisions.
Annotations stored by different simulation packages can therefore
coexist in the same model definition.  The rules governing the content
of "annotation" elements are designed to enable applications to easily
add, change, and remove their annotations from SBML elements while
simultaneously preserving annotations inserted by other applications
when mapping SBML from input to output.
As a further simplification for developers of software and to improve
software interoperability, applications are only required to preserve
other annotations (i.e., annotations they do not recognize) when those
annotations are self-contained entirely within "annotation", complete
with namespace declarations.  The following is an example:
@verbatim
<annotation>
<topLevelElement xmlns:"URI">
... content in the namespace identified by "URI" ...
</topLevelElement>
</annotation>
@endverbatim
Some more examples hopefully will make these points more clear.  The
next example is invalid because it contains a top-level element in the
SBML XML namespace&mdash;this happens because no namespace is declared
for the C<&lt;cytoplasm&gt;> element, which means by default it
falls into the enclosing SBML namespace:
@verbatim
<annotation>
<cytoplasm/>
</annotation>
@endverbatim
The following example is also invalid, this time because it contains two
top-level elements using the same XML namespace.  Note that it does not
matter that these are two different top-level elements
(C<&lt;nodecolors&gt;> and C<&lt;textcolors&gt;>); 
what matters is that these separate elements are both in the same 
namespace rather than having been collected and placed inside one 
overall container element for that namespace.
@verbatim
<annotation>
<mysim:nodecolors xmlns:mysim="http://www.mysim.org/ns"
mysim:bgcolor="green" mysim:fgcolor="white"/>
<mysim:textcolors xmlns:mysim="http://www.mysim.org/ns"
mysim:bgcolor="green" mysim:fgcolor="white"/>
</annotation>
@endverbatim
On the other hand, the following example is valid:
@verbatim
<annotation>
<mysim:geometry xmlns:mysim="http://www.mysim.org/ns"
mysim:bgcolor="green" mysim:fgcolor="white">
<graph:node xmlns:graph="http://www.graph.org/ns" 
graph:x="4" graph:y="5" />
</mysim:geometry>
<othersim:icon xmlns:othersim="http://www.othersim.com/">
WS2002
</othersim:icon>
</annotation>
@endverbatim
It is worth keeping in mind that although XML namespace names must be
URIs, they are (like all XML namespace names) <em>not required</em> to
be directly usable in the sense of identifying an actual, retrieval
document or resource on the Internet.  URIs such as
C<"http://www.mysim.org/"> may appear as though they are
(e.g.) Internet addresses, but there are not the same thing.  This
style of URI strings, using a domain name and other parts, is only a
simple and commonly-used way of creating a unique name string.
@section sbase-miriam Standard format for annotations linking data resources
SBML Level 2 Versions 2, 3 and 4 define a proposed regular format for
encoding two particular categories of annotations: (a) references to
controlled vocabulary terms and database identifiers which define and
describe biological and biochemical entities in a model; and (b)
descriptions of the provenance of a model, including its author(s) and
modification history.


=over

=item SBase::accept

Accepts the given SBMLVisitor for this instance of SBase.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>.


=item SBase::clone

Creates and returns a deep copy of this SBase object.
Returns a (deep) copy of this SBase object


=item SBase::getMetaId

Returns the value of the "metaid" attribute of this object.
Returns the metaid of this SBML object.


=item SBase::getMetaId

Returns the value of the "metaid" attribute of this object.
Returns the metaid of this SBML object.


=item SBase::getId

Returns the value of the "id" attribute of this object.
Returns the id of this SBML object.


=item SBase::getName

Returns the value of the "name" attribute of this object.
Returns the name of this SBML object.


=item SBase::getNotes

Returns the content of the "notes" subelement of this object.
The notes content will be in XML form, but libSBML does not provide an
object model specifically for the content of notes.  Callers will need
to traverse the XML tree structure using the facilities available on
XMLNode and related objects.
Returns the content of the "notes" subelement of this SBML object.


=item SBase::getNotesString

Returns the content of the "notes" subelement of this object by string.
The notes content will be in XML form, but libSBML does not provide an
object model specifically for the content of notes.  Callers will need
to traverse the XML tree structure using the facilities available on
XMLNode and related objects.
Returns the content of the "notes" subelement of this SBML object.


=item SBase::getAnnotation

Returns the content of the "annotation" subelement of this object.
Annotations will be in XML form.  LibSBML provides an object model and
related interfaces for certain specific kinds of annotations, namely
model history information and RDF content.  See the relevant object
classes for more information about the facilities available.
Returns the annotation of this SBML object.
@see ModelHistory
@see CVTerm
@see RDFAnnotation


=item SBase::getAnnotationString

Returns the content of the "annotation" subelement of this object by.
string.

Annotations will be in XML form.  LibSBML provides an object model and
related interfaces for certain specific kinds of annotations, namely
model history information and RDF content.  See the relevant object
classes for more information about the facilities available.
Returns the annotation string of this SBML object.
@see ModelHistory
@see CVTerm
@see RDFAnnotation


=item SBase::getNamespaces

Returns a list of the XML Namespaces declared on this SBML document.
Returns the Namespaces associated with this SBML object


=item SBase::getSBMLDocument

Returns the parent SBMLDocument object.
Returns the parent SBMLDocument object of this SBML object.


=item SBase::getSBMLDocument

Returns the parent SBMLDocument object.
Returns the parent SBMLDocument object of this SBML object.


=item SBase::getParentSBMLObject

Returns the parent SBML object.
Returns the parent SBML object of this SBML object.


=item SBase::getAncestorOfType

Returns the ancestor SBML object that corresponds to the 
given SBMLTypeCode_t.
This function allows any object to determine its exact 
location/function within a model. For example a 
StoichiometryMath object has ancestors of type SpeciesReference,
ListOf(Products/Reactants), Reaction, ListOfReactions and Model; 
any of which can be accessed via this function.
@param type the SBMLTypeCode_t of the ancestor to be returned.
Returns the ancestor SBML object of this SBML object, that 
corresponds to the given SBMLTypeCode_t, NULL if none exists.


=item SBase::getSBOTerm

Returns the integer portion of the value of the "sboTerm" attribute of
this object.
In SBML Level 2 Versions 2, 3 and 4, the data type of the attribute is a
string of the form SBO:NNNNNNN, where NNNNNNN is a seven digit integer
number; libSBML simplifies the representation by only storing the
NNNNNNN integer portion.  Thus, in libSBML, the "sboTerm" attribute on
SBase has data type C<int>, and SBO identifiers are stored simply as
integers.  SBO terms are a type of optional annotation, and each
different class of SBML object derived from SBase imposes its own
requirements about the values permitted for "sboTerm".  Please consult
the SBML Level 2 Version 4 specification for more information about
the use of SBO and the "sboTerm" attribute.
Returns the value of the "sboTerm" attribute as an integer, or C<-1>
if the value is not set.


=item SBase::getSBOTermID

Returns the string representation of the "sboTerm" attribute of
this object.
In SBML Level 2 Versions 2, 3 and 4, the data type of the attribute is a
string of the form SBO:NNNNNNN, where NNNNNNN is a seven digit integer
number; libSBML simplifies the representation by only storing the
NNNNNNN integer portion.  Thus, in libSBML, the "sboTerm" attribute on
SBase has data type C<int>, and SBO identifiers are stored simply as
integers.  This function recreates the string representation from the
stored value.  SBO terms are a type of optional annotation, and each
different class of SBML object derived from SBase imposes its own
requirements about the values permitted for "sboTerm".  Please consult
the SBML Level 2 Version 4 specification for more information about
the use of SBO and the "sboTerm" attribute.
Returns the value of the "sboTerm" attribute as a string of the form
SBO:NNNNNNN, or  NULL
if the value is not set.


=item SBase::getLine

Returns the line number on which this object first appears in the XML
representation of the SBML document.
Returns the line number of this SBML object.
@see getColumn()


=item SBase::getColumn

Returns the column number on which this object first appears in the XML
representation of the SBML document.
Returns the column number of this SBML object.
@see getLine()


=item SBase::isSetMetaId

Predicate returning C<true> or C<false> depending on whether this
object's "metaid" attribute has been set.
@htmlinclude libsbml-comment-set-methods.html
Returns C<true> if the "metaid" attribute of this SBML object has been
set, C<false> otherwise.


=item SBase::isSetId

Predicate returning C<true> or C<false> depending on whether this
object's "id" attribute has been set.
@htmlinclude libsbml-comment-set-methods.html
Returns C<true> if the "id" attribute of this SBML object has been
set, C<false> otherwise.


=item SBase::isSetName

Predicate returning C<true> or C<false> depending on whether this
object's "name" attribute has been set.
@htmlinclude libsbml-comment-set-methods.html
Returns C<true> if the "name" attribute of this SBML object has been
set, C<false> otherwise.


=item SBase::isSetNotes

Predicate returning C<true> or C<false> depending on whether this
object's "notes" subelement exists and has content.
@htmlinclude libsbml-comment-set-methods.html
Returns C<true> if a "notes" subelement exists, C<false> otherwise.


=item SBase::isSetAnnotation

Predicate returning C<true> or C<false> depending on whether this
object's "annotation" subelement exists and has content.
@htmlinclude libsbml-comment-set-methods.html
Returns C<true> if a "annotation" subelement exists, C<false>
otherwise.



=item SBase::isSetSBOTerm

Predicate returning C<true> or C<false> depending on whether this
object's "sboTerm" attribute has been set.
@htmlinclude libsbml-comment-set-methods.html
Returns C<true> if the "sboTerm" attribute of this SBML object has been
set, C<false> otherwise.


=item SBase::setMetaId

Sets the value of the "metaid" attribute of this object.
The string C<metaid> is copied.  The value of C<metaid> must be an
identifier conforming to the syntax defined by the XML 1.0 data type
ID.  Among other things, this type requires that a value is unique
among all the values of type XML ID in an SBMLDocument.  Although SBML
only uses XML ID for the "metaid" attribute, callers should be careful
if they use XML ID's in XML portions of a model that are not defined
by SBML, such as in the application-specific content of the
"annotation" subelement.
@htmlinclude libsbml-comment-set-methods.html
@param metaid the identifier string to use as the value of the
"metaid" attribute


=item SBase::setId

Sets the value of the "id" attribute of this SBML object.
The string C<sid> is copied.  Note that SBML has strict requirements
for the syntax of identifiers.  The following is summary of the
definition of the SBML identifier type C<SId> (here expressed in an
extended form of BNF notation):
C<ode>
letter ::= 'a'..'z','A'..'Z'
digit  ::= '0'..'9'
idChar ::= letter | digit | '_'
SId    ::= ( letter | '_' ) idChar 
@endcode
The equality of SBML identifiers is determined by an exact character
sequence match; i.e., comparisons must be performed in a
case-sensitive manner.  In addition, there are a few conditions for
the uniqueness of identifiers in an SBML model.  Please consult the
SBML specifications for the exact formulations.
@htmlinclude libsbml-comment-set-methods.html
@param sid the string to use as the identifier of this object


=item SBase::setName

Sets the value of the "name" attribute of this SBML object.
The string in C<name> is copied.
@htmlinclude libsbml-comment-set-methods.html
@param name the new name for the object


=item SBase::setAnnotation

Sets the value of the "annotation" subelement of this SBML object to a
copy of C<annotation>.
Any existing content of the "annotation" subelement is discarded.
Unless you have taken steps to first copy and reconstitute any
existing annotations into the C<annotation> that is about to be
assigned, it is likely that performing such wholesale replacement is
unfriendly towards other software applications whose annotations are
discarded.  An alternative may be to use appendAnnotation().
@htmlinclude libsbml-comment-set-methods.html
@param annotation an XML structure that is to be used as the content
of the "annotation" subelement of this object
@see appendAnnotation()


=item SBase::setAnnotation

Sets the value of the "annotation" subelement of this SBML object to a
copy of C<annotation>.
Any existing content of the "annotation" subelement is discarded.
Unless you have taken steps to first copy and reconstitute any
existing annotations into the C<annotation> that is about to be
assigned, it is likely that performing such wholesale replacement is
unfriendly towards other software applications whose annotations are
discarded.  An alternative may be to use appendAnnotation().
@htmlinclude libsbml-comment-set-methods.html
@param annotation an XML string that is to be used as the content
of the "annotation" subelement of this object
@see appendAnnotation()


=item SBase::appendAnnotation

Appends annotation content to any existing content in the "annotation"
subelement of this object.
The content in C<annotation> is copied.  Unlike setAnnotation(), this
method allows other annotations to be preserved when an application
adds its own data.
@param annotation an XML structure that is to be copied and appended
to the content of the "annotation" subelement of this object
@see setAnnotation()


=item SBase::appendAnnotation

Appends annotation content to any existing content in the "annotation"
subelement of this object.
The content in C<annotation> is copied.  Unlike setAnnotation(), this
method allows other annotations to be preserved when an application
adds its own data.
@param annotation an XML string that is to be copied and appended
to the content of the "annotation" subelement of this object
@see setAnnotation()


=item SBase::setNotes

Sets the value of the "notes" subelement of this SBML object to a copy
of C<notes>.
@htmlinclude libsbml-comment-set-methods.html
Any existing content of the "notes" subelement is discarded.
@param notes an XML structure that is to be used as the content of the
"notes" subelement of this object
@see appendNotes()


=item SBase::setNotes

Sets the value of the "notes" subelement of this SBML object to a copy
of C<notes>.
Any existing content of the "notes" subelement is discarded.
@htmlinclude libsbml-comment-set-methods.html
@param notes an XML string that is to be used as the content of the
"notes" subelement of this object
@see appendNotes()


=item SBase::appendNotes

Appends annotation content to any existing content in the "annotation"
subelement of this object.
The content in C<notes> is copied.
@param notes an XML structure that is to appended to the content of
the "notes" subelement of this object
@see setNotes()


=item SBase::appendNotes

Appends annotation content to any existing content in the "annotation"
subelement of this object.
The content in C<notes> is copied.
@param notes an XML string that is to appended to the content of
the "notes" subelement of this object
@see setNotes()


=item SBase::setSBMLDocument

Sets the parent SBMLDocument of this SBML object.
@param d the SBMLDocument object to use
@deprecated libSBML internal


=item SBase::setParentSBMLObject

Sets the parent SBML object of this SBML object.
@param sb the SBML object to use
@deprecated libSBML internal


=item SBase::setSBOTerm

Sets the value of the "sboTerm" attribute.
In SBML Level 2 Versions 2, 3 and 4, the data type of the SBML "sboTerm"
attribute is a string of the form SBO:NNNNNNN, where NNNNNNN is a
seven digit integer number; libSBML simplifies the representation by
only storing the NNNNNNN integer portion.  Thus, in libSBML, the
"sboTerm" attribute on SBase has data type C<int>, and SBO identifiers
are stored simply as integers.  SBO terms are a type of optional
annotation, and each different class of SBML object derived from SBase
imposes its own requirements about the values permitted for "sboTerm".
Please consult the SBML Level 2 Version 4 specification for more
information about the use of SBO and the "sboTerm" attribute.
@htmlinclude libsbml-comment-set-methods.html
@param value the NNNNNNN integer portion of the SBO identifier


=item SBase::setNamespaces

Sets the namespaces relevant of this SBML object.
@param xmlns the namespaces to set


=item SBase::unsetMetaId

Unsets the value of the "metaid" attribute of this SBML object.
@htmlinclude libsbml-comment-set-methods.html


=item SBase::unsetId

Unsets the value of the "id" attribute of this SBML object.
@htmlinclude libsbml-comment-set-methods.html


=item SBase::unsetName

Unsets the value of the "name" attribute of this SBML object.
@htmlinclude libsbml-comment-set-methods.html


=item SBase::unsetNotes

Unsets the value of the "notes" subelement of this SBML object.
@htmlinclude libsbml-comment-set-methods.html


=item SBase::unsetAnnotation

Unsets the value of the "annotation" subelement of this SBML object.
@htmlinclude libsbml-comment-set-methods.html


=item SBase::unsetSBOTerm

Unsets the value of the "sboTerm" attribute of this SBML object.
@htmlinclude libsbml-comment-set-methods.html


=item SBase::addCVTerm

Adds a copy of the given CVTerm to this SBML object.
@param term the CVTerm to assign
@note Since the CV Term uses the metaid of the object as a 
reference, if the object has no metaid set the CVTerm will
not be added.
@note The fact that this method I<copies> the object passed to it
means that the caller will be left holding a physically different
object instance than the one contained in I<this> object.  Changes
made to the original object instance (such as resetting attribute
values) will <em>not affect the instance added here</em>.  In
addition, the caller should make sure to free the original object if
it is no longer being used, or else a memory leak will result.


=item SBase::getCVTerms

Returns a list of CVTerm objects in the annotations of this SBML
object.

Returns the list of CVTerms for this SBML object.


=item SBase::getCVTerms

Returns a list of CVTerm objects in the annotations of this SBML
object.

Returns the list of CVTerms for this SBML object.


=item SBase::getNumCVTerms

Returns the number of CVTerm objects in the annotations of this SBML
object.

Returns the number of CVTerms for this SBML object.


=item SBase::getCVTerm

Returns the nth CVTerm in the list of CVTerms of this SBML
object.

@param n unsigned int the index of the CVTerm to retrieve
Returns the nth CVTerm in the list of CVTerms for this SBML object.


=item SBase::unsetCVTerms

Clears the list of CVTerms of this SBML
object.



=item SBase::getResourceBiologicalQualifier

Returns the BiologicalQualifier associated with this resource,
BQB_UNKNOWN if the resource does not exist.
@param resource string representing the resource; e.g.,
"http://www.geneontology.org/#GO:0005892"

Returns the #BiolQualifierType_t value associated with the resource


=item SBase::getResourceModelQualifier

Returns the ModelQualifier associated with this resource,
BQM_UNKNOWN if the resource does not exist.
@param resource string representing the resource; e.g.,
"http://www.geneontology.org/#GO:0005892"

Returns the #ModelQualifierType_t value associated with the resource


=item SBase::getModel

Returns the Model object in which the current object is located.
Returns the parent Model of this SBML object.


=item SBase::getLevel

Returns the SBML Level of the overall SBML document.
Returns the SBML level of this SBML object.
@see getVersion()


=item SBase::getVersion

Returns the Version within the SBML Level of the overall SBML document.
Returns the SBML version of this SBML object.
@see getLevel()


=item SBase::getTypeCode

Returns the libSBML type code for this object.
This method MAY return the typecode of this SBML object or it MAY
return SBML_UNKNOWN.  That is, subclasses of SBase are not required to
implement this method to return a typecode.  This method is meant
primarily for the LibSBML C interface where class and subclass
information is not readily available.
Returns the #SBMLTypeCode_t value of this SBML object or SBML_UNKNOWN
(default).

@see getElementName()


=item SBase::getElementName

Returns the XML element name of this object.
This is overridden by subclasses to return a string appropriate to the
SBML component.  For example, Model defines it as returning "model",
CompartmentType defines it as returning "compartmentType", etc.


=item SBase::toSBML

Returns a string that consists of the partial SBML describing this
object.  This is primarily provided for testing and debugging
purposes.  It may be removed in a future version of libSBML.
Returns the partial SBML that describes this SBML object.


=item SBase::read

Reads (initializes) this SBML object by reading from XMLInputStream.
@deprecated libSBML internal


=item SBase::write

Writes (serializes) this SBML object by writing it to XMLOutputStream.
@deprecated libSBML internal


=item SBase::writeElements

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.  For example:
SBase::writeElements(stream);
mReactans.write(stream);
mProducts.write(stream);
...
@deprecated libSBML internal


=item SBase::SBase

Only subclasses may create SBase objects.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.

@deprecated libSBML internal


=item SBase::SBase

Creates a new SBase object with the given sboTerm.
Only subclasses may create SBase objects.
@deprecated libSBML internal


=item SBase::SBase

Copy constructor. Creates a copy of this SBase object.
@deprecated libSBML internal


=item SBase::createObject

Subclasses should override this method to create, store, and then
return an SBML object corresponding to the next XMLToken in the
XMLInputStream.

Returns the SBML object corresponding to next XMLToken in the
XMLInputStream or NULL if the token was not recognized.
@deprecated libSBML internal


=item SBase::readOtherXML

Subclasses should override this method to read (and store) XHTML,
MathML, etc. directly from the XMLInputStream.
Returns true if the subclass read from the stream, false otherwise.
@deprecated libSBML internal


=item SBase::getElementPosition

The SBML XML Schema is written such that the order of child elements
is significant.  LibSBML can read elements out of order.  If you
override this method to indicate the ordinal position of element with
respect to its siblings, libSBML will log an error if the element is
read out of order.
Returns the ordinal position of the element with respect to its
siblings or -1 (default) to indicate the position is not significant.
@deprecated libSBML internal


=item SBase::getErrorLog

Returns the SBMLErrorLog used to log errors during while reading and
validating SBML.
@deprecated libSBML internal


=item SBase::logError

Convenience method for easily logging problems from within method
implementations.

This is essentially a short form of getErrorLog()->logError(...)
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.

@deprecated libSBML internal


=item SBase::logUnknownAttribute

Helper to log a common type of error.
@deprecated libSBML internal


=item SBase::logUnknownElement

Helper to log a common type of error.
@deprecated libSBML internal


=item SBase::logEmptyString

Helper to log a common type of error.
@deprecated libSBML internal


=item SBase::readAttributes

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.
@deprecated libSBML internal


=item SBase::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.  For example:
SBase::writeAttributes(stream);
stream.writeAttribute( "id"  , mId   );
stream.writeAttribute( "name", mName );
...

@deprecated libSBML internal


=item SBase::syncAnnotation

Synchronizes the annotation of this SBML object.
Annotation element (XMLNode  mAnnotation) is synchronized with the 
current CVTerm objects (List  mCVTerm).
Currently, this method is called in getAnnotation, isSetAnnotation,
and writeElements methods.
@deprecated libSBML internal


=item SBase::checkOrderAndLogError

Checks that SBML element has been read in the proper order.  If object
is not in the expected position, an error is logged.
@deprecated libSBML internal


=item SBase::checkListOfPopulated

Checks that an SBML ListOf element has been populated.  
If a listOf element has been declared with no elements, 
an error is logged.
@deprecated libSBML internal


=item SBase::checkMetaIdSyntax

Checks the syntax of a metaid attribute.
The syntax of a metaid is XML 1.0 type ID. The literal representation of 
this type consists of strings of characters restricted to:
- NCNameChar ::= letter | digit | '.' | '-' | ' ' | ':' | CombiningChar | Extender
- ID ::= ( letter | ' ' | ':' ) NCNameChar 
If the syntax of the metaid attribute of this object is incorrect, 
an error is logged
@deprecated libSBML internal


=item SBase::checkIdSyntax

Checks the syntax of the id attribute.
The syntax of an id is of type SId which is defined as:
- letter ::= 'a'..'z','A'..'Z'
- digit  ::= '0'..'9'
- idChar ::= letter | digit | '_'
- SId    ::= ( letter | '_' ) idChar 
If the syntax of the id attribute of this object is incorrect, 
an error is logged
@deprecated libSBML internal


=item SBase::checkUnitSyntax

Checks the syntax of the unit attribute.
The syntax of an unit is of type UnitSId which is defined as:
- letter ::= 'a'..'z','A'..'Z'
- digit  ::= '0'..'9'
- idChar ::= letter | digit | '_'
- UnitSId    ::= ( letter | '_' ) idChar 
If the syntax of the unit attribute of this object is incorrect, 
an error is logged
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.

@deprecated libSBML internal


=item SBase::checkAnnotation

Checks the annotation does not declare an sbml namespace.
If the annotation declares an sbml namespace an error is logged.
@deprecated libSBML internal


=item SBase::checkXHTML

Checks that the XHTML is valid.
If the xhtml does not conform to the specification of valid xhtml within
an sbml document, an error is logged.
@deprecated libSBML internal


=item SBase::isUnicodeLetter

Checks if a character is part of the Unicode Letter set.
Returns true if the character is a part of the set, false otherwise.
@deprecated libSBML internal


=item SBase::isUnicodeDigit

Checks if a character is part of the Unicode Digit set.
Returns true if the character is a part of the set, false otherwise.
@deprecated libSBML internal


=item SBase::isCombiningChar

Checks if a character is part of the Unicode CombiningChar set.
Returns true if the character is a part of the set, false otherwise.
@deprecated libSBML internal


=item SBase::isExtender

Checks if a character is part of the Unicode Extender set.
Returns true if the character is a part of the set, false otherwise.
@deprecated libSBML internal


=item SBase::isExtender

Checks if a character is part of the Unicode Extender set.
Returns true if the character is a part of the set, false otherwise.
@deprecated libSBML internal


=item SBase::isExtender

Checks if a character is part of the Unicode Extender set.
Returns true if the character is a part of the set, false otherwise.
@deprecated libSBML internal


=item SBase::isExtender

Checks if a character is part of the Unicode Extender set.
Returns true if the character is a part of the set, false otherwise.
@deprecated libSBML internal


=item SBase::isExtender

Checks if a character is part of the Unicode Extender set.
Returns true if the character is a part of the set, false otherwise.
@deprecated libSBML internal


=item SBase::isExtender

Checks if a character is part of the Unicode Extender set.
Returns true if the character is a part of the set, false otherwise.
@deprecated libSBML internal


=item SBase::isExtender

Checks if a character is part of the Unicode Extender set.
Returns true if the character is a part of the set, false otherwise.
@deprecated libSBML internal


=item SBase::isExtender

Checks if a character is part of the Unicode Extender set.
Returns true if the character is a part of the set, false otherwise.
@deprecated libSBML internal


=item SBase::isExtender

Checks if a character is part of the Unicode Extender set.
Returns true if the character is a part of the set, false otherwise.
@deprecated libSBML internal


=item SBase::isExtender

Checks if a character is part of the Unicode Extender set.
Returns true if the character is a part of the set, false otherwise.
@deprecated libSBML internal


=item SBase::isExtender

Checks if a character is part of the Unicode Extender set.
Returns true if the character is a part of the set, false otherwise.
@deprecated libSBML internal


=item SBase::isExtender

Checks if a character is part of the Unicode Extender set.
Returns true if the character is a part of the set, false otherwise.
@deprecated libSBML internal


=item SBase::isExtender

Checks if a character is part of the Unicode Extender set.
Returns true if the character is a part of the set, false otherwise.
@deprecated libSBML internal


=item SBase::isExtender

Checks if a character is part of the Unicode Extender set.
Returns true if the character is a part of the set, false otherwise.
@deprecated libSBML internal


=item SBase::isExtender

Checks if a character is part of the Unicode Extender set.
Returns true if the character is a part of the set, false otherwise.
@deprecated libSBML internal


=item SBase::isExtender

Checks if a character is part of the Unicode Extender set.
Returns true if the character is a part of the set, false otherwise.
@deprecated libSBML internal


=item SBase::setSBaseFields

Stores the location (line and column) and any XML namespaces (for
roundtripping) declared on this SBML (XML) element.
@deprecated libSBML internal


=item SBase::readAnnotation

Returns true if read an <annotation> element from the stream
@deprecated libSBML internal


=item SBase::readNotes

Returns true if read a <notes> element from the stream
@deprecated libSBML internal


=item SBase::getHasBeenDeleted

Returns true if read a <notes> element from the stream
@deprecated libSBML internal


=back

=head2 ListOf

Parent class for the various SBML "ListOfXYZ" classes.
@htmlinclude libsbml-not-sbml-warning.html


=over

=item ListOf::ListOf

Creates a new ListOf.


=item ListOf::ListOf

Copy constructor.  Creates a copy of this ListOf.


=item ListOf::accept

Accepts the given SBMLVisitor.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>, which indicates
whether the Visitor would like to visit the next item in the
list.



=item ListOf::clone

Creates and returns a deep copy of this ListOf.
Returns a (deep) copy of this ListOf.


=item ListOf::append

Adds item to the end of this ListOf.
This variant of the method makes a clone of the C<item> handed to it.
This means that when the ListOf is destroyed, the original items will
not be destroyed.
@param item the item to be added to the list.
@see appendAndOwn


=item ListOf::appendAndOwn

Adds item to the end of this ListOf.
This variant of the method does not clone the C<item> handed to it;
instead, it assumes ownership of it.  This means that when the ListOf
is destroyed, the item will be destroyed along with it.
@param item the item to be added to the list.
@see append


=item ListOf::get

Get an item from the list.
@param n the index number of the item to get.
Returns the nth item in this ListOf items.
@see size()


=item ListOf::get

Get an item from the list.
@param n the index number of the item to get.
Returns the nth item in this ListOf items.
@see size()


=item ListOf::get

Get an item from the list based on its identifier.
@param sid a string representing the the identifier of the item to get.
Returns item in this ListOf items with the given id or NULL if no such
item exists.
@see get(unsigned int n)
@see size()


=item ListOf::get

Get an item from the list based on its identifier.
@param sid a string representing the the identifier of the item to get.
Returns item in this ListOf items with the given id or NULL if no such
item exists.
@see get(unsigned int n)
@see size()


=item ListOf::clear

Removes all items in this ListOf object.
If doDelete is true (default), all items in this ListOf object are deleted
and cleared, and thus the caller doesn't have to delete those items.
Otherwise, all items are just cleared from this ListOf object and the caller 
is responsible for deleting all items (In this case, pointers to all items 
should be stored elsewhere before calling this function by the caller).
@param doDelete if true (default), all items are deleted and cleared.
Otherwise, all items are just cleared and not deleted. 


=item ListOf::remove

Removes the nth item from this ListOf items and returns a pointer to
it.

The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove
@see size()


=item ListOf::remove

Removes item in this ListOf items with the given identifier.
The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier C<sid>, then @c
NULL is returned.
@param sid the identifier of the item to remove
Returns the item removed.  As mentioned above, the caller owns the
returned item.


=item ListOf::size

Get the size of this ListOf.
Returns the number of items in this ListOf items.


=item ListOf::setSBMLDocument

Sets the parent SBMLDocument of this SBML object.
@param d the SBMLDocument that should become the parent of this
ListOf.

@deprecated libSBML internal


=item ListOf::setParentSBMLObject

Sets the parent SBML object of this SBML object.
@param sb the SBML object to use
@deprecated libSBML internal


=item ListOf::getTypeCode

Returns the libSBML type code for this object, namely, @c
SBML_LIST_OF.

@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for this object, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item ListOf::getItemTypeCode

Get the type code of the objects contained in this ListOf.
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for the objects contained in this ListOf
instance, or C<SBML_UNKNOWN> (default).


=item ListOf::getElementName

Returns the XML element name of this object, which for ListOf, is
always C<"listOf">.
Returns the XML name of this element.


=item ListOf::writeElements

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.
@deprecated libSBML internal


=item ListOf::readAttributes

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.
@deprecated libSBML internal


=item ListOf::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.  For example:
SBase::writeAttributes(stream);
stream.writeAttribute( "id"  , mId   );
stream.writeAttribute( "name", mName );
...

@deprecated libSBML internal


=item ListOf::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.  For example:
SBase::writeAttributes(stream);
stream.writeAttribute( "id"  , mId   );
stream.writeAttribute( "name", mName );
...

@deprecated libSBML internal


=back

=head2 Model

LibSBML implementation of SBML's Model construct.
In an SBML model definition, a single object of class Model serves as
the overall container for the lists of the various model components.
All of the lists are optional, but if a given list container is present
within the model, the list must not be empty; that is, it must have
length one or more.  The following are the components and lists
permitted in different Levels and Versions of SBML as of this version
of libSBML (3.3):

=over


=item

In SBML Level 1, the components are: UnitDefinition, Compartment,
Species, Parameter, Rule, and Reaction.  Instances of the classes are
placed inside instances of classes ListOfUnitDefinitions,
ListOfCompartments, ListOfSpecies, ListOfParameters, ListOfRules, and
ListOfReactions.


=item

In SBML Level 2 Version 1, the components are: FunctionDefinition,
UnitDefinition, Compartment, Species, Parameter, Rule, Reaction and
Event.  Instances of the classes are placed inside instances of classes
ListOfFunctionDefinitions, ListOfUnitDefinitions, ListOfCompartments,
ListOfSpecies, ListOfParameters, ListOfRules, ListOfReactions, and
ListOfEvents.


=item

In SBML Level 2 Versions 2, 3 and 4, the components are:
FunctionDefinition, UnitDefinition, CompartmentType, SpeciesType,
Compartment, Species, Parameter, InitialAssignment, Rule, Constraint,
Reaction and Event.  Instances of the classes are placed inside
instances of classes ListOfFunctionDefinitions, ListOfUnitDefinitions,
ListOfCompartmentTypes, ListOfSpeciesTypes, ListOfCompartments,
ListOfSpecies, ListOfParameters, ListOfInitialAssignments, ListOfRules,
ListOfConstraints, ListOfReactions, and ListOfEvents.

=back


Although all the lists are optional, there are dependencies between SBML
components such that defining some components requires defining others.
An example is that defining a species requires defining a compartment,
and defining a reaction requires defining a species.  The dependencies
are explained in more detail in the SBML specifications.
@section approaches Approaches to creating objects using the libSBML API
LibSBML provides two main mechanisms for creating objects: class
constructors (e.g., @if clike @link Species::Species() Species()
@endlink @endif@if java <a href="org/sbml/libsbml/Species.html">Species()</a> @endif),
and <code>create<i>Object</i>()</code> methods (such as
Model::createSpecies()) provided by certain object classes such as
Model.  These multiple mechanisms are provided by libSBML for
flexibility and to support different use-cases, but they also have
different implications for the overall model structure.
In general, the recommended approach is to use the
<code>create<i>Object</i>()</code> methods.  These methods both create
an object I<and> link it to the parent in one step.  Here is an
example:
@verbatim
// Create an SBMLDocument object in Level 2 Version 4 format:
SBMLDocument  sbmlDoc = new SBMLDocument(2, 4);
// Create a Model object inside the SBMLDocument object and set
// its identifier.  The call returns a pointer to the Model object
// created, and methods called on that object affect the attributes
// of the object attached to the model (as expected).
Model  model = sbmlDoc->createModel();
model->setId("MyModel");
// Create a Species object inside the Model and set its identifier.
// Similar to the lines above, this call returns a pointer to the Species
// object created, and methods called on that object affect the attributes
// of the object attached to the model (as expected).
Species  sp = model->createSpecies();
sp->setId("MySpecies");
@endverbatim
The <code>create<i>Object</i>()</code> methods return a pointer to the
object created, but they also add the object to the relevant list of
object instances contained in the parent.  (These lists become the
<code>&lt;listOf<i>Object</i>s&gt;</code> elements in the finished XML
rendition of SBML.)  In the example above, Model::createSpecies() adds
the created species directly to the C<&lt;listOfSpecies&gt;>
list in the model.  Subsequently, methods called on the species change
the species in the model (which is what is expected in most situations).
By contrast, the other main way of creating an object and adding it to a
parent makes a I<copy> of the object, and requires more care on the
part of the caller.  Here is an example of this alternative approach:
@verbatim
// Create a Species object and add it to the model.
// This uses the Species class constructor:
Species  newsp = Species("MySpecies");
model->addSpecies(newsp); // Warning! This makes a COPY inside 'model'.
// addSpecies(...) copies the object, with the result that
// 'newsp' still refers to the original.  The following may not
// do what is expected:
newsp.setId("NewId");    // Warning -- doesn't change the species in 'model'!
// If 'newsp' object isn't going to be used further, it needs
// to be deleted to avoid a memory leak.
delete newsp;
@endverbatim
The key point of the example above is that, because the @if clike
Model::addSpecies() @endif@if java Model::addSpecies(Species s) @endif
call makes a copy of the object handed to it, care is needed both when
attempting to make changes to the object, and when the original object
is no longer needed.
@section checking Consistency and adherence to SBML specifications
To make it easier for applications to do whatever they need,
libSBML&nbsp;3.x is relatively lax when it comes to enforcing
correctness and completeness of models during model construction and
editing.  Essentially, libSBML I<will> I<not> in most cases check
automatically that a model's components have valid attribute values, or
that the overall model is consistent and free of errors&mdash;even
obvious errors such as duplication of identifiers.  This allows
applications great leeway in how they build their models, but it means
that software authors must take deliberate steps to ensure that the
model will be, in the end, valid SBML.  These steps include such things
as keeping track of the identifiers used in a model, manually performing
updates in certain situations where an entity is referenced in more than
one place (e.g., a species that is referenced by multiple
SpeciesReference objects), and so on.
That said, libSBML does provide powerful features for deliberately
performing validation of SBML when an application decides it is time to
do so.  The interfaces to these facilities are on the SBMLDocument
class, in the form of SBMLDocument::checkInternalConsistency() and
SBMLDocument::checkConsistency().  Please refer to the documentation for
SBMLDocument for more information about this.
While applications may play fast and loose and live like free spirits
during the construction and editing of SBML models, they should always
make sure to call SBMLDocument::checkInternalConsistency() and/or
SBMLDocument::checkConsistency() before writing out the final version of
an SBML model.


=over

=item Model::Model

Creates a new Model, optionally with a given identifier and
name.

@param id a string, the optional identifier of this Model
@param name a string, the optional name of this Model.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item Model::Model

Creates a new Model using the given SBML C<level> and C<version>
values and optionally a set of XMLNamespaces.
@param level an unsigned int, the SBML Level to assign to this Model
@param version an unsigned int, the SBML Version to assign to this
Model

@param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
assign to this Model
@note Once a Model has been added to an SBMLDocument, the C<level>,
C<version> and C<xmlns> namespaces for the document I<override> those used
to create the Model.  Despite this, the ability to supply the values
at creation time is an important aid to creating valid SBML.  Knowledge of
the intented SBML Level and Version determine whether it is valid to
assign a particular value to an attribute, or whether it is valid to add
an object to an existing SBMLDocument.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.

@deprecated libSBML internal


=item Model::Model

Copy constructor; creates a (deep) copy of the given Model object.


=item Model::accept

Accepts the given SBMLVisitor for this instance of Constraint.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>.


=item Model::clone

Creates and returns a deep copy of this Model object.
Returns a (deep) copy of this Model.


=item Model::getModelHistory

Returns the ModelHistory of this Model.
Returns ModelHistory of this Model.


=item Model::getModelHistory

Returns the ModelHistory of this Model.
Returns ModelHistory of this Model.


=item Model::isSetModelHistory

Predicate returning C<true> or C<false> depending on whether this
Model's ModelHistory has been set.
@htmlinclude libsbml-comment-set-methods.html
Returns C<true> if the ModelHistory of this Model
has been set, C<false> otherwise.


=item Model::setModelHistory

Sets the ModelHistory of this Model.
@htmlinclude libsbml-comment-set-methods.html
@param history ModelHistory of this Model.


=item Model::unsetModelHistory

Unsets the ModelHistory of this Model.
@htmlinclude libsbml-comment-set-methods.html


=item Model::addFunctionDefinition

Adds a copy of the given FunctionDefinition object to this Model.
@param fd the FunctionDefinition to add
@note This method should be used with some caution.  The fact that
this method I<copies> the object passed to it means that the caller
will be left holding a physically different object instance than the
one contained in this Model.  Changes made to the original object
instance (such as resetting attribute values) will <em>not affect the
instance in the Model</em>.  In addition, the caller should make sure
to free the original object if it is no longer being used, or else a
memory leak will result.  Please see Model::createFunctionDefinition()
for a method that does not lead to these issues.
@see createFunctionDefinition()


=item Model::addUnitDefinition

Adds a copy of the given UnitDefinition object to this Model.
@param ud the UnitDefinition object to add
@note This method should be used with some caution.  The fact that
this method I<copies> the object passed to it means that the caller
will be left holding a physically different object instance than the
one contained in this Model.  Changes made to the original object
instance (such as resetting attribute values) will <em>not affect the
instance in the Model</em>.  In addition, the caller should make sure
to free the original object if it is no longer being used, or else a
memory leak will result.  Please see Model::createUnitDefinition() for
a method that does not lead to these issues.
@see createUnitDefinition()


=item Model::addCompartmentType

Adds a copy of the given CompartmentType object to this Model.
@param ct the CompartmentType object to add
@note This method should be used with some caution.  The fact that
this method I<copies> the object passed to it means that the caller
will be left holding a physically different object instance than the
one contained in this Model.  Changes made to the original object
instance (such as resetting attribute values) will <em>not affect the
instance in the Model</em>.  In addition, the caller should make sure
to free the original object if it is no longer being used, or else a
memory leak will result.  Please see Model::createCompartmentType()
for a method that does not lead to these issues.
@see createCompartmentType()


=item Model::addSpeciesType

Adds a copy of the given SpeciesType object to this Model.
@param st the SpeciesType object to add
@note This method should be used with some caution.  The fact that
this method I<copies> the object passed to it means that the caller
will be left holding a physically different object instance than the
one contained in this Model.  Changes made to the original object
instance (such as resetting attribute values) will <em>not affect the
instance in the Model</em>.  In addition, the caller should make sure
to free the original object if it is no longer being used, or else a
memory leak will result.  Please see Model::createSpeciesType() for a
method that does not lead to these issues.
@see createSpeciesType()


=item Model::addCompartment

Adds a copy of the given Compartment object to this Model.
@param c the Compartment object to add
@note This method should be used with some caution.  The fact that
this method I<copies> the object passed to it means that the caller
will be left holding a physically different object instance than the
one contained in this Model.  Changes made to the original object
instance (such as resetting attribute values) will <em>not affect the
instance in the Model</em>.  In addition, the caller should make sure
to free the original object if it is no longer being used, or else a
memory leak will result.  Please see Model::createCompartment() for a
method that does not lead to these issues.
@see createCompartment()


=item Model::addSpecies

Adds a copy of the given Species object to this Model.
@param s the Species object to add
@note This method should be used with some caution.  The fact that
this method I<copies> the object passed to it means that the caller
will be left holding a physically different object instance than the
one contained in this Model.  Changes made to the original object
instance (such as resetting attribute values) will <em>not affect the
instance in the Model</em>.  In addition, the caller should make sure
to free the original object if it is no longer being used, or else a
memory leak will result.  Please see Model::createSpecies() for a
method that does not lead to these issues.
@see createSpecies()


=item Model::addParameter

Adds a copy of the given Parameter object to this Model.
@param p the Parameter object to add
@note This method should be used with some caution.  The fact that
this method I<copies> the object passed to it means that the caller
will be left holding a physically different object instance than the
one contained in this Model.  Changes made to the original object
instance (such as resetting attribute values) will <em>not affect the
instance in the Model</em>.  In addition, the caller should make sure
to free the original object if it is no longer being used, or else a
memory leak will result.  Please see Model::createParameter() for a
method that does not lead to these issues.
@see createParameter()


=item Model::addInitialAssignment

Adds a copy of the given InitialAssignment object to this Model.
@param ia the InitialAssignment object to add
@note This method should be used with some caution.  The fact that
this method I<copies> the object passed to it means that the caller
will be left holding a physically different object instance than the
one contained in this Model.  Changes made to the original object
instance (such as resetting attribute values) will <em>not affect the
instance in the Model</em>.  In addition, the caller should make sure
to free the original object if it is no longer being used, or else a
memory leak will result.  Please see Model::createInitialAssignment()
for a method that does not lead to these issues.
@see createInitialAssignment()


=item Model::addRule

Adds a copy of the given Rule object to this Model.
@param r the Rule object to add
@note This method should be used with some caution.  The fact that
this method I<copies> the object passed to it means that the caller
will be left holding a physically different object instance than the
one contained in this Model.  Changes made to the original object
instance (such as resetting attribute values) will <em>not affect the
instance in the Model</em>.  In addition, the caller should make sure
to free the original object if it is no longer being used, or else a
memory leak will result.  Please see Model::createRule() for a method
that does not lead to these issues.
@see createRule()


=item Model::addConstraint

Adds a copy of the given Constraint object to this Model.
@param c the Constraint object to add
@note This method should be used with some caution.  The fact that
this method I<copies> the object passed to it means that the caller
will be left holding a physically different object instance than the
one contained in this Model.  Changes made to the original object
instance (such as resetting attribute values) will <em>not affect the
instance in the Model</em>.  In addition, the caller should make sure
to free the original object if it is no longer being used, or else a
memory leak will result.  Please see Model::createConstraint() for a
method that does not lead to these issues.
@see createConstraint()


=item Model::addReaction

Adds a copy of the given Reaction object to this Model.
@param r the Reaction object to add
@note This method should be used with some caution.  The fact that
this method I<copies> the object passed to it means that the caller
will be left holding a physically different object instance than the
one contained in this Model.  Changes made to the original object
instance (such as resetting attribute values) will <em>not affect the
instance in the Model</em>.  In addition, the caller should make sure
to free the original object if it is no longer being used, or else a
memory leak will result.  Please see Model::createReaction() for a
method that does not lead to these issues.
@see createReaction()


=item Model::addEvent

Adds a copy of the given Event object to this Model.
@param e the Event object to add
@note This method should be used with some caution.  The fact that
this method I<copies> the object passed to it means that the caller
will be left holding a physically different object instance than the
one contained in this Model.  Changes made to the original object
instance (such as resetting attribute values) will <em>not affect the
instance in the Model</em>.  In addition, the caller should make sure
to free the original object if it is no longer being used, or else a
memory leak will result.  Please see Model::createEvent() for a method
that does not lead to these issues.
@see createEvent()


=item Model::createFunctionDefinition

Creates a new FunctionDefinition inside this Model and returns it.
Returns the FunctionDefinition object created
@see addFunctionDefinition()


=item Model::createUnitDefinition

Creates a new UnitDefinition inside this Model and returns it.
Returns the UnitDefinition object created
@see addUnitDefinition()


=item Model::createUnit

Creates a new Unit object within the last UnitDefinition object
created in this model and returns a pointer to it.
The mechanism by which the UnitDefinition was created is not
significant.  If a UnitDefinition object does not exist in this model,
a new Unit is I<not> created and NULL is returned instead.
Returns the Unit object created
@see addUnit()


=item Model::createCompartmentType

Creates a new CompartmentType inside this Model and returns it.
Returns the CompartmentType object created
@see addCompartmentType()


=item Model::createSpeciesType

Creates a new SpeciesType inside this Model and returns it.
Returns the SpeciesType object created
@see addSpeciesType()


=item Model::createCompartment

Creates a new Compartment inside this Model and returns it.
Returns the Compartment object created
@see addCompartment()


=item Model::createSpecies

Creates a new Species inside this Model and returns it.
Returns the Species object created
@see addSpecies()


=item Model::createParameter

Creates a new Parameter inside this Model and returns it.
Returns the Parameter object created
@see addParameter()


=item Model::createInitialAssignment

Creates a new InitialAssignment inside this Model and returns it.
Returns the InitialAssignment object created
@see addInitialAssignment()


=item Model::createAlgebraicRule

Creates a new AlgebraicRule inside this Model and returns it.
Returns the AlgebraicRule object created
@see addRule()


=item Model::createAssignmentRule

Creates a new AssignmentRule inside this Model and returns it.
Returns the AssignmentRule object created
@see addRule()


=item Model::createRateRule

Creates a new RateRule inside this Model and returns it.
Returns the RateRule object created
@see addRule()


=item Model::createConstraint

Creates a new Constraint inside this Model and returns it.
Returns the Constraint object created
@see addConstraint()


=item Model::createReaction

Creates a new Reaction inside this Model and returns it.
Returns the Reaction object created
@see addReaction()


=item Model::createReactant

Creates a new SpeciesReference object for a reactant inside the last
Reaction object in this Model, and returns a pointer to it.
The mechanism by which the last Reaction object was created and added
to this Model is not significant.  It could have been created in a
variety of ways, for example using createReaction().  If a Reaction
does not exist for this model, a new SpeciesReference is I<not>
created and NULL is returned instead.
Returns the SpeciesReference object created


=item Model::createProduct

Creates a new SpeciesReference object for a product inside the last
Reaction object in this Model, and returns a pointer to it.
The mechanism by which the last Reaction object was created and added
to this Model is not significant.  It could have been created in a
variety of ways, for example using createReaction().  If a Reaction
does not exist for this model, a new SpeciesReference is I<not>
created and NULL is returned instead.
Returns the SpeciesReference object created


=item Model::createModifier

Creates a new ModifierSpeciesReference object for a modifier species
inside the last Reaction object in this Model, and returns a pointer
to it.
The mechanism by which the last Reaction object was created and added
to this Model is not significant.  It could have been created in a
variety of ways, for example using createReaction().  If a Reaction
does not exist for this model, a new ModifierSpeciesReference is @em
not created and NULL is returned instead.
Returns the SpeciesReference object created


=item Model::createKineticLaw

Creates a new KineticLaw inside the last Reaction object created in
this Model, and returns a pointer to it.
The mechanism by which the last Reaction object was created and added
to this Model is not significant.  It could have been created in a
variety of ways, for example using createReaction().  If a Reaction
does not exist for this model, or a Reaction exists but already has a
KineticLaw, a new KineticLaw is I<not> created and NULL is returned
instead.

Returns the KineticLaw object created


=item Model::createKineticLawParameter

Creates a new local Parameter inside the KineticLaw object of the last
Reaction created inside this Model, and returns a pointer to it.
The last KineticLaw object in this Model could have been created in a
variety of ways.  For example, it could have been added using
createKineticLaw(), or it could be the result of using
Reaction::createKineticLaw() on the Reaction object created by a
createReaction().  If a Reaction does not exist for this model, or the
last Reaction does not contain a KineticLaw object, a new Parameter is
I<not> created and NULL is returned instead.
Returns the Parameter object created


=item Model::createEvent

Creates a new Event inside this Model and returns it.
Returns the Event object created


=item Model::createEventAssignment

Creates a new EventAssignment inside the last Event object created in
this Model, and returns a pointer to it.
The mechanism by which the last Event object in this model was created
is not significant.  It could have been created in a variety of ways,
for example by using createEvent().  If no Event object exists in this
Model object, a new EventAssignment is I<not> created and NULL is
returned instead.
Returns the EventAssignment object created


=item Model::setAnnotation

Sets the value of the "annotation" subelement of this SBML object to a
copy of C<annotation>.
Any existing content of the "annotation" subelement is discarded.
Unless you have taken steps to first copy and reconstitute any
existing annotations into the C<annotation> that is about to be
assigned, it is likely that performing such wholesale replacement is
unfriendly towards other software applications whose annotations are
discarded.  An alternative may be to use appendAnnotation().
@param annotation an XML structure that is to be used as the content
of the "annotation" subelement of this object
@see appendAnnotation(const XMLNode  annotation)


=item Model::setAnnotation

Sets the value of the "annotation" subelement of this SBML object to a
copy of C<annotation>.
Any existing content of the "annotation" subelement is discarded.
Unless you have taken steps to first copy and reconstitute any
existing annotations into the C<annotation> that is about to be
assigned, it is likely that performing such wholesale replacement is
unfriendly towards other software applications whose annotations are
discarded.  An alternative may be to use appendAnnotation().
@param annotation an XML string that is to be used as the content
of the "annotation" subelement of this object
@see appendAnnotation(const std::string& annotation)


=item Model::appendAnnotation

Appends annotation content to any existing content in the "annotation"
subelement of this object.
The content in C<annotation> is copied.  Unlike setAnnotation(), this
method allows other annotations to be preserved when an application
adds its own data.
@param annotation an XML structure that is to be copied and appended
to the content of the "annotation" subelement of this object
@see setAnnotation(const XMLNode  annotation)


=item Model::appendAnnotation

Appends annotation content to any existing content in the "annotation"
subelement of this object.
The content in C<annotation> is copied.  Unlike setAnnotation(), this 
method allows other annotations to be preserved when an application
adds its own data.
@param annotation an XML string that is to be copied and appended
to the content of the "annotation" subelement of this object
@see setAnnotation(const std::string& annotation)


=item Model::getListOfFunctionDefinitions

Get the ListOfFunctionDefinitions object in this Model.
Returns the list of FunctionDefinitions for this Model.


=item Model::getListOfFunctionDefinitions

Get the ListOfFunctionDefinitions object in this Model.
Returns the list of FunctionDefinitions for this Model.


=item Model::getListOfUnitDefinitions

Get the ListOfUnitDefinitions object in this Model.
Returns the list of UnitDefinitions for this Model.


=item Model::getListOfUnitDefinitions

Get the ListOfUnitDefinitions object in this Model.
Returns the list of UnitDefinitions for this Model.


=item Model::getListOfCompartmentTypes

Get the ListOfCompartmentTypes object in this Model.
Returns the list of CompartmentTypes for this Model.


=item Model::getListOfCompartmentTypes

Get the ListOfCompartmentTypes object in this Model.
Returns the list of CompartmentTypes for this Model.


=item Model::getListOfSpeciesTypes

Get the ListOfSpeciesTypes object in this Model.
Returns the list of SpeciesTypes for this Model.


=item Model::getListOfSpeciesTypes

Get the ListOfSpeciesTypes object in this Model.
Returns the list of SpeciesTypes for this Model.


=item Model::getListOfCompartments

Get the ListOfCompartments object in this Model.
Returns the list of Compartments for this Model.


=item Model::getListOfCompartments

Get the ListOfCompartments object in this Model.
Returns the list of Compartments for this Model.


=item Model::getListOfSpecies

Get the ListOfSpecies object in this Model.
Returns the list of Species for this Model.


=item Model::getListOfSpecies

Get the ListOfSpecies object in this Model.
Returns the list of Species for this Model.


=item Model::getListOfParameters

Get the ListOfParameters object in this Model.
Returns the list of Parameters for this Model.


=item Model::getListOfParameters

Get the ListOfParameters object in this Model.
Returns the list of Parameters for this Model.


=item Model::getListOfInitialAssignments

Get the ListOfInitialAssignments object in this Model.
Returns the list of InitialAssignments for this Model.


=item Model::getListOfInitialAssignments

Get the ListOfInitialAssignments object in this Model.
Returns the list of InitialAssignment for this Model.


=item Model::getListOfRules

Get the ListOfRules object in this Model.
Returns the list of Rules for this Model.


=item Model::getListOfRules

Get the ListOfRules object in this Model.
Returns the list of Rules for this Model.


=item Model::getListOfConstraints

Get the ListOfConstraints object in this Model.
Returns the list of Constraints for this Model.


=item Model::getListOfConstraints

Get the ListOfConstraints object in this Model.
Returns the list of Constraints for this Model.


=item Model::getListOfReactions

Get the ListOfReactions object in this Model.
Returns the list of Reactions for this Model.


=item Model::getListOfReactions

Get the ListOfReactions object in this Model.
Returns the list of Reactions for this Model.


=item Model::getListOfEvents

Get the ListOfEvents object in this Model.
Returns the list of Events for this Model.


=item Model::getListOfEvents

Get the ListOfEvents object in this Model.
Returns the list of Events for this Model.


=item Model::getFunctionDefinition

Get the nth FunctionDefinitions object in this Model.
Returns the nth FunctionDefinition of this Model.


=item Model::getFunctionDefinition

Get the nth FunctionDefinitions object in this Model.
Returns the nth FunctionDefinition of this Model.


=item Model::getFunctionDefinition

Get a FunctionDefinition object based on its identifier.
Returns the FunctionDefinition in this Model with the identifier @p
sid or NULL if no such FunctionDefinition exists.


=item Model::getFunctionDefinition

Get a FunctionDefinition object based on its identifier.
Returns the FunctionDefinition in this Model with the identifier @p
sid or NULL if no such FunctionDefinition exists.


=item Model::getUnitDefinition

Get the nth UnitDefinition object in this Model.
Returns the nth UnitDefinition of this Model.


=item Model::getUnitDefinition

Get the nth UnitDefinition object in this Model.
Returns the nth UnitDefinition of this Model.


=item Model::getUnitDefinition

Get a UnitDefinition based on its identifier.
Returns the UnitDefinition in this Model with the identifier C<sid> or
NULL if no such UnitDefinition exists.


=item Model::getUnitDefinition

Get a UnitDefinition based on its identifier.
Returns the UnitDefinition in this Model with the identifier C<sid> or
NULL if no such UnitDefinition exists.


=item Model::getCompartmentType

Get the nth CompartmentType object in this Model.
Returns the nth CompartmentType of this Model.


=item Model::getCompartmentType

Get the nth CompartmentType object in this Model.
Returns the nth CompartmentType of this Model.


=item Model::getCompartmentType

Get a CompartmentType object based on its identifier.
Returns the CompartmentType in this Model with the identifier C<sid>
or NULL if no such CompartmentType exists.


=item Model::getCompartmentType

Get a CompartmentType object based on its identifier.
Returns the CompartmentType in this Model with the identifier C<sid>
or NULL if no such CompartmentType exists.


=item Model::getSpeciesType

Get the nth SpeciesType object in this Model.
Returns the nth SpeciesType of this Model.


=item Model::getSpeciesType

Get the nth SpeciesType object in this Model.
Returns the nth SpeciesType of this Model.


=item Model::getSpeciesType

Get a SpeciesType object based on its identifier.
Returns the SpeciesType in this Model with the identifier C<sid> or
NULL if no such SpeciesType exists.


=item Model::getSpeciesType

Get a SpeciesType object based on its identifier.
Returns the SpeciesType in this Model with the identifier C<sid> or
NULL if no such SpeciesType exists.


=item Model::getCompartment

Get the nth Compartment object in this Model.
Returns the nth Compartment of this Model.


=item Model::getCompartment

Get the nth Compartment object in this Model.
Returns the nth Compartment of this Model.


=item Model::getCompartment

Get a Compartment object based on its identifier.
Returns the Compartment in this Model with the identifier C<sid> or
NULL if no such Compartment exists.


=item Model::getCompartment

Get a Compartment object based on its identifier.
Returns the Compartment in this Model with the identifier C<sid> or
NULL if no such Compartment exists.


=item Model::getSpecies

Get the nth Species object in this Model.
Returns the nth Species of this Model.


=item Model::getSpecies

Get the nth Species object in this Model.
Returns the nth Species of this Model.


=item Model::getSpecies

Get a Species object based on its identifier.
Returns the Species in this Model with the identifier C<sid> or NULL
if no such Species exists.


=item Model::getSpecies

Get a Species object based on its identifier.
Returns the Species in this Model with the identifier C<sid> or NULL
if no such Species exists.


=item Model::getParameter

Get the nth Parameter object in this Model.
Returns the nth Parameter of this Model.


=item Model::getParameter

Get the nth Parameter object in this Model.
Returns the nth Parameter of this Model.


=item Model::getParameter

Get a Parameter object based on its identifier.
Returns the Parameter in this Model with the identifier C<sid> or NULL
if no such Parameter exists.


=item Model::getParameter

Get a Parameter object based on its identifier.
Returns the Parameter in this Model with the identifier C<sid> or NULL
if no such Parameter exists.


=item Model::getInitialAssignment

Get the nth InitialAssignment object in this Model.
Returns the nth InitialAssignment of this Model.


=item Model::getInitialAssignment

Get the nth InitialAssignment object in this Model.
Returns the nth InitialAssignment of this Model.


=item Model::getInitialAssignment

Get an InitialAssignment object based on the symbol to which it
assigns a value.
Returns the InitialAssignment in this Model with the given "symbol"
attribute value or NULL if no such InitialAssignment exists.


=item Model::getInitialAssignment

Get an InitialAssignment object based on the symbol to which it
assigns a value.
Returns the InitialAssignment in this Model with the given "symbol"
attribute value or NULL if no such InitialAssignment exists.


=item Model::getRule

Get the nth Rule object in this Model.
Returns the nth Rule of this Model.


=item Model::getRule

Get the nth Rule object in this Model.
Returns the nth Rule of this Model.


=item Model::getRule

Get a Rule object based on the variable to which it assigns a value.
Returns the Rule in this Model with the given "variable" attribute
value or NULL if no such Rule exists.


=item Model::getRule

Get a Rule object based on the variable to which it assigns a value.
Returns the Rule in this Model with the given "variable" attribute
value or NULL if no such Rule exists.


=item Model::getConstraint

Get the nth Constraint object in this Model.
Returns the nth Constraint of this Model.


=item Model::getConstraint

Get the nth Constraint object in this Model.
Returns the nth Constraint of this Model.


=item Model::getReaction

Get the nth Reaction object in this Model.
Returns the nth Reaction of this Model.


=item Model::getReaction

Get the nth Reaction object in this Model.
Returns the nth Reaction of this Model.


=item Model::getReaction

Get a Reaction object based on its identifier.
Returns the Reaction in this Model with the identifier C<sid> or NULL
if no such Reaction exists.


=item Model::getReaction

Get a Reaction object based on its identifier.
Returns the Reaction in this Model with the identifier C<sid> or NULL
if no such Reaction exists.


=item Model::getEvent

Get the nth Event object in this Model.
Returns the nth Event of this Model.


=item Model::getEvent

Get the nth Event object in this Model.
Returns the nth Event of this Model.


=item Model::getEvent

Get an Event object based on its identifier.
Returns the Event in this Model with the identifier C<sid> or NULL if
no such Event exists.


=item Model::getEvent

Get an Event object based on its identifier.
Returns the Event in this Model with the identifier C<sid> or NULL if
no such Event exists.


=item Model::getNumFunctionDefinitions

Get the number of FunctionDefinition objects in this Model.
Returns the number of FunctionDefinitions in this Model.


=item Model::getNumUnitDefinitions

Get the number of UnitDefinition objects in this Model.
Returns the number of UnitDefinitions in this Model.


=item Model::getNumCompartmentTypes

Get the number of CompartmentType objects in this Model.
Returns the number of CompartmentTypes in this Model.


=item Model::getNumSpeciesTypes

Get the number of SpeciesType objects in this Model.
Returns the number of SpeciesTypes in this Model.


=item Model::getNumCompartments

Get the number of Compartment objects in this Model.
Returns the number of Compartments in this Model.


=item Model::getNumSpecies

Get the number of Specie objects in this Model.
Returns the number of Species in this Model.


=item Model::getNumSpeciesWithBoundaryCondition

Get the number of Species in this Model having their
"boundaryCondition" attribute value set to C<true>.
Returns the number of Species in this Model with boundaryCondition set
to true.


=item Model::getNumParameters

Get the number of Parameter objects in this Model.
Returns the number of Parameters in this Model.  Parameters defined in
KineticLaws are not included.


=item Model::getNumInitialAssignments

Get the number of InitialAssignment objects in this Model.
Returns the number of InitialAssignments in this Model.


=item Model::getNumRules

Get the number of Rule objects in this Model.
Returns the number of Rules in this Model.


=item Model::getNumConstraints

Get the number of Constraint objects in this Model.
Returns the number of Constraints in this Model.


=item Model::getNumReactions

Get the number of Reaction objects in this Model.
Returns the number of Reactions in this Model.


=item Model::getNumEvents

Get the number of Event objects in this Model.
Returns the number of Events in this Model.


=item Model::convertToL1

Converts the model to a from SBML Level 2 to Level 1.
Most of the necessary changes occur during the various
writeAttributes() methods, however there are some difference between
L1 and L2 that require the underlying Model to be changed.


=item Model::convertToL2

Converts the model to a from SBML Level 1 to Level 2.
Most of the necessary changes occur during the various
writeAttributes() methods, however there are some difference between
L1 and L2 that require the underlying Model to be changed.


=item Model::isBoolean

Predicate returning C<true> or C<false> depending on whether the
given ASTNode is a boolean.
Often times, this question can be answered with the ASTNode's own
isBoolean() method, but if the AST is an expression that calls a
function defined in the Model's ListOfFunctionDefinitions, the model
is needed for lookup context.
Returns true if the given ASTNode is a boolean.


=item Model::setSBMLDocument

Sets the parent SBMLDocument of this SBML object.
@param d the SBMLDocument object to set
@deprecated libSBML internal


=item Model::setParentSBMLObject

Sets the parent SBML object of this SBML object.
@param sb the SBML object to use
@deprecated libSBML internal


=item Model::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for this object, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item Model::getElementName

Returns the XML element name of this object, which for Model, is
always C<"model">.
Returns the name of this element, i.e., C<"model">.


=item Model::getElementPosition

Returns the ordinal position of the element with respect to its
siblings or -1 (default) to indicate the position is not significant.
@deprecated libSBML internal


=item Model::writeElements

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.
@deprecated libSBML internal


=item Model::getListOfLayouts

Returns the ListOf Layouts for this Model.


=item Model::getListOfLayouts

Returns the ListOf Layouts for this Model.


=item Model::getLayout

Returns the layout object that belongs to the given index. If the
index is invalid, NULL is returned.


=item Model::getLayout

Returns the layout object that belongs to the given index. If the
index is invalid, NULL is returned.


=item Model::addLayout

Adds a copy of the layout object to the list of layouts.


=item Model::createLayout

Creates a new layout object and adds it to the list of layout objects
and returns it.


=item Model::populateListFormulaUnitsData

Populates the list of FormulaDataUnits with the units derived 
for the model. The list contains elements of class
FormulaUnitsData. 

The first element of the list refers to the default units
of 'substance per time' derived from the model and has the
unitReferenceId 'subs_per_time'. This facilitates the comparison of units
derived from mathematical formula with the expected units.
The next elements of the list record the units of the 
compartments and species established from either explicitly
declared or default units.
The next elements record the units of any parameters.
Subsequent elements of the list record the units derived for
each mathematical expression encountered within the model.
@note This function is utilised by the Unit Consistency Validator.
The List is populated prior to running the validation and thus
the consistency of units can be checked by accessing the members
of the list and comparing the appropriate data.


=item Model::isPopulatedListFormulaUnitsData

Predicate returning C<true> or C<false> depending on whether 
the list of FormulaUnitsData has been populated.
Returns C<true> if the list of FormulaUnitsData has been populated, 
C<false> otherwise.


=item Model::addFormulaUnitsData

Adds a copy of the given FormulaUnitsData object to this Model.
@param fud the FormulaUnitsData to add
@deprecated libSBML internal


=item Model::createFormulaUnitsData

Creates a new FormulaUnitsData inside this Model and returns it.
Returns the FormulaUnitsData object created
@deprecated libSBML internal


=item Model::getFormulaUnitsData

Get the nth FormulaUnitsData object in this Model.
Returns the nth FormulaUnitsData of this Model.
@deprecated libSBML internal


=item Model::getFormulaUnitsData

Get the nth FormulaUnitsData object in this Model.
Returns the nth FormulaUnitsData of this Model.
@deprecated libSBML internal


=item Model::getFormulaUnitsData

Get a FormulaUnitsData object based on its unitReferenceId and typecode.
Returns the FormulaUnitsData in this Model with the unitReferenceId C<sid> 
and the SBMLTypeCode_t C<typecode> or NULL
if no such FormulaUnitsData exists.
@note The SBMLTypecode_t parameter is necessary as the unitReferenceId
of the FormulaUnitsData need not be unique. For example if a Species
with id 's' is assigned by an AssignmentRule there will be two 
elements of the FormulaUnitsData List with the unitReferenceId 's'; 
one with
typecode 'SBML_SPECIES' referring to the units related to the species, 
the other with typecode 'SBML_ASSIGNMENT_RULE' referring to the units
derived from the math element of the AssignmentRule.
@deprecated libSBML internal


=item Model::getFormulaUnitsData

Get a FormulaUnitsData object based on its unitReferenceId and typecode.
Returns the FormulaUnitsData in this Model with the unitReferenceId C<sid> 
and the SBMLTypeCode_t C<typecode> or NULL
if no such FormulaUnitsData exists.
@note The SBMLTypecode_t parameter is necessary as the unitReferenceId
of the FormulaUnitsData need not be unique. For example if a Species
with id 's' is assigned by an AssignmentRule there will be two 
elements of the FormulaUnitsData List with the unitReferenceId 's'; 
one with
typecode 'SBML_SPECIES' referring to the units related to the species, 
the other with typecode 'SBML_ASSIGNMENT_RULE' referring to the units
derived from the math element of the AssignmentRule.
@deprecated libSBML internal


=item Model::getNumFormulaUnitsData

Get the number of FormulaUnitsData objects in this Model.
Returns the number of FormulaUnitsData in this Model.
@deprecated libSBML internal


=item Model::getListFormulaUnitsData

Get the list of FormulaUnitsData object in this Model.
Returns the list of FormulaUnitsData for this Model.
@deprecated libSBML internal


=item Model::getListFormulaUnitsData

Get the list of FormulaUnitsData object in this Model.
Returns the list of FormulaUnitsData for this Model.
@deprecated libSBML internal


=item Model::readOtherXML

Subclasses should override this method to read (and store) XHTML,
MathML, etc. directly from the XMLInputStream.
Returns true if the subclass read from the stream, false otherwise.
@deprecated libSBML internal


=item Model::createObject

Returns the SBML object corresponding to next XMLToken in the
XMLInputStream or NULL if the token was not recognized.
@deprecated libSBML internal


=item Model::readAttributes

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.
@deprecated libSBML internal


=item Model::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Model::syncAnnotation

Synchronizes the annotation of this SBML object.
Annotation element (XMLNode  mAnnotation) is synchronized with the
current CVTerm objects (List  mCVTerm), ModelHistory object 
(ModelHistory  mHistory) and ListOfLayouts object (ListOfLayouts mLayouts).
Currently, this method is called in getAnnotation, isSetAnnotation,
and writeElements methods.
@deprecated libSBML internal


=item Model::syncAnnotation

Synchronizes the annotation of this SBML object.
Annotation element (XMLNode  mAnnotation) is synchronized with the
current CVTerm objects (List  mCVTerm), ModelHistory object 
(ModelHistory  mHistory) and ListOfLayouts object (ListOfLayouts mLayouts).
Currently, this method is called in getAnnotation, isSetAnnotation,
and writeElements methods.
@deprecated libSBML internal


=item Model::syncAnnotation

Synchronizes the annotation of this SBML object.
Annotation element (XMLNode  mAnnotation) is synchronized with the
current CVTerm objects (List  mCVTerm), ModelHistory object 
(ModelHistory  mHistory) and ListOfLayouts object (ListOfLayouts mLayouts).
Currently, this method is called in getAnnotation, isSetAnnotation,
and writeElements methods.
@deprecated libSBML internal


=item Model::syncAnnotation

Synchronizes the annotation of this SBML object.
Annotation element (XMLNode  mAnnotation) is synchronized with the
current CVTerm objects (List  mCVTerm), ModelHistory object 
(ModelHistory  mHistory) and ListOfLayouts object (ListOfLayouts mLayouts).
Currently, this method is called in getAnnotation, isSetAnnotation,
and writeElements methods.
@deprecated libSBML internal


=item Model::syncAnnotation

Synchronizes the annotation of this SBML object.
Annotation element (XMLNode  mAnnotation) is synchronized with the
current CVTerm objects (List  mCVTerm), ModelHistory object 
(ModelHistory  mHistory) and ListOfLayouts object (ListOfLayouts mLayouts).
Currently, this method is called in getAnnotation, isSetAnnotation,
and writeElements methods.
@deprecated libSBML internal


=item Model::syncAnnotation

Synchronizes the annotation of this SBML object.
Annotation element (XMLNode  mAnnotation) is synchronized with the
current CVTerm objects (List  mCVTerm), ModelHistory object 
(ModelHistory  mHistory) and ListOfLayouts object (ListOfLayouts mLayouts).
Currently, this method is called in getAnnotation, isSetAnnotation,
and writeElements methods.
@deprecated libSBML internal


=item Model::syncAnnotation

Synchronizes the annotation of this SBML object.
Annotation element (XMLNode  mAnnotation) is synchronized with the
current CVTerm objects (List  mCVTerm), ModelHistory object 
(ModelHistory  mHistory) and ListOfLayouts object (ListOfLayouts mLayouts).
Currently, this method is called in getAnnotation, isSetAnnotation,
and writeElements methods.
@deprecated libSBML internal


=item Model::syncAnnotation

Synchronizes the annotation of this SBML object.
Annotation element (XMLNode  mAnnotation) is synchronized with the
current CVTerm objects (List  mCVTerm), ModelHistory object 
(ModelHistory  mHistory) and ListOfLayouts object (ListOfLayouts mLayouts).
Currently, this method is called in getAnnotation, isSetAnnotation,
and writeElements methods.
@deprecated libSBML internal


=item Model::syncAnnotation

Synchronizes the annotation of this SBML object.
Annotation element (XMLNode  mAnnotation) is synchronized with the
current CVTerm objects (List  mCVTerm), ModelHistory object 
(ModelHistory  mHistory) and ListOfLayouts object (ListOfLayouts mLayouts).
Currently, this method is called in getAnnotation, isSetAnnotation,
and writeElements methods.
@deprecated libSBML internal


=item Model::syncAnnotation

Synchronizes the annotation of this SBML object.
Annotation element (XMLNode  mAnnotation) is synchronized with the
current CVTerm objects (List  mCVTerm), ModelHistory object 
(ModelHistory  mHistory) and ListOfLayouts object (ListOfLayouts mLayouts).
Currently, this method is called in getAnnotation, isSetAnnotation,
and writeElements methods.
@deprecated libSBML internal


=item Model::syncAnnotation

Synchronizes the annotation of this SBML object.
Annotation element (XMLNode  mAnnotation) is synchronized with the
current CVTerm objects (List  mCVTerm), ModelHistory object 
(ModelHistory  mHistory) and ListOfLayouts object (ListOfLayouts mLayouts).
Currently, this method is called in getAnnotation, isSetAnnotation,
and writeElements methods.
@deprecated libSBML internal


=item Model::syncAnnotation

Synchronizes the annotation of this SBML object.
Annotation element (XMLNode  mAnnotation) is synchronized with the
current CVTerm objects (List  mCVTerm), ModelHistory object 
(ModelHistory  mHistory) and ListOfLayouts object (ListOfLayouts mLayouts).
Currently, this method is called in getAnnotation, isSetAnnotation,
and writeElements methods.
@deprecated libSBML internal


=item Model::syncAnnotation

Synchronizes the annotation of this SBML object.
Annotation element (XMLNode  mAnnotation) is synchronized with the
current CVTerm objects (List  mCVTerm), ModelHistory object 
(ModelHistory  mHistory) and ListOfLayouts object (ListOfLayouts mLayouts).
Currently, this method is called in getAnnotation, isSetAnnotation,
and writeElements methods.
@deprecated libSBML internal


=item Model::syncAnnotation

Synchronizes the annotation of this SBML object.
Annotation element (XMLNode  mAnnotation) is synchronized with the
current CVTerm objects (List  mCVTerm), ModelHistory object 
(ModelHistory  mHistory) and ListOfLayouts object (ListOfLayouts mLayouts).
Currently, this method is called in getAnnotation, isSetAnnotation,
and writeElements methods.
@deprecated libSBML internal


=item Model::syncAnnotation

Synchronizes the annotation of this SBML object.
Annotation element (XMLNode  mAnnotation) is synchronized with the
current CVTerm objects (List  mCVTerm), ModelHistory object 
(ModelHistory  mHistory) and ListOfLayouts object (ListOfLayouts mLayouts).
Currently, this method is called in getAnnotation, isSetAnnotation,
and writeElements methods.
@deprecated libSBML internal


=back

=head2 SBMLDocument

Container for an SBML document and interface for global operations
on SBML documents.
@if clike LibSBML uses the class SBMLDocument as a
top-level container for storing SBML content and data associated with it
(such as warnings and error messages).  The two primary means of reading
an SBML model, SBMLReader::readSBML() and
SBMLReader::readSBMLFromString(), both return a pointer to an
SBMLDocument object.  From there, callers can inquire about any errors
encountered (e.g., using SBMLDocument::getNumErrors()), access the Model
object, and perform other actions such as consistency-checking and model
translation. @endif@if java LibSBML uses the class
SBMLDocument as a top-level container for storing SBML content and data
associated with it (such as warnings and error messages).  The two
primary means of reading an SBML model, SBMLReader::readSBML(String
filename) and SBMLReader::readSBMLFromString(String xml), both return a
pointer to an SBMLDocument object.  From there, callers can inquire
about any errors encountered (e.g., using SBMLDocument::getNumErrors()),
access the Model object, and perform other actions such as
consistency-checking and model translation. @endif
When creating fresh models programmatically, the starting point is
typically the creation of an SBMLDocument object instance.  The
SBMLDocument constructor accepts arguments for the SBML Level and
Version of the model to be created.  After creating the SBMLDocument
object, calling programs then typically call SBMLDocument::createModel()
almost immediately, and then proceed to call the methods on the Model
object to fill out the model's contents.
SBMLDocument corresponds roughly to the class <i>Sbml</i> defined in the
SBML Level&nbsp;2 specification.  It does not have a direct
correspondence in SBML Level&nbsp;1.  (However, to make matters simpler
for applications, libSBML creates an SBMLDocument no matter whether the model
is Level&nbsp;1 or Level&nbsp;2.)  In its barest form, when written out
in XML format for SBML Level&nbsp;2 Version&nbsp;4, the corresponding
structure is the following:
@verbatim
<sbml xmlns="http://www.sbml.org/sbml/level2/version4" level="2" version="4"
...
</sbml>
@endverbatim
SBMLDocument is derived from SBase, and therefore contains the usual SBase
attributes (in SBML Level&nbsp;2 Version&nbsp;4) of "metaid" and "sboTerm", as
well as the subelements "notes" and "annotation".  It also contains the
attributes "level" and "version" indicating the Level and Version of the
SBML data structure.  These can be accessed using the methods defined by
the SBase class for that purpose.
@section checking Checking consistency and adherence to SBML specifications
One of the most important features of libSBML is its ability to perform
SBML validation to ensure that a model adheres to the SBML specification
for whatever Level+Version combination the model uses.  SBMLDocument
provides the methods for running consistency-checking and validation
rules on the SBML content.
First, a brief explanation of the rationale is in order.  In libSBML
versions up to and including the version 3.3.x series, the individual
methods for creating and setting attributes and other components are
quite lenient, and allow a caller to compose SBML entities that may not,
in the end, represent valid SBML.  This allows applications the freedom
to do things such as save incomplete models (which is useful when models
are being developed over long periods of time), but at the same time, it
means that a separate validation step is necessary when a calling
program finally wants to finish a complete SBML document.
The primary interface to this facility is SBMLDocument's
SBMLDocument::checkInternalConsistency() and
SBMLDocument::checkConsistency().  The former verifies the basic
internal consistency and syntax of an SBML document, and the latter
implements more elaborate validation rules (both those defined by the
SBML specifications, as well as additional rules offered by libSBML).
@if clike The checks performed by
SBMLDocument::checkInternalConsistency() are hardwired and cannot be
changed by calling programs, but the validation performed by
SBMLDocument::checkConsistency() is under program control using the
method SBMLDocument::setConsistencyChecks().  Applications can
selectively disable specific kinds of checks that they may not be
interested in, by calling SBMLDocument::setConsistencyChecks() with
appropriate parameters.  @endif@if java The checks
performed by SBMLDocument::checkInternalConsistency() are hardwired and
cannot be changed by calling programs, but the validation performed by
SBMLDocument::checkConsistency() is under program control using the
method SBMLDocument::setConsistencyChecks(int categ, boolean onoff).
Applications can selectively disable specific kinds of checks that they
may not be interested by calling SBMLDocument::setConsistencyChecks(int
categ, boolean onoff) with appropriate parameters. @endif
These methods have slightly different relevance depending on whether a
model is created programmaticaly from scratch, or whether it is read in
from a file or data stream.  The following table summarizes the possible
scenarios.

<center>
<table border="0" class="text-table width80 normal-font alt-row-colors">
<tr style="background: lightgray; font-size: 14px;">
<th align="left" width="200">Scenario</th>
<th align="left">Relevant methods</th>
</tr>
<tr><td>Creating a model from scratch</td>
<td>Before writing out the model:<ol>
<li style="margin-bottom: 0.5em">Call
SBMLDocument::checkInternalConsistency(), then inquire about the results by
calling SBMLDocument::getNumErrors()</li>
<li style="margin-bottom: 0.5em">
Call @if clike SBMLDocument::setConsistencyChecks() @endif@if java SBMLDocument::setConsistencyChecks(int categ, boolean onoff) @endif to configure which checks
will be performed by SBMLDocument::checkConsistency()</li>
<li>Call SBMLDocument::checkConsistency(), then inquire about the results by
calling SBMLDocument::getNumErrors()</li>
</ol>
</td>
<tr><td>Reading a model from a file or data stream</td>
<td>After reading the model:<ol>
<li style="margin-bottom: 0.5em">Basic consistency checks will have been
performed automatically by libSBML upon reading the content&mdash;only need
to inquire about the results by using SBMLDocument::getNumErrors()</li>
<li style="margin-bottom: 0.5em">
Call @if clike SBMLDocument::setConsistencyChecks() @endif@if java SBMLDocument::setConsistencyChecks(int categ, boolean onoff) @endif to configure which
checks are performed by SBMLDocument::checkConsistency()</li>
<li>Call SBMLDocument::checkConsistency(), then inquire about the results
by calling SBMLDocument::getNumErrors()</li>
</ol>
</td>
</table>
</center>
@if clike An example of using the consistency-checking
and validation facilities is provided in this manual in the
section @ref libsbml-example. @endif
@section converting Converting documents between Levels and Versions of SBML
LibSBML provides facilities for limited translation of SBML between
Levels and Versions of the SBML specifications.  The method for doing is
is @if clike SBMLDocument::setLevelAndVersion() @endif@if java SBMLDocument::setLevelAndVersion(long lev, long ver) @endif.  In 
general, models can be converted upward without difficulty (e.g., from
SBML Level&nbsp;1 to Level&nbsp;2, or from an earlier Version of
Level&nbsp;2 to the latest Version of Level&nbsp;2).  Sometimes models
can be translated downward as well, if they do not use constructs
specific to more advanced Levels of SBML.
Calling @if clike SBMLDocument::setLevelAndVersion() @endif@if java SBMLDocument::setLevelAndVersion(long lev, long ver) @endif will not I<necessarily> lead
to a successful conversion.  The method will return a boolean value
to indicate success or failure.  Callers must check the error log (see 
next section) attached to the SBMLDocument object after calling
@if clike SBMLDocument::setLevelAndVersion() @endif@if java SBMLDocument::setLevelAndVersion(long lev, long ver) @endif in order to assess whether any
problems arose.
If an application is interested in translating to a lower Level and/or
Version of SBML within a Level, the following methods allow for prior
assessment of whether there is sufficient compatibility to make a
translation possible:
@li SBMLDocument::checkL1Compatibility(),
@li SBMLDocument::checkL2v1Compatibility(),
@li SBMLDocument::checkL2v2Compatibility(),
@li SBMLDocument::checkL2v3Compatibility(), and
@li SBMLDocument::checkL2v4Compatibility().
Some changes between Versions of SBML Level&nbsp;2 may lead to
unexpected behaviors when attempting conversions in either direction.
For example, SBML Level&nbsp;2 Version&nbsp;4 relaxed the requirement
for consistency in units of measurement between expressions annd
quantities in a model.  As a result, a model written in Version&nbsp;4,
if converted to Version&nbsp;3 with no other changes, may fail
validation as a Version&nbsp;3 model because Version&nbsp;3 imposed
stricter requirements on unit consistency.
@section errors Error handling
Upon reading a model, SBMLDocument logs any problems encountered while
reading the model from the file or data stream.  The log contains
objects that record diagnostic information about any notable issues that
arose.  Whether the problems are warnings or errors, they are both
reported through a single common interface involving the object class
SBMLError.

The methods SBMLDocument::getNumErrors(), @if clike SBMLDocument::getError() @endif@if java SBMLDocument::getError(long n) @endif and
SBMLDocument::printErrors() allow callers to interact with the warnings
or errors logged.  Alternatively, callers may retrieve the entire log as
an SBMLErrorLog object using the method SBMLDocument::getErrorLog().
The SBMLErrorLog object provides some alternative methods for
interacting with the set of errors and warnings.  In either case,
applications typically should first call SBMLDocument::getNumErrors() to
find out if any issues have been logged after specific libSBML
operations such as the ones discussed in the sections above.  If they
have, then an application will should proceed to inspect the individual
reports using either the direct interfaces on SBMLDocument or using the
methods on the SBMLErrorLog object.
@if clike An example of using the error facility is
provided in this manual in the
section @ref libsbml-example. @endif
<hr style="margin: 1em auto">


=over

=item SBMLDocument::getDefaultLevel

The default SBML Level of new SBMLDocument objects.
This "default level" corresponds to the most recent SBML specification
Level available at the time this version of libSBML was released.  For
this copy of libSBML, the value is C<2>.  The default Level
is used by SBMLDocument if no Level is explicitly specified at the
time of the construction of an SBMLDocument instance. 
Returns an integer indicating the most recent SBML specification Level
@see getDefaultVersion()


=item SBMLDocument::getDefaultVersion

The default Version of new SBMLDocument objects.
This "default version" corresponds to the most recent SBML Version
within the most recent Level of SBML available at the time this
version of libSBML was released.  For this copy of libSBML, the value
is C<4>.  The default Version is used by SBMLDocument if no
Version is explicitly specified at the time of the construction of an
SBMLDocument instance.
Returns an integer indicating the most recent SBML specification
Version

@see getDefaultLevel()


=item SBMLDocument::SBMLDocument

Creates a new SBMLDocument, optionally with given values for the SBML
Level and Version.
If <em>both</em> the SBML Level and Version attributes are not
specified, the SBML document is treated as having the latest Level and
Version of SBML as determined by SBMLDocument::getDefaultLevel() and
SBMLDocument::getDefaultVersion(); <em>however</em>, the SBMLDocument
object is otherwise left blank.  In particular, the blank SBMLDocument
object has no associated XML attributes, including (but not limited
to) an XML namespace declaration.  The XML namespace declaration is
not added until the model is written out, <em>or</em> the method
@if clike SBMLDocument::setLevelAndVersion() @endif@if java SBMLDocument::setLevelAndVersion(long lev, long ver) @endif is called.  This may be important to keep in mind
if an application needs to add additional XML namespace declarations
on the C<&lt;sbml&gt;> element.  Application writers should
either provide values for C<level> and C<version> on the call to this
constructor, or else call @if clike SBMLDocument::setLevelAndVersion() @endif@if java SBMLDocument::setLevelAndVersion(long lev, long ver) @endif shortly after creating
the SBMLDocument object.
@param level an integer for the SBML Level
@param version an integer for the Version within the SBML Level
@if clike @see SBMLDocument::setLevelAndVersion() @endif@if java @see SBMLDocument::setLevelAndVersion(long lev, long ver) @endif
@see getDefaultLevel()
@see getDefaultVersion()
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item SBMLDocument::SBMLDocument

Copy constructor; creates a copy of this SBMLDocument.


=item SBMLDocument::accept

Accepts the given SBMLVisitor for this instance of SBMLDocument.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>.


=item SBMLDocument::clone

Creates and returns a deep copy of this SBMLDocument.
Returns a (deep) copy of this SBMLDocument.


=item SBMLDocument::getModel

Returns the Model object stored in this SBMLDocument.
It is important to note that this method <em>does not create</em> a
Model instance.  The model in the SBMLDocument must have been created
at some prior time, for example using SBMLDocument::createModel() 
or @if clike SBMLDocument::setModel() @endif@if java SBMLDocument::setModel(Model m) @endif.
This method returns NULL if a model does not yet exist.
Returns the Model contained in this SBMLDocument.
@see createModel()


=item SBMLDocument::getModel

Returns the Model object stored in this SBMLDocument.
It is important to note that this method <em>does not create</em> a
Model instance.  The model in the SBMLDocument must have been created
at some prior time, for example using SBMLDocument::createModel() 
or @if clike SBMLDocument::setModel() @endif@if java SBMLDocument::setModel(Model m) @endif.
This method returns NULL if a model does not yet exist.
Returns the Model contained in this SBMLDocument.
@see createModel()


=item SBMLDocument::setLevelAndVersion

Sets the SBML Level and Version of this SBMLDocument instance,
attempting to convert the model as needed.
This method is the principal way in libSBML to convert models between
Levels and Versions of SBML.  Generally, models can be converted
upward without difficulty (e.g., from SBML Level&nbsp;1 to
Level&nbsp;2, or from an earlier Version of Level&nbsp;2 to the latest
Version of Level&nbsp;2).  Sometimes models can be translated downward
as well, if they do not use constructs specific to more advanced
Levels of SBML.
Before calling this method, callers may check compatibility directly
using the methods SBMLDocument::checkL1Compatibility(),
SBMLDocument::checkL2v1Compatibility(),
SBMLDocument::checkL2v2Compatibility(),
SBMLDocument::checkL2v3Compatibility() and
SBMLDocument::checkL2v4Compatibility().

The valid combinations of SBML Level and Version as of this release
of libSBML are the following: 

=over


=item

Level&nbsp;1 Version&nbsp;2

=item

Level&nbsp;2 Version&nbsp;1

=item

Level&nbsp;2 Version&nbsp;2

=item

Level&nbsp;2 Version&nbsp;3

=item

Level&nbsp;2 Version&nbsp;4

=back


@param level the desired SBML Level
@param version the desired Version within the SBML Level
@note Calling this method will not I<necessarily> lead to a successful
conversion.  If the conversion fails, it will be logged in the error
list associated with this SBMLDocument.  Callers should consult
getNumErrors() to find out if the conversion succeeded without
problems.  For conversions from Level&nbsp;2 to Level&nbsp;1, callers
can also check the Level of the model after calling this method to
find out whether it is Level&nbsp;1.  (If the conversion to
Level&nbsp;1 failed, the Level of this model will be left unchanged.)
@see checkL1Compatibility()
@see checkL2v1Compatibility()
@see checkL2v2Compatibility()
@see checkL2v3Compatibility()
@see checkL2v4Compatibility()


=item SBMLDocument::setModel

Sets the Model for this SBMLDocument to a copy of the given Model.
@param m the new Model to use.
@see createModel()
@see getModel()


=item SBMLDocument::createModel

Creates a new Model inside this SBMLDocument, and returns a pointer to
it.

In SBML Level&nbsp;2, the use of an identifier on a Model object is
optional.  This method takes an optional argument, C<sid>, for setting
the identifier.  If not supplied, the identifier attribute on the
Model instance is not set.
@param sid the identifier of the new Model to create.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.

@see getModel()
@see @if clike SBMLDocument::setModel() @endif@if java SBMLDocument::setModel(Model m) @endif


=item SBMLDocument::setConsistencyChecks

Controls the consistency checks that are performed when
SBMLDocument::checkConsistency() is called.
This method works by adding or subtracting consistency checks from the
set of all possible checks that SBMLDocument::checkConsistency() knows
how to perform.  This method may need to be called multiple times in
order to achieve the desired combination of checks.  The first
argument (C<category>) in a call to this method indicates the category
of consistency/error checks that are to be turned on or off, and the
second argument (C<apply>, a boolean) indicates whether to turn it on
(value of C<true>) or off (value of C<false>).
The possible categories (values to the argument C<category>) are the
set of values from the enumeration #SBMLErrorCategory_t.  The
following are the possible choices in libSBML version&nbsp;3.3.x:
@li C<LIBSBML_CAT_GENERAL_CONSISTENCY>: Correctness and consistency of
specific SBML language constructs.  Performing this set of checks is
highly recommended.  With respect to the SBML specification, these
concern failures in applying the validation rules numbered 2xxxx in
the Level&nbsp;2 Versions&nbsp;2, 3 and&nbsp;4 specifications.
@li C<LIBSBML_CAT_IDENTIFIER_CONSISTENCY>: Correctness and consistency
of identifiers used for model entities.  An example of inconsistency
would be using a species identifier in a reaction rate formula without
first having declared the species.  With respect to the SBML
specification, these concern failures in applying the validation rules
numbered 103xx in the Level&nbsp;2 Versions&nbsp;2, 3 and&nbsp;4
specifications.

@li C<LIBSBML_CAT_UNITS_CONSISTENCY>: Consistency of measurement units
associated with quantities in a model.  With respect to the SBML
specification, these concern failures in applying the validation rules
numbered 105xx in the Level&nbsp;2 Versions&nbsp;2, 3 and&nbsp;4
specifications.

@li C<LIBSBML_CAT_MATHML_CONSISTENCY>: Syntax of MathML constructs.
With respect to the SBML specification, these concern failures in
applying the validation rules numbered 102xx in the Level&nbsp;2
Versions&nbsp;2, 3 and&nbsp;4 specifications.
@li C<LIBSBML_CAT_SBO_CONSISTENCY>: Consistency and validity of SBO
identifiers (if any) used in the model.  With respect to the SBML
specification, these concern failures in applying the validation rules
numbered 107xx in the Level&nbsp;2 Versions&nbsp;2, 3 and&nbsp;4
specifications.

@li C<LIBSBML_CAT_OVERDETERMINED_MODEL>: Static analysis of
whether the system of equations implied by a model is mathematically
overdetermined.  With respect to the SBML specification, this is
validation rule #10601 in the SBML Level&nbsp;2 Versions&nbsp;2, 3
and&nbsp;4 specifications.
@li C<LIBSBML_CAT_MODELING_PRACTICE>: Additional checks for
recommended good modeling practice. (These are tests performed by
libSBML and do not have equivalent SBML validation rules.)
<em>By default, all validation checks are applied</em> to the model in
an SBMLDocument object I<unless> @if clike SBMLDocument::setConsistencyChecks() @endif@if java SBMLDocument::setConsistencyChecks(int categ, boolean onoff) @endif is called to
indicate that only a subset should be applied.  Further, this default
(i.e., performing all checks) applies separately to <em>each new
SBMLDocument object</em> created.  In other words, each time a model
is read using @if clike SBMLReader::readSBML() @endif@if java SBMLReader::readSBML(String filename) @endif, @if clike SBMLReader::readSBMLFromString() @endif@if java SBMLReader::readSBMLFromString(String xml) @endif,
or the global functions readSBML() and readSBMLFromString(), a new
SBMLDocument is created and for that document, a call to
SBMLDocument::checkConsistency() will default to applying all possible checks.
Calling programs must invoke @if clike SBMLDocument::setConsistencyChecks() @endif@if java SBMLDocument::setConsistencyChecks(int categ, boolean onoff) @endif for each such new
model if they wish to change the consistency checks applied.
@param category a value drawn from #SBMLErrorCategory_t indicating the
consistency checking/validation to be turned on or off
@param apply a boolean indicating whether the checks indicated by @p
category should be applied or not.
@see SBMLDocument::checkConsistency()


=item SBMLDocument::checkConsistency

Performs consistency checking and validation on this SBML document.
If this method returns a nonzero value (meaning, one or more
consistency checks have failed for SBML document), the failures may be
due to warnings I<or> errors.  Callers should inspect the severity
flag in the individual SBMLError objects returned by
@if clike SBMLDocument::getError() @endif@if java SBMLDocument::getError(long n) @endif to determine the nature of the failures.
Returns the number of failed checks (errors) encountered.
@see SBMLDocument::checkInternalConsistency()


=item SBMLDocument::checkInternalConsistency

Performs consistency checking on libSBML's internal representation of 
an SBML Model.
Callers should query the results of the consistency check by calling
@if clike SBMLDocument::getError() @endif@if java SBMLDocument::getError(long n) @endif.
Returns the number of failed checks (errors) encountered.
The distinction between this method and
SBMLDocument::checkConsistency() is that this method reports on
fundamental syntactic and structural errors that violate the XML
Schema for SBML; by contrast, SBMLDocument::checkConsistency()
performs more elaborate model verifications and also validation
according to the validation rules written in the appendices of the
SBML Level&nbsp;2 Versions&nbsp;2&ndash;4 specification documents.
@see SBMLDocument::checkConsistency()


=item SBMLDocument::checkL1Compatibility

Performs a set of consistency checks on the document to establish
whether it is compatible with SBML Level&nbsp;1 and can be converted
to Level&nbsp;1.
Callers should query the results of the consistency check by calling
@if clike SBMLDocument::getError() @endif@if java SBMLDocument::getError(long n) @endif.
Returns the number of failed checks (errors) encountered.


=item SBMLDocument::checkL2v1Compatibility

Performs a set of consistency checks on the document to establish
whether it is compatible with SBML Level&nbsp;2 Version&nbsp;1 and can
be converted to Level&nbsp;2 Version&nbsp;1.
Callers should query the results of the consistency check by calling
@if clike SBMLDocument::getError() @endif@if java SBMLDocument::getError(long n) @endif.
Returns the number of failed checks (errors) encountered.


=item SBMLDocument::checkL2v2Compatibility

Performs a set of consistency checks on the document to establish
whether it is compatible with SBML Level&nbsp;2 Version&nbsp;2 and can
be converted to Level&nbsp;2 Version&nbsp;2.
Callers should query the results of the consistency check by calling
@if clike SBMLDocument::getError() @endif@if java SBMLDocument::getError(long n) @endif.
Returns the number of failed checks (errors) encountered.


=item SBMLDocument::checkL2v3Compatibility

Performs a set of consistency checks on the document to establish
whether it is compatible with SBML Level&nbsp;2 Version&nbsp;3 and can
be converted to Level&nbsp;2 Version&nbsp;3.
Callers should query the results of the consistency check by calling
@if clike SBMLDocument::getError() @endif@if java SBMLDocument::getError(long n) @endif.
Returns the number of failed checks (errors) encountered.


=item SBMLDocument::checkL2v4Compatibility

Performs a set of consistency checks on the document to establish
whether it is compatible with SBML Level&nbsp;2 Version&nbsp;4 and can
be converted to Level&nbsp;2 Version&nbsp;4.
Callers should query the results of the consistency check by calling
@if clike SBMLDocument::getError() @endif@if java SBMLDocument::getError(long n) @endif.
Returns the number of failed checks (errors) encountered.


=item SBMLDocument::getError

Returns the nth error or warning encountered during parsing,
consistency checking, or attempted translation of this model.
Callers can use method XMLError::getSeverity() on the result to assess
the severity of the problem.  The possible severity levels range from
informational messages to fatal errors.
Returns the error or warning indexed by integer C<n>, or return @c
NULL if C<n &gt; (getNumErrors() - 1)>.
@param n the integer index of the error sought.
@see SBMLDocument::getNumErrors()


=item SBMLDocument::getNumErrors

Returns the number of errors or warnings encountered during parsing,
consistency checking, or attempted translation of this model.
Returns the number of errors or warnings encountered


=item SBMLDocument::printErrors

Prints to the given output stream all the errors or warnings
encountered during parsing, consistency checking, or attempted
translation of this model.
If no errors have occurred, i.e., C<getNumErrors() == 0>, no
output will be sent to the stream.
The format of the output is:
@verbatim
N error(s):
line NNN: (id) message
@endverbatim
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item SBMLDocument::setSBMLDocument

No-op; it is provided for consistency with the method available on
other libSBML object classes but has no effect on SBMLDocument.
@deprecated libSBML internal


=item SBMLDocument::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for this object, or C<SBML_UNKNOWN> (default).
@see SBMLDocument::getElementName()


=item SBMLDocument::getElementName

Returns the XML element name of this object, which for SBMLDocument,
is always C<"sbml">.
Returns the name of this element, i.e., C<"sbml">.


=item SBMLDocument::getErrorLog

Returns the list of errors or warnings logged during parsing, 
consistency checking, or attempted translation of this model.
Returns the SBMLErrorLog used for this SBMLDocument
@see SBMLDocument::getNumErrors()


=item SBMLDocument::getNamespaces

Returns a list of XML Namespaces associated with the XML content
of this SBML document.
Returns the XML Namespaces associated with this SBML object


=item SBMLDocument::getElementPosition

Returns the ordinal position of the element with respect to its
siblings or -1 (default) to indicate the position is not significant.
@deprecated libSBML internal


=item SBMLDocument::writeElements

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.
@deprecated libSBML internal


=item SBMLDocument::createObject

Returns the SBML object corresponding to next XMLToken in the
XMLInputStream or NULL if the token was not recognized.
@deprecated libSBML internal


=item SBMLDocument::readAttributes

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.
@deprecated libSBML internal


=item SBMLDocument::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item SBMLDocument::conversion_errors

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item SBMLDocument::hasStrictUnits

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item SBMLDocument::hasStrictSBO

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item SBMLDocument::hasStrictSBO

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item SBMLDocument::hasStrictSBO

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item SBMLDocument::hasStrictSBO

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item SBMLDocument::hasStrictSBO

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item SBMLDocument::hasStrictSBO

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item SBMLDocument::hasStrictSBO

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item SBMLDocument::hasStrictSBO

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=back

=head2 FunctionDefinition

LibSBML implementation of SBML's FunctionDefinition construct.
The FunctionDefinition structure associates an identifier with a
function definition.  This identifier can then be used as the function
called in subsequent MathML content elsewhere in an SBML model.
FunctionDefinition has one required attribute, "id", to give the
function a unique identifier by which other parts of an SBML model
definition can refer to it.  A FunctionDefinition instance can also have
an optional "name" attribute of type C<string>.  Identifiers and names
must be used according to the guidelines described in the SBML
specification (e.g., Section 3.3 in the Level 2 Version 4
specification).

FunctionDefinition has a required "math" subelement containing a MathML
expression defining the function body.  The content of this element can
only be a MathML "lambda" element.  The "lambda" element must begin with
zero or more "bvar" elements, followed by any other of the elements in
the MathML subset allowed in SBML Level 2 I<except> "lambda" (i.e., a
"lambda" element cannot contain another "lambda" element).  This is the
only place in SBML where a "lambda" element can be used.  The function
defined by a FunctionDefinition is only available for use in other
MathML elements that I<follow> the FunctionDefinition definition in the
model.  (These restrictions prevent recursive and mutually-recursive
functions from being expressed.)
A further restriction on the content of "math" is that it cannot contain
references to variables other than the variables declared to the
"lambda" itself.  That is, the contents of MathML "ci" elements inside
the body of the "lambda" can only be the variables declared by its
"bvar" elements, or the identifiers of other FunctionDefinition
instances earlier in the model.  This means must be written so that all
variables or parameters used in the MathML content are passed to them
via their function parameters.
@note Function definitions (also informally known as user-defined
functions) were introduced in SBML Level 2.  They have purposefully
limited capabilities.  A function cannot reference parameters or other
model quantities outside of itself; values must be passed as parameters
to the function.  Moreover, recursive and mutually-recursive functions
are not permitted.  The purpose of these limitations is to balance power
against complexity of implementation.  With the restrictions as they
are, function definitions could be implemented as textual
substitutions&mdash;they are simply macros.  Software implementations
therefore do not need the full function-definition machinery typically
associated with programming languages.
@note Another important point to note is FunctionDefinition does not
have a separate attribute for defining the units of the value returned
by the function.  The units associated with the function's return value,
when the function is called from within MathML expressions elsewhere in
SBML, are simply the overall units of the expression in
FunctionDefinition's "math" subelement when applied to the arguments
supplied in the call to the function.  Ascertaining these units requires
performing dimensional analysis on the expression.  (Readers may wonder
why there is no attribute.  The reason is that having a separate
attribute for declaring the units would not only be redundant, but also
lead to the potential for having conflicting information.  In the case
of a conflict between the declared units and those of the value actually
returned by the function, the only logical resolution rule would be to
assume that the correct units are those of the expression anyway.)
<!---------------------------------------------------------------------- -->


=over

=back

=head2 ListOfFunctionDefinitions

LibSBML implementation of SBML's ListOfFunctionDefinitions construct.
The various ListOf___ classes in SBML are merely containers used for
organizing the main components of an SBML model.  All are derived from
the abstract class SBase, and inherit the various attributes and
subelements of SBase, such as "metaid" as and "annotation".  The
ListOf___ classes do not add any attributes of their own.
The relationship between the lists and the rest of an SBML model is
illustrated by the following (for SBML Level&nbsp;2 Version&nbsp;4):
@image html listof-illustration.jpg "ListOf___ elements in an SBML Model"
@image latex listof-illustration.jpg "ListOf___ elements in an SBML Model"
Readers may wonder about the motivations for using the ListOf___
containers.  A simpler approach in XML might be to place the components
all directly at the top level of the model definition.  We chose instead
to group them within XML elements named after ListOf<em>Classname</em>,
in part because we believe this helps organize the components and makes
visual reading of models in XML easier.  More importantly, the fact that
the container classes are derived from SBase means that software tools
can add information about the lists themselves into each list
container's "annotation".
@see ListOfFunctionDefinitions
@see ListOfUnitDefinitions
@see ListOfCompartmentTypes
@see ListOfSpeciesTypes
@see ListOfCompartments
@see ListOfSpecies
@see ListOfParameters
@see ListOfInitialAssignments
@see ListOfRules
@see ListOfConstraints
@see ListOfReactions
@see ListOfEvents


=over

=item FunctionDefinition::FunctionDefinition

Creates a new FunctionDefinition, optionally with a given identifier
and mathematical formula.
@param id a string, the identifier of this FunctionDefinition instance
@param formula the formula of the function definition expressed as a
string in infix notation 
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item FunctionDefinition::FunctionDefinition

Creates a new FunctionDefinition using the given SBML C<level> and C<version>
values and optionally a set of XMLNamespaces.
@param level an unsigned int, the SBML Level to assign to this FunctionDefinition
@param version an unsigned int, the SBML Version to assign to this
FunctionDefinition

@param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
assign to this FunctionDefinition
@note Once a FunctionDefinition has been added to an SBMLDocument, the C<level>,
C<version> and C<xmlns> namespaces for the document I<override> those used
to create the FunctionDefinition.  Despite this, the ability to supply the values
at creation time is an important aid to creating valid SBML.  Knowledge of
the intented SBML Level and Version determine whether it is valid to
assign a particular value to an attribute, or whether it is valid to add
an object to an existing SBMLDocument.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.

@deprecated libSBML internal


=item FunctionDefinition::FunctionDefinition

Creates a new FunctionDefinition, optionally with a given identifier
and mathematical formula.
@param id a string, the identifier of this FunctionDefinition instance
@param math the formula of the function definition expressed as an
AST.



=item FunctionDefinition::FunctionDefinition

Copy constructor; creates a copy of this FunctionDefinition.


=item FunctionDefinition::accept

Accepts the given SBMLVisitor for this instance of FunctionDefinition.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>, which indicates
whether the Visitor would like to visit the next FunctionDefinition in
the list of function definitions.


=item FunctionDefinition::clone

Creates and returns a deep copy of this FunctionDefinition.
Returns a (deep) copy of this FunctionDefinition.


=item FunctionDefinition::getMath

Get the mathematical formula of this FunctionDefinition.
Returns an ASTNode, the value of the "math" subelement of this
FunctionDefinition



=item FunctionDefinition::isSetMath

Predicate returning C<true> or C<false> depending on whether this
FunctionDefinition's "math" subelement contains a value.
Returns C<true> if the "math" for this FunctionDefinition has been set,
C<false> otherwise.


=item FunctionDefinition::setMath

Sets the "math" subelement of this FunctionDefinition to the Abstract
Syntax Tree given in C<math>.
@param math an AST containing the mathematical expression to
be used as the formula for this FunctionDefinition.


=item FunctionDefinition::getArgument

Get the C<n>th argument to this function.
Callers should first find out the number of arguments to the function
by calling getNumArguments().
@param n an integer index for the argument sought.
Returns the nth argument (bound variable) passed to this
FunctionDefinition.

@see getNumArguments()


=item FunctionDefinition::getArgument

Get the argument named C<name> to this FunctionDefinition.
@param name the exact name (case-sensitive) of the sought-after
argument

Returns the argument (bound variable) having the given name, or NULL if
no such argument exists.


=item FunctionDefinition::getBody

Get the mathematical expression that is the body of this
FunctionDefinition object.
Returns the body of this FunctionDefinition as an Abstract Syntax
Tree, or NULL if no body is defined.


=item FunctionDefinition::getBody

Get the mathematical expression that is the body of this
FunctionDefinition object.
Returns the body of this FunctionDefinition as an Abstract Syntax
Tree, or NULL if no body is defined.


=item FunctionDefinition::getNumArguments

Get the number of arguments (bound variables) taken by this
FunctionDefinition.

Returns the number of arguments (bound variables) that must be passed
to this FunctionDefinition.


=item FunctionDefinition::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for this object, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item FunctionDefinition::getElementName

Returns the XML element name of this object, which for
FunctionDefinition, is always C<"functionDefinition">.
Returns the name of this element, i.e., C<"functionDefinition">.


=item FunctionDefinition::writeElements

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.
@deprecated libSBML internal


=item FunctionDefinition::readOtherXML

Subclasses should override this method to read (and store) XHTML,
MathML, etc. directly from the XMLInputStream.
Returns true if the subclass read from the stream, false otherwise.
@deprecated libSBML internal


=item FunctionDefinition::readAttributes

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.
@deprecated libSBML internal


=item FunctionDefinition::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item FunctionDefinition::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item ListOfFunctionDefinitions::clone

Creates and returns a deep copy of this ListOfFunctionDefinitions instance.
Returns a (deep) copy of this ListOfFunctionDefinitions.


=item ListOfFunctionDefinitions::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for this object, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item ListOfFunctionDefinitions::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., FunctionDefinition objects, if the list is non-empty).
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for the objects contained in this ListOf
instance, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item ListOfFunctionDefinitions::getElementName

Returns the XML element name of this object.
For ListOfFunctionDefinitions, the XML element name is @c
"listOfFunctionDefinitions".

Returns the name of this element, i.e., C<"listOfFunctionDefinitions">.


=item ListOfFunctionDefinitions::get

Get a FunctionDefinition from the ListOfFunctionDefinitions.
@param n the index number of the FunctionDefinition to get.
Returns the nth FunctionDefinition in this ListOfFunctionDefinitions.
@see size()


=item ListOfFunctionDefinitions::get

Get a FunctionDefinition from the ListOfFunctionDefinitions.
@param n the index number of the FunctionDefinition to get.
Returns the nth FunctionDefinition in this ListOfFunctionDefinitions.
@see size()


=item ListOfFunctionDefinitions::get

Get a FunctionDefinition from the ListOfFunctionDefinitions
based on its identifier.
@param sid a string representing the identifier 
of the FunctionDefinition to get.
Returns FunctionDefinition in this ListOfFunctionDefinitions
with the given id or NULL if no such
FunctionDefinition exists.
@see get(unsigned int n)
@see size()


=item ListOfFunctionDefinitions::get

Get a FunctionDefinition from the ListOfFunctionDefinitions
based on its identifier.
@param sid a string representing the identifier 
of the FunctionDefinition to get.
Returns FunctionDefinition in this ListOfFunctionDefinitions
with the given id or NULL if no such
FunctionDefinition exists.
@see get(unsigned int n)
@see size()


=item ListOfFunctionDefinitions::remove

Removes the nth item from this ListOfFunctionDefinitions items and returns a pointer to
it.

The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove
@see size()


=item ListOfFunctionDefinitions::remove

Removes item in this ListOfFunctionDefinitions items with the given identifier.
The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier C<sid>, then @c
NULL is returned.
@param sid the identifier of the item to remove
Returns the item removed.  As mentioned above, the caller owns the
returned item.


=item ListOfFunctionDefinitions::getElementPosition

Get the ordinal position of this element in the containing object
(which in this case is the Model object).
The ordering of elements in the XML form of SBML is generally fixed
for most components in SBML.  So, for example, the
ListOfFunctionDefinitions in a model is (in SBML Level 2 Version 4)
the first ListOf___.  (However, it differs for different Levels and
Versions of SBML.)
Returns the ordinal position of the element with respect to its
siblings, or C<-1> (default) to indicate the position is not significant.
@deprecated libSBML internal


=item ListOfFunctionDefinitions::createObject

Returns the SBML object corresponding to next XMLToken in the
XMLInputStream or NULL if the token was not recognized.
@deprecated libSBML internal


=item UnitKind_equals

Tests for logical equality between two given UnitKind_t values.
This function behaves exactly like C's <tt>==</tt> operator, except for
the following two cases:
@li UNIT_KIND_LITER C<==> UNIT_KIND_LITRE
@li UNIT_KIND_METER C<==> UNIT_KIND_METRE
C equality comparison would yield false (because each of the above is a
distinct enumeration value), but UnitKind_equals() returns true.
@param uk1 a UnitKind_t enumeration value 
@param uk2 the UnitKind_t enumeration value to compare to C<uk1>
Returns nonzero (for true) if uk1 is logically equivalent to uk2,
zero (0) otherwise.
@note For more information about the UnitKind_t enumeration, please
refer to the class documentation for Unit.


=item UnitKind_forName

Converts a string to its corresponding UnitKind_t enumeration value.
@param name a string, the name of a predefined base unit in SBML
Returns a value from UnitKind_t corresponding to the given name
(determined in a case-insensitive manner).
@note For more information about the UnitKind_t enumeration, please
refer to the class documentation for Unit.


=item UnitKind_toString

Converts a UnitKind_t enumeration value to a text string equivalent.
@param uk the UnitKind_t value to convert
Returns the name of the given UnitKind.
@note The string returned is a static data value.  The caller does not
own the returned string and is therefore not allowed to modify it.
@note For more information about the UnitKind_t enumeration, please
refer to the class documentation for Unit.


=item UnitKind_isValidUnitKindString

Predicate for testing whether a given string corresponds to a
predefined UnitKind_t enumeration value.
Returns nonzero (for true) if string is the name of a valid
UnitKind_t enumeration value, zero (0) otherwise.
@note For more information about the UnitKind_t enumeration, please
refer to the class documentation for Unit.


=back

=head2 Unit

LibSBML implementation of SBML's Unit construct.
The SBML unit definition facility uses two classes of objects,
UnitDefinition and Unit.  The approach to defining units in SBML is
compositional; for example, <em>meter second<sup> &ndash;2</sup></em> is
constructed by combining a Unit object representing <em>meter</em> with
another Unit object representing <em>second<sup> &ndash;2</sup></em>.
The combination is wrapped inside a UnitDefinition, which provides for
assigning an identifier and optional name to the combination.  The
identifier can then be referenced from elsewhere in a model.  Thus, the
UnitDefinition class is the container, and Unit instances are placed
inside UnitDefinition instances.
A Unit structure has four attributes named "kind", "exponent", "scale"
and "multiplier".  It represents a (possibly transformed) reference to a
base unit.  The attribute "kind" on Unit indicates the chosen base unit.
Its value in SBML Level&nbsp;2 Version&nbsp;4 must be one of the following
predefined strings:
@htmlinclude libsbml-base-units.html
(See also the definition of the C<UNIT_KIND_> constants in <a
class="el" href="#UnitKind_t">the section below</a>.)  For SBML
Level&nbsp;2 Version&nbsp;1 models, the string C<Celsius> is also
permitted.  Note also that the table above contains two names not
strictly defined in SBML Level&nbsp;2: C<liter> and C<meter>.  For
convenience, libSBML defines the American English spellings of these
units, although the SBML specification limits the valid unit names to
those defined by SI.
The optional attribute named "exponent" on Unit represents an exponent
on the unit.  Its default value is C<1> (one).  A Unit structure also
has an optional attribute called "scale"; its value must be an integer
exponent for a power-of-ten multiplier used to set the scale of the
unit.  For example, a unit having a "kind" value of C<gram> and a
"scale" value of C<-3> signifies 10<sup>&nbsp;&ndash;3</sup>
\f$\times\f$ gram, or milligrams.  The default value of "scale" is C<0>
(zero), because 10<sup> 0</sup> = 1.  Lastly, the optional attribute
named "multiplier" can be used to multiply the kind unit by a
real-numbered factor; this enables the definition of units that are not
power-of-ten multiples of SI units.  For instance, a multiplier of
0.3048 could be used to define C<foot> as a measure of length in terms
of a C<metre>.  The "multiplier" attribute has a default value of C<1>
(one).

<h3><a class="anchor" name="UnitKind_t">UnitKind_t</a></h3>
SBML defines a set of base units which serves as the starting point for
new unit definitions.  This set of base units consists of the SI units
and a small number of additional convenience units.
@if clike Until SBML Level&nbsp;2 Version&nbsp;3, there
existed a data type in the SBML specifications called C<UnitKind>,
enumerating the possible SBML base units.  Although SBML Level&nbsp;2
Version&nbsp;3 removed this type from the language specification,
libSBML maintains the corresponding enumeration type C<UnitKind_t> as a
convenience and as a way to provide backward compatibility to previous
SBML Level/Version specifications.  (The removal in SBML Level&nbsp;2
Version&nbsp;3 of the enumeration C<UnitKind> was also accompanied by
the redefinition of the data type C<UnitSId> to include the previous @c
UnitKind values as reserved symbols in the C<UnitSId> space.  This
change has no net effect on permissible models, their representation or
their syntax.  The purpose of the change in the SBML specification was
simply to clean up an inconsistency about the contexts in which these
values were usable.)  The C<UnitKind_t> enumeration in libSBML has a 
small number of differences compared to the SBML specifications:
@endif@if java In SBML Level&nbsp;2 Versions before
Version&nbsp;3, there existed an enumeration of units called @c
UnitKind.  In Version&nbsp;3, this enumeration was removed and the
identifier class C<UnitSId> redefined to include the previous @c
UnitKind values as reserved symbols.  This change has no net effect on
permissible models, their representation or their syntax.  The purpose
of the change in the SBML specification was simply to clean up an
inconsistency about the contexts in which these values were usable.
However, LibSBML maintains UnitKind in the form of of a set of static
integer constants whose names begin with the characters
C<UNIT_KIND_>.  These constants are defined in the class
<code><a href="libsbmlConstants.java">libsbmlConstants</a></code> This
enumeration in libSBML has a small number of differences compared to the
SBML specifications: @endif

=over


=item

The alternate spelling C<"meter"> is included in addition to the
official SI spelling C<"metre">.

=item

The alternate spelling C<"liter"> is included in addition to the
official SI spelling C<"litre">.

=item

The unit C<"Celsius"> is included because of its presence in
specifications of SBML prior to SBML Level&nbsp;2 Version&nbsp;3.

=back


@if clike The table below lists the symbols defined in the
C<UnitKind_t> enumeration, and their
meanings. @endif@if java The table below lists the unit
constants defined in libSBML, and their meanings. @endif
@htmlinclude libsbml-unitkind-table.html
<!-- leave this next break as-is to work around some doxygen bug -->


=over

=back

=head2 ListOfUnits

LibSBML implementation of SBML's ListOfUnits construct.
The various ListOf___ classes in SBML are merely containers used for
organizing the main components of an SBML model.  All are derived from
the abstract class SBase, and inherit the various attributes and
subelements of SBase, such as "metaid" as and "annotation".  The
ListOf___ classes do not add any attributes of their own.
ListOfUnits is entirely contained within UnitDefinition.


=over

=item Unit::Unit

Creates a new Unit, optionally with specific values of C<kind>, @p
exponent, C<scale> and C<multipler>.
@if clike If no arguments are passed to this constructor,
the value of C<kind> defaults to C<UNIT_KIND_INVALID>.  Callers must
reset the value to something appropriate using the Unit::setKind()
method.  The use of arguments to this constructor is functionally
equivalent to the following: @endif@if java If no
arguments are passed to this constructor, the value of C<kind>
defaults to C<UNIT_KIND_INVALID>.  Callers must reset the value to
something appropriate using the method Unit::setKind(int kind). 
The use of arguments to this constructor is functionally
equivalent to the following: @endif
C<ode>
Unit u = new Unit();
u.setKind(kind);
u.setExponent(exponent);
u.setScale(scale);
u.setMultiplier(multipler);
@endcode

Readers are urged to read the description of the Unit class (both the
beginning of this page, and in the SBML specification documents) for
more information about the meaning of the arguments to this
constructor.

@if clike @param kind a value from the <a class="el"
href="#UnitKind_t">UnitKind_t</a> enumeration naming the base unit
serving as the basis of this particular unit
definition @endif@if java @param kind a value from the
set of static integer constants having names beginning with the
characters C<UNIT_KIND_> in <code><a
href="libsbmlConstants.java">libsbmlConstants</a></code> @endif
@param exponent an integer, the "exponent" attribute of the unit
definition 

@param scale an integer, the "scale" attribute of the unit definition
@param multiplier a double, the "multiplier" attribute of the unit
definition 

@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item Unit::Unit

Creates a new Unit of a specific C<kind> (given as a string), and
optionally with C<exponent>, C<scale> and C<multipler>.
@if clike This method accepts a base unit name as a
string, and internally converts it to a value from the <a class="el"
href="#UnitKind_t">UnitKind_t</a> enumeration.  If the string passed
as the value of C<kind> is not recognized as a valid unit name, this
method sets the value to C<UNIT_KIND_INVALID>.  The following table
lists the valid unit kind names: @endif@if java This
method accepts a unit kind name as a string, and internally converts
it to the appropriate C<UNIT_KIND_> constants from <code><a
href="libsbmlConstants.java">libsbmlConstants</a></code>.  If the
string passed as the value of C<kind> is not recognized as a valid
unit name, this method sets the value to C<UNIT_KIND_INVALID>.  The
following table lists the valid unit kind names: @endif
@htmlinclude libsbml-base-units.html
In addition to the strings above, the string C<Celsius> is
accepted for models in SBML Level&nbsp;2 Version&nbsp;1 format.
Readers are urged to read the description of the Unit class (both the
beginning of this page, and in the SBML specification documents) for
more information about the meaning of the arguments to this
constructor.

@param kind a string whose value is a valid unit name
@param exponent an integer, the "exponent" attribute of the unit
definition 

@param scale an integer, the "scale" attribute of the unit definition
@param multiplier a double, the "multiplier" attribute of the unit
definition 

@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item Unit::Unit

Creates a new Unit using the given SBML C<level> and C<version>
values and optionally a set of XMLNamespaces.
@param level an unsigned int, the SBML Level to assign to this Unit
@param version an unsigned int, the SBML Version to assign to this
Unit

@param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
assign to this Unit
@note Once a Unit has been added to an SBMLDocument, the C<level>,
C<version> and C<xmlns> namespaces for the document I<override> those used
to create the Unit.  Despite this, the ability to supply the values
at creation time is an important aid to creating valid SBML.  Knowledge of
the intented SBML Level and Version determine whether it is valid to
assign a particular value to an attribute, or whether it is valid to add
an object to an existing SBMLDocument.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.

@deprecated libSBML internal


=item Unit::Unit

Copy constructor; creates a copy of this Unit.


=item Unit::accept

Accepts the given SBMLVisitor for this instance of Unit.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>, which indicates
whether the Visitor would like to visit the next Unit in the list
of units within which this Unit is embedded (i.e., in the ListOfUnits
located in the enclosing UnitDefinition instance).


=item Unit::clone

Creates and returns a deep copy of this Unit.
Returns a (deep) copy of this Unit.


=item Unit::initDefaults

Initializes the attributes of this Unit (except for "kind") to their
defaults values.
The default values are as follows:
@li exponent   = 1
@li scale      = 0
@li multiplier = 1.0
The "kind" attribute is left unchanged.


=item Unit::getKind

Returns the "kind" of Unit this is.
Returns the value of the "kind" attribute of this Unit as a value from
the <a class="el" href="#UnitKind_t">UnitKind_t</a> enumeration


=item Unit::getExponent

Returns the value of the "exponent" attribute of this unit.
Returns the "exponent" value of this Unit, as an integer


=item Unit::getScale

Returns the value of the "scale" attribute of this unit.
Returns the "scale" value of this Unit, as an integer.


=item Unit::getMultiplier

Returns the value of the "multiplier" attribute of this Unit.
Returns the "multiplier" value of this Unit, as a double


=item Unit::getOffset

Returns the value of the "offset" attribute of this Unit.
@warning The "offset" attribute is only available in SBML Level&nbsp;2
Version&nbsp;1.  This attribute is not present in SBML Level&nbsp;2
Version&nbsp;2 or above.  When producing SBML models using these later
specifications, modelers and software tools need to account for units
with offsets explicitly.  The SBML specification document offers a
number of suggestions for how to achieve this.  LibSBML methods such
as this one related to "offset" are retained for compatibility with
earlier versions of SBML Level&nbsp;2, but their use is strongly
discouraged.

Returns the "offset" value of this Unit, as a double


=item Unit::isAmpere

Predicate for testing whether this Unit is of the kind C<ampere>.
Returns C<true> if the kind of this Unit is C<ampere>, C<false>
otherwise. 



=item Unit::isBecquerel

Predicate for testing whether this Unit is of the kind C<becquerel>
Returns C<true> if the kind of this Unit is C<becquerel>, C<false>
otherwise. 



=item Unit::isCandela

Predicate for testing whether this Unit is of the kind C<candela>
Returns C<true> if the kind of this Unit is C<candela>, C<false>
otherwise. 



=item Unit::isCelsius

Predicate for testing whether this Unit is of the kind C<Celsius>
Returns C<true> if the kind of this Unit is C<Celsius>, C<false>
otherwise. 

@warning The predefined unit C<Celsius> was removed from the list of
predefined units in SBML Level&nbsp;2 Version&nbsp;2 at the same time
that the "offset" attribute was removed from Unit definitions.
LibSBML methods such as this one related to C<Celsius> are retained in
order to support SBML Level&nbsp;2 Version&nbsp;1, but their use is
strongly discouraged.


=item Unit::isCoulomb

Predicate for testing whether this Unit is of the kind C<coulomb>
Returns C<true> if the kind of this Unit is C<coulomb>, C<false>
otherwise. 



=item Unit::isDimensionless

Predicate for testing whether this Unit is of the kind @c
dimensionless

Returns C<true> if the kind of this Unit is C<dimensionless>, C<false>
otherwise.



=item Unit::isFarad

Predicate for testing whether this Unit is of the kind C<farad>
Returns C<true> if the kind of this Unit is C<farad>, C<false>
otherwise. 



=item Unit::isGram

Predicate for testing whether this Unit is of the kind C<gram>
Returns C<true> if the kind of this Unit is C<gram>, C<false>
otherwise. 



=item Unit::isGray

Predicate for testing whether this Unit is of the kind C<gray>
Returns C<true> if the kind of this Unit is C<gray>, C<false>
otherwise. 



=item Unit::isHenry

Predicate for testing whether this Unit is of the kind C<henry>
Returns C<true> if the kind of this Unit is C<henry>, C<false>
otherwise. 



=item Unit::isHertz

Predicate for testing whether this Unit is of the kind C<hertz>
Returns C<true> if the kind of this Unit is C<hertz>, C<false>
otherwise. 



=item Unit::isItem

Predicate for testing whether this Unit is of the kind C<item>
Returns C<true> if the kind of this Unit is C<item>, C<false>
otherwise. 



=item Unit::isJoule

Predicate for testing whether this Unit is of the kind C<joule>
Returns C<true> if the kind of this Unit is C<joule>, C<false>
otherwise. 



=item Unit::isKatal

Predicate for testing whether this Unit is of the kind C<katal>
Returns C<true> if the kind of this Unit is C<katal>, C<false>
otherwise. 



=item Unit::isKelvin

Predicate for testing whether this Unit is of the kind C<kelvin>
Returns C<true> if the kind of this Unit is C<kelvin>, C<false>
otherwise. 



=item Unit::isKilogram

Predicate for testing whether this Unit is of the kind C<kilogram>
Returns C<true> if the kind of this Unit is C<kilogram>, C<false>
otherwise. 



=item Unit::isLitre

Predicate for testing whether this Unit is of the kind C<litre>
Returns C<true> if the kind of this Unit is C<litre> or 'liter', @c
false 
otherwise.


=item Unit::isLumen

Predicate for testing whether this Unit is of the kind C<lumen>
Returns C<true> if the kind of this Unit is C<lumen>, C<false>
otherwise. 



=item Unit::isLux

Predicate for testing whether this Unit is of the kind C<lux>
Returns C<true> if the kind of this Unit is C<lux>, C<false>
otherwise. 



=item Unit::isMetre

Predicate for testing whether this Unit is of the kind C<metre>
Returns C<true> if the kind of this Unit is C<metre> or 'meter', @c
false 
otherwise.


=item Unit::isMole

Predicate for testing whether this Unit is of the kind C<mole>
Returns C<true> if the kind of this Unit is C<mole>, C<false>
otherwise. 



=item Unit::isNewton

Predicate for testing whether this Unit is of the kind C<newton>
Returns C<true> if the kind of this Unit is C<newton>, C<false>
otherwise. 



=item Unit::isOhm

Predicate for testing whether this Unit is of the kind C<ohm>
Returns C<true> if the kind of this Unit is C<ohm>, C<false>
otherwise. 



=item Unit::isPascal

Predicate for testing whether this Unit is of the kind C<pascal>
Returns C<true> if the kind of this Unit is C<pascal>, C<false>
otherwise. 



=item Unit::isRadian

Predicate for testing whether this Unit is of the kind C<radian>
Returns C<true> if the kind of this Unit is C<radian>, C<false>
otherwise. 



=item Unit::isSecond

Predicate for testing whether this Unit is of the kind C<second>
Returns C<true> if the kind of this Unit is C<second>, C<false>
otherwise. 



=item Unit::isSiemens

Predicate for testing whether this Unit is of the kind C<siemens>
Returns C<true> if the kind of this Unit is C<siemens>, C<false>
otherwise. 



=item Unit::isSievert

Predicate for testing whether this Unit is of the kind C<sievert>
Returns C<true> if the kind of this Unit is C<sievert>, C<false>
otherwise. 



=item Unit::isSteradian

Predicate for testing whether this Unit is of the kind C<steradian>
Returns C<true> if the kind of this Unit is C<steradian>, C<false>
otherwise. 



=item Unit::isTesla

Predicate for testing whether this Unit is of the kind C<tesla>
Returns C<true> if the kind of this Unit is C<tesla>, C<false>
otherwise. 



=item Unit::isVolt

Predicate for testing whether this Unit is of the kind C<volt>
Returns C<true> if the kind of this Unit is C<volt>, C<false>
otherwise. 



=item Unit::isWatt

Predicate for testing whether this Unit is of the kind C<watt>
Returns C<true> if the kind of this Unit is C<watt>, C<false>
otherwise. 



=item Unit::isWeber

Predicate for testing whether this Unit is of the kind C<weber>
Returns C<true> if the kind of this Unit is C<weber>, C<false>
otherwise. 



=item Unit::isSetKind

Predicate to test whether the "kind" attribute of this Unit has been set.
Returns C<true> if the "kind" attribute of this Unit has been set, @c
false otherwise.


=item Unit::setKind

Sets the "kind" attribute value of this Unit.
@param kind a value from the <a class="el"
href="#UnitKind_t">UnitKind_t</a> enumeration


=item Unit::setExponent

Sets the "exponent" attribute value of this Unit.
@param value the integer to which the attribute "exponent" should be set


=item Unit::setScale

Sets the "scale" attribute value of this Unit.
@param value the integer to which the attribute "scale" should be set


=item Unit::setMultiplier

Sets the "multipler" attribute value of this Unit.
@param value the floating-point value to which the attribute
"multiplier" should be set


=item Unit::setOffset

Sets the "offset" attribute value of this Unit.
@param value the float-point value to which the attribute "offset"
should set
@warning The "offset" attribute is only available in SBML Level&nbsp;2
Version&nbsp;1.  This attribute is not present in SBML Level&nbsp;2
Version&nbsp;2 or above.  When producing SBML models using these later
specifications, modelers and software tools need to account for units
with offsets explicitly.  The SBML specification document offers a
number of suggestions for how to achieve this.  LibSBML methods such
as this one related to "offset" are retained for compatibility with
earlier versions of SBML Level&nbsp;2, but their use is strongly
discouraged.



=item Unit::getTypeCode

Returns the libSBML type code of this object instance.
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for this object, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item Unit::getElementName

Returns the XML element name of this object, which for Unit, is
always C<"unit">.
Returns the name of this element, i.e., C<"unit">. 


=item Unit::isBuiltIn

Predicate to test whether a given string is the name of a
predefined SBML unit.
@param name a string to be tested against the predefined unit names
@param level the Level of SBML for which the determination should be
made.  This is necessary because there are a few small differences
in allowed units between SBML Level&nbsp;1 and Level&nbsp;2.
Returns C<true> if C<name> is one of the five SBML predefined unit
identifiers (C<"substance">, C<"volume">, C<"area">, C<"length"> or @c
"time"), C<false> otherwise.
@note The predefined unit identifiers C<"length"> and C<"area"> were
added in Level&nbsp;2 Version&nbsp;1


=item Unit::isUnitKind

Predicate to test whether a given string is the name of a valid
base unit in SBML (such as C<"gram"> or C<"mole">).
This method exists because prior to SBML Level&nbsp;2 Version&nbsp;3,
an enumeration called C<UnitKind> was defined by SBML.  This enumeration
was removed in SBML Level&nbsp;2 Version&nbsp;3 and its values were
folded into the space of values of a type called C<UnitSId>.  This method
therefore has less significance in SBML Level&nbsp;2 Version&nbsp;3
and Level&nbsp;2 Version&nbsp;4, but remains for backward
compatibility and support for reading models in older Versions of
Level&nbsp;2.

@param name a string to be tested
@param level an unsigned int representing the SBML specification
Level 

@param version an unsigned int representing the SBML specification
Version

Returns C<true> if name is a valid UnitKind, C<false> otherwise
@note The allowed unit names differ between SBML Levels&nbsp;1
and&nbsp;2 and again slightly between Level&nbsp;2 Versions&nbsp;1
and&nbsp;2.



=item Unit::areIdentical

Predicate returning C<true> or C<false> depending on whether two
Unit objects are identical.
Two Unit objects are considered to be I<identical> if they match in
all attributes.  (Contrast this to the method areEquivalent(), which
compares Unit objects only with respect to certain attributes.)
@param unit1 the first Unit object to compare
@param unit2 the second Unit object to compare
Returns C<true> if all the attributes of unit1 are identical
to the attributes of unit2, C<false> otherwise.
@see areEquivalent()


=item Unit::areEquivalent

Predicate returning C<true> or C<false> depending on whether 
Unit objects are equivalent.
Two Unit objects are considered to be I<equivalent> if their "kind"
and "exponent" attributes are equal.  (Contrast this to the method
Unit::areIdentical(), which compares Unit objects with respect to all
attributes, not just the kind and exponent.)
@param unit1 the first Unit object to compare
@param unit2 the second Unit object to compare
Returns C<true> if the "kind" and "exponent" attributes of unit1 are
identical to the kind and exponent attributes of unit2, C<false>
otherwise.

@see areIdentical()


=item Unit::removeScale

Manipulates the attributes of the Unit to express the unit with the 
value of the scale attribute reduced to zero.
For example, 1 millimetre can be expressed as a Unit with kind=@c
"metre" multiplier=C<"1"> scale=C<"-3"> exponent=C<"1">. It can also be
expressed as a Unit with kind=C<"metre">
multiplier=C<"0.001"> scale=C<"0"> exponent=C<"1">.
@param unit the Unit object to manipulate.


=item Unit::merge

Merges two Unit objects with the same "kind" attribute value into a
single Unit.
For example, the following,
C<ode>
<unit kind="metre" exponent="2"/>
<unit kind="metre" exponent="1"/>
@endcode
would be merged to become
C<ode>
<unit kind="metre" exponent="3"/>
@endcode

@param unit1 the first Unit object; the result of the operation is
left as a new version of this unit, modified in-place.
@param unit2 the second Unit object to merge with the first


=item Unit::convertToSI

Returns a UnitDefinition object which contains the argument Unit
converted to the appropriate SI unit.
@param unit the Unit object to convert to SI
Returns a UnitDefinition object containing the SI unit.


=item Unit::readAttributes

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.
@deprecated libSBML internal


=item Unit::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Unit::isL1UnitKind

Predicate to test whether a given string is the name of a valid
base unit in SBML Level 1 (such as C<"gram"> or C<"mole">)
@param name a string to be tested
Returns C<true> if name is a valid UnitKind, C<false> otherwise
@deprecated libSBML internal


=item Unit::isL2V1UnitKind

Predicate to test whether a given string is the name of a valid base
unit in SBML Level&nbsp;2 Version&nbsp;1 (such as C<"gram"> or @c
"mole")

@param name a string to be tested
Returns C<true> if name is a valid UnitKind, C<false> otherwise
@deprecated libSBML internal


=item Unit::isL2UnitKind

Predicate to test whether a given string is the name of a valid base
unit in SBML Level&nbsp;2 Version&nbsp;2, 3 or 4 (such as C<"gram"> or @c
"mole")

@param name a string to be tested
Returns C<true> if name is a valid UnitKind, C<false> otherwise
@deprecated libSBML internal


=item Unit::isL2UnitKind

Predicate to test whether a given string is the name of a valid base
unit in SBML Level&nbsp;2 Version&nbsp;2, 3 or 4 (such as C<"gram"> or @c
"mole")

@param name a string to be tested
Returns C<true> if name is a valid UnitKind, C<false> otherwise
@deprecated libSBML internal


=item Unit::isL2UnitKind

Predicate to test whether a given string is the name of a valid base
unit in SBML Level&nbsp;2 Version&nbsp;2, 3 or 4 (such as C<"gram"> or @c
"mole")

@param name a string to be tested
Returns C<true> if name is a valid UnitKind, C<false> otherwise
@deprecated libSBML internal


=item Unit::isL2UnitKind

Predicate to test whether a given string is the name of a valid base
unit in SBML Level&nbsp;2 Version&nbsp;2, 3 or 4 (such as C<"gram"> or @c
"mole")

@param name a string to be tested
Returns C<true> if name is a valid UnitKind, C<false> otherwise
@deprecated libSBML internal


=item Unit::isL2UnitKind

Predicate to test whether a given string is the name of a valid base
unit in SBML Level&nbsp;2 Version&nbsp;2, 3 or 4 (such as C<"gram"> or @c
"mole")

@param name a string to be tested
Returns C<true> if name is a valid UnitKind, C<false> otherwise
@deprecated libSBML internal


=item Unit::isL2UnitKind

Predicate to test whether a given string is the name of a valid base
unit in SBML Level&nbsp;2 Version&nbsp;2, 3 or 4 (such as C<"gram"> or @c
"mole")

@param name a string to be tested
Returns C<true> if name is a valid UnitKind, C<false> otherwise
@deprecated libSBML internal


=item ListOfUnits::clone

Creates and returns a deep copy of this ListOfUnits.
Returns a (deep) copy of this ListOfUnits.


=item ListOfUnits::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for this object, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item ListOfUnits::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., Unit objects, if the list is non-empty).
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for the objects contained in this ListOf
instance, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item ListOfUnits::getElementName

Returns the XML element name of this object.
For ListOfUnits, the XML element name is C<"listOfUnits">.
Returns the name of this element, i.e., C<"listOfUnits">.


=item ListOfUnits::get

Get a Unit from the ListOfUnits.
@param n the index number of the Unit to get.
Returns the nth Unit in this ListOfUnits.
@see size()


=item ListOfUnits::get

Get a Unit from the ListOfUnits.
@param n the index number of the Unit to get.
Returns the nth Unit in this ListOfUnits.
@see size()


=item ListOfUnits::remove

Removes the nth item from this ListOfUnits items and returns a pointer to
it.

The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove
@see size()


=item ListOfUnits::getElementPosition

Get the ordinal position of this element in the containing object
(which in this case is the Model object).
Returns the ordinal position of the element with respect to its
siblings, or C<-1> (default) to indicate the position is not significant.
@deprecated libSBML internal


=item ListOfUnits::createObject

Create a ListOfUnits object corresponding to the next token
in the XML input stream.
Returns the SBML object corresponding to next XMLToken in the
XMLInputStream, or C<NULL> if the token was not recognized.
@deprecated libSBML internal


=back

=head2 UnitDefinition

LibSBML implementation of SBML's UnitDefinition construct.
Units of measurement may be supplied in a number of contexts in an SBML
model.  The units of the following mathematical entities can be
specified explicitly: the size of a compartment, the initial amount of a
species, and the units of constant and variable parameter values.  The
overall units of any mathematical formula appearing in SBML are those
that arise naturally from the components and mathematical expressions
comprising the formula, or in other words, the units obtained by doing
dimensional analysis on the formula.
Rather than requiring a complete unit definition on every construct,
SBML provides a facility for defining units that can be referenced
throughout a model.  In addition, every kind of SBML mathematical
entity has units assigned to it from a set of predefined defaults (listed
below); by redefining these predefined default units, it is possible to
change the units used throughout a model in a simple and consistent
manner.

The SBML unit definition facility uses two classes of objects,
UnitDefinition and Unit.  The approach to defining units in SBML is
compositional; for example, <em>meter second<sup> &ndash;2</sup></em> is
constructed by combining a Unit object representing <em>meter</em> with
another Unit object representing <em>second<sup> &ndash;2</sup></em>.
The combination is wrapped inside a UnitDefinition, which provides for
assigning an identifier and optional name to the combination.  The
identifier can then be referenced from elsewhere in a model.  Thus, the
UnitDefinition class is the container, and Unit instances are placed
inside UnitDefinition instances.
@section unitdef-summary Summary of the UnitDefinition construct
UnitDefinition in SBML Level&nbsp;2 has two attributes and one
subelement.  The two attributes are "id" and "name", and the subelement
is ListOfUnits.
The required attribute "id" and optional attribute "name" are both
strings.  The "id" attribute is used to give the defined unit a unique
identifier by which other parts of an SBML model definition can refer to
it.  The "name" attribute is intended to be used for giving the unit
definition an optional human-readable name.
There are two important restrictions about the use of unit definition
"id" values in SBML Level&nbsp;2 Versions&nbsp;3&ndash;4:

=over


=item

The "id" of a UnitDefinition must I<not> contain a value from the
list of reserved base unit names (i.e., the strings C<gram>, C<liter>,
etc.; see the definition of Unit for the complete list).  This
constraint simply prevents the redefinition of the base units.

=item

There is a set of reserved identifiers for the predefined
units in SBML; these identifiers are C<substance>, C<volume>, C<area>,
C<length>, and C<time>.  Using one of these values for the attribute
"id" of a UnitDefinition has the effect of redefining the model-wide
default units for the corresponding quantities.  The list of
predefined units is given in the table below:
@htmlinclude libsbml-predefined-units.html
Also, two limitations are imposed on redefining the predefined
unit C<substance>, C<volume>, C<area>, C<length>, and C<time>:
(1) The UnitDefinition of a predefined SBML unit can only
contain a single Unit object within it.
(2) The value of the "kind" attribute in 
a Unit instance must be drawn from one of the values
in the second column of the table above.

=back


A UnitDefinition must contain exactly one ListOfUnits, and this list
must contain one or more Unit definitions; see the definitions of these
other object classes for more information about them.  The following
example illustrates a complete unit definition (when written in XML)
when they all the pieces are combined together.  This defines "mmls"
to be millimoles per litre per second.
C<ode>
<listOfUnitDefinitions>
<unitDefinition id="mmls">
<listOfUnits>
<unit kind="mole"   scale="-3"/>
<unit kind="litre"  exponent="-1"/>
<unit kind="second" exponent="-1"/>
</listOfUnits>
</unitDefinition>
</listOfUnitDefinitions>
@endcode
@section sbml-units-limits Further comments about SBML's unit definition system
The vast majority of modeling situations requiring new SBML unit
definitions involve simple multiplicative combinations of base units and
factors.  An example of this might be <em>moles per litre per
second</em>.  What distinguishes these sorts of simpler unit definitions
from more complex ones is that they may be expressed without the use of
an additive offset from a zero point.  The use of offsets complicates
all unit definition systems, yet in the domain of SBML the real-life
cases requiring offsets are few (and in fact, to the best of our
knowledge, only involve temperature).  Consequently, the SBML unit
system has been consciously designed in a way that attempts to simplify
implementation of unit support for the most common cases in systems
biology.

As of SBML Level&nbsp;2 Version&nbsp;2, Unit no longer has the
attribute called "offset" introduced in SBML Level&nbsp;2
Version&nbsp;1.  It turned out that the general case involving units
with offsets was incorrectly defined, and few (if any) developers even
attempted to support offset-based units in their software.  In the
development of Level&nbsp;2 Version&nbsp;2, a consensus among SBML
developers emerged that a fully generalized unit scheme is I<so>
confusing and complicated that it actually I<impedes> interoperability.
SBML Level&nbsp;2 Version&nbsp;2, Version&nbsp;3 and Version&nbsp;4 acknowledge this
reality by reducing and simplifying the unit system, specifically by
removing the "offset" attribute on Unit and C<Celsius> as a pre-defined
unit.

The following guidelines suggest methods for handling units that do
require the use of zero offsets for their definitions:

=over


=item

<em>Handling Celsius</em>.  A model in which certain quantities are
temperatures measured in degrees Celsius can be converted
straightforwardly to a model in which those temperatures are in
kelvin.  A software tool could do this by performing a straightforward
substitution using the following relationship: T<sub> kelvin</sub> =
T<sub> Celsius</sub> + 273.15.  In every mathematical formula of the
model where a quantity (call it I<x>) in degrees Celsius appears,
replace I<x> with x<sub> k</sub>+ 273.15, where x<sub> k</sub> is now
in kelvin.  An alternative approach would be to use a
FunctionDefinition to define a function encapsulating this
relationship above and then using that in the rest of the model as
needed.  Since Celsius is a commonly-used unit, software tools could
help users by providing users with the ability to express temperatures
in Celsius in the tools' interfaces, and making substitutions
automatically when writing out the SBML.

=item

<em>Other units requiring offsets</em>.  One approach to handling
other kinds of units is to use a FunctionDefinition to define a function
encapsulating the necessary mathematical relationship, then
substituting a call to this function wherever the original quantity
appeared in the model.  For example, here is a possible definition for
converting Fahrenheit to Celsius degrees:
C<ode>
<functionDefinition id="Fahrenheit_to_kelvin">
<math xmlns="http://www.w3.org/1998/Math/MathML">
<lambda>
<bvar><ci> temp_in_fahrenheit </ci></bvar>
<apply>
<divide/>
<apply>
<plus/>
<ci> temp_in_fahrenheit </ci>
<cn> 459.67 </cn>
</apply>
<cn> 1.8 </cn>
</apply>
</lambda>
</math>
</functionDefinition>
@endcode


=item

An alternative approach not requiring the use of function definitions
is to use an AssignmentRule for each variable in Fahrenheit units.
The AssignmentRule could compute the conversion from Fahrenheit to
(say) kelvin, assign its value to a variable (in Kelvin units), and
then that variable could be used elsewhere in the model.

=item

Still another approach is to rewrite the mathematical formulas of a
model to directly incorporate the conversion formula wherever the
original quantity appeared.

=back


Please consult the SBML specifications for more information about this
and other issues involving units.
<!-- leave this next break as-is to work around some doxygen bug -->


=over

=back

=head2 ListOfUnitDefinitions

LibSBML implementation of SBML's ListOfUnitDefinitions construct.
The various ListOf___ classes in SBML are merely containers used for
organizing the main components of an SBML model.  All are derived from
the abstract class SBase, and inherit the various attributes and
subelements of SBase, such as "metaid" as and "annotation".  The
ListOf___ classes do not add any attributes of their own.
The relationship between the lists and the rest of an SBML model is
illustrated by the following (for SBML Level&nbsp;2 Version&nbsp;4):
@image html listof-illustration.jpg "ListOf___ elements in an SBML Model"
@image latex listof-illustration.jpg "ListOf___ elements in an SBML Model"
Readers may wonder about the motivations for using the ListOf___
containers.  A simpler approach in XML might be to place the components
all directly at the top level of the model definition.  We chose instead
to group them within XML elements named after ListOf<em>Classname</em>,
in part because we believe this helps organize the components and makes
visual reading of models in XML easier.  More importantly, the fact that
the container classes are derived from SBase means that software tools
can add information about the lists themselves into each list
container's "annotation".
@see ListOfFunctionDefinitions
@see ListOfUnitDefinitions
@see ListOfCompartmentTypes
@see ListOfSpeciesTypes
@see ListOfCompartments
@see ListOfSpecies
@see ListOfParameters
@see ListOfInitialAssignments
@see ListOfRules
@see ListOfConstraints
@see ListOfReactions
@see ListOfEvents


=over

=item UnitDefinition::UnitDefinition

Creates a new UnitDefinition instance, optionally with specific values
of C<id> and C<name>.
The permitted values of the identifier C<id> I<exclude> the
predefined base units in SBML and two spelling variants C<"meter"> and
C<"liter">.  More specifically, the following is the set of base unit
names which are I<excluded> from being used as a value of C<id>:
@htmlinclude libsbml-base-units.html
In addition, there is a set of reserved identifiers for the predefined
default units in SBML.  These identifiers are C<substance>, C<volume>,
C<area>, C<length>, and C<time>.  Using one of these values for the
attribute C<id> of a UnitDefinition has the special meaning of @em
redefining the model-wide default units for the corresponding
quantities.  The list of reserved unit names is given in the table below:
@htmlinclude libsbml-predefined-units.html
Finally, note that SBML imposes two limitations on redefining the
predefined units listed above:

=over


=item

The UnitDefinition of a predefined SBML unit can only
contain a single Unit object within it.

=item

The value of the "kind" attribute in 
a Unit instance must be drawn from one of the values
in the second column of the table above.

=back


@param id the identifier to assign to the new unit definition.
@param name an optional name to assign to the new unit definition.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item UnitDefinition::UnitDefinition

Creates a new UnitDefinition using the given SBML C<level> and C<version>
values and optionally a set of XMLNamespaces.
@param level an unsigned int, the SBML Level to assign to this UnitDefinition
@param version an unsigned int, the SBML Version to assign to this
UnitDefinition

@param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
assign to this UnitDefinition
@note Once a UnitDefinition has been added to an SBMLDocument, the C<level>,
C<version> and C<xmlns> namespaces for the document I<override> those used
to create the UnitDefinition.  Despite this, the ability to supply the values
at creation time is an important aid to creating valid SBML.  Knowledge of
the intented SBML Level and Version determine whether it is valid to
assign a particular value to an attribute, or whether it is valid to add
an object to an existing SBMLDocument.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.

@deprecated libSBML internal


=item UnitDefinition::UnitDefinition

Copy constructor; creates a copy of this UnitDefinition.


=item UnitDefinition::accept

Accepts the given SBMLVisitor for this instance of UnitDefinition.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>, which indicates
whether the Visitor would like to visit the next UnitDefinition in the
list of units within which this UnitDefinition is embedded (i.e., in
the ListOfUnitDefinitions located in the enclosing Model instance).


=item UnitDefinition::clone

Creates and returns a deep copy of this UnitDefinition.
Returns a (deep) copy of this UnitDefinition.


=item UnitDefinition::isVariantOfArea

Convenience function for testing if a given unit definition is a
variant of the predefined unit identifier C<"area">.
Returns C<true> if this UnitDefinition is a variant of the predefined
unit C<area>, meaning square metres with only abritrary variations
in scale or multiplier values; C<false> otherwise.


=item UnitDefinition::isVariantOfLength

Convenience function for testing if a given unit definition is a
variant of the predefined unit identifier C<"length">.
Returns C<true> if this UnitDefinition is a variant of the predefined
unit C<length>, meaning metres with only abritrary variations in scale
or multiplier values; C<false> otherwise.


=item UnitDefinition::isVariantOfSubstance

Convenience function for testing if a given unit definition is a
variant of the predefined unit identifier C<"substance">.
Returns C<true> if this UnitDefinition is a variant of the predefined
unit C<substance>, meaning moles or items (and grams or kilograms from
SBML Level&nbsp;2 Version&nbsp;2 onwards) with only abritrary variations
in scale or multiplier values; C<false> otherwise.


=item UnitDefinition::isVariantOfTime

Convenience function for testing if a given unit definition is a
variant of the predefined unit identifier C<"time">.
Returns C<true> if this UnitDefinition is a variant of the predefined
unit C<time>, meaning seconds with only abritrary variations in scale or
multiplier values; C<false> otherwise.


=item UnitDefinition::isVariantOfVolume

Convenience function for testing if a given unit definition is a
variant of the predefined unit identifier C<"volume">.
Returns C<true> if this UnitDefinition is a variant of the predefined
unit C<volume>, meaning litre or cubic metre with only abritrary
variations in scale or multiplier values; C<false> otherwise.


=item UnitDefinition::isVariantOfDimensionless

Convenience function for testing if a given unit definition is a
variant of the unit C<"dimensionless">.
Returns C<true> if this UnitDefinition is a variant of @c
dimensionless, meaning dimensionless with only abritrary variations in
scale or multiplier values; C<false> otherwise.


=item UnitDefinition::isVariantOfMass

Convenience function for testing if a given unit definition is a
variant of the predefined unit identifier C<"mass">.
Returns C<true> if this UnitDefinition is a variant of mass units,
meaning gram or kilogram with only abritrary variations in scale or
multiplier values; C<false> otherwise.


=item UnitDefinition::isVariantOfSubstancePerTime

Convenience function for testing if a given unit definition is a
variant of the predefined unit C<"substance"> divided by the predefined
unit C<"time">.
Returns C<true> if this UnitDefinition is a variant of the predefined
unit C<substance> per predefined unit C<time>, meaning it contains two
units one of which is a variant of substance and the other is a
variant of time which an exponent of -1; C<false> otherwise.


=item UnitDefinition::addUnit

Adds a copy of the given Unit to this UnitDefinition.
@param u the Unit instance to add to this UnitDefinition.
@note This method should be used with some caution.  The fact that
this method I<copies> the object passed to it means that the caller
will be left holding a physically different object instance than the
one contained in this UnitDefinition.  Changes made to the original
object instance (such as resetting attribute values) will <em>not
affect the instance in the UnitDefinition</em>.  In addition, the
caller should make sure to free the original object if it is no longer
being used, or else a memory leak will result.  Please see
UnitDefinition::createUnit() for a method that does not lead to these
issues.

@see createUnit()


=item UnitDefinition::createUnit

Creates a new and empty Unit, adds it to this UnitDefinition's list of
units, and returns it.
Returns a newly constructed (and empty) Unit instance.
@note It is worth emphasizing that the attribute "kind" value of a
Unit is a required attribute for a valid Unit definition.  The
createUnit() method does not assign a valid kind to the constructed
unit (instead, it sets the "kind" to C<UNIT_KIND_INVALID>).  Callers
are cautioned to set the newly-constructed Unit's kind using
Unit::setKind() soon after calling this method.
@see addUnit()


=item UnitDefinition::getListOfUnits

Returns the list of Units for this UnitDefinition instance.
Returns the ListOfUnits value for this UnitDefinition.


=item UnitDefinition::getListOfUnits

Returns the list of Units for this UnitDefinition instance.
Returns the ListOfUnits value for this UnitDefinition.


=item UnitDefinition::getUnit

Returns a specific Unit instance belonging to this UnitDefinition.
@param n an integer, the index of the Unit to be returned.
Returns the nth Unit of this UnitDefinition
@see getNumUnits()


=item UnitDefinition::getUnit

Returns a specific Unit instance belonging to this UnitDefinition.
@param n an integer, the index of the Unit to be returned.
Returns the nth Unit of this UnitDefinition


=item UnitDefinition::getNumUnits

Returns the number of Unit objects contained within this
UnitDefinition.

Returns an integer representing the number of Units in this
UnitDefinition.



=item UnitDefinition::setSBMLDocument

Sets the parent SBMLDocument of this SBML object.
@param d the SBMLDocument to use
@deprecated libSBML internal


=item UnitDefinition::setParentSBMLObject

Sets the parent SBML object of this SBML object.
@param sb the SBML object to use
@deprecated libSBML internal


=item UnitDefinition::getTypeCode

Returns the libSBML type code for this object instance.
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for this object, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item UnitDefinition::getElementName

Returns the XML element name of this object, which for UnitDefinition,
is always C<"unitDefinition">.
Returns the name of this element, i.e., C<"unitDefinition">.


=item UnitDefinition::simplify

Simplifies the UnitDefinition so that any Unit objects occurring within
the ListOfUnits occurs only once.
For example, the following definition,
C<ode>
<unitDefinition>
<listOfUnits>
<unit kind="metre" exponent="1"/>
<unit kind="metre" exponent="2"/>
</listOfUnits>
<unitDefinition>
@endcode
will be simplified to 
C<ode>
<unitDefinition>
<listOfUnits>
<unit kind="metre" exponent="3"/>
</listOfUnits>
<unitDefinition>
@endcode

@param ud the UnitDefinition object to be simplified.


=item UnitDefinition::reorder

Orders alphabetically the Unit objects within the ListOfUnits of a
UnitDefinition.

@param ud the UnitDefinition object whose units are to be reordered.


=item UnitDefinition::convertToSI

Convert a given UnitDefinition into a new UnitDefinition object
that uses SI units.
@param ud the UnitDefinition object to convert to SI
Returns a new UnitDefinition object representing the results of the
conversion.



=item UnitDefinition::areIdentical

Predicate returning C<true> or C<false> depending on whether two
UnitDefinition objects are identical.
For the purposes of performing this comparison, two UnitDefinition
objects are considered identical when they contain identical lists of
Unit objects.  Pairs of Unit objects in the lists are in turn
considered identical if they satisfy the predicate
Unit::areIdentical().  The predicate compares every attribute of the
Unit objects.
@param ud1 the first UnitDefinition object to compare
@param ud2 the second UnitDefinition object to compare
Returns C<true> if all the Unit objects in ud1 are identical to the
Unit objects of ud2, C<false> otherwise.
@see areEquivalent()
@see Unit::areIdentical()


=item UnitDefinition::areEquivalent

Predicate returning C<true> or C<false> depending on whether two
UnitDefinition objects are equivalent.
For the purposes of performing this comparison, two UnitDefinition
objects are considered equivalent when they contain I<equivalent>
list of Unit objects.  Unit objects are in turn considered equivalent
if they satisfy the predicate Unit::areEquivalent().  The predicate
tests a subset of the objects's attributes.
@param ud1 the first UnitDefinition object to compare
@param ud2 the second UnitDefinition object to compare
Returns C<true> if all the Unit objects in ud1 are equivalent
to the Unit objects in ud2, C<false> otherwise.
@see areIdentical()
@see Unit::areEquivalent()


=item UnitDefinition::combine

Combines two UnitDefinition objects into a single UnitDefinition
object which expresses the product of the units of the two
UnitDefinition's.

@param ud1 the first UnitDefinition object 
@param ud2 the second UnitDefinition object
Returns a UnitDefinition which represents the product of the 
units of the two argument UnitDefinitions.


=item UnitDefinition::printUnits

Returns a string that expresses the unit definition
represented by this UnitDefinition object.
For example printUnits applied to
C<ode>
<unitDefinition>
<listOfUnits>
<unit kind="metre" exponent="1"/>
<unit kind="second" exponent="-2"/>
</listOfUnits>
<unitDefinition>
@endcode
will return the string C<"metre (exponent = 1, multiplier = 1, scale = 0) 
second (exponent = -2, multiplier = 1, scale = 0)"> or, if 
compact = true, the string C<"(1 metre)^1 (1 second)^-2">
This may be useful for printing unit information to
human users, or in debugging, or other situations.
@param ud the UnitDefinition object
@param compact boolean indicating whether the compact form
should be used (defaults to false)
Returns a string expressing the unit definition


=item UnitDefinition::writeElements

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.
@deprecated libSBML internal


=item UnitDefinition::createObject

Returns the SBML object corresponding to next XMLToken in the
XMLInputStream or NULL if the token was not recognized.
@deprecated libSBML internal


=item UnitDefinition::readAttributes

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.
@deprecated libSBML internal


=item UnitDefinition::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item UnitDefinition::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item ListOfUnitDefinitions::clone

Creates and returns a deep copy of this ListOfUnitDefinitions instance.
Returns a (deep) copy of this ListOfUnitDefinitions.


=item ListOfUnitDefinitions::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for this object, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item ListOfUnitDefinitions::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., UnitDefinition objects, if the list is non-empty).
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for the objects contained in this ListOf
instance, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item ListOfUnitDefinitions::getElementName

Returns the XML element name of this object.
For ListOfUnitDefinitions, the XML element name is @c
"listOfUnitDefinitions".

Returns the name of this element, i.e., C<"listOfUnitDefinitions">.


=item ListOfUnitDefinitions::get

Get a UnitDefinition from the ListOfUnitDefinitions.
@param n the index number of the UnitDefinition to get.
Returns the nth UnitDefinition in this ListOfUnitDefinitions.
@see size()


=item ListOfUnitDefinitions::get

Get a UnitDefinition from the ListOfUnitDefinitions.
@param n the index number of the UnitDefinition to get.
Returns the nth UnitDefinition in this ListOfUnitDefinitions.
@see size()


=item ListOfUnitDefinitions::get

Get a UnitDefinition from the ListOfUnitDefinitions
based on its identifier.
@param sid a string representing the identifier 
of the UnitDefinition to get.
Returns UnitDefinition in this ListOfUnitDefinitions
with the given id or NULL if no such
UnitDefinition exists.
@see get(unsigned int n)
@see size()


=item ListOfUnitDefinitions::get

Get a UnitDefinition from the ListOfUnitDefinitions
based on its identifier.
@param sid a string representing the identifier 
of the UnitDefinition to get.
Returns UnitDefinition in this ListOfUnitDefinitions
with the given id or NULL if no such
UnitDefinition exists.
@see get(unsigned int n)
@see size()


=item ListOfUnitDefinitions::remove

Removes the nth item from this ListOfUnitDefinitions items and returns a pointer to
it.

The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove
@see size()


=item ListOfUnitDefinitions::remove

Removes item in this ListOfUnitDefinitions items with the given identifier.
The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier C<sid>, then @c
NULL is returned.
@param sid the identifier of the item to remove
Returns the item removed.  As mentioned above, the caller owns the
returned item.


=item ListOfUnitDefinitions::getElementPosition

Get the ordinal position of this element in the containing object
(which in this case is the Model object).
The ordering of elements in the XML form of SBML is generally fixed
for most components in SBML.  So, for example, the
ListOfUnitDefinitions in a model is (in SBML Level&nbsp;2
Version&nbsp;4) the second ListOf___.  (However, it differs for
different Levels and Versions of SBML.)
Returns the ordinal position of the element with respect to its
siblings, or C<-1> (default) to indicate the position is not significant.
@deprecated libSBML internal


=item ListOfUnitDefinitions::createObject

Returns the SBML object corresponding to next XMLToken in the
XMLInputStream or NULL if the token was not recognized.
@deprecated libSBML internal


=back

=head2 CompartmentType

LibSBML implementation of SBML's CompartmentType construct.
A <em>compartment type</em> in SBML is a grouping construct used to
establish a relationship between multiple Compartment objects.
In SBML Level 2 Versions 2, 3 and 4, a compartment type only has an
identity, and this identity can only be used to indicate that particular
compartments belong to this type.  This may be useful for conveying a
modeling intention, such as when a model contains many similar
compartments, either by their biological function or the reactions they
carry.  Without a compartment type construct, it would be impossible in
the language of SBML to indicate that all of the compartments share an
underlying conceptual relationship because each SBML compartment must be
given a unique and separate identity.  Compartment types have no
mathematical meaning in SBML Level 2&mdash;they have no effect on a
model's mathematical interpretation.  Simulators and other numerical
analysis software may ignore CompartmentType definitions and references
to them in a model.
There is no mechanism in SBML for representing hierarchies of
compartment types.  One CompartmentType instance cannot be the subtype
of another CompartmentType instance; SBML provides no means of defining
such relationships.
As with other major structures in SBML, CompartmentType has a mandatory
attribute, "id", used to give the compartment type an identifier.  The
identifier must be a text string conforming to the identifer syntax
permitted in SBML.  CompartmentType also has an optional "name"
attribute, of type C<string>.  The "id" and "name" must be used
according to the guidelines described in the SBML specification (e.g.,
Section 3.3 in the Level 2 Version 4 specification).
CompartmentType was introduced in SBML Level 2 Version 2.  It is not
available in earlier versions of Level 2 nor in any version of Level 1.
@see Compartment
@see ListOfCompartmentTypes
@see SpeciesType
@see ListOfSpeciesTypes


=over

=back

=head2 ListOfCompartmentTypes

LibSBML implementation of SBML's ListOfCompartmentTypes construct.
The various ListOf___ classes in SBML are merely containers used for
organizing the main components of an SBML model.  All are derived from
the abstract class SBase, and inherit the various attributes and
subelements of SBase, such as "metaid" as and "annotation".  The
ListOf___ classes do not add any attributes of their own.
The relationship between the lists and the rest of an SBML model is
illustrated by the following (for SBML Level&nbsp;2 Version&nbsp;4):
@image html listof-illustration.jpg "ListOf___ elements in an SBML Model"
@image latex listof-illustration.jpg "ListOf___ elements in an SBML Model"
Readers may wonder about the motivations for using the ListOf___
containers.  A simpler approach in XML might be to place the components
all directly at the top level of the model definition.  We chose instead
to group them within XML elements named after ListOf<em>Classname</em>,
in part because we believe this helps organize the components and makes
visual reading of models in XML easier.  More importantly, the fact that
the container classes are derived from SBase means that software tools
can add information about the lists themselves into each list
container's "annotation".
@see ListOfFunctionDefinitions
@see ListOfUnitDefinitions
@see ListOfCompartmentTypes
@see ListOfSpeciesTypes
@see ListOfCompartments
@see ListOfSpecies
@see ListOfParameters
@see ListOfInitialAssignments
@see ListOfRules
@see ListOfConstraints
@see ListOfReactions
@see ListOfEvents


=over

=item CompartmentType::CompartmentType

Creates a new CompartmentType, optionally with the given C<id> and @p
name attribute values.
In SBML, identifiers are required for CompartmentType objects;
however, the identifier does not have to be set at the time of
creation of the object, and instead can be set using the setId()
method on the SBase parent class.
@param id a string, the identifier of this CompartmentType instance
@param name a string, the optional name of this CompartmentType instance
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item CompartmentType::CompartmentType

Creates a new CompartmentType using the given SBML C<level> and C<version>
values and optionally a set of XMLNamespaces.
It is worth emphasizing that although this constructor does not take
an identifier argument, in SBML Level&nbsp;2 and beyond, the "id"
(identifier) attribute of a CompartmentType is required to have a value.
Thus, callers are cautioned to assign a value after calling this
constructor.  Setting the identifier can be accomplished using the
method @if clike SBase::setId() @endif@if java SBase::setId(String id) @endif.
@param level an unsigned int, the SBML Level to assign to this CompartmentType
@param version an unsigned int, the SBML Version to assign to this
CompartmentType

@param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
assign to this CompartmentType
@note Once a CompartmentType has been added to an SBMLDocument, the C<level>,
C<version> and C<xmlns> namespaces for the document I<override> those used
to create the CompartmentType.  Despite this, the ability to supply the values
at creation time is an important aid to creating valid SBML.  Knowledge of
the intented SBML Level and Version determine whether it is valid to
assign a particular value to an attribute, or whether it is valid to add
an object to an existing SBMLDocument.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.

@deprecated libSBML internal


=item CompartmentType::CompartmentType

Copy constructor; creates a copy of this CompartmentType.


=item CompartmentType::accept

Accepts the given SBMLVisitor for this instance of CompartmentType.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>, which indicates
whether the Visitor would like to visit the next CompartmentType in
the list of compartment types.


=item CompartmentType::clone

Creates and returns a deep copy of this CompartmentType.
Returns a (deep) copy of this CompartmentType.


=item CompartmentType::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for this object, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item CompartmentType::getElementName

Returns the XML element name of this object, which for
CompartmentType, is always C<"compartmentType">.
Returns the name of this element, i.e., C<"compartmentType">.


=item CompartmentType::readAttributes

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.
@param attributes the XMLAttributes to use.
@deprecated libSBML internal


=item CompartmentType::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@param stream the XMLOutputStream to use.
@deprecated libSBML internal


=item ListOfCompartmentTypes::clone

Creates and returns a deep copy of this ListOfCompartmentTypes instance.
Returns a (deep) copy of this ListOfCompartmentTypes.


=item ListOfCompartmentTypes::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for this object, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item ListOfCompartmentTypes::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., CompartmentType objects, if the list is non-empty).
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for the objects contained in this ListOf
instance, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item ListOfCompartmentTypes::getElementName

Returns the XML element name of this object.
For ListOfCompartmentTypes, the XML element name is @c
"listOfCompartmentTypes".

Returns the name of this element, i.e., C<"listOfCompartmentTypes">.


=item ListOfCompartmentTypes::get

Get a CompartmentType from the ListOfCompartmentTypes.
@param n the index number of the CompartmentType to get.
Returns the nth CompartmentType in this ListOfCompartmentTypes.
@see size()


=item ListOfCompartmentTypes::get

Get a CompartmentType from the ListOfCompartmentTypes.
@param n the index number of the CompartmentType to get.
Returns the nth CompartmentType in this ListOfCompartmentTypes.
@see size()


=item ListOfCompartmentTypes::get

Get a CompartmentType from the ListOfCompartmentTypes
based on its identifier.
@param sid a string representing the identifier 
of the CompartmentType to get.
Returns CompartmentType in this ListOfCompartmentTypes
with the given id or NULL if no such
CompartmentType exists.
@see get(unsigned int n)
@see size()


=item ListOfCompartmentTypes::get

Get a CompartmentType from the ListOfCompartmentTypes
based on its identifier.
@param sid a string representing the identifier 
of the CompartmentType to get.
Returns CompartmentType in this ListOfCompartmentTypes
with the given id or NULL if no such
CompartmentType exists.
@see get(unsigned int n)
@see size()


=item ListOfCompartmentTypes::remove

Removes the nth item from this ListOfCompartmentTypes items and returns a pointer to
it.

The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove
@see size()


=item ListOfCompartmentTypes::remove

Removes item in this ListOfCompartmentTypes items with the given identifier.
The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier C<sid>, then @c
NULL is returned.
@param sid the identifier of the item to remove
Returns the item removed.  As mentioned above, the caller owns the
returned item.


=item ListOfCompartmentTypes::getElementPosition

Get the ordinal position of this element in the containing object
(which in this case is the Model object).
The ordering of elements in the XML form of SBML is generally fixed
for most components in SBML.  For example, the
ListOfCompartmentTypes in a model (in SBML Level 2 Version 4) is the
third ListOf___.  (However, it differs for different Levels and
Versions of SBML, so calling code should not hardwire this number.)
Returns the ordinal position of the element with respect to its
siblings, or C<-1> (default) to indicate the position is not significant.
@deprecated libSBML internal


=item ListOfCompartmentTypes::createObject

Create a ListOfCompartmentTypes object corresponding to the next token
in the XML input stream.
Returns the SBML object corresponding to next XMLToken in the
XMLInputStream, or C<NULL> if the token was not recognized.
@deprecated libSBML internal


=back

=head2 SpeciesType

LibSBML implementation of SBML's SpeciesType construct.
The term I<species> I<type> refers to reacting entities independent of
location.  These include simple ions (e.g., protons, calcium), simple
molecules (e.g., glucose, ATP), large molecules (e.g., RNA,
polysaccharides, and proteins), and others.
SpeciesType structures are included in SBML to enable Species of the
same type to be related together.  It is a conceptual construct; the
existence of SpeciesType objects in a model has no effect on the
model's numerical interpretation.  Except for the requirement for
uniqueness of species/species type combinations located in compartments,
simulators and other numerical analysis software may ignore SpeciesType
definitions and references to them in a model.
There is no mechanism in SBML for representing hierarchies of species
types.  One SpeciesType object cannot be the subtype of another
SpeciesType object; SBML provides no means of defining such
relationships.

As with other major structures in SBML, SpeciesType has a mandatory
attribute, "id", used to give the species type an identifier.  The
identifier must be a text string conforming to the identifer syntax
permitted in SBML.  SpeciesType also has an optional "name" attribute,
of type C<string>.  The "id" and "name" must be used according to the
guidelines described in the SBML specification (e.g., Section 3.3 in
the Level 2 Version 4 specification).
SpeciesType was introduced in SBML Level 2 Version 2.  It is not
available in earlier versions of Level 2 nor in any version of Level 1.
<!---------------------------------------------------------------------- -->


=over

=back

=head2 ListOfSpeciesTypes

LibSBML implementation of SBML's ListOfSpeciesTypes construct.
The various ListOf___ classes in SBML are merely containers used for
organizing the main components of an SBML model.  All are derived from
the abstract class SBase, and inherit the various attributes and
subelements of SBase, such as "metaid" as and "annotation".  The
ListOf___ classes do not add any attributes of their own.
The relationship between the lists and the rest of an SBML model is
illustrated by the following (for SBML Level&nbsp;2 Version&nbsp;4):
@image html listof-illustration.jpg "ListOf___ elements in an SBML Model"
@image latex listof-illustration.jpg "ListOf___ elements in an SBML Model"
Readers may wonder about the motivations for using the ListOf___
containers.  A simpler approach in XML might be to place the components
all directly at the top level of the model definition.  We chose instead
to group them within XML elements named after ListOf<em>Classname</em>,
in part because we believe this helps organize the components and makes
visual reading of models in XML easier.  More importantly, the fact that
the container classes are derived from SBase means that software tools
can add information about the lists themselves into each list
container's "annotation".
@see ListOfFunctionDefinitions
@see ListOfUnitDefinitions
@see ListOfCompartmentTypes
@see ListOfSpeciesTypes
@see ListOfCompartments
@see ListOfSpecies
@see ListOfParameters
@see ListOfInitialAssignments
@see ListOfRules
@see ListOfConstraints
@see ListOfReactions
@see ListOfEvents


=over

=item SpeciesType::SpeciesType

Creates a new SpeciesType, optionally with the given C<id> and @p
name attribute values.
In SBML, identifiers are required for SpeciesType objects;
however, the identifier does not have to be set at the time of
creation of the object, and instead can be set using the setId()
method on the SBase parent class.
@param id a string, the identifier of this SpeciesType instance
@param name a string, the optional name of this SpeciesType instance
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item SpeciesType::SpeciesType

Creates a new SpeciesType using the given SBML C<level> and C<version>
values and optionally a set of XMLNamespaces.
It is worth emphasizing that although this constructor does not take
an identifier argument, in SBML Level&nbsp;2 and beyond, the "id"
(identifier) attribute of a SpeciesType object is required to have a value.
Thus, callers are cautioned to assign a value after calling this
constructor.  Setting the identifier can be accomplished using the
method @if clike SBase::setId() @endif@if java SBase::setId(String id) @endif.
@param level an unsigned int, the SBML Level to assign to this SpeciesType
@param version an unsigned int, the SBML Version to assign to this
SpeciesType

@param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
assign to this SpeciesType
@note Once a SpeciesType has been added to an SBMLDocument, the C<level>,
C<version> and C<xmlns> namespaces for the document I<override> those used
to create the SpeciesType.  Despite this, the ability to supply the values
at creation time is an important aid to creating valid SBML.  Knowledge of
the intented SBML Level and Version determine whether it is valid to
assign a particular value to an attribute, or whether it is valid to add
an object to an existing SBMLDocument.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.

@deprecated libSBML internal


=item SpeciesType::SpeciesType

Copy constructor; creates a copy of this SpeciesType.


=item SpeciesType::accept

Accepts the given SBMLVisitor for this instance of SpeciesType.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>, which indicates
whether the Visitor would like to visit the next SpeciesType in
the list of compartment types.


=item SpeciesType::clone

Creates and returns a deep copy of this SpeciesType.
Returns a (deep) copy of this SpeciesType.


=item SpeciesType::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for this object, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item SpeciesType::getElementName

Returns the XML element name of this object, which for
SpeciesType, is always C<"compartmentType">.
Returns the name of this element, i.e., C<"compartmentType">.


=item SpeciesType::readAttributes

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.
@param attributes the XMLAttributes to use.
@deprecated libSBML internal


=item SpeciesType::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@param stream the XMLOutputStream to use.
@deprecated libSBML internal


=item ListOfSpeciesTypes::clone

Creates and returns a deep copy of this ListOfSpeciesTypes instance.
Returns a (deep) copy of this ListOfSpeciesTypes.


=item ListOfSpeciesTypes::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for this object, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item ListOfSpeciesTypes::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., SpeciesType objects, if the list is non-empty).
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for the objects contained in this ListOf
instance, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item ListOfSpeciesTypes::getElementName

Returns the XML element name of this object.
For ListOfSpeciesTypes, the XML element name is @c
"listOfSpeciesTypes".

Returns the name of this element, i.e., C<"listOfSpeciesTypes">.


=item ListOfSpeciesTypes::get

Get a SpeciesType from the ListOfSpeciesTypes.
@param n the index number of the SpeciesType to get.
Returns the nth SpeciesType in this ListOfSpeciesTypes.
@see size()


=item ListOfSpeciesTypes::get

Get a SpeciesType from the ListOfSpeciesTypes.
@param n the index number of the SpeciesType to get.
Returns the nth SpeciesType in this ListOfSpeciesTypes.
@see size()


=item ListOfSpeciesTypes::get

Get a SpeciesType from the ListOfSpeciesTypes
based on its identifier.
@param sid a string representing the identifier 
of the SpeciesType to get.
Returns SpeciesType in this ListOfSpeciesTypes
with the given id or NULL if no such
SpeciesType exists.
@see get(unsigned int n)
@see size()


=item ListOfSpeciesTypes::get

Get a SpeciesType from the ListOfSpeciesTypes
based on its identifier.
@param sid a string representing the identifier 
of the SpeciesType to get.
Returns SpeciesType in this ListOfSpeciesTypes
with the given id or NULL if no such
SpeciesType exists.
@see get(unsigned int n)
@see size()


=item ListOfSpeciesTypes::remove

Removes the nth item from this ListOfSpeciesTypes items and returns a pointer to
it.

The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove
@see size()


=item ListOfSpeciesTypes::remove

Removes item in this ListOfSpeciesTypes items with the given identifier.
The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier C<sid>, then @c
NULL is returned.
@param sid the identifier of the item to remove
Returns the item removed.  As mentioned above, the caller owns the
returned item.


=item ListOfSpeciesTypes::getElementPosition

Get the ordinal position of this element in the containing object
(which in this case is the Model object).
The ordering of elements in the XML form of SBML is generally fixed
for most components in SBML.  For example, the
ListOfSpeciesTypes in a model (in SBML Level 2 Version 4) is the
third ListOf___.  (However, it differs for different Levels and
Versions of SBML, so calling code should not hardwire this number.)
Returns the ordinal position of the element with respect to its
siblings, or C<-1> (default) to indicate the position is not significant.
@deprecated libSBML internal


=item ListOfSpeciesTypes::createObject

Create a ListOfSpeciesTypes object corresponding to the next token
in the XML input stream.
Returns the SBML object corresponding to next XMLToken in the
XMLInputStream, or C<NULL> if the token was not recognized.
@deprecated libSBML internal


=back

=head2 Compartment

LibSBML implementation of SBML's Compartment construct.
A compartment in SBML represents a bounded space in which species are
located.  Compartments do not necessarily have to correspond to actual
structures inside or outside of a biological cell.
It is important to note that although compartments are optional in the
overall definition of Model, every species in an SBML model must be
located in a compartment.  This in turn means that if a model defines
any species, the model must also define at least one compartment.  The
reason is simply that species represent physical things, and therefore
must exist I<somewhere>.  Compartments represent the I<somewhere>.
Compartment has one required attribute, "id", to give the compartment a
unique identifier by which other parts of an SBML model definition can
refer to it.  A compartment can also have an optional "name" attribute
of type C<string>.  Identifiers and names must be used according to the
guidelines described in the SBML specification (e.g., Section 3.3 in
the Level 2 Version 4 specification).
Each compartment in a model may optionally be designated as belonging to
a particular compartment type.  The optional attribute "compartmentType"
is used identify the compartment type represented by the Compartment
structure.  The "compartmentType" attribute's value must be the
identifier of a CompartmentType instance defined in the model.  If the
"compartmentType" attribute is not present on a particular compartment
definition, a unique virtual compartment type is assumed for that
compartment, and no other compartment can belong to that compartment
type.  The values of "compartmentType" attributes on compartments have
no effect on the numerical interpretation of a model.  Simulators and
other numerical analysis software may ignore "compartmentType"
attributes.

Compartment also has an optional attribute "spatialDimensions", whose
value must be a positive integer indicating the number of spatial
dimensions possessed by the compartment.  The maximum value is C<3>,
meaning a three-dimensional structure (a volume).  Other permissible
values are C<2> (for a two-dimensional area), C<1> (for a
one-dimensional curve), and C<0> (for a point).  The default value of
"spatialDimensions" is C<3>.
Compartment has another optional attribute named "size", representing
the initial total size of the compartment.  The "size" attribute must be
a floating-point value and may represent a volume (if the compartment is
a three-dimensional one), or an area (if the compartment is
two-dimensional), or a length (if the compartment is one-dimensional).
There is no default value of compartment size in SBML Level 2.  In
particular, a missing "size" value <em>does not imply that the
compartment size is 1</em>.  (This is unlike the definition of
compartment "volume" in SBML Level 1.)  When the compartment's
"spatialDimensions" attribute does not have a value of C<0>, a missing
value of "size" for a given compartment signifies that the value either
is unknown, or to be obtained from an external source, or determined by
an InitialAssignment, AssignmentRule, AlgebraicRule or RateRule
elsewhere in the model.  The "size" attribute must not be present if the
"spatialDimensions" attribute has a value of C<0>; otherwise, a logical
inconsistency would exist because a zero-dimensional object cannot have
a physical size.
The units associated with a compartment's "size" attribute value may be
set using the optional Compartment attribute "units".  The default
units, and the kinds of units allowed as values of the attribute
"units", interact with the number of spatial dimensions of the
compartment.  The value of the "units" attribute of a Compartment object
must be one of the base units (see Unit), or the predefined unit
identifiers C<volume>, C<area>, C<length> or C<dimensionless>, or a new
unit defined by a UnitDefinition object in the enclosing Model, subject
to the restrictions detailed in the following table:
@image html compartment-size.jpg "Units permitted for compartment sizes"
@image latex compartment-size.jpg "Units permitted for compartment sizes"
In SBML Level 2, the units of the compartment size, as defined by the
"units" attribute or (if "units" is not set) the default value listed in
the table above, are used in the following ways when the compartment has
a "spatialDimensions" value greater than C<0>:

=over


=item

The value of the "units" attribute is used as the units of the
compartment identifier when the identifier appears as a numerical
quantity in a mathematical formula expressed in MathML.

=item

The C<math> element of an AssignmentRule or InitialAssignment
referring to this compartment must have identical units.

=item

In RateRule objects that set the rate of change of the compartment's
size, the units of the rule's C<math> element must be identical to the
compartment's "units" attribute divided by the default I<time> units.
(In other words, the units for the rate of change of compartment size
are <em>compartment size</em>/<em>time</em> units.

=item

When a Species is to be treated in terms of concentrations or
density, the units of the spatial size portion of the concentration
value (i.e., the denominator in the units formula I<substance>/@em
size) are those indicated by the value of the "units" attribute on the
compartment in which the species is located.

=back


Compartments with "spatialDimensions"=C<0> require special treatment in
this framework.  If a compartment has no size or dimensional units, how
should such a compartment's identifier be interpreted when it appears in
mathematical formulas?  The answer is that such a compartment's
identifier should not appear in mathematical formulas in the first
place&mdash;it has no value, and its value cannot change.  Note also
that a zero-dimensional compartment is a point, and species located at
points can only be described in terms of amounts, not
spatially-dependent measures such as concentration.  Since SBML
KineticLaw formulas are already in terms of I<substance>/I<time> and
not (say) I<concentration>/I<time>, volume or other factors in
principle are not needed for species located in zero-dimensional
compartments.

Compartment has another optional attribute named "constant".  This takes
a boolean value indicating whether the compartment's size stays constant
or can vary during a simulation.  A value of C<false> indicates the
compartment's "size" can be changed by other constructs in SBML.  A
value of C<true> indicates the compartment's "size" cannot be changed by
any other construct except InitialAssignment.  In the special case of
"spatialDimensions"=C<0>, the value cannot be changed by
InitialAssignment either.  The default value for the "constant"
attribute is C<true> because in the most common modeling scenarios at
the time of this writing, compartment sizes remain constant.  The
"constant" attribute must default to or be set to C<true> if the value
of the "spatialDimensions" attribute is C<0>, because a zero-dimensional
compartment cannot ever have a size.
Finally, Compartment has an optional attribute named "outside", whose
value can be the identifier of another Compartment object defined in the
enclosing Model object.  Doing so means that the other compartment
contains it or is outside of it.  This enables the representation of
simple topological relationships between compartments, for those
simulation systems that can make use of the information (e.g., for
drawing simple diagrams of compartments).  There are two restrictions on
the containment relationships in SBML.  First, because a compartment
with "spatialDimensions" of C<0> has no size, such a compartment cannot
act as the container of any other compartment I<except> compartments
that I<also> have "spatialDimensions" values of C<0>.  Second, the
directed graph formed by representing Compartment structures as vertexes
and the "outside" attribute values as edges must be acyclic.  The latter
condition is imposed to prevent a compartment from being contained
inside itself.  In the absence of a value for "outside", compartment
definitions in SBML Level 2 do not have any implied spatial
relationships between each other.
It is worth noting that in SBML, there is no relationship between
compartment sizes when compartment positioning is expressed using the
"outside" attribute.  The size of a given compartment does not in any
sense include the sizes of other compartments having it as the value of
their "outside" attributes.  In other words, if a compartment I<B> has
the identifier of compartment I<A> as its "outside" attribute value,
the size of I<A> does not include the size of I<B>.  The compartment
sizes are separate.
@note the "size" attribute on a compartment must be defined as optional;
however, <em>it is extremely good practice to specify values for
compartment sizes</em> when such values are available.  There are three
major technical reasons for this.  First, if the model contains any
species whose initial amounts are given in terms of concentrations, and
there is at least one reaction in the model referencing such a species,
then the model is numerically incomplete if it lacks a value for the
size of the compartment in which the species is located.  The reason is
simply that SBML Reaction objects defined in units of
<em>substance</em>/<em>time</em>, not concentration per time, and
thus the compartment size must at some point be used to convert from
species concentration to substance units.  Second, models ideally should
be instantiable in a variety of simulation frameworks.  A commonly-used
one is the discrete stochastic framework in which species are
represented as item counts (e.g., molecule counts).  If species' initial
quantities are given in terms of concentrations or densities, it is
impossible to convert the values to item counts without knowing
compartment sizes.  Third, if a model contains multiple compartments
whose sizes are not all identical to each other, it is impossible to
quantify the reaction rate expressions without knowing the compartment
volumes.  The reason for the latter is again that reaction rates in SBML
are defined in terms of <em>substance</em>/<em>time</em>, and when
species quantities are given in terms of concentrations or densities,
the compartment sizes become factors in the reaction rate expressions.
<!-- leave this next break as-is to work around some doxygen bug -->


=over

=back

=head2 ListOfCompartments

LibSBML implementation of SBML's ListOfCompartments construct.
The various ListOf___ classes in SBML are merely containers used for
organizing the main components of an SBML model.  All are derived from
the abstract class SBase, and inherit the various attributes and
subelements of SBase, such as "metaid" as and "annotation".  The
ListOf___ classes do not add any attributes of their own.
The relationship between the lists and the rest of an SBML model is
illustrated by the following (for SBML Level&nbsp;2 Version&nbsp;4):
@image html listof-illustration.jpg "ListOf___ elements in an SBML Model"
@image latex listof-illustration.jpg "ListOf___ elements in an SBML Model"
Readers may wonder about the motivations for using the ListOf___
containers.  A simpler approach in XML might be to place the components
all directly at the top level of the model definition.  We chose instead
to group them within XML elements named after ListOf<em>Classname</em>,
in part because we believe this helps organize the components and makes
visual reading of models in XML easier.  More importantly, the fact that
the container classes are derived from SBase means that software tools
can add information about the lists themselves into each list
container's "annotation".
@see ListOfFunctionDefinitions
@see ListOfUnitDefinitions
@see ListOfCompartmentTypes
@see ListOfSpeciesTypes
@see ListOfCompartments
@see ListOfSpecies
@see ListOfParameters
@see ListOfInitialAssignments
@see ListOfRules
@see ListOfConstraints
@see ListOfReactions
@see ListOfEvents


=over

=item Compartment::Compartment

Creates a new Compartment, optionally with the given C<id> and C<name>
attribute values.
@param id a string, the identifier to assign to this Compartment
@param name a string, the optional name to assign to this Compartment
@note It is worth emphasizing that although the identifier is optional
for this constructor, in SBML Level 2 and beyond, the "id"
(identifier) attribute of a Compartment is required to have a value.
Thus, callers are cautioned to assign a value after calling this
constructor if no identifier is provided as an argument.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item Compartment::Compartment

Creates a new Compartment using the given SBML C<level> and C<version>
values and optionally a set of XMLNamespaces.
It is worth emphasizing that although this constructor does not take
an identifier argument, in SBML Level&nbsp;2 and beyond, the "id"
(identifier) attribute of a Compartment is required to have a value.
Thus, callers are cautioned to assign a value after calling this
constructor.  Setting the identifier can be accomplished using the
method @if clike SBase::setId() @endif@if java SBase::setId(String id) @endif.
@param level an unsigned int, the SBML Level to assign to this Compartment
@param version an unsigned int, the SBML Version to assign to this
Compartment

@param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
assign to this Compartment
@note Once a Compartment has been added to an SBMLDocument, the C<level>,
C<version> and C<xmlns> namespaces for the document I<override> those used
to create the Compartment.  Despite this, the ability to supply the values
at creation time is an important aid to creating valid SBML.  Knowledge of
the intented SBML Level and Version determine whether it is valid to
assign a particular value to an attribute, or whether it is valid to add
an object to an existing SBMLDocument.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.

@deprecated libSBML internal


=item Compartment::Compartment

Copy constructor; creates a copy of a Compartment.
@param orig the Compartment instance to copy.


=item Compartment::accept

Accepts the given SBMLVisitor for this instance of Compartment.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>, which indicates
whether the Visitor would like to visit the next Compartment in the
list of compartments within which this Compartment is embedded (i.e.,
the ListOfCompartments in the parent Model).


=item Compartment::clone

Creates and returns a deep copy of this Compartment.
Returns a (deep) copy of this Compartment.


=item Compartment::initDefaults

Initializes the fields of this Compartment to the defaults defined in
the specification of the relevant Level/Version of SBML.

=over


=item

(SBML Level 1 only) sets attribute "volume" to C<1>.0

=item

(SBML Level 2 only) sets attribute "spatialDimensions" to C<3>

=item

(SBML Level 2 only) sets attribute "constant" to C<1> (true)

=back




=item Compartment::getCompartmentType

Get the compartment type of this Compartment, as indicated by the
Compartment object's "compartmentType" attribute value.
Returns the value of the "compartmentType" attribute of this
Compartment as a string.


=item Compartment::getSpatialDimensions

Get the number of spatial dimensions of this Compartment object.
Returns the value of the "spatialDimensions" attribute of this
Compartment as an unsigned integer


=item Compartment::getSize

Get the size of this Compartment
This method is identical to getVolume().  In SBML Level 1,
compartments are always three-dimensional constructs and only have
volumes, whereas in SBML Level 2, compartments may be other than
three-dimensional and therefore the "volume" attribute is named "size"
in Level 2.  LibSBML provides both getSize() and getVolume() for
easier compatibility between SBML Levels.
Returns the value of the "size" attribute ("volume" in Level 1) of
this Compartment as a float-point number.
@see isSetSize()


=item Compartment::getVolume

(For SBML Level 1) Get the volume of this Compartment
This method is identical to getSize().  In SBML Level 1, compartments
are always three-dimensional constructs and only have volumes, whereas
in SBML Level 2, compartments may be other than three-dimensional and
therefore the "volume" attribute is named "size" in Level 2.  LibSBML
provides both getSize() and getVolume() for easier compatibility
between SBML Levels.
Returns the value of the "volume" attribute ("size" in Level 2) of
this Compartment, as a floating-point number.
@see isSetVolume()


=item Compartment::getUnits

Get the units of this compartment's size or volume.
Returns the value of the "units" attribute of this Compartment.


=item Compartment::getOutside

Get the identifier, if any, of the compartment that is designated
as being outside of this one.
Returns the value of the "outside" attribute of this Compartment.


=item Compartment::getConstant

Get the value of the "constant" attribute of this Compartment.
Returns C<true> if this Compartment's size is flagged as being
constant, C<false> otherwise.


=item Compartment::isSetCompartmentType

Predicate returning C<true> or C<false> depending on whether this
Compartment's "compartmentType" attribute has been set.
@htmlinclude libsbml-comment-set-methods.html
Returns C<true> if the "compartmentType" attribute of this Compartment
has been set, C<false> otherwise.


=item Compartment::isSetSize

Predicate returning C<true> or C<false> depending on whether this
Compartment's "size" attribute has been set.
@htmlinclude libsbml-comment-set-methods.html
This method is similar but not identical to isSetVolume().  The latter
should be used in the context of SBML Level 1 models instead of
isSetSize() because isSetVolume() performs extra processing to take
into account the difference in default values between SBML Levels 1
and 2.
Returns C<true> if the "size" attribute ("volume" in Level) of this
Compartment has been set, C<false> otherwise.
@see isSetVolume()
@see setSize(double value)


=item Compartment::isSetVolume

(For SBML Level 1) Predicate returning C<true> or C<false> depending
on whether this Compartment's "volume" attribute has been set.
@htmlinclude libsbml-comment-set-methods.html
This method is similar but not identical to isSetSize().  The latter
should not be used in the context of SBML Level 1 models because this
method (isSetVolume()) performs extra processing to take into account
the difference in default values between SBML Levels 1 and 2.
Returns C<true> if the "volume" attribute ("size" in L2) of this
Compartment has been set, C<false> otherwise.
@see isSetSize()
@see setVolume(double value)
@note In SBML Level 1, a compartment's volume has a default value (@c
1.0) and therefore this method will always return C<true>.  In Level
2, a compartment's size (the equivalent of SBML Level 1's "volume") is
optional and has no default value, and therefore may or may not be
set.



=item Compartment::isSetUnits

Predicate returning C<true> or C<false> depending on whether this
Compartment's "units" attribute has been set.
@htmlinclude libsbml-comment-set-methods.html
Returns C<true> if the "units" attribute of this Compartment has been
set, C<false> otherwise.


=item Compartment::isSetOutside

Predicate returning C<true> or C<false> depending on whether this
Compartment's "outside" attribute has been set.
@htmlinclude libsbml-comment-set-methods.html
Returns C<true> if the "outside" attribute of this Compartment has
been set, C<false> otherwise.


=item Compartment::setCompartmentType

Sets the "compartmentType" attribute of this Compartment.
@htmlinclude libsbml-comment-set-methods.html
@param sid the identifier of a CompartmentType object defined
elsewhere in this Model.


=item Compartment::setSpatialDimensions

Sets the "spatialDimensions" attribute of this Compartment.
@htmlinclude libsbml-comment-set-methods.html
If C<value> is not one of C<0>, C<1>, C<2>, or C<3>, this method will
have no effect (i.e., the "spatialDimensions" attribute will not be
set).

@param value an unsigned integer indicating the number of dimensions
of this compartment.


=item Compartment::setSize

Sets the "size" attribute (or "volume" in SBML Level 1) of this
Compartment.

@htmlinclude libsbml-comment-set-methods.html
This method is identical to setVolume() and is provided for
compatibility between SBML Level 1 and Level 2.
@param value a C<double> representing the size of this compartment
instance in whatever units are in effect for the compartment.


=item Compartment::setVolume

Sets the "volume" attribute (or "size" in SBML Level 2) of this
Compartment.

@htmlinclude libsbml-comment-set-methods.html
This method is identical to setVolume() and is provided for
compatibility between SBML Level 1 and Level 2.
@param value a C<double> representing the volume of this compartment
instance in whatever units are in effect for the compartment.


=item Compartment::setUnits

Sets the "units" attribute of this Compartment.
@htmlinclude libsbml-comment-set-methods.html
@param sid the identifier of the defined units to use.


=item Compartment::setOutside

Sets the "outside" attribute of this Compartment.
@htmlinclude libsbml-comment-set-methods.html
@param sid the identifier of a compartment that encloses this one.


=item Compartment::setConstant

Sets the value of the "constant" attribute of this Compartment.
@param value a boolean indicating whether the size/volume of this
compartment should be considered constant (C<true>) or variable (@c
false)



=item Compartment::unsetCompartmentType

Unsets the value of the "compartmentType" attribute of this
Compartment.

@htmlinclude libsbml-comment-set-methods.html
@see setCompartmentType()
@see isSetCompartmentType()


=item Compartment::unsetSize

Unsets the value of the "size" attribute of this Compartment.
@htmlinclude libsbml-comment-set-methods.html


=item Compartment::unsetVolume

(For SBML Level 1) Unsets the value of the "volume" attribute of this
Compartment.

@htmlinclude libsbml-comment-set-methods.html
In SBML Level 1, a Compartment volume has a default value (1.0) and
therefore <em>should always be set</em>.  In Level 2, "size" is
optional with no default value and as such may or may not be set.


=item Compartment::unsetUnits

Unsets the value of the "units" attribute of this Compartment.
@htmlinclude libsbml-comment-set-methods.html


=item Compartment::unsetOutside

Unsets the value of the "outside" attribute of this Compartment.
@htmlinclude libsbml-comment-set-methods.html


=item Compartment::getDerivedUnitDefinition

Constructs and returns a UnitDefinition that corresponds to the units
of this Compartment's designated size.
Compartments in SBML have an attribute ("units") for declaring the
units of measurement intended for the value of the compartment's size.
In the absence of a value given for this attribute, the units are
taken from the model's definition of C<"volume">, C<"area">, @c
"length" units, depending on the value given to this Compartment's
"size" attribute, or (if the Model does not redefine them) the
corresponding SBML default units for those quantities.  Following that
procedure, the method getDerivedUnitDefinition() returns a
UnitDefinition based on the interpreted units of this compartment's
size.

Note that method will always return a value, never NULL, because SBML
defines default units for compartment sizes.  It is thus not possible
for the units to be undefined (which is unlike the case of Parameter).
Note also that unit declarations for Compartment are in terms of the
I<identifier> of a unit, but this method returns a UnitDefinition
object, not a unit identifier.  It does this by constructing an
appropriate UnitDefinition.  Callers may find this particularly useful
when used in conjunction with the helper methods on UnitDefinition for
comparing different UnitDefinition objects.
Returns a UnitDefinition that expresses the units of this 
Compartment.

@see getUnits()


=item Compartment::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for this object, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item Compartment::getElementName

Returns the XML element name of this object, which for Compartment, is
always C<"compartment">.
Returns the name of this element, i.e., C<"compartment">.


=item Compartment::readAttributes

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.
@deprecated libSBML internal


=item Compartment::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Compartment::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Compartment::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Compartment::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Compartment::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Compartment::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Compartment::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Compartment::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item ListOfCompartments::clone

Creates and returns a deep copy of this ListOfCompartments instance.
Returns a (deep) copy of this ListOfCompartments.


=item ListOfCompartments::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for this object, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item ListOfCompartments::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., Compartment objects, if the list is non-empty).
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for the objects contained in this ListOf
instance, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item ListOfCompartments::getElementName

Returns the XML element name of this object.
For ListOfCompartments, the XML element name is C<"listOfCompartments">.
Returns the name of this element, i.e., C<"listOfCompartments">.


=item ListOfCompartments::get

Get a Compartment from the ListOfCompartments.
@param n the index number of the Compartment to get.
Returns the nth Compartment in this ListOfCompartments.
@see size()


=item ListOfCompartments::get

Get a Compartment from the ListOfCompartments.
@param n the index number of the Compartment to get.
Returns the nth Compartment in this ListOfCompartments.
@see size()


=item ListOfCompartments::get

Get a Compartment from the ListOfCompartments
based on its identifier.
@param sid a string representing the identifier 
of the Compartment to get.
Returns Compartment in this ListOfCompartments
with the given id or NULL if no such
Compartment exists.
@see get(unsigned int n)
@see size()


=item ListOfCompartments::get

Get a Compartment from the ListOfCompartments
based on its identifier.
@param sid a string representing the identifier 
of the Compartment to get.
Returns Compartment in this ListOfCompartments
with the given id or NULL if no such
Compartment exists.
@see get(unsigned int n)
@see size()


=item ListOfCompartments::remove

Removes the nth item from this ListOfCompartments items and returns a pointer to
it.

The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove
@see size()


=item ListOfCompartments::remove

Removes item in this ListOfCompartments items with the given identifier.
The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier C<sid>, then @c
NULL is returned.
@param sid the identifier of the item to remove
Returns the item removed.  As mentioned above, the caller owns the
returned item.


=item ListOfCompartments::getElementPosition

Get the ordinal position of this element in the containing object
(which in this case is the Model object).
The ordering of elements in the XML form of SBML is generally fixed
for most components in SBML.  So, for example, the ListOfCompartments
in a model is (in SBML Level 2 Version 4) the fifth ListOf___.
(However, it differs for different Levels and Versions of SBML.)
Returns the ordinal position of the element with respect to its
siblings, or C<-1> (default) to indicate the position is not significant.
@deprecated libSBML internal


=item ListOfCompartments::createObject

Returns the SBML object corresponding to next XMLToken in the
XMLInputStream or NULL if the token was not recognized.
@deprecated libSBML internal


=back

=head2 Species

LibSBML implementation of SBML's Species construct.
A I<species> refers to a pool of reacting entities of a specific
<em>species type</em> that take part in reactions and are located in a
specific I<compartment>.  The Species data structure is intended to
represent these pools.  A Species definition has several parts: an
optional identifier (defined by the attribute "id"), an optional name
(defined by the attribute "name"), a required attribute "compartment",
and optional attributes "speciesType", "initialAmount",
"initialConcentration", "substanceUnits", "hasOnlySubstanceUnits",
"boundaryCondition", "charge" and "constant".  These various parts are
described next.
As with other major structures in SBML, Species has a mandatory
attribute, "id", used to give the species type an identifier in the
model.  The identifier must be a text string conforming to the identifer
syntax permitted in SBML.  Species also has an optional "name"
attribute, of type C<string>.  The "id" and "name" must be used
according to the guidelines described in the SBML specification (e.g.,
Section 3.3 in the Level&nbsp;2 Version&nbsp;4 specification).
The required attribute "compartment" is used to identify the compartment
in which the species is located.  The attribute's value must be the
identifier of an existing Compartment structure.  It is important to
note that there is no default value for the "compartment" attribute on
Species; every species in an SBML model must be assigned a compartment,
and consequently, a model must define at least one compartment if that
model contains any species.
Each species in a model may optionally be designated as belonging to a
particular species type.  The optional attribute "speciesType" is used
to identify the species type of the chemical entities that make up the
pool represented by the Species structure.  The attribute's value must
be the identifier of an existing SpeciesType structure.  If the
"speciesType" attribute is not present on a particular species
definition, it means the pool contains chemical entities of a type
unique to that pool; in effect, a virtual species type is assumed for
that species, and no other species can belong to that species type.  The
value of "speciesType" attributes on species have no effect on the
numerical interpretation of a model; simulators and other numerical
analysis software may ignore "speciesType" attributes.
There can be only one species of a given species type in any given
compartment of a model.  More specifically, for all Species structures
having a value for the "speciesType" attribute, the pair
<center>
("speciesType" attribute value, "compartment" attribute value)
</center>

must be unique across the set of all Species structures in a model.
@section species-amounts The initial amount and concentration of a species
The optional attributes "initialAmount" and "initialConcentration", both
having a data type of C<double>, are used to set the initial quantity of
the species in the compartment where the species is located.  These
attributes are mutually exclusive; i.e., <em>only one</em> can have a
value on any given instance of a Species structure.  Missing
"initialAmount" and "initialConcentration" values implies that their
values either are unknown, or to be obtained from an external source, or
determined by an InitialAssignment or Rule object elsewhere in the
model.  In the case where a species' compartment has a
"spatialDimensions" value of C<0> (zero), the species cannot have a
value for "initialConcentration" because the concepts of concentration
and density break down when a container has zero dimensions.
A species' initial quantity is set by the "initialAmount" or
"initialConcentration" attributes exactly once.  If the species'
"constant" attribute is C<true> (the default), then the size is fixed
and cannot be changed except by an InitialAssignment.  These methods
differ in that the "initialAmount" and "initialConcentration" attributes
can only be used to set the species quantity to a literal scalar value,
whereas InitialAssignment allows the value to be set using an arbitrary
mathematical expression.  If the species' "constant" attribute is @c
false, the species' quantity value may be overridden by an
InitialAssignment or changed by AssignmentRule or AlgebraicRule, and in
addition, for <em>t &lt; 0</em>, it may also be changed by a RateRule or
Event. (However, some constructs are mutually exclusive; see the SBML
specification for more details.)  It is not an error to define
"initialAmount" or "initialConcentration" on a species and also redefine
the value using an InitialAssignment, but the "initialAmount" or
"initialConcentration" setting in that case is ignored.
@section species-units The units of a species' amount or concentration
The units associated with a species' quantity, referred to as the
<em>units of the species</em>, are determined via the optional
attributes "substanceUnits" and "hasOnlySubstanceUnits", in combination
with the units of the size defined for the compartment object in which
the species are located.  The way this is done is as follows.
The units of the value in the "initialConcentration" attribute are @em
substance/I<size> units, where the units of I<substance> are those
defined by the "substanceUnits" attribute and the I<size> units are
those given in the definition of the size of the Compartment in which
the species is located.  The units of the value in the "initialAmount"
attribute are determined by the "substanceUnits" attribute of the
species structure.  The role of the attribute "hasOnlySubstanceUnits" is
to indicate whether the units of the species, when the species
identifier appears in mathematical formulas, are intended to be
concentration or amount.  The attribute takes on boolean values and
defaults to C<false>.  Although it may seem as though this intention
could be determined based on whether "initialConcentration" or
"initialAmount" is set, the fact that these two attributes are optional
means that a separate flag is needed.  (Consider the situation where
neither is set, and instead the species' quantity is established by an
InitialAssignment or AssignmentRule.)
The possible values of <em>units of the species</em> are summarized in
the following table.  (The dependence on the number of spatial
dimensions of the compartment is due to the fact that a zero-dimensional
compartment cannot support concentrations or densities.)
@htmlinclude libsbml-species-hasonlysubstance.html 
The value assigned to "substanceUnits" must be chosen from one of the
following possibilities: one of the base unit identifiers defined in
SBML; the built-in unit identifier C<"substance">; or the identifier of
a new unit defined in the list of unit definitions in the enclosing
Model structure.  The chosen units for "substanceUnits" must be be @c
"dimensionless", C<"mole">, C<"item">, C<"kilogram">, C<"gram">, or
units derived from these.  The "substanceUnits" attribute defaults to
the the built-in unit C<"substance">.
The <em>units of the species</em> are used in the following ways:

=over


=item

The species identifier has these units when the identifier appears
as a numerical quantity in a mathematical formula expressed in MathML.

=item

The "math" subelement of an AssignmentRule or InitialAssignment
referring to this species must have identical units.

=item

In RateRule structures that set the rate of change of the species'
quantity, the units of the rule's "math" subelement must be identical to
the <em>units of the species</em> divided by the model's I<time> units.

=back


@section species-constant The "constant" and "boundaryCondition" attributes
The Species structure has two optional boolean attributes named
"constant" and "boundaryCondition", used to indicate whether and how the
quantity of that species can vary during a simulation.  The following
table shows how to interpret the combined values of these attributes.
@htmlinclude libsbml-species-boundarycondition.html
By default, when a species is a product or reactant of one or more
reactions, its quantity is determined by those reactions.  In SBML, it
is possible to indicate that a given species' quantity is <em>not</em>
determined by the set of reactions even when that species occurs as a
product or reactant; i.e., the species is on the <em>boundary</em> of
the reaction system, and its quantity is not determined by the
reactions.  The boolean attribute "boundaryCondition" can be used to
indicate this.  The value of the attribute defaults to C<false>,
indicating the species I<is> part of the reaction system.
The "constant" attribute indicates whether the species' quantity can be
changed at all, regardless of whether by reactions, rules, or constructs
other than InitialAssignment.  The default value is C<false>, indicating
that the species' quantity can be changed, since the purpose of most
simulations is precisely to calculate changes in species quantities.
Note that the initial quantity of a species can be set by an
InitialAssignment irrespective of the value of the "constant" attribute.
In practice, a "boundaryCondition" value of C<true> means a differential
equation derived from the reaction definitions should not be generated
for the species.  However, the species' quantity may still be changed by
AssignmentRule, RateRule, AlgebraicRule, Event, and InitialAssignment
constructs if its "constant" attribute is C<false>.  Conversely, if the
species' "constant" attribute is C<true>, then its value cannot be
changed by anything except InitialAssignment.
A species having "boundaryCondition"=C<false> and "constant"=C<false>
can appear as a product and/or reactant of one or more reactions in the
model.  If the species is a reactant or product of a reaction, it must
I<not> also appear as the target of any AssignmentRule or RateRule
structure in the model.  If instead the species has
"boundaryCondition"=C<false> and "constant"=C<true>, then it cannot
appear as a reactant or product, or as the target of any
AssignmentRule, RateRule or EventAssignment structure in the model.
@warning In versions of SBML Level&nbsp;2 before Version&nbsp;3, the class
Species included an attribute called "spatialSizeUnits, which allowed
explicitly setting the units of size for initial concentration.  LibSBML
retains this attribute for compatibility with older definitions of
Level&nbsp;2, but its use is strongly discouraged because it is
incompatible with Level&nbsp;2 Version&nbsp;3 andLevel&nbsp;2 Version&nbsp;4.
<!-- leave this next break as-is to work around some doxygen bug -->


=over

=back

=head2 ListOfSpecies

LibSBML implementation of SBML's ListOfSpecies construct.
The various ListOf___ classes in SBML are merely containers used for
organizing the main components of an SBML model.  All are derived from
the abstract class SBase, and inherit the various attributes and
subelements of SBase, such as "metaid" as and "annotation".  The
ListOf___ classes do not add any attributes of their own.
The relationship between the lists and the rest of an SBML model is
illustrated by the following (for SBML Level&nbsp;2 Version&nbsp;4):
@image html listof-illustration.jpg "ListOf___ elements in an SBML Model"
@image latex listof-illustration.jpg "ListOf___ elements in an SBML Model"
Readers may wonder about the motivations for using the ListOf___
containers.  A simpler approach in XML might be to place the components
all directly at the top level of the model definition.  We chose instead
to group them within XML elements named after ListOf<em>Classname</em>,
in part because we believe this helps organize the components and makes
visual reading of models in XML easier.  More importantly, the fact that
the container classes are derived from SBase means that software tools
can add information about the lists themselves into each list
container's "annotation".
@see ListOfFunctionDefinitions
@see ListOfUnitDefinitions
@see ListOfCompartmentTypes
@see ListOfSpeciesTypes
@see ListOfCompartments
@see ListOfSpecies
@see ListOfParameters
@see ListOfInitialAssignments
@see ListOfRules
@see ListOfConstraints
@see ListOfReactions
@see ListOfEvents


=over

=item Species::Species

Creates a new Species, optionally with the given C<id> and C<name>
attribute values.
@param id a string, the identifier to assign to this Species
@param name a string, the optional name to assign to this Species
@note It is worth emphasizing that although the identifier is optional
for this constructor, in SBML Level&nbsp;2 and beyond, the "id"
(identifier) attribute of a Species is required to have a value.
Thus, callers are cautioned to assign a value after calling this
constructor if no identifier is provided as an argument.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item Species::Species

Creates a new Species using the given SBML C<level> and C<version>
values and optionally a set of XMLNamespaces.
It is worth emphasizing that although this constructor does not take
an identifier argument, in SBML Level&nbsp;2 and beyond, the "id"
(identifier) attribute of a Species is required to have a value.
Thus, callers are cautioned to assign a value after calling this
constructor.  Setting the identifier can be accomplished using the
method @if clike SBase::setId() @endif@if java SBase::setId(String id) @endif.
@param level an unsigned int, the SBML Level to assign to this Species
@param version an unsigned int, the SBML Version to assign to this
Species

@param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
assign to this Species
@note Once a Species has been added to an SBMLDocument, the C<level>,
C<version> and C<xmlns> namespaces for the document I<override> those used
to create the Species.  Despite this, the ability to supply the values
at creation time is an important aid to creating valid SBML.  Knowledge of
the intented SBML Level and Version determine whether it is valid to
assign a particular value to an attribute, or whether it is valid to add
an object to an existing SBMLDocument.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.

@deprecated libSBML internal


=item Species::Species

Copy constructor; creates a copy of this Species.


=item Species::accept

Accepts the given SBMLVisitor for this instance of Species.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>.


=item Species::clone

Creates and returns a deep copy of this Species.
Returns a (deep) copy of this Species.


=item Species::initDefaults

Initializes the fields of this Species to the defaults defined
in the specification of the relevant Level/Version of SBML.

=over


=item

sets "boundaryCondition" to C<1> (true)

=item

(Level&nbsp;2 only) sets "constant" to C<0> (false)

=item

(Level&nbsp;2 only) sets "hasOnlySubstanceUnits" to C<0> (false)

=back




=item Species::getSpeciesType

Get the species type of this Species, as indicated by the
Species object's "speciesType" attribute value.
Returns the value of the "speciesType" attribute of this
Species as a string.


=item Species::getCompartment

Get the compartment in which this species is located.
Returns the value of the "compartment" attribute of this Species, as a
string.



=item Species::getInitialAmount

Get the value of the "initialAmount" attribute.
Returns the initialAmount of this Species, as a float-point number.


=item Species::getInitialConcentration

Get the value of the "initialConcentration" attribute.
Returns the initialConcentration of this Species,, as a float-point
number.



=item Species::getSubstanceUnits

Get the value of the "substanceUnit" attribute.
Returns the substanceUnits of this Species, as a string.


=item Species::getSpatialSizeUnits

Get the value of the "spatialSizeUnits" attribute.
Returns the spatialSizeUnits of this Species.
@warning In versions of SBML Level~2 before Version&nbsp;3, the class
Species included an attribute called "spatialSizeUnits", which allowed
explicitly setting the units of size for initial concentration.  This
attribute was removed in SBML Level&nbsp;2 Version&nbsp;3.  LibSBML
retains this attribute for compatibility with older definitions of
Level&nbsp;2, but its use is strongly discouraged because it is
incompatible with Level&nbsp;2 Version&nbsp;3 and Level&nbsp;2 Version&nbsp;4.


=item Species::getUnits

(SBML Level&nbsp;1 only) Get the value of the "units" attribute.
Returns the units of this Species (L1 only).


=item Species::getHasOnlySubstanceUnits

Get the value of the "hasOnlySubstanceUnits" attribute.
Returns C<true> if this Species' "hasOnlySubstanceUnits" attribute
value is nonzero, C<false> otherwise.


=item Species::getBoundaryCondition

Get the value of the "boundaryCondition" attribute.
Returns C<true> if this Species' "boundaryCondition" attribute value
is nonzero, C<false> otherwise.


=item Species::getCharge

Get the value of the "charge" attribute.
Returns the charge of this Species.
@note Beginning in SBML Level&nbsp;2 Version&nbsp;2, the "charge"
attribute on Species is deprecated and its use strongly discouraged.
Its presence is considered a misfeature in earlier definitions of SBML
because its implications for the mathematics of a model were never
defined, and in any case, no known modeling system ever used it.
Instead, models take account of charge values directly in their
definitions of species by (for example) having separate species
identities for the charged and uncharged versions of the same species.
This allows the condition to affect model mathematics directly.
LibSBML retains this method for easier compatibility with SBML
Level&nbsp;1.



=item Species::getConstant

Get the value of the "constant" attribute.
Returns C<true> if this Species's "constant" attribute value is
nonzero, C<false> otherwise.


=item Species::isSetSpeciesType

Predicate returning C<true> or C<false> depending on whether this
Species's "speciesType" attribute has been set.
@htmlinclude libsbml-comment-set-methods.html
Returns C<true> if the "speciesType" attribute of this Species has
been set, C<false> otherwise.


=item Species::isSetCompartment

Predicate returning C<true> or C<false> depending on whether this
Species's "compartment" attribute has been set.
@htmlinclude libsbml-comment-set-methods.html
Returns C<true> if the "compartment" attribute of this Species has
been set, C<false> otherwise.


=item Species::isSetInitialAmount

Predicate returning C<true> or C<false> depending on whether this
Species's "initialAmount" attribute has been set.
@htmlinclude libsbml-comment-set-methods.html
Returns C<true> if the "initialAmount" attribute of this Species has
been set, C<false> otherwise.
@note In SBML Level&nbsp;1, Species' "initialAmount" is required and
therefore <em>should always be set</em>.  (However, in Level&nbsp;1, the
attribute has no default value either, so this method will not return
C<true> until a value has been assigned.)  In SBML Level&nbsp;2,
"initialAmount" is optional and as such may or may not be set.


=item Species::isSetInitialConcentration

Predicate returning C<true> or C<false> depending on whether this
Species's "initialConcentration" attribute has been set.
@htmlinclude libsbml-comment-set-methods.html
Returns C<true> if the "initialConcentration" attribute of this Species has
been set, C<false> otherwise.


=item Species::isSetSubstanceUnits

Predicate returning C<true> or C<false> depending on whether this
Species's "substanceUnits" attribute has been set.
@htmlinclude libsbml-comment-set-methods.html
Returns C<true> if the "substanceUnits" attribute of this Species has
been set, C<false> otherwise.


=item Species::isSetSpatialSizeUnits

Predicate returning C<true> or C<false> depending on whether this
Species's "spatialSizeUnits" attribute has been set.
@htmlinclude libsbml-comment-set-methods.html
Returns C<true> if the "spatialSizeUnits" attribute of this Species has
been set, C<false> otherwise.
@warning In versions of SBML Level~2 before Version&nbsp;3, the class
Species included an attribute called "spatialSizeUnits", which allowed
explicitly setting the units of size for initial concentration.  This
attribute was removed in SBML Level&nbsp;2 Version&nbsp;3.  LibSBML
retains this attribute for compatibility with older definitions of
Level&nbsp;2, but its use is strongly discouraged because it is
incompatible with Level&nbsp;2 Version&nbsp;3 and Level&nbsp;2 Version&nbsp;4.


=item Species::isSetUnits

(SBML Level&nbsp;1 only) Predicate returning C<true> or C<false> depending
on whether this Species's "units" attribute has been set.
@htmlinclude libsbml-comment-set-methods.html
Returns C<true> if the "units" attribute of this Species has
been set, C<false> otherwise.


=item Species::isSetCharge

Predicate returning C<true> or C<false> depending on whether this
Species's "charge" attribute has been set.
@htmlinclude libsbml-comment-set-methods.html
Returns C<true> if the "charge" attribute of this Species has
been set, C<false> otherwise.
@note Beginning in SBML Level&nbsp;2 Version&nbsp;2, the "charge"
attribute on Species in SBML is deprecated and its use strongly
discouraged.  Its presence is considered a misfeature in earlier
definitions of SBML because its implications for the mathematics of a
model were never defined, and in any case, no known modeling system
ever used it.  Instead, models take account of charge values directly
in their definitions of species by (for example) having separate
species identities for the charged and uncharged versions of the same
species.  This allows the condition to affect model mathematics
directly.  LibSBML retains this method for easier compatibility with
SBML Level&nbsp;1.


=item Species::setSpeciesType

Sets the "speciesType" attribute of this Species.
@htmlinclude libsbml-comment-set-methods.html
@param sid the identifier of a SpeciesType object defined elsewhere
in this Model.


=item Species::setCompartment

Sets the "compartment" attribute of this Species.
@htmlinclude libsbml-comment-set-methods.html
@param sid the identifier of a Compartment object defined elsewhere
in this Model.


=item Species::setInitialAmount

Sets the "initialAmount" attribute of this Species and marks the field
as set.
This method also unsets the "initialConcentration" attribute.
@htmlinclude libsbml-comment-set-methods.html
@param value the value to which the "initialAmount" attribute should
be set.


=item Species::setInitialConcentration

Sets the "initialConcentration" attribute of this Species and marks
the field as set.
This method also unsets the "initialAmount" attribute.
@htmlinclude libsbml-comment-set-methods.html
@param value the value to which the "initialConcentration" attribute
should be set.


=item Species::setSubstanceUnits

Sets the "substanceUnits" attribute of this Species.
@htmlinclude libsbml-comment-set-methods.html
@param sid the identifier of the unit to use.


=item Species::setSpatialSizeUnits

Sets the "spatialSizeUnits" attribute of this Species.
@htmlinclude libsbml-comment-set-methods.html
@param sid the identifier of the unit to use.
@warning In versions of SBML Level~2 before Version&nbsp;3, the class
Species included an attribute called "spatialSizeUnits", which allowed
explicitly setting the units of size for initial concentration.  This
attribute was removed in SBML Level&nbsp;2 Version&nbsp;3.  LibSBML
retains this attribute for compatibility with older definitions of
Level&nbsp;2, but its use is strongly discouraged because it is
incompatible with Level&nbsp;2 Version&nbsp;3 and Level&nbsp;2 Version&nbsp;4.


=item Species::setUnits

(SBML Level&nbsp;1 only) Sets the units of this Species.
@htmlinclude libsbml-comment-set-methods.html
@param sname the identifier of the unit to use.


=item Species::setHasOnlySubstanceUnits

Sets the "hasOnlySubstanceUnits" attribute of this Species.
@htmlinclude libsbml-comment-set-methods.html
@param value boolean value for the "hasOnlySubstanceUnits" attribute.


=item Species::setBoundaryCondition

Sets the "boundaryCondition" attribute of this Species.
@htmlinclude libsbml-comment-set-methods.html
@param value boolean value for the "boundaryCondition" attribute.


=item Species::setCharge

Sets the "charge" attribute of this Species.
@htmlinclude libsbml-comment-set-methods.html
@param value an integer to which to set the "charge" to.
@note Beginning in SBML Level&nbsp;2 Version&nbsp;2, the "charge"
attribute on Species in SBML is deprecated and its use strongly
discouraged.  Its presence is considered a misfeature in earlier
definitions of SBML because its implications for the mathematics of a
model were never defined, and in any case, no known modeling system
ever used it.  Instead, models take account of charge values directly
in their definitions of species by (for example) having separate
species identities for the charged and uncharged versions of the same
species.  This allows the condition to affect model mathematics
directly.  LibSBML retains this method for easier compatibility with
SBML Level&nbsp;1.


=item Species::setConstant

Sets the "constant" attribute of this Species.
@htmlinclude libsbml-comment-set-methods.html
@param value a boolean value for the "constant" attribute


=item Species::unsetSpeciesType

Unsets the "speciesType" attribute value of this Species.
@htmlinclude libsbml-comment-set-methods.html


=item Species::unsetInitialAmount

Unsets the "initialAmount" attribute value of this Species.
@htmlinclude libsbml-comment-set-methods.html


=item Species::unsetInitialConcentration

Unsets the "initialConcentration" attribute value of this Species.
@htmlinclude libsbml-comment-set-methods.html


=item Species::unsetSubstanceUnits

Unsets the "substanceUnits" attribute value of this Species.
@htmlinclude libsbml-comment-set-methods.html


=item Species::unsetSpatialSizeUnits

Unsets the "spatialSizeUnits" attribute value of this Species.
@htmlinclude libsbml-comment-set-methods.html
@warning In versions of SBML Level~2 before Version&nbsp;3, the class
Species included an attribute called "spatialSizeUnits", which allowed
explicitly setting the units of size for initial concentration.  This
attribute was removed in SBML Level&nbsp;2 Version&nbsp;3.  LibSBML
retains this attribute for compatibility with older definitions of
Level&nbsp;2, but its use is strongly discouraged because it is
incompatible with Level&nbsp;2 Version&nbsp;3 and Level&nbsp;2 Version&nbsp;4.


=item Species::unsetUnits

(SBML Level&nbsp;1 only) Unsets the "units" attribute value of this Species.
@htmlinclude libsbml-comment-set-methods.html


=item Species::unsetCharge

Unsets the "charge" attribute value of this Species.
@htmlinclude libsbml-comment-set-methods.html
@note Beginning in SBML Level&nbsp;2 Version&nbsp;2, the "charge"
attribute on Species in SBML is deprecated and its use strongly
discouraged.  Its presence is considered a misfeature in earlier
definitions of SBML because its implications for the mathematics of a
model were never defined, and in any case, no known modeling system
ever used it.  Instead, models take account of charge values directly
in their definitions of species by (for example) having separate
species identities for the charged and uncharged versions of the same
species.  This allows the condition to affect model mathematics
directly.  LibSBML retains this method for easier compatibility with
SBML Level&nbsp;1.


=item Species::getDerivedUnitDefinition

Constructs and returns a UnitDefinition that corresponds to the units
of this Species' amount or concentration.
Species in SBML have an attribute ("substanceUnits") for declaring the
units of measurement intended for the species' amount or concentration
(depending on which one applies).  In the absence of a value given for
"substanceUnits", the units are taken from the enclosing Model's
definition of C<"substance"> or C<"substance">/<em>(size of the
compartment)</em> in which the species is located, or finally, if
these are not redefined by the Model, the relevant SBML default units
for those quantities.  Following that procedure, the method
getDerivedUnitDefinition() returns a UnitDefinition based on the
interpreted units of this species's amount or concentration.
Note that method will always return a value, never NULL, because SBML
defines default units for species' initial amounts and concentrations.
It is thus not possible for the units to be undefined (which is unlike
the case of Parameter).
Note also that unit declarations for Species are in terms of the @em
identifier of a unit, but this method returns a UnitDefinition object,
not a unit identifier.  It does this by constructing an appropriate
UnitDefinition.  Callers may find this particularly useful when used
in conjunction with the helper methods on UnitDefinition for comparing
different UnitDefinition objects.
In SBML Level&nbsp;2 specifications prior to Version&nbsp;3, Species
includes an additional attribute named "spatialSizeUnits", which
allows explicitly setting the units of size for initial concentration.
The getDerivedUnitDefinition() takes this into account for models
expressed in SBML Level&nbsp;2 Versions&nbsp;1 and&nbsp;2.
Returns a UnitDefinition that expresses the units of this 
Species.

@see getSubstanceUnits()


=item Species::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for this object, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item Species::getElementName

Returns the XML element name of this object, which for Species, is
always C<"species">.
Returns the name of this element, i.e., C<"species">.


=item Species::readAttributes

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.
@deprecated libSBML internal


=item Species::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Species::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Species::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Species::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Species::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Species::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Species::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Species::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Species::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Species::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Species::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Species::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Species::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Species::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item ListOfSpecies::clone

Creates and returns a deep copy of this ListOfSpeciess instance.
Returns a (deep) copy of this ListOfSpeciess.


=item ListOfSpecies::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for this object, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item ListOfSpecies::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., Species objects, if the list is non-empty).
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for the objects contained in this ListOf
instance, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item ListOfSpecies::getElementName

Returns the XML element name of this object.
For ListOfSpeciess, the XML element name is C<"listOfSpeciess">.
Returns the name of this element, i.e., C<"listOfSpeciess">.


=item ListOfSpecies::get

Get a Species from the ListOfSpecies.
@param n the index number of the Species to get.
Returns the nth Species in this ListOfSpecies.
@see size()


=item ListOfSpecies::get

Get a Species from the ListOfSpecies.
@param n the index number of the Species to get.
Returns the nth Species in this ListOfSpecies.
@see size()


=item ListOfSpecies::get

Get a Species from the ListOfSpecies
based on its identifier.
@param sid a string representing the identifier 
of the Species to get.
Returns Species in this ListOfSpecies
with the given id or NULL if no such
Species exists.
@see get(unsigned int n)
@see size()


=item ListOfSpecies::get

Get a Species from the ListOfSpecies
based on its identifier.
@param sid a string representing the identifier 
of the Species to get.
Returns Species in this ListOfSpecies
with the given id or NULL if no such
Species exists.
@see get(unsigned int n)
@see size()


=item ListOfSpecies::remove

Removes the nth item from this ListOfSpeciess items and returns a pointer to
it.

The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove
@see size()


=item ListOfSpecies::remove

Removes item in this ListOfSpeciess items with the given identifier.
The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier C<sid>, then @c
NULL is returned.
@param sid the identifier of the item to remove
Returns the item removed.  As mentioned above, the caller owns the
returned item.


=item ListOfSpecies::getElementPosition

Get the ordinal position of this element in the containing object
(which in this case is the Model object).
The ordering of elements in the XML form of SBML is generally fixed
for most components in SBML.  So, for example, the ListOfSpeciess in
a model is (in SBML Level&nbsp;2 Version&nbsp;4) the sixth
ListOf___.  (However, it differs for different Levels and Versions of
SBML.)

Returns the ordinal position of the element with respect to its
siblings, or C<-1> (default) to indicate the position is not significant.
@deprecated libSBML internal


=item ListOfSpecies::createObject

Returns the SBML object corresponding to next XMLToken in the
XMLInputStream or NULL if the token was not recognized.
@deprecated libSBML internal


=back

=head2 Parameter

LibSBML implementation of SBML's Parameter construct.
A Parameter is used in SBML to define a symbol associated with a value;
this symbol can then be used in mathematical formulas in a model.  By
default, parameters have constant value for the duration of a
simulation, and for this reason are called I<parameters> instead of @em
variables in SBML, although it is crucial to understand that <em>%SBML
parameters represent both concepts</em>.  Whether a given SBML
parameter is intended to be constant or variable is indicated by the
value of its "constant" attribute.
SBML's Parameter has one required attribute, "id", to give the
parameter a unique identifier by which other parts of an SBML model
definition can refer to it.  A parameter can also have an optional
"name" attribute of type C<string>.  Identifiers and names must be used
according to the guidelines described in the SBML specification (e.g.,
Section 3.3 in the Level&nbsp;2 Version&nbsp;4 specification).
The optional attribute "value" determines the value (of type C<double>)
assigned to the identifier.  A missing value for "value" implies that
the value either is unknown, or to be obtained from an external source,
or determined by an initial assignment.  The units associated with the
value of the parameter are specified by the attribute named "units".
The value assigned to the parameter's "units" attribute must be chosen
from one of the following possibilities: one of the base unit
identifiers defined in SBML; one of the built-in unit identifiers @c
"substance", C<"time">, C<"volume">, C<"area"> or C<"length">; or the
identifier of a new unit defined in the list of unit definitions in the
enclosing Model structure.  There are no constraints on the units that
can be chosen from these sets.  There are no default units for
parameters.  Please consult the SBML specification documents for more
details about the meanings and implications of the various unit choices.
The Parameter structure has an optional boolean attribute named
"constant" that indicates whether the parameter's value can vary during
a simulation.  The attribute's default value is C<true>.  A value of @c
false indicates the parameter's value can be changed by Rule constructs
and that the "value" attribute is actually intended to be the initial
value of the parameter. Parameters local to a reaction (that is, those
defined within the KineticLaw structure of a Reaction) cannot be changed
by rules and therefore are implicitly always constant; thus, parameter
definitions within Reaction structures should I<not> have their
"constant" attribute set to C<false>.
What if a global parameter has its "constant" attribute set to C<false>,
but the model does not contain any rules, events or other constructs
that ever change its value over time?  Although the model may be
suspect, this situation is not strictly an error.  A value of C<false>
for "constant" only indicates that a parameter I<can> change value, not
that it I<must>.
As with all other major SBML components, Parameter is derived from
SBase, and the methods defined on SBase are available on Parameter.
@see ListOfParameters
@see KineticLaw
@note The use of the term I<parameter> in SBML sometimes leads to
confusion among readers who have a particular notion of what something
called "parameter" should be.  It has been the source of heated debate,
but despite this, no one has yet found an adequate replacement term that
does not have different connotations to different people and hence leads
to confusion among I<some> subset of users.  Perhaps it would have been
better to have two constructs, one called I<constants> and the other
called I<variables>.  The current approach in SBML is simply more
parsimonious, using a single Parameter construct with the boolean flag
"constant" indicating which flavor it is.  In any case, readers are
implored to look past their particular definition of a I<parameter> and
simply view SBML's Parameter as a single mechanism for defining both
constants and (additional) variables in a model.  (We write @em
additional because the species in a model are usually considered to be
the central variables.)  After all, software tools are not required to
expose to users the actual names of particular SBML constructs, and
thus tools can present to their users whatever terms their designers
feel best matches their target audience.
<!-- leave this next break as-is to work around some doxygen bug -->


=over

=back

=head2 ListOfParameters

LibSBML implementation of SBML's ListOfParameters construct.
The various ListOf___ classes in SBML are merely containers used for
organizing the main components of an SBML model.  All are derived from
the abstract class SBase, and inherit the various attributes and
subelements of SBase, such as "metaid" as and "annotation".  The
ListOf___ classes do not add any attributes of their own.
The relationship between the lists and the rest of an SBML model is
illustrated by the following (for SBML Level&nbsp;2 Version&nbsp;4):
@image html listof-illustration.jpg "ListOf___ elements in an SBML Model"
@image latex listof-illustration.jpg "ListOf___ elements in an SBML Model"
Readers may wonder about the motivations for using the ListOf___
containers.  A simpler approach in XML might be to place the components
all directly at the top level of the model definition.  We chose instead
to group them within XML elements named after ListOf<em>Classname</em>,
in part because we believe this helps organize the components and makes
visual reading of models in XML easier.  More importantly, the fact that
the container classes are derived from SBase means that software tools
can add information about the lists themselves into each list
container's "annotation".
@see ListOfFunctionDefinitions
@see ListOfUnitDefinitions
@see ListOfCompartmentTypes
@see ListOfSpeciesTypes
@see ListOfCompartments
@see ListOfSpecies
@see ListOfParameters
@see ListOfInitialAssignments
@see ListOfRules
@see ListOfConstraints
@see ListOfReactions
@see ListOfEvents


=over

=item Parameter::Parameter

Creates a new Parameter, optionally with the given C<id> and C<name>
attribute values.
@param id a string, the identifier to assign to this Parameter
@param name a string, the optional name to assign to this Parameter
@note It is worth emphasizing that although the identifier is optional
for this constructor, in SBML Level&nbsp;2 and beyond, the "id"
(identifier) attribute of a Parameter is required to have a value.
Thus, callers are cautioned to assign a value after calling this
constructor if no identifier is provided as an argument.  Setting the
identifier can be accomplished using the method @if clike
SBase::setId() @endif@if java SBase::setId(String id)
@endif

@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item Parameter::Parameter

Creates a new Parameter with the given C<id> and C<value> attribute
values, and optionally with the given C<units> and C<constant>
attribute values.
In contrast to the other constructors for this class, the C<id>
(identifier) and C<value> parameters are required in this call.
@param id a string, the identifier to assign to this Parameter instance
@param value a double, the value to assign to this Parameter
@param units a string, an optional identifier for units to be assigned
to this Parameter
@param constant a boolean, the optional value to assign to the
"constant" attribute of this Parameter instance
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item Parameter::Parameter

Creates a new Parameter using the given SBML C<level> and C<version>
values and optionally a set of XMLNamespaces.
It is worth emphasizing that although this constructor does not take
an identifier argument, in SBML Level&nbsp;2 and beyond, the "id"
(identifier) attribute of a Parameter is required to have a value.
Thus, callers are cautioned to assign a value after calling this
constructor if no identifier is provided as an argument.  Setting the
identifier can be accomplished using the method @if clike
SBase::setId(). @endif@if java SBase::setId(String id).
@endif

@param level an unsigned int, the SBML Level to assign to this Parameter
@param version an unsigned int, the SBML Version to assign to this
Parameter

@param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
assign to this Parameter
@note Once a Parameter has been added to an SBMLDocument, the C<level>,
C<version> and C<xmlns> namespaces for the document I<override> those used
to create the Parameter.  Despite this, the ability to supply the values
at creation time is an important aid to creating valid SBML.  Knowledge of
the intented SBML Level and Version determine whether it is valid to
assign a particular value to an attribute, or whether it is valid to add
an object to an existing SBMLDocument.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.

@deprecated libSBML internal


=item Parameter::Parameter

Copy constructor; creates a copy of a Parameter.
@param orig the Parameter instance to copy.


=item Parameter::accept

Accepts the given SBMLVisitor for this instance of Parameter.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>, which indicates
whether the Visitor would like to visit the next Parameter in the list
of parameters within which this Parameter is embedded (i.e., either
the list of parameters in the parent Model or the list of parameters
in the enclosing KineticLaw).


=item Parameter::clone

Creates and returns a deep copy of this Parameter.
Returns a (deep) copy of this Parameter.


=item Parameter::initDefaults

Initializes the fields of this Parameter to the defaults defined in
the specification of the relevant Level/Version of SBML.
The exact actions of this are as follows:

=over


=item

(%SBML Level&nbsp;2 only) set the "constant" attribute to C<true>.

=back




=item Parameter::getValue

Gets the numerical value of this Parameter.
Returns the value of the "value" attribute of this Parameter, as a
number of type C<double>.
@see isSetValue()
@note B<It is crucial> that callers not blindly call
Parameter::getValue() without first checking with
Parameter::isSetValue() to determine whether a value has been set.
Otherwise, the value return by Parameter::getValue() may not actually
represent a value assigned to the parameter.


=item Parameter::getUnits

Gets the units defined for this Parameter
Returns the value of the "units" attribute of this Parameter, as a
string.



=item Parameter::getConstant

Gets the value of the "constant" attribute of this Parameter instance.
Note that in SBML Level&nbsp;2 and beyond, the default value of
Parameter's "constant" attribute is C<true>.  Since a boolean value
can only be true or value, there is no Parameter::isSetConstant()
method as is available for the other attributes on Parameter.
Returns C<true> if this Parameter has been declared as being constant,
C<false> otherwise.


=item Parameter::isSetValue

Predicate returning C<true> or C<false> depending on whether the
"value" attribute of this Parameter has been set.
@htmlinclude libsbml-comment-set-methods.html
In SBML definitions after SBML Level&nbsp;1 Version&nbsp;1,
parameter values are optional and have no defaults.  If a model read
from a file does not contain a setting for the "value" attribute of a
parameter, its value is considered unset; it does not default to any
particular value.  Similarly, when a Parameter object is created in
libSBML, it has no value until given a value.  The
Parameter::isSetValue() method allows calling applications to
determine whether a given parameter's value has ever been set.
In SBML Level&nbsp;1 Version&nbsp;1, parameters are required to have
values and therefore, the value of a Parameter B<should always be
set>.  In Level&nbsp;1 Version&nbsp;2 and beyond, the value is
optional and as such, the "value" attribute may or may not be set.
Returns C<true> if the value of this Parameter has been set,
C<false> otherwise.
@see getValue()
@note B<It is crucial> that callers not blindly call
Parameter::getValue() without first checking with
Parameter::isSetValue() to determine whether a value has been set.
Otherwise, the value return by Parameter::getValue() may not actually
represent a value assigned to the parameter.


=item Parameter::isSetUnits

Predicate returning C<true> or C<false> depending on whether the
"units" attribute of this Parameter has been set.
@htmlinclude libsbml-comment-set-methods.html
Returns C<true> if the "units" attribute of this Parameter has been
set, C<false> otherwise.


=item Parameter::setValue

Sets the "value" attribute of this Parameter to the given C<double>
value and marks the attribute as set.
@htmlinclude libsbml-comment-set-methods.html
@param value a C<double>, the value to assign


=item Parameter::setUnits

Sets the "units" attribute of this Parameter to a copy of the given
units identifier C<units>.
@htmlinclude libsbml-comment-set-methods.html
@param units a string, the identifier of the units to assign to this
Parameter instance


=item Parameter::setConstant

Sets the "constant" attribute of this Parameter to the given boolean
C<flag>.
@param flag a boolean, the value for the "constant" attribute of this
Parameter instance


=item Parameter::unsetValue

Unsets the "value" attribute of this Parameter instance.
@htmlinclude libsbml-comment-set-methods.html
In SBML Level&nbsp;1 Version&nbsp;1, parameters are required to have
values and therefore, the value of a Parameter B<should always be
set>.  In SBML Level&nbsp;1 Version&nbsp;2 and beyond, the value
is optional and as such, the "value" attribute may or may not be set.


=item Parameter::unsetUnits

Unsets the "units" attribute of this Parameter instance.
@htmlinclude libsbml-comment-set-methods.html


=item Parameter::getDerivedUnitDefinition

Constructs and returns a UnitDefinition that corresponds to the units
of this Parameter's value.
Parameters in SBML have an attribute ("units") for declaring the units
of measurement intended for the parameter's value.  B<No defaults are
defined> by SBML in the absence of a definition for "units".  The
Parameter::getDerivedUnitDefinition() method returns a UnitDefinition
object based on the units declared for this Parameter using its
"units" attribute, or it returns NULL if no units have been declared.
Note that unit declarations for Parameter are in terms of the @em
identifier of a unit, but this method returns a UnitDefinition object,
not a unit identifier.  It does this by constructing an appropriate
UnitDefinition even when the value of the "units" attribute is one of
the predefined SBML units C<"substance">, C<"volume">, C<"area">, @c
"length" or C<"time">.  Callers may find this particularly useful
when used in conjunction with the helper methods on UnitDefinition
for comparing different UnitDefinition objects.
Returns a UnitDefinition that expresses the units of this 
Parameter.



=item Parameter::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for this object, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item Parameter::getElementName

Returns the XML element name of this object, which for Parameter, is
always C<"parameter">.
Returns the name of this element, i.e., C<"parameter">.


=item Parameter::readAttributes

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.
@deprecated libSBML internal


=item Parameter::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Parameter::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Parameter::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Parameter::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Parameter::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item ListOfParameters::clone

Creates and returns a deep copy of this ListOfParameters instance.
Returns a (deep) copy of this ListOfParameters.


=item ListOfParameters::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for this object, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item ListOfParameters::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., Parameter objects, if the list is non-empty).
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for the objects contained in this ListOf
instance, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item ListOfParameters::getElementName

Returns the XML element name of this object.
For ListOfParameters, the XML element name is C<"listOfParameters">.
Returns the name of this element, i.e., C<"listOfParameters">.


=item ListOfParameters::get

Get a Parameter from the ListOfParameters.
@param n the index number of the Parameter to get.
Returns the nth Parameter in this ListOfParameters.
@see size()


=item ListOfParameters::get

Get a Parameter from the ListOfParameters.
@param n the index number of the Parameter to get.
Returns the nth Parameter in this ListOfParameters.
@see size()


=item ListOfParameters::get

Get a Parameter from the ListOfParameters
based on its identifier.
@param sid a string representing the identifier 
of the Parameter to get.
Returns Parameter in this ListOfParameters
with the given id or NULL if no such
Parameter exists.
@see get(unsigned int n)
@see size()


=item ListOfParameters::get

Get a Parameter from the ListOfParameters
based on its identifier.
@param sid a string representing the identifier 
of the Parameter to get.
Returns Parameter in this ListOfParameters
with the given id or NULL if no such
Parameter exists.
@see get(unsigned int n)
@see size()


=item ListOfParameters::remove

Removes the nth item from this ListOfParameters items and returns a pointer to
it.

The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove
@see size()


=item ListOfParameters::remove

Removes item in this ListOfParameters items with the given identifier.
The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier C<sid>, then @c
NULL is returned.
@param sid the identifier of the item to remove
Returns the item removed.  As mentioned above, the caller owns the
returned item.


=item ListOfParameters::getElementPosition

Get the ordinal position of this element in the containing object
(which in this case is the Model object).
The ordering of elements in the XML form of SBML is generally fixed
for most components in SBML.  So, for example, the ListOfParameters
in a model is (in SBML Level&nbsp;2 Version&nbsp;4) the seventh
ListOf___.  (However, it differs for different Levels and Versions of
SBML.)

Returns the ordinal position of the element with respect to its
siblings, or C<-1> (default) to indicate the position is not significant.
@deprecated libSBML internal


=item ListOfParameters::createObject

Create a ListOfParameters object corresponding to the next token in
the XML input stream.
Returns the SBML object corresponding to next XMLToken in the
XMLInputStream, or C<NULL> if the token was not recognized.
@deprecated libSBML internal


=back

=head2 InitialAssignment

LibSBML implementation of SBML's InitialAssignment construct.
SBML Level 2 Versions 2, 3 and 4 provide two ways of assigning initial
values to entities in a model.  The simplest and most basic is to set
the values of the appropriate attributes in the relevant components; for
example, the initial value of a model parameter (whether it is a
constant or a variable) can be assigned by setting its "value" attribute
directly in the model definition.  However, this approach is not
suitable when the value must be calculated, because the initial value
attributes on different components such as species, compartments, and
parameters are single values and not mathematical expressions.  In those
situations, the InitialAssignment construct can be used; it permits the
calculation of the value of a constant or the initial value of a
variable from the values of I<other> quantities in a model.
As explained below, the provision of InitialAssignment does not mean
that models necessarily must use this construct when defining initial
values of quantities in a model.  If a value can be set directly using
the relevant attribute of a component in a model, then that
approach may be more efficient and more portable to other software
tools.  InitialAssignment should be used when the other mechanism is
insufficient for the needs of a particular model.
The InitialAssignment construct has some similarities to AssignmentRule.
The main differences are: (a) an InitialAssignment can set the value of
a constant whereas an AssignmentRule cannot, and (b) unlike
AssignmentRule, an InitialAssignment definition only applies up to and
including the beginning of simulation time, i.e., <em>t \f$\leq\f$ 0</em>,
while an AssignmentRule applies at all times.
InitialAssignment has a required attribute, "symbol", whose value must
follow the guidelines for identifiers described in the SBML
specification (e.g., Section 3.3 in the Level 2 Version 4
specification).  The value of this attribute in an InitialAssignment
object can be the identifier of a Compartment, Species or global
Parameter elsewhere in the model.  The InitialAssignment defines the
initial value of the constant or variable referred to by the "symbol"
attribute.  (The attribute's name is "symbol" rather than "variable"
because it may assign values to constants as well as variables in a
model.)  Note that an initial assignment cannot be made to reaction
identifiers, that is, the "symbol" attribute value of an
InitialAssignment cannot be an identifier that is the "id" attribute
value of a Reaction object in the model.  This is identical to a
restriction placed on rules.
InitialAssignment also has a required "math" subelement that contains a
MathML expression used to calculate the value of the constant or the
initial value of the variable.  The units of the value computed by the
formula in the "math" subelement should (in SBML Level&nbsp;2
Version&nbsp;4) or must (in previous Versions) be identical to be the
units associated with the identifier given in the "symbol" attribute.
(That is, the units are the units of the species, compartment, or
parameter, as appropriate for the kind of object identified by the value
of "symbol".)
InitialAssignment was introduced in SBML Level 2 Version 2.  It is not
available in earlier versions of Level 2 nor in any version of Level 1.
@section initassign-semantics Semantics of Initial Assignments
The value calculated by an InitialAssignment object overrides the value
assigned to the given symbol by the object defining that symbol.  For
example, if a compartment's "size" attribute is set in its definition,
and the model also contains an InitialAssignment having that
compartment's identifier as its "symbol" attribute value, then the
interpretation is that the "size" assigned in the Compartment object
should be ignored and the value assigned based on the computation
defined in the InitialAssignment.  Initial assignments can take place
for Compartment, Species and global Parameter objects regardless of the
value of their "constant" attribute.
The actions of all InitialAssignment objects are in general terms
the same, but differ in the precise details depending on the type
of variable being set:

=over


=item

<em>In the case of a species</em>, an InitialAssignment sets the
referenced species' initial quantity (concentration or amount of
substance) to the value determined by the formula in the "math"
subelement.    The overall units of the formula should (in SBML
Level&nbsp;2 Version&nbsp;4) or must (in previous Versions) be the same
as the units specified for the species.

=item

<em>In the case of a compartment</em>, an InitialAssignment sets
the referenced compartment's initial size to the size determined by the
formula in "math".  The overall units of the formula should (in SBML
Level&nbsp;2 Version&nbsp;4) or must (in previous Versions) be the same
as the units specified for the size of the compartment.

=item

<em>In the case of a parameter</em>, an InitialAssignment sets the
referenced parameter's initial value to that determined by the formula
in "math".  The overall units of the formula should (in SBML
Level&nbsp;2 Version&nbsp;4) or must (in previous Versions) be the same
as the units defined for the parameter.  
=back

In the context of a simulation, initial assignments establish values
that are in effect prior to and including the start of simulation time,
i.e., <em>t \f$\leq\f$ 0</em>.  Section 3.4.8 in the SBML Level 2
Version 4 specification provides information about the interpretation of
assignments, rules, and entity values for simulation time up to and
including the start time <em>t = 0</em>; this is important for
establishing the initial conditions of a simulation if the model
involves expressions containing the <em>delay</em> "csymbol".
There cannot be two initial assignments for the same symbol in a model;
that is, a model must not contain two or more InitialAssignment objects
that both have the same identifier as their "symbol" attribute value.  A
model must also not define initial assignments <em>and</em> assignment
rules for the same entity.  That is, there cannot be <em>both</em> an
InitialAssignment and an AssignmentRule for the same symbol in a model,
because both kinds of constructs apply prior to and at the start of
simulated time&mdash;allowing both to exist for a given symbol would
result in indeterminism).
The ordering of InitialAssignment objects is not significant.  The
combined set of InitialAssignment, AssignmentRule and KineticLaw
objects form a set of assignment statements that must be considered as a
whole.  The combined set of assignment statements should not contain
algebraic loops: a chain of dependency between these statements should
terminate.  (More formally, consider the directed graph of assignment
statements where nodes are a model's assignment statements and directed
arcs exist for each occurrence of a symbol in an assignment statement
"math" attribute.  The directed arcs in this graph start from the
statement assigning the symbol and end at the statement that contains
the symbol in their math elements.  Such a graph must be acyclic.)
Finally, it is worth being explicit about the expected behavior in the
following situation.  Suppose (1) a given symbol has a value <em>x</em>
assigned to it in its definition, and (2) there is an initial assignment
having the identifier as its "symbol" value and reassigning the value to
<em>y</em>, <em>and</em> (3) the identifier is also used in the
mathematical formula of a second initial assignment.  What value should
the second initial assignment use?  It is <em>y</em>, the value assigned
to the symbol by the first initial assignment, not whatever value was
given in the symbol's definition.  This follows directly from the
behavior described above: if an InitialAssignment object exists for a
given symbol, then the symbol's value is overridden by that initial
assignment.

<!---------------------------------------------------------------------- -->


=over

=back

=head2 ListOfInitialAssignments

LibSBML implementation of SBML's ListOfInitialAssignments construct.
The various ListOf___ classes in SBML are merely containers used for
organizing the main components of an SBML model.  All are derived from
the abstract class SBase, and inherit the various attributes and
subelements of SBase, such as "metaid" as and "annotation".  The
ListOf___ classes do not add any attributes of their own.
The relationship between the lists and the rest of an SBML model is
illustrated by the following (for SBML Level&nbsp;2 Version&nbsp;4):
@image html listof-illustration.jpg "ListOf___ elements in an SBML Model"
@image latex listof-illustration.jpg "ListOf___ elements in an SBML Model"
Readers may wonder about the motivations for using the ListOf___
containers.  A simpler approach in XML might be to place the components
all directly at the top level of the model definition.  We chose instead
to group them within XML elements named after ListOf<em>Classname</em>,
in part because we believe this helps organize the components and makes
visual reading of models in XML easier.  More importantly, the fact that
the container classes are derived from SBase means that software tools
can add information about the lists themselves into each list
container's "annotation".
@see ListOfFunctionDefinitions
@see ListOfUnitDefinitions
@see ListOfCompartmentTypes
@see ListOfSpeciesTypes
@see ListOfCompartments
@see ListOfSpecies
@see ListOfParameters
@see ListOfInitialAssignments
@see ListOfRules
@see ListOfConstraints
@see ListOfReactions
@see ListOfEvents


=over

=item InitialAssignment::InitialAssignment

Creates a new InitialAssignment, optionally with its "symbol"
attribute set.
@param symbol an identifier to assign as the value of the "symbol"
attribute of this InitialAssignment
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item InitialAssignment::InitialAssignment

Creates a new InitialAssignment using the given SBML C<level> and C<version>
values and optionally a set of XMLNamespaces.
@param level an unsigned int, the SBML Level to assign to this InitialAssignment
@param version an unsigned int, the SBML Version to assign to this
InitialAssignment

@param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
assign to this InitialAssignment
@note Once a InitialAssignment has been added to an SBMLDocument, the C<level>,
C<version> and C<xmlns> namespaces for the document I<override> those used
to create the InitialAssignment.  Despite this, the ability to supply the values
at creation time is an important aid to creating valid SBML.  Knowledge of
the intented SBML Level and Version determine whether it is valid to
assign a particular value to an attribute, or whether it is valid to add
an object to an existing SBMLDocument.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.

@deprecated libSBML internal


=item InitialAssignment::InitialAssignment

Copy constructor; creates a copy of this InitialAssignment.


=item InitialAssignment::accept

Accepts the given SBMLVisitor for this instance of InitialAssignment.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>, which indicates
whether the Visitor would like to visit the next InitialAssignment in
the list of compartment types.


=item InitialAssignment::clone

Creates and returns a deep copy of this InitialAssignment.
Returns a (deep) copy of this InitialAssignment.


=item InitialAssignment::getSymbol

Get the value of the "symbol" attribute of this InitialAssignment.
Returns the identifier string stored as the "symbol" attribute value
in this InitialAssignment.


=item InitialAssignment::getMath

Get the mathematical formula of this InitialAssignment.
Returns an ASTNode, the value of the "math" subelement of this
InitialAssignment



=item InitialAssignment::isSetSymbol

Predicate returning C<true> or C<false> depending on whether this
InitialAssignment's "symbol" attribute has been set.
Returns C<true> if the "symbol" attribute of this InitialAssignment
has been set, C<false> otherwise.


=item InitialAssignment::isSetMath

Predicate returning C<true> or C<false> depending on whether this
InitialAssignment's "math" subelement contains a value.
Returns C<true> if the "math" for this InitialAssignment has been set,
C<false> otherwise.


=item InitialAssignment::setSymbol

Sets the "symbol" attribute value of this InitialAssignment.
@param sid the identifier of a Species, Compartment or Parameter
object defined elsewhere in this Model.


=item InitialAssignment::setMath

Sets the "math" subelement of this InitialAssignment.
The AST passed in C<math> is copied.
@param math an AST containing the mathematical expression to
be used as the formula for this InitialAssignment.


=item InitialAssignment::getDerivedUnitDefinition

Calculates and returns a UnitDefinition that expresses the units
of measurement assumed for the "math" expression of this
InitialAssignment.

The units are calculated based on the mathematical expression in the
InitialAssignment and the model quantities referenced by
C<&lt;ci&gt;> elements used within that expression.  The
getDerivedUnitDefinition() method returns the calculated units.
@warning Note that it is possible the "math" expression in the
InitialAssignment contains pure numbers or parameters with undeclared
units.  In those cases, it is not possible to calculate the units of
the overall expression without making assumptions.  LibSBML does not
make assumptions about the units, and getDerivedUnitDefinition() only
returns the units as far as it is able to determine them.  For
example, in an expression <em>X + Y</em>, if <em>X</em> has
unambiguously-defined units and <em>Y</em> does not, it will return
the units of <em>X</em>.  <strong>It is important that callers also
invoke the method</strong> containsUndeclaredUnits() <strong>to
determine whether this situation holds</strong>.  Callers may wish to
take suitable actions in those scenarios.
Returns a UnitDefinition that expresses the units of the math 
expression of this InitialAssignment.
@see containsUndeclaredUnits()


=item InitialAssignment::containsUndeclaredUnits

Predicate returning C<true> or C<false> depending on whether 
the math expression of this InitialAssignment contains
parameters/numbers with undeclared units.
Returns C<true> if the math expression of this InitialAssignment
includes parameters/numbers 
with undeclared units, C<false> otherwise.
@note A return value of C<true> indicates that the UnitDefinition
returned by getDerivedUnitDefinition() may not accurately represent
the units of the expression.
@see getDerivedUnitDefinition()


=item InitialAssignment::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for this object, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item InitialAssignment::getElementName

Returns the XML element name of this object, which for
InitialAssignment, is always C<"initialAssignment">.
Returns the name of this element, i.e., C<"initialAssignment">.


=item InitialAssignment::writeElements

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.
@deprecated libSBML internal


=item InitialAssignment::readOtherXML

Subclasses should override this method to read (and store) XHTML,
MathML, etc. directly from the XMLInputStream.
Returns true if the subclass read from the stream, false otherwise.
@deprecated libSBML internal


=item InitialAssignment::readAttributes

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.
@deprecated libSBML internal


=item InitialAssignment::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item InitialAssignment::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item ListOfInitialAssignments::clone

Creates and returns a deep copy of this ListOfInitialAssignments instance.
Returns a (deep) copy of this ListOfInitialAssignments.


=item ListOfInitialAssignments::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for this object, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item ListOfInitialAssignments::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., InitialAssignment objects, if the list is non-empty).
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for the objects contained in this ListOf
instance, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item ListOfInitialAssignments::getElementName

Returns the XML element name of this object.
For ListOfInitialAssignments, the XML element name is @c
"listOfInitialAssignments".

Returns the name of this element, i.e., C<"listOfInitialAssignments">.


=item ListOfInitialAssignments::get

Get a InitialAssignment from the ListOfInitialAssignments.
@param n the index number of the InitialAssignment to get.
Returns the nth InitialAssignment in this ListOfInitialAssignments.
@see size()


=item ListOfInitialAssignments::get

Get a InitialAssignment from the ListOfInitialAssignments.
@param n the index number of the InitialAssignment to get.
Returns the nth InitialAssignment in this ListOfInitialAssignments.
@see size()


=item ListOfInitialAssignments::get

Get a InitialAssignment from the ListOfInitialAssignments
based on its identifier.
@param sid a string representing the identifier 
of the InitialAssignment to get.
Returns InitialAssignment in this ListOfInitialAssignments
with the given id or NULL if no such
InitialAssignment exists.
@see get(unsigned int n)
@see size()


=item ListOfInitialAssignments::get

Get a InitialAssignment from the ListOfInitialAssignments
based on its identifier.
@param sid a string representing the identifier 
of the InitialAssignment to get.
Returns InitialAssignment in this ListOfInitialAssignments
with the given id or NULL if no such
InitialAssignment exists.
@see get(unsigned int n)
@see size()


=item ListOfInitialAssignments::remove

Removes the nth item from this ListOfInitialAssignments items and returns a pointer to
it.

The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove
@see size()


=item ListOfInitialAssignments::remove

Removes item in this ListOfInitialAssignments items with the given identifier.
The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier C<sid>, then @c
NULL is returned.
@param sid the identifier of the item to remove
Returns the item removed.  As mentioned above, the caller owns the
returned item.


=item ListOfInitialAssignments::getElementPosition

Get the ordinal position of this element in the containing object
(which in this case is the Model object).
The ordering of elements in the XML form of SBML is generally fixed
for most components in SBML.  So, for example, the
ListOfInitialAssignments in a model is (in SBML Level 2 Version 4)
the eigth ListOf___.  (However, it differs for different Levels and
Versions of SBML.)
Returns the ordinal position of the element with respect to its
siblings, or C<-1> (default) to indicate the position is not significant.
@deprecated libSBML internal


=item ListOfInitialAssignments::createObject

Returns the SBML object corresponding to next XMLToken in the
XMLInputStream or NULL if the token was not recognized.
@deprecated libSBML internal


=back

=head2 Rule

LibSBML implementation of SBML's Rule construct.
In SBML, I<rules> provide additional ways to define the values of
variables in a model, their relationships, and the dynamical behaviors
of those variables.  They enable encoding relationships that cannot be
expressed using Reaction nor InitialAssignment objects alone.
The libSBML implementation of rules mirrors the SBML Level&nbsp;2
Version&nbsp;4 definition, with Rule being the parent class of three
subclasses as explained below.  The Rule class itself cannot be
instantiated by user programs and has no constructor; only the
subclasses AssignmentRule, AlgebraicRule and RateRule can be
instantiated directly.
@section rules-general General summary of SBML rules
In SBML Level&nbsp;2, rules are separated into three subclasses for the
benefit of model analysis software.  The three subclasses are based on
the following three different possible functional forms (where I<x> is
a variable, I<f> is some arbitrary function returning a numerical
result, B<V> is a vector of variables that does not include I<x>,
and B<W> is a vector of variables that may include I<x>):
<center>
<table border="0" cellpadding="0" style="font-size: small">
<tr><td width="120px"><em>Algebraic:</em></td><td width="250px">left-hand side is zero</td><td><em>0 = f(B<W>)</em></td></tr>
<tr><td><em>Assignment:</em></td><td>left-hand side is a scalar:</td><td><em>x = f(B<V>)</em></td></tr>
<tr><td><em>Rate:</em></td><td>left-hand side is a rate-of-change:</td><td><em>dx/dt = f(B<W>)</em></td></tr>
</table>
</center>
In their general form given above, there is little to distinguish
between I<assignment> and I<algebraic> rules.  They are treated as
separate cases for the following reasons:

=over


=item

I<Assignment> rules can simply be evaluated to calculate
intermediate values for use in numerical methods.  They are statements
of equality that hold at all times.  (For assignments that are only
performed once, see InitialAssignment.)

=item

SBML needs to place restrictions on assignment rules, for example
the restriction that assignment rules cannot contain algebraic loops.

=item

Some simulators do not contain numerical solvers capable of solving
unconstrained algebraic equations, and providing more direct forms such
as assignment rules may enable those simulators to process models they
could not process if the same assignments were put in the form of
general algebraic equations;

=item

Those simulators that I<can> solve these algebraic equations make a
distinction between the different categories listed above; and

=item

Some specialized numerical analyses of models may only be applicable
to models that do not contain I<algebraic> rules.

=back


The approach taken to covering these cases in SBML is to define an
abstract Rule structure containing a subelement, "math", to hold the
right-hand side expression, then to derive subtypes of Rule that add
attributes to distinguish the cases of algebraic, assignment and rate
rules.  The "math" subelement must contain a MathML expression defining
the mathematical formula of the rule.  This MathML formula must return a
numerical value.  The formula can be an arbitrary expression referencing
the variables and other entities in an SBML model.
Each of the three subclasses of Rule (AssignmentRule, AlgebraicRule,
RateRule) inherit the the "math" subelement and other fields from SBase.
The AssignmentRule and RateRule classes add an additional attribute,
"variable".  See the definitions of AssignmentRule, AlgebraicRule and
RateRule for details about the structure and interpretation of each one.
@section rule-restrictions Additional restrictions on SBML rules
An important design goal of SBML rule semantics is to ensure that a
model's simulation and analysis results will not be dependent on when or
how often rules are evaluated.  To achieve this, SBML needs to place two
restrictions on rule use.  The first concerns algebraic loops in the
system of assignments in a model, and the second concerns overdetermined
systems.

@subsection rule-loops A model must not contain algebraic loops
The combined set of InitialAssignment, AssignmentRule and KineticLaw
objects in a model constitute a set of assignment statements that should
be considered as a whole.  (A KineticLaw object is counted as an
assignment because it assigns a value to the symbol contained in the
"id" attribute of the Reaction object in which it is defined.)  This
combined set of assignment statements must not contain algebraic
loops&mdash;dependency chains between these statements must terminate.
To put this more formally, consider a directed graph in which nodes are
assignment statements and directed arcs exist for each occurrence of an
SBML species, compartment or parameter symbol in an assignment
statement's "math" subelement.  Let the directed arcs point from the
statement assigning the symbol to the statements that contain the symbol
in their "math" subelement expressions.  This graph must be acyclic.
SBML does not specify when or how often rules should be evaluated.
Eliminating algebraic loops ensures that assignment statements can be
evaluated any number of times without the result of those evaluations
changing.  As an example, consider the set of equations <em>x = x +
1</em>, <em>y = z + 200</em> and <em>z = y + 100</em>.  If this set of
equations were interpreted as a set of assignment statements, it would
be invalid because the rule for <em>x</em> refers to <em>x</em>
(exhibiting one type of loop), and the rule for <em>y</em> refers to
<em>z</em> while the rule for <em>z</em> refers back to <em>y</em>
(exhibiting another type of loop).  Conversely, the following set of
equations would constitute a valid set of assignment statements: <em>x =
10</em>, <em>y = z + 200</em>, and <em>z = x + 100</em>.
@subsection rules-overdetermined A model must not be overdetermined
An SBML model must not be overdetermined; that is, a model must not
define more equations than there are unknowns in a model.  An SBML model
that does not contain AlgebraicRule structures cannot be overdetermined.
LibSBML 3.3 implements the static analysis procedure described in
Appendix D of the SBML Level&nbsp;2 Version&nbsp;4 specification for
assessing whether a model is overdetermined.
(In summary, assessing whether a given continuous, deterministic,
mathematical model is overdetermined does not require dynamic analysis;
it can be done by analyzing the system of equations created from the
model.  One approach is to construct a bipartite graph in which one set
of vertices represents the variables and the other the set of vertices
represents the equations.  Place edges between vertices such that
variables in the system are linked to the equations that determine them.
For algebraic equations, there will be edges between the equation and
each variable occurring in the equation.  For ordinary differential
equations (such as those defined by rate rules or implied by the
reaction rate definitions), there will be a single edge between the
equation and the variable determined by that differential equation.  A
mathematical model is overdetermined if the maximal matchings of the
bipartite graph contain disconnected vertexes representing equations.
If one maximal matching has this property, then all the maximal
matchings will have this property; i.e., it is only necessary to find
one maximal matching.)
<h3><a class="anchor" name="RuleType_t">RuleType_t</a></h3>
SBML Level 1 uses a different scheme than SBML Level&nbsp;2 for
distinguishing rules; specifically, it uses an attribute whose value is
drawn from an enumeration.  LibSBML supports this using methods that
work with the RuleType_t enumeration.
<center>
<table width="90%" cellspacing="1" cellpadding="1" border="0" class="normal-font">
<tr style="background: lightgray" class="normal-font">
<td><strong>Enumerator</strong></td>
<td><strong>Meaning</strong></td>
</tr>
<tr><td><em>RULE_TYPE_RATE</em></td><td>Indicates the rule is a "rate" rule.</td>
<tr><td><em>RULE_TYPE_SCALAR</em></td><td>Indicates the rule is a "scalar" rule.</td>
<tr><td><em>RULE_TYPE_UNKNOWN</em></td><td>Indicates the rule type is unknown or not
yet set.</td>
</table>
</center>
<!-- leave this next break as-is to work around some doxygen bug -->


=over

=back

=head2 AlgebraicRule

LibSBML implementation of SBML's AlgebraicRule construct.
The rule type AlgebraicRule is derived from the parent class Rule.  It
is used to express equations that are neither assignments of model
variables nor rates of change.  AlgebraicRule does not add any
attributes to the basic Rule; its role is simply to distinguish this
case from the other cases.
In the context of a simulation, algebraic rules are in effect at all
times, <em>t</em> \f$\geq\f$ <em>0</em>.  For purposes of evaluating
expressions that involve the delay "csymbol" (see the SBML
specification), algebraic rules are considered to apply also at
<em>t</em> \f$\leq\f$ <em>0</em>.  The SBML Level&nbsp;2 Version&nbsp;4
specification provides additional information about the semantics of
assignments, rules, and entity values for simulation time <em>t</em>
\f$\leq\f$ <em>0</em>.
The ability to define arbitrary algebraic expressions in an SBML model
introduces the possibility that a model is mathematically overdetermined
by the overall system of equations constructed from its rules and
reactions.  An SBML model must not be overdetermined; see the
description of Rule and also the SBML Level&nbsp;2 Version&nbsp;4
specification.  An SBML model that does not contain AlgebraicRule
structures cannot be overdetermined.
Assessing whether a given continuous, deterministic, mathematical model
is overdetermined does not require dynamic analysis; it can be done by
analyzing the system of equations created from the model.  One approach
is to construct a bipartite graph in which one set of vertices
represents the variables and the other the set of vertices represents
the equations.  Place edges between vertices such that variables in the
system are linked to the equations that determine them.  For algebraic
equations, there will be edges between the equation and each variable
occurring in the equation.  For ordinary differential equations (such as
those defined by rate rules or implied by the reaction rate
definitions), there will be a single edge between the equation and the
variable determined by that differential equation.  A mathematical model
is overdetermined if the maximal matchings of the bipartite graph
contain disconnected vertexes representing equations.  (If one maximal
matching has this property, then all the maximal matchings will have
this property; i.e., it is only necessary to find one maximal matching.)
Appendix D of the SBML Level&nbsp;2 Version&nbsp;4 specification
describes a method of applying this procedure to specific SBML data
objects.


<!-- leave this next break as-is to work around some doxygen bug -->


=over

=back

=head2 AssignmentRule

LibSBML implementation of SBML's AssignmentRule construct.
The rule type AssignmentRule is derived from the parent class Rule.  It
is used to express equations that set the values of variables.  The
left-hand side (the attribute named "variable") of an assignment rule
can refer to the identifier of a Species, Compartment, or Parameter
object in the model (but not a Reaction).  The entity identified must
not have its "constant" attribute set to C<true>.  The effects of an
AssignmentRule are in general terms the same, but differ in the precise
details depending on the type of variable being set:

=over


=item

<em>In the case of a species</em>, an AssignmentRule sets the
referenced species' quantity (I<concentration> or <em>amount of
substance</em>) to the value determined by the formula in the subelement
"math" of the AssignmentRule object.  The units of the formula in "math"
should (in SBML Level&nbsp;2 Version&nbsp;4) or must (in previous
Versions) be the same as the <em>units of the species</em> for the
species identified by the "variable" attribute of the AssignmentRule.
<em>Restrictions</em>: There must not be both an AssignmentRule
"variable" attribute and a SpeciesReference "species" attribute having
the same value, unless that species has its "boundaryCondition"
attribute set to C<true>.  In other words, an assignment rule cannot be
defined for a species that is created or destroyed in a reaction unless
that species is defined as a boundary condition in the model.

=item

<em>In the case of a compartment</em>, an AssignmentRule sets the
referenced compartment's size to the value determined by the formula in
the "math" subelement of the AssignmentRule object.  The overall units
of the formula in "math" should (in SBML Level&nbsp;2 Version&nbsp;4) or
must (in previous Versions) be the same as the units of the size of the
compartment.


=item

<em>In the case of a parameter</em>, an AssignmentRule sets the
referenced parameter's value to that determined by the formula in the
"math" subelement of the AssignmentRule object.  The overall units of
the formula in the "math" subelement should (in SBML Level&nbsp;2
Version&nbsp;4) or must (in previous Versions) be the same as the units
defined for the parameter.  
=back

In the context of a simulation, assignment rules are in effect at all
times, <em>t</em> \f$\geq\f$ <em>0</em>.  For purposes of evaluating
expressions that involve the <em>delay</em> "csymbol" (see the SBML
Level&nbsp;2 specification), assignment rules are considered to apply
also at <em>t</em> \f$\leq\f$ <em>0</em>.  The SBML Level&nbsp;2
Version&nbsp;4 specification provides additional information about the
semantics of assignments, rules, and entity values for simulation time
<em>t</em> \f$\leq\f$ <em>0</em>.
A model must not contain more than one AssignmentRule or RateRule
object having the same value of "variable"; in other words, in the set
of all assignment rules and rate rules in an SBML model, each variable
appearing in the left-hand sides can only appear once.  This simply
follows from the fact that an indeterminate system would result if a
model contained more than one assignment rule for the same variable or
both an assignment rule and a rate rule for the same variable.
Similarly, a model must also not contain <em>both</em> an AssignmentRule
and an InitialAssignment for the same variable, because both kinds of
constructs apply prior to and at the start of simulation time, i.e.,
<em>t</em> \f$\leq\f$ <em>0</em>.  If a model contained both an initial
assignment and an assignment rule for the same variable, an
indeterminate system would result.
The value calculated by an AssignmentRule object overrides the value
assigned to the given symbol by the object defining that symbol.  For
example, if a Compartment's "size" attribute value is set in its
definition, and the model also contains an AssignmentRule having that
compartment's "id" as its "variable" value, then the "size" assigned in
the Compartment definition is ignored and the value assigned based on
the computation defined in the AssignmentRule.  This does <em>not</em>
mean that a definition for a given symbol can be omitted if there is an
AssignmentRule object for it.  For example, there must be a Parameter
definition for a given parameter if there is an AssignmentRule for that
parameter.  It is only a question of which value definition takes
precedence.


<!-- leave this next break as-is to work around some doxygen bug -->


=over

=back

=head2 RateRule

LibSBML implementation of SBML's RateRule construct.
The rule type RateRule is derived from the parent class Rule.  It is
used to express equations that determine the rates of change of
variables.  The left-hand side (the "variable" attribute) can refer to
the identifier of a species, compartment, or parameter (but not a
reaction).  The entity identified must have its "constant" attribute set
to C<false>.  The effects of a RateRule are in general terms the same,
but differ in the precise details depending on which variable is being
set:

=over


=item

<em>In the case of a species</em>, a RateRule sets the rate of
change of the species' quantity (<em>concentration</em> or <em>amount of
substance</em>) to the value determined by the formula in the "math"
subelement of the RateRule object.  The overall units of the formula in
"math" should (in SBML Level&nbsp;2 Version&nbsp;4) or must (in previous
Versions) be <em>species quantity</em>/<em>time</em>, where the
<em>time</em> units are the SBML predefined units of time and the
<em>species quantity</em> units are the <em>units of the species</em>.
<em>Restrictions</em>: There must not be both a RateRule "variable"
attribute and a SpeciesReference "species" attribute having the same
value, unless that species has its "boundaryCondition" attribute is set
to C<true>.  This means a rate rule cannot be defined for a species that
is created or destroyed in a reaction, unless that species is defined as
a boundary condition in the model.

=item

<em>In the case of a compartment</em>, a RateRule sets the rate of
change of the compartment's size to the value determined by the formula
in the "math" subelement of the RateRule object.  The overall units of
the formula should (in SBML Level&nbsp;2 Version&nbsp;4) or must (in previous
Versions) be <em>size</em>/<em>time</em>, where the <em>time</em>
units are the SBML predefined units of time and the <em>size</em> units
are the units of size on the compartment.

=item

<em>In the case of a parameter</em>, a RateRule sets the rate of
change of the parameter's value to that determined by the formula in the
"math" subelement of the RateRule object.  The overall units of the
formula should (in SBML Level&nbsp;2 Version&nbsp;4) or must (in previous
Versions) be <em>x</em>/<em>time</em>, where <em>x</em> are the units
of the parameter.

=back


In the context of a simulation, rate rules are in effect for simulation
time <em>t</em> &lt; <em>0</em>.  The SBML Level&nbsp;2 Version&nbsp;4
specification provides additional information about the semantics of
assignments, rules, and entity values for simulation time <em>t</em>
\f$\leq\f$ <em>0</em>.
As mentioned in the description of AssignmentRule, a model must not
contain more than one RateRule or AssignmentRule object having the same
value of "variable"; in other words, in the set of all assignment rules
and rate rules in an SBML model, each variable appearing in the
left-hand sides can only appear once.  This simply follows from the fact
that an indeterminate system would result if a model contained more than
one assignment rule for the same variable or both an assignment rule and
a rate rule for the same variable.
<!-- leave this next break as-is to work around some doxygen bug -->


=over

=back

=head2 ListOfRules

LibSBML implementation of SBML's ListOfRules construct.
The various ListOf___ classes in SBML are merely containers used for
organizing the main components of an SBML model.  All are derived from
the abstract class SBase, and inherit the various attributes and
subelements of SBase, such as "metaid" as and "annotation".  The
ListOf___ classes do not add any attributes of their own.
The relationship between the lists and the rest of an SBML model is
illustrated by the following (for SBML Level&nbsp;2 Version&nbsp;4):
@image html listof-illustration.jpg "ListOf___ elements in an SBML Model"
@image latex listof-illustration.jpg "ListOf___ elements in an SBML Model"
Readers may wonder about the motivations for using the ListOf___
containers.  A simpler approach in XML might be to place the components
all directly at the top level of the model definition.  We chose instead
to group them within XML elements named after ListOf<em>Classname</em>,
in part because we believe this helps organize the components and makes
visual reading of models in XML easier.  More importantly, the fact that
the container classes are derived from SBase means that software tools
can add information about the lists themselves into each list
container's "annotation".
@see ListOfFunctionDefinitions
@see ListOfUnitDefinitions
@see ListOfCompartmentTypes
@see ListOfSpeciesTypes
@see ListOfCompartments
@see ListOfSpecies
@see ListOfParameters
@see ListOfInitialAssignments
@see ListOfRules
@see ListOfConstraints
@see ListOfReactions
@see ListOfEvents


=over

=item Rule::Rule

Copy constructor; creates a copy of this Rule.


=item Rule::accept

Accepts the given SBMLVisitor for this instance of Rule.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>.


=item Rule::clone

Creates and returns a deep copy of this Rule.
Returns a (deep) copy of this Rule.


=item Rule::getFormula

Returns the mathematical expression of this Rule in text-string form.
Returns the formula for this Rule.


=item Rule::getMath

Get the mathematical formula of this Rule.
Returns an ASTNode, the value of the "math" subelement of this Rule


=item Rule::getVariable

Get the value of the "variable" attribute of this Rule.
This applies to AssignmentRule and RateRule, which have explicit
left-hand sides in their equations.  AlgebraicRule does not have a
variable field.
Returns the identifier string stored as the "variable" attribute value
in this Rule.


=item Rule::getUnits

(SBML Level&nbsp;1 ParameterRule only) Returns the units for the
mathematical formula of this Rule.
Returns the identifier of the units for the expression of this Rule


=item Rule::isSetFormula

Predicate returning C<true> or C<false> depending on whether this
Rule's mathematical expression has been set.
This method is equivalent to isSetMath().  This version is present for
easier compatibility with SBML Level&nbsp;1, in which mathematical
formulas were written in text-string form.
Returns C<true> if the mathematical formula for this Rule has been
set, C<false> otherwise.


=item Rule::isSetMath

Predicate returning C<true> or C<false> depending on whether this
Rule's mathematical expression has been set.
This method is equivalent to isSetFormula().
Returns C<true> if the formula (or equivalently the math) for this
Rule has been set, C<false> otherwise.


=item Rule::isSetVariable

Predicate returning C<true> or C<false> depending on whether this
Rule's "variable" attribute has been set.
Returns C<true> if the variable of this Rule has been set, C<false>
otherwise.



=item Rule::isSetUnits

(SBML Level&nbsp;1 ParameterRule only) Predicate returning C<true> or @c
false depending on whether this Rule's "units" attribute has been set.
@htmlinclude libsbml-comment-set-methods.html
Returns C<true> if the units for this Rule has been set, C<false>
otherwise



=item Rule::setFormula

Sets the "math" subelement of this Rule to an expression in
text-string form.
This is equivalent to setMath().  The provision of using text-string
formulas is retained for easier SBML Level&nbsp;1 compatibility.  The
formula is converted to an ASTNode internally.
@param formula a mathematical formula in text-string form.


=item Rule::setMath

Sets the "math" subelement of this Rule to a copy of the given
ASTNode.

@param math the ASTNode structure of the mathematical formula.


=item Rule::setVariable

Sets the "variable" attribute of this Rule.
@param sid the identifier of a Compartment, Species or Parameter
elsewhere in the enclosing Model object.


=item Rule::setUnits

(SBML Level&nbsp;1 ParameterRule only) Sets the units for this Rule.
@htmlinclude libsbml-comment-set-methods.html
@param sname the identifier of the units


=item Rule::unsetUnits

(SBML Level&nbsp;1 ParameterRule only) Unsets the "units" for this Rule.
@htmlinclude libsbml-comment-set-methods.html


=item Rule::getDerivedUnitDefinition

Calculates and returns a UnitDefinition that expresses the units of
measurement assumed for the "math" expression of this Rule.
The units are calculated based on the mathematical expression in the
Rule and the model quantities referenced by C<&lt;ci&gt;>
elements used within that expression.  The getDerivedUnitDefinition()
method returns the calculated units.
@warning Note that it is possible the "math" expression in the Rule
contains pure numbers or parameters with undeclared units.  In those
cases, it is not possible to calculate the units of the overall
expression without making assumptions.  LibSBML does not make
assumptions about the units, and getDerivedUnitDefinition() only
returns the units as far as it is able to determine them.  For
example, in an expression <em>X + Y</em>, if <em>X</em> has
unambiguously-defined units and <em>Y</em> does not, it will return
the units of <em>X</em>.  <strong>It is important that callers also
invoke the method</strong> containsUndeclaredUnits() <strong>to
determine whether this situation holds</strong>.  Callers may wish to
take suitable actions in those scenarios.
Returns a UnitDefinition that expresses the units of the math 
expression of this Rule.
@see containsUndeclaredUnits()


=item Rule::containsUndeclaredUnits

Predicate returning C<true> or C<false> depending on whether 
the math expression of this Rule contains
parameters/numbers with undeclared units.
Returns C<true> if the math expression of this Rule
includes parameters/numbers 
with undeclared units, C<false> otherwise.
@note A return value of C<true> indicates that the UnitDefinition
returned by getDerivedUnitDefinition() may not accurately represent
the units of the expression.
@see getDerivedUnitDefinition()


=item Rule::getType

(SBML Level&nbsp;1) Get the type of rule this is.
Returns the rule type (a value drawn from the enumeration <a
class="el" href="#RuleType_t">RuleType_t</a>) of this Rule.  The value
will be either C<RULE_TYPE_RATE> or C<RULE_TYPE_SCALAR>.


=item Rule::isAlgebraic

Predicate returning C<true> or C<false> depending on whether this
Rule is an AlgebraicRule.
Returns C<true> if this Rule is an AlgebraicRule, C<false> otherwise.


=item Rule::isAssignment

Predicate returning C<true> or C<false> depending on whether this
Rule is an AssignmentRule.
Returns C<true> if this Rule is an AssignmentRule, C<false> otherwise.


=item Rule::isCompartmentVolume

(SBML Level&nbsp;1 only) Predicate returning C<true> or C<false> depending
on whether this Rule is an CompartmentVolumeRule.
Returns C<true> if this Rule is a CompartmentVolumeRule, C<false>
otherwise.



=item Rule::isParameter

(SBML Level&nbsp;1 only) Predicate returning C<true> or C<false> depending
on whether this Rule is an ParameterRule.
Returns C<true> if this Rule is a ParameterRule, C<false>
otherwise.



=item Rule::isRate

Predicate returning C<true> or C<false> depending on whether this Rule
is a RateRule (SBML Level&nbsp;2) or has a "type" attribute value of @c
"rate" (SBML Level&nbsp;1).
Returns C<true> if this Rule is a RateRule (Level&nbsp;2) or has
type "rate" (Level&nbsp;1), C<false> otherwise.


=item Rule::isScalar

Predicate returning C<true> or C<false> depending on whether this Rule
is an AssignmentRule (SBML Level&nbsp;2) or has a "type" attribute value of
C<"scalar"> (SBML Level&nbsp;1).
Returns C<true> if this Rule is an AssignmentRule (Level&nbsp;2) or has
type "scalar" (Level&nbsp;1), C<false> otherwise.


=item Rule::isSpeciesConcentration

(SBML Level&nbsp;1 only) Predicate returning C<true> or C<false> depending
on whether this Rule is an SpeciesConcentrationRule.
Returns C<true> if this Rule is a SpeciesConcentrationRule, C<false>
otherwise.



=item Rule::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for this object, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item Rule::getL1TypeCode

Returns  the SBML Level&nbsp;1 type code for this Rule, or C<SBML_UNNOWN>.
Returns the SBML Level&nbsp;1 typecode for this Rule or C<SBML_UNKNOWN>
(default).



=item Rule::getElementName

Returns the XML element name of this object, which can be any
of a number of different strings depending on the SBML Level and the
kind of rule this is.
The rules as of libSBML 3.0.0 are the following:

=over


=item

(Level&nbsp;2) RateRule: returns C<"rateRule">

=item

(Level&nbsp;2) AssignmentRule: returns C<"assignmentRule"> 

=item

(Level&nbsp;2) AlgebraicRule: returns C<"algebraicRule">

=item

(Level&nbsp;1 Version&nbsp;1) SpecieConcentrationRule: returns C<"specieConcentrationRule">

=item

(Level&nbsp;1 Version&nbsp;2) SpeciesConcentrationRule: returns C<"speciesConcentrationRule">

=item

(Level&nbsp;1) CompartmentVolumeRule: returns C<"compartmentVolumeRule">

=item

(Level&nbsp;1) ParameterRule: returns C<"parameterRule">

=item

Unknown rule type: returns C<"unknownRule">

=back


Returns the name of this element


=item Rule::writeElements

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.
@deprecated libSBML internal


=item Rule::setL1TypeCode

Sets the SBML Level&nbsp;1 typecode for this Rule.
@deprecated libSBML internal


=item Rule::Rule

Only subclasses may create Rules.
@deprecated libSBML internal


=item Rule::Rule

Only subclasses may create Rules.
@deprecated libSBML internal


=item Rule::readOtherXML

Subclasses should override this method to read (and store) XHTML,
MathML, etc. directly from the XMLInputStream.
Returns true if the subclass read from the stream, false otherwise.
@deprecated libSBML internal


=item Rule::readAttributes

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.
@deprecated libSBML internal


=item Rule::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Rule::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Rule::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Rule::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Rule::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Rule::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Rule::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item AlgebraicRule::AlgebraicRule

Creates a new AlgebraicRule, optionally with the given mathematical
formula expressed in text-string form.
This is equivalent to the constructor that takes an ASTNode.  It is
provided for convenience.
There exists another form of this method that allows you to use an
ASTNode as the the formula instead of the text string used by this
variant.

@param formula The algebraic expression to be placed in the rule
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item AlgebraicRule::AlgebraicRule

Creates a new AlgebraicRule and optionally sets its "math" subelement.
There exists another form of this method that allows you to use a text
string to express the formula instead of the ASTNode used by this
variant.

@param math an ASTNode containing the mathematical formula expressing
the right-hand side of the algebraic equation


=item AlgebraicRule::AlgebraicRule

Creates a new AlgebraicRule using the given SBML C<level> and C<version>
values and optionally a set of XMLNamespaces.
@param level an unsigned int, the SBML Level to assign to this AlgebraicRule
@param version an unsigned int, the SBML Version to assign to this
AlgebraicRule

@param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
assign to this AlgebraicRule
@note Once a AlgebraicRule has been added to an SBMLDocument, the C<level>,
C<version> and C<xmlns> namespaces for the document I<override> those used
to create the AlgebraicRule.  Despite this, the ability to supply the values
at creation time is an important aid to creating valid SBML.  Knowledge of
the intented SBML Level and Version determine whether it is valid to
assign a particular value to an attribute, or whether it is valid to add
an object to an existing SBMLDocument.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.

@deprecated libSBML internal


=item AlgebraicRule::clone

Creates and returns a deep copy of this Rule.
Returns a (deep) copy of this Rule.


=item AlgebraicRule::accept

Accepts the given SBMLVisitor for this instance of AlgebraicRule.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>.


=item AlgebraicRule::setInternalIdOnly

sets the mInternalIdOnly flag
@deprecated libSBML internal


=item AlgebraicRule::getInternalIdOnly

sets the mInternalIdOnly flag
@deprecated libSBML internal


=item AlgebraicRule::getInternalIdOnly

sets the mInternalIdOnly flag
@deprecated libSBML internal


=item AssignmentRule::AssignmentRule

Creates a new AssignmentRule and optionally sets its variable and
math.

There exists another form of this method that allows you to use an
ASTNode as the the formula instead of the text string used by this
variant.

@param variable the identifier of the variable (a Compartment, Species
or Parameter elsewhere in this Model object) that is being assigned
@param formula the mathematical formula placed in the assignment rule,
written as a text string.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item AssignmentRule::AssignmentRule

Creates a new AssignmentRule with a given C<variable> and mathematical
expression.

There exists another form of this method that allows you to use a text
string to express the formula instead of the ASTNode used by this
variant.

@param variable the identifier of the variable (a Compartment, Species
or Parameter elsewhere in this Model object) that is being assigned
@param math an ASTNode containing the mathematical formula
expressing the right-hand side of the assignment equation


=item AssignmentRule::AssignmentRule

Creates a new AssignmentRule using the given SBML C<level> and C<version>
values and optionally a set of XMLNamespaces.
@param level an unsigned int, the SBML Level to assign to this AssignmentRule
@param version an unsigned int, the SBML Version to assign to this
AssignmentRule

@param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
assign to this AssignmentRule
@note Once a AssignmentRule has been added to an SBMLDocument, the C<level>,
C<version> and C<xmlns> namespaces for the document I<override> those used
to create the AssignmentRule.  Despite this, the ability to supply the values
at creation time is an important aid to creating valid SBML.  Knowledge of
the intented SBML Level and Version determine whether it is valid to
assign a particular value to an attribute, or whether it is valid to add
an object to an existing SBMLDocument.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.

@deprecated libSBML internal


=item AssignmentRule::clone

Creates and returns a deep copy of this Rule.
Returns a (deep) copy of this Rule.


=item AssignmentRule::accept

Accepts the given SBMLVisitor for this instance of AssignmentRule.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>.


=item RateRule::RateRule

Creates a new RateRule and optionally sets its variable and formula.
There exists another form of this method that allows you to use an
ASTNode as the the formula instead of the text string used by this
variant.

@param variable the identifier of the variable (a Compartment, Species
or Parameter elsewhere in this Model object) that is being assigned
@param formula the mathematical formula placed in the assignment rule,
written as a text string.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item RateRule::RateRule

Creates a new RateRule with a given C<variable> and mathematical
expression.

There exists another form of this method that allows you to use a text
string to express the formula instead of the ASTNode used by this
variant.

@param variable the identifier of the variable (a Compartment, Species
or Parameter elsewhere in this Model object)
@param math an ASTNode containing the mathematical formula
expressing the right-hand side of the rate equation


=item RateRule::RateRule

Creates a new RateRule using the given SBML C<level> and C<version>
values and optionally a set of XMLNamespaces.
@param level an unsigned int, the SBML Level to assign to this RateRule
@param version an unsigned int, the SBML Version to assign to this
RateRule

@param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
assign to this RateRule
@note Once a RateRule has been added to an SBMLDocument, the C<level>,
C<version> and C<xmlns> namespaces for the document I<override> those used
to create the RateRule.  Despite this, the ability to supply the values
at creation time is an important aid to creating valid SBML.  Knowledge of
the intented SBML Level and Version determine whether it is valid to
assign a particular value to an attribute, or whether it is valid to add
an object to an existing SBMLDocument.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.

@deprecated libSBML internal


=item RateRule::clone

Creates and returns a deep copy of this Rule.
Returns a (deep) copy of this Rule.


=item RateRule::accept

Accepts the given SBMLVisitor.
Returns the result of calling C<v.visit()>, which indicates
whether or not the Visitor would like to visit the Model's next Rule
(if available).


=item ListOfRules::clone

Creates and returns a deep copy of this ListOfRules instance.
Returns a (deep) copy of this ListOfRules.


=item ListOfRules::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for this object, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item ListOfRules::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., Rule objects, if the list is non-empty).
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for the objects contained in this ListOf
instance, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item ListOfRules::getElementName

Returns the XML element name of this object.
For ListOfRules, the XML element name is C<"listOfRules">.
Returns the name of this element, i.e., C<"listOfRules">.


=item ListOfRules::get

Get a Rule from the ListOfRules.
@param n the index number of the Rule to get.
Returns the nth Rule in this ListOfRules.
@see size()


=item ListOfRules::get

Get a Rule from the ListOfRules.
@param n the index number of the Rule to get.
Returns the nth Rule in this ListOfRules.
@see size()


=item ListOfRules::get

Get a Rule from the ListOfRules
based on its identifier.
@param sid a string representing the identifier 
of the Rule to get.
Returns Rule in this ListOfRules
with the given id or NULL if no such
Rule exists.
@see get(unsigned int n)
@see size()


=item ListOfRules::get

Get a Rule from the ListOfRules
based on its identifier.
@param sid a string representing the identifier 
of the Rule to get.
Returns Rule in this ListOfRules
with the given id or NULL if no such
Rule exists.
@see get(unsigned int n)
@see size()


=item ListOfRules::remove

Removes the nth item from this ListOfRules items and returns a pointer to
it.

The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove
@see size()


=item ListOfRules::remove

Removes item in this ListOfRules items with the given identifier.
The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier C<sid>, then @c
NULL is returned.
@param sid the identifier of the item to remove
Returns the item removed.  As mentioned above, the caller owns the
returned item.


=item ListOfRules::getElementPosition

Get the ordinal position of this element in the containing object
(which in this case is the Model object).
The ordering of elements in the XML form of SBML is generally fixed
for most components in SBML.
Returns the ordinal position of the element with respect to its
siblings, or C<-1> (default) to indicate the position is not significant.
@deprecated libSBML internal


=item ListOfRules::createObject

Returns the SBML object corresponding to next XMLToken in the
XMLInputStream or NULL if the token was not recognized.
@deprecated libSBML internal


=back

=head2 Constraint

LibSBML implementation of SBML's Constraint construct.
The Constraint object class was introduced in SBML Level 2 Version 2 as
a mechanism for stating the assumptions under which a model is designed
to operate.  The <em>constraints</em> are statements about permissible
values of different quantities in a model.  Constraints are not used to
compute dynamical values for simulation or analysis, but rather, they
serve an advisory role for simulation/analysis tools.
SBML's Constraint object class has one required attribute, "id", to
give the parameter a unique identifier by which other parts of an SBML
model definition can refer to it.  A Constraint object can also have an
optional "name" attribute of type C<string>.  Identifiers and names must
be used according to the guidelines described in the SBML specification
(e.g., Section 3.3 in the Level 2 Version 4 specification).  
Constraint has one required subelement, "math", containing a MathML
formula defining the condition of the constraint.  This formula must
return a boolean value of C<true> when the model is a <em>valid</em>
state.  The formula can be an arbitrary expression referencing the
variables and other entities in an SBML model.  The evaluation of "math"
and behavior of constraints are described in more detail below.
A Constraint structure also has an optional subelement called "message".
This can contain a message in XHTML format that may be displayed to the
user when the condition of the formula in the "math" subelement
evaluates to a value of C<false>.  Software tools are not required to
display the message, but it is recommended that they do so as a matter
of best practice.  The XHTML content within a "message" subelement must
follow the same restrictions as for the "notes" element on SBase
described in in the SBML Level 2 specification.  For example, "message"
must not contain an XML declaration or a DOCTYPE declaration, and the
permitted content can only take one of the following general forms: (1)
a complete XHTML document beginning with the element
C<&lt;html&gt;> and ending with C<&lt;/xhtml&gt;>; 
(2) the body portion of a document beginning with the element
C<&lt;body&gt;> and ending with C<&lt;/body&gt;>; or
(3) XHTML content that is permitted within a C<&lt;body&gt;> ...
C<&lt;/body&gt;> elements.  The appendix of the SBML Level 2
Version 4 specification document describes one approach to reading the
"message" subelement content.
Constraint was introduced in SBML Level 2 Version 2.  It is not
available in earlier versions of Level 2 nor in any version of Level 1.
@section constraint-semantics Semantics of Constraints
In the context of a simulation, a Constraint has effect at all times
<em>t \f$\geq\f$ 0</em>.  Each Constraint's "math" subelement is first
evaluated after any InitialAssignment definitions in a model at <em>t =
0</em> and can conceivably trigger at that point.  (In other words, a
simulation could fail a constraint immediately.)
Constraint structures <em>cannot and should not</em> be used to compute
the dynamical behavior of a model as part of, for example, simulation.
Constraints may be used as input to non-dynamical analysis, for instance
by expressing flux constraints for flux balance analysis.
The results of a simulation of a model containing a constraint are
invalid from any simulation time at and after a point when the function
given by the "math" subelement returns a value of C<false>.  Invalid
simulation results do not make a prediction of the behavior of the
biochemical reaction network represented by the model.  The precise
behavior of simulation tools is left undefined with respect to
constraints.  If invalid results are detected with respect to a given
constraint, the "message" subelement may optionally be displayed to the
user.  The simulation tool may also halt the simulation or clearly
delimit in output data the simulation time point at which the simulation
results become invalid.
SBML does not impose restrictions on duplicate Constraint definitions or
the order of evaluation of Constraint objects in a model.  It is
possible for a model to define multiple constraints all with the same
mathematical expression.  Since the failure of any constraint indicates
that the model simulation has entered an invalid state, a system is not
required to attempt to detect whether other constraints in the model
have failed once any one constraint has failed.
<!---------------------------------------------------------------------- -->


=over

=back

=head2 ListOfConstraints

LibSBML implementation of SBML's ListOfConstraints construct.
The various ListOf___ classes in SBML are merely containers used for
organizing the main components of an SBML model.  All are derived from
the abstract class SBase, and inherit the various attributes and
subelements of SBase, such as "metaid" as and "annotation".  The
ListOf___ classes do not add any attributes of their own.
The relationship between the lists and the rest of an SBML model is
illustrated by the following (for SBML Level&nbsp;2 Version&nbsp;4):
@image html listof-illustration.jpg "ListOf___ elements in an SBML Model"
@image latex listof-illustration.jpg "ListOf___ elements in an SBML Model"
Readers may wonder about the motivations for using the ListOf___
containers.  A simpler approach in XML might be to place the components
all directly at the top level of the model definition.  We chose instead
to group them within XML elements named after ListOf<em>Classname</em>,
in part because we believe this helps organize the components and makes
visual reading of models in XML easier.  More importantly, the fact that
the container classes are derived from SBase means that software tools
can add information about the lists themselves into each list
container's "annotation".
@see ListOfFunctionDefinitions
@see ListOfUnitDefinitions
@see ListOfCompartmentTypes
@see ListOfSpeciesTypes
@see ListOfCompartments
@see ListOfSpecies
@see ListOfParameters
@see ListOfInitialAssignments
@see ListOfRules
@see ListOfConstraints
@see ListOfReactions
@see ListOfEvents


=over

=item Constraint::Constraint

Creates a new Constraint optionally with its math set.
@param math ASTNode representing the math of the Constraint.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item Constraint::Constraint

Creates a new Constraint using the given SBML C<level> and C<version>
values and optionally a set of XMLNamespaces.
@param level an unsigned int, the SBML Level to assign to this Constraint
@param version an unsigned int, the SBML Version to assign to this
Constraint

@param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
assign to this Constraint
@note Once a Constraint has been added to an SBMLDocument, the C<level>,
C<version> and C<xmlns> namespaces for the document I<override> those used
to create the Constraint.  Despite this, the ability to supply the values
at creation time is an important aid to creating valid SBML.  Knowledge of
the intented SBML Level and Version determine whether it is valid to
assign a particular value to an attribute, or whether it is valid to add
an object to an existing SBMLDocument.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.

@deprecated libSBML internal


=item Constraint::Constraint

Copy constructor; creates a copy of this Constraint.


=item Constraint::accept

Accepts the given SBMLVisitor for this instance of Constraint.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>, which indicates
whether the Visitor would like to visit the next Constraint in the
list of constraints within which this Constraint is embedded (i.e., in
the ListOfConstraints located in the enclosing Model instance).


=item Constraint::clone

Creates and returns a deep copy of this Constraint.
Returns a (deep) copy of this Constraint.


=item Constraint::getMessage

Get the message, if any, associated with this Constraint
Returns the message for this Constraint, as an XMLNode.


=item Constraint::getMessageString

Get the message string, if any, associated with this Constraint
Returns the message for this Constraint, as a string.


=item Constraint::getMath

Get the mathematical expression of this Constraint
Returns the math for this Constraint, as an ASTNode.


=item Constraint::isSetMessage

Predicate returning C<true> or C<false> depending on whether a
message has been defined for this Constraint.
@htmlinclude libsbml-comment-set-methods.html
Returns C<true> if the message of this Constraint has been set,
C<false> otherwise.


=item Constraint::isSetMath

Predicate returning C<true> or C<false> depending on whether a
mathematical formula has been defined for this Constraint.
@htmlinclude libsbml-comment-set-methods.html
Returns C<true> if the "math" subelement for this Constraint has been
set, C<false> otherwise.


=item Constraint::setMessage

Sets the message of this Constraint.
@htmlinclude libsbml-comment-set-methods.html
The XMLNode tree passed in C<xhtml> is copied.
@param xhtml an XML tree containing XHTML content.


=item Constraint::setMath

Sets the mathematical expression of this Constraint to a copy of the
AST given as C<math>.
@htmlinclude libsbml-comment-set-methods.html
@param math an ASTNode expression to be assigned as the "math"
subelement of this Constraint


=item Constraint::unsetMessage

Unsets the "message" subelement of this Constraint.
@htmlinclude libsbml-comment-set-methods.html


=item Constraint::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for this object, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item Constraint::getElementName

Returns the XML element name of this object, which for Constraint, is
always C<"constraint">.
Returns the name of this element, i.e., C<"constraint">.


=item Constraint::writeElements

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.
@deprecated libSBML internal


=item Constraint::readOtherXML

Subclasses should override this method to read (and store) XHTML,
MathML, etc. directly from the XMLInputStream.
Returns true if the subclass read from the stream, false otherwise.
@deprecated libSBML internal


=item Constraint::readAttributes

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.
@deprecated libSBML internal


=item Constraint::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Constraint::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Constraint::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item ListOfConstraints::clone

Creates and returns a deep copy of this ListOfConstraints instance.
Returns a (deep) copy of this ListOfConstraints.


=item ListOfConstraints::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for this object, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item ListOfConstraints::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., Constraint objects, if the list is non-empty).
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for the objects contained in this ListOf
instance, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item ListOfConstraints::getElementName

Returns the XML element name of this object.
For ListOfConstraints, the XML element name is C<"listOfConstraints">.
Returns the name of this element, i.e., C<"listOfConstraints">.


=item ListOfConstraints::get

Get a Constraint from the ListOfConstraints.
@param n the index number of the Constraint to get.
Returns the nth Constraint in this ListOfConstraints.
@see size()


=item ListOfConstraints::get

Get a Constraint from the ListOfConstraints.
@param n the index number of the Constraint to get.
Returns the nth Constraint in this ListOfConstraints.
@see size()


=item ListOfConstraints::remove

Removes the nth item from this ListOfConstraints items and returns a
pointer to it.
The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove
@see size()


=item ListOfConstraints::getElementPosition

Get the ordinal position of this element in the containing object
(which in this case is the Model object).
The ordering of elements in the XML form of SBML is generally fixed
for most components in SBML.  So, for example, the ListOfConstraints
in a model is (in SBML Level 2 Version 4) the tenth ListOf___.
(However, it differs for different Levels and Versions of SBML.)
Returns the ordinal position of the element with respect to its
siblings, or C<-1> (default) to indicate the position is not significant.
@deprecated libSBML internal


=item ListOfConstraints::createObject

Returns the SBML object corresponding to next XMLToken in the
XMLInputStream or NULL if the token was not recognized.
@deprecated libSBML internal


=back

=head2 Reaction

LibSBML implementation of SBML's Reaction construct.
A I<reaction> represents any transformation, transport or binding
process, typically a chemical reaction, that can change the quantity of
one or more species.  In SBML, a reaction is defined primarily in terms
of the participating reactants and products (and their corresponding
stoichiometries), along with optional modifier species, an optional rate
at which the reaction takes place, and optional parameters.  These
various parts of a reaction are recorded in the Reaction object and its
supporting object classes: KineticLaw, SpeciesReference,
ModifierSpeciesReference, ListOfSpeciesReferences,
ListOfModifierSpeciesReferences, and StoichiometryMath.  It also uses
Parameter and ListOfParameters.
As with other major object in SBML, Reaction has a mandatory attribute,
"id", used to give the compartment type an identifier.  The identifier
must be a text string conforming to the identifer syntax permitted in
SBML.  The reaction "id" identifier can be used in mathematical
formulas elsewhere in an SBML model to represent the rate of that
reaction; this usage is explained below.  Reaction also has an optional
"name" attribute, of type C<string>.  The "id" and "name" must be used
according to the guidelines described in the SBML specification (e.g.,
Section 3.3 in the Level 2 Version 4 specification).
The species participating as reactants, products, and/or modifiers in a
reaction are declared using lists of SpeciesReference and/or
ModifierSpeciesReference instances stored in subelements
"listOfReactants", "listOfProducts" and "listOfModifiers".  Certain
restrictions are placed on the appearance of species in reaction
definitions:

=over


=item

The ability of a species to appear as a reactant or product of any
reaction in a model is governed by certain flags in that species'
definition; see the definition of Species for more information.

=item

Any species appearing in the mathematical formula of the subelement
"kineticLaw" (described below) of a Reaction must be declared in at
least one of that Reaction's lists of reactants, products, and/or
modifiers.  Put another way, it is an error for a reaction's kinetic law
formula to refer to species that have not been declared for that
reaction.


=item

A reaction definition can contain an empty list of reactants
<em>or</em> an empty list of products, but it must have at least one
reactant or product; in other words, a reaction without any reactant or
product species is not permitted.  (This restriction does not apply to
modifier species, which remain optional in all cases.)

=back


A reaction can contain up to one KineticLaw object in a subelement named
"kineticLaw".  It defines the speed at which the process defined by the
reaction takes place.  The description of KineticLaw provides more
details about its use.  Note that although the inclusion of a KineticLaw
object in an instance of a Reaction component is optional, there is no
useful default that can be substituted in place of a missing rate
expression in a reaction.  Moreover, a reaction's rate cannot be defined
in any other way in SBML&mdash;InitialAssignment, AssignmentRule,
RateRule, AlgebraicRule, Event, and other constructs in SBML cannot be
used to set the reaction rate separately.  Nevertheless, for some
modeling applications, reactions without any defined rate can be
perfectly acceptable.
Reaction also has an optional boolean attribute named "reversible" for
indicating whether the reaction is reversible.  The default is C<true>.
To say that a reaction is I<reversible> is to say it can proceed in
either the forward or the reverse direction.  Although the reversibility
of a reaction can sometimes be deduced by inspecting its rate
expression, this is not always the case, especially for complicated
expressions.  Moreover, the need in SBML to allow rate expressions
(i.e., KineticLaw) to be optional leads to the need for a separate flag
indicating reversibility.  Note that labeling a reaction as irreversible
is an assertion that the reaction always proceeds in the given forward
direction.  (Why else would it be flagged as irreversible?)  This
implies the rate expression in the KineticLaw always has a non-negative
value during simulations.  Software tools could provide a means of
optionally testing that this condition holds.  The presence of
reversibility information in two places (i.e., the rate expression and
the "reversible" attribute on Reaction) leaves open the possibility that
a model could contain contradictory information, but the creation of
such a model would be an error on the part of the software generating
it.

Finally, Reaction has another optional boolean attribute called "fast".
It is used to indicate that a reaction occurs on a vastly faster time
scale than others in a system.  Readers are directed to the SBML Level
2 Version 4 specification, which provides more detail about the
conditions under which a reaction can be considered to be fast in this
sense.  The attribute's default value is C<false>.  SBML Level 1 and
Level 2 Version 1 incorrectly claimed that software tools could ignore
this attribute if they did not implement support for the corresponding
concept; however, further research in SBML has revealed that this is
not true, and "fast" <em>cannot be ignored</em> if it is set to C<true>.
SBML Level 2 Versions 2, 3 and 4 therefore stipulate that if a model has
any reactions with "fast" set to C<true>, a software tool must be able
to respect the attribute or else indicate to the user that it does not
have the capacity to do so.  Analysis software cannot ignore the value
of the "fast" attribute because doing so may lead to different results
as compared to a software system that <em>does</em> make use of "fast".
Readers are urged to read the SBML specification for more details about
the proper use of Reaction.


=over

=back

=head2 ListOfReactions

LibSBML implementation of SBML's ListOfReactions construct.
The various ListOf___ classes in SBML are merely containers used for
organizing the main components of an SBML model.  All are derived from
the abstract class SBase, and inherit the various attributes and
subelements of SBase, such as "metaid" as and "annotation".  The
ListOf___ classes do not add any attributes of their own.
The relationship between the lists and the rest of an SBML model is
illustrated by the following (for SBML Level&nbsp;2 Version&nbsp;4):
@image html listof-illustration.jpg "ListOf___ elements in an SBML Model"
@image latex listof-illustration.jpg "ListOf___ elements in an SBML Model"
Readers may wonder about the motivations for using the ListOf___
containers.  A simpler approach in XML might be to place the components
all directly at the top level of the model definition.  We chose instead
to group them within XML elements named after ListOf<em>Classname</em>,
in part because we believe this helps organize the components and makes
visual reading of models in XML easier.  More importantly, the fact that
the container classes are derived from SBase means that software tools
can add information about the lists themselves into each list
container's "annotation".
@see ListOfFunctionDefinitions
@see ListOfUnitDefinitions
@see ListOfCompartmentTypes
@see ListOfSpeciesTypes
@see ListOfCompartments
@see ListOfSpecies
@see ListOfParameters
@see ListOfInitialAssignments
@see ListOfRules
@see ListOfConstraints
@see ListOfReactions
@see ListOfEvents


=over

=item Reaction::Reaction

Creates a new Reaction, optionally with the given identifier,
KineticLaw object and value of the "reversible" attribute.
@param sid an identifier string for the Reaction
@param name a name string for the Reaction
@param kl a KineticLaw object
@param reversible a boolean value for the "reversible" flag
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item Reaction::Reaction

Creates a new Reaction using the given SBML C<level> and C<version>
values and optionally a set of XMLNamespaces.
@param level an unsigned int, the SBML Level to assign to this Reaction
@param version an unsigned int, the SBML Version to assign to this
Reaction

@param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
assign to this Reaction
@note Once a Reaction has been added to an SBMLDocument, the C<level>,
C<version> and C<xmlns> namespaces for the document I<override> those used
to create the Reaction.  Despite this, the ability to supply the values
at creation time is an important aid to creating valid SBML.  Knowledge of
the intented SBML Level and Version determine whether it is valid to
assign a particular value to an attribute, or whether it is valid to add
an object to an existing SBMLDocument.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.

@deprecated libSBML internal


=item Reaction::Reaction

Copy constructor; creates a copy of this Reaction.


=item Reaction::accept

Accepts the given SBMLVisitor for this instance of Reaction.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>.


=item Reaction::clone

Creates and returns a deep copy of this Reaction.
Returns a (deep) copy of this Reaction.


=item Reaction::initDefaults

Initializes certain attributes of this Reaction object to default
values.

=over


=item

Sets the "reversible" attribute to C<true>

=item

(SBML Level 1 only) Sets the "fast" attribute to C<false>

=back


@warning The "fast" attribute must be used with care.  SBML
definitions before SBML Level 2 Version 2 incorrectly indicated that
software tools could ignore this attribute if they did not implement
support for the corresponding concept; however, further research in
SBML has revealed that this is not true, and "fast" <em>cannot be
ignored</em> if it is set to C<true>.  SBML Level 2 Versions 2, 3 and 4
therefore stipulate that if a model has any reactions with "fast" set
to C<true>, a software tool must be able to respect the attribute or
else indicate to the user that it does not have the capacity to do so.
Readers are directed to the SBML Level 2 Version 4 specification,
which provides more detail about the conditions under which a reaction
can be considered to be fast in this sense.


=item Reaction::getKineticLaw

Returns the KineticLaw object contained in this Reaction.
Returns the KineticLaw instance.


=item Reaction::getKineticLaw

Returns the KineticLaw object contained in this Reaction.
Returns the KineticLaw instance.


=item Reaction::getReversible

Returns the value of the "reversible" attribute on the Reaction as a
boolean value.
Returns the reversibility status of this Reaction.


=item Reaction::getFast

Returns the value of the "fast" attribute of this Reaction.
Returns the "fast" status of this Reaction.
@warning SBML definitions before SBML Level 2 Version 2 incorrectly
indicated that software tools could ignore this attribute if they did
not implement support for the corresponding concept; however, further
research in SBML has revealed that this is not true, and "fast"
<em>cannot be ignored</em> if it is set to C<true>.  SBML Level 2
Versions 2, 3 and 4 therefore stipulate that if a model has any reactions
with "fast" set to C<true>, a software tool must be able to respect
the attribute or else indicate to the user that it does not have the
capacity to do so.  Readers are directed to the SBML Level 2 Version
4 specification, which provides more detail about the conditions under
which a reaction can be considered to be fast in this sense.


=item Reaction::isSetKineticLaw

Predicate returning C<true> or C<false> depending on whether this
Reaction contains a kinetic law object.
@htmlinclude libsbml-comment-set-methods.html
Returns C<true> if a KineticLaw is present in this Reaction,, C<false>
otherwise.



=item Reaction::isSetFast

Predicate returning C<true> or C<false> depending on the value of
the "fast" attribute on this Reaction.
@htmlinclude libsbml-comment-set-methods.html
Returns C<true> if the "fast" attribute is true, C<false> otherwise.
@warning SBML definitions before SBML Level 2 Version 2 incorrectly
indicated that software tools could ignore this attribute if they did
not implement support for the corresponding concept; however, further
research in SBML has revealed that this is not true, and "fast"
<em>cannot be ignored</em> if it is set to C<true>.  SBML Level 2
Versions 2, 3 and 4 therefore stipulate that if a model has any reactions
with "fast" set to C<true>, a software tool must be able to respect
the attribute or else indicate to the user that it does not have the
capacity to do so.  Readers are directed to the SBML Level 2 Version
4 specification, which provides more detail about the conditions under
which a reaction can be considered to be fast in this sense.  Note
also that in SBML Level 1, "fast" is defined as optional with a
default of C<false>, which means it is effectively always set.


=item Reaction::setKineticLaw

Sets the "kineticLaw" subelement of this Reaction to a copy of the
given KineticLaw object.
@htmlinclude libsbml-comment-set-methods.html
@param kl the KineticLaw object to use.


=item Reaction::setReversible

Sets the value of the "reversible" attribute of this Reaction.
@htmlinclude libsbml-comment-set-methods.html
@param value the value of the "reversible" attribute.


=item Reaction::setFast

Sets the value of the "fast" attribute of this Reaction.
@htmlinclude libsbml-comment-set-methods.html
@param value the value of the "fast" attribute.
@warning SBML definitions before SBML Level 2 Version 2 incorrectly
indicated that software tools could ignore this attribute if they did
not implement support for the corresponding concept; however, further
research in SBML has revealed that this is not true, and "fast"
<em>cannot be ignored</em> if it is set to C<true>.  SBML Level 2
Versions 2, 3 and 4 therefore stipulate that if a model has any reactions
with "fast" set to C<true>, a software tool must be able to respect
the attribute or else indicate to the user that it does not have the
capacity to do so.  Readers are directed to the SBML Level 2 Version
4 specification, which provides more detail about the conditions under
which a reaction can be considered to be fast in this sense.


=item Reaction::unsetKineticLaw

Unsets the "kineticLaw" subelement of this Reaction.
@htmlinclude libsbml-comment-set-methods.html


=item Reaction::unsetFast

Unsets the value of the "fast" attribute of this Reaction.
@htmlinclude libsbml-comment-set-methods.html
@warning In SBML Level 1, "fast" is optional with a default of @c
false, which means it is effectively always set (and reset to C<false>
if this method is called).  Further, SBML definitions before SBML
Level 2 Version 2 incorrectly indicated that software tools could
ignore this attribute if they did not implement support for the
corresponding concept; however, further research in SBML has revealed
that this is not true, and "fast" <em>cannot be ignored</em> if it is
set to C<true>.  SBML Level 2 Versions 2, 3 and 4 therefore stipulate
that if a model has any reactions with "fast" set to C<true>, a
software tool must be able to respect the attribute or else indicate
to the user that it does not have the capacity to do so.  Readers are
directed to the SBML Level 2 Version 4 specification, which provides
more detail about the conditions under which a reaction can be
considered to be fast in this sense.


=item Reaction::addReactant

Adds a given SpeciesReference object as a reactant in this Reaction.
The SpeciesReference instance in C<sr> is copied.
@param sr a SpeciesReference object referring to a Species in the
enclosing Model
@note This method should be used with some caution.  The fact that
this method I<copies> the object passed to it means that the caller
will be left holding a physically different object instance than the
one contained in this Reaction.  Changes made to the original object
instance (such as resetting attribute values) will <em>not affect the
instance in the Reaction</em>.  In addition, the caller should make
sure to free the original object if it is no longer being used, or
else a memory leak will result.  Please see Reaction::createReactant()
for a method that does not lead to these issues.
@see createReactant()


=item Reaction::addProduct

Adds a given SpeciesReference object as a product in this Reaction.
The SpeciesReference instance in C<sr> is copied.
@param sr a SpeciesReference object referring to a Species in the
enclosing Model
@note This method should be used with some caution.  The fact that
this method I<copies> the object passed to it means that the caller
will be left holding a physically different object instance than the
one contained in this Reaction.  Changes made to the original object
instance (such as resetting attribute values) will <em>not affect the
instance in the Reaction</em>.  In addition, the caller should make
sure to free the original object if it is no longer being used, or
else a memory leak will result.  Please see Reaction::createProduct()
for a method that does not lead to these issues.
@see createProduct()


=item Reaction::addModifier

Adds a given ModifierSpeciesReference object as a product in this
Reaction.

The ModifierSpeciesReference instance in C<msr> is copied.
@param msr a ModifierSpeciesReference object referring to a Species in
the enclosing Model
@note This method should be used with some caution.  The fact that
this method I<copies> the object passed to it means that the caller
will be left holding a physically different object instance than the
one contained in this Reaction.  Changes made to the original object
instance (such as resetting attribute values) will <em>not affect the
instance in the Reaction</em>.  In addition, the caller should make
sure to free the original object if it is no longer being used, or
else a memory leak will result.  Please see Reaction::createModifier()
for a method that does not lead to these issues.
@see createModifier()


=item Reaction::createReactant

Creates a new SpeciesReference, adds it to this Reaction's list of
reactants, and returns it.
Returns a new SpeciesReference object.


=item Reaction::createProduct

Creates a new SpeciesReference, adds it to this Reaction's list of
products, and returns it.
Returns a new SpeciesReference object.


=item Reaction::createModifier

Creates a new ModifierSpeciesReference, adds it to this Reaction's
list of modifiers and returns it.
Returns a new ModifierSpeciesReference object.


=item Reaction::createKineticLaw

Creates a new KineticLaw object, installs it as this Reaction's
"kineticLaw" subelement, and returns it.
If this Reaction had a previous KineticLaw, it will be destroyed.
Returns the new KineticLaw object


=item Reaction::getListOfReactants

Returns the list of reactants in this Reaction object.
Returns the ListOfSpeciesReferences containing the references to the
species acting as reactants in this reaction


=item Reaction::getListOfReactants

Returns the list of reactants in this Reaction object.
Returns the ListOfSpeciesReferences containing the references to the
species acting as reactants in this reaction


=item Reaction::getListOfProducts

Returns the list of products in this Reaction object.
Returns the ListOfSpeciesReferences containing the references to the
species acting as products in this reaction


=item Reaction::getListOfProducts

Returns the list of products in this Reaction object.
Returns the ListOfSpeciesReferences containing the references to the
species acting as products in this reaction


=item Reaction::getListOfModifiers

Returns the list of modifiers in this Reaction object.
Returns the ListOfSpeciesReferences containing the references to the
species acting as modifiers in this reaction


=item Reaction::getListOfModifiers

Returns the list of modifiers in this Reaction object.
Returns the ListOfSpeciesReferences containing the references to the
species acting as modifiers in this reaction


=item Reaction::getReactant

Returns the nth reactant species in the list of reactants in this
Reaction.

Callers should first call getNumReactants() to find out how many
reactants there are, to avoid using an invalid index number.
@param n the index of the reactant sought.
Returns the nth reactant (as a SpeciesReference object) of this
Reaction.



=item Reaction::getReactant

Returns the nth reactant species in the list of reactants in this
Reaction.

Callers should first call getNumReactants() to find out how many
reactants there are, to avoid using an invalid index number.
@param n the index of the reactant sought.
Returns the nth reactant (as a SpeciesReference object) of this
Reaction.



=item Reaction::getReactant

Returns the reactant species having a specific identifier in this
Reaction.

@param species the identifier of the reactant Species
Returns a SpeciesReference object, or NULL if no species with the
given identifier C<species> appears as a reactant in this Reaction.


=item Reaction::getReactant

Returns the reactant species having a specific identifier in this
Reaction.

@param species the identifier of the reactant Species
Returns a SpeciesReference object, or NULL if no species with the
given identifier C<species> appears as a reactant in this Reaction.


=item Reaction::getProduct

Returns the nth product species in the list of products in this Reaction.
Callers should first call getNumProducts() to find out how many
products there are, to avoid using an invalid index number.
@param n the index of the product sought.
Returns the nth product (as a SpeciesReference object) of this
Reaction.



=item Reaction::getProduct

Returns the nth product species in the list of products in this
Reaction.

Callers should first call getNumProducts() to find out how many
products there are, to avoid using an invalid index number.
@param n the index of the product sought.
Returns the nth product (as a SpeciesReference object) of this
Reaction.



=item Reaction::getProduct

Returns the product species having a specific identifier in this
Reaction.

@param species the identifier of the product Species
Returns a SpeciesReference object, or NULL if no species with the
given identifier C<species> appears as a product in this Reaction.


=item Reaction::getProduct

Returns the product species having a specific identifier in this
Reaction.

@param species the identifier of the product Species
Returns a SpeciesReference object, or NULL if no species with the
given identifier C<species> appears as a product in this Reaction.


=item Reaction::getModifier

Returns the nth modifier species in the list of modifiers of this Reaction.
Callers should first call getNumModifiers() to find out how many
modifiers there are, to avoid using an invalid index number.
@param n the index of the modifier species sought
Returns the nth modifier (as a ModifierSpeciesReference object) of
this Reaction.


=item Reaction::getModifier

Returns the nth modifier species in the list of modifiers of this Reaction.
Callers should first call getNumModifiers() to find out how many
modifiers there are, to avoid using an invalid index number.
@param n the index of the modifier species sought
Returns the nth modifier (as a ModifierSpeciesReference object) of
this Reaction.


=item Reaction::getModifier

Returns the modifier species having a specific identifier in this
Reaction.

@param species the identifier of the modifier Species
Returns a ModifierSpeciesReference object, or NULL if no species with
the given identifier C<species> appears as a modifier in this
Reaction.



=item Reaction::getModifier

Returns the modifier species having a specific identifier in this
Reaction.

@param species the identifier of the modifier Species
Returns a ModifierSpeciesReference object, or NULL if no species with
the given identifier C<species> appears as a modifier in this
Reaction.



=item Reaction::getNumReactants

Returns the number of reactant species in this Reaction.
Returns the number of reactants in this Reaction.


=item Reaction::getNumProducts

Returns the number of product species in this Reaction.
Returns the number of products in this Reaction.


=item Reaction::getNumModifiers

Returns the number of modifier species in this Reaction.
Returns the number of modifiers in this Reaction.


=item Reaction::setSBMLDocument

Sets the parent SBMLDocument of this SBML object.
@deprecated libSBML internal


=item Reaction::setParentSBMLObject

Sets the parent SBML object of this SBML object.
@param sb the SBML object to use
@deprecated libSBML internal


=item Reaction::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for this object, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item Reaction::getElementName

Returns the XML element name of this object, which for Reaction, is
always C<"reaction">.
Returns the name of this element, i.e., C<"reaction">.


=item Reaction::writeElements

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.
@deprecated libSBML internal


=item Reaction::createObject

Returns the SBML object corresponding to next XMLToken in the
XMLInputStream or NULL if the token was not recognized.
@deprecated libSBML internal


=item Reaction::readAttributes

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.
@deprecated libSBML internal


=item Reaction::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Reaction::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Reaction::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Reaction::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Reaction::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Reaction::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Reaction::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Reaction::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item ListOfReactions::clone

Creates and returns a deep copy of this ListOfReactions instance.
Returns a (deep) copy of this ListOfReactions.


=item ListOfReactions::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for this object, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item ListOfReactions::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., Reaction objects, if the list is non-empty).
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for the objects contained in this ListOf
instance, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item ListOfReactions::getElementName

Returns the XML element name of this object, which for
ListOfReactions, is always C<"listOfReactions">.
Returns the name of this element, i.e., C<"listOfReactions">.


=item ListOfReactions::get

Get a Reaction from the ListOfReactions.
@param n the index number of the Reaction to get.
Returns the nth Reaction in this ListOfReactions.
@see size()


=item ListOfReactions::get

Get a Reaction from the ListOfReactions.
@param n the index number of the Reaction to get.
Returns the nth Reaction in this ListOfReactions.
@see size()


=item ListOfReactions::get

Get a Reaction from the ListOfReactions
based on its identifier.
@param sid a string representing the identifier 
of the Reaction to get.
Returns Reaction in this ListOfReactions
with the given id or NULL if no such
Reaction exists.
@see get(unsigned int n)
@see size()


=item ListOfReactions::get

Get a Reaction from the ListOfReactions
based on its identifier.
@param sid a string representing the identifier 
of the Reaction to get.
Returns Reaction in this ListOfReactions
with the given id or NULL if no such
Reaction exists.
@see get(unsigned int n)
@see size()


=item ListOfReactions::remove

Removes the nth item from this ListOfReactions items and returns a pointer to
it.

The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove
@see size()


=item ListOfReactions::remove

Removes item in this ListOfReactions items with the given identifier.
The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier C<sid>, then @c
NULL is returned.
@param sid the identifier of the item to remove
Returns the item removed.  As mentioned above, the caller owns the
returned item.


=item ListOfReactions::getElementPosition

Returns the ordinal position of the element with respect to its
siblings or -1 (default) to indicate the position is not significant.
@deprecated libSBML internal


=item ListOfReactions::createObject

Returns the SBML object corresponding to next XMLToken in the
XMLInputStream or NULL if the token was not recognized.
@deprecated libSBML internal


=back

=head2 KineticLaw

LibSBML implementation of SBML's KineticLaw construct.
An object of class KineticLaw is used to describe the rate at which the
process defined by a given Reaction takes place.  KineticLaw has
subelements called "math" (for MathML content) and "listOfParameters"
(of class ListOfParameters), in addition to the attributes and
subelements it inherits from SBase.
KineticLaw's "math" subelement for holding a MathML formula defines the
rate of the reaction.  The formula may refer to other entities in a
model (Compartment, Species, Parameter, FunctionDefinition, Reaction),
but the only Species identifiers that can be used in this formula are
those declared in the lists of reactants, products and modifiers in the
Reaction structure.  Parameter identifiers may be taken from either the
KineticLaw's list of local parameters (discussed below) or the
parameters defined globally on the Model instance.
KineticLaw's "listOfParameters" subelement can contain a list of one or
more Parameter objects defining new parameters whose identifiers can be
used in the "math" formula of that KineticLaw instance.  The Parameter
objects so defined are only visible within the KineticLaw; they cannot
be accessed outside.  Moreover, if a Parameter has the same identifier
as a global Parameter object defined in the enclosing Model, the
definition inside the KineticLaw takes precedence (i.e., it shadows the
global definition).
The type of structure used to define a parameter inside KineticLaw is
the same Parameter structure used to define global parameters.  This
simplifies the SBML language and reduces the number of unique types of
data objects.  However, there is a difference between local and global
parameters: in the case of parameters defined locally to a KineticLaw,
there is no means by which the parameter values can be changed.
Consequently, such parameters' values are always constant, and the
"constant" attribute in their definitions must always have a value of @c
true (either explicitly or left to its default value).  See the
definition of Parameter for more information about the "constant"
attribute.

@section kineticlaw-units Units of rate expressions in KineticLaw
It is important to make clear that a so-called kinetic law in SBML is
I<not> identical to a traditional rate law.  The reason is that SBML
must support multicompartment models, and the units normally used in
traditional rate laws as well as some conventional single-compartment
modeling packages are problematic when used for defining reactions
between multiple compartments.  When modeling species as continuous
amounts (e.g., concentrations), the rate laws used are traditionally
expressed in terms of <em>amount of substance concentration per
time</em>, embodying a tacit assumption that reactants and products are
all located in a single, constant volume.  Attempting to describe
reactions between multiple volumes using
<em>concentration</em>/<em>time</em> (which is to say,
<em>substance</em>/<em>volume</em>/<em>time</em>) quickly leads to
difficulties, as explained in the SBML Level&nbsp;2 Version&nbsp;2, 3
and&nbsp;4 specifications.
The need to support multicompartment models requires that the reaction
rates in SBML to be expressed in terms of
<em>substance</em>/<em>time</em>, rather than the more typical
<em>substance</em>/<em>size</em>/<em>time</em>.  As a result, modelers
and software tools in general cannot insert textbook rate laws
unmodified as the rate expression in the "math" subelement of a
KineticLaw.  The unusual term "kinetic law" was chosen to alert users to
this difference.
Please consult the SBML specification document for more information
about the definition reaction rates in SBML.
@note Before SBML Level&nbsp;2 Version&nbsp;2, the SBML specification
included two additional attributes on KineticLaw called "substanceUnits"
and "timeUnits".  They were removed beginning with SBML Level&nbsp;2
Version&nbsp;2 because further research determined they introduced many
problems.  The most significant problem was that their use could easily
lead to the creation of valid models whose reactions nevertheless could
not be integrated into a system of equations without outside knowledge
for converting the quantities used.  Examination of real-life models
revealed that a common reason for using "substanceUnits" on KineticLaw
was to set the units of all reactions to the same set of substance
units, something that is better achieved by using UnitDefinition to
redefine C<"substance"> for the whole Model.


=over

=item KineticLaw::KineticLaw

Creates a new KineticLaw object, optionally with values for its "formula",
"timeUnits" and/or "substanceUnits" attributes.
This will copy the strings handed in C<formula>, C<timeUnits> and @p
substanceUnits.  This method is functionally equivalent to the following:
C<ode>
KineticLaw k = new KineticLaw();
k.setFormula(formula);
k.setTimeUnits(timeUnits);
k.setSubstanceUnits(substanceUnits);
@endcode
@param formula a mathematical expression in text-string form
representing the rate of the reaction.
@param timeUnits the identifier of the time units
@param substanceUnits the identifier of the substance units
@note SBML Level&nbsp;1 uses a text-string format for mathematical
formulas.  SBML Level&nbsp;2 uses MathML, an XML format for representing
mathematical expressions.  LibSBML provides an Abstract Syntax Tree
API for working with mathematical expressions; this API is more
powerful than working with formulas directly in text form, and ASTs
can be translated into either MathML or the text-string syntax.  The
libSBML methods that accept text-string formulas directly (such as
this constructor) are provided for SBML Level&nbsp;1 compatibility, but
developers are encouraged to use the AST mechanisms.  See the other
KineticLaw constructor for a version that takes an ASTNode.
@warning In SBML Level&nbsp;2 Version&nbsp;2, the "timeUnits" and
"substanceUnits" attributes were removed.  For compatibility with new
versions of SBML, users are cautioned to avoid these attributes.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item KineticLaw::KineticLaw

Creates a new KineticLaw object, optionally with values for the "math"
subelement and the "timeUnits" and/or "substanceUnits" attributes.
This will copy the strings handed in C<timeUnits> and @p
substanceUnits.  This method is functionally equivalent to the following:
C<ode>
KineticLaw k = new KineticLaw();
k.setMath(math);
k.setTimeUnits(timeUnits);
k.setSubstanceUnits(substanceUnits);
@endcode
@param math an ASTNode representing the rate of the reaction.
@param timeUnits the identifier of the time units
@param substanceUnits the identifier of the substance units
@warning In SBML Level&nbsp;2 Version&nbsp;2, the "timeUnits" and
"substanceUnits" attributes were removed.  For compatibility with new
versions of SBML, users are cautioned to avoid these attributes.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item KineticLaw::KineticLaw

Creates a new KineticLaw using the given SBML C<level> and C<version>
values and optionally a set of XMLNamespaces.
@param level an unsigned int, the SBML Level to assign to this KineticLaw
@param version an unsigned int, the SBML Version to assign to this
KineticLaw

@param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
assign to this KineticLaw
@note Once a KineticLaw has been added to an SBMLDocument, the C<level>,
C<version> and C<xmlns> namespaces for the document I<override> those used
to create the KineticLaw.  Despite this, the ability to supply the values
at creation time is an important aid to creating valid SBML.  Knowledge of
the intented SBML Level and Version determine whether it is valid to
assign a particular value to an attribute, or whether it is valid to add
an object to an existing SBMLDocument.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.

@deprecated libSBML internal


=item KineticLaw::KineticLaw

Copy constructor; creates a copy of this KineticLaw.


=item KineticLaw::accept

Accepts the given SBMLVisitor for this instance of KineticLaw.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>.


=item KineticLaw::clone

Creates and returns a deep copy of this KineticLaw object.
Returns a (deep) copy of this KineticLaw.


=item KineticLaw::getFormula

Returns the mathematical formula for this KineticLaw object and return
it as as a text string.
This is fundamentally equivalent to getMath().  This variant is
provided principally for compatibility compatibility with SBML Level
1.

Returns a string representing the formula of this KineticLaw.
@see getMath()
@note SBML Level&nbsp;1 uses a text-string format for mathematical
formulas.  SBML Level&nbsp;2 uses MathML, an XML format for
representing mathematical expressions.  LibSBML provides an Abstract
Syntax Tree API for working with mathematical expressions; this API is
more powerful than working with formulas directly in text form, and
ASTs can be translated into either MathML or the text-string syntax.
The libSBML methods that accept text-string formulas directly (such as
this constructor) are provided for SBML Level&nbsp;1 compatibility,
but developers are encouraged to use the AST mechanisms.


=item KineticLaw::getMath

Returns the mathematical formula for this KineticLaw object and return
it as as an AST.
This is fundamentally equivalent to getFormula().  The latter is
provided principally for compatibility compatibility with SBML Level
1, which represented mathematical formulas in text-string form.
Returns the ASTNode representation of the mathematical formula.
@see getFormula()


=item KineticLaw::getTimeUnits

Returns the value of the "timeUnits" attribute of this KineticLaw
object.

Returns the "timeUnits" attribute value
@warning In SBML Level&nbsp;2 Version&nbsp;2, the "timeUnits" and
"substanceUnits" attributes were removed.  For compatibility with new
versions of SBML, users are cautioned to avoid these attributes.


=item KineticLaw::getSubstanceUnits

Returns the value of the "substanceUnits" attribute of this KineticLaw
object.

Returns the "substanceUnits" attribute value
@warning In SBML Level&nbsp;2 Version&nbsp;2, the "timeUnits" and
"substanceUnits" attributes were removed.  For compatibility with new
versions of SBML, users are cautioned to avoid these attributes.


=item KineticLaw::isSetFormula

Predicate returning C<true> or C<false> depending on whether this
KineticLaw's "formula" attribute has been set
@htmlinclude libsbml-comment-set-methods.html
This is functionally identical to the method isSetMath().  It is
provided in order to mirror the parallel between getFormula() and
getMath().

Returns C<true> if the formula (meaning the C<math> subelement) of
this KineticLaw has been set, C<false> otherwise.
@note SBML Level&nbsp;1 uses a text-string format for mathematical
formulas.  SBML Level&nbsp;2 uses MathML, an XML format for
representing mathematical expressions.  LibSBML provides an Abstract
Syntax Tree API for working with mathematical expressions; this API is
more powerful than working with formulas directly in text form, and
ASTs can be translated into either MathML or the text-string syntax.
The libSBML methods that accept text-string formulas directly (such as
this constructor) are provided for SBML Level&nbsp;1 compatibility,
but developers are encouraged to use the AST mechanisms.


=item KineticLaw::isSetMath

Predicate returning C<true> or C<false> depending on whether this
Kinetic's "math" subelement has been set
@htmlinclude libsbml-comment-set-methods.html
This is identical to the method isSetFormula().  It is provided
in order to mirror the parallel between getFormula() and getMath().
Returns C<true> if the formula (meaning the C<math> subelement) of
this KineticLaw has been set, C<false> otherwise.


=item KineticLaw::isSetTimeUnits

Predicate returning C<true> or C<false> depending on whether this
SpeciesReference's "timeUnits" attribute has been set
@htmlinclude libsbml-comment-set-methods.html
Returns C<true> if the "timeUnits" attribute of this KineticLaw object
has been set, C<false> otherwise.
@warning In SBML Level&nbsp;2 Version&nbsp;2, the "timeUnits" and
"substanceUnits" attributes were removed.  For compatibility with new
versions of SBML, users are cautioned to avoid these attributes.


=item KineticLaw::isSetSubstanceUnits

Predicate returning C<true> or C<false> depending on whether this
SpeciesReference's "substanceUnits" attribute has been set
@htmlinclude libsbml-comment-set-methods.html
Returns C<true> if the "substanceUnits" attribute of this KineticLaw
object has been set, C<false> otherwise.
@warning In SBML Level&nbsp;2 Version&nbsp;2, the "timeUnits" and
"substanceUnits" attributes were removed.  For compatibility with new
versions of SBML, users are cautioned to avoid these attributes.


=item KineticLaw::setFormula

Sets the mathematical expression of this KineticLaw instance to the
given C<formula>.
@htmlinclude libsbml-comment-set-methods.html
The given C<formula> string is copied.  Internally, libSBML stores the
mathematical expression as an ASTNode.
@param formula the mathematical expression to use, represented in
text-string form.
@note SBML Level&nbsp;1 uses a text-string format for mathematical
formulas.  SBML Level&nbsp;2 uses MathML, an XML format for representing
mathematical expressions.  LibSBML provides an Abstract Syntax Tree
API for working with mathematical expressions; this API is more
powerful than working with formulas directly in text form, and ASTs
can be translated into either MathML or the text-string syntax.  The
libSBML methods that accept text-string formulas directly (such as
this constructor) are provided for SBML Level&nbsp;1 compatibility, but
developers are encouraged to use the AST mechanisms.


=item KineticLaw::setMath

Sets the mathematical expression of this KineticLaw instance to a copy
of the given ASTNode.
@htmlinclude libsbml-comment-set-methods.html
This is fundamentally identical to setFormula().  The latter is
provided principally for compatibility compatibility with SBML Level
1, which represented mathematical formulas in text-string form.
@param math an ASTNode representing a formula tree.


=item KineticLaw::setTimeUnits

Sets the "timeUnits" attribute of this KineticLaw object to a copy of
the identifier in C<sid>.
@htmlinclude libsbml-comment-set-methods.html
@param sid the identifier of the units to use.
@warning In SBML Level&nbsp;2 Version&nbsp;2, the "timeUnits" and
"substanceUnits" attributes were removed.  For compatibility with new
versions of SBML, users are cautioned to avoid these attributes.


=item KineticLaw::setSubstanceUnits

Sets the "substanceUnits" attribute of this KineticLaw object to a copy
of the identifier given in C<sid>.
@htmlinclude libsbml-comment-set-methods.html
@param sid the identifier of the units to use.
@warning In SBML Level&nbsp;2 Version&nbsp;2, the "timeUnits" and
"substanceUnits" attributes were removed.  For compatibility with new
versions of SBML, users are cautioned to avoid these attributes.


=item KineticLaw::unsetTimeUnits

Unsets the "timeUnits" attribugte of this KineticLaw object.
@htmlinclude libsbml-comment-set-methods.html
@warning In SBML Level&nbsp;2 Version&nbsp;2, the "timeUnits" and
"substanceUnits" attributes were removed.  For compatibility with new
versions of SBML, users are cautioned to avoid these attributes.


=item KineticLaw::unsetSubstanceUnits

Unsets the "substanceUnits" attribute of this KineticLaw object.
@htmlinclude libsbml-comment-set-methods.html
@warning In SBML Level&nbsp;2 Version&nbsp;2, the "timeUnits" and
"substanceUnits" attributes were removed.  For compatibility with new
versions of SBML, users are cautioned to avoid these attributes.


=item KineticLaw::addParameter

Adds a copy of the given Parameter object to the list of local
parameters in this KineticLaw.
@param p the Parameter to add
@note This method should be used with some caution.  The fact that
this method I<copies> the object passed to it means that the caller
will be left holding a physically different object instance than the
one contained in this KineticLaw.  Changes made to the original object
instance (such as resetting attribute values) will <em>not affect the
instance in the KineticLaw</em>.  In addition, the caller should make
sure to free the original object if it is no longer being used, or
else a memory leak will result.  Please see
KineticLaw::createParameter() for ab method that does not lead to
these issues.
@see createParameter()


=item KineticLaw::createParameter

Creates a new Parameter object, adds it to this KineticLaw's list of
local parameters, and returns the Parameter object created.
Returns a new Parameter object instance
@see addParameter()


=item KineticLaw::getListOfParameters

Returns the list of local parameters in this KineticLaw object.
Returns the list of Parameters for this KineticLaw.


=item KineticLaw::getListOfParameters

Returns the list of local parameters in this KineticLaw object.
Returns the list of Parameters for this KineticLaw.


=item KineticLaw::getParameter

Returns the nth Parameter object in the list of local parameters in
this KineticLaw instance.
@param n the index of the Parameter object sought
Returns the nth Parameter of this KineticLaw.


=item KineticLaw::getParameter

Returns the nth Parameter object in the list of local parameters in
this KineticLaw instance.
@param n the index of the Parameter object sought
Returns the nth Parameter of this KineticLaw.


=item KineticLaw::getParameter

Returns a local parameter based on its identifier.
@param sid the identifier of the Parameter being sought.
Returns the Parameter object in this KineticLaw instace having the
given "id", or C<NULL> if no such Parameter exists.


=item KineticLaw::getParameter

Returns a local parameter based on its identifier.
@param sid the identifier of the Parameter being sought.
Returns the Parameter object in this KineticLaw instace having the
given "id", or C<NULL> if no such Parameter exists.


=item KineticLaw::getNumParameters

Returns the number of local parameters in this KineticLaw instance.
Returns the number of Parameters in this KineticLaw.


=item KineticLaw::getDerivedUnitDefinition

Calculates and returns a UnitDefinition that expresses the units
of measurement assumed for the "math" expression of this
KineticLaw.

The units are calculated based on the mathematical expression in the
KineticLaw and the model quantities referenced by
C<&lt;ci&gt;> elements used within that expression.  The
getDerivedUnitDefinition() method returns the calculated units.
@warning Note that it is possible the "math" expression in the
KineticLaw contains pure numbers or parameters with undeclared
units.  In those cases, it is not possible to calculate the units of
the overall expression without making assumptions.  LibSBML does not
make assumptions about the units, and getDerivedUnitDefinition() only
returns the units as far as it is able to determine them.  For
example, in an expression <em>X + Y</em>, if <em>X</em> has
unambiguously-defined units and <em>Y</em> does not, it will return
the units of <em>X</em>.  <strong>It is important that callers also
invoke the method</strong> containsUndeclaredUnits() <strong>to
determine whether this situation holds</strong>.  Callers may wish to
take suitable actions in those scenarios.
Returns a UnitDefinition that expresses the units of the math 
expression of this KineticLaw.
@see containsUndeclaredUnits()


=item KineticLaw::containsUndeclaredUnits

Predicate returning C<true> or C<false> depending on whether 
the math expression of this KineticLaw contains
parameters/numbers with undeclared units.
Returns C<true> if the math expression of this KineticLaw
includes parameters/numbers 
with undeclared units, C<false> otherwise.
@note A return value of C<true> indicates that the UnitDefinition
returned by getDerivedUnitDefinition() may not accurately represent
the units of the expression.
@see getDerivedUnitDefinition()


=item KineticLaw::setSBMLDocument

Sets the parent SBMLDocument of this SBML object.
@param d the SBMLDocument to use.
@deprecated libSBML internal


=item KineticLaw::setParentSBMLObject

Sets the parent SBML object of this SBML object.
@param sb the SBML object to use
@deprecated libSBML internal


=item KineticLaw::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for this object, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item KineticLaw::getElementName

Returns the XML element name of this object, which for Species, is
always C<"kineticLaw">.
Returns the name of this element, i.e., C<"kineticLaw">.


=item KineticLaw::getElementPosition

Returns the ordinal position of the element with respect to its
siblings or -1 (default) to indicate the position is not significant.
@deprecated libSBML internal


=item KineticLaw::writeElements

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.
@deprecated libSBML internal


=item KineticLaw::createObject

Returns the SBML object corresponding to next XMLToken in the
XMLInputStream or C<NULL> if the token was not recognized.
@deprecated libSBML internal


=item KineticLaw::readOtherXML

Subclasses should override this method to read (and store) XHTML,
MathML, etc. directly from the XMLInputStream.
Returns true if the subclass read from the stream, false otherwise.
@deprecated libSBML internal


=item KineticLaw::readAttributes

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.
@deprecated libSBML internal


=item KineticLaw::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item KineticLaw::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item KineticLaw::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item KineticLaw::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item KineticLaw::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item KineticLaw::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=back

=head2 SimpleSpeciesReference

LibSBML implementation of SBML's SimpleSpeciesReference construct.
As mentioned in the description of Reaction, every species that enters
into a given reaction must appear in that reaction's lists of reactants,
products and/or modifiers.  In an SBML model, all species that may
participate in any reaction are listed in the "listOfSpecies" element of
the top-level Model object.  Lists of products, reactants and modifiers
in Reaction objects do not introduce new species, but rather, they refer
back to those listed in the model's top-level "listOfSpecies".  For
reactants and products, the connection is made using SpeciesReference
objects; for modifiers, it is made using ModifierSpeciesReference
objects.  SimpleSpeciesReference is an abstract type that serves as the
parent class of both SpeciesReference and ModifierSpeciesReference.  It
is used simply to hold the attributes and elements that are common to
the latter two structures.
The SimpleSpeciesReference structure has a mandatory attribute,
"species", which must be a text string conforming to the identifer
syntax permitted in SBML.  This attribute is inherited by the
SpeciesReference and ModifierSpeciesReference subclasses derived from
SimpleSpeciesReference.  The value of the "species" attribute must be
the identifier of a species defined in the enclosing Model.  The species
is thereby declared as participating in the reaction being defined.  The
precise role of that species as a reactant, product, or modifier in the
reaction is determined by the subclass of SimpleSpeciesReference (i.e.,
either SpeciesReference or ModifierSpeciesReference) in which the
identifier appears.
SimpleSpeciesReference also contains an optional attribute, "id",
allowing instances to be referenced from other structures.  No SBML
structures currently do this; however, such structures are anticipated
in future SBML Levels.
<!---------------------------------------------------------------------- -->


=over

=back

=head2 SpeciesReference

LibSBML implementation of SBML's SpeciesReference construct.
The Reaction structure provides a way to express which species act as
reactants and which species act as products in a reaction.  In a given
reaction, references to those species acting as reactants and/or
products are made using instances of SpeciesReference structures in a
Reaction object's lists of reactants and products.
The mandatory "species" attribute of SpeciesReference must have as its
value the identifier of an existing species defined in the enclosing
Model.  The species is thereby designated as a reactant or product in
the reaction.  Which one it is (i.e., reactant or product) is indicated
by whether the SpeciesReference appears in the Reaction's "reactant" or
"product" lists.
Product and reactant stoichiometries can be specified using
<em>either</em> "stoichiometry" or "stoichiometryMath" in a
SpeciesReference object.  The "stoichiometry" attribute is of type
double and should contain values greater than zero (0).  The
"stoichiometryMath" element is implemented as an element containing a
MathML expression.  These two are mutually exclusive; only one of
"stoichiometry" or "stoichiometryMath" should be defined in a given
SpeciesReference instance.  When neither the attribute nor the element
is present, the value of "stoichiometry" in the SpeciesReference
instance defaults to C<1>.
For maximum interoperability, the "stoichiometry" attribute should be
used in preference to "stoichiometryMath" when a species' stoichiometry
is a simple scalar number (integer or decimal).  When the stoichiometry
is a rational number, or when it is a more complicated formula,
"stoichiometryMath" must be used.  The MathML expression in
"stoichiometryMath" may also refer to identifiers of entities in a model
(except reaction identifiers).  However, the only species identifiers
that can be used in "stoichiometryMath" are those referenced in the
Reaction list of reactants, products and modifiers.
The following is a simple example of a species reference for species @c
X0, with stoichiometry C<2>, in a list of reactants within a reaction
having the identifier C<J1>:
C<ode>
<model>
...
<listOfReactions>
<reaction id="J1">
<listOfReactants>
<speciesReference species="X0" stoichiometry="2">
</listOfReactants>
...
</reaction>
...
</listOfReactions>
...
</model>
@endcode
The following is a more complex example of a species reference for
species X0, with a stoichiometry formula consisting of the parameter
C<x>:
C<ode>
<model>
...
<listOfReactions>
<reaction id="J1">
<listOfReactants>
<speciesReference species="X0">
<stoichiometryMath>
<math xmlns="http://www.w3.org/1998/Math/MathML">
<ci>x</ci>
</math>
</stoichiometryMath>
</speciesReference>
</listOfReactants>
...
</reaction>
...
</listOfReactions>
...
</model>
@endcode
A species can occur more than once in the lists of reactants and
products of a given Reaction instance.  The effective stoichiometry for
a species in a reaction is the sum of the stoichiometry values given on
the SpeciesReference object in the list of products minus the sum of
stoichiometry values given on the SpeciesReference objects in the list
of reactants.  A positive value indicates the species is effectively a
product and a negative value indicates the species is effectively a
reactant.  SBML places no restrictions on the effective stoichiometry of
a species in a reaction; for example, it can be zero.  In the following
SBML fragment, the two reactions have the same effective stoichiometry
for all their species:
C<ode>
<reaction id="x">
<listOfReactants>
<speciesReference species="a"/>
<speciesReference species="a"/>
<speciesReference species="b"/>
</listOfReactants>
<listOfProducts>
<speciesReference species="c"/>
<speciesReference species="b"/>
</listProducts>
</reaction>
<reaction id="y">
<listOfReactants>
<speciesReference species="a" stoichiometry="2"/>
</listOfReactants>
<listOfProducts>
<speciesReference species="c"/>
</listProducts>
</reaction>
@endcode


<!---------------------------------------------------------------------- -->


=over

=back

=head2 ModifierSpeciesReference

LibSBML implementation of SBML's ModifierSpeciesReference construct.
Sometimes a species appears in the kinetic rate formula of a reaction
but is itself neither created nor destroyed in that reaction (for
example, because it acts as a catalyst or inhibitor).  In SBML, all such
species are simply called I<modifiers> without regard to the detailed
role of those species in the model.  The Reaction structure provides a
way to express which species act as modifiers in a given reaction.  This
is the purpose of the list of modifiers available in Reaction.  The list
contains instances of ModifierSpeciesReference structures.
The ModifierSpeciesReference structure inherits the mandatory attribute
"species" and optional attributes "id" and "name" from the parent class
SimpleSpeciesReference.  See the description of SimpleSpeciesReference
for more information about these.
The value of the "species" attribute must be the identifier of a species
defined in the enclosing Model; this species is designated as a modifier
for the current reaction.  A reaction may have any number of modifiers.
It is permissible for a modifier species to appear simultaneously in the
list of reactants and products of the same reaction where it is
designated as a modifier, as well as to appear in the list of reactants,
products and modifiers of other reactions in the model.
<!---------------------------------------------------------------------- -->


=over

=back

=head2 ListOfSpeciesReferences

LibSBML implementation of SBML's ListOfSpeciesReferences construct.
The ListOfSpeciesReferences class is used to store lists of reactants
and products in a Reaction object.
As with the various other ListOf___ classes in SBML, the
ListOfSpeciesReferences is merely a container used for organizing
instances of other objects, in this case SpeciesReference objects.
ListOfSpeciesReferences is derived from the abstract class SBase, and
inherit the various attributes and subelements of SBase, such as
"metaid" as and "annotation".  The ListOf___ classes do not add any
attributes of their own.


=over

=item SimpleSpeciesReference::SimpleSpeciesReference

Creates a new SimpleSpeciesReference, optionally with its "species"
attribute set.
The "species" attribute on SpeciesReference and
ModifierSpeciesReference is required to have a value in SBML.
Although the attribute is optional in this constructor, callers should
provide a value or use setSpecies() shortly after creating the object.
@param species the identifier of the species to be referenced
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item SimpleSpeciesReference::SimpleSpeciesReference

Creates a new SimpleSpeciesReference using the given SBML C<level> and C<version>
values and optionally a set of XMLNamespaces.
@param level an unsigned int, the SBML Level to assign to this SimpleSpeciesReference
@param version an unsigned int, the SBML Version to assign to this
SimpleSpeciesReference

@param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
assign to this SimpleSpeciesReference
@note Once a SimpleSpeciesReference has been added to an SBMLDocument, the C<level>,
C<version> and C<xmlns> namespaces for the document I<override> those used
to create the SimpleSpeciesReference.  Despite this, the ability to supply the values
at creation time is an important aid to creating valid SBML.  Knowledge of
the intented SBML Level and Version determine whether it is valid to
assign a particular value to an attribute, or whether it is valid to add
an object to an existing SBMLDocument.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.

@deprecated libSBML internal


=item SimpleSpeciesReference::SimpleSpeciesReference

Copy constructor; creates a copy of this SimpleSpeciesReference.


=item SimpleSpeciesReference::accept

Accepts the given SBMLVisitor.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>.


=item SimpleSpeciesReference::getSpecies

Get the value of the "species" attribute.
Returns the value of the attribute "species" for this
SimpleSpeciesReference.



=item SimpleSpeciesReference::isSetSpecies

Predicate returning C<true> or C<false> depending on whether this
SimpleSpeciesReference's "species" attribute has been set.
Returns C<true> if the "species" attribute of this
SimpleSpeciesReference has been set, C<false> otherwise.


=item SimpleSpeciesReference::setSpecies

Sets the "species" attribute of this SimpleSpeciesReference.
The identifier string passed in C<sid> is copied.
@param sid the identifier of a species defined in the enclosing
Model's ListOfSpecies.


=item SimpleSpeciesReference::isModifier

Predicate returning C<true> or C<false> depending on whether this
is a ModifierSpeciesReference.
Returns C<true> if this SimpleSpeciesReference's subclass is
ModiferSpeciesReference, C<false> if it is a plain SpeciesReference.


=item SimpleSpeciesReference::readAttributes

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.
@deprecated libSBML internal


=item SimpleSpeciesReference::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item SimpleSpeciesReference::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item SpeciesReference::SpeciesReference

Creates a new SpeciesReference, optionally setting its "species",
"stoichiometry" and "denominator" attribute values.
The "denominator" attribute is only actually written out in the case
of an SBML Level 1 model.  In SBML Level 2, rational-number
stoichiometries are written as MathML elements in the
"stoichiometryMath" subelement.  However, as a convenience to users,
libSBML allows the creation and manipulation of rational-number
stoichiometries by supplying the numerator and denominator directly
rather than having to manually create an ASTNode structure.  LibSBML
will write out the appropriate constructs (either a combination of
"stoichiometry" and "denominator" in the case of SBML Level 1, or a
"stoichiometryMath" subelement in the case of SBML Level 2).
@param species the identifier of the species to be referenced
@param stoichiometry the (simple) stoichoiometry
@param denominator the denominator, in the case where the stoichoiometry
is a rational number
@note The "species" attribute on SpeciesReference is required to have
a value in SBML.  Although the attribute is optional in this
constructor, callers should provide a value or use setSpecies()
shortly after creating the object.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item SpeciesReference::SpeciesReference

Creates a new SpeciesReference using the given SBML C<level> and C<version>
values and optionally a set of XMLNamespaces.
@param level an unsigned int, the SBML Level to assign to this SpeciesReference
@param version an unsigned int, the SBML Version to assign to this
SpeciesReference

@param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
assign to this SpeciesReference
@note Once a SpeciesReference has been added to an SBMLDocument, the C<level>,
C<version> and C<xmlns> namespaces for the document I<override> those used
to create the SpeciesReference.  Despite this, the ability to supply the values
at creation time is an important aid to creating valid SBML.  Knowledge of
the intented SBML Level and Version determine whether it is valid to
assign a particular value to an attribute, or whether it is valid to add
an object to an existing SBMLDocument.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.

@deprecated libSBML internal


=item SpeciesReference::SpeciesReference

Copy constructor; creates a copy of this SpeciesReference.


=item SpeciesReference::accept

Accepts the given SBMLVisitor.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>.


=item SpeciesReference::clone

Creates and returns a deep copy of this SpeciesReference instance.
Returns a (deep) copy of this SpeciesReference.


=item SpeciesReference::initDefaults

Initializes the attributes of this SpeciesReference to their defaults.

=over


=item

stoichiometry is set to C<1>

=item

denominator is set to C<1>

=back


@see getDenominator()
@see setDenominator()
@see getStoichiometry()
@see setStoichiometry()
@see getStoichiometryMath()
@see setStoichiometryMath()


=item SpeciesReference::getStoichiometry

Get the value of the "stoichiometry" attribute.
In SBML Level 2, Product and reactant stoichiometries can be specified
using <em>either</em> "stoichiometry" or "stoichiometryMath" in a
SpeciesReference object.  The former is to be used when a
stoichiometry is simply a scalar number, while the latter is for
occasions when it needs to be a rational number or it needs to
reference other mathematical expressions.  The "stoichiometry"
attribute is of type double and should contain values greater than
zero (0).  The "stoichiometryMath" element is implemented as an
element containing a MathML expression.  These two are mutually
exclusive; only one of "stoichiometry" or "stoichiometryMath" should
be defined in a given SpeciesReference instance.  When neither the
attribute nor the element is present, the value of "stoichiometry" in
the SpeciesReference instance defaults to C<1>.  For maximum
interoperability between different software tools, the "stoichiometry"
attribute should be   used in preference to "stoichiometryMath" when a
species' stoichiometry   is a simple scalar number (integer or
decimal).

Returns the value of the (scalar) "stoichiometry" attribute of this
SpeciesReference.

@see getStoichiometryMath()


=item SpeciesReference::getStoichiometryMath

Get the content of the "stoichiometryMath" subelement as an ASTNode
tree.

In SBML Level 2, Product and reactant stoichiometries can be specified
using <em>either</em> "stoichiometry" or "stoichiometryMath" in a
SpeciesReference object.  The former is to be used when a
stoichiometry is simply a scalar number, while the latter is for
occasions when it needs to be a rational number or it needs to
reference other mathematical expressions.  The "stoichiometry"
attribute is of type double and should contain values greater than
zero (0).  The "stoichiometryMath" element is implemented as an
element containing a MathML expression.  These two are mutually
exclusive; only one of "stoichiometry" or "stoichiometryMath" should
be defined in a given SpeciesReference instance.  When neither the
attribute nor the element is present, the value of "stoichiometry" in
the SpeciesReference instance defaults to C<1>.  For maximum
interoperability between different software tools, the "stoichiometry"
attribute should be used in preference to "stoichiometryMath" when a
species' stoichiometry is a simple scalar number (integer or
decimal).

Returns the content of the "stoichiometryMath" subelement of this
SpeciesReference.



=item SpeciesReference::getStoichiometryMath

Get the content of the "stoichiometryMath" subelement as an ASTNode
tree.

In SBML Level 2, Product and reactant stoichiometries can be specified
using <em>either</em> "stoichiometry" or "stoichiometryMath" in a
SpeciesReference object.  The former is to be used when a
stoichiometry is simply a scalar number, while the latter is for
occasions when it needs to be a rational number or it needs to
reference other mathematical expressions.  The "stoichiometry"
attribute is of type double and should contain values greater than
zero (0).  The "stoichiometryMath" element is implemented as an
element containing a MathML expression.  These two are mutually
exclusive; only one of "stoichiometry" or "stoichiometryMath" should
be defined in a given SpeciesReference instance.  When neither the
attribute nor the element is present, the value of "stoichiometry" in
the SpeciesReference instance defaults to C<1>.  For maximum
interoperability between different software tools, the "stoichiometry"
attribute should be used in preference to "stoichiometryMath" when a
species' stoichiometry is a simple scalar number (integer or
decimal).

Returns the content of the "stoichiometryMath" subelement of this
SpeciesReference.



=item SpeciesReference::getDenominator

Get the value of the "denominator" attribute, for the case of a
rational-numbered stoichiometry or a model in SBML Level 1.
The "denominator" attribute is only actually written out in the case
of an SBML Level 1 model.  In SBML Level 2, rational-number
stoichiometries are written as MathML elements in the
"stoichiometryMath" subelement.  However, as a convenience to users,
libSBML allows the creation and manipulation of rational-number
stoichiometries by supplying the numerator and denominator directly
rather than having to manually create an ASTNode structure.  LibSBML
will write out the appropriate constructs (either a combination of
"stoichiometry" and "denominator" in the case of SBML Level 1, or a
"stoichiometryMath" subelement in the case of SBML Level 2).
Returns the value of the "denominator" attribute of this
SpeciesReference.



=item SpeciesReference::isSetStoichiometryMath

Predicate returning C<true> or C<false> depending on whether this
SpeciesReference's "stoichiometryMath" subelement has been set
Returns C<true> if the "stoichiometryMath" subelement of this
SpeciesReference has been set, C<false> otherwise.


=item SpeciesReference::setStoichiometry

Sets the value of the "stoichiometry" attribute of this
SpeciesReference.

In SBML Level 2, Product and reactant stoichiometries can be specified
using <em>either</em> "stoichiometry" or "stoichiometryMath" in a
SpeciesReference object.  The former is to be used when a
stoichiometry is simply a scalar number, while the latter is for
occasions when it needs to be a rational number or it needs to
reference other mathematical expressions.  The "stoichiometry"
attribute is of type double and should contain values greater than
zero (0).  The "stoichiometryMath" element is implemented as an
element containing a MathML expression.  These two are mutually
exclusive; only one of "stoichiometry" or "stoichiometryMath" should
be defined in a given SpeciesReference instance.  When neither the
attribute nor the element is present, the value of "stoichiometry" in
the SpeciesReference instance defaults to C<1>.  For maximum
interoperability between different software tools, the "stoichiometry"
attribute should be used in preference to "stoichiometryMath" when a
species' stoichiometry is a simple scalar number (integer or
decimal).

@param value the new value of the "stoichiometry" attribute


=item SpeciesReference::setStoichiometryMath

Sets the "stoichiometryMath" subelement of this SpeciesReference.
The Abstract Syntax Tree in C<math> is copied.
In SBML Level 2, Product and reactant stoichiometries can be specified
using <em>either</em> "stoichiometry" or "stoichiometryMath" in a
SpeciesReference object.  The former is to be used when a
stoichiometry is simply a scalar number, while the latter is for
occasions when it needs to be a rational number or it needs to
reference other mathematical expressions.  The "stoichiometry"
attribute is of type double and should contain values greater than
zero (0).  The "stoichiometryMath" element is implemented as an
element containing a MathML expression.  These two are mutually
exclusive; only one of "stoichiometry" or "stoichiometryMath" should
be defined in a given SpeciesReference instance.  When neither the
attribute nor the element is present, the value of "stoichiometry" in
the SpeciesReference instance defaults to C<1>.  For maximum
interoperability between different software tools, the "stoichiometry"
attribute should be used in preference to "stoichiometryMath" when a
species' stoichiometry is a simple scalar number (integer or
decimal).

@param math the StoichiometryMath expression that is to be copied as the
content of the "stoichiometryMath" subelement.


=item SpeciesReference::setDenominator

Set the value of the "denominator" attribute, for the case of a
rational-numbered stoichiometry or a model in SBML Level 1.
The "denominator" attribute is only actually written out in the case
of an SBML Level 1 model.  In SBML Level 2, rational-number
stoichiometries are written as MathML elements in the
"stoichiometryMath" subelement.  However, as a convenience to users,
libSBML allows the creation and manipulation of rational-number
stoichiometries by supplying the numerator and denominator directly
rather than having to manually create an ASTNode structure.  LibSBML
will write out the appropriate constructs (either a combination of
"stoichiometry" and "denominator" in the case of SBML Level 1, or a
"stoichiometryMath" subelement in the case of SBML Level 2).
@param value the scalar value 


=item SpeciesReference::unsetStoichiometryMath

Unsets the "stoichiometryMath" subelement of this SpeciesReference.
In SBML Level 2, Product and reactant stoichiometries can be specified
using <em>either</em> "stoichiometry" or "stoichiometryMath" in a
SpeciesReference object.  The former is to be used when a
stoichiometry is simply a scalar number, while the latter is for
occasions when it needs to be a rational number or it needs to
reference other mathematical expressions.  The "stoichiometry"
attribute is of type double and should contain values greater than
zero (0).  The "stoichiometryMath" element is implemented as an
element containing a MathML expression.  These two are mutually
exclusive; only one of "stoichiometry" or "stoichiometryMath" should
be defined in a given SpeciesReference instance.  When neither the
attribute nor the element is present, the value of "stoichiometry" in
the SpeciesReference instance defaults to C<1>.  For maximum
interoperability between different software tools, the "stoichiometry"
attribute should be used in preference to "stoichiometryMath" when a
species' stoichiometry is a simple scalar number (integer or
decimal).




=item SpeciesReference::setAnnotation

Sets the value of the "annotation" subelement of this SBML object to a
copy of C<annotation>.
Any existing content of the "annotation" subelement is discarded.
Unless you have taken steps to first copy and reconstitute any
existing annotations into the C<annotation> that is about to be
assigned, it is likely that performing such wholesale replacement is
unfriendly towards other software applications whose annotations are
discarded.  An alternative may be to use appendAnnotation().
@param annotation an XML structure that is to be used as the content
of the "annotation" subelement of this object
@see appendAnnotation()


=item SpeciesReference::setAnnotation

Sets the value of the "annotation" subelement of this SBML object to a
copy of C<annotation>.
Any existing content of the "annotation" subelement is discarded.
Unless you have taken steps to first copy and reconstitute any
existing annotations into the C<annotation> that is about to be
assigned, it is likely that performing such wholesale replacement is
unfriendly towards other software applications whose annotations are
discarded.  An alternative may be to use appendAnnotation().
@param annotation an XML string that is to be used as the content
of the "annotation" subelement of this object
@see appendAnnotation()


=item SpeciesReference::appendAnnotation

Appends annotation content to any existing content in the "annotation"
subelement of this object.
The content in C<annotation> is copied.  Unlike setAnnotation(), this
method allows other annotations to be preserved when an application
adds its own data.
@param annotation an XML structure that is to be copied and appended
to the content of the "annotation" subelement of this object
@see setAnnotation()


=item SpeciesReference::appendAnnotation

Appends annotation content to any existing content in the "annotation"
subelement of this object.
The content in C<annotation> is copied.  Unlike setAnnotation(), this
method allows other annotations to be preserved when an application
adds its own data.
@param annotation an XML string that is to be copied and appended
to the content of the "annotation" subelement of this object
@see setAnnotation()


=item SpeciesReference::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for this object, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item SpeciesReference::getElementName

Returns the XML element name of this object, which for
SpeciesReference, is always C<"speciesReference">.
Returns the name of this element, i.e., C<"speciesReference">.


=item SpeciesReference::writeElements

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.
@deprecated libSBML internal


=item SpeciesReference::sortMath

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.
@deprecated libSBML internal


=item SpeciesReference::createObject

Returns the SBML object corresponding to next XMLToken in the
XMLInputStream or NULL if the token was not recognized.
@deprecated libSBML internal


=item SpeciesReference::readOtherXML

Subclasses should override this method to read (and store) XHTML,
MathML, etc. directly from the XMLInputStream.
Returns true if the subclass read from the stream, false otherwise.
@deprecated libSBML internal


=item SpeciesReference::readAttributes

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.
@deprecated libSBML internal


=item SpeciesReference::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item SpeciesReference::syncAnnotation

Synchronizes the annotation of this SBML object.
Annotation element (XMLNode  mAnnotation) is synchronized with the
current CVTerm objects (List  mCVTerm) and id string (std::string mId)
Currently, this method is called in getAnnotation, isSetAnnotation,
and writeElements methods.
@deprecated libSBML internal


=item SpeciesReference::syncAnnotation

Synchronizes the annotation of this SBML object.
Annotation element (XMLNode  mAnnotation) is synchronized with the
current CVTerm objects (List  mCVTerm) and id string (std::string mId)
Currently, this method is called in getAnnotation, isSetAnnotation,
and writeElements methods.
@deprecated libSBML internal


=item SpeciesReference::syncAnnotation

Synchronizes the annotation of this SBML object.
Annotation element (XMLNode  mAnnotation) is synchronized with the
current CVTerm objects (List  mCVTerm) and id string (std::string mId)
Currently, this method is called in getAnnotation, isSetAnnotation,
and writeElements methods.
@deprecated libSBML internal


=item SpeciesReference::syncAnnotation

Synchronizes the annotation of this SBML object.
Annotation element (XMLNode  mAnnotation) is synchronized with the
current CVTerm objects (List  mCVTerm) and id string (std::string mId)
Currently, this method is called in getAnnotation, isSetAnnotation,
and writeElements methods.
@deprecated libSBML internal


=item ModifierSpeciesReference::ModifierSpeciesReference

Creates a new ModiferSpeciesReference, optionally with its "species"
attribute set.
The "species" attribute on SpeciesReference and
ModifierSpeciesReference is required to have a value in SBML.
Although the attribute is optional in this constructor, callers should
provide a value or use setSpecies() shortly after creating the object.
@param species the identifier of the species to be referenced
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item ModifierSpeciesReference::ModifierSpeciesReference

Creates a new ModifierSpeciesReference using the given SBML C<level> and C<version>
values and optionally a set of XMLNamespaces.
@param level an unsigned int, the SBML Level to assign to this ModifierSpeciesReference
@param version an unsigned int, the SBML Version to assign to this
ModifierSpeciesReference

@param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
assign to this ModifierSpeciesReference
@note Once a ModifierSpeciesReference has been added to an SBMLDocument, the C<level>,
C<version> and C<xmlns> namespaces for the document I<override> those used
to create the ModifierSpeciesReference.  Despite this, the ability to supply the values
at creation time is an important aid to creating valid SBML.  Knowledge of
the intented SBML Level and Version determine whether it is valid to
assign a particular value to an attribute, or whether it is valid to add
an object to an existing SBMLDocument.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.

@deprecated libSBML internal


=item ModifierSpeciesReference::accept

Accepts the given SBMLVisitor.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>.


=item ModifierSpeciesReference::clone

Creates and returns a deep copy of this ModifierSpeciesReference
instance.

Returns a (deep) copy of this ModifierSpeciesReference.


=item ModifierSpeciesReference::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for this object, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item ModifierSpeciesReference::getElementName

Returns the XML element name of this object, which for Species, is
always C<"modifierSpeciesReference">.
Returns the name of this element, i.e., C<"modifierSpeciesReference">.


=item ModifierSpeciesReference::writeElements

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.
@deprecated libSBML internal


=item ModifierSpeciesReference::readOtherXML

Subclasses should override this method to read (and store) XHTML,
MathML, etc. directly from the XMLInputStream.
Returns true if the subclass read from the stream, false otherwise.
@deprecated libSBML internal


=item ListOfSpeciesReferences::ListOfSpeciesReferences

Creates a new, empty ListOfSpeciesReferences.


=item ListOfSpeciesReferences::clone

Creates and returns a deep copy of this ListOfSpeciesReferences
instance.

Returns a (deep) copy of this ListOfSpeciesReferences.


=item ListOfSpeciesReferences::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for this object, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item ListOfSpeciesReferences::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., SpeciesReference objects, if the list is non-empty).
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for the objects contained in this ListOf
instance, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item ListOfSpeciesReferences::getElementName

Returns the XML element name of this object.
For ListOfSpeciesReferences, the XML element name is @c
"listOfSpeciesReferences".

Returns the name of this element, i.e., C<"listOfSpeciesReferences">.


=item ListOfSpeciesReferences::get

Get a SpeciesReference from the ListOfSpeciesReferences.
@param n the index number of the SpeciesReference to get.
Returns the nth SpeciesReference in this ListOfSpeciesReferences.
@see size()


=item ListOfSpeciesReferences::get

Get a SpeciesReference from the ListOfSpeciesReferences.
@param n the index number of the SpeciesReference to get.
Returns the nth SpeciesReference in this ListOfSpeciesReferences.
@see size()


=item ListOfSpeciesReferences::get

Get a SpeciesReference from the ListOfSpeciesReferences
based on its identifier.
@param sid a string representing the identifier 
of the SpeciesReference to get.
Returns SpeciesReference in this ListOfSpeciesReferences
with the given id or NULL if no such
SpeciesReference exists.
@see get(unsigned int n)
@see size()


=item ListOfSpeciesReferences::get

Get a SpeciesReference from the ListOfSpeciesReferences
based on its identifier.
@param sid a string representing the identifier 
of the SpeciesReference to get.
Returns SpeciesReference in this ListOfSpeciesReferences
with the given id or NULL if no such
SpeciesReference exists.
@see get(unsigned int n)
@see size()


=item ListOfSpeciesReferences::remove

Removes the nth item from this ListOfSpeciesReferences items and returns a pointer to
it.

The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove
@see size()


=item ListOfSpeciesReferences::remove

Removes item in this ListOfSpeciesReferences items with the given identifier.
The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier C<sid>, then @c
NULL is returned.
@param sid the identifier of the item to remove
Returns the item removed.  As mentioned above, the caller owns the
returned item.


=item ListOfSpeciesReferences::getElementPosition

Get the ordinal position of this element in the containing object
(which in this case is the Model object).
Returns the ordinal position of the element with respect to its
siblings, or C<-1> (default) to indicate the position is not significant.
@deprecated libSBML internal


=item ListOfSpeciesReferences::setType

Sets type of this ListOfSpeciesReferences.
@deprecated libSBML internal


=item ListOfSpeciesReferences::createObject

Returns the SBML object corresponding to next XMLToken in the
XMLInputStream or NULL if the token was not recognized.
@deprecated libSBML internal


=item ListOfSpeciesReferences::createObject

Returns the SBML object corresponding to next XMLToken in the
XMLInputStream or NULL if the token was not recognized.
@deprecated libSBML internal


=item ListOfSpeciesReferences::createObject

Returns the SBML object corresponding to next XMLToken in the
XMLInputStream or NULL if the token was not recognized.
@deprecated libSBML internal


=back

=head2 Event

LibSBML implementation of SBML's Event construct.
An Event object defines when the event can occur, the variables that are
affected by the event, and how the variables are affected.
An Event definition has several parts: an optional identifier (defined
by the attribute "id"), an optional name (defined by the attribute
"name"), a required trigger condition (defined by an object of class
Trigger), and at least one EventAssignment.  In addition, an event can
include an optional delay (defined by an object of class Delay).
The operation of Event is divided into two phases (even when the event
is not delayed): one when the event is I<fired>, and the other when the
event is I<executed>.  Trigger objects define the conditions for firing
an event, Delay objects define when the event is actually executed, and
EventAssignment objects define the effects of executing the event.
Please consult the descriptions of Trigger, Delay and EventAssignment
for more information.
The optional Delay on Event means there are two times to consider when
computing the results of an event: the time at which the event
<em>fires</em>, and the time at which assignments are <em>executed</em>.
It is also possible to distinguish between the time at which the
EventAssignment's expression is calculated, and the time at which the
assignment is made: the expression could be evaluated at the same time
the assignments are performed, i.e., when the event is
<em>executed</em>, but it could also be defined to be evaluated at the
time the event <em>fired</em>.
In SBML Level&nbsp;2 versions prior to Version&nbsp;4, the semantics of
Event time delays were defined such that the expressions in the event's
assignments were always evaluated at the time the event was
<em>fired</em>.  This definition made it difficult to define an event
whose assignment formulas were meant to be evaluated at the time the
event was <em>executed</em> (i.e., after the time period defined by the
value of the Delay element).  In SBML Level&nbsp;2 Version&nbsp;4, the
attribute "useValuesFromTriggerTime" on Event allows a model to indicate
the time at which the event's assignments are intended to be evaluated.
The default value is C<true>, which corresponds to the interpretation of
event assignments prior to Version&nbsp;4: the values of the assignment
formulas are computed at the moment the event fired, not after the
delay.  If "useValuesFromTriggerTime"=C<false>, it means that the
formulas in the event's assignments are to be computed after the delay,
at the time the event is executed.
@section version-diffs SBML version differences
Definitions of Event in SBML Level&nbsp;2 Versions 1 and 2 included an
additional attribute called "timeUnits", which allowed the time units of
the Delay to be set explicitly.  Versions&nbsp;3 and&nbsp;4 do not
define this attribute.  The LibSBML supports this attribute for
compatibility with previous versions of SBML Level&nbsp;2; however, if a
Version&nbsp;3 or&nbsp;4 model sets the attribute, the
consistency-checking method SBMLDocument::checkConsistency() will report
an error.
The attribute "useValuesFromTriggerTime" was introduced in SBML
Level&nbsp;2 Version&nbsp;4.  Models defined in prior Versions of SBML
Level&nbsp;2 cannot use this attribute, and
SBMLDocument::checkConsistency() will report an error if they do.


=over

=back

=head2 ListOfEvents

LibSBML implementation of SBML's ListOfEvents construct.
The various ListOf___ classes in SBML are merely containers used for
organizing the main components of an SBML model.  All are derived from
the abstract class SBase, and inherit the various attributes and
subelements of SBase, such as "metaid" as and "annotation".  The
ListOf___ classes do not add any attributes of their own.
The relationship between the lists and the rest of an SBML model is
illustrated by the following (for SBML Level&nbsp;2 Version&nbsp;4):
@image html listof-illustration.jpg "ListOf___ elements in an SBML Model"
@image latex listof-illustration.jpg "ListOf___ elements in an SBML Model"
Readers may wonder about the motivations for using the ListOf___
containers.  A simpler approach in XML might be to place the components
all directly at the top level of the model definition.  We chose instead
to group them within XML elements named after ListOf<em>Classname</em>,
in part because we believe this helps organize the components and makes
visual reading of models in XML easier.  More importantly, the fact that
the container classes are derived from SBase means that software tools
can add information about the lists themselves into each list
container's "annotation".
@see ListOfFunctionDefinitions
@see ListOfUnitDefinitions
@see ListOfCompartmentTypes
@see ListOfSpeciesTypes
@see ListOfCompartments
@see ListOfSpecies
@see ListOfParameters
@see ListOfInitialAssignments
@see ListOfRules
@see ListOfConstraints
@see ListOfReactions
@see ListOfEvents


=over

=item Event::Event

Creates a new Event, optionally with specific values of C<id> and @p
name attributes.
@param id a string, the identifier to assign to this Event
@param name a string, the name to be assigned to this Event
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item Event::Event

Creates a new Event using the given SBML C<level> and C<version>
values and optionally a set of XMLNamespaces.
@param level an unsigned int, the SBML Level to assign to this Event
@param version an unsigned int, the SBML Version to assign to this
Event

@param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
assign to this Event
@note Once a Event has been added to an SBMLDocument, the C<level>,
C<version> and C<xmlns> namespaces for the document I<override> those used
to create the Event.  Despite this, the ability to supply the values
at creation time is an important aid to creating valid SBML.  Knowledge of
the intented SBML Level and Version determine whether it is valid to
assign a particular value to an attribute, or whether it is valid to add
an object to an existing SBMLDocument.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.

@deprecated libSBML internal


=item Event::Event

Copy constructor; creates a copy of this Event.


=item Event::accept

Accepts the given SBMLVisitor for this instance of Event.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>, which indicates
whether the Visitor would like to visit the next Event in the list
of events within which this Event is embedded.


=item Event::clone

Creates and returns a deep copy of this Event.
Returns a (deep) copy of this Event.


=item Event::getTrigger

Get the event trigger portion of this Event.
Returns the Trigger object of this Event.


=item Event::getTrigger

Get the event trigger portion of this Event.
Returns the Trigger object of this Event.


=item Event::getDelay

Get the assignment delay portion of this Event, if there is one.
Returns the delay of this Event if one is defined, or C<NULL> if none
is defined.


=item Event::getDelay

Get the assignment delay portion of this Event, if there is one.
Returns the delay of this Event if one is defined, or C<NULL> if none
is defined.


=item Event::getTimeUnits

Get the value of the "timeUnits" attribute of this Event, if it has one.
Returns the value of the attribute "timeUnits" as a string.
@warning Definitions of Event in SBML Level 2 Versions&nbsp;1
and&nbsp;2 included the additional attribute called "timeUnits", but
it was removed in SBML Level&nbsp;2 Version&nbsp;3.  LibSBML supports
this attribute for compatibility with previous versions of SBML
Level&nbsp;2, but its use is discouraged since models in Level 2
Versions&nbsp;3 and&nbsp;4 cannot contain it.  If a Version&nbsp;3
or&nbsp;4 model sets the attribute, the consistency-checking method
SBMLDocument::checkConsistency() will report an error.


=item Event::getUseValuesFromTriggerTime

Get the value of the "useValuesFromTriggerTime" attribute of this Event.
The optional Delay on Event means there are two times to consider when
computing the results of an event: the time at which the event
<em>fires</em>, and the time at which assignments are <em>executed</em>.
It is also possible to distinguish between the time at which the
EventAssignment's expression is calculated, and the time at which the
assignment is made: the expression could be evaluated at the same time
the assignments are performed, i.e., when the event is
<em>executed</em>, but it could also be defined to be evaluated at the
time the event <em>fired</em>.
In SBML Level&nbsp;2 versions prior to Version&nbsp;4, the semantics of
Event time delays were defined such that the expressions in the event's
assignments were always evaluated at the time the event was
<em>fired</em>.  This definition made it difficult to define an event
whose assignment formulas were meant to be evaluated at the time the
event was <em>executed</em> (i.e., after the time period defined by the
value of the Delay element).  In SBML Level&nbsp;2 Version&nbsp;4, the
attribute "useValuesFromTriggerTime" on Event allows a model to indicate
the time at which the event's assignments are intended to be evaluated.
The default value is C<true>, which corresponds to the interpretation of
event assignments prior to Version&nbsp;4: the values of the assignment
formulas are computed at the moment the event fired, not after the
delay.  If "useValuesFromTriggerTime"=C<false>, it means that the
formulas in the event's assignments are to be computed after the delay,
at the time the event is executed.
Returns the value of the attribute "useValuesFromTriggerTime" as a boolean.
@warning The attribute "useValuesFromTriggerTime" was introduced in
SBML Level&nbsp;2 Version&nbsp;4.  It is not valid in models defined
using SBML Level&nbsp;2 versions prior to Version&nbsp;4.  If a
Version&nbsp;1&ndash;&nbsp;3 model sets the attribute, the
consistency-checking method SBMLDocument::checkConsistency() will
report an error.


=item Event::isSetTrigger

Predicate for testing whether the trigger for this Event has been set.
@htmlinclude libsbml-comment-set-methods.html
Returns C<true> if the trigger of this Event has been set, C<false>
otherwise.



=item Event::isSetDelay

Predicate for testing whether the delay for this Event has been set.
@htmlinclude libsbml-comment-set-methods.html
Returns C<true> if the delay of this Event has been set, C<false>
otherwise.



=item Event::isSetTimeUnits

Predicate for testing whether the "timeUnits" attribute of this Event
has been set.
@htmlinclude libsbml-comment-set-methods.html
Returns C<true> if the "timeUnits" attribute of this Event has been
set, C<false> otherwise.
@warning Definitions of Event in SBML Level 2 Versions&nbsp;1
and&nbsp;2 included the additional attribute called "timeUnits", but
it was removed in SBML Level&nbsp;2 Version&nbsp;3.  LibSBML supports
this attribute for compatibility with previous versions of SBML
Level&nbsp;2, but its use is discouraged since models in Level 2
Versions&nbsp;3 and&nbsp;4 cannot contain it.  If a Version&nbsp;3
or&nbsp;4 model sets the attribute, the consistency-checking method
SBMLDocument::checkConsistency() will report an error.


=item Event::setTrigger

Sets the trigger definition of this Event to a copy of the given
Trigger object instance.
@htmlinclude libsbml-comment-set-methods.html
@param trigger the Trigger object instance to use.


=item Event::setDelay

Sets the delay definition of this Event to a copy of the given Delay
object instance.
@htmlinclude libsbml-comment-set-methods.html
@param delay the Delay object instance to use


=item Event::setTimeUnits

Sets the "timeUnits" attribute of this Event to a copy of C<sid>.
@htmlinclude libsbml-comment-set-methods.html
@param sid the identifier of the time units to use.
@warning Definitions of Event in SBML Level 2 Versions&nbsp;1
and&nbsp;2 included the additional attribute called "timeUnits", but
it was removed in SBML Level&nbsp;2 Version&nbsp;3.  LibSBML supports
this attribute for compatibility with previous versions of SBML
Level&nbsp;2, but its use is discouraged since models in Level 2
Versions&nbsp;3 and&nbsp;4 cannot contain it.  If a Version&nbsp;3
or&nbsp;4 model sets the attribute, the consistency-checking method
SBMLDocument::checkConsistency() will report an error.


=item Event::setUseValuesFromTriggerTime

Sets the "useValuesFromTriggerTime" attribute of this Event to a C<value>.
The optional Delay on Event means there are two times to consider when
computing the results of an event: the time at which the event
<em>fires</em>, and the time at which assignments are <em>executed</em>.
It is also possible to distinguish between the time at which the
EventAssignment's expression is calculated, and the time at which the
assignment is made: the expression could be evaluated at the same time
the assignments are performed, i.e., when the event is
<em>executed</em>, but it could also be defined to be evaluated at the
time the event <em>fired</em>.
In SBML Level&nbsp;2 versions prior to Version&nbsp;4, the semantics of
Event time delays were defined such that the expressions in the event's
assignments were always evaluated at the time the event was
<em>fired</em>.  This definition made it difficult to define an event
whose assignment formulas were meant to be evaluated at the time the
event was <em>executed</em> (i.e., after the time period defined by the
value of the Delay element).  In SBML Level&nbsp;2 Version&nbsp;4, the
attribute "useValuesFromTriggerTime" on Event allows a model to indicate
the time at which the event's assignments are intended to be evaluated.
The default value is C<true>, which corresponds to the interpretation of
event assignments prior to Version&nbsp;4: the values of the assignment
formulas are computed at the moment the event fired, not after the
delay.  If "useValuesFromTriggerTime"=C<false>, it means that the
formulas in the event's assignments are to be computed after the delay,
at the time the event is executed.
@param value the value of useValuesFromTriggerTime to use.
@warning The attribute "useValuesFromTriggerTime" was introduced in
SBML Level&nbsp;2 Version&nbsp;4.  It is not valid in models defined
using SBML Level&nbsp;2 versions prior to Version&nbsp;4.  If a
Version&nbsp;1&ndash;&nbsp;3 model sets the attribute, the
consistency-checking method SBMLDocument::checkConsistency() will
report an error.


=item Event::unsetDelay

Unsets the Delay of this Event.
@htmlinclude libsbml-comment-set-methods.html


=item Event::unsetTimeUnits

Unsets the "timeUnits" attribute of this Event.
@htmlinclude libsbml-comment-set-methods.html
@warning Definitions of Event in SBML Level&nbsp;2 Versions 1 and 2
included the attribute called "timeUnits", but it was removed in SBML
Level&nbsp;2 Version&nbsp;3.  LibSBML supports this attribute for
compatibility with previous versions of SBML Level&nbsp;2, but its use
is discouraged since models in Level&nbsp;2 Version&nbsp;3 and
Version&nbsp;4 cannot contain it.  If a Version&nbsp;3 or&nbsp;4 model
sets this attribute, the consistency-checking method
SBMLDocument::checkConsistency() will report an error.


=item Event::addEventAssignment

Appends a copy of the given EventAssignment to this Event.
@param ea the EventAssignment object to add.
@note This method should be used with some caution.  The fact that
this method I<copies> the object passed to it means that the caller
will be left holding a physically different object instance than the
one contained in this Event.  Changes made to the original object
instance (such as resetting attribute values) will <em>not affect the
instance in the Event</em>.  In addition, the caller should make sure
to free the original object if it is no longer being used, or else a
memory leak will result.  Please see Event::createEventAssignment()
for a method that does not lead to these issues.
@see createEventAssignment()


=item Event::createEventAssignment

Creates a new, empty EventAssignment, adds it to this Event's list of
event assignments and returns the EventAssignment.
Returns the newly created EventAssignment object instance
@see addEvent()


=item Event::getListOfEventAssignments

Returns the list of event assignments for this Event.
Returns the list of EventAssignments for this Event.


=item Event::getListOfEventAssignments

Returns the list of event assignments for this Event.
Returns the list of EventAssignments for this Event.


=item Event::getEventAssignment

Return a specific EventAssignment object of this Event.
@param n an integer, the index of the EventAssignment object to return
Returns the C<n>th EventAssignment of this Event.


=item Event::getEventAssignment

Return a specific EventAssignment object of this Event.
@param n an integer, the index of the EventAssignment object to return
Returns the C<n>th EventAssignment of this Event.


=item Event::getEventAssignment

Return the event assignment indicated by the given C<variable>.
@param variable a string, the identifier of the variable whose
EventAssignment is being sought.
Returns the EventAssignment for the given C<variable>, or C<NULL> if
no such EventAssignment exits.


=item Event::getEventAssignment

Return the event assignment indicated by the given C<variable>.
@param variable a string, the identifier of the variable whose
EventAssignment is being sought.
Returns the EventAssignment for the given C<variable>, or C<NULL> if
no such EventAssignment exits.


=item Event::getNumEventAssignments

Returns the number of EventAssignment objects attached to this
Event.

Returns the number of EventAssignments in this Event.


=item Event::setSBMLDocument

Sets the parent SBMLDocument of this SBML object.
@param d the SBMLDocument to use
@deprecated libSBML internal


=item Event::setParentSBMLObject

Sets the parent SBML object of this SBML object.
@param sb the SBML object to use
@deprecated libSBML internal


=item Event::getTypeCode

Returns the libSBML type code of this object instance.
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for this object, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item Event::getElementName

Returns the XML element name of this object, which for Event, is
always C<"event">.
Returns the name of this element, i.e., C<"event">. 


=item Event::writeElements

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.
@deprecated libSBML internal


=item Event::setInternalIdOnly

sets the mInternalIdOnly flag
@deprecated libSBML internal


=item Event::createObject

Returns the SBML object corresponding to next XMLToken in the
XMLInputStream or C<NULL> if the token was not recognized.
@deprecated libSBML internal


=item Event::readAttributes

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.
@deprecated libSBML internal


=item Event::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Event::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Event::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Event::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Event::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Event::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Event::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item ListOfEvents::clone

Creates and returns a deep copy of this ListOfEvents.
Returns a (deep) copy of this ListOfEvents.


=item ListOfEvents::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for this object, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item ListOfEvents::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., Event objects, if the list is non-empty).
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for the objects contained in this ListOf
instance, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item ListOfEvents::getElementName

Returns the XML element name of this object.
For ListOfEvents, the XML element name is C<"listOfEvents">.
Returns the name of this element, i.e., C<"listOfEvents">.


=item ListOfEvents::get

Get a Event from the ListOfEvents.
@param n the index number of the Event to get.
Returns the C<n>th Event in this ListOfEvents.
@see size()


=item ListOfEvents::get

Get a Event from the ListOfEvents.
@param n the index number of the Event to get.
Returns the C<n>th Event in this ListOfEvents.
@see size()


=item ListOfEvents::get

Get a Event from the ListOfEvents
based on its identifier.
@param sid a string representing the identifier 
of the Event to get.
Returns Event in this ListOfEvents
with the given id or NULL if no such
Event exists.
@see get(unsigned int n)
@see size()


=item ListOfEvents::get

Get a Event from the ListOfEvents
based on its identifier.
@param sid a string representing the identifier 
of the Event to get.
Returns Event in this ListOfEvents
with the given id or NULL if no such
Event exists.
@see get(unsigned int n)
@see size()


=item ListOfEvents::remove

Removes the nth item from this ListOfEvents items and returns a pointer to
it.

The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove
@see size()


=item ListOfEvents::remove

Removes item in this ListOfEvents items with the given identifier.
The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier C<sid>, then @c
NULL is returned.
@param sid the identifier of the item to remove
Returns the item removed.  As mentioned above, the caller owns the
returned item.


=item ListOfEvents::getElementPosition

Get the ordinal position of this element in the containing object
(which in this case is the Model object).
The ordering of elements in the XML form of SBML is generally fixed
for most components in SBML.  So, for example, the ListOfEvents in a
model is (in SBML Level&nbsp;2 Version&nbsp;4) the twelfth ListOf___.
(However, it differs for different Levels and Versions of SBML, so
calling code should not hardwire this number.)
Returns the ordinal position of the element with respect to its
siblings, or C<-1> (default) to indicate the position is not significant.
@deprecated libSBML internal


=item ListOfEvents::createObject

Returns the SBML object corresponding to next XMLToken in the
XMLInputStream or C<NULL> if the token was not recognized.
@deprecated libSBML internal


=back

=head2 EventAssignment

LibSBML implementation of SBML's EventAssignment construct for Event
An Event object defines when the event can occur, the variables that are
affected by the event, and how the variables are affected.  The purpose
of the EventAssignment object class is to define how variables are
affected by an Event.  In every instance of an Event definition in a
model, the object's ListOfEventAssignments must have a non-empty list of
one or more elements of class EventAssignment.
The operation of an Event is divided into two phases (regardless of
whether a delay is involved): one phase when the event is I<fired>, and
the other when the event is I<executed>.  EventAssignment objects are
interpreted when an event is executed.  The effects are described below.
EventAssignment is derived from SBase and adds one attribute
("variable") and one subelement ("math", containing MathML content).
The attribute "variable" is required to have a value.  Its type is the
SBML type C<SId> and can contain the identifier of an existing
Compartment, Species or (global) Parameter instance defined in the
model.

@section event-variable Effects of event assignments
An SBML event assignment has effect when the event is I<executed>; that
is, at the end of any given delay period (if defined) following the
moment that the Event is triggered.  When the event fires, the effect is
to change the value of the model component identified by the "variable"
attribute.

Certain restrictions are placed on what can appear in "variable":

=over


=item

The object identified by the value of the EventAssignment attribute
"variable" must not have its "constant" attribute set to or default to
C<true>.  (Constants cannot be affected by events.)

=item

The "variable" attribute must not contain the identifier of a
reaction; only species, compartment and parameter values may be set by
an Event.

=item

The value of every "variable" attribute must be unique among the set
of EventAssignment structures within a given Event structure.  In other
words, a single event cannot have multiple EventAssignment objects
assigning the same variable.  (All of them would be performed at the
same time when that particular Event triggers, resulting in
indeterminacy.)  However, I<separate> Event instances can refer to the
same variable.

=item

A variable cannot be assigned a value in an EventAssignment object
instance and also be assigned a value by an AssignmentRule; i.e., the
value of an EventAssignment's "variable" attribute cannot be the same as
the value of a AssignmentRule' "variable" attribute.  (Assignment rules
hold at all times, therefore it would be inconsistent to also define an
event that reassigns the value of the same variable.)

=back


Note that the time of assignment of the object identified by the
value of the "variable" attribute is always the time at which the Event
is <em>executed</em>, not when it is <em>fired</em>.  The timing is
controlled by the optional Delay in an Event.  The time of
assignment is not affected by the "useValuesFromTriggerTime"
attribute on Event&mdash;that attribute affects the time at which the
EventAssignment's "math" expression is I<evaluated>.  In other
words, SBML allows decoupling the time at which the
"variable" is assigned from the time at which its value
expression is calculated.
@section event-math The "math" subelement in an EventAssignment
The MathML expression contained in an EventAssignment defines the new
value of the variable being assigned by the Event.  The order of the
EventAssignment structures is not significant; the effect of one
assignment cannot affect the result of another assignment.
The time at which this expression is evaluated is determined by Event's
"useValuesFromTriggerTime" attribute.  If the attribute value is C<true>
(the default), the expression must be evaluated when the event is
<em>fired</em>; more precisely, the values of identifiers occurring in
MathML C<ci> attributes in the EventAssignment's "math" expression are
the values they have at the point when the event <em>fired</em>.  If,
instead, "useValuesFromTriggerTime"'s value is C<false>, it means the
values at <em>execution</em> time should be used; that is, the values of
identifiers occurring in MathML C<ci> attributes in the
EventAssignment's "math" expression are the values they have at the
point when the event <em>executed</em>.
Between Version&nbsp;4 and previous versions of SBML Level&nbsp;2, the
requirements regarding the matching of units between an
EvengAssignment's formula and the units of the object identified by the
"variable" attribute changed.  Previous versions required consistency,
but in Version&nbsp;4, unit consistency is only recommended.  More
precisely: 
=over
 
=item

In the case of a species, an EventAssignment sets
the referenced species' quantity (concentration or amount of substance)
to the value determined by the formula in the EventAssignment's "math"
subelement.  The units of the "math" formula should (in SBML
Level&nbsp;2 Version&nbsp;4) or must (in previous Versions) be identical
to the units of the species.

=item

In the case of a compartment, an EventAssignment sets the
referenced compartment's size to the size determined by the formula in
the "math" subelement of the EventAssignment.  The overall units of the
formula should (in SBML Level&nbsp;2 Version&nbsp;4) or must (in
previous Versions) be identical to the units specified for the size of
the compartment identified by the EventAssignment's "variable"
attribute.


=item

In the case of a parameter, an EventAssignment sets the referenced
parameter's value to that determined by the formula in "math".  The
overall units of the formula should (in SBML Level&nbsp;2
Version&nbsp;4) or must (in previous Versions) be identical to the units
defined for the parameter.

=back


Note that the formula placed in the "math" element <em>has no assumed
units</em>.  The consistency of the units of the formula, and the units
of the entity which the assignment affects, must be explicitly
established just as in the case of the value of the Delay subelement.
An approach similar to the one discussed in the context of Delay may be
used for the formula of an EventAssignment.
@section event-semantics Semantics of Event and EventAssignment
Readers are urged to consult the SBML specification for important
information about the interpretation of Event and EventAssignment.


=over

=back

=head2 ListOfEventAssignments

LibSBML implementation of SBML's ListOfEventAssignments construct.
The various ListOf___ classes in SBML are merely containers used for
organizing the main components of an SBML model.  All are derived from
the abstract class SBase, and inherit the various attributes and
subelements of SBase, such as "metaid" as and "annotation".  The
ListOf___ classes do not add any attributes of their own.
ListOfEventAssignments is entirely contained within Event.


=over

=item EventAssignment::EventAssignment

Creates a new EventAssignment, optionally with its "variable"
attribute and math subelement set.
@param variable the identifier of a Species, Compartment or Parameter
object.

@param math the top ASTNode of an abstract syntax tree defining the
mathematical formula used as the expression for the event assignment's
effect.

@note Although the value of the "variable" attribute is optional in
this constructor, it is worth emphasizing that valid EventAssignment
definitions must have a value for this attribute.  If no variable is
provided at the time of creation, the value is left as the empty
string.  Callers are cautioned to set the value
using @if clike EventAssignment::setVariable(String id) @endif@if java EventAssignment::setVariable() @endif
soon after invoking this constructor.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item EventAssignment::EventAssignment

Creates a new EventAssignment using the given SBML C<level> and C<version>
values and optionally a set of XMLNamespaces.
@param level an unsigned int, the SBML Level to assign to this EventAssignment
@param version an unsigned int, the SBML Version to assign to this
EventAssignment

@param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
assign to this EventAssignment
@note Once a EventAssignment has been added to an SBMLDocument, the C<level>,
C<version> and C<xmlns> namespaces for the document I<override> those used
to create the EventAssignment.  Despite this, the ability to supply the values
at creation time is an important aid to creating valid SBML.  Knowledge of
the intented SBML Level and Version determine whether it is valid to
assign a particular value to an attribute, or whether it is valid to add
an object to an existing SBMLDocument.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.

@deprecated libSBML internal


=item EventAssignment::EventAssignment

Copy constructor; creates a copy of this EventAssignment.


=item EventAssignment::accept

Accepts the given SBMLVisitor for this instance of EventAssignment.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>, which indicates
whether the Visitor would like to visit the next EventAssignment in
the list within which this EventAssignment is embedded (i.e., in the
ListOfEventAssignments located in the enclosing Event instance).


=item EventAssignment::clone

Creates and returns a deep copy of this EventAssignment.
Returns a (deep) copy of this EventAssignment.


=item EventAssignment::getVariable

Get the value of this EventAssignment's "variable" attribute.
Returns the identifier stored in the "variable" attribute of this
EventAssignment.



=item EventAssignment::getMath

Get the mathematical expression in this EventAssignment's "math"
subelement.

Returns the top ASTNode of an abstract syntax tree representing the
mathematical formula in this EventAssignment.


=item EventAssignment::isSetVariable

Predicate for testing whether the attribute "variable" of this
EventAssignment has been set.
Returns C<true> if the "variable" attribute of this EventAssignment
has been set, C<false> otherwise.


=item EventAssignment::isSetMath

Predicate for testing whether the "math" subelement of this
EventAssignment has been set.
Returns C<true> if this EventAssignment has a "math" subelement,
C<false> otherwise.


=item EventAssignment::setVariable

Sets the attribute "variable" of this EventAssignment to a copy of
the given identifier string.
@param sid the identifier of a Compartment, Species or (global)
Parameter defined in this model.


=item EventAssignment::setMath

Sets the "math" subelement of this EventAssignment to a copy of the
given ASTNode.
@param math an ASTNode that will be copied and stored as the
mathematical formula for this EventAssignment.


=item EventAssignment::getDerivedUnitDefinition

Calculates and returns a UnitDefinition that expresses the units
of measurement assumed for the "math" expression of this
EventAssignment.

The units are calculated based on the mathematical expression in the
EventAssignment and the model quantities referenced by
C<&lt;ci&gt;> elements used within that expression.  The
EventAssignment::getDerivedUnitDefinition() method returns the
calculated units.
@warning Note that it is possible the "math" expression in the
EventAssignment contains literal numbers or parameters with undeclared
units.  In those cases, it is not possible to calculate the units of
the overall expression without making assumptions.  LibSBML does not
make assumptions about the units, and
EventAssignment::getDerivedUnitDefinition() only returns the units as
far as it is able to determine them.  For example, in an expression
<em>X + Y</em>, if <em>X</em> has unambiguously-defined units and
<em>Y</em> does not, it will return the units of <em>X</em>.  When
using this method, <strong>it is critical that callers also invoke the
method</strong> EventAssignment::containsUndeclaredUnits() <strong>to
determine whether this situation holds</strong>.  Callers should take
suitable action in those situations.
Returns a UnitDefinition that expresses the units of the math 
expression of this EventAssignment.
@see containsUndeclaredUnits()


=item EventAssignment::containsUndeclaredUnits

Predicate returning C<true> or C<false> depending on whether the math
expression of this EventAssignment contains literal numbers or
parameters with undeclared units.
The EventAssignment::getDerivedUnitDefinition() method returns what
libSBML computes to be the units of the "math", to the extent that
libSBML can compute them.  However, if the expression contains literal
numbers or parameters with undeclared units, libSBML may not be able
to compute the full units of the expression and will only return what
it can compute.  Callers should always use
EventAssignment::containsUndeclaredUnits() when using
EventAssignment::getDerivedUnitDefinition() to decide whether the
returned units may be incomplete.
Returns C<true> if the math expression of this EventAssignment
includes parameters/numbers 
with undeclared units, C<false> otherwise.
@note A return value of C<true> indicates that the UnitDefinition
returned by EventAssignment::getDerivedUnitDefinition() may not
accurately represent the units of the expression.
@see getDerivedUnitDefinition()


=item EventAssignment::getTypeCode

Returns the libSBML type code of this object instance.
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for this object, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item EventAssignment::getElementName

Returns the XML element name of this object, which for
EventAssignment, is always C<"eventAssignment">.
Returns the name of this element, i.e., C<"eventAssignment">. 


=item EventAssignment::writeElements

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.
@deprecated libSBML internal


=item EventAssignment::readOtherXML

Subclasses should override this method to read (and store) XHTML,
MathML, etc. directly from the XMLInputStream.
Returns true if the subclass read from the stream, false otherwise.
@deprecated libSBML internal


=item EventAssignment::readAttributes

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.
@deprecated libSBML internal


=item EventAssignment::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item EventAssignment::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item ListOfEventAssignments::clone

Creates and returns a deep copy of this ListOfEventAssignments.
Returns a (deep) copy of this ListOfEventAssignments.


=item ListOfEventAssignments::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for this object, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item ListOfEventAssignments::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., EventAssignment objects, if the list is non-empty).
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for the objects contained in this ListOf
instance, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item ListOfEventAssignments::getElementName

Returns the XML element name of this object.
For ListOfEventAssignments, the XML element name is @c
"listOfEventAssignments".

Returns the name of this element, i.e., C<"listOfEventAssignments">.


=item ListOfEventAssignments::get

Get a EventAssignment from the ListOfEventAssignments.
@param n the index number of the EventAssignment to get.
Returns the nth EventAssignment in this ListOfEventAssignments.
@see size()


=item ListOfEventAssignments::get

Get a EventAssignment from the ListOfEventAssignments.
@param n the index number of the EventAssignment to get.
Returns the nth EventAssignment in this ListOfEventAssignments.
@see size()


=item ListOfEventAssignments::get

Get a EventAssignment from the ListOfEventAssignments
based on its identifier.
@param sid a string representing the identifier 
of the EventAssignment to get.
Returns EventAssignment in this ListOfEventAssignments
with the given id or NULL if no such
EventAssignment exists.
@see get(unsigned int n)
@see size()


=item ListOfEventAssignments::get

Get a EventAssignment from the ListOfEventAssignments
based on its identifier.
@param sid a string representing the identifier 
of the EventAssignment to get.
Returns EventAssignment in this ListOfEventAssignments
with the given id or NULL if no such
EventAssignment exists.
@see get(unsigned int n)
@see size()


=item ListOfEventAssignments::remove

Removes the nth item from this ListOfEventAssignments items and returns a pointer to
it.

The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove
@see size()


=item ListOfEventAssignments::remove

Removes item in this ListOfEventAssignments items with the given identifier.
The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier C<sid>, then @c
NULL is returned.
@param sid the identifier of the item to remove
Returns the item removed.  As mentioned above, the caller owns the
returned item.


=item ListOfEventAssignments::getElementPosition

Get the ordinal position of this element in the containing object
(which in this case is the Model object).
Returns the ordinal position of the element with respect to its
siblings, or C<-1> (default) to indicate the position is not significant.
@deprecated libSBML internal


=item ListOfEventAssignments::createObject

Returns the SBML object corresponding to next XMLToken in the
XMLInputStream or NULL if the token was not recognized.
@deprecated libSBML internal


=back

=head2 Trigger

LibSBML implementation of SBML's Trigger construct for Event.
An Event object defines when the event can occur, the variables that
are affected by the event, and how the variables are affected.  The
Trigger construct in SBML is used to define a mathematical expression
that determines when an Event I<fires>.
A Trigger contains one subelement named "math" containing a MathML
expression.  The expression must evaluate to a value of type C<boolean>.
The exact moment at which the expression evaluates to C<true> is the
time point when the Event is I<fired>.
An event only fires when its Trigger expression makes the transition in
value from C<false> to C<true>.  The event will also fire at any future
time points when the trigger expression makes this transition; in other
words, an event can fire multiple times during a simulation if its
trigger condition makes the transition from C<false> to C<true> more
than once.
An important question is whether an event can fire prior to, or at,
initial simulation time, that is <em>t &lt; 0</em>.  The answer is no:
an event can only be triggered immediately after initial simulation time
i.e., <em>t &gt; 0</em>.
@see Event
@see Delay
@see EventAssignment


=over

=item Trigger::Trigger

Creates a new Trigger, optionally with the given math. 
@param math an ASTNode representing the mathematical formula for
the trigger expression.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item Trigger::Trigger

Creates a new Trigger using the given SBML C<level> and C<version>
values and optionally a set of XMLNamespaces.
@param level an unsigned int, the SBML Level to assign to this Trigger
@param version an unsigned int, the SBML Version to assign to this
Trigger

@param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
assign to this Trigger
@note Once a Trigger has been added to an SBMLDocument, the C<level>,
C<version> and C<xmlns> namespaces for the document I<override> those used
to create the Trigger.  Despite this, the ability to supply the values
at creation time is an important aid to creating valid SBML.  Knowledge of
the intented SBML Level and Version determine whether it is valid to
assign a particular value to an attribute, or whether it is valid to add
an object to an existing SBMLDocument.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.

@deprecated libSBML internal


=item Trigger::Trigger

Copy constructor; creates a copy of this Trigger.


=item Trigger::accept

Accepts the given SBMLVisitor for this instance of Trigger.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>.


=item Trigger::clone

Creates and returns a deep copy of this Trigger.
Returns a (deep) copy of this Trigger.


=item Trigger::getMath

Get the mathematical formula for the trigger and return it
as an AST.
Returns the math of this Trigger.


=item Trigger::isSetMath

Predicate to test whether the math for this trigger has been set.
Returns C<true> if the formula (meaning the "math" subelement) of
this Trigger has been set, C<false> otherwise.


=item Trigger::setMath

Sets the trigger expression of this Trigger instance to a copy of the given
ASTNode.

@param math an ASTNode representing a formula tree.


=item Trigger::setSBMLDocument

Sets the parent SBMLDocument of this SBML object.
@param d the SBMLDocument to use.
@deprecated libSBML internal


=item Trigger::setParentSBMLObject

Sets the parent SBML object of this SBML object.
@param sb the SBML object to use
@deprecated libSBML internal


=item Trigger::getTypeCode

Returns the libSBML type code of this object instance.
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for this object, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item Trigger::getElementName

Returns the XML element name of this object, which for Trigger, is
always C<"trigger">.
Returns the name of this element, i.e., C<"trigger">. 


=item Trigger::getElementPosition

Returns the position of this element.
Returns the ordinal position of the element with respect to its
siblings or -1 (default) to indicate the position is not significant.
@deprecated libSBML internal


=item Trigger::writeElements

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.
@deprecated libSBML internal


=item Trigger::readOtherXML

Subclasses should override this method to read (and store) XHTML,
MathML, etc. directly from the XMLInputStream.
Returns true if the subclass read from the stream, false otherwise.
@deprecated libSBML internal


=item Trigger::readAttributes

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.
@deprecated libSBML internal


=item Trigger::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Trigger::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=back

=head2 Delay

LibSBML implementation of SBML's Delay construct for Event.
An Event object defines when the event can occur, the variables that
are affected by the event, and how the variables are affected.  The
effect of the event can optionally be delayed after the occurrence of
the condition which invokes it.  An event delay is defined using an
object of class Delay.
The object class Delay is derived from SBase and adds a single
subelement called "math".  This subelement is used to hold MathML
content.  The mathematical formula represented by "math" must evaluate
to a numerical value.  It is used as the length of time between when the
event has I<fired> and when the event's assignments are actually @em
executed.  If no delay is present on a given Event, a time delay of zero
is assumed.
The expression in "math" must be evaluated at the time the rule is @em
fired.  The expression must always evaluate to a positive number
(otherwise, a nonsensical situation could arise where an event is
defined to fire before it is triggered!).
@section delay-units The units of the mathematical expression in a Delay
In SBML Level&nbsp;2 versions before Version&nbsp;4, the units of the
numerical value computed by the Delay's "math" expression were @em
required to be in units of time or the model is considered to have a
unit consistency error.  In Version&nbsp;4, this requirement is relaxed.
The Version&nbsp;4 specification only stipulates that the units of the
numerical value computed by a Delay instance's "math" expression @em
should match the model's units of time (meaning the definition of the @c
time units in the model).  Depending on which Version of SBML
Level&nbsp;2 is in use, libSBML may or may not flag unit inconsistencies
as errors or just warnings. 
Note that <em>units are not predefined or assumed</em> for the contents
of "math" in a Delay object; rather, they must be defined explicitly for
each instance of a Delay object in a model.  This is an important point
to bear in mind when literal numbers are used in delay expressions.  For
example, the following Event instance would result in a warning logged
by SBMLDocument::checkConsistency() about the fact that libSBML cannot
verify the consistency of the units of the expression.  The reason is
that the formula inside the "math" element does not have any declared
units, whereas what is expected in this context is units of time:
C<ode>
<model>
...
<listOfEvents>
<event>
...
<delay>
<math xmlns="http://www.w3.org/1998/Math/MathML">
<cn> 1 </cn>
</math>
</delay>
...
</event>
</listOfEvents>
...
</model>
@endcode
The C<&lt;cn&gt; 1 &lt;/cn&gt;> within the mathematical formula
of the C<delay> above has <em>no units declared</em>.  To make the
expression have the needed units of time, literal numbers should be
avoided in favor of defining Parameter objects for each quantity, and
declaring units for the Parameter values.  The following fragment of
SBML illustrates this approach:
C<ode>
<model>
...
<listOfParameters>
<parameter id="transcriptionDelay" value="10" units="time"/>
</listOfParameters>
...
<listOfEvents>
<event>
...
<delay>
<math xmlns="http://www.w3.org/1998/Math/MathML">
<ci> transcriptionDelay </ci>
</math>
</delay>
...
</event>
</listOfEvents>
...
</model>
@endcode


=over

=item Delay::Delay

Creates a new Delay, optionally with the given math. 
@param math an ASTNode representing the mathematical formula for
the delay expression.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item Delay::Delay

Creates a new Delay using the given SBML C<level> and C<version>
values and optionally a set of XMLNamespaces.
@param level an unsigned int, the SBML Level to assign to this Delay
@param version an unsigned int, the SBML Version to assign to this
Delay

@param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
assign to this Delay
@note Once a Delay has been added to an SBMLDocument, the C<level>,
C<version> and C<xmlns> namespaces for the document I<override> those used
to create the Delay.  Despite this, the ability to supply the values
at creation time is an important aid to creating valid SBML.  Knowledge of
the intented SBML Level and Version determine whether it is valid to
assign a particular value to an attribute, or whether it is valid to add
an object to an existing SBMLDocument.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.

@deprecated libSBML internal


=item Delay::Delay

Copy constructor; creates a copy of this Delay.


=item Delay::accept

Accepts the given SBMLVisitor for this instance of Delay.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>.


=item Delay::clone

Creates and returns a deep copy of this Delay.
Returns a (deep) copy of this Delay.


=item Delay::getMath

Get the mathematical formula for the delay and return it
as an AST.
Returns the math of this Delay.


=item Delay::isSetMath

Predicate to test whether the formula for this delay has been set.
@htmlinclude libsbml-comment-set-methods.html
Returns C<true> if the formula (meaning the C<math> subelement) of
this Delay has been set, C<false> otherwise.


=item Delay::setMath

Sets the delay expression of this Delay instance to a copy of the given
ASTNode.

@htmlinclude libsbml-comment-set-methods.html
@param math an ASTNode representing a formula tree.


=item Delay::getDerivedUnitDefinition

Calculates and returns a UnitDefinition that expresses the units
of measurement assumed for the "math" expression of this Delay.
Delay elements in SBML express a time delay for an Event.  Beginning
with SBML Level&nbsp;2 Version&nbsp;2, the units of that time are
calculated based on the mathematical expression and the model
quantities referenced by C<&lt;ci&gt;> elements used within
that expression.  The Delay::getDerivedUnitDefinition() method returns
what libSBML computes the units to be, to the extent that libSBML can
compute them.
(Prior to SBML Level&nbsp;2 Version&nbsp;2, there existed an attribute
on Event called "timeUnits".  This attribute could be used to set the
intended units of the delay expression.  For such models, this will
return a UnitDefinition object that corresponds to the declared
"timeUnits" units.)
@warning Note that it is possible the "math" expression in the Delay
contains literal numbers or parameters with undeclared units.  In
those cases, it is not possible to calculate the units of the overall
expression without making assumptions.  LibSBML does not make
assumptions about the units, and Delay::getDerivedUnitDefinition()
only returns the units as far as it is able to determine them.  For
example, in an expression <em>X + Y</em>, if <em>X</em> has
unambiguously-defined units and <em>Y</em> does not, it will return
the units of <em>X</em>.  When using this method, <strong>it is
critical that callers also invoke the method</strong>
Delay::containsUndeclaredUnits() <strong>to determine whether this
situation holds</strong>.  Callers should take suitable action in
those situations.
Returns a UnitDefinition that expresses the units of the math 
expression of this Delay.
@see containsUndeclaredUnits()


=item Delay::containsUndeclaredUnits

Predicate returning C<true> or C<false> depending on whether 
the "math" expression in this Delay instance contains
parameters with undeclared units or literal numbers.
Delay elements in SBML express a time delay for an Event.  Beginning
with SBML Level&nbsp;2 Version&nbsp;2, the units of that time are
calculated based on the mathematical expression and the model
quantities referenced by C<&lt;ci&gt;> elements used within
that expression.  The Delay::getDerivedUnitDefinition() method returns
what libSBML computes the units to be, to the extent that libSBML can
compute them.  However, if the expression contains literal numbers or
parameters with undeclared units, libSBML may not be able to compute
the full units of the expression and will only return what it can
compute.  Callers should always use Delay::containsUndeclaredUnits()
when using Delay::getDerivedUnitDefinition() to decide whether the
returned units may be incomplete.
Returns C<true> if the math expression of this Delay includes
numbers/parameters with undeclared units, C<false> otherwise.
@note A return value of C<true> indicates that the UnitDefinition
returned by Delay::getDerivedUnitDefinition() may not accurately
represent the units of the expression.
@see getDerivedUnitDefinition()


=item Delay::setSBMLDocument

Sets the parent SBMLDocument of this SBML object.
@param d the SBMLDocument to use.
@deprecated libSBML internal


=item Delay::setParentSBMLObject

Sets the parent SBML object of this SBML object.
@param sb the SBML object to use
@deprecated libSBML internal


=item Delay::getTypeCode

Returns the libSBML type code of this object instance.
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for this object, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item Delay::getElementName

Returns the XML element name of this object, which for Delay, is
always C<"delay">.
Returns the name of this element, i.e., C<"delay">.
@see getTypeCode()


=item Delay::getElementPosition

Returns the position of this element.
Returns the ordinal position of the element with respect to its
siblings or -1 (default) to indicate the position is not significant.
@deprecated libSBML internal


=item Delay::writeElements

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.
@deprecated libSBML internal


=item Delay::readOtherXML

Subclasses should override this method to read (and store) XHTML,
MathML, etc. directly from the XMLInputStream.
Returns true if the subclass read from the stream, false otherwise.
@deprecated libSBML internal


=item Delay::readAttributes

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.
@deprecated libSBML internal


=item Delay::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item Delay::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=back

=head2 SBO

Methods for interacting with Systems Biology Ontology (%SBO) terms.
@htmlinclude libsbml-not-sbml-warning.html


=over

=item SBO::readTerm

Reads (and checks) sboTerm from the given XMLAttributes set.
Returns the sboTerm as an integer or -1 if the sboTerm was not in the
correct format or not found.
@deprecated libSBML internal


=item SBO::writeTerm

Writes sboTerm as an XMLAttribute to the given XMLOutputStream.
@deprecated libSBML internal


=item SBO::isQuantitativeParameter

Function for checking the SBO term is from correct part of SBO.
Returns true if the term is-a QuantitativeParameter, false otherwise


=item SBO::isParticipantRole

Function for checking the SBO term is from correct part of SBO.
Returns true if the term is-a ParticipantRole, false otherwise


=item SBO::isModellingFramework

Function for checking the SBO term is from correct part of SBO.
Returns true if the term is-a ModellingFramework, false otherwise


=item SBO::isMathematicalExpression

Function for checking the SBO term is from correct part of SBO.
Returns true if the term is-a MathematicalExpression, false otherwise


=item SBO::isKineticConstant

Function for checking the SBO term is from correct part of SBO.
Returns true if the term is-a KineticConstant, false otherwise


=item SBO::isReactant

Function for checking the SBO term is from correct part of SBO.
Returns true if the term is-a Reactant, false otherwise


=item SBO::isProduct

Function for checking the SBO term is from correct part of SBO.
Returns true if the term is-a Product, false otherwise


=item SBO::isModifier

Function for checking the SBO term is from correct part of SBO.
Returns true if the term is-a Modifier, false otherwise


=item SBO::isRateLaw

Function for checking the SBO term is from correct part of SBO.
Returns true if the term is-a RateLaw, false otherwise


=item SBO::isEvent

Function for checking the SBO term is from correct part of SBO.
Returns true if the term is-a Event, false otherwise


=item SBO::isPhysicalParticipant

Function for checking the SBO term is from correct part of SBO.
Returns true if the term is-a PhysicalParticipant, false otherwise


=item SBO::isParticipant

Function for checking the SBO term is from correct part of SBO.
Returns true if the term is-a Participant, false otherwise


=item SBO::isInteraction

Function for checking the SBO term is from correct part of SBO.
Returns true if the term is-a Interaction, false otherwise


=item SBO::isEntity

Function for checking the SBO term is from correct part of SBO.
Returns true if the term is-a Entity, false otherwise


=item SBO::isFunctionalEntity

Function for checking the SBO term is from correct part of SBO.
Returns true if the term is-a FunctionalEntity, false otherwise


=item SBO::isMaterialEntity

Function for checking the SBO term is from correct part of SBO.
Returns true if the term is-a MaterialEntity, false otherwise


=item SBO::isConservationLaw

Function for checking the SBO term is from correct part of SBO.
Returns true if the term is-a ConservationLaw, false otherwise


=item SBO::isSteadyStateExpression

Function for checking the SBO term is from correct part of SBO.
Returns true if the term is-a SteadyStateExpression, false otherwise


=item SBO::isFunctionalCompartment

Function for checking the SBO term is from correct part of SBO.
Returns true if the term is-a FunctionalCompartment, false otherwise


=item SBO::isContinuousFramework

Function for checking the SBO term is from correct part of SBO.
Returns true if the term is-a ContinuousFramework, false otherwise


=item SBO::isDiscreteFramework

Function for checking the SBO term is from correct part of SBO.
Returns true if the term is-a DiscreteFramework, false otherwise


=item SBO::isLogicalFramework

Function for checking the SBO term is from correct part of SBO.
Returns true if the term is-a LogicalFramework, false otherwise


=item SBO::isObselete

Function for checking whether the SBO term is obselete.
Returns true if the term is-a Obsolete, false otherwise


=item SBO::intToString

Returns the integer as a correctly formatted SBO string.
Returns the given integer sboTerm as a zero-padded seven digit string.
@note If the sboTerm is not in the correct range ([0 -- 9999999]), an empty
string is returned.


=item SBO::isChildOf

Function for checking the SBO term is from correct part of SBO.
Returns true if the term is-a parent, false otherwise
@deprecated libSBML internal


=item SBO::populateSBOTree

Function for checking the SBO term is from correct part of SBO.
populates the parent-child map
@deprecated libSBML internal


=item SBO::checkTerm

Returns true if sboTerm is in the correct format (a zero-padded, seven
digit string), false otherwise.
@deprecated libSBML internal


=item SBO::checkTerm

Returns true if sboTerm is in the range [0 -- 9999999], false
otherwise.

@deprecated libSBML internal


=item SBO::stringToInt

Returns the given string sboTerm as an integer.  If the sboTerm is not
in the correct format (a zero-padded, seven digit string), -1 is
returned.

@deprecated libSBML internal


=back

=head2 StoichiometryMath

LibSBML implementation of SBML's StoichiometryMath construct.
In SBML Level 2, product and reactant stoichiometries can be specified
using I<either> the "stoichiometry" attribute or a "stoichiometryMath"
element in a SpeciesReference object.  The "stoichiometry" attribute is
of type C<double> and should contain values greater than zero (0).  The
"stoichiometryMath" element is implemented as an element containing a
MathML expression.  These two are mutually exclusive; only one of
"stoichiometry" or "stoichiometryMath" should be defined in a given
SpeciesReference instance.  When neither the attribute nor the element
is present, the value of "stoichiometry" in the enclosing
SpeciesReference instance defaults to C<1>.
For maximum interoperability, SpeciesReference's "stoichiometry"
attribute should be used in preference to "stoichiometryMath" when a
species' stoichiometry is a simple scalar number (integer or decimal).
When the stoichiometry is a rational number, or when it is a more
complicated formula, "stoichiometryMath" must be used.  The MathML
expression in "stoichiometryMath" may also refer to identifiers of
entities in a model (except reaction identifiers).  However, the only
species identifiers that can be used in "stoichiometryMath" are those
referenced in the enclosing Reaction's list of reactants, products and
modifiers.

The "stoichiometry" attribute and the "stoichiometryMath" element, when
either is used, is each interpreted as a factor applied to the reaction
rate to produce the rate of change of the species identified by the
"species" attribute in the enclosing SpeciesReference.  This is the
normal interpretation of a stoichiometry, but in SBML, one additional
consideration has to be taken into account.  The reaction rate, which is
the result of the KineticLaw's "math" element, is always in the model's
I<substance> per I<time> units.  However, the rate of change of the
species will involve the species' I<substance> units (i.e., the units
identified by the Species object's "substanceUnits" attribute), and
these units may be different from the model's default I<substance>
units.  If the units I<are> different, the stoichiometry must
incorporate a conversion factor for converting the model's I<substance>
units to the species' I<substance> units.  The conversion factor is
assumed to be included in the scalar value of the "stoichiometry"
attribute if "stoichiometry" is used.  If instead "stoichiometryMath" is
used, then the product of the model's "substance" units times the
"stoichiometryMath" units must match the I<substance> units of the
species.  Note that in either case, if the species' units and the
model's default I<substance> units are the same, the stoichiometry ends
up being a dimensionless number and equivalent to the standard chemical
stoichiometry found in textbooks.  Examples and more explanations of
this are given in the SBML specification.
The following is a simple example of a species reference for species @c
"X0", with stoichiometry C<2>, in a list of reactants within a reaction
having the identifier C<"J1">:
C<ode>
<model>
...
<listOfReactions>
<reaction id="J1">
<listOfReactants>
<speciesReference species="X0" stoichiometry="2">
</listOfReactants>
...
</reaction>
...
</listOfReactions>
...
</model>
@endcode
The following is a more complex example of a species reference for
species C<"X0">, with a stoichiometry formula consisting of
a rational number:
C<ode>
<model>
...
<listOfReactions>
<reaction id="J1">
<listOfReactants>
<speciesReference species="X0">
<stoichiometryMath>
<math xmlns="http://www.w3.org/1998/Math/MathML"> 
<cn type="rational"> 3 <sep/> 2 </cn>
</math>
</stoichiometryMath>
</speciesReference>
</listOfReactants>
...
</reaction>
...
</listOfReactions>
...
</model>
@endcode

Additional discussions of stoichiometries and implications for species
and reactions are included in the documentation of SpeciesReference
class.

@see SpeciesReference
@see Reaction


=over

=item StoichiometryMath::StoichiometryMath

Creates a new StoichiometryMath object, optionally with the given math. 
@param math an ASTNode representing the mathematical formula for
the stoichiometry expression.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item StoichiometryMath::StoichiometryMath

Creates a new StoichiometryMath object using the given SBML C<level>
and C<version> values and optionally a set of XMLNamespaces.
@param level an unsigned int, the SBML Level to assign to this StoichiometryMath
@param version an unsigned int, the SBML Version to assign to this
StoichiometryMath

@param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
assign to this StoichiometryMath
@note Once a StoichiometryMath has been added to an SBMLDocument, the C<level>,
C<version> and C<xmlns> namespaces for the document I<override> those used
to create the StoichiometryMath.  Despite this, the ability to supply the values
at creation time is an important aid to creating valid SBML.  Knowledge of
the intented SBML Level and Version determine whether it is valid to
assign a particular value to an attribute, or whether it is valid to add
an object to an existing SBMLDocument.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.

@deprecated libSBML internal


=item StoichiometryMath::StoichiometryMath

Copy constructor; creates a copy of this StoichiometryMath.


=item StoichiometryMath::accept

Accepts the given SBMLVisitor for this instance of StoichiometryMath.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>.


=item StoichiometryMath::clone

Creates and returns a deep copy of this StoichiometryMath object.
Returns a (deep) copy of this StoichiometryMath.


=item StoichiometryMath::getMath

Retrieves the mathematical formula within this StoichiometryMath and
return it as an AST.
Returns the math of this StoichiometryMath.


=item StoichiometryMath::isSetMath

Predicate to test whether the math for this StoichiometryMath object
has been set.
Returns C<true> if the formula (meaning the C<math> subelement) of
this StoichiometryMath has been set, C<false> otherwise.


=item StoichiometryMath::setMath

Sets the 'math' expression of this StoichiometryMath instance to a
copy of the given ASTNode.
@param math an ASTNode representing a formula tree.


=item StoichiometryMath::getDerivedUnitDefinition

Calculates and returns a UnitDefinition object that expresses the
units returned by the math expression in this StoichiometryMath
object.

The units are calculated based on the mathematical expression in the
StoichiometryMath and the model quantities referenced by
C<&lt;ci&gt;> elements used within that expression.  The
StoichiometryMath::getDerivedUnitDefinition() method returns the
calculated units.
@warning Note that it is possible the "math" expression in the
StoichiometryMath instance contains literal numbers or parameters with
undeclared units.  In those cases, it is not possible to calculate the
units of the overall expression without making assumptions.  LibSBML
does not make assumptions about the units, and
StoichiometryMath::getDerivedUnitDefinition() only returns the units
as far as it is able to determine them.  For example, in an expression
<em>X + Y</em>, if <em>X</em> has unambiguously-defined units and
<em>Y</em> does not, it will return the units of <em>X</em>.  When
using this method, <strong>it is critical that callers also invoke the
method</strong> StoichiometryMath::containsUndeclaredUnits()
<strong>to determine whether this situation holds</strong>.  Callers
should take suitable action in those situations.
Returns a UnitDefinition that expresses the units of the math 
@see containsUndeclaredUnits()


=item StoichiometryMath::containsUndeclaredUnits

Predicate returning C<true> or C<false> depending on whether the math
expression of this StoichiometryMath object contains literal numbers
or parameters with undeclared units.
The StoichiometryMath::getDerivedUnitDefinition() method returns what
libSBML computes the units of the Stoichiometry to be, to the extent
that libSBML can compute them.  However, if the expression contains
literal numbers or parameters with undeclared units, libSBML may not
be able to compute the full units of the expression and will only
return what it can compute.  Callers should always use
StoichiometryMath::containsUndeclaredUnits() when using
StoichiometryMath::getDerivedUnitDefinition() to decide whether the
returned units may be incomplete.
Returns C<true> if the math expression of this StoichiometryMath
includes numbers/parameters with undeclared units, C<false> otherwise.
@note A return value of C<true> indicates that the UnitDefinition
returned by StoichiometryMath::getDerivedUnitDefinition() may not
accurately represent the units of the expression.
@see getDerivedUnitDefinition()


=item StoichiometryMath::setSBMLDocument

Sets the parent SBMLDocument of this SBML object.
@param d the SBMLDocument to use.
@deprecated libSBML internal


=item StoichiometryMath::setParentSBMLObject

Sets the parent SBML object of this SBML object.
@param sb the SBML object to use
@deprecated libSBML internal


=item StoichiometryMath::getTypeCode

Returns the libSBML type code of this object instance.
@if clike LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.
The set of possible type codes is defined in the enumeration
#SBMLTypeCode_t.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if java LibSBML attaches an
identifying code to every kind of SBML object.  These are known as
<em>SBML type codes</em>.  In other languages, the set of type codes
is stored in an enumeration; in the Java language interface for
libSBML, the type codes are defined as static integer constants in
interface class {@link libsbmlConstants}.  The names of the type codes
all begin with the characters C<SBML_>. @endif
Returns the SBML type code for this object, or C<SBML_UNKNOWN> (default).
@see getElementName()


=item StoichiometryMath::getElementName

Returns the XML element name of this object, which for StoichiometryMath, is
always C<"stoichiometryMath">.
Returns the name of this element, i.e., C<"stoichiometryMath">. 


=item StoichiometryMath::getElementPosition

Returns the position of this element.
Returns the ordinal position of the element with respect to its
siblings or C<-1> (default) to indicate the position is not significant.
@deprecated libSBML internal


=item StoichiometryMath::writeElements

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.
@deprecated libSBML internal


=item StoichiometryMath::readOtherXML

Subclasses should override this method to read (and store) XHTML,
MathML, etc. directly from the XMLInputStream.
Returns true if the subclass read from the stream, false otherwise.
@deprecated libSBML internal


=item StoichiometryMath::readAttributes

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.
@deprecated libSBML internal


=item StoichiometryMath::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item StoichiometryMath::writeAttributes

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@deprecated libSBML internal


=item readMathML

Reads the MathML from the given XMLInputStream, constructs a corresponding
abstract syntax tree and returns a pointer to the root of the tree.
@deprecated libSBML internal


=item writeMathML

Writes the given ASTNode (and its children) to the XMLOutputStream as
MathML.

@deprecated libSBML internal


=item readMathMLFromString

Reads the MathML from the given XML string, constructs a corresponding
abstract syntax tree and returns a pointer to the root of the tree.


=item writeMathMLToString

Writes the given ASTNode (and its children) to the XMLOutputStream as
MathML.  The string is owned by the caller and should be freed
(with free()) when no longer needed.


=back

=head2 ASTNode

A node in the Abstract Syntax Tree (AST) representation of a
mathematical expression.
@htmlinclude libsbml-not-sbml-warning.html
Abstract Syntax Trees (ASTs) are a simple kind of data structure used in
libSBML for storing mathematical expressions.  The ASTNode is the
cornerstone of libSBML's AST representation.  ASTNodes represent the
most basic, indivisible part of a mathematical formula and come in many
types.  For instance, there are node types to represent numbers (with
subtypes to distinguish integer, real, and rational numbers), names
(e.g., constants or variables), simple mathematical operators, logical
or relational operators and functions. LibSBML ASTs provide a canonical,
in-memory representation for all mathematical formulas regardless of
their original format (which might be MathML or might be text strings).
An AST I<node> in libSBML is a recursive structure containing a pointer
to the node's value (which might be, for example, a number or a symbol)
and a list of children nodes.  Each ASTNode node may have none, one,
two, or more child depending on its type. The following diagram
illustrates an example of how the mathematical expression C<"1 +
2"> is represented as an AST with one I<plus> node having two @em
integer children nodes for the numbers C<1> and
C<2>.  The figure also shows the corresponding MathML
representation:

@image html astnode-illustration.jpg "Example AST representation of a mathematical expression."
@image latex astnode-illustration.jpg "Example AST representation of a mathematical expression."
The following are other noteworthy points about the AST representation
in libSBML:

=over


=item

A numerical value represented in MathML as a real number with an
exponent is preserved as such in the AST node representation, even if
the number could be stored in a C<double> data type.  This is done
so that when an SBML model is read in and then written out again, the
amount of change introduced by libSBML to the SBML during the round-trip
activity is minimized.

=item

Rational numbers are represented in an AST node using separate
numerator and denominator values.  These can be retrieved using the
methods ASTNode::getNumerator() and ASTNode::getDenominator().

=item

The children of an ASTNode are other ASTNode objects.  The list of
children is empty for nodes that are leaf elements, such as numbers.
For nodes that are actually roots of expression subtrees, the list of
children points to the parsed objects that make up the rest of the
expression.

=back

@if clike <h3><a class="anchor" name="ASTNodeType_t">
ASTNodeType_t</a></h3> @endif@if java <h3><a class="anchor"
name="ASTNodeType_t">The set of possible ASTNode types</a></h3> @endif
@if clike Every ASTNode has an associated type code to indicate,
for example, whether it holds a number or stands for an arithmetic
operator.  The type is recorded as a value drawn from the enumeration <a
class="el" href="#ASTNodeType_t">ASTNodeType_t</a>.  The list of
possible types is quite long, because it covers all the mathematical
functions that are permitted in SBML.  The values are shown in the
following table; their names hopefully evoke the construct that they
represent: @endif@if java Every ASTNode has an associated
type code to indicate, for example, whether it holds a number or stands for
an arithmetic operator.  The type is recorded as a value drawn from a
set of static integer constants defined in the class {@link
libsbmlConstants}.  Their names begin with the characters C<AST_>.  The
list of possible types is quite long, because it covers all the
mathematical functions that are permitted in SBML.  The values are shown
in the following table; their names hopefully evoke the construct that
they represent: @endif
@htmlinclude libsbml-astnode-types.html
The types have the following meanings:

=over


=item

If the node is basic mathematical operator (e.g., C<"+">), then the
node's type will be C<AST_PLUS>, C<AST_MINUS>, C<AST_TIMES>, C<AST_DIVIDE>,
or C<AST_POWER>, as appropriate.

=item

If the node is a predefined function or operator from SBML Level 1
(in the string-based formula syntax used in Level 1) or SBML Level 2
(in the subset of MathML used in SBML Level 2), then the node's type
will be either C<AST_FUNCTION_><em>x</em>,
C<AST_LOGICAL_><em>x</em>, or
C<AST_RELATIONAL_><em>x</em>, as appropriate.  (Examples: @c
AST_FUNCTION_LOG, C<AST_RELATIONAL_LEQ>.)

=item

If the node refers to a user-defined function, the node's type will
be C<AST_NAME> (because it holds the name of the function).

=item

If the node is a lambda expression, its type will be C<AST_LAMBDA>.

=item

If the node is a predefined constant (C<"ExponentialE">, C<"Pi">, 
C<"True"> or C<"False">), then the node's type will be C<AST_CONSTANT_E>,
C<AST_CONSTANT_PI>, C<AST_CONSTANT_TRUE>, or C<AST_CONSTANT_FALSE>.

=item

(Level 2 only) If the node is the special MathML csymbol C<time>,
the value of the node will be C<AST_NAME_TIME>.  (Note, however, that the
MathML csymbol C<delay> is translated into a node of type
C<AST_FUNCTION_DELAY>.  The difference is due to the fact that C<time> is a
single variable, whereas C<delay> is actually a function taking
arguments.)


=item

If the node contains a numerical value, its type will be
C<AST_INTEGER>, C<AST_REAL>, C<AST_REAL_E>, or C<AST_RATIONAL>,
as appropriate.

=back



<h3><a class="anchor" name="math-convert">Converting between ASTs and text strings</a></h3>
@if clike The text-string form of mathematical formulas
produced by SBML_formulaToString() and read by SBML_parseFormula() are
simple C-inspired infix notation taken from SBML Level&nbsp;1.  A
formula in this text-string form can be handed to a program that
understands SBML Level&nbsp;1 mathematical expressions, or used as part
of a translation system.  The libSBML distribution comes with an example
program in the C<"examples"> subdirectory called C<translateMath> that
implements an interactive command-line demonstration of translating
infix formulas into MathML and
vice-versa. @endif@if java
The text-string form of mathematical formulas produced by <code><a
href="libsbml.html">libsbml.formulaToString()</a></code> and read by <code><a
href="libsbml.html">libsbml.parseFormula()</a></code> are simple C-inspired
infix notation taken from SBML Level&nbsp;1.  A formula in this
text-string form can be handed to a program that understands SBML
Level&nbsp;1 mathematical expressions, or used as part of a translation
system.  The libSBML distribution comes with an example program in the
C<"examples"> subdirectory called C<translateMath> that implements an
interactive command-line demonstration of translating infix formulas
into MathML and vice-versa.@endif
The formula strings may contain operators, function calls, symbols, and
white space characters.  The allowable white space characters are tab
and space.  The following are illustrative examples of formulas
expressed in the syntax:
@verbatim
0.10   k4^2
@endverbatim
@verbatim
(vm   s1)/(km + s1)
@endverbatim
The following table shows the precedence rules in this syntax.  In the
Class column, I<operand> implies the construct is an operand, @em
prefix implies the operation is applied to the following arguments, @em
unary implies there is one argument, and I<binary> implies there are
two arguments.  The values in the Precedence column show how the order
of different types of operation are determined.  For example, the
expression <em>a   b + c</em> is evaluated as <em>(a   b) + c</em>
because the C< > operator has higher precedence.  The
Associates column shows how the order of similar precedence operations
is determined; for example, <em>a - b + c</em> is evaluated as <em>(a -
b) + c</em> because the C<+> and C<-> operators are
left-associative.  The precedence and associativity rules are taken from
the C programming language, except for the symbol C<^>, which
is used in C for a different purpose.  (Exponentiation can be invoked
using either C<^> or the function C<power>.)
@htmlinclude libsbml-math-precedence-table.html 
A program parsing a formula in an SBML model should assume that names
appearing in the formula are the identifiers of Species, Parameter,
Compartment, FunctionDefinition, or Reaction objects defined in a model.
When a function call is involved, the syntax consists of a function
identifier, followed by optional white space, followed by an opening
parenthesis, followed by a sequence of zero or more arguments separated
by commas (with each comma optionally preceded and/or followed by zero
or more white space characters), followed by a closing parenthesis.
There is an almost one-to-one mapping between the list of predefined
functions available, and those defined in MathML.  All of the MathML
functions are recognized; this set is larger than the functions defined
in SBML Level&nbsp;1.  In the subset of functions that overlap between
MathML and SBML Level&nbsp;1, there exist a few differences.  The
following table summarizes the differences between the predefined
functions in SBML Level&nbsp;1 and the MathML equivalents in SBML
Level&nbsp;2:

@htmlinclude libsbml-math-functions.html


=over

=item ASTNode::ASTNode

Creates and returns a new ASTNode.
By default, the returned node will have a type of C<AST_UNKNOWN>.  The
calling code should set the node type to something else as soon as
possible using @if clike ASTNode::setType() @endif@if java ASTNode::setType(int) @endif
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item ASTNode::ASTNode

Creates a new ASTNode from the given Token.  The resulting ASTNode
will contain the same data as the Token.
@param token the Token to add.


=item ASTNode::ASTNode

Copy constructor; Creates a deep copy of the given ASTNode.
@param orig the ASTNode to be copied.


=item ASTNode::freeName

Frees the name of this ASTNode and sets it to NULL.
This operation is only applicable to ASTNodes corresponding to
operators, numbers, or C<AST_UNKNOWN>.  This method will have no
effect on other types of nodes.


=item ASTNode::canonicalize

Converts this ASTNode to a canonical form and returns true (non-zero)
if successful, false (zero) otherwise.
The rules determining the canonical form conversion are as follows:

=over



=item

If the node type is C<AST_NAME> and the node name matches @c
"ExponentialE", C<"Pi">, C<"True"> or C<"False"> the node type is
converted to the corresponding C<AST_CONSTANT_><em>x</em> type.

=item

If the node type is an C<AST_FUNCTION> and the node name matches
an SBML Level&nbsp;1 or Level&nbsp;2 (MathML) function name, logical
operator name, or relational operator name, the node is converted to
the correspnding C<AST_FUNCTION_><em>x</em> or
C<AST_LOGICAL_><em>x</em> type.

=back


SBML Level&nbsp;1 function names are searched first; thus, for
example, canonicalizing C<log> will result in a node type of @c
AST_FUNCTION_LN.  (See the SBML Level&nbsp;1 Specification, Appendix
C.)

Sometimes canonicalization of a node results in a structural converion
of the node as a result of adding a child.  For example, a node with
the SBML Level&nbsp;1 function name C<sqr> and a single child node
(the argument) will be transformed to a node of type
C<AST_FUNCTION_POWER> with two children.  The first child will remain
unchanged, but the second child will be an ASTNode of type
C<AST_INTEGER> and a value of 2.  The function names that result in
structural changes are: C<log10>, C<sqr>, and C<sqrt>.
See the SBML Level&nbsp;1 and Level&nbsp;2 (all versions)
specification documents for more information.


=item ASTNode::addChild

Adds the given node as a child of this ASTNode.  Child nodes are added
in-order from left to right.
@param child the ASTNode instance to add


=item ASTNode::prependChild

Adds the given node as a child of this ASTNode.  This method adds
child nodes from right to left.
@param child the ASTNode instance to add


=item ASTNode::removeChild

Removes child n of this ASTNode. 
@param n unsigned int the index of the child to remove
Returns int indicating the success or failure of the operation
@note removing a child from an ASTNode may result in an
inaccurate representation.


=item ASTNode::replaceChild

Replaces the nth child of this ASTNode with the given ASTNode.
@param n unsigned int the index of the child to replace
@param newChild ASTNode to replace the nth child
Returns int indicating the success or failure of the operation
@note replacing a child within an ASTNode may result in an
inaccurate representation.


=item ASTNode::insertChild

Insert the given ASTNode at point n in the list of children
of this ASTNode.
@param n unsigned int the index of the ASTNode being added
@param newChild ASTNode to insert as the nth child
Returns int indicating the success or failure of the operation
@note inserting a child within an ASTNode may result in an
inaccurate representation.


=item ASTNode::deepCopy

Creates a recursive copy of this node and all its children.
Returns a copy of this ASTNode and all its children.  The caller owns
the returned ASTNode and is reponsible for deleting it.


=item ASTNode::getChild

Get a child of this node according to an index number.
@param n the index of the child to get
Returns the nth child of this ASTNode or NULL if this node has no nth
child (C<n &gt; getNumChildren() - 1>).


=item ASTNode::getLeftChild

Get the left child of this node.
Returns the left child of this ASTNode.  This is equivalent to
C<getChild(0)>;



=item ASTNode::getRightChild

Get the right child of this node.
Returns the right child of this ASTNode, or NULL if this node has no
right child.  If C<getNumChildren() &gt; 1>, then
this is equivalent to:
C<ode>
getChild( getNumChildren() - 1 );
@endcode



=item ASTNode::getNumChildren

Get the number of children that this node has.
Returns the number of children of this ASTNode, or 0 is this node has
no children.


=item ASTNode::addSemanticsAnnotation

Adds the given XMLNode as a semantic annotation of this ASTNode.
@param sAnnotation the annotation to add.


=item ASTNode::getNumSemanticsAnnotations

Get the number of semantic annotation elements inside this node.
Returns the number of annotations of this ASTNode.  


=item ASTNode::getSemanticsAnnotation

Get the nth semantic annotation of this node.
Returns the nth annotation of this ASTNode, or NULL if this node has no nth
annotation (C<n &gt; getNumChildren() - 1>).


=item ASTNode::getListOfNodes

Performs a depth-first search of the tree rooted at node and returns
the List of nodes where C<predicate(node)> returns true
(non-zero).

The typedef for ASTNodePredicate is:
C<ode>
int ( ASTNodePredicate) (const ASTNode_t  node);
@endcode
where a return value of non-zero represents true and zero represents
false.

@param predicate the predicate to use
Returns the list of nodes for which the predicate returned true
(non-zero).  The List returned is owned by the caller and should be
deleted after the caller is done using it.  The ASTNodes in the list;
however, are not owned by the caller (as they still belong to the tree
itself) and therefore should not be deleted.


=item ASTNode::fillListOfNodes

This method is identical in functionality to
ASTNode::getListOfNodes(), except the List is passed-in by the caller.


=item ASTNode::getCharacter

Get the value of this node as a single character.  This function
should be called only when ASTNode::getType() is one of C<AST_PLUS>,
C<AST_MINUS>, C<AST_TIMES>, C<AST_DIVIDE> or C<AST_POWER>.
Returns the value of this ASTNode as a single character


=item ASTNode::getInteger

Get the value of this node as an integer. This function should be
called only when C<getType() == AST_INTEGER>.
Returns the value of this ASTNode as a (C<long>) integer. 


=item ASTNode::getName

Get the value of this node as a string.  This function may be called
on nodes that are not operators (C<isOperator() == false>)
or numbers (C<isNumber() == false>).
Returns the value of this ASTNode as a string.


=item ASTNode::getNumerator

Get the value of the numerator of this node.  This function
should be called only when C<getType() == AST_RATIONAL>.
Returns the value of the numerator of this ASTNode.  


=item ASTNode::getDenominator

Get the value of the denominator of this node.  This function
should be called only when C<getType() == AST_RATIONAL>.
Returns the value of the denominator of this ASTNode.


=item ASTNode::getReal

Get the real-numbered value of this node.  This function
should be called only when C<isReal() == true>.
This function performs the necessary arithmetic if the node type is @c
AST_REAL_E (<em>mantissa   10<sup> exponent</sup></em>) or @c
AST_RATIONAL (<em>numerator / denominator</em>).
Returns the value of this ASTNode as a real (double).


=item ASTNode::getMantissa

Get the mantissa value of this node.  This function should be called
only when getType() returns C<AST_REAL_E> or C<AST_REAL>.  If
getType() returns C<AST_REAL>, this method is identical to getReal().
Returns the value of the mantissa of this ASTNode. 


=item ASTNode::getExponent

Get the exponent value of this ASTNode.  This function should be
called only when getType() returns C<AST_REAL_E> or C<AST_REAL>.
Returns the value of the exponent of this ASTNode.


=item ASTNode::getPrecedence

Get the precedence of this node in the infix math syntax of SBML
Level&nbsp;1.  For more information about the infix syntax, see the
discussion about <a href="#math-convert">text string formulas</a> at
the top of the documentation for ASTNode.
Returns an integer indicating the precedence of this ASTNode


=item ASTNode::getType

Get the type of this ASTNode.  The value returned is one of the
enumeration values such as C<AST_LAMBDA>, C<AST_PLUS>, etc.
Returns the type of this ASTNode.


=item ASTNode::isBoolean

Predicate returning true (non-zero) if this node has a boolean type (a
logical operator, a relational operator, or the constants C<true> or
C<false>).
Returns true if this ASTNode is a boolean, false otherwise.


=item ASTNode::isConstant

Predicate returning true (non-zero) if this node represents a MathML
constant (e.g., C<true>, C<Pi>).
Returns true if this ASTNode is a MathML constant, false otherwise.


=item ASTNode::isFunction

Predicate returning true (non-zero) if this node represents a MathML
function (e.g., C<abs()>), or an SBML Level&nbsp;1
function, or a user-defined function.
Returns true if this ASTNode is a function, false otherwise.


=item ASTNode::isInfinity

Predicate returning true (non-zero) if this node represents
the special IEEE 754 value infinity, false (zero) otherwise.
Returns true if this ASTNode is the special IEEE 754 value infinity,
false otherwise.


=item ASTNode::isInteger

Predicate returning true (non-zero) if this node contains an integer
value, false (zero) otherwise.
Returns true if this ASTNode is of type AST_INTEGER, false otherwise.


=item ASTNode::isLambda

Predicate returning true (non-zero) if this node is a MathML
C<&lt;lambda&gt;>, false (zero) otherwise.
Returns true if this ASTNode is of type AST_LAMBDA, false otherwise.


=item ASTNode::isLog10

Predicate returning true (non-zero) if this node represents a @c
log10() function, false (zero) otherwise.  More precisely, this
predicate returns true if the node type is C<AST_FUNCTION_LOG> with
two children, the first of which is an C<AST_INTEGER> equal to 10.
Returns true if the given ASTNode represents a log10() function, false
otherwise.



=item ASTNode::isLogical

Predicate returning true (non-zero) if this node is a MathML logical
operator (i.e., C<and>, C<or>, C<not>, C<xor>).
Returns true if this ASTNode is a MathML logical operator


=item ASTNode::isName

Predicate returning true (non-zero) if this node is a user-defined
variable name in SBML L1, L2 (MathML), or the special symbols C<delay>
or C<time>.  The predicate returns false (zero) otherwise.
Returns true if this ASTNode is a user-defined variable name in SBML
L1, L2 (MathML) or the special symbols delay or time.


=item ASTNode::isNaN

Predicate returning true (non-zero) if this node represents the
special IEEE 754 value "not a number" (NaN), false (zero) otherwise.
Returns true if this ASTNode is the special IEEE 754 NaN


=item ASTNode::isNegInfinity

Predicate returning true (non-zero) if this node represents the
special IEEE 754 value "negative infinity", false (zero) otherwise.
Returns true if this ASTNode is the special IEEE 754 value negative
infinity, false otherwise.


=item ASTNode::isNumber

Predicate returning true (non-zero) if this node contains a number,
false (zero) otherwise.  This is functionally equivalent to the
following code:
C<ode>
isInteger() || isReal()
@endcode

Returns true if this ASTNode is a number, false otherwise.


=item ASTNode::isOperator

Predicate returning true (non-zero) if this node is a mathematical
operator, meaning, C<+>, C<->, C< >,
C</> or C<^> (power).
Returns true if this ASTNode is an operator.


=item ASTNode::isPiecewise

Predicate returning true (non-zero) if this node is the MathML
C<&lt;piecewise&gt;> construct, false (zero) otherwise.
Returns true if this ASTNode is a MathML C<piecewise> function


=item ASTNode::isRational

Predicate returning true (non-zero) if this node represents a rational
number, false (zero) otherwise.
Returns true if this ASTNode is of type C<AST_RATIONAL>.


=item ASTNode::isReal

Predicate returning true (non-zero) if this node can represent a real
number, false (zero) otherwise.  More precisely, this node must be of
one of the following types: C<AST_REAL>, C<AST_REAL_E> or @c
AST_RATIONAL.

Returns true if the value of this ASTNode can represented as a real
number, false otherwise.


=item ASTNode::isRelational

Predicate returning true (non-zero) if this node is a MathML
relational operator, meaning C<==>, C<&gt;=>, 
C<&gt;>, C<&lt;>, and C<!=>.
Returns true if this ASTNode is a MathML relational operator, false
otherwise



=item ASTNode::isSqrt

Predicate returning true (non-zero) if this node represents a square
root function, false (zero) otherwise.  More precisely, the node type
must be C<AST_FUNCTION_ROOT> with two children, the first of which is
an C<AST_INTEGER> node having value equal to 2.
Returns true if the given ASTNode represents a sqrt() function, false
otherwise.



=item ASTNode::isUMinus

Predicate returning true (non-zero) if this node is a unary minus
operator, false (zero) otherwise.  A node is defined as a unary minus
node if it is of type C<AST_MINUS> and has exactly one child.
For numbers, unary minus nodes can be "collapsed" by negating the
number.  In fact, SBML_parseFormula() does this during its parse.
However, unary minus nodes for symbols (C<AST_NAMES>) cannot be
"collapsed", so this predicate function is necessary.
Returns true if this ASTNode is a unary minus, false otherwise.


=item ASTNode::isUnknown

Predicate returning true (non-zero) if this node has an unknown type.
"Unknown" nodes have the type C<AST_UNKNOWN>.  Nodes with unknown
types will not appear in an ASTNode tree returned by libSBML based
upon valid SBML input; the only situation in which a node with type @c
AST_UNKNOWN may appear is immediately after having create a new,
untyped node using the ASTNode constructor.  Callers creating nodes
should endeavor to set the type to a valid node type as soon as
possible after creating new nodes.
Returns true if this ASTNode is of type C<AST_UNKNOWN>, false otherwise.


=item ASTNode::setCharacter

Sets the value of this ASTNode to the given character.  If character
is one of C<+>, C<->, @c  , @c / or C<^>, the node type will be set
accordingly.  For all other characters, the node type will be set to
C<AST_UNKNOWN>.
@param value the character value to which the node's value should be
set.



=item ASTNode::setName

Sets the value of this ASTNode to the given name.
The node type will be set (to C<AST_NAME>) <em>only if</em> the
ASTNode was previously an operator (C<isOperator(node) ==
true>) or number (C<isNumber(node) == true>).  This
allows names to be set for C<AST_FUNCTIONs> and the like.
@param name the string containing the name to which this node's value
should be set


=item ASTNode::setValue

Sets the value of this ASTNode to the given integer and sets the node
type to C<AST_INTEGER>.
@param value the integer to which this node's value should be set


=item ASTNode::setValue

Sets the value of this ASTNode to the given (C<long>) integer and sets
the node type to C<AST_INTEGER>.
@param value the integer to which this node's value should be set


=item ASTNode::setValue

Sets the value of this ASTNode to the given rational in two parts: the
numerator and denominator.  The node type is set to C<AST_RATIONAL>.
@param numerator the numerator value of the rational
@param denominator the denominator value of the rational


=item ASTNode::setValue

Sets the value of this ASTNode to the given real (C<double>) and sets
the node type to C<AST_REAL>.
This is functionally equivalent to:
C<ode>
setValue(value, 0);
@endcode

@param value the C<double> format number to which this node's value
should be set


=item ASTNode::setValue

Sets the value of this ASTNode to the given real (C<double>) in two
parts: the mantissa and the exponent.  The node type is set to
C<AST_REAL_E>.
@param mantissa the mantissa of this node's real-numbered value
@param exponent the exponent of this node's real-numbered value


=item ASTNode::setType

Sets the type of this ASTNode to the given <a class="el"
href="#ASTNodeType_t">ASTNodeType_t</a>.  A side-effect of doing this
is that any numerical values previously stored in this node are reset
to zero.
@param type the type to which this node should be set


=item ASTNode::swapChildren

Swap the children of this ASTNode with the children of C<that>
ASTNode.

@param that the other node whose children should be used to replace
<em>this</em> node's children


=item ASTNode::setSemanticsFlag

Sets the flag indicating that this ASTNode has semantics attached
@deprecated libSBML internal


=item ASTNode::unsetSemanticsFlag

Unsets the flag indicating that this ASTNode has semantics attached
@deprecated libSBML internal


=item ASTNode::getSemanticsFlag

gets the flag indicating that this ASTNode has semantics attached
@deprecated libSBML internal


=item ASTNode::setDefinitionURL

sets the definitionURL attributes
@deprecated libSBML internal


=item ASTNode::getDefinitionURL

Gets the MathML C<definitionURL> attribute value.


=item ASTNode::replaceArgument

Replaces occurences of a name within this ASTNode with the name/value/formula
represented by the second argument ASTNode
e.g. if the formula in this ASTNode is x + y; bvar is x and arg is an 
ASTNode representing the real value 3 ReplaceArgument substitutes 3 for
x within this ASTNode
@param bvar a string representing the variable name to be substituted
@param arg an ASTNode representing the name/value/formula to substitute


=item ASTNode::ReplaceArgument

Replaces occurences of a name within this ASTNode with the name/value/formula
represented by the second argument ASTNode
e.g. if the formula in this ASTNode is x + y; bvar is x and arg is an 
ASTNode representing the real value 3 ReplaceArgument substitutes 3 for
x within this ASTNode
@param bvar a string representing the variable name to be substituted
@param arg an ASTNode representing the name/value/formula to substitute
@deprecated libSBML internal


=item ASTNode::setParentSBMLObject

Sets the parent SBML object.
@param sb the parent SBML object of this ASTNode.
@deprecated libSBML internal


=item ASTNode::getParentSBMLObject

Returns the parent SBML object.
Returns the parent SBML object of this ASTNode.


=item ASTNode::ReduceToBinary

Returns the parent SBML object.
Returns the parent SBML object of this ASTNode.
@deprecated libSBML internal


=item ASTNode::reduceToBinary

Reduces this ASTNode to a binary tree
e.g. if the formula in this ASTNode is and(x, y, z) then the 
formula of the reduced node would be and(and(x, y), z)


=item ASTNode::setUserData

Sets the user data of this node. This can be used by the application
developer to attach custom information to the node. In case of a deep
copy this attribute will passed as it is. The attribute will be never
interpreted by this class.
@param userData specifies the new user data. 


=item ASTNode::*getUserData

Returns the user data that has been previously set via setUserData().
Returns the user data of this node. NULL if no user data has been.
@see ASTNode::setUserData


=item ASTNode::canonicalizeConstant

Internal helper function for canonicalize().
@deprecated libSBML internal


=item ASTNode::canonicalizeFunction

Internal helper function for canonicalize().
@deprecated libSBML internal


=item ASTNode::canonicalizeFunctionL1

Internal helper function for canonicalize().
@deprecated libSBML internal


=item ASTNode::canonicalizeLogical

Internal helper function for canonicalize().
@deprecated libSBML internal


=item ASTNode::canonicalizeRelational

Internal helper function for canonicalize().
@deprecated libSBML internal


=item ASTNode::canonicalizeRelational

Internal helper function for canonicalize().
@deprecated libSBML internal


=item ASTNode::canonicalizeRelational

Internal helper function for canonicalize().
@deprecated libSBML internal


=item ASTNode::canonicalizeRelational

Internal helper function for canonicalize().
@deprecated libSBML internal


=item ASTNode::canonicalizeRelational

Internal helper function for canonicalize().
@deprecated libSBML internal


=item ASTNode::canonicalizeRelational

Internal helper function for canonicalize().
@deprecated libSBML internal


=item ASTNode::canonicalizeRelational

Internal helper function for canonicalize().
@deprecated libSBML internal


=item ASTNode::canonicalizeRelational

Internal helper function for canonicalize().
@deprecated libSBML internal


=item ASTNode::canonicalizeRelational

Internal helper function for canonicalize().
@deprecated libSBML internal


=item ASTNode::canonicalizeRelational

Internal helper function for canonicalize().
@deprecated libSBML internal


=item ASTNode::canonicalizeRelational

Internal helper function for canonicalize().
@deprecated libSBML internal


=item ASTNode::canonicalizeRelational

Internal helper function for canonicalize().
@deprecated libSBML internal


=item ASTNode::canonicalizeRelational

Internal helper function for canonicalize().
@deprecated libSBML internal


=item ASTNode::canonicalizeRelational

Internal helper function for canonicalize().
@deprecated libSBML internal


=item ASTNode::canonicalizeRelational

Internal helper function for canonicalize().
@deprecated libSBML internal


=item ASTNode::canonicalizeRelational

Internal helper function for canonicalize().
@deprecated libSBML internal


=item SBML_parseFormula

Parses a text-string mathematical formula and returns a representation
as an Abstract Syntax Tree.
@if clike The text-string form of mathematical formulas produced by
SBML_formulaToString() and read by SBML_parseFormula() are simple
C-inspired infix notation taken from SBML Level&nbsp;1.  A formula in
this text-string form therefore can be handed to a program that
understands SBML Level&nbsp;1 mathematical expressions, or used as part
of a formula translation system.  The syntax is described in detail in
the documentation for ASTNode. @endif@if java The text-string form of
mathematical formulas produced by <code><a
href="libsbml.html">libsbml.formulaToString()</a></code> and read by
<code><a href="libsbml.html">libsbml.parseFormula()</a></code> are
simple C-inspired infix notation taken from SBML Level&nbsp;1.  A
formula in this text-string form therefore can be handed to a program
that understands SBML Level&nbsp;1 mathematical expressions, or used as
part of a formula translation system.  The syntax is described in detail
in the documentation for ASTNode.   @endif
@param formula the string containing the mathematical formula.
Returns an ASTNode (the root of the expression tree).  If the formula
contains a grammatical error, NULL is returned.


=item SBML_formulaToString

Converts an ASTNode formula to a text string using a specific
syntax for mathematical formulas.
@if clike The text-string form of mathematical formulas produced by
SBML_formulaToString() and read by SBML_parseFormula() are simple
C-inspired infix notation taken from SBML Level&nbsp;1.  A formula in
this text-string form therefore can be handed to a program that
understands SBML Level&nbsp;1 mathematical expressions, or used as part
of a formula translation system.  The syntax is described in detail in
the documentation for ASTNode. @endif@if java The text-string form of
mathematical formulas produced by <code><a
href="libsbml.html">libsbml.formulaToString()</a></code> and read by
<code><a href="libsbml.html">libsbml.parseFormula()</a></code> are
simple C-inspired infix notation taken from SBML Level&nbsp;1.  A
formula in this text-string form therefore can be handed to a program
that understands SBML Level&nbsp;1 mathematical expressions, or used as
part of a formula translation system.  The syntax is described in detail
in the documentation for ASTNode.   @endif
@param tree the root of the ASTNode formula expression tree
Returns the formula from the given AST as an SBML Level 1 text-string
mathematical formula.  The caller owns the returned string and is
responsible for freeing it when it is no longer needed.


=back

=head2 XMLAttributes

Representation of attributes on an XML node.
@htmlinclude libsbml-not-sbml-warning.html


=over

=item XMLAttributes::XMLAttributes

Creates a new empty XMLAttributes set.


=item XMLAttributes::XMLAttributes

Copy constructor; creates a copy of this XMLAttributes set.


=item XMLAttributes::clone

Creates and returns a deep copy of this XMLAttributes set.
Returns a (deep) copy of this XMLAttributes set.


=item XMLAttributes::add

Adds an attribute (a name/value pair) to this XMLAttributes set optionally 
with a prefix and URI defining a namespace.
@param name a string, the local name of the attribute.
@param value a string, the value of the attribute.
@param namespaceURI a string, the namespace URI of the attribute.
@param prefix a string, the prefix of the namespace
@note if local name with the same namespace URI already exists in this 
attribute set, its value and prefix will be replaced.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item XMLAttributes::add

Adds an attribute with the given XMLTriple/value pair to this XMLAttributes set.
@note if local name with the same namespace URI already exists in this attribute set, 
its value and prefix will be replaced.
@param triple an XMLTriple, the XML triple of the attribute.
@param value a string, the value of the attribute.


=item XMLAttributes::addResource

Adds an name/value pair to this XMLAttributes set.  
This method is similar to the add method but an attribute with same name wont 
be overwritten. This facilitates the addition of multiple resource attributes 
in CVTerm class.
@param name a string, the name of the attribute.
@param value a string, the value of the attribute.
@note This function is only internally used to store multiple rdf:resource 
attributes in CVTerm class, and thus should not be used for other purposes.
@deprecated libSBML internal


=item XMLAttributes::removeResource

Removes an attribute with the given index from this XMLAttributes set.  
@param n an integer the index of the resource to be deleted


=item XMLAttributes::remove

Removes an attribute with the given index from this XMLAttributes set.  
(This function is an alias of XMLAttributes::removeResource() ).
@param n an integer the index of the resource to be deleted


=item XMLAttributes::remove

Removes an attribute with the given local name and namespace URI from 
this XMLAttributes set.  
@param name   a string, the local name of the attribute.
@param uri    a string, the namespace URI of the attribute.


=item XMLAttributes::remove

Removes an attribute with the given XMLTriple from this XMLAttributes set.  
@param triple an XMLTriple, the XML triple of the attribute.


=item XMLAttributes::clear

Clears (deletes) all attributes in this XMLAttributes object.


=item XMLAttributes::getIndex

Return the index of an attribute with the given name.
@note A namespace bound to the name is not checked by this function.
Thus, if there are multiple attributes with the given local name and
different namespaces, the smallest index among those attributes will
be returned.  XMLAttributes::getIndex(name,uri) or
XMLAttributes::getIndex(triple) should be used to get an index of an
attribute with the given local name and namespace.
@param name a string, the local name of the attribute for which the 
index is required.
Returns the index of an attribute with the given local name, or -1 if not present.


=item XMLAttributes::getIndex

Return the index of an attribute with the given local name and namespace URI.
@param name a string, the local name of the attribute.
@param uri  a string, the namespace URI of the attribute.
Returns the index of an attribute with the given local name and namespace URI, 
or -1 if not present.


=item XMLAttributes::getIndex

Return the index of an attribute with the given XMLTriple.
@param triple an XMLTriple, the XML triple of the attribute for which 
the index is required.
Returns the index of an attribute with the given XMLTriple, or -1 if not present.


=item XMLAttributes::getLength

Return the number of attributes in the set.
Returns the number of attributes in this XMLAttributes set.


=item XMLAttributes::getName

Return the local name of an attribute in this XMLAttributes set (by position).
@param index an integer, the position of the attribute whose local name is 
required.

Returns the local name of an attribute in this list (by position).  
@note If index is out of range, an empty string will be returned.  Use
XMLAttributes::hasAttribute(index) to test for the attribute
existence.



=item XMLAttributes::getPrefix

Return the prefix of an attribute in this XMLAttributes set (by position).
@param index an integer, the position of the attribute whose prefix is 
required.

Returns the namespace prefix of an attribute in this list (by
position).  

@note If index is out of range, an empty string will be returned. Use
XMLAttributes::hasAttribute(index) to test for the attribute
existence.



=item XMLAttributes::getPrefixedName

Return the prefixed name of an attribute in this XMLAttributes set (by position).
@param index an integer, the position of the attribute whose prefixed 
name is required.
Returns the prefixed name of an attribute in this list (by
position).  

@note If index is out of range, an empty string will be returned.  Use
XMLAttributes::hasAttribute(index) to test for attribute existence.


=item XMLAttributes::getURI

Return the namespace URI of an attribute in this XMLAttributes set (by position).
@param index an integer, the position of the attribute whose namespace URI is 
required.

Returns the namespace URI of an attribute in this list (by position).
@note If index is out of range, an empty string will be returned.  Use
XMLAttributes::hasAttribute(index) to test for attribute existence.


=item XMLAttributes::getValue

Return the value of an attribute in this XMLAttributes set (by position).
@param index an integer, the position of the attribute whose value is 
required.

Returns the value of an attribute in the list (by position).  
@note If index is out of range, an empty string will be returned.  Use
XMLAttributes::hasAttribute(index) to test for attribute existence.


=item XMLAttributes::getValue

Return an attribute's value by name.
@param name a string, the local name of the attribute whose value is required.
Returns The attribute value as a string.  
@note If an attribute with the given local name does not exist, an
empty string will be returned.  Use XMLAttributes::hasAttribute(name)
to test for attribute existence.  A namespace bound to the local name
is not checked by this function.  Thus, if there are multiple
attributes with the given local name and different namespaces, the
value of an attribute with the smallest index among those attributes
will be returned.  XMLAttributes::getValue(name,uri) or
XMLAttributes::getValue(triple) should be used to get a value of an
attribute with the given local name and namespace.


=item XMLAttributes::getValue

Return a value of an attribute with the given local name and namespace URI.
@param name a string, the local name of the attribute whose value is required.
@param uri  a string, the namespace URI of the attribute.
Returns The attribute value as a string.  
@note If an attribute with the given local name and namespace URI does
not exist, an empty string will be returned.  Use
XMLAttributes::hasAttribute(name, uri) to test for attribute
existence.



=item XMLAttributes::getValue

Return a value of an attribute with the given XMLTriple.
@param triple an XMLTriple, the XML triple of the attribute whose 
value is required.
Returns The attribute value as a string.  
@note If an attribute with the given XMLTriple does not exist, an
empty string will be returned.  Use
XMLAttributes::hasAttribute(triple) to test for attribute existence.


=item XMLAttributes::hasAttribute

Predicate returning C<true> or C<false> depending on whether
an attribute with the given index exists in this XMLAttributes.
@param index an integer, the position of the attribute.
Returns C<true> if an attribute with the given index exists in this
XMLAttributes, C<false> otherwise.


=item XMLAttributes::hasAttribute

Predicate returning C<true> or C<false> depending on whether
an attribute with the given local name and namespace URI exists in this 
XMLAttributes.

@param name a string, the local name of the attribute.
@param uri  a string, the namespace URI of the attribute.
Returns C<true> if an attribute with the given local name and namespace 
URI exists in this XMLAttributes, C<false> otherwise.


=item XMLAttributes::hasAttribute

Predicate returning C<true> or C<false> depending on whether
an attribute with the given XML triple exists in this XMLAttributes.
@param triple an XMLTriple, the XML triple of the attribute 
Returns C<true> if an attribute with the given XML triple exists in this
XMLAttributes, C<false> otherwise.


=item XMLAttributes::isEmpty

Predicate returning C<true> or C<false> depending on whether 
this XMLAttributes set is empty.
Returns C<true> if this XMLAttributes set is empty, C<false> otherwise.


=item XMLAttributes::readInto

Reads the value for the attribute name into value.  If the given local
name was not found or value could be interpreted as a boolean, value 
is not modified.
According to the W3C XML Schema, valid boolean values are: "true",
"false", "1", and "0" (case-insensitive).  For more information, see:
http://www.w3.org/TR/xmlschema-2/#boolean

If an XMLErrorLog is passed in datatype format errors are logged.  If
required is true, missing attributes are also logged.
@param name a string, the local name of the attribute.
@param value a boolean, the value of the attribute.
@param log an XMLErrorLog, the error log.
@param required a boolean, indicating whether the attribute is required.
Returnss C<true> if the attribute was read into value, C<false> otherwise.
@note A namespace bound to the given local name is not checked by this
function. XMLAttributes::readInto(const XMLTriple, bool&, ...) should
be used to read a value for an attribute name with a prefix and
namespace.

@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item XMLAttributes::readInto

Reads the value for the attribute with the given XMLTriple into value.  
If the XMLTriple was not found or value could be interpreted as a boolean, 
value is not modified.
According to the W3C XML Schema, valid boolean values are: "true",
"false", "1", and "0" (case-insensitive).  For more information, see:
http://www.w3.org/TR/xmlschema-2/#boolean

If an XMLErrorLog is passed in datatype format errors are logged.  If
required is true, missing attributes are also logged.
@param triple an XMLTriple, the XML triple of the attribute.
@param value a boolean, the value of the attribute.
@param log an XMLErrorLog, the error log.
@param required a boolean, indicating whether the attribute is required.
Returnss C<true> if the attribute was read into value, C<false> otherwise.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item XMLAttributes::readInto

Reads the value for the attribute name into value.  If the given local
name was not found or value could be interpreted as a double, value is 
not modified.
According to the W3C XML Schema, valid doubles are the same as valid
doubles for C and the special values "INF", "-INF", and "NaN"
(case-sensitive).  For more information, see:
http://www.w3.org/TR/xmlschema-2/#double

If an XMLErrorLog is passed in datatype format errors are logged.  If
required is true, missing attributes are also logged.
@param name a string, the local name of the attribute.
@param value a double, the value of the attribute.
@param log an XMLErrorLog, the error log.
@param required a boolean, indicating whether the attribute is required.
Returnss C<true> if the attribute was read into value, C<false> otherwise.
@note A namespace bound to the given local name is not checked by this
function.  XMLAttributes::readInto(const XMLTriple, double&, ...)
should be used to read a value for an attribute name with a prefix and
namespace.

@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item XMLAttributes::readInto

Reads the value for the attribute with the given XMLTriple into value.  
If the triple was not found or value could be interpreted as a double, 
value is not modified.
According to the W3C XML Schema, valid doubles are the same as valid
doubles for C and the special values "INF", "-INF", and "NaN"
(case-sensitive).  For more information, see:
http://www.w3.org/TR/xmlschema-2/#double

If an XMLErrorLog is passed in datatype format errors are logged.  If
required is true, missing attributes are also logged.
@param triple an XMLTriple, the XML triple of the attribute.
@param value a double, the value of the attribute.
@param log an XMLErrorLog, the error log.
@param required a boolean, indicating whether the attribute is required.
Returnss C<true> if the attribute was read into value, C<false> otherwise.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item XMLAttributes::readInto

Reads the value for the attribute name into value.  If the given local
name was not found or value could be interpreted as an long, value is 
not modified.
According to the W3C XML Schema valid integers include zero,  all 
positive and  all  negative whole numbers.  For practical purposes, we
limit values to what can be stored in a long.  For more information,
see: http://www.w3.org/TR/xmlschema-2/#integer
If an XMLErrorLog is passed in datatype format errors are logged.  If
required is true, missing attributes are also logged.
@param name a string, the local name of the attribute.
@param value a long, the value of the attribute.
@param log an XMLErrorLog, the error log.
@param required a boolean, indicating whether the attribute is required.
Returnss C<true> if the attribute was read into value, C<false> otherwise.
@note A namespace bound to the given local name is not checked by this
function.  XMLAttributes::readInto(const XMLTriple, long&, ...) should
be used to read a value for an attribute name with a prefix and
namespace.

@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item XMLAttributes::readInto

Reads the value for the attribute XMLTriple into value.  
If the XMLTriple was not found or value could be interpreted as a long, 
value is not modified.
According to the W3C XML Schema valid integers include zero,  all 
positive and  all  negative whole numbers.  For practical purposes, we
limit values to what can be stored in a long.  For more information,
see: http://www.w3.org/TR/xmlschema-2/#integer
If an XMLErrorLog is passed in datatype format errors are logged.  If
required is true, missing attributes are also logged.
@param triple an XMLTriple, the XML triple of the attribute.
@param value a long, the value of the attribute.
@param log an XMLErrorLog, the error log.
@param required a boolean, indicating whether the attribute is required.
Returnss C<true> if the attribute was read into value, C<false> otherwise.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item XMLAttributes::readInto

Reads the value for the attribute name into value.  If the given local
name was not found or value could be interpreted as an int, value is 
not modified.
According to the W3C XML Schema valid integers include zero,  all 
positive and  all  negative whole numbers.  For practical purposes, we
limit values to what can be stored in a int.  For more information,
see: http://www.w3.org/TR/xmlschema-2/#integer
If an XMLErrorLog is passed in datatype format errors are logged.  If
required is true, missing attributes are also logged.
@param name a string, the local name of the attribute.
@param value an integer, the value of the attribute.
@param log an XMLErrorLog, the error log.
@param required a boolean, indicating whether the attribute is required.
Returnss C<true> if the attribute was read into value, C<false> otherwise.
@note A namespace bound to the given local name is not checked by this
function.  XMLAttributes::readInto(const XMLTriple, int&, ...) should
be used to read a value for an attribute name with a prefix and
namespace.

@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item XMLAttributes::readInto

Reads the value for the attribute with the given XMLTriple into value.  
If the XMLTriple was not found or value could be interpreted as an int, 
value is not modified.
According to the W3C XML Schema valid integers include zero,  all 
positive and  all  negative whole numbers.  For practical purposes, we
limit values to what can be stored in a int.  For more information,
see: http://www.w3.org/TR/xmlschema-2/#integer
If an XMLErrorLog is passed in datatype format errors are logged.  If
required is true, missing attributes are also logged.
@param triple an XMLTriple, the XML triple of the attribute.
@param value an integer, the value of the attribute.
@param log an XMLErrorLog, the error log.
@param required a boolean, indicating whether the attribute is required.
Returnss C<true> if the attribute was read into value, C<false> otherwise.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item XMLAttributes::readInto

Reads the value for the attribute name into value.  If the given local
name was not found or value could be interpreted as an unsigned int, 
value is not modified.
According to the W3C XML Schema valid integers include zero,  all 
positive and  all  negative whole numbers.  For practical purposes, we
limit values to what can be stored in a unsigned int.  For more
information, see: http://www.w3.org/TR/xmlschema-2/#integer
If an XMLErrorLog is passed in datatype format errors are logged.  If
required is true, missing attributes are also logged.
@param name a string, the local name of the attribute.
@param value an unsigned integer, the value of the attribute.
@param log an XMLErrorLog, the error log.
@param required a boolean, indicating whether the attribute is required.
Returnss C<true> if the attribute was read into value, C<false> otherwise.
@note A namespace bound to the given local name is not checked by this
function.  XMLAttributes::readInto(const XMLTriple, unsigned int&,
...) should be used to read a value for an attribute name with a
prefix and namespace.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item XMLAttributes::readInto

Reads the value for the attribute with the given XMLTriple into value.  
If the XMLTriple was not found or value could be interpreted as an unsigned int, 
value is not modified.
According to the W3C XML Schema valid integers include zero,  all 
positive and  all  negative whole numbers.  For practical purposes, we
limit values to what can be stored in a unsigned int.  For more
information, see: http://www.w3.org/TR/xmlschema-2/#integer
If an XMLErrorLog is passed in datatype format errors are logged.  If
required is true, missing attributes are also logged.
@param triple an XMLTriple, the XML triple of the attribute.
@param value an unsigned integer, the value of the attribute.
@param log an XMLErrorLog, the error log.
@param required a boolean, indicating whether the attribute is required.
Returnss C<true> if the attribute was read into value, C<false> otherwise.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item XMLAttributes::readInto

Reads the value for the attribute name into value.  If the given local
name was not found, value is not modified.
If an XMLErrorLog is passed in and required is true, missing
attributes are logged.
@param name a string, the local name of the attribute.
@param value a string, the value of the attribute.
@param log an XMLErrorLog, the error log.
@param required a boolean, indicating whether the attribute is required.
Returnss C<true> if the attribute was read into value, C<false> otherwise.
@note A namespace bound to the given local name is not checked by this
function. XMLAttributes::readInto(const XMLTriple, std::string&, ...)
should be used to read a value for an attribute name with a prefix and
namespace.

@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item XMLAttributes::readInto

Reads the value for the attribute with the given XMLTriple into value.  
If the XMLTriple was not found, value is not modified.
If an XMLErrorLog is passed in and required is true, missing
attributes are logged.
@param triple an XMLTriple, the XML triple of the attribute.
@param value a string, the value of the attribute.
@param log an XMLErrorLog, the error log.
@param required a boolean, indicating whether the attribute is required.
Returnss C<true> if the attribute was read into value, C<false> otherwise.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item XMLAttributes::write

Writes this XMLAttributes set to stream.
@param stream XMLOutputStream, stream to which this XMLAttributes
set is to be written.
@deprecated libSBML internal


=item XMLAttributes::setErrorLog

(Optional) Sets the log used when logging attributeTypeError() and
attributeRequired() errors.
@param log the log to use
@deprecated libSBML internal


=item XMLAttributes::attributeTypeError

Logs an attribute datatype error.
@param name  name of the attribute
@param type  the datatype of the attribute value.
@param log   the XMLErrorLog where the error should be logged
@deprecated libSBML internal


=item XMLAttributes::attributeRequiredError

Logs an error indicating a required attribute was missing.
Used internally.
@param name  name of the attribute
@param log   the XMLErrorLog where the error should be logged
@deprecated libSBML internal


=item XMLAttributes::readInto

Reads the value for the attribute with the given index into value.  
If the attribute was not found or value could be interpreted as a boolean, 
value is not modified.
According to the W3C XML Schema, valid boolean values are: "true",
"false", "1", and "0" (case-insensitive).  For more information, see:
http://www.w3.org/TR/xmlschema-2/#boolean

If an XMLErrorLog is passed in datatype format errors are logged.  If
required is true, missing attributes are also logged.
@param index a int, the index of the attribute.
@param name a string, the name of the attribute 
(only used for an error message (if error detected))
@param value a boolean, the value of the attribute.
@param log an XMLErrorLog, the error log.
@param required a boolean, indicating whether the attribute is required.
Returnss C<true> if the attribute was read into value, C<false> otherwise.
@deprecated libSBML internal


=item XMLAttributes::readInto

Reads the value for the attribute with the given index into value.  
If name was not found or value could be interpreted as a double, value 
is not modified.
According to the W3C XML Schema, valid doubles are the same as valid
doubles for C and the special values "INF", "-INF", and "NaN"
(case-sensitive).  For more information, see:
http://www.w3.org/TR/xmlschema-2/#double

If an XMLErrorLog is passed in datatype format errors are logged.  If
required is true, missing attributes are also logged.
@param index a int, the index of the attribute.
@param name a string, the name of the attribute
(only used for an error message (if error detected))
@param value a double, the value of the attribute.
@param log an XMLErrorLog, the error log.
@param required a boolean, indicating whether the attribute is required.
Returnss C<true> if the attribute was read into value, C<false> otherwise.
@deprecated libSBML internal


=item XMLAttributes::readInto

Reads the value for the attribute with the given index into value.  
If the attribute was not found or value could be interpreted as a long, 
value is not modified.
According to the W3C XML Schema valid integers include zero,  all 
positive and  all  negative whole numbers.  For practical purposes, we
limit values to what can be stored in a long.  For more information,
see: http://www.w3.org/TR/xmlschema-2/#integer
If an XMLErrorLog is passed in datatype format errors are logged.  If
required is true, missing attributes are also logged.
@param index a int, the index of the attribute.
@param name a string, the name of the attribute
(only used for an error message (if error detected))
@param value a long, the value of the attribute.
@param log an XMLErrorLog, the error log.
@param required a boolean, indicating whether the attribute is required.
Returnss C<true> if the attribute was read into value, C<false> otherwise.
@deprecated libSBML internal


=item XMLAttributes::readInto

Reads the value for the attribute with the given index into value.  
If the attribute was not found or value could be interpreted as an integer, 
value is not modified.
According to the W3C XML Schema valid integers include zero,  all 
positive and  all  negative whole numbers.  For practical purposes, we
limit values to what can be stored in a int.  For more information,
see: http://www.w3.org/TR/xmlschema-2/#integer
If an XMLErrorLog is passed in datatype format errors are logged.  If
required is true, missing attributes are also logged.
@param index a int, the index of the attribute.
@param name a string, the name of the attribute
(only used for an error message (if error detected))
@param value an integer, the value of the attribute.
@param log an XMLErrorLog, the error log.
@param required a boolean, indicating whether the attribute is required.
Returnss C<true> if the attribute was read into value, C<false> otherwise.
@deprecated libSBML internal


=item XMLAttributes::readInto

Reads the value for the attribute with the given index into value.  
If the attribute was not found or value could be interpreted as an 
unsigned int, value is not modified.
According to the W3C XML Schema valid integers include zero,  all 
positive and  all  negative whole numbers.  For practical purposes, we
limit values to what can be stored in a unsigned int.  For more
information, see: http://www.w3.org/TR/xmlschema-2/#integer
If an XMLErrorLog is passed in datatype format errors are logged.  If
required is true, missing attributes are also logged.
@param index a int, the index of the attribute.
@param name a string, the name of the attribute
(only used for an error message (if error detected))
@param value an unsigned integer, the value of the attribute.
@param log an XMLErrorLog, the error log.
@param required a boolean, indicating whether the attribute is required.
Returnss C<true> if the attribute was read into value, C<false> otherwise.
@deprecated libSBML internal


=item XMLAttributes::readInto

Reads the value for the attribute with the given index into value.  
If the attribute was not found, value is not modified.
If an XMLErrorLog is passed in and required is true, missing
attributes are logged.
@param index a int, the index of the attribute.
@param name a string, the name of the attribute
(only used for an error message (if error detected))
@param value a string, the value of the attribute.
@param log an XMLErrorLog, the error log.
@param required a boolean, indicating whether the attribute is required.
Returnss C<true> if the attribute was read into value, C<false> otherwise.
@deprecated libSBML internal


=item XMLAttributes::readInto

Reads the value for the attribute with the given index into value.  
If the attribute was not found, value is not modified.
If an XMLErrorLog is passed in and required is true, missing
attributes are logged.
@param index a int, the index of the attribute.
@param name a string, the name of the attribute
(only used for an error message (if error detected))
@param value a string, the value of the attribute.
@param log an XMLErrorLog, the error log.
@param required a boolean, indicating whether the attribute is required.
Returnss C<true> if the attribute was read into value, C<false> otherwise.
@deprecated libSBML internal


=item XMLAttributes::readInto

Reads the value for the attribute with the given index into value.  
If the attribute was not found, value is not modified.
If an XMLErrorLog is passed in and required is true, missing
attributes are logged.
@param index a int, the index of the attribute.
@param name a string, the name of the attribute
(only used for an error message (if error detected))
@param value a string, the value of the attribute.
@param log an XMLErrorLog, the error log.
@param required a boolean, indicating whether the attribute is required.
Returnss C<true> if the attribute was read into value, C<false> otherwise.
@deprecated libSBML internal


=item XMLAttributes::readInto

Reads the value for the attribute with the given index into value.  
If the attribute was not found, value is not modified.
If an XMLErrorLog is passed in and required is true, missing
attributes are logged.
@param index a int, the index of the attribute.
@param name a string, the name of the attribute
(only used for an error message (if error detected))
@param value a string, the value of the attribute.
@param log an XMLErrorLog, the error log.
@param required a boolean, indicating whether the attribute is required.
Returnss C<true> if the attribute was read into value, C<false> otherwise.
@deprecated libSBML internal


=item XMLAttributes::readInto

Reads the value for the attribute with the given index into value.  
If the attribute was not found, value is not modified.
If an XMLErrorLog is passed in and required is true, missing
attributes are logged.
@param index a int, the index of the attribute.
@param name a string, the name of the attribute
(only used for an error message (if error detected))
@param value a string, the value of the attribute.
@param log an XMLErrorLog, the error log.
@param required a boolean, indicating whether the attribute is required.
Returnss C<true> if the attribute was read into value, C<false> otherwise.
@deprecated libSBML internal


=back

=head2 XMLNamespaces

Representation of XML Namespaces.
@htmlinclude libsbml-not-sbml-warning.html
This class serves to organize functionality for tracking XML namespaces
in a document or data stream.  The namespace declarations are stored as
a list of pairs of XML namespace URIs and prefix strings.  These
correspond to the parts of a namespace declaration on an XML element.
For example, in the following XML fragment,
@verbatim
<annotation>
<mysim:nodecolors xmlns:mysim="urn:lsid:mysim.org"
mysim:bgcolor="green" mysim:fgcolor="white"/>
</annotation>
@endverbatim
there is one namespace declaration.  Its URI is
C<urn:lsid:mysim.org> and its prefix is C<mysim>.
This pair could be stored as one item in an XMLNamespaces list.
XMLNamespaces provides various methods for manipulating the list of
prefix-URI pairs.  Individual namespaces stored in a given XMLNamespace
object instance can be retrieved based on their index using
XMLNamespaces::getPrefix(int index), or by their characteristics such as
their URI or position in the list.


=over

=item XMLNamespaces::XMLNamespaces

Creates a new empty list of XML namespace declarations.


=item XMLNamespaces::XMLNamespaces

Copy constructor; creates a copy of this XMLNamespaces list.
@param orig the XMLNamespaces object to copy


=item XMLNamespaces::clone

Creates and returns a deep copy of this XMLNamespaces list.
Returns a (deep) copy of this XMLNamespaces list.


=item XMLNamespaces::add

Appends an XML namespace prefix and URI pair to this list of namespace
declarations.

An XMLNamespace object stores a list of pairs of namespaces and their
prefixes.  If there is an XML namespace with the given C<uri> prefix
in this list, then its corresponding URI will be overwritten by the
new C<uri>.  Calling programs could use one of the other XMLNamespaces
methods, such as
@if clike XMLNamespaces::hasPrefix() @endif@if java XMLNamespaces::hasPrefix(String) @endif and 
@if clike XMLNamespaces::hasURI() @endif@if java XMLNamespaces::hasURI(String) @endif to
inquire whether a given prefix and/or URI
is already present in this XMLNamespaces object.
@param uri a string, the uri for the namespace
@param prefix a string, the prefix for the namespace
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item XMLNamespaces::remove

Removes an XML Namespace stored in the given position of this list.
@param index an integer, position of the removed namespace.


=item XMLNamespaces::remove

Removes an XML Namespace with the given prefix.
@param prefix a string, prefix of the required namespace.
@see remove(int index)


=item XMLNamespaces::clear

Clears (deletes) all XML namespace declarations in this XMLNamespaces
object.

@see remove(int index)


=item XMLNamespaces::getIndex

Look up the index of an XML namespace declaration by URI.
An XMLNamespace object stores a list of pairs of namespaces and their
prefixes.  If this XMLNamespaces object contains a pair with the given
URI C<uri>, this method returns its index in the list.
@param uri a string, the URI of the sought-after namespace.
Returns the index of the given declaration, or C<-1> if not
present.



=item XMLNamespaces::getIndexByPrefix

Look up the index of an XML namespace declaration by prefix.
An XMLNamespace object stores a list of pairs of namespaces and their
prefixes.  If this XMLNamespaces object contains a pair with the given
prefix C<prefix>, this method returns its index in the list.
@param prefix a string, the prefix string of the sought-after
namespace

Returns the index of the given declaration, or C<-1> if not
present.



=item XMLNamespaces::getLength

Returns the total number of URI-and-prefix pairs stored in this
particular XMLNamespaces instance.
Returns the number of namespaces in this list.


=item XMLNamespaces::getPrefix

Look up the prefix of an XML namespace declaration by its position.
An XMLNamespace object stores a list of pairs of namespaces and their
prefixes.  This method returns the prefix of the C<n>th
element in that list (if it exists).  Callers should use
XMLAttributes::getLength() first to find out how many namespaces are
stored in the list.
@param index an integer, position of the sought-after prefix
Returns the prefix of an XML namespace declaration in this list (by
position), or an empty string if the C<index> is out of range
@see getLength()


=item XMLNamespaces::getPrefix

Look up the prefix of an XML namespace declaration by its URI.
An XMLNamespace object stores a list of pairs of namespaces and their
prefixes.  This method returns the prefix for a pair that has the
given C<uri>.
@param uri a string, the URI of the prefix being sought
Returns the prefix of an XML namespace declaration given its URI, or
an empty string if no such C<uri> exists in this XMLNamespaces object


=item XMLNamespaces::getURI

Look up the URI of an XML namespace declaration by its position.
An XMLNamespace object stores a list of pairs of namespaces and their
prefixes.  This method returns the URI of the C<n>th element
in that list (if it exists).  Callers should use
XMLAttributes::getLength() first to find out how many namespaces are
stored in the list.
@param index an integer, position of the required URI.
Returns the URI of an XML namespace declaration in this list (by
position), or an empty string if the C<index> is out of range.
@see getLength()


=item XMLNamespaces::getURI

Look up the URI of an XML namespace declaration by its prefix.
An XMLNamespace object stores a list of pairs of namespaces and their
prefixes.  This method returns the namespace URI for a pair that has
the given C<prefix>.
@param prefix a string, the prefix of the required URI
Returns the URI of an XML namespace declaration having the given @p
prefix, or an empty string if no such prefix-and-URI pair exists
in this XMLNamespaces object
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.

@see getURI()


=item XMLNamespaces::isEmpty

Predicate returning C<true> or C<false> depending on whether this
XMLNamespaces list is empty.
Returns C<true> if this XMLNamespaces list is empty, C<false> otherwise.


=item XMLNamespaces::hasURI

Predicate returning C<true> or C<false> depending on whether an XML
Namespace with the given URI is contained in this XMLNamespaces list.
@param uri a string, the uri for the namespace
Returns C<true> if an XML Namespace with the given URI is contained in
this XMLNamespaces list, C<false> otherwise.


=item XMLNamespaces::hasPrefix

Predicate returning C<true> or C<false> depending on whether an XML
Namespace with the given prefix is contained in this XMLNamespaces
list.

@param prefix a string, the prefix for the namespace
Returns C<true> if an XML Namespace with the given URI is contained in
this XMLNamespaces list, C<false> otherwise.


=item XMLNamespaces::hasNS

Predicate returning C<true> or C<false> depending on whether an XML
Namespace with the given URI and prefix pair is contained in this
XMLNamespaces list.
@param uri a string, the URI for the namespace
@param prefix a string, the prefix for the namespace
Returns C<true> if an XML Namespace with the given uri/prefix pair is
contained in this XMLNamespaces list, C<false> otherwise.


=item XMLNamespaces::removeDefault

Removes the default XML namespace.
@deprecated libSBML internal


=back

=head2 XMLToken

Representation of a token in an XML stream.
@htmlinclude libsbml-not-sbml-warning.html


=over

=item XMLToken::XMLToken

Creates a new empty XMLToken.


=item XMLToken::XMLToken

Creates a start element XMLToken with the given set of attributes and
namespace declarations.
@param triple XMLTriple.
@param attributes XMLAttributes, the attributes to set.
@param namespaces XMLNamespaces, the namespaces to set.
@param line an unsigned int, the line number (default = 0).
@param column an unsigned int, the column number (default = 0).
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item XMLToken::XMLToken

Creates a start element XMLToken with the given set of attributes.
@param triple XMLTriple.
@param attributes XMLAttributes, the attributes to set.
@param line an unsigned int, the line number (default = 0).
@param column an unsigned int, the column number (default = 0).
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item XMLToken::XMLToken

Creates an end element XMLToken.
@param triple XMLTriple.
@param line an unsigned int, the line number (default = 0).
@param column an unsigned int, the column number (default = 0).
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item XMLToken::XMLToken

Creates a text XMLToken.
@param chars a string, the text to be added to the XMLToken
@param line an unsigned int, the line number (default = 0).
@param column an unsigned int, the column number (default = 0).
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item XMLToken::XMLToken

Copy constructor; creates a copy of this XMLToken.


=item XMLToken::clone

Creates and returns a deep copy of this XMLToken.
Returns a (deep) copy of this XMLToken set.


=item XMLToken::getAttributes

Returns the attributes of this element.
Returns the XMLAttributes of this XML element.


=item XMLToken::setAttributes

Sets an XMLAttributes to this XMLToken.
Nothing will be done if this XMLToken is not a start element.
@param attributes XMLAttributes to be set to this XMLToken.
@note This function replaces the existing XMLAttributes with the new one.


=item XMLToken::addAttr

Adds an attribute to the attribute set in this XMLToken optionally 
with a prefix and URI defining a namespace.
Nothing will be done if this XMLToken is not a start element.
@param name a string, the local name of the attribute.
@param value a string, the value of the attribute.
@param namespaceURI a string, the namespace URI of the attribute.
@param prefix a string, the prefix of the namespace
@note if local name with the same namespace URI already exists in the
attribute set, its value and prefix will be replaced.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item XMLToken::addAttr

Adds an attribute with the given XMLTriple/value pair to the attribute set
in this XMLToken.
Nothing will be done if this XMLToken is not a start element.
@note if local name with the same namespace URI already exists in the 
attribute set, its value and prefix will be replaced.
@param triple an XMLTriple, the XML triple of the attribute.
@param value a string, the value of the attribute.


=item XMLToken::removeAttr

Removes an attribute with the given index from the attribute set in
this XMLToken.
Nothing will be done if this XMLToken is not a start element.
@param n an integer the index of the resource to be deleted


=item XMLToken::removeAttr

Removes an attribute with the given local name and namespace URI from 
the attribute set in this XMLToken.
Nothing will be done if this XMLToken is not a start element.
@param name   a string, the local name of the attribute.
@param uri    a string, the namespace URI of the attribute.


=item XMLToken::removeAttr

Removes an attribute with the given XMLTriple from the attribute set 
in this XMLToken.  
Nothing will be done if this XMLToken is not a start element.
@param triple an XMLTriple, the XML triple of the attribute.


=item XMLToken::clearAttributes

Clears (deletes) all attributes in this XMLToken.
Nothing will be done if this XMLToken is not a start element.


=item XMLToken::getAttrIndex

Return the index of an attribute with the given local name and namespace URI.
@param name a string, the local name of the attribute.
@param uri  a string, the namespace URI of the attribute.
Returns the index of an attribute with the given local name and namespace URI, 
or -1 if not present.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item XMLToken::getAttrIndex

Return the index of an attribute with the given XMLTriple.
@param triple an XMLTriple, the XML triple of the attribute for which 
the index is required.
Returns the index of an attribute with the given XMLTriple, or -1 if not present.


=item XMLToken::getAttributesLength

Return the number of attributes in the attributes set.
Returns the number of attributes in the attributes set in this XMLToken.


=item XMLToken::getAttrName

Return the local name of an attribute in the attributes set in this 
XMLToken (by position).
@param index an integer, the position of the attribute whose local name 
is required.
Returns the local name of an attribute in this list (by position).  
@note If index
is out of range, an empty string will be returned.  Use hasAttr(index) 
to test for the attribute existence.


=item XMLToken::getAttrPrefix

Return the prefix of an attribute in the attribute set in this 
XMLToken (by position).
@param index an integer, the position of the attribute whose prefix is 
required.

Returns the namespace prefix of an attribute in the attribute set
(by position).  
@note If index is out of range, an empty string will be
returned. Use hasAttr(index) to test for the attribute existence.


=item XMLToken::getAttrPrefixedName

Return the prefixed name of an attribute in the attribute set in this 
XMLToken (by position).
@param index an integer, the position of the attribute whose prefixed 
name is required.
Returns the prefixed name of an attribute in the attribute set 
(by position).  
@note If index is out of range, an empty string will be
returned.  Use hasAttr(index) to test for attribute existence.


=item XMLToken::getAttrURI

Return the namespace URI of an attribute in the attribute set in this 
XMLToken (by position).
@param index an integer, the position of the attribute whose namespace 
URI is required.
Returns the namespace URI of an attribute in the attribute set (by position).
@note If index is out of range, an empty string will be returned.  Use
hasAttr(index) to test for attribute existence.


=item XMLToken::getAttrValue

Return the value of an attribute in the attribute set in this XMLToken  
(by position).
@param index an integer, the position of the attribute whose value is 
required.

Returns the value of an attribute in the attribute set (by position).  
@note If index
is out of range, an empty string will be returned. Use hasAttr(index)
to test for attribute existence.


=item XMLToken::getAttrValue

Return a value of an attribute with the given local name and namespace URI.
@param name a string, the local name of the attribute whose value is required.
@param uri  a string, the namespace URI of the attribute.
Returns The attribute value as a string.  
@note If an attribute with the 
given local name and namespace URI does not exist, an empty string will be 
returned.  
Use hasAttr(name, uri) to test for attribute existence.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item XMLToken::getAttrValue

Return a value of an attribute with the given XMLTriple.
@param triple an XMLTriple, the XML triple of the attribute whose 
value is required.
Returns The attribute value as a string.  
@note If an attribute with the
given XMLTriple does not exist, an empty string will be returned.  
Use hasAttr(triple) to test for attribute existence.


=item XMLToken::hasAttr

Predicate returning C<true> or C<false> depending on whether
an attribute with the given index exists in the attribute set in this 
XMLToken.

@param index an integer, the position of the attribute.
Returns C<true> if an attribute with the given index exists in the attribute 
set in this XMLToken, C<false> otherwise.


=item XMLToken::hasAttr

Predicate returning C<true> or C<false> depending on whether
an attribute with the given local name and namespace URI exists 
in the attribute set in this XMLToken.
@param name a string, the local name of the attribute.
@param uri  a string, the namespace URI of the attribute.
Returns C<true> if an attribute with the given local name and namespace 
URI exists in the attribute set in this XMLToken, C<false> otherwise.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item XMLToken::hasAttr

Predicate returning C<true> or C<false> depending on whether
an attribute with the given XML triple exists in the attribute set in 
this XMLToken 
@param triple an XMLTriple, the XML triple of the attribute 
Returns C<true> if an attribute with the given XML triple exists
in the attribute set in this XMLToken, C<false> otherwise.


=item XMLToken::isAttributesEmpty

Predicate returning C<true> or C<false> depending on whether 
the attribute set in this XMLToken set is empty.
Returns C<true> if the attribute set in this XMLToken is empty, 
C<false> otherwise.


=item XMLToken::getNamespaces

Returns the XML namespace declarations for this XML element.
Returns the XML namespace declarations for this XML element.


=item XMLToken::setNamespaces

Sets an XMLnamespaces to this XML element.
Nothing will be done if this XMLToken is not a start element.
@param namespaces XMLNamespaces to be set to this XMLToken.
@note This function replaces the existing XMLNamespaces with the new one.


=item XMLToken::addNamespace

Appends an XML namespace prefix and URI pair to this XMLToken.
If there is an XML namespace with the given prefix in this XMLToken, 
then the existing XML namespace will be overwritten by the new one.
Nothing will be done if this XMLToken is not a start element.
@param uri a string, the uri for the namespace
@param prefix a string, the prefix for the namespace
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item XMLToken::removeNamespace

Removes an XML Namespace stored in the given position of the XMLNamespaces
of this XMLToken.
Nothing will be done if this XMLToken is not a start element.
@param index an integer, position of the removed namespace.


=item XMLToken::removeNamespace

Removes an XML Namespace with the given prefix.
Nothing will be done if this XMLToken is not a start element.
@param prefix a string, prefix of the required namespace.


=item XMLToken::clearNamespaces

Clears (deletes) all XML namespace declarations in the XMLNamespaces of
this XMLToken.
Nothing will be done if this XMLToken is not a start element.


=item XMLToken::getNamespaceIndex

Look up the index of an XML namespace declaration by URI.
@param uri a string, uri of the required namespace.
Returns the index of the given declaration, or -1 if not present.


=item XMLToken::getNamespaceIndexByPrefix

Look up the index of an XML namespace declaration by prefix.
@param prefix a string, prefix of the required namespace.
Returns the index of the given declaration, or -1 if not present.


=item XMLToken::getNamespacesLength

Returns the number of XML namespaces stored in the XMLNamespaces 
of this XMLToken.
Returns the number of namespaces in this list.


=item XMLToken::getNamespacePrefix

Look up the prefix of an XML namespace declaration by position.
Callers should use getNamespacesLength() to find out how many 
namespaces are stored in the XMLNamespaces.
@param index an integer, position of the required prefix.
Returns the prefix of an XML namespace declaration in the XMLNamespaces 
(by position).  
@note If index is out of range, an empty string will be
returned.

@see getNamespacesLength()


=item XMLToken::getNamespacePrefix

Look up the prefix of an XML namespace declaration by its URI.
@param uri a string, the URI of the prefix being sought
Returns the prefix of an XML namespace declaration given its URI.  
@note If C<uri> does not exist, an empty string will be returned.


=item XMLToken::getNamespaceURI

Look up the URI of an XML namespace declaration by its position.
@param index an integer, position of the required URI.
Returns the URI of an XML namespace declaration in the XMLNamespaces
(by position).  
@note If C<index> is out of range, an empty string will be
returned.

@see getNamespacesLength()


=item XMLToken::getNamespaceURI

Look up the URI of an XML namespace declaration by its prefix.
@param prefix a string, the prefix of the required URI
Returns the URI of an XML namespace declaration given its prefix.  
@note If C<prefix> does not exist, an empty string will be returned.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item XMLToken::isNamespacesEmpty

Predicate returning C<true> or C<false> depending on whether 
the XMLNamespaces of this XMLToken is empty.
Returns C<true> if the XMLNamespaces of this XMLToken is empty, 
C<false> otherwise.


=item XMLToken::hasNamespaceURI

Predicate returning C<true> or C<false> depending on whether 
an XML Namespace with the given URI is contained in the XMLNamespaces of
this XMLToken.
@param uri a string, the uri for the namespace
Returns C<true> if an XML Namespace with the given URI is contained in the
XMLNamespaces of this XMLToken,  C<false> otherwise.


=item XMLToken::hasNamespacePrefix

Predicate returning C<true> or C<false> depending on whether 
an XML Namespace with the given prefix is contained in the XMLNamespaces of
this XMLToken.
@param prefix a string, the prefix for the namespace
Returns C<true> if an XML Namespace with the given URI is contained in the
XMLNamespaces of this XMLToken, C<false> otherwise.


=item XMLToken::hasNamespaceNS

Predicate returning C<true> or C<false> depending on whether 
an XML Namespace with the given uri/prefix pair is contained in the 
XMLNamespaces ofthis XMLToken.
@param uri a string, the uri for the namespace
@param prefix a string, the prefix for the namespace
Returns C<true> if an XML Namespace with the given uri/prefix pair is 
contained in the XMLNamespaces of this XMLToken,  C<false> otherwise.


=item XMLToken::setTriple

Sets the XMLTripe (name, uri and prefix) of this XML element.
Nothing will be done if this XML element is a text node.
@param triple XMLTriple to be added to this XML element.


=item XMLToken::getName

Returns the (unqualified) name of this XML element.
Returns the (unqualified) name of this XML element.


=item XMLToken::getPrefix

Returns the namespace prefix of this XML element.
Returns the namespace prefix of this XML element.  
@note If no prefix
exists, an empty string will be return.


=item XMLToken::getURI

Returns the namespace URI of this XML element.
Returns the namespace URI of this XML element.


=item XMLToken::getCharacters

Returns the text of this element.
Returns the characters of this XML text.


=item XMLToken::append

Appends characters to this XML text content.
@param chars string, characters to append


=item XMLToken::getColumn

Returns the column at which this XMLToken occurred in the input
document or data stream.
Returns the column at which this XMLToken occurred.


=item XMLToken::getLine

Returns the line at which this XMLToken occurred in the input document
or data stream.
Returns the line at which this XMLToken occurred.


=item XMLToken::isElement

Predicate returning C<true> or C<false> depending on whether 
this XMLToken is an XML element.
Returns C<true> if this XMLToken is an XML element, C<false> otherwise.


=item XMLToken::isEnd

Predicate returning C<true> or C<false> depending on whether 
this XMLToken is an XML end element.
Returns C<true> if this XMLToken is an XML end element, C<false> otherwise.


=item XMLToken::isEndFor

Predicate returning C<true> or C<false> depending on whether 
this XMLToken is an XML end element for the given start element.
@param element XMLToken, element for which query is made.
Returns C<true> if this XMLToken is an XML end element for the given
XMLToken start element, C<false> otherwise.


=item XMLToken::isEOF

Predicate returning C<true> or C<false> depending on whether 
this XMLToken is an end of file marker.
Returns C<true> if this XMLToken is an end of file (input) marker, C<false>
otherwise.



=item XMLToken::isStart

Predicate returning C<true> or C<false> depending on whether 
this XMLToken is an XML start element.
Returns C<true> if this XMLToken is an XML start element, C<false> otherwise.


=item XMLToken::isText

Predicate returning C<true> or C<false> depending on whether 
this XMLToken is an XML text element.
Returns C<true> if this XMLToken is an XML text element, C<false> otherwise.


=item XMLToken::setEnd

Declares this XML start element is also an end element.


=item XMLToken::setEOF

Declares this XMLToken is an end-of-file (input) marker.


=item XMLToken::unsetEnd

Declares this XML start/end element is no longer an end element.


=item XMLToken::write

Writes this XMLToken to stream.
@param stream XMLOutputStream, stream to which this XMLToken
is to be written.
@deprecated libSBML internal


=item XMLToken::toString

Prints a string representation of the underlying token stream, for
debugging purposes.


=back

=head2 XMLNode

Representation of a node in an XML document tree.
Beginning with version 3.0.0, libSBML implements an XML abstraction
layer.  This layer presents a uniform XML interface to calling programs
regardless of which underlying XML parser libSBML has actually been
configured to use.  The basic data object in the XML abstraction is a
I<node>, represented by XMLNode.
An XMLNode can contain any number of children.  Each child is another
XMLNode, thereby forming a tree.  The methods XMLNode::getNumChildren()
and @if clike XMLNode::getChild() can be used to access the
tree structure starting from a given node. @endif@if java XMLNode::getChild(long n)
can be used to access the tree structure starting from a given node.
@endif

Each XMLNode is subclassed from XMLToken, and thus has the same methods
available as XMLToken.  These methods include XMLToken::getNamespaces(),
XMLToken::getPrefix(), XMLToken::getName(), XMLToken::getURI(), and
XMLToken::getAttributes().


=over

=item XMLNode::XMLNode

Creates a new empty XMLNode with no children.


=item XMLNode::XMLNode

Creates a new XMLNode by copying token.
@param token XMLToken to be copied to XMLNode


=item XMLNode::XMLNode

Creates a new start element XMLNode with the given set of attributes and
namespace declarations.
@param triple XMLTriple.
@param attributes XMLAttributes, the attributes to set.
@param namespaces XMLNamespaces, the namespaces to set.
@param line an unsigned int, the line number (default = 0).
@param column an unsigned int, the column number (default = 0).
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item XMLNode::XMLNode

Creates a start element XMLNode with the given set of attributes.
@param triple XMLTriple.
@param attributes XMLAttributes, the attributes to set.
@param line an unsigned int, the line number (default = 0).
@param column an unsigned int, the column number (default = 0).
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item XMLNode::XMLNode

Creates an end element XMLNode.
@param triple XMLTriple.
@param line an unsigned int, the line number (default = 0).
@param column an unsigned int, the column number (default = 0).
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item XMLNode::XMLNode

Creates a text XMLNode.
@param chars a string, the text to be added to the XMLToken
@param line an unsigned int, the line number (default = 0).
@param column an unsigned int, the column number (default = 0).
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item XMLNode::XMLNode

Creates a new XMLNode by reading XMLTokens from stream.  
The stream must be positioned on a start element
(C<stream.peek().isStart() == true>) and will be read until
the matching end element is found.
@param stream XMLInputStream from which XMLNode is to be created.
@deprecated libSBML internal


=item XMLNode::XMLNode

Copy constructor; creates a copy of this XMLNode.
@param orig the XMLNode instance to copy.


=item XMLNode::clone

Creates and returns a deep copy of this XMLNode.
Returns a (deep) copy of this XMLNode.


=item XMLNode::addChild

Adds a copy of C<node> as a child of this XMLNode.
The given C<node> is added at the end of the list of children.
@param node the XMLNode to be added as child.


=item XMLNode::insertChild

Inserts a copy of the given node as the C<n>th child of this
XMLNode.

If the given index C<n> is out of range for this XMLNode instance,
the C<node> is added at the end of the list of children.  Even in
that situation, this method does not throw an error.
@param n an integer, the index at which the given node is inserted
@param node an XMLNode to be inserted as C<n>th child.
Returns a reference to the newly-inserted child C<node>


=item XMLNode::removeChild

Removes the C<n>th child of this XMLNode and returns the
removed node.
It is important to keep in mind that a given XMLNode may have more
than one child.  Calling this method erases all existing references to
child nodes I<after> the given position C<n>.  If the index C<n> is
greater than the number of child nodes in this XMLNode, this method
takes no action (and returns NULL).
@param n an integer, the index of the node to be removed
Returns the removed child, or NULL if C<n> is greater than the number
of children in this node
@note The caller owns the returned node and is responsible for deleting it.


=item XMLNode::removeChildren

Removes all children from this node.


=item XMLNode::getChild

Returns the C<n>th child of this XMLNode.
If the index C<n> is greater than the number of child nodes, or it is
0 or less, this method returns an empty node.
@param n the index of the node to return
Returns the  C<n>th child of this XMLNode.


=item XMLNode::getChild

Returns the  C<n>th child of this XMLNode.
If the index C<n> is greater than the number of child nodes, or it is
0 or less, this method returns an empty node.
@param n an integer, the index of the node to return
Returns the  C<n>th child of this XMLNode.


=item XMLNode::getNumChildren

Returns the number of children for this XMLNode.
Returns the number of children for this XMLNode.


=item XMLNode::write

Writes this XMLNode and its children to stream.
@param stream XMLOutputStream, stream to which this XMLNode
is to be written.
@deprecated libSBML internal


=item XMLNode::toXMLString

Returns a string representation of this XMLNode. 
Returns a string derived from this XMLNode.


=item XMLNode::convertXMLNodeToString

Returns a string representation of a given XMLNode. 
@param node the XMLNode to be represented as a string
Returns a string-form representation of C<node>


=item XMLNode::convertStringToXMLNode

Returns an XMLNode which is derived from a string containing XML
content.

The XML namespace must be defined using argument C<xmlns> if the
corresponding XML namespace attribute is not part of the string of the
first argument.
@param xmlstr string to be converted to a XML node.
@param xmlns XMLNamespaces the namespaces to set (default value is NULL).
Returns a XMLNode which is converted from string C<xmlstr>.  The
caller owns the returned XMLNode and is reponsible for deleting it.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=back

=head2 XMLTriple

Representation of a qualified XML name.
@htmlinclude libsbml-not-sbml-warning.html
A "triple" in the libSBML XML layer encapsulates the notion of qualified
name, meaning an element name or an attribute name with an optional
namespace qualifier.  An XMLTriple instance carries up to three data items:

=over



=item

The name of the attribute or element; that is, the attribute name
as it appears in an XML document or data stream;

=item

The XML namespace prefix (if any) of the attribute.  For example,
in the following fragment of XML, the namespace prefix is the string
C<mysim> and it appears on both the element
C<someelement> and the attribute C<attribA>.  When
both the element and the attribute are stored as XMLTriple objects,
their <i>prefix</i> is C<mysim>.
@verbatim
<mysim:someelement mysim:attribA="value" />
@endverbatim

=item

The XML namespace URI with which the prefix is associated.  In
XML, every namespace used must be declared and mapped to a URI.

=back


XMLTriple objects are the lowest-level data item in the XML layer
of libSBML.  Other objects such as XMLToken make use of XMLTriple
objects.


=over

=item XMLTriple::XMLTriple

Creates a new, empty XMLTriple.


=item XMLTriple::XMLTriple

Creates a new XMLTriple with the given C<name>, C<uri> and and @p
prefix.

@param name a string, name for the XMLTriple.
@param uri a string, URI of the XMLTriple.
@param prefix a string, prefix for the URI of the XMLTriple,


=item XMLTriple::XMLTriple

Creates a new XMLTriple by splitting the given C<triplet> on the
separator character C<sepchar>.
Triplet may be in one of the following formats:

=over


=item

name

=item

uri sepchar name

=item

uri sepchar name sepchar prefix

=back

@param triplet a string representing the triplet as above
@param sepchar a character, the sepchar used in the triplet
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item XMLTriple::XMLTriple

Copy constructor; creates a copy of this XMLTriple set.


=item XMLTriple::clone

Creates and returns a deep copy of this XMLTriple set.
Returns a (deep) copy of this XMLTriple set.


=item XMLTriple::getName

Returns the I<name> portion of this XMLTriple.
Returns a string, the name from this XMLTriple.


=item XMLTriple::getPrefix

Returns the I<prefix> portion of this XMLTriple.
Returns a string, the I<prefix> portion of this XMLTriple.


=item XMLTriple::getURI

Returns the I<URI> portion of this XMLTriple.
Returns URI a string, the I<prefix> portion of this XMLTriple.


=item XMLTriple::getPrefixedName

Returns the prefixed name from this XMLTriple.
Returns a string, the prefixed name from this XMLTriple.


=item XMLTriple::isEmpty

Predicate returning C<true> or C<false> depending on whether 
this XMLTriple is empty.
Returns C<true> if this XMLTriple is empty, C<false> otherwise.


=item XMLTriple::isEmpty

Predicate returning C<true> or C<false> depending on whether 
this XMLTriple is empty.
Returns C<true> if this XMLTriple is empty, C<false> otherwise.
@deprecated libSBML internal


=item XMLTriple::isEmpty

Predicate returning C<true> or C<false> depending on whether 
this XMLTriple is empty.
Returns C<true> if this XMLTriple is empty, C<false> otherwise.
@deprecated libSBML internal


=item XMLTriple::isEmpty

Predicate returning C<true> or C<false> depending on whether 
this XMLTriple is empty.
Returns C<true> if this XMLTriple is empty, C<false> otherwise.
@deprecated libSBML internal


=back

=head2 XMLInputStream

@if java @deprecated libSBML internal @endif


=over

=item XMLInputStream::XMLInputStream

Creates a new XMLInputStream.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item XMLInputStream::getEncoding

Returns the encoding of the XML stream.


=item XMLInputStream::getVersion

Returns the version of the XML stream.


=item XMLInputStream::getErrorLog

Returns an XMLErrorLog which can be used to log XML parse errors and
other validation errors (and messages).


=item XMLInputStream::isEOF

Returns true if end of file (stream) has been reached, false
otherwise.



=item XMLInputStream::isError

Returns true if a fatal error occurred while reading from this stream.


=item XMLInputStream::isGood

Returns true if the stream is in a good state (i.e. isEOF() and
isError() are both false), false otherwise.


=item XMLInputStream::next

Consumes the next XMLToken and return it.
Returns the next XMLToken or EOF (XMLToken.isEOF() == true).


=item XMLInputStream::peek

Returns the next XMLToken without consuming it.  A subsequent call to
either peek() or next() will return the same token.
Returns the next XMLToken or EOF (XMLToken.isEOF() == true).


=item XMLInputStream::skipPastEnd

Consume zero or more XMLTokens up to and including the corresponding
end XML element or EOF.


=item XMLInputStream::skipText

Consume zero or more XMLTokens up to but not including the next XML
element or EOF.


=item XMLInputStream::setErrorLog

Sets the XMLErrorLog this stream will use to log errors.


=item XMLInputStream::toString

Prints a string representation of the underlying token stream, for
debugging purposes.


=item XMLInputStream::XMLInputStream

Unitialized XMLInputStreams may only be created by subclasses.
@deprecated libSBML internal


=item XMLInputStream::queueToken

Runs mParser until mTokenizer is ready to deliver at least one
XMLToken or a fatal error occurs.
@deprecated libSBML internal


=item XMLInputStream::queueToken

Runs mParser until mTokenizer is ready to deliver at least one
XMLToken or a fatal error occurs.
@deprecated libSBML internal


=item XMLInputStream::queueToken

Runs mParser until mTokenizer is ready to deliver at least one
XMLToken or a fatal error occurs.
@deprecated libSBML internal


=item XMLInputStream::queueToken

Runs mParser until mTokenizer is ready to deliver at least one
XMLToken or a fatal error occurs.
@deprecated libSBML internal


=item XMLInputStream::queueToken

Runs mParser until mTokenizer is ready to deliver at least one
XMLToken or a fatal error occurs.
@deprecated libSBML internal


=back

=head2 XMLOutputStream

@if java @deprecated libSBML internal @endif


=over

=item XMLOutputStream::XMLOutputStream

Creates a new XMLOutputStream that wraps stream.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item XMLOutputStream::endElement

Writes the given XML end element name to this XMLOutputStream.


=item XMLOutputStream::endElement

Writes the given XML end element 'prefix:name' to this
XMLOutputStream.



=item XMLOutputStream::setAutoIndent

Turns automatic indentation on or off for this XMLOutputStream.


=item XMLOutputStream::startElement

Writes the given XML start element name to this XMLOutputStream.


=item XMLOutputStream::startElement

Writes the given XML start element 'prefix:name' to this
XMLOutputStream.



=item XMLOutputStream::startEndElement

Writes the given XML start and end element name to this XMLOutputStream.


=item XMLOutputStream::startEndElement

Writes the given XML start and end element 'prefix:name' to this
XMLOutputStream.



=item XMLOutputStream::writeAttribute

Writes the given attribute, name="value" to this XMLOutputStream.


=item XMLOutputStream::writeAttribute

Writes the given attribute, prefix:name="value" to this
XMLOutputStream.



=item XMLOutputStream::writeAttribute

Writes the given attribute, name="true" or name="false" to this
XMLOutputStream.



=item XMLOutputStream::writeAttribute

Writes the given attribute, prefix:name="true" or prefix:name="false"
to this XMLOutputStream.


=item XMLOutputStream::writeAttribute

Writes the given attribute, name="value" to this XMLOutputStream.


=item XMLOutputStream::writeAttribute

Writes the given attribute, prefix:name="value" to this
XMLOutputStream.



=item XMLOutputStream::writeAttribute

Writes the given attribute, name="value" to this XMLOutputStream.


=item XMLOutputStream::writeAttribute

Writes the given attribute, prefix:name="value" to this
XMLOutputStream.



=item XMLOutputStream::writeAttribute

Writes the given attribute, name="value" to this XMLOutputStream.


=item XMLOutputStream::writeAttribute

Writes the given attribute, prefix:name="value" to this
XMLOutputStream.



=item XMLOutputStream::writeAttribute

Writes the given attribute, name="value" to this XMLOutputStream.


=item XMLOutputStream::writeAttribute

Writes the given attribute, prefix:name="value" to this
XMLOutputStream.



=item XMLOutputStream::writeXMLDecl

Writes the XML declaration:
<?xml version="1.0" encoding="..."?>


=item XMLOutputStream::writeComment

Writes an XML comment:
<?xml version="1.0" encoding="..."?>


=item XMLOutputStream::downIndent

Decreases the indentation level for this XMLOutputStream.


=item XMLOutputStream::upIndent

Increases the indentation level for this XMLOutputStream.


=item XMLOutputStream::getStringStream

Increases the indentation level for this XMLOutputStream.
@deprecated libSBML internal


=item XMLOutputStream::XMLOutputStream

Unitialized XMLOutputStreams may only be created by subclasses.
@deprecated libSBML internal


=item XMLOutputStream::writeChars

Outputs the given characters to the underlying stream.
@deprecated libSBML internal


=item XMLOutputStream::writeIndent

Outputs indentation whitespace.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.

@deprecated libSBML internal


=item XMLOutputStream::writeName

Outputs name.
@deprecated libSBML internal


=item XMLOutputStream::writeName

Outputs prefix:name.
@deprecated libSBML internal


=item XMLOutputStream::writeValue

Outputs value in quotes.
@deprecated libSBML internal


=item XMLOutputStream::writeValue

Outputs "true" or "false" in quotes.
@deprecated libSBML internal


=item XMLOutputStream::writeValue

Outputs the double value in quotes, or "INF", "-INF", or "NaN".
@deprecated libSBML internal


=item XMLOutputStream::writeValue

Outputs the long value in quotes.
@deprecated libSBML internal


=item XMLOutputStream::writeValue

Outputs the int value in quotes.
@deprecated libSBML internal


=item XMLOutputStream::writeValue

Outputs the int value in quotes.
@deprecated libSBML internal


=item XMLOutputStream::writeValue

Outputs the int value in quotes.
@deprecated libSBML internal


=item XMLOutputStream::writeValue

Outputs the int value in quotes.
@deprecated libSBML internal


=item XMLOutputStream::writeValue

Outputs the int value in quotes.
@deprecated libSBML internal


=item XMLOutputStream::writeValue

Outputs the int value in quotes.
@deprecated libSBML internal


=item XMLOutputStream::writeValue

Outputs the int value in quotes.
@deprecated libSBML internal


=item XMLOutputStream::writeValue

Outputs the int value in quotes.
@deprecated libSBML internal


=item XMLOutputStream::writeValue

Outputs the int value in quotes.
@deprecated libSBML internal


=item XMLOutputStream::writeValue

Outputs the int value in quotes.
@deprecated libSBML internal


=item XMLOutputStream::setStringStream

Outputs the int value in quotes.
@deprecated libSBML internal


=item XMLOutputStream::unsetStringStream

Outputs the int value in quotes.
@deprecated libSBML internal


=item XMLOutputStringStream::XMLOutputStringStream

Creates a new XMLOutputStream that wraps stream.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.

@deprecated libSBML internal


=item XMLOutputStringStream::getString

Creates a new XMLOutputStream that wraps stream.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.

@deprecated libSBML internal


=item XMLOutputStringStream::getString

Creates a new XMLOutputStream that wraps stream.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.

@deprecated libSBML internal


=item XMLOutputFileStream::XMLOutputFileStream

Creates a new XMLOutputStream that wraps stream.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.

@deprecated libSBML internal


=back

=head2 XMLError

Representation of errors, warnings and other diagnostics
@htmlinclude libsbml-not-sbml-warning.html
LibSBML can be configured to use any of a number of XML parsers; at the
time of this writing, libSBML supports Xerces versions 2.4 through 3.0,
Expat version 1.95.x and higher, and libxml2 version 2.6.16 and higher.
These parsers each report different status codes for the various
exceptions that can occur during XML processing.  The XMLError object
class abstracts away from the particular diagnostics reported by the
different parsers and presents a single uniform interface and set of
status codes, along with operations for manipulating the error objects.
When the libSBML XML parser layer encounters an error in the XML content
being processed, or when there is something else wrong (such as an
out-of-memory condition), the problems are reported as XMLError objects.
Each XMLError object instance has an identification number that
identifies the nature of the problem.
@if clike This error identifier will be up to five digits 
long and drawn from the enumeration <a class="el"
href="#XMLErrorCode_t">XMLErrorCode_t</a>.  Applications can use the
error identifiers as a means of recognizing the error encountered and
changing their behavior if desired. @endif@if java This
error identifier is one of the constants listed in the next section below.
Applications can use the error identifiers as a means of recognizing the
error encountered and changing their behavior if desired.  @endif
Integer error codes are useful for software, but not so much for telling
humans what happened.  For this reason, XMLError also provides two text
messages describing the nature of the error.  These messages are
accessible by means of the methods XMLError::getShortMessage() and
XMLError::getMessage().  The method XMLError::getShortMessage() returns
a very brief synopsis of the warning or error condition, whereas
XMLError::getMessage() returns a longer explanation.  These text strings
are suitable for displaying to human users.
Each XMLError object also contains a category code; its value may be
retrieved using the method XMLError::getCategory().  Category values
are @if clike drawn from the enumeration
<a class="el" href="#XMLErrorCategory_t">XMLErrorCategory_t</a> 
described below.  Categories are used by libSBML to provide more
information to calling programs about the nature of a given
error. @endif@if java drawn from a set of constants whose
names begin with the characters C<LIBSBML_CAT_>.  The list of possible
codes is described in a separate section below. Categories are used by
libSBML to provide more information to calling programs about the nature
of a given error.  @endif
In addition to category codes, each XMLError object also has a severity
code; its value may be retrieved using the method
XMLError::getSeverity().  Severity code values are 
@if clike drawn from the enumeration 
<a class="el" href="#XMLErrorSeverity_t">XMLErrorSeverity_t</a> described
in a separate section below.  Severity levels range from informational
(C<LIBSBML_SEV_INFO>) to fatal errors (C<LIBSBML_SEV_FATAL>).
@endif@if java drawn from a
set of constants whose names begin with the characters C<LIBSBML_SEV_>.
The list of possible severity codes is described in a separate section
below.  Severity levels range from informational (C<LIBSBML_SEV_INFO>)
to fatal errors (C<LIBSBML_SEV_FATAL>). @endif
Finally, XMLError objects record the line and column near where the
problem occurred in the XML content.  The values can be retrieved using
the methods XMLError::getLine() and XMLError::getColumn().  We say "near
where the problem occurred", because many factors affect how accurate
the line/column information ultimately is.  For example, different XML
parsers have different conventions for which line and column number they
report for a particular problem (which in turn makes a difference when a
problem involves an opening XML tag on one line and a closing tag on
another line).  In some situations, some parsers report invalid line
and/or column numbers altogether.  If this occurs, libSBML sets the line
and/or column number in the XMLError object to the the value of the
maximum unsigned long integer representable on the platform where
libSBML is running.  (This is equal to the constant named
C<ULONG_MAX> in C and C++.)  The probability that a true line
or column number in an SBML model would equal this value is vanishingly
small; thus, if an application encounters these values in an XMLError
object, it can assume no valid line/column number could be provided by
libSBML in that situation.
@if clike
<h3><a class="anchor" name="XMLErrorCode_t">XMLErrorCode_t</a></h3>
This is an enumeration of all the error and warning codes returned by
the XML layer in libSBML.  Each code is an integer with a 4-digit value
less than 10000.  The following table lists each possible value and a
brief description of its meaning.
@endif@if java <h3><a class="anchor" 
name="XMLErrorCode_t">Error codes associated with XMLError objects</a></h3>
The error and warning codes returned by the XML layer in libSBML are
listed in the table below.  In the libSBML Java language interface,
these error identifiers are currently (in libSBML 3.3.x) implemented as
static integer constants defined in the interface class <code><a
href="libsbmlConstants.html">libsbmlConstants</a></code>.  This is admittedly
not an ideal approach from the standpoint of modern Java programming,
but it was necessary to work around the lack of enumerations in Java
prior to JDK 1.5.  Future versions of libSBML may use a proper Java
enumeration type to define the error identifiers. @endif
<center>
<table cellspacing="1" cellpadding="1" border="0" class="text-table width80 normal-font alt-row-colors">
<caption>Possible XMLError error codes.  Depending on the programming
language in use, the <em>Enumerator</em> values will be defined either
as a value from the enumeration XMLErrorCode_t or as integer constants.
To make this table more compact, we have shortened the identifiers for
the category and severity codes to their essential parts.  To get the
actual names of the constants, prepend C<LIBSBML_CAT_> to the
category names and C<LIBSBML_SEV_> to the severity names
shown in the two right-hand columns below.
</caption>
<tr style="background: lightgray" class="normal-font">
<th>Enumerator</th>
<th>Meaning</th>
<th width="90">Category</th>
<th width="90">Severity</th>
</tr>
<tr><td>C<XMLUnknownError></td><td>Unrecognized error encountered internally</td><td>INTERNAL</td><td>FATAL</td></tr>
<tr><td>C<XMLOutOfMemory></td> <td>Out of memory</td><td>SYSTEM</td><td>FATAL</td></tr>
<tr><td>C<XMLFileUnreadable></td> <td>File unreadable</td><td>SYSTEM</td><td>ERROR</td></tr>
<tr><td>C<XMLFileUnwritable></td> <td>File unwritable</td><td>SYSTEM</td><td>ERROR</td></tr>
<tr><td>C<XMLFileOperationError></td><td>Error encountered while attempting file operation</td><td>SYSTEM</td><td>ERROR</td></tr>
<tr><td>C<XMLNetworkAccessError></td><td>Network access error</td><td>SYSTEM</td><td>ERROR</td></tr>
<tr><td>C<InternalXMLParserError></td><td>Internal XML parser state error</td><td>INTERNAL</td><td>FATAL</td></tr>
<tr><td>C<UnrecognizedXMLParserCode></td><td>XML parser returned an unrecognized error code</td><td>INTERNAL</td><td>FATAL</td></tr>
<tr><td>C<XMLTranscoderError></td><td>Character transcoder error</td><td>INTERNAL</td><td>FATAL</td></tr>
<tr><td>C<MissingXMLDecl></td><td>Missing XML declaration at beginning of XML input</td><td>XML</td><td>ERROR</td></tr>
<tr><td>C<MissingXMLEncoding></td><td>Missing encoding attribute in XML declaration</td><td>XML</td><td>ERROR</td></tr>
<tr><td>C<BadXMLDecl></td><td>Invalid or unrecognized XML declaration or XML encoding</td><td>XML</td><td>ERROR</td></tr>
<tr><td>C<BadXMLDOCTYPE></td><td>Invalid, malformed or unrecognized XML DOCTYPE declaration</td><td>XML</td><td>ERROR</td></tr>
<tr><td>C<InvalidCharInXML></td><td>Invalid character in XML content</td><td>XML</td><td>ERROR</td></tr>
<tr><td>C<BadlyFormedXML></td><td>XML content is not well-formed</td><td>XML</td><td>ERROR</td></tr>
<tr><td>C<UnclosedXMLToken></td><td>Unclosed XML token</td><td>XML</td><td>ERROR</td></tr>
<tr><td>C<InvalidXMLConstruct></td><td>XML construct is invalid or not permitted</td><td>XML</td><td>ERROR</td></tr>
<tr><td>C<XMLTagMismatch></td><td>Element tag mismatch or missing tag</td><td>XML</td><td>ERROR</td></tr>
<tr><td>C<DuplicateXMLAttribute></td><td>Duplicate XML attribute</td><td>XML</td><td>ERROR</td></tr>
<tr><td>C<UndefinedXMLEntity></td><td>Undefined XML entity</td><td>XML</td><td>ERROR</td></tr>
<tr><td>C<BadProcessingInstruction></td><td>Invalid, malformed or unrecognized XML processing instruction</td><td>XML</td><td>ERROR</td></tr>
<tr><td>C<BadXMLPrefix></td><td>Invalid or undefined XML namespace prefix</td><td>XML</td><td>ERROR</td></tr>
<tr><td>C<BadXMLPrefixValue></td><td>Invalid XML namespace prefix value</td><td>XML</td><td>ERROR</td></tr>
<tr><td>C<MissingXMLRequiredAttribute></td><td>Missing a required XML attribute</td><td>XML</td><td>ERROR</td></tr>
<tr><td>C<XMLAttributeTypeMismatch></td><td>Data type mismatch for the value of an attribute</td><td>XML</td><td>ERROR</td></tr>
<tr><td>C<XMLBadUTF8Content></td><td>Invalid UTF8 content</td><td>XML</td><td>ERROR</td></tr>
<tr><td>C<MissingXMLAttributeValue></td><td>Missing or improperly formed attribute value</td><td>XML</td><td>ERROR</td></tr>
<tr><td>C<BadXMLAttributeValue></td><td>Invalid or unrecognizable attribute value</td><td>XML</td><td>ERROR</td></tr>
<tr><td>C<BadXMLAttribute></td><td>Invalid, unrecognized or malformed attribute</td><td>XML</td><td>ERROR</td></tr>
<tr><td>C<UnrecognizedXMLElement></td><td>Element either not recognized or not permitted</td><td>XML</td><td>ERROR</td></tr>
<tr><td>C<BadXMLComment></td><td>Badly formed XML comment</td><td>XML</td><td>ERROR</td></tr>
<tr><td>C<BadXMLDeclLocation></td><td>XML declaration not permitted in this location</td><td>XML</td><td>ERROR</td></tr>
<tr><td>C<XMLUnexpectedEOF></td><td>Reached end of input unexpectedly</td><td>XML</td><td>ERROR</td></tr>
<tr><td>C<BadXMLIDValue></td><td>Value is invalid for XML ID, or has already been used</td><td>XML</td><td>ERROR</td></tr>
<tr><td>C<BadXMLIDRef></td><td>XML ID value was never declared</td><td>XML</td><td>ERROR</td></tr>
<tr><td>C<UninterpretableXMLContent></td><td>Unable to interpret content</td><td>XML</td><td>ERROR</td></tr>
<tr><td>C<BadXMLDocumentStructure></td><td>Bad XML document structure</td><td>XML</td><td>ERROR</td></tr>
<tr><td>C<InvalidAfterXMLContent></td><td>Encountered invalid content after expected content</td><td>XML</td><td>ERROR</td></tr>
<tr><td>C<XMLExpectedQuotedString></td><td>Expected to find a quoted string</td><td>XML</td><td>ERROR</td></tr>
<tr><td>C<XMLEmptyValueNotPermitted></td><td>An empty value is not permitted in this context</td><td>XML</td><td>ERROR</td></tr>
<tr><td>C<XMLBadNumber></td><td>Invalid or unrecognized number</td><td>XML</td><td>ERROR</td></tr>
<tr><td>C<XMLBadColon></td><td>Colon characters are invalid in this context</td><td>XML</td><td>ERROR</td></tr>
<tr><td>C<MissingXMLElements></td><td>One or more expected elements are missing</td><td>XML</td><td>ERROR</td></tr>
<tr><td>C<XMLContentEmpty></td><td>Main XML content is empty</td><td>XML</td><td>ERROR</td></tr>
</table>
</center>
@if clike
<h3><a class="anchor" name="XMLErrorCategory_t">XMLErrorCategory_t</a></h3>
As discussed above, each XMLError object contains a value for a category
identifier, describing the type of issue that the XMLError object
represents.  The category can be retrieved from an XMLError object using
the method XMLError::getCategory().  The value is chosen from the
enumeration of category codes XMLErrorCategory_t.  The following table
lists each possible value and a brief description of its meaning.
@endif@if java <h3><a class="anchor"
name="XMLErrorCategory_t">Category codes associated with XMLError objects</a></h3>
As discussed above, each XMLError object contains a value for a category
identifier, describing the type of issue that the XMLError object represents.
The category can be retrieved from an XMLError object using the method
XMLError::getCategory(). The following table lists each possible value
and a brief description of its meaning.
As is the case with the error codes, in the libSBML Java language
interface, the category identifiers are currently implemented as static
integer constants defined in the interface class
C<libsbmlConstants> in the file "<a
href="libsbmlConstants.html">libsbmlConstants.java</a>".
@endif
<center>
<table width="90%" cellspacing="1" cellpadding="1" border="0" class="text-table width80 normal-font alt-row-colors">
<tr style="background: lightgray" class="normal-font">
<th>Enumerator</th>
<th>Meaning</th>
</tr>
<tr><td><em>LIBSBML_CAT_INTERNAL</em></td><td>A problem involving the libSBML
software itself or the underlying XML parser.  This almost certainly
indicates a software defect (i.e., bug) in libSBML.  Please report
instances of this to the libSBML developers.</td></tr>
<tr><td><em>LIBSBML_CAT_SYSTEM</em></td><td>A problem reported by the operating
system, such as an inability to read or write a file.  This indicates
something that is not a program error but is outside of the control of
libSBML.</td></tr>
<tr><td><em>LIBSBML_CAT_XML</em></td><td>A problem in the XML content itself.  This
usually arises from malformed XML or the use of
constructs not permitted in SBML.</td></tr>
</table>
</center>
@if clike
<h3><a class="anchor" name="XMLErrorSeverity_t">XMLErrorSeverity_t</a></h3>
As described above, each XMLError object contains a value for a severity
code, describing how critical is the issue that the XMLError object
represents.  The severity can be retrieved from an XMLError object using
the method XMLError::getSeverity().  The value is chosen from the
enumeration of category codes XMLErrorSeverity_t.  The following table
lists each possible value and a brief description of its meaning.
@endif@if java <h3><a class="anchor"
name="XMLErrorSeverity_t">Severity codes associated with XMLError objects</a></h3>
As described above, each XMLError object contains a value for a severity
code, describing how severe is the issue that the XMLError object
represents.  The severity be retrieved from an XMLError object using the
method XMLError::getSeverity(). The following table lists each possible
value and a brief description of its meaning.
As is the case with the category codes, in the libSBML Java language
interface, these severity codes are currently (in libSBML 3.3.x)
implemented as static integer constants defined in the interface class
C<libsbmlConstants> in the file "libsbmlConstants.java".  This
is admittedly not an ideal approach from the standpoint of modern Java
programming, but it was necessary to work around the lack of
enumerations in Java prior to JDK 1.5.  Future versions of libSBML may
use a proper Java enumeration type to define the severity codes. @endif
<center>
<table width="90%" cellspacing="1" cellpadding="1" border="0" class="text-table width80 normal-font alt-row-colors">
<tr style="background: lightgray" class="normal-font">
<th>Enumerator</th>
<th>Meaning</th>
</tr>
<tr><td><em>LIBSBML_SEV_INFO</em></td><td>The error is actually informational and
not necessarily a serious problem.</td></tr>
<tr><td><em>LIBSBML_SEV_WARNING</em></td><td>The error object represents a problem
that is not serious enough to necessarily stop the problem, but
applications should take note of the problem and evaluate what its
implications may be.</td></tr>
<tr><td><em>LIBSBML_SEV_ERROR</em></td><td>The error object represents a serious
error.  The application may continue running but it is unlikely to be
able to continue processing the same XML file or data stream.</td></tr>
<tr><td><em>LIBSBML_SEV_FATAL</em></td><td>A serious error occurred, such as an
out-of-memory condition, and the software should terminate
immediately.</td></tr>
</table>
</center>


=over

=item XMLError::XMLError

Creates a new XMLError to report that something occurred during XML
processing.

XMLError objects have identification numbers to indicate the nature of
the exception.  @if clike These numbers are drawn from
the enumeration <a class="el"
href="#XMLErrorCode_t">XMLErrorCode_t</a>.
@endif@if java These numbers are defined as unsigned 
integer constants in the file
"libsbmlConstants.java".  See the <a class="el"
href="#XMLErrorCode_t">top of this documentation</a> for a table
listing the possible values and their meanings. @endif The argument @p
errorId to this constructor I<can> be (but does not have to be) a
value from this @if clike enumeration. If it is a value
from <a class="el" href="#XMLErrorCode_t">XMLErrorCode_t</a>, the
XMLError class assumes the error is a low-level system or XML layer
error and <em>prepends</em> a built-in, predefined error message to
any string passed in the argument C<details> to this constructor.  In
addition, all <a class="el" href="#XMLErrorCode_t">XMLErrorCode_t</a>
errors have associated values for the C<severity> and C<category>
codes, and these fields are filled-in as well from the enumerations <a
class="el" href="#XMLErrorSeverity_t">XMLErrorSeverity_t</a> and <a
class="el" href="#XMLErrorCategory_t">XMLErrorCategory_t</a>,
respectively. @endif@if java set of constants.  If it is
one of the predefined error identifiers, the XMLError class assumes
the error is a low-level system or XML layer error and
<em>prepends</em> a built-in, predefined error message to any string
passed in the argument C<details> to this constructor.  In addition,
all the predefined error identifiers have associated values for the @p
severity and C<category> codes, and these fields are filled-in as
well. @endif
If the error identifier C<errorId> is a number greater than 9999, this
constructor assumes that the error was generated from another part of
the software, and does not do additional filling in of values beyond
the defaults in the constructor itself.  This allows XMLError to serve
as a base class for other errors (and is used in this way elsewhere in
libSBML).  Callers should fill in all the parameters with suitable
values if generating errors with codes greater than 9999 to make
maximum use of the XMLError facilities.
@if clike As mentioned above, there are two other
enumerations, <a class="el"
href="#XMLErrorSeverity_t">XMLErrorSeverity_t</a> and <a class="el"
href="#XMLErrorCategory_t">XMLErrorCategory_t</a>, used for indicating
the severity and category of error for the predefined XMLError codes.
The values passed in C<severity> and C<category> override the defaults
assigned based on the error code.  If the value of C<errorId> is a
value from <a class="el" href="#XMLErrorCode_t">XMLErrorCode_t</a>,
callers do not need to fill in C<severity> and C<category>.
Conversely, if C<errorId> is not a value from <a class="el"
href="#XMLErrorCode_t">XMLErrorCode_t</a>, callers can use other
values (not just those from <a class="el"
href="#XMLErrorSeverity_t">XMLErrorSeverity_t</a> and <a class="el"
href="#XMLErrorCategory_t">XMLErrorCategory_t</a>, but their own
special values) for C<severity> and @p
category. @endif@if java As mentioned above, 
there are additional constants defined for <a class="el"
href="#XMLErrorSeverity_t">standard severity</a> and <a class="el"
href="#XMLErrorCategory_t">standard category</a> codes, and every predefined 
error in libSBML has an associated value for severity and category taken
from these predefined sets.  These constants have symbol names
prefixed with C<LIBSBML_SEV_> and C<LIBSBML_CAT_>,
respectively.  If the value of C<errorId> is one of the standard error
codes, callers do not need to fill in C<severity> and C<category> in a
call to this constructor.  Conversely, if C<errorId> is not an existing
XML-level error code, callers can use other values for C<severity> and
C<category>. @endif
@param errorId an unsigned int, the identification number of the error.
@param details a string containing additional details about the error.
If the error code in C<errorId> is one that is recognized by XMLError,
the given message is I<appended> to a predefined message associated
with the given code.  If the error code is not recognized, the message
is stored as-is as the text of the error.
@param line an unsigned int, the line number at which the error occured.
@param column an unsigned int, the column number at which the error occured.
@param severity an integer indicating severity of the error.
@param category an integer indicating the category to which the error
belongs.

@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item XMLError::XMLError

Copy constructor; creates a copy of this XMLError.


=item XMLError::getErrorId

Returns the identifier of this error.
Returns the id of this XMLError.
@see getMessage()
@see getShortMessage()
@see getCategory()
@see getSeverity()


=item XMLError::getMessage

Returns the message text of this error.
The message associated with an error object describes the nature of
the problem.  The message returned by this method is generally longer
and clearer than the message returned by XMLError::getShortMessage(),
but not in all cases.
Callers may use XMLError::getCategory() and XMLError::getSeverity() to
obtain additional information about the nature and severity of the
problem.

Returns the message text
@see getErrorId()
@see getShortMessage()
@see getCategory()
@see getSeverity()


=item XMLError::getShortMessage

Returns a brief message for this error.
This is an alternative error message that, in general, is as short as
the authors could make it.  However, brevity is often inversely
proportional to clarity, so this short message may not be sufficiently
informative to understand the nature of the error.  Calling
applications may wish to check XMLError::getMessage() in addition or
instead.

Returns the short error message text
@see getErrorId()
@see getMessage()
@see getCategory()
@see getSeverity()


=item XMLError::getLine

Returns the line number in the XML input near where the error, warning
or other diagnostic occurred.
We say "near where the problem occurred", because many factors affect
how accurate the line/column information ultimately is.  For example,
different XML parsers have different conventions for which line and
column number they report for a particular problem (which in turn
makes a difference when a problem involves an opening XML tag on one
line and a closing tag on another line).  In some situations, some
parsers report invalid line and/or column numbers altogether.  If this
occurs, the line and/or column number in the XMLError object will be
set to the the value of the maximum unsigned long integer
representable on the platform where libSBML is running.  (This is
equal to the constant named C<ULONG_MAX> in C and C++.)  The
probability that a true line or column number in an SBML model would
equal this value is vanishingly small; thus, if an application
encounters these values in an XMLError object, it can assume no valid
line/column number could be provided by libSBML in that situation.
Returns the line number
@see getColumn()


=item XMLError::getColumn

Returns the column number in the XML input near where the error,
warning or other diagnostic occurred.
We say "near where the problem occurred", because many factors affect
how accurate the line/column information ultimately is.  For example,
different XML parsers have different conventions for which line and
column number they report for a particular problem (which in turn
makes a difference when a problem involves an opening XML tag on one
line and a closing tag on another line).  In some situations, some
parsers report invalid line and/or column numbers altogether.  If this
occurs, the line and/or column number in the XMLError object will be
set to the the value of the maximum unsigned long integer
representable on the platform where libSBML is running.  (This is
equal to the constant named C<ULONG_MAX> in C and C++.)  The
probability that a true line or column number in an SBML model would
equal this value is vanishingly small; thus, if an application
encounters these values in an XMLError object, it can assume no valid
line/column number could be provided by libSBML in that situation.
Returns the column number
@see getLine()


=item XMLError::getSeverity

Returns the severity of this error.
XMLError defines an enumeration of severity codes for the XML layer.
Applications that build on XMLError by subclassing it may add their
own severity codes with numbers higher than those in the predefined
set of severity codes.
Returns the severity of this XMLError.
@see getSeverityAsString()
@see getCategory()


=item XMLError::getSeverityAsString

Returns a string describing the severity level of this error.
XMLError defines an enumeration of severity codes for the XML layer.
Applications that build on XMLError by subclassing it may add their
own severity codes with numbers higher than those in the predefined
set of severity codes.
Returns string representing the severity of this XMLError.
@see getSeverity()
@see getCategoryAsString()


=item XMLError::getCategory

Returns the category of this error.
XMLError defines an enumeration of category codes for the XML layer.
Applications that build on XMLError by subclassing it may add their
own categories with numbers higher than those in the predefined
set of category codes.
Categories can be used to partition errors into distinct groups.
Among other things, this can be used to prevent id conflicts by
uniquely identifying an XMLError by both id and category.
Returns the category of this XMLError.
@see getSeverity()
@see getCategoryAsString()


=item XMLError::getCategoryAsString

Returns a string describing the category of this error.
XMLError defines an enumeration of category codes for the XML layer.
Applications that build on XMLError by subclassing it may add their
own categories with numbers higher than those in the predefined
set of category codes.
Categories can be used to partition errors into distinct groups.
Among other things, this can be used to prevent id conflicts by
uniquely identifying an XMLError by both id and category.
Returns string representing the category of this XMLError.
@see getCategory()
@see getSeverityAsString()


=item XMLError::isInfo

Predicate returning C<true> or C<false> depending on whether this
error object is for information purposes only.
This is equivalent to obtaining the severity code from an XMLError
object (via XMLError::getSeverity()) and then comparing it to the
value C<LIBSBML_SEV_INFO> from the
@if clike enumeration
#XMLErrorSeverity_t. @endif@if java set of predefined
severity codes.@endif
Returns C<true> if this XMLError is for informational purposes only,
C<false> otherwise.
@see isWarning()
@see isError()
@see isFatal()


=item XMLError::isWarning

Predicate returning C<true> or C<false> depending on whether 
this error object is a warning.
This is equivalent to obtaining the severity code from an XMLError
object (via XMLError::getSeverity()) and then comparing it to the
value C<LIBSBML_SEV_WARNING> from the
@if clike enumeration
#XMLErrorSeverity_t. @endif@if java set of predefined
severity codes.@endif
Returns C<true> if this error is a warning, C<false> otherwise.
@see isInfo()
@see isError()
@see isFatal()


=item XMLError::isError

Predicate returning C<true> or C<false> depending on whether this
error is a significant error.
This is equivalent to obtaining the severity code from an XMLError
object (via XMLError::getSeverity()) and then comparing it to the
value C<LIBSBML_SEV_ERROR> from the
@if clike enumeration
#XMLErrorSeverity_t. @endif@if java set of predefined
severity codes.@endif
Returns C<true> if this error is an error, C<false> otherwise.
@see isInfo()
@see isWarning()
@see isFatal()


=item XMLError::isFatal

Predicate returning C<true> or C<false> depending on whether this
error is a fatal run-time error.
This is equivalent to obtaining the severity code from an XMLError
object (via XMLError::getSeverity()) and then comparing it to the
value C<LIBSBML_SEV_FATAL> from the
@if clike enumeration
#XMLErrorSeverity_t. @endif@if java set of predefined
severity codes.@endif
Returns C<true> if this error is a fatal error, C<false> otherwise.
@see isInfo()
@see isWarning()
@see isError()


=item XMLError::isInternal

Predicate returning C<true> or C<false> depending on whether this
error resulted from an internal program error.
This is equivalent to obtaining the category identifier from an
XMLError object (via XMLError::getCategory()) and then comparing it to
the value C<LIBSBML_CAT_INTERNAL> from the
@if clike
enumeration #XMLErrorCategory_t. @endif@if java set of
predefined category codes.@endif
Returns C<true> or C<false>
@see isSystem()
@see isXML()


=item XMLError::isSystem

Predicate returning C<true> or C<false> depending on whether this
error was generated by the operating system.
This is equivalent to obtaining the category identifier from an
XMLError object (via XMLError::getCategory()) and then comparing it to
the value C<LIBSBML_CAT_SYSTEM> from the
@if clike
enumeration #XMLErrorCategory_t. @endif@if java set of
predefined category codes.@endif
Returns C<true> or C<false>
@see isInternal()
@see isXML()


=item XMLError::isXML

Predicate returning C<true> or C<false> depending on whether this
error resulted from a problem in the XML input (e.g., an XML syntax
error).

This is equivalent to obtaining the category identifier from an
XMLError object (via XMLError::getCategory()) and then comparing it to
the value C<LIBSBML_CAT_XML> from the
@if clike
enumeration #XMLErrorCategory_t. @endif@if java set of
predefined category codes.@endif
Returns C<true> or C<false>
@see isInternal()
@see isSystem()


=item XMLError::setLine

Sets the line number where this error occurred.
@param line an unsigned int, the line number to set.
@see setColunn()


=item XMLError::setColumn

Sets the column number where this error occurred.
@param column an unsigned int, the column number to set.
@see setLine()


=item XMLError::getStandardMessage

Returns a copy of the message string associated with the given
predefined XMLError code.
@param code the error code whose message is sought; it must be a
predefined value from @if clike <a class="el"
href="#XMLErrorCode_t">
XMLErrorCode_t</a>. @endif@if java <a class="el"
href="#XMLErrorCode_t">the set of predefined error identifiers.@endif


=back

=head2 XMLErrorLog

Log of errors and other events encountered while processing an XML
file or data stream.
@htmlinclude libsbml-not-sbml-warning.html
The error log is simply a list.  The XML layer of libSBML maintains an
error log associated with a given XML document or data stream.  When an
operation results in an error, or when there is something wrong with the
XML content, the problem is reported as an XMLError object stored in the
XMLErrorLog list.  Problems range from low-level issues (such as the
inability to open a file) to XML syntax errors (such as mismatched tags
or other problems).
A typical approach for using this error log is to first use
XMLErrorLog::getNumErrors() to inquire how many XMLError object instances
it contains, and then to iterate over the list of objects one at a time
using XMLErrorLog::getError(unsigned int n).
In normal circumstances, programs using libSBML will actually obtain an
SBMLErrorLog rather than an actual XMLErrorLog.  The former is
subclassed from XMLErrorLog and simply wraps commands for working with
SBMLError objects rather than the low-level XMLError objects.  Classes
such as SBMLDocument use the higher-level SBMLErrorLog.


=over

=item XMLErrorLog::getNumErrors

Returns the number of errors that have been logged.
To retrieve individual errors from the log, callers may use
XMLErrorLog::getError(unsigned int n).
Returns the number of errors that have been logged.


=item XMLErrorLog::getError

Returns the nth XMLError in this log.
Callers should first use XMLErrorLog::getNumErrors() to find out how
many errors are in the log.
@param n the index number of the error to retrieve (with 0 being the
first error)
Returns the nth XMLError in this log, or NULL if C<n> is greater than
or equal to XMLErrorLog::getNumErrors().


=item XMLErrorLog::clearLog

Removes all errors from this log.


=item XMLErrorLog::XMLErrorLog

Creates a new empty XMLErrorLog.
@deprecated libSBML internal


=item XMLErrorLog::add

Logs the given XMLError.
@param error XMLError, the error to be logged.
@deprecated libSBML internal


=item XMLErrorLog::add

Logs (copies) the XMLErrors in the given XMLError list to this
XMLErrorLog.

@param errors list, a list of XMLError to be added to the log.
@deprecated libSBML internal


=item XMLErrorLog::setParser

Sets the XMLParser associated with this XMLErrorLog.
The XMLParser will be used to obtain the current line and column
number for XMLError objects that lack line and column numbers when
they are logged.  This method is used by libSBML's internal XML
parsing code and probably has no useful reason to be called from
application programs.
@param p XMLParser, the parser to use
@deprecated libSBML internal


=item XMLErrorLog::setParser

Sets the XMLParser associated with this XMLErrorLog.
The XMLParser will be used to obtain the current line and column
number for XMLError objects that lack line and column numbers when
they are logged.  This method is used by libSBML's internal XML
parsing code and probably has no useful reason to be called from
application programs.
@param p XMLParser, the parser to use
@deprecated libSBML internal


=item XMLErrorLog::setParser

Sets the XMLParser associated with this XMLErrorLog.
The XMLParser will be used to obtain the current line and column
number for XMLError objects that lack line and column numbers when
they are logged.  This method is used by libSBML's internal XML
parsing code and probably has no useful reason to be called from
application programs.
@param p XMLParser, the parser to use
@deprecated libSBML internal


=back

=head2 XMLHandler

Class providing a unified interface to different XML parsers.
@if java @deprecated libSBML internal @endif


=over

=item XMLHandler::XMLHandler

Creates a new XMLHandler.
@deprecated libSBML internal


=item XMLHandler::startDocument

Receive notification of the beginning of the document.
By default, do nothing. Application writers may override this method
in a subclass to take specific actions at the start of the document.
@deprecated libSBML internal


=item XMLHandler::XML

Receive notification of the XML declaration, i.e.
<?xml version="1.0" encoding="UTF-8"?>
By default, do nothing. Application writers may override this method
in a subclass to take specific actions at the declaration.
@deprecated libSBML internal


=item XMLHandler::startElement

Receive notification of the start of an element.
By default, do nothing. Application writers may override this method
in a subclass to take specific actions at the start of each element.
@deprecated libSBML internal


=item XMLHandler::endDocument

Receive notification of the end of the document.
By default, do nothing. Application writers may override this method
in a subclass to take specific actions at the end of the document.
@deprecated libSBML internal


=item XMLHandler::endElement

Receive notification of the end of an element.
By default, do nothing. Application writers may override this method
in a subclass to take specific actions at the end of each element.
@deprecated libSBML internal


=item XMLHandler::characters

Receive notification of character data inside an element.
By default, do nothing. Application writers may override this method
to take specific actions for each chunk of character data.
@deprecated libSBML internal


=back

=head2 XMLParser

Class providing a unified interface to different XML parsers.
@if java @deprecated libSBML internal @endif


=over

=item XMLParser::create

Creates a new XMLParser.  The parser will notify the given XMLHandler
of parse events and errors.
The library parameter indicates the underlying XML library to use if
the XML compatibility layer has been linked against multiple XML
libraries.  It may be one of: "expat" (default), "libxml", or
"xerces".

If the XML compatibility layer has been linked against only a single
XML library, the library parameter is ignored.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item XMLParser::parse

Parses XML content in one fell swoop.
If isFile is true (default), content is treated as a filename from
which to read the XML content.  Otherwise, content is treated as a
null-terminated buffer containing XML data and is read directly.
Returns true if the parse was successful, false otherwise.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item XMLParser::parseFirst

Begins a progressive parse of XML content.  This parses the first
chunk of the XML content and returns.  Successive chunks are parsed by
calling parseNext().
A chunk differs slightly depending on the underlying XML parser.  For
Xerces and libXML chunks correspond to XML elements.  For Expat, a
chunk is the size of its internal buffer.
If isFile is true (default), content is treated as a filename from
which to read the XML content.  Otherwise, content is treated as a
null-terminated buffer containing XML data and is read directly.
Returns true if the first step of the progressive parse was
successful, false otherwise.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item XMLParser::parseNext

Parses the next chunk of XML content.
Returns true if the next step of the progressive parse was successful,
false otherwise or when at EOF.


=item XMLParser::parseReset

Resets the progressive parser.  Call between the last call to
parseNext() and the next call to parseFirst().


=item XMLParser::getColumn

Returns the current column position of the parser.


=item XMLParser::getLine

Returns the current line position of the parser.


=item XMLParser::getErrorLog

Returns an XMLErrorLog which can be used to log XML parse errors and
other validation errors (and messages).


=item XMLParser::setErrorLog

Sets the XMLErrorLog this parser will use to log errors.


=item XMLParser::XMLParser

Creates a new XMLParser.  The parser will notify the given XMLHandler
of parse events and errors.
Only subclasses may call this constructor directly.  Everyone else
should use XMLParser::create().
@deprecated libSBML internal


=item XMLParser::XMLParser

Creates a new XMLParser.  The parser will notify the given XMLHandler
of parse events and errors.
Only subclasses may call this constructor directly.  Everyone else
should use XMLParser::create().
@deprecated libSBML internal


=back

=head2 XMLTokenizer

Class implementing methods for turning XML into tokens.
@if java @deprecated libSBML internal @endif


=over

=item XMLTokenizer::XMLTokenizer

Creates a new XMLTokenizer.
@deprecated libSBML internal


=item XMLTokenizer::getEncoding

Returns the encoding of the underlying XML document.
@deprecated libSBML internal


=item XMLTokenizer::getVersion

Returns the xml version of the underlying XML document.
@deprecated libSBML internal


=item XMLTokenizer::hasNext

Returns true if this XMLTokenizer has at least one XMLToken ready to
deliver, false otherwise.
Note that hasNext() == false does not imply isEOF() == true.  The
XMLTokenizer may simply be waiting for the XMLParser to parse more of
the document.
@deprecated libSBML internal


=item XMLTokenizer::isEOF

Returns true if the end of the XML file (document) has been reached
and there are no more tokens to consume, false otherwise.
@deprecated libSBML internal


=item XMLTokenizer::next

Consume the next XMLToken and return it.
Returns the next XMLToken.
@deprecated libSBML internal


=item XMLTokenizer::peek

Returns the next XMLToken without consuming it.  A subsequent call to
either peek() or next() will return the same token.
Returns the next XMLToken.
@deprecated libSBML internal


=item XMLTokenizer::toString

Prints a string representation of the underlying token stream, for
debugging purposes.
@deprecated libSBML internal


=item XMLTokenizer::XML

Receive notification of the XML declaration, i.e.
<?xml version="1.0" encoding="UTF-8"?>
@deprecated libSBML internal


=item XMLTokenizer::startElement

Receive notification of the start of an element.
@deprecated libSBML internal


=item XMLTokenizer::endDocument

Receive notification of the end of the document.
@deprecated libSBML internal


=item XMLTokenizer::endElement

Receive notification of the end of an element.
@deprecated libSBML internal


=item XMLTokenizer::characters

Receive notification of character data inside an element.
@deprecated libSBML internal


=item XMLTokenizer::characters

Receive notification of character data inside an element.
@deprecated libSBML internal


=item XMLTokenizer::characters

Receive notification of character data inside an element.
@deprecated libSBML internal


=item XMLTokenizer::characters

Receive notification of character data inside an element.
@deprecated libSBML internal


=item XMLTokenizer::characters

Receive notification of character data inside an element.
@deprecated libSBML internal


=item XMLTokenizer::characters

Receive notification of character data inside an element.
@deprecated libSBML internal


=item XMLTokenizer::characters

Receive notification of character data inside an element.
@deprecated libSBML internal


=item XMLTokenizer::characters

Receive notification of character data inside an element.
@deprecated libSBML internal


=back

=head2 SBMLErrorLog

Log of errors and other events encountered during SBML processing.
@htmlinclude libsbml-not-sbml-warning.html
The error log is simply a list.  Each SBMLDocument maintains its own
SBMLErrorLog.  When a libSBML operation on SBML content results in an
error, or when there is something worth noting about the SBML content, 
the issue is reported as an SBMLError object stored in the SBMLErrorLog
list.

SBMLErrorLog is derived from XMLErrorLog, an object class that serves
exactly the same purpose but for the XML parsing layer.  XMLErrorLog
provides crucial methods such as SBMLErrorLog::getNumErrors() for
determining how many SBMLError or XMLError objects are in the log.
SBMLErrorLog inherits these methods.
The general approach to working with SBMLErrorLog in user programs
involves first obtaining a pointer to a log from a libSBML object such
as SBMLDocument.  Callers should then use SBMLErrorLog::getNumErrors()
to inquire how many objects there are in the list.  (The answer may be
0.)  If there is at least one SBMLError object in the SBMLErrorLog
instance, callers can then iterate over the list using 
@if clike SBMLErrorLog::getError(), using methods on SBMLError
to find out the error code and associated information such as the error
severity, the message, and the line number in the
input. @endif@if java SBMLErrorLog::getError(long n), using
methods on SBMLError  to find out the error code and associated
information such as the error severity, the message, and the line number
in the input. 
@endif

If you wish to simply print the error strings for a human to read, an
easier and more direct way might be to use SBMLDocument::printErrors().


=over

=item SBMLErrorLog::getError

Returns the nth SBMLError in this log.
Callers should first inquire about the number of items in the log by
using the SBMLErrorLog::getNumErrors() method.  (This method is
inherited from the parent class, XMLErrorLog).  Attempting to using an
error index number that exceed the number of errors in the log will
result in a NULL being returned.
@param n unsigned int number of the error to retrieve.
Returns the C<n>th SBMLError in this log.


=item SBMLErrorLog::getNumFailsWithSeverity

Returns the number of errors that have been logged with the given
severity code.
LibSBML associates severity levels with every SBMLError object to
provide an indication of how serious the problem is.  Severities range
from informational diagnostics to fatal (irrecoverable) errors.  Given
an SBMLError object instance, a caller can interrogate it for its
severity level using methods such as SBMLError::getSeverity(),
SBMLError::isFatal(), and so on.  The present method encapsulates
iteration and interrogation of all objects in an SBMLErrorLog, making
it easy to check for the presence of error objects with specific
severity levels.
@if clike @param severity a value from
#SBMLErrorSeverity_t @endif@if java @param severity a
value from the set of C<LIBSBML_SEV_> constants defined by
the interface class <code><a
href="libsbmlConstants.html">libsbmlConstants</a></code> @endif


=item SBMLErrorLog::SBMLErrorLog

Creates a new, empty SBMLErrorLog.
@deprecated libSBML internal


=item SBMLErrorLog::logError

Convenience function that combines creating an SBMLError object and
adding it to the log.
@param errorId an unsigned int, the identification number of the error.
@param details a string containing additional details about the error.
If the error code in C<errorId> is one that is recognized by SBMLError,
the given message is I<appended> to a predefined message associated
with the given code.  If the error code is not recognized, the message
is stored as-is as the text of the error.
@param line an unsigned int, the line number at which the error occured.
@param column an unsigned int, the column number at which the error occured.
@param severity an integer indicating severity of the error.
@param category an integer indicating the category to which the error
belongs.

@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.

@deprecated libSBML internal


=item SBMLErrorLog::add

Adds the given SBMLError to the log.
@param error SBMLError, the error to be logged.
@deprecated libSBML internal


=item SBMLErrorLog::add

Adds (copies) the SBMLErrors in the given SBMLError list to this
SBMLErrorLog.

@param errors list, a list of SBMLError to be added to the log.
@deprecated libSBML internal


=item SBMLErrorLog::remove

Removes an error having errorId from the SBMLError list.
Only the first item will be removed if there are multiple errors
with the given errorId.
@param errorId the error identifier of the error to be removed.
@deprecated libSBML internal


=back

=head2 SBMLError

Representation of errors, warnings and other diagnostics
@htmlinclude libsbml-not-sbml-warning.html
When a libSBML operation on SBML content results in an error, or when
there is something wrong with the SBML content, the problems are
reported as SBMLError objects.  These are generally stored in an
SBMLErrorLog object; this log object, in turn, is kept in the
SBMLDocument object containing the SBML content.  Applications can
obtain the list of logged errors using SBMLDocument::getErrorLog() and
then use the methods provided by SBMLErrorLog to access individual
SBMLError objects.  (Note that despite the word "error" in the name,
SBMLError objects are used to represent not only "true" errors, but also
warnings and some informational diagnostics.  The name is a historical
hold-over from early versions of libSBML, in which the object really was
only used to report errors.)
Each SBMLError object instance has an identification number that
identifies the nature of the problem.  This "error id" number will be up
to five digits long, @if clike and it will be listed in one
of two enumerations: <a class="el" href="#SBMLErrorCode_t">
SBMLErrorCode_t</a> (described <a class="el" href="#SBMLErrorCode_t">
below</a>) or @link XMLError::XMLErrorCode_t XMLErrorCode_t @endlink
(described in the documentation for the class XMLError).  The former
enumeration contains all the SBML validation rule numbers listed in the
appendices of the SBML specification documents, as well as some
additional libSBML-specific error codes.@endif@if java and
it will come from one of two sets of static integer constants defined in
the interface class <code><a href="libsbmlConstants.html">
libsbmlConstants</a></code>: either the SBML error identifiers <a
class="el" href="#SBMLErrorCode_t"> (described below)</a> or the XML
error identifiers (described in the documentation for the class <code><a
href="XMLError.html"> XMLError</a></code>).  The former set of constants
includes all the SBML validation rule numbers listed in the appendices
of the SBML specification documents, as well as some additional
libSBML-specific error codes.@endif
Error codes are useful mainly for software.  For human readers,
SBMLError also includes text messages that describe the nature of a
given problem.  The messages can be accessed using
SBMLError::getShortMessage() and SBMLError::getMessage().  The former
provides a brief one-line description of the issue, while
SBMLError::getMessage() provides a more detailed text, including (if
appropriate) references to sections of the SBML specifications where
relevant topics are discussed.  These text strings are suitable for
displaying to human users.
An SBMLError object also contains a category code; its value may be
retrieved using the method SBMLError::getCategory().  Category values
are @if clike drawn from the enumeration <a class="el"
href="#SBMLErrorCategory_t">SBMLErrorCategory_t</a> described below.
Categories are used to partition errors into distinct conceptual groups.
This is principally used by the libSBML validation system to group
classes of validation checks.  For example, @c
LIBSBML_CAT_IDENTIFIER_CONSISTENCY is the category for tests that check
identifier consistency; C<LIBSBML_CAT_MATHML_CONSISTENCY> is the
category for MathML consistency checking; and so
on.  @endif@if java drawn from a set of static integer
constants defined in <code><a
href="libsbmlConstants.html">libsbmlConstants</a></code>, and having
names beginning with the characters C<LIBSBML_CAT_>.  The list
of possible codes is described in a separate section below.  Categories
are used to partition errors into distinct conceptual groups.  This is
principally used by the libSBML validation system to group classes of
validation checks.  For example, C<LIBSBML_CAT_IDENTIFIER_CONSISTENCY>
is the category for tests that check identifier consistency; @c
LIBSBML_CAT_MATHML_CONSISTENCY is the category for MathML consistency
checking; and so on. @endif
In addition, SBMLError also has a severity code.  Its value may be
retrieved using the method SBMLError::getSeverity().  The possible
severity values are the same as those reported by @if clike
XMLError.  Severity levels currently range from informational (@c
LIBSBML_SEV_INFO) to fatal errors (C<LIBSBML_SEV_FATAL>).  They can be
used by an application to evaluate how serious a given problem
is. @endif@if java <code><a
href="XMLError.html">XMLError</a></code>. Severity levels currently
range from informational (C<LIBSBML_SEV_INFO>) to fatal errors (@c
LIBSBML_SEV_FATAL).  They can be used by an application to evaluate how
serious a given problem is. @endif
Finally, SBMLError records the line and column near where the problem
occurred in the SBML content.  The values may be retrieved using the
methods SBMLError::getLine() and SBMLError::getColumn().  We say "near",
because a lot of factors affect how accurate the line/column information
ultimately is.  For example, different XML parsers have different
conventions for which line and column number they report for a
particular problem (which makes a difference when a problem involves an
opening XML tag on one line and a closing tag on another line).  In some
situations, some parsers report invalid line and/or column numbers
altogether.  If this occurs, libSBML sets the line and/or column number
in the SBMLError object to the the value of the maximum unsigned long
integer representable on the platform where libSBML is running.  (This
is equal to the constant named C<ULONG_MAX> in C and C++.)
The probability that a true line or column number in an SBML model would
equal this value is vanishingly small; thus, if an application
encounters these values in an XMLError object, it can assume no valid
line/column number could be provided by libSBML in that situation.
@if clike
<h3><a class="anchor" name="SBMLErrorCode_t">SBMLErrorCode_t</a></h3>
SBMLErrorCode_t is an enumeration of all SBML-level error, warning and
informational diagnostic codes.  Every SBMLError object has an error
code value that can be either a value from this enumeration, or a value
from the @link XMLError::XMLErrorCode_t XMLErrorCode_t @endlink
enumeration (see the documentation for XMLError).  The latter values
apply when the error or warning signifies a basic XML issue rather than
an SBML issue per se.  The values of SBMLErrorCode_t are distinguished
from those of @link XMLError::XMLErrorCode_t XMLErrorCode_t @endlink by
being numbered 10000 and higher, while the XML layer's codes are 9999 and
lower.  The method SBMLError::getErrorId() returns the error code of a
given SBMLError object instance.
The following is a table of the symbolic names of SBMLErrorCode_t values
and the meaning of each code.  In this table, the right-hand columns
titled "L1V1", "L1V2", etc. refer to Levels and Versions of the SBML
specifications, and the entries in each column refer to whether the
severity of the condition in that particular Level+Version of SBML.
The codes stand for the following:
@endif@if java <h3><a class="anchor" 
name="SBMLErrorCode_t">Error codes associated with SBMLError objects</a></h3>
The error and warning codes returned by libSBML are listed in the table
below.  The method SBMLError::getErrorId() returns the error code of a
given SBMLError object instance.  In the libSBML Java language
interface, these error identifiers are currently (in libSBML 3.3.x)
implemented as static integer constants defined in the interface class
<code><a href="libsbmlConstants.html">libsbmlConstants</a></code>.  This
is admittedly not an ideal approach from the standpoint of modern Java
programming, but it was necessary to work around the lack of
enumerations in Java prior to JDK 1.5.  Future versions of libSBML may
use a proper Java enumeration type to define the error identifiers.
In this table, the right-hand columns titled "L1V1", "L1V2", etc. refer
to Levels and Versions of the SBML specifications, and the entries in
each column refer to whether the severity of the condition in that
particular Level+Version of SBML.  The codes stand for the following:
@endif

<table cellspacing="1" cellpadding="2" border="0" class="normal-font">
<tr><td class="s-na">N</td><td>= Not applicable</td></tr>
<tr><td class="s-info">I</td><td>= Informational</td></tr>
<tr><td class="s-warning">W</td><td>= Warning</td></tr>
<tr><td class="s-error">E</td><td>= Error</td></tr>
<tr><td class="s-fatal">F</td><td>= Fatal</td></tr>
</table>

The text shown in the "Meaning" is the text returned by the
SBMLError::getShortMessage() method on a given SBMLError object.  A
longer and (hopefully) clearer explanation of the issue is returned by
SBMLError::getMessage().

<center>
<table width="95%" cellspacing="1" cellpadding="2" border="0" class="text-table small-font alt-row-colors">
<tr style="background: lightgray" class="normal-font">
<th valign="bottom"><strong>Enumerator</strong></th>
<th valign="bottom"><strong>Meaning</strong></th>
<th align="center" width="15">L 1 V 1</th>
<th align="center" width="15">L 1 V 2</th>
<th align="center" width="15">L 2 V 1</th>
<th align="center" width="15">L 2 V 2</th>
<th align="center" width="15">L 2 V 3</th>
<th align="center" width="15">L 2 V 4</th>
</tr>
<tr><td>C<UnknownError></td><td>Unknown internal libSBML error</td><td class="s-fatal">F</td><td class="s-fatal">F</td><td class="s-fatal">F</td><td class="s-fatal">F</td><td class="s-fatal">F</td><td class="s-fatal">F</td></tr>
<tr><td>C<NotUTF8></td><td>Not UTF8</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<UnrecognizedElement></td><td>Unrecognized element</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<NotSchemaConformant></td><td>Not conformant to SBML XML schema</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<InvalidMathElement></td><td>Invalid MathML</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<DisallowedMathMLSymbol></td><td>Disallowed MathML symbol</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<DisallowedMathMLEncodingUse></td><td>Disallowed use of MathML C<encoding> attribute</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<DisallowedDefinitionURLUse></td><td>Disallowed use of MathML C<definitionURL> attribute</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<BadCsymbolDefinitionURLValue></td><td>Invalid C<&lt;csymbol&gt;> C<definitionURL> attribute value</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<DisallowedMathTypeAttributeUse></td><td>Disallowed use of MathML C<type> attribute</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<DisallowedMathTypeAttributeValue></td><td>Disallowed MathML C<type> attribute value</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<LambdaOnlyAllowedInFunctionDef></td><td>Use of C<&lt;lambda&gt;> not permitted outside of a C<&lt;functionDefinition&gt;></td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<BooleanOpsNeedBooleanArgs></td><td>Non-boolean argument given to boolean operator</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-warning">W</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<NumericOpsNeedNumericArgs></td><td>Non-numerical argument given to numerical operator</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-warning">W</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<ArgsToEqNeedSameType></td><td>Arguments to C<&lt;eq&gt;> or C<&lt;neq&gt;> have inconsistent data types</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-warning">W</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<PiecewiseNeedsConsistentTypes></td><td>C<&lt;piecewise&gt;> terms have inconsistent data types</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-warning">W</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<PieceNeedsBoolean></td><td>Second argument of C<&lt;piece&gt;> must yield a boolean value</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-warning">W</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<ApplyCiMustBeUserFunction></td><td>C<&lt;ci&gt;> does not refer to a function definition</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-warning">W</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<ApplyCiMustBeModelComponent></td><td>C<&lt;ci&gt;>'s value is not a component in this model</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-warning">W</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<KineticLawParametersAreLocalOnly></td><td>Cannot use C<&lt;kineticLaw&gt;> parameter outside local scope</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-warning">W</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<MathResultMustBeNumeric></td><td>Formula result is not a numerical value</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-warning">W</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<OpsNeedCorrectNumberOfArgs></td><td>Incorrect number of arguments to operator</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-warning">W</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<InvalidNoArgsPassedToFunctionDef></td><td>Incorrect number of arguments to function</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td></tr>
<tr><td>C<DuplicateComponentId></td><td>Duplicate component identifier</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<DuplicateUnitDefinitionId></td><td>Duplicate unit definition identifier</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<DuplicateLocalParameterId></td><td>Duplicate local parameter identifier</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<MultipleAssignmentOrRateRules></td><td>Multiple rules for the same variable</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<MultipleEventAssignmentsForId></td><td>Multiple event assignments for the same variable</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<EventAndAssignmentRuleForId></td><td>C<variable> value used in both event assignments and assignment rules</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<DuplicateMetaId></td><td>Duplicate C<metaid> identifier</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<InvalidSBOTermSyntax></td><td>Invalid C<sboTerm> value syntax</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<InvalidMetaidSyntax></td><td>Invalid C<metaid> value syntax</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<InvalidIdSyntax></td><td>Invalid identifier syntax</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<InvalidUnitIdSyntax></td><td>Invalid unit identifier syntax</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<MissingAnnotationNamespace></td><td>Missing declaration of XML namespace for annotation</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<DuplicateAnnotationNamespaces></td><td>Multiple annotations using same XML namespace</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<SBMLNamespaceInAnnotation></td><td>Invalid use of SBML XML namespace in annotation</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<InconsistentArgUnits></td><td>Units of arguments to function call do not match function's definition</td><td class="s-warning">W</td><td class="s-warning">W</td><td class="s-warning">W</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-warning">W</td></tr>
<tr><td>C<AssignRuleCompartmentMismatch></td><td>Mismatched units in assignment rule for compartment</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-warning">W</td></tr>
<tr><td>C<AssignRuleSpeciesMismatch></td><td>Mismatched units in assignment rule for species</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-warning">W</td></tr>
<tr><td>C<AssignRuleParameterMismatch></td><td>Mismatched units in assignment rule for parameter</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-warning">W</td></tr>
<tr><td>C<InitAssignCompartmenMismatch></td><td>Mismatched units in initial assignment to compartment</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-warning">W</td></tr>
<tr><td>C<InitAssignSpeciesMismatch></td><td>Mismatched units in initial assignment to species</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-warning">W</td></tr>
<tr><td>C<InitAssignParameterMismatch></td><td>Mismatched units in initial assignment to parameter</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-warning">W</td></tr>
<tr><td>C<RateRuleCompartmentMismatch></td><td>Mismatched units in rate rule for compartment</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-warning">W</td></tr>
<tr><td>C<RateRuleSpeciesMismatch></td><td>Mismatched units in rate rule for species</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-warning">W</td></tr>
<tr><td>C<RateRuleParameterMismatch></td><td>Mismatched units in rate rule for parameter</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-warning">W</td></tr>
<tr><td>C<KineticLawNotSubstancePerTime></td><td>Kinetic law units are not C<substance>/C<time></td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-warning">W</td></tr>
<tr><td>C<DelayUnitsNotTime></td><td>Units of delay are not units of time</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-warning">W</td></tr>
<tr><td>C<EventAssignCompartmentMismatch></td><td>Mismatched units in event assignment for compartment</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-warning">W</td></tr>
<tr><td>C<EventAssignSpeciesMismatch></td><td>Mismatched units in event assignment for species</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-warning">W</td></tr>
<tr><td>C<EventAssignParameterMismatch></td><td>Mismatched units in event assignment for parameter</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-warning">W</td></tr>
<tr><td>C<OverdeterminedSystem></td><td>Model is overdetermined</td><td class="s-warning">W</td><td class="s-warning">W</td><td class="s-warning">W</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<InvalidModelSBOTerm></td><td>Invalid C<sboTerm> value for model</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-warning">W</td></tr>
<tr><td>C<InvalidFunctionDefSBOTerm></td><td>Invalid C<sboTerm> value for function definition</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-warning">W</td></tr>
<tr><td>C<InvalidParameterSBOTerm></td><td>Invalid C<sboTerm> value for parameter</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-warning">W</td></tr>
<tr><td>C<InvalidInitAssignSBOTerm></td><td>Invalid C<sboTerm> value for initial assignment</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-warning">W</td></tr>
<tr><td>C<InvalidRuleSBOTerm></td><td>Invalid C<sboTerm> value for rule</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-warning">W</td></tr>
<tr><td>C<InvalidConstraintSBOTerm></td><td>Invalid C<sboTerm> value for constraint</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-warning">W</td></tr>
<tr><td>C<InvalidReactionSBOTerm></td><td>Invalid C<sboTerm> value for reaction</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-warning">W</td></tr>
<tr><td>C<InvalidSpeciesReferenceSBOTerm></td><td>Invalid C<sboTerm> value for species reference</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-warning">W</td></tr>
<tr><td>C<InvalidKineticLawSBOTerm></td><td>Invalid C<sboTerm> value for kinetic law</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-warning">W</td></tr>
<tr><td>C<InvalidEventSBOTerm></td><td>Invalid C<sboTerm> value for event</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-warning">W</td></tr>
<tr><td>C<InvalidEventAssignmentSBOTerm></td><td>Invalid C<sboTerm> value for event assignment</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-warning">W</td></tr>
<tr><td>C<InvalidCompartmentSBOTerm></td><td>Invalid C<sboTerm> value for compartment</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-warning">W</td></tr>
<tr><td>C<InvalidSpeciesSBOTerm></td><td>Invalid C<sboTerm> value for species</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-warning">W</td></tr>
<tr><td>C<InvalidCompartmentTypeSBOTerm></td><td>Invalid C<sboTerm> value for compartment type</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-warning">W</td></tr>
<tr><td>C<InvalidSpeciesTypeSBOTerm></td><td>Invalid C<sboTerm> value for species type</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-warning">W</td></tr>
<tr><td>C<InvalidTriggerSBOTerm></td><td>Invalid C<sboTerm> value for event trigger</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-warning">W</td></tr>
<tr><td>C<InvalidDelaySBOTerm></td><td>Invalid C<sboTerm> value for event delay</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-warning">W</td></tr>
<tr><td>C<NotesNotInXHTMLNamespace></td><td>Notes not placed in XHTML namespace</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<NotesContainsXMLDecl></td><td>XML declarations not permitted in notes</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<NotesContainsDOCTYPE></td><td>XML C<DOCTYPE> not permitted in notes</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<InvalidNotesContent></td><td>Invalid notes content</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<InvalidNamespaceOnSBML></td><td>Invalid XML namespace for SBML container</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<MissingOrInconsistentLevel></td><td>Missing or inconsistent value for C<level> attribute</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<MissingOrInconsistentVersion></td><td>Missing or inconsistent value for C<version> attribute</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<AnnotationNotesNotAllowedLevel1></td><td>Annotation on C<&lt;sbml&gt;> not permitted in SBML Level 1</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<MissingModel></td><td>Missing model</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<IncorrectOrderInModel></td><td>Incorrect ordering of components in model definition</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<EmptyListElement></td><td>A given C<listOf___>, if present, cannot be empty</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<NeedCompartmentIfHaveSpecies></td><td>Missing compartment in species definition</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<FunctionDefMathNotLambda></td><td>Invalid expression in function definition</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<InvalidApplyCiInLambda></td><td>Invalid forward reference in C<&lt;apply&gt;>C<&lt;ci&gt;>...C<&lt;/ci&gt;>C<&lt;/apply&gt;> value</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td></tr>
<tr><td>C<RecursiveFunctionDefinition></td><td>Recursive function definition</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<InvalidCiInLambda></td><td>Unknown C<&lt;ci&gt;> reference in C<&lt;lambda&gt;></td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<InvalidFunctionDefReturnType></td><td>Function return type must be either numerical or boolean</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<InvalidUnitDefId></td><td>Invalid C<id> value for unit definition</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<InvalidSubstanceRedefinition></td><td>Invalid redefinition of C<substance></td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<InvalidLengthRedefinition></td><td>Invalid redefinition of C<length></td><td class="s-warning">W</td><td class="s-warning">W</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<InvalidAreaRedefinition></td><td>Invalid redefinition of C<area></td><td class="s-warning">W</td><td class="s-warning">W</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<InvalidTimeRedefinition></td><td>Invalid redefinition of C<time></td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<InvalidVolumeRedefinition></td><td>Invalid redefinition of C<volume></td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<VolumeLitreDefExponentNotOne></td><td>Must use C<exponent>=C<1> when defining C<volume> in terms of litres</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td></tr>
<tr><td>C<VolumeMetreDefExponentNot3></td><td>Must use C<exponent>=C<3> when defining C<volume> in terms of metres</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td></tr>
<tr><td>C<EmptyListOfUnits></td><td>Empty list of units not permitted</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<InvalidUnitKind></td><td>Invalid value of C<kind> in unit definition</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<OffsetNoLongerValid></td><td>C<offset> not supported in this Level+Version of SBML</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">N</td></tr>
<tr><td>C<CelsiusNoLongerValid></td><td>C<Celsius> not defined in this Level+Version of SBML</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td></tr>
<tr><td>C<ZeroDimensionalCompartmentSize></td><td>Use of C<size> is invalid for a zero-dimensional compartment</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<ZeroDimensionalCompartmentUnits></td><td>Use of C<units> is invalid for a zero-dimensional compartment</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<ZeroDimensionalCompartmentConst></td><td>Zero-dimensional compartments cannot be non-constant</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<UndefinedOutsideCompartment></td><td>Undefined compartment used as C<outside> value</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<RecursiveCompartmentContainment></td><td>Recursive nesting of compartments via C<outside></td><td class="s-warning">W</td><td class="s-warning">W</td><td class="s-warning">W</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<ZeroDCompartmentContainment></td><td>Invalid nesting of zero-dimensional compartments</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-warning">W</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<Invalid1DCompartmentUnits></td><td>Invalid value of C<units> for a one-dimensional compartment</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<Invalid2DCompartmentUnits></td><td>Invalid value of C<units> for a two-dimensional compartment</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<Invalid3DCompartmentUnits></td><td>Invalid value of C<units> for a three-dimensional compartment</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<InvalidCompartmentTypeRef></td><td>Invalid C<compartmentType> reference</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<InvalidSpeciesCompartmentRef></td><td>Invalid C<compartment> reference</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<HasOnlySubsNoSpatialUnits></td><td>No C<spatialSizeUnits> permitted if C<hasOnlySubstanceUnits>=C<true></td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<NoSpatialUnitsInZeroD></td><td>No C<spatialSizeUnits> permitted if compartment is zero-dimensional</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<NoConcentrationInZeroD></td><td>No C<initialConcentration> permitted if compartment is zero-dimensional</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<SpatialUnitsInOneD></td><td>Invalid value of C<spatialSizeUnits> for a one-dimensional compartment</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<SpatialUnitsInTwoD></td><td>Invalid value of C<spatialSizeUnits> for a two-dimensional compartment</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<SpatialUnitsInThreeD></td><td>Invalid value of C<spatialSizeUnits> for a three-dimensional compartment</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<InvalidSpeciesSusbstanceUnits></td><td>Invalid value of C<units></td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<BothAmountAndConcentrationSet></td><td>Cannot set both C<initialConcentration> and C<initialAmount></td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<NonBoundarySpeciesAssignedAndUsed></td><td>Cannot use non-boundary species in both reactions and rules simultaneously</td><td class="s-warning">W</td><td class="s-warning">W</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<NonConstantSpeciesUsed></td><td>Cannot use non-boundary, constant species as reactant or product</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<InvalidSpeciesTypeRef></td><td>Invalid C<speciesType> reference</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<MultSpeciesSameTypeInCompartment></td><td>Cannot have multiple species of the same type in the same compartment</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<MissingSpeciesCompartment></td><td>Missing C<compartment> value for species</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<SpatialSizeUnitsRemoved></td><td>Attribute C<spatialSizeUnits> not supported in this Level+Version of SBML</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<InvalidParameterUnits></td><td>Invalid value for C<units> in parameter definition</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<InvalidInitAssignSymbol></td><td>Invalid C<symbol> reference in initial assignment</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<MultipleInitAssignments></td><td>Multiple initial assignments for the same C<symbol> value</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<InitAssignmentAndRuleForSameId></td><td>Cannot set a value with both initial assignments and assignment rules simultaneously</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<InvalidAssignRuleVariable></td><td>Invalid C<variable> reference in assignment rule</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<InvalidRateRuleVariable></td><td>Invalid C<variable> reference in rate rule</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<AssignmentToConstantEntity></td><td>Cannot reassign a constant in an assignment rule</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<RateRuleForConstantEntity></td><td>Cannot reassign a constant in a rate rule</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<CircularRuleDependency></td><td>Circular dependency involving rules and reactions</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<ConstraintMathNotBoolean></td><td>Non-boolean math expression in constraint definition</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<IncorrectOrderInConstraint></td><td>Incorrect order of elements in constraint definition</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<ConstraintNotInXHTMLNamespace></td><td>Constraint message is not in XHTML XML namespace</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<ConstraintContainsXMLDecl></td><td>XML declarations not permitted in constraint messages</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<ConstraintContainsDOCTYPE></td><td>XML C<DOCTYPE> not permitted in constraint messages</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<InvalidConstraintContent></td><td>Invalid content for constraint message</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<NoReactantsOrProducts></td><td>Cannot have a reaction with neither reactants nor products</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<IncorrectOrderInReaction></td><td>Incorrect ordering of components in reaction definition</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<EmptyListInReaction></td><td>Reaction components, if present, cannot be empty</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<InvalidReactantsProductsList></td><td>Invalid element in list of reactants or products</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<InvalidModifiersList></td><td>Invalid element in list of modifiers</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<InvalidSpeciesReference></td><td>Invalid C<species> value in species reference</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<BothStoichiometryAndMath></td><td>Cannot use both C<stoichiometry> and C<&lt;stoichiometryMath&gt;> simultaneously</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<UndeclaredSpeciesRef></td><td>Undeclared species referenced in kinetic law formula</td><td class="s-warning">W</td><td class="s-warning">W</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<IncorrectOrderInKineticLaw></td><td>Incorrect ordering of components in kinetic law definition</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<EmptyListInKineticLaw></td><td>The list of parameters component, if present, cannot be empty</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<NonConstantLocalParameter></td><td>Parameters local to a kinetic law must have C<constant>=C<true></td><td class="s-na">N</td><td class="s-na">N</td><td class="s-warning">W</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<SubsUnitsNoLongerValid></td><td>C<substanceUnits> not supported in this Level+Version of SBML</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">N</td></tr>
<tr><td>C<TimeUnitsNoLongerValid></td><td>C<timeUnits> not supported in this Level+Version of SBML</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">N</td></tr>
<tr><td>C<UndeclaredSpeciesInStoichMath></td><td>Undeclared species referenced in C<&lt;stoichiometryMath&gt;> formula</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-warning">W</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<MissingTriggerInEvent></td><td>Missing trigger in event definition</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<TriggerMathNotBoolean></td><td>Non-boolean math expression in trigger definition</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<MissingEventAssignment></td><td>Missing event assignment in event definition</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<TimeUnitsEvent></td><td>Units of C<timeUnits> are not time units</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<IncorrectOrderInEvent></td><td>Incorrect ordering of components in event definition</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<ValuesFromTriggerTimeNeedDelay></td><td>C<useValuesFromTriggerTime>=C<false>, but no delay defined in event</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td></tr>
<tr><td>C<InvalidEventAssignmentVariable></td><td>Invalid value for C<variable> in event assignment</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<EventAssignmentForConstantEntity></td><td>Cannot assign to a constant component in an event assignment</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-warning">W</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<CompartmentShouldHaveSize></td><td>It's best to define a size for every compartment in a model</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-warning">W</td><td class="s-warning">W</td><td class="s-warning">W</td><td class="s-warning">W</td></tr>
<tr><td>C<ParameterShouldHaveUnits></td><td>It's best to declare units for every parameter in a model</td><td class="s-warning">W</td><td class="s-warning">W</td><td class="s-warning">W</td><td class="s-warning">W</td><td class="s-warning">W</td><td class="s-warning">W</td></tr>
<tr><td>C<LocalParameterShadowsId></td><td>Local parameters defined in a kinetic law shadow global parameters</td><td class="s-warning">W</td><td class="s-warning">W</td><td class="s-warning">W</td><td class="s-warning">W</td><td class="s-warning">W</td><td class="s-warning">W</td></tr>
<tr><td>C<CannotConvertToL1V1></td><td>Cannot convert to SBML Level 1 Version&nbsp;1</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<NoEventsInL1></td><td>SBML Level 1 does not support events</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<NoFunctionDefinitionsInL1></td><td>SBML Level 1 does not support function definitions</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<NoConstraintsInL1></td><td>SBML Level 1 does not support constraints</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-warning">W</td><td class="s-warning">W</td><td class="s-warning">W</td></tr>
<tr><td>C<NoInitialAssignmentsInL1></td><td>SBML Level 1 does not support initial assignments</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<NoSpeciesTypesInL1></td><td>SBML Level 1 does not support species types</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-warning">W</td><td class="s-warning">W</td><td class="s-warning">W</td></tr>
<tr><td>C<NoCompartmentTypeInL1></td><td>SBML Level 1 does not support compartment types</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-warning">W</td><td class="s-warning">W</td><td class="s-warning">W</td></tr>
<tr><td>C<NoNon3DComparmentsInL1></td><td>SBML Level 1 only supports three-dimensional compartments</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<NoFancyStoichiometryMathInL1></td><td>SBML Level 1 does not support non-integer nor non-rational stoichiometry formulas</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<NoNonIntegerStoichiometryInL1></td><td>SBML Level 1 does not support non-integer C<stoichiometry> attribute values</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<NoUnitMultipliersOrOffsetsInL1></td><td>SBML Level 1 does not support multipliers or offsets in unit definitions</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<SpeciesCompartmentRequiredInL1></td><td>In SBML Level 1, a value for C<compartment> is mandatory in species definitions</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<NoSpeciesSpatialSizeUnitsInL1></td><td>SBML Level 1 does not support species C<spatialSizeUnits> settings</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<NoSBOTermsInL1></td><td>SBML Level 1 does not support the C<sboTerm> attribute</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-warning">W</td><td class="s-warning">W</td><td class="s-warning">W</td></tr>
<tr><td>C<StrictUnitsRequiredInL1></td><td>SBML Level 1 requires strict unit consistency</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td></tr>
<tr><td>C<NoConstraintsInL2v1></td><td>SBML Level&nbsp;2 Version&nbsp;1 does not support constraints</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-warning">W</td><td class="s-warning">W</td><td class="s-warning">W</td></tr>
<tr><td>C<NoInitialAssignmentsInL2v1></td><td>SBML Level&nbsp;2 Version&nbsp;1 does not support initial assignments</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<NoSpeciesTypeInL2v1></td><td>SBML Level&nbsp;2 Version&nbsp;1 does not support species types</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-warning">W</td><td class="s-warning">W</td><td class="s-warning">W</td></tr>
<tr><td>C<NoCompartmentTypeInL2v1></td><td>SBML Level&nbsp;2 Version&nbsp;1 does not support compartment types</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-warning">W</td><td class="s-warning">W</td><td class="s-warning">W</td></tr>
<tr><td>C<NoSBOTermsInL2v1></td><td>SBML Level&nbsp;2 Version&nbsp;1 does not support the C<sboTerm> attribute</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-warning">W</td><td class="s-warning">W</td><td class="s-warning">W</td></tr>
<tr><td>C<NoIdOnSpeciesReferenceInL2v1></td><td>SBML Level&nbsp;2 Version&nbsp;1 does not support the C<id> attribute on species references</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-warning">W</td><td class="s-warning">W</td><td class="s-warning">W</td></tr>
<tr><td>C<NoDelayedEventAssignmentInL2v1></td><td>Attribute C<useValuesFromTriggerTime> not supported in this Level+Version of SBML</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td></tr>
<tr><td>C<StrictUnitsRequiredInL2v1></td><td>SBML Level&nbsp;2 Version&nbsp;1 requires strict unit consistency</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td></tr>
<tr><td>C<SBOTermNotUniversalInL2v2></td><td>The C<sboTerm> attribute is invalid for this component in Level&nbsp;2 Version&nbsp;2</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-warning">W</td><td class="s-warning">W</td></tr>
<tr><td>C<NoUnitOffsetInL2v2></td><td>The unit C<offset> attribute is invalid in this Level+Version of SBML</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<NoKineticLawTimeUnitsInL2v2></td><td>The C<timeUnits> attribute is invalid in this Level+Version of SBML</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<NoKineticLawSubstanceUnitsInL2v2></td><td>The C<substanceUnits> attribute is invalid in this Level+Version of SBML</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<NoDelayedEventAssignmentInL2v2></td><td>Attribute C<useValuesFromTriggerTime> not supported in this Level+Version of SBML</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td></tr>
<tr><td>C<ModelSBOBranchChangedBeyondL2v2></td><td>The allowable C<sboTerm> values for model differ for this SBML Level+Version</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td></tr>
<tr><td>C<StrictUnitsRequiredInL2v2></td><td>SBML Level&nbsp;2 Version&nbsp;2 requires strict unit consistency</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td></tr>
<tr><td>C<StrictSBORequiredInL2v2></td><td>SBML Level&nbsp;2 Version&nbsp;2 requires strict sbo consistency</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td></tr>
<tr><td>C<NoUnitOffsetInL2v3></td><td>Attribute C<offset> not supported in this Level+Version of SBML</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<NoKineticLawTimeUnitsInL2v3></td><td>Attribute C<timeUnits> not supported in this Level+Version of SBML</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<NoKineticLawSubstanceUnitsInL2v3></td><td>Attribute C<substanceUnits> not supported in this Level+Version of SBML</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<NoSpeciesSpatialSizeUnitsInL2v3></td><td>Attribute C<spatialSizeUnits> not supported in this Level+Version of SBML</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<NoEventTimeUnitsInL2v3></td><td>Attribute C<timeUnits> not supported in this Level+Version of SBML</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<NoDelayedEventAssignmentInL2v3></td><td>Attribute C<useValuesFromTriggerTime> not supported in this Level+Version of SBML</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td></tr>
<tr><td>C<ModelSBOBranchChangedBeyondL2v3></td><td>The allowable C<sboTerm> values for model differ for this SBML Level+Version</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td></tr>
<tr><td>C<StrictUnitsRequiredInL2v3></td><td>SBML Level&nbsp;2 Version&nbsp;3 requires strict unit consistency</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td></tr>
<tr><td>C<StrictSBORequiredInL2v3></td><td>SBML Level&nbsp;2 Version&nbsp;3 requires strict sbo consistency</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td></tr>
<tr><td>C<NoUnitOffsetInL2v4></td><td>The unit C<offset> attribute is invalid in this Level+Version of SBML</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<NoKineticLawTimeUnitsInL2v4></td><td>The C<timeUnits> attribute is invalid in this Level+Version of SBML</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<NoKineticLawSubstanceUnitsInL2v4></td><td>The C<substanceUnits> attribute is invalid in this Level+Version of SBML</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<NoSpeciesSpatialSizeUnitsInL2v4></td><td>The C<spatialSizeUnits> attribute is invalid in this Level+Version of SBML</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<NoEventTimeUnitsInL2v4></td><td>The C<timeUnits> attribute is invalid in this Level+Version of SBML</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<ModelSBOBranchChangedInL2v4></td><td>The allowable C<sboTerm> values for model differ for this SBML Level+Version</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td></tr>
<tr><td>C<InvalidSBMLLevelVersion></td><td>Invalid SBML Level and Version</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<InvalidRuleOrdering></td><td>Invalid ordering of rules</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<SubsUnitsAllowedInKL></td><td>Disallowed value for attribute C<substanceUnits></td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<TimeUnitsAllowedInKL></td><td>Disallowed value for attribute C<timeUnits></td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<FormulaInLevel1KL></td><td>Only predefined functions are permitted in SBML Level 1 formulas</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<TimeUnitsRemoved></td><td>The C<timeUnits> attribute is invalid in this Level+Version of SBML</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<BadMathML></td><td>Invalid MathML expression</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td>   </tr>
<tr><td>C<FailedMathMLReadOfDouble></td><td>Failed to read floating-point number</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td>   </tr>
<tr><td>C<FailedMathMLReadOfInteger></td><td>Failed to read an integer</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td>   </tr>
<tr><td>C<FailedMathMLReadOfExponential></td><td>Failed to read an exponential expression</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td>   </tr>
<tr><td>C<FailedMathMLReadOfRational></td><td>Failed to read a rational expression</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td>   </tr>
<tr><td>C<BadMathMLNodeType></td><td>Invalid MathML element</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td>   </tr>
<tr><td>C<NoTimeSymbolInFunctionDef></td><td>C<&lt;csymbol&gt;> for C<time> used within the C<&lt;math&gt;> of a function definition</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-warning">W</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td>   </tr>
<tr><td>C<UndeclaredUnits></td><td>Undeclared units</td><td class="s-warning">W</td><td class="s-warning">W</td><td class="s-warning">W</td><td class="s-warning">W</td><td class="s-warning">W</td><td class="s-warning">W</td></tr>
<tr><td>C<UnrecognisedSBOTerm></td><td>Unrecognized C<sboTerm> value</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-warning">W</td><td class="s-warning">W</td><td class="s-warning">W</td></tr>
<tr><td>C<ObseleteSBOTerm></td><td>Obsolete C<sboTerm> value</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-warning">W</td><td class="s-warning">W</td><td class="s-warning">W</td></tr>
<tr><td>C<IncorrectCompartmentSpatialDimensions></td><td>in SBML Level 1, only three-dimensional compartments are permitted</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<CompartmentTypeNotValidAttribute></td><td>Compartment types not supported in this Level+Version of SBML</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<ConstantNotValidAttribute></td><td>Attribute C<constant> not supported on this component in SBML Level 1</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<MetaIdNotValidAttribute></td><td>Attribute C<metaid> not supported in SBML Level 1</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<SBOTermNotValidAttributeBeforeL2V3></td><td>C<sboTerm> not available on this component before SBML Level&nbsp;2 Version&nbsp;3</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<InvalidL1CompartmentUnits></td><td>Invalid units for a compartment in SBML Level 1</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<L1V1CompartmentVolumeReqd></td><td>Compartment volume must be specified</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<CompartmentTypeNotValidComponent></td><td>Compartment types not supported in this Level+Version of SBML</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<ConstraintNotValidComponent></td><td>Constraints not supported in this Level+Version of SBML</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<EventNotValidComponent></td><td>Events not supported in this Level+Version of SBML</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<SBOTermNotValidAttributeBeforeL2V2></td><td>The C<sboTerm> attribute is invalid for this component before Level&nbsp;2 Version&nbsp;2</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<FuncDefNotValidComponent></td><td>Function definitions are not supported in this Level+Version of SBML</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<InitialAssignNotValidComponent></td><td>Initial assignments are not supported in this Level+Version of SBML</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<VariableNotValidAttribute></td><td>Attribute C<variable> not valid</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<UnitsNotValidAttribute></td><td>Attribute C<units> not valid</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td></tr>
<tr><td>C<ConstantSpeciesNotValidAttribute></td><td>Attribute C<constant> on species not supported in SBML Level 1</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<SpatialSizeUnitsNotValidAttribute></td><td>Attribute C<spatialSizeUnits> on species not supported in SBML Level 1</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<SpeciesTypeNotValidAttribute></td><td>Attribute C<speciesType> on species not supported in SBML Level 1</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<HasOnlySubsUnitsNotValidAttribute></td><td>Attribute C<hasOnlySubstanceUnits> on species not supported in SBML Level 1</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<IdNotValidAttribute></td><td>Attribute C<id> on species references not supported in SBML Level 1</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<NameNotValidAttribute></td><td>Attribute C<name> on species references not supported in SBML Level 1</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<SpeciesTypeNotValidComponent></td><td>Species types not supported in SBML Level 1</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<StoichiometryMathNotValidComponent></td><td>lt;stoichiometryMath&gt; not supported in SBML Level 1</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td></tr>
<tr><td>C<MultiplierNotValidAttribute></td><td>Attribute C<multiplier> on units not supported in SBML Level 1</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td></tr> 
<tr><td>C<OffsetNotValidAttribute></td><td>Attribute C<offset> on units only available in SBML Level&nbsp;2 Version&nbsp;1</td><td class="s-error">E</td><td class="s-error">E</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td><td class="s-na">N</td></tr>
</table>
</center>
@if clike
<h3><a class="anchor" name="SBMLErrorCategory_t">SBMLErrorCategory_t</a></h3>
SBMLErrorCategory_t is an enumeration of category codes for SBMLError
diagnostics.  The category can be retrieved from an SBMLError object
using the method SBMLError::getCategory().  These enumeration values are
distinct from (and in addition to) the @link
XMLError::XMLErrorCategory_t XMLErrorCategory_t @endlink codes used by
the parent XMLError object.  User programs receiving an SBMLError object
can use this distinction to check whether the error represents a
low-level XML problem or an SBML problem.
The following table lists each possible value and a brief description of
its meaning.
@endif@if java <h3><a class="anchor"
name="SBMLErrorCategory_t">Category codes associated with SBMLError objects</a></h3>
As discussed above, each SBMLError object contains a value for a
category identifier, describing the type of issue that the SBMLError
object represents.  The category can be retrieved from an SBMLError
object using the method SBMLError::getCategory().  The following table
lists each possible value and a brief description of its meaning.
As is the case with the error codes, in the libSBML Java language
interface, the category identifiers are currently implemented as static
integer constants defined in the interface class
<code><a href="libsbmlConstants.html">libsbmlConstants</a></code>. @endif
<center>
<table width="90%" cellspacing="1" cellpadding="4" border="0"  class="text-table normal-font alt-row-colors">
<tr style="background: lightgray" class="normal-font">
<th>Enumerator</td>
<th>Meaning</td>
</tr>
<tr><td>C<LIBSBML_CAT_SBML></td><td>General error not falling into
another category below.</td></tr> 
<tr><td>C<LIBSBML_CAT_SBML_L1_COMPAT></td><td>Category of errors
that can only occur during attempted translation from one Level/Version
of SBML to another.  This particular category applies to errors
encountered while trying to convert a model from SBML Level&nbsp;2 to SBML
Level&nbsp;1.</td></tr> 
<tr><td>C<LIBSBML_CAT_SBML_L2V1_COMPAT></td><td>Category of errors
that can only occur during attempted translation from one Level/Version
of SBML to another.  This particular category applies to errors
encountered while trying to convert a model to SBML Level&nbsp;2
Version&nbsp;1.</td></tr> 
<tr><td>C<LIBSBML_CAT_SBML_L2V2_COMPAT></td><td>Category of errors
that can only occur during attempted translation from one Level/Version
of SBML to another.  This particular category applies to errors
encountered while trying to convert a model to SBML Level&nbsp;2
Version&nbsp;2.</td></tr> 
<tr><td>C<LIBSBML_CAT_GENERAL_CONSISTENCY></td><td>Category of
errors that can occur while validating general SBML constructs.  With
respect to the SBML specification, these concern failures in applying
the validation rules numbered 2xxxx in the Level&nbsp;2 Versions&nbsp;2
and&nbsp;3 specifications.</td></tr>
<tr><td>C<LIBSBML_CAT_IDENTIFIER_CONSISTENCY></td><td>Category of
errors that can occur while validating symbol identifiers in a model.
With respect to the SBML specification, these concern failures in
applying the validation rules numbered 103xx in the Level&nbsp;2
Versions&nbsp;2 and&nbsp;3 specifications.</td></tr>  
<tr><td>C<LIBSBML_CAT_UNITS_CONSISTENCY></td><td>Category of
errors that can occur while validating the units of measurement on
quantities in a model.  With respect to the SBML specification, these
concern failures in applying the validation rules numbered 105xx in the
Level&nbsp;2 Versions&nbsp;2 and&nbsp;3 specifications.</td></tr> 
<tr><td>C<LIBSBML_CAT_MATHML_CONSISTENCY></td><td>Category of
errors that can occur while validating MathML formulas in a model.  With
respect to the SBML specification, these concern failures in applying
the validation rules numbered 102xx in the Level&nbsp;2 Versions&nbsp;2
and&nbsp;3 specifications.</td></tr> 
<tr><td>C<LIBSBML_CAT_SBO_CONSISTENCY></td><td>Category of errors
that can occur while validating SBO identifiers in a model.  With
respect to the SBML specification, these concern failures in applying
the validation rules numbered 107xx in the Level&nbsp;2 Versions&nbsp;2
and&nbsp;3 specifications.</td></tr> 
<tr><td>C<LIBSBML_CAT_OVERDETERMINED_MODEL></td><td>Error in the
system of equations in the model: the system is overdetermined,
therefore violating a tenet of proper SBML.  With respect to the SBML
specification, this is validation rule #10601 in the SBML Level&nbsp;2
Versions&nbsp;2 and&nbsp;3 specifications.</td></tr> 
<tr><td>C<LIBSBML_CAT_SBML_L2V3_COMPAT></td><td>Category of errors
that can only occur during attempted translation from one Level/Version
of SBML to another.  This particular category applies to errors
encountered while trying to convert a model to SBML Level&nbsp;2
Version&nbsp;3.</td></tr> 
<tr><td>C<LIBSBML_CAT_MODELING_PRACTICE></td><td>Category of
warnings about recommended good practices involving SBML and
computational modeling.  (These are tests performed by libSBML and do
not have equivalent SBML validation rules.)</td></tr> 
<tr><td>C<LIBSBML_CAT_INTERNAL_CONSISTENCY></td><td>Category of
errors that can occur while validating libSBML's internal representation
of SBML constructs. (These are tests performed by libSBML and do
not have equivalent SBML validation rules.)</td></tr> 
<tr><td>C<LIBSBML_CAT_SBML_L2V4_COMPAT></td><td>Category of errors
that can only occur during attempted translation from one Level/Version
of SBML to another.  This particular category applies to errors
encountered while trying to convert a model to SBML Level&nbsp;2
Version&nbsp;4.</td></tr> 

</table>
</center>

@if clike
<h3><a class="anchor" name="SBMLErrorSeverity_t">SBMLErrorSeverity_t</a></h3>
This is an enumeration of severity codes for SBMLError diagnostics.
User programs receiving an SBMLError object can use this distinction to
check whether the error represents a low-level XML problem or an SBML
problem.

In this verision of libSBML (3.3.x), there are no additional severity
codes in SBMLErrorSeverity_t beyond those defined in @link
XMLError::XMLErrorSeverity_t XMLErrorSeverity_t @endlink.
<hr>
@endif@if java <h3><a class="anchor"
name="SBMLErrorSeverity_t">Severity codes associated with SBMLError
objects</h3>

In this verision of libSBML (3.3.x), there are no additional severity
codes beyond those defined by XMLError.  They are implemented as static
integer constants defined in the interface class <code><a
href="libsbmlConstants.html">libsbmlConstants</a></code>, and have names
beginning with C<LIBSBML_SEV_>.
@endif


=over

=item SBMLError::SBMLError

Creates a new SBMLError to report that something occurred during SBML
processing.

When a libSBML operation on SBML content results in a warning, error
or other diagnostic, the issue is reported as an SBMLError object.
SBMLError objects have identification numbers to indicate the nature
of the exception.  @if clike These numbers are drawn from
the enumeration <a class="el"
href="#SBMLErrorCode_t">
SBMLErrorCode_t</a>.  @endif@if java These numbers are
defined as unsigned integer constants in the file
"libsbmlConstants.html".  See the <a class="el"
href="#SBMLErrorCode_t">top of this documentation page</a> for a table
listing the possible values and their meanings. @endif The argument @p
errorId to this constructor I<can> be (but does not have to be) a
value from this @if clike enumeration. If it I<is> a value
from <a class="el" href="#SBMLErrorCode_t">SBMLErrorCode_t</a>, the
SBMLError class assumes the error is a low-level system or SBML layer
error and <em>prepends</em> a built-in, predefined error message to
any string passed in the argument C<details> to this constructor.  In
addition, all <a class="el"
href="#SBMLErrorCode_t">SBMLErrorCode_t</a> errors have associated
values for the C<severity> and C<category> codes, and these fields are
filled-in as well from the enumerations <a class="el"
href="#SBMLErrorSeverity_t">SBMLErrorSeverity_t</a> and <a class="el"
href="#SBMLErrorCategory_t">SBMLErrorCategory_t</a>,
respectively. @endif@if java set of constants.  If it @em
is one of the predefined error identifiers, the SBMLError class
assumes the error is a low-level system or SBML layer error and
<em>prepends</em> a built-in, predefined error message to any string
passed in the argument C<details> to this constructor.  In addition,
all the predefined error identifiers have associated values for the @p
severity and C<category> codes, and these fields are filled-in using
the libSBML defaults for each different error identifier. @endif
If the error identifier C<errorId> is a number greater than 99999, the
SBMLError class assumes the error was generated from another part of
the software and does not do additional filling in of values beyond
the default in the constructor itself.  This allows SBMLError to serve
as a base class for other errors, such as for user-defined validation
rules (see Validator).  Callers should fill in all the parameters with
suitable values if generating errors with codes greater than 99999 to
make maximum use of the SBMLError facilities.
@if clike As mentioned above, there are two other
enumerations, <a class="el"
href="#SBMLErrorSeverity_t">SBMLErrorSeverity_t</a> and <a class="el"
href="#SBMLErrorCategory_t">SBMLErrorCategory_t</a>, used for indicating
the severity and category of error for the predefined SBMLError codes.
The values passed in C<severity> and C<category> override the defaults
assigned based on the error code.  If the value of C<errorId> is a
value from <a class="el" href="#SBMLErrorCode_t">SBMLErrorCode_t</a>,
callers do not need to fill in C<severity> and C<category>.
Conversely, if C<errorId> is not a value from <a class="el"
href="#SBMLErrorCode_t">SBMLErrorCode_t</a>, callers can use other
values (not just those from <a class="el"
href="#SBMLErrorSeverity_t">SBMLErrorSeverity_t</a> and <a class="el"
href="#SBMLErrorCategory_t">SBMLErrorCategory_t</a>, but their own
special values) for C<severity> and @p
category. @endif@if java As mentioned above, 
there are additional constants defined for <a class="el"
href="#SBMLErrorSeverity_t">standard severity</a> and <a class="el"
href="#SBMLErrorCategory_t">standard category</a> codes, and every predefined 
error in libSBML has an associated value for severity and category taken
from these predefined sets.  These constants have symbol names
prefixed with C<LIBSBML_SEV_> and C<LIBSBML_CAT_>,
respectively.  If the value of C<errorId> is one of the standard error
codes, callers do not need to fill in C<severity> and C<category> in a
call to this constructor.  Conversely, if C<errorId> is not an existing
SBML-level error code, callers can use other values for C<severity> and
C<category>. @endif
Please see the top of the documentation for SBMLError for a longer
discussion of the possible error codes, their meanings, and their
applicability to different combinations of Level+Version of SBML.
@param errorId an unsigned int, the identification number of the error.
@param level the SBML Level of the SBML model
@param version the SBML Version within the Level of the SBML model
@param details a string containing additional details about the error.
If the error code in C<errorId> is one that is recognized by SBMLError,
the given message is I<appended> to a predefined message associated
with the given code.  If the error code is not recognized, the message
is stored as-is as the text of the error.
@param line an unsigned int, the line number at which the error occured.
@param column an unsigned int, the column number at which the error occured.
@param severity an integer indicating severity of the error.
@param category an integer indicating the category to which the error
belongs.

@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item SBMLError::SBMLError

Copy constructor; creates a copy of this SBMLError.


=back

=head2 CVTerm

Representation of MIRIAM-compliant controlled vocabulary annotation.
@htmlinclude libsbml-not-sbml-warning.html
CVTerm is a libSBML construct used as part of the libSBML support for
annotations conforming to the guidelines specified by MIRIAM ("Minimum
Information Requested in the Annotation of biochemical Models").  The
general scheme is as follows.  A set of RDF-based annotations attached
to a given SBML C<&lt;annotation&gt;> element are read by
RDFAnnotationParser and converted into a list of CVTerm objects.  Each
CVTerm object instance stores the following components of an annotation:

=over

<li>The qualifier, which can be a MIRIAM "biological qualifier", a
"model qualifier", or an unknown qualifier (as far as the CVTerm class
is concerned).  Qualifiers are used in MIRIAM to indicate the nature of
the relationship between the object being annotated and the resource.
In CVTerm, the qualifiers can be manipulated using the methods
getQualifierType(), setQualifierType(), and related methods.
<li>The resource, represent by a URI (note: not a URL).  In CVTerm, the
resource component can be manipulated using the methods addResource()
and removeResource().

=back



=over

=item CVTerm::CVTerm

Creates a new CVTerm, optionally with the given #QualifierType_t value
C<type>.
The possible qualifier types are MODEL_QUALIFIER and
BIOLOGICAL_QUALIFIER.  If the given #QualifierType_t value is not
given, this method defaults to using UNKNOWN_QUALIFIER.  The
#QualifierType_t type value can be set using the setQualifierType()
method.

@param type a #QualifierType_t value
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item CVTerm::CVTerm

Create a new CVTerm from the given XMLNode.
RDFAnnotations within a model are stored as a List of CVTerms.  This allows
the user to interact with the CVTerms directly.  When LibSBML reads in a 
model containing RDFAnnotations it parses them into a List of CVTerms and
when writing a model it parses the CVTerms into the appropriate annotation
structure.  This function creates a CVTerm from the XMLNode supplied.
@param node an XMLNode representing a CVTerm.
@note this method assumes that the XMLNode is of the correct form


=item CVTerm::CVTerm

Copy constructor; creates a copy of a CVTerm.
@param orig the CVTerm instance to copy.


=item CVTerm::clone

Creates and returns a deep copy of this CVTerm.
Returns a (deep) copy of this CVTerm.


=item CVTerm::getQualifierType

Returns the Qualifier Type code for this CVTerm.
Returns the #QualifierType_t value of this object or UNKNOWN_QUALIFIER
(default).



=item CVTerm::getModelQualifierType

Returns the Model QualifierType code for this CVTerm.
Returns the #ModelQualifierType_t value of this object or BQM_UNKNOWN
(default).



=item CVTerm::getBiologicalQualifierType

Returns the Biological QualifierType code for this CVTerm.
Returns the #BiolQualifierType_t value of this object or BQB_UNKNOWN
(default).



=item CVTerm::getResources

Returns the resources for this CVTerm.
Returns the XMLAttributes that store the resources of this CVTerm.


=item CVTerm::getResources

Returns the resources for this CVTerm.
Returns the XMLAttributes that store the resources of this CVTerm.


=item CVTerm::getNumResources

Returns the number of resources for this CVTerm.
Returns the number of resources in the set of XMLAttributes
of this CVTerm.


=item CVTerm::getResourceURI

Returns the value of the nth resource for this CVTerm.
@param n the index of the resource to query
Returns string representing the value of the nth resource
in the set of XMLAttributes of this CVTerm.
@note Since the values of the resource attributes in a CVTerm
are URIs this is a convenience function to facilitate
interaction with the CVTerm class.


=item CVTerm::setQualifierType

Sets the #QualifierType_t value of this CVTerm.
@param type the #QualifierType_t type value 


=item CVTerm::setModelQualifierType

Sets the #ModelQualifierType_t value of this CVTerm.
@param type the #ModelQualifierType_t value
@note If the Qualifier Type of this object is not MODEL_QUALIFIER,
then the ModelQualifierType_t will default to BQM_UNKNOWN.


=item CVTerm::setBiologicalQualifierType

Sets the #BiolQualifierType_t of this CVTerm.
@param type the #BiolQualifierType_t value
@note if the Qualifier Type of this object is not
BIOLOGICAL_QUALIFIER, then the #BiolQualifierType_t value will default
to BQB_UNKNOWN.


=item CVTerm::addResource

Adds a resource to the CVTerm.
@param resource string representing the resource; e.g.,
"http://www.geneontology.org/#GO:0005892"

@note this method adds the name "rdf:resource" to the attribute prior
to adding it to the resources in this CVTerm.


=item CVTerm::removeResource

Removes a resource from the CVTerm.
@param resource string representing the resource; e.g.,
"http://www.geneontology.org/#GO:0005892"



=item CVTerm::removeResource

Removes a resource from the CVTerm.
@param resource string representing the resource; e.g.,
"http://www.geneontology.org/#GO:0005892"

@deprecated libSBML internal


=item CVTerm::removeResource

Removes a resource from the CVTerm.
@param resource string representing the resource; e.g.,
"http://www.geneontology.org/#GO:0005892"

@deprecated libSBML internal


=item CVTerm::removeResource

Removes a resource from the CVTerm.
@param resource string representing the resource; e.g.,
"http://www.geneontology.org/#GO:0005892"

@deprecated libSBML internal


=item CVTerm::removeResource

Removes a resource from the CVTerm.
@param resource string representing the resource; e.g.,
"http://www.geneontology.org/#GO:0005892"

@deprecated libSBML internal


=back

=head2 ModelHistory

Representation of MIRIAM-compliant model history data.
@htmlinclude libsbml-not-sbml-warning.html
The SBML specification beginning with Level 2 Version 2 defines a
standard approach to recording model history and model creator
information in a form that complies with MIRIAM ("Minimum Information
Requested in the Annotation of biochemical Models", Nature
Biotechnology, vol. 23, no. 12, Dec. 2005).  LibSBML provides the
ModelHistory class as a convenience high-level interface for working
with model history data.
<!-- leave this next break as-is to work around some doxygen bug -->


=over

=back

=head2 ModelCreator

Representation of MIRIAM-compliant model creator data used
in ModelHistory. 
@htmlinclude libsbml-not-sbml-warning.html
The SBML specification beginning with Level 2 Version 2 defines a
standard approach to recording model history and model creator
information in a form that complies with MIRIAM ("Minimum Information
Requested in the Annotation of biochemical Models", Nature
Biotechnology, vol. 23, no. 12, Dec. 2005).  LibSBML provides the
ModelCreator class as a convenience high-level interface for working
with model creator data.
<!-- leave this next break as-is to work around some doxygen bug -->


=over

=back

=head2 Date

Representation of MIRIAM-compliant dates used in ModelHistory.
@htmlinclude libsbml-not-sbml-warning.html
A Date object stores a reasonably complete date representation,
consisting of the following fields:

=over


=item

I<year>: an unsigned int representing the year.

=item

I<month>: an unsigned int representing the month.

=item

I<day>: an unsigned int representing the day.

=item

I<hour>: an unsigned int representing the hour.

=item

I<minute>: an unsigned int representing the minute.

=item

I<second>: an unsigned int representing the second.

=item

I<sign>: an unsigned int representing the sign of the offset (0/1 equivalent to +/-). 

=item

I<hours> offset: an unsigned int representing the hoursOffset.

=item

I<minute> offset: an unsigned int representing the minutesOffset.

=back



=over

=item Date::Date

Creates a date optionally from the individual fields entered as numbers.
@param year an unsigned int representing the year.
@param month an unsigned int representing the month.
@param day an unsigned int representing the day.
@param hour an unsigned int representing the hour.
@param minute an unsigned int representing the minute.
@param second an unsigned int representing the second.
@param sign an unsigned int representing the sign of the offset 
(0/1 equivalent to +/-). 
@param hoursOffset an unsigned int representing the hoursOffset.
@param minutesOffset an unsigned int representing the minutesOffset.
@docnote The native C++ implementation of this method defines a
default argument value.  In the documentation generated for different
libSBML language bindings, you may or may not see corresponding
arguments in the method declarations.  For example, in Java, a default
argument is handled by declaring two separate methods, with one of
them having the argument and the other one lacking the argument.
However, the libSBML documentation will be I<identical> for both
methods.  Consequently, if you are reading this and do not see an
argument even though one is described, please look for descriptions of
other variants of this method near where this one appears in the
documentation.



=item Date::Date

Creates a date from a string.
@param date a string representing the date.
@note the string should be in W3CDTF format 
YYYY-MM-DDThh:mm:ssTZD (eg 1997-07-16T19:20:30+01:00)
where TZD is the time zone designator.


=item Date::Date

Copy constructor; creates a copy of this Date.


=item Date::clone

Returns a copy of this Date.
Returns a (deep) copy of this Date.


=item Date::getYear

Returns the year from this Date.
Returns the year from this Date.


=item Date::getMonth

Returns the month from this Date.
Returns the month from this Date.


=item Date::getDay

Returns the day from this Date.
Returns the day from this Date.


=item Date::getHour

Returns the hour from this Date.
Returns the hour from this Date.


=item Date::getMinute

Returns the minute from this Date.
Returns the minute from this Date.


=item Date::getSecond

Returns the seconds from this Date.
Returns the seconds from this Date.


=item Date::getSignOffset

Returns the sign of the offset from this Date.
Returns the sign of the offset from this Date.


=item Date::getHoursOffset

Returns the hours of the offset from this Date.
Returns the hours of the offset from this Date.


=item Date::getMinutesOffset

Returns the minutes of the offset from this Date.
Returns the minutes of the offset from this Date.


=item Date::getDateAsString

Returns the Date as a string.
Returns the date as a string.


=item Date::setYear

Sets the value of the year checking appropriateness.
@param year an unsigned int representing the year to set.  


=item Date::setMonth

Sets the value of the month checking appropriateness.
@param month an unsigned int representing the month to set  


=item Date::setDay

Sets the value of the day checking appropriateness.
@param day an unsigned int representing the day to set.  


=item Date::setHour

Sets the value of the hour checking appropriateness.
@param hour an unsigned int representing the hour to set.  


=item Date::setMinute

Sets the value of the minute checking appropriateness.
@param minute an unsigned int representing the minute to set.  


=item Date::setSecond

Sets the value of the second checking appropriateness.
@param second an unsigned int representing the second to set.  


=item Date::setSignOffset

Sets the value of the offset sign checking appropriateness.
@param sign an unsigned int representing 
the sign of the offset to set.  


=item Date::setHoursOffset

Sets the value of the offset hour checking appropriateness.
@param hoursOffset an unsigned int representing the hours of the 
offset to set.  


=item Date::setMinutesOffset

Sets the value of the offset minutes checking appropriateness.
@param minutesOffset an unsigned int representing the minutes of the 
offset to set.  


=item Date::setDateAsString

Sets the value of the date string checking appropriateness.
@param date a string representing the date.
@note the string should be in W3CDTF format 
YYYY-MM-DDThh:mm:ssTZD (eg 1997-07-16T19:20:30+01:00)
where TZD is the time zone designator.


=item Date::parseDateStringToNumbers

Sets the value of the individual numbers from the date 
as a string.
@deprecated libSBML internal


=item Date::parseDateNumbersToString

Sets the value of the date as a string from the individual numbers.
@deprecated libSBML internal


=item Date::parseDateNumbersToString

Sets the value of the date as a string from the individual numbers.
@deprecated libSBML internal


=item Date::parseDateNumbersToString

Sets the value of the date as a string from the individual numbers.
@deprecated libSBML internal


=item Date::parseDateNumbersToString

Sets the value of the date as a string from the individual numbers.
@deprecated libSBML internal


=item Date::parseDateNumbersToString

Sets the value of the date as a string from the individual numbers.
@deprecated libSBML internal


=item Date::parseDateNumbersToString

Sets the value of the date as a string from the individual numbers.
@deprecated libSBML internal


=item Date::parseDateNumbersToString

Sets the value of the date as a string from the individual numbers.
@deprecated libSBML internal


=item Date::parseDateNumbersToString

Sets the value of the date as a string from the individual numbers.
@deprecated libSBML internal


=item Date::parseDateNumbersToString

Sets the value of the date as a string from the individual numbers.
@deprecated libSBML internal


=item Date::parseDateNumbersToString

Sets the value of the date as a string from the individual numbers.
@deprecated libSBML internal


=item Date::parseDateNumbersToString

Sets the value of the date as a string from the individual numbers.
@deprecated libSBML internal


=item ModelCreator::ModelCreator

Creates a new ModelCreator.


=item ModelCreator::ModelCreator

Creates a new ModelCreator from an XMLNode.
@param creator the XMLNode from which to create the ModelCreator.


=item ModelCreator::ModelCreator

Copy constructor; creates a copy of the ModelCreator.


=item ModelCreator::clone

Creates and returns a copy of this ModelCreator.
Returns a (deep) copy of this ModelCreator.


=item ModelCreator::getFamilyName

Returns the familyName from the ModelCreator.
Returns familyName from the ModelCreator.


=item ModelCreator::getGivenName

Returns the givenName from the ModelCreator.
Returns givenName from the ModelCreator.


=item ModelCreator::getEmail

Returns the email from the ModelCreator.
Returns email from the ModelCreator.


=item ModelCreator::getOrganization

Returns the organization from the ModelCreator.
Returns organization from the ModelCreator.


=item ModelCreator::getOrganisation

Returns the organization from the ModelCreator.
Returns organization from the ModelCreator.
@deprecated libSBML internal


=item ModelCreator::isSetFamilyName

Predicate returning C<true> or C<false> depending on whether this
ModelCreator's familyName has been set.
Returns C<true> if the familyName of this ModelCreator has been set, C<false> otherwise.


=item ModelCreator::isSetGivenName

Predicate returning C<true> or C<false> depending on whether this
ModelCreator's givenName has been set.
Returns C<true> if the givenName of this ModelCreator has been set, C<false> otherwise.


=item ModelCreator::isSetEmail

Predicate returning C<true> or C<false> depending on whether this
ModelCreator's email has been set.
Returns C<true> if the email of this ModelCreator has been set, C<false> otherwise.


=item ModelCreator::isSetOrganization

Predicate returning C<true> or C<false> depending on whether this
ModelCreator's organization has been set.
Returns C<true> if the organization of this ModelCreator has been set, C<false> otherwise.


=item ModelCreator::isSetOrganisation

Predicate returning C<true> or C<false> depending on whether this
ModelCreator's organization has been set.
Returns C<true> if the organization of this ModelCreator has been set, C<false> otherwise.
@deprecated libSBML internal


=item ModelCreator::setFamilyName

Sets the family name
@param familyName a string representing the familyName of the ModelCreator. 


=item ModelCreator::setGivenName

Sets the given name
@param givenName a string representing the givenName of the ModelCreator. 


=item ModelCreator::setEmail

Sets the email
@param email a string representing the email of the ModelCreator. 


=item ModelCreator::setOrganization

Sets the organization
@param organization a string representing the organization of the 
ModelCreator. 



=item ModelCreator::setOrganisation

Sets the organization
@param organization a string representing the organization of the 
ModelCreator. 

@deprecated libSBML internal


=item ModelCreator::unsetFamilyName

Unsets the familyName of this ModelCreator.


=item ModelCreator::unsetGivenName

Unsets the givenName of this ModelCreator.


=item ModelCreator::unsetEmail

Unsets the email of this ModelCreator.


=item ModelCreator::unsetOrganization

Unsets the organization of this ModelCreator.


=item ModelCreator::unsetOrganisation

Unsets the organization of this ModelCreator.
@deprecated libSBML internal


=item ModelCreator::unsetOrganisation

Unsets the organization of this ModelCreator.
@deprecated libSBML internal


=item ModelCreator::unsetOrganisation

Unsets the organization of this ModelCreator.
@deprecated libSBML internal


=item ModelCreator::unsetOrganisation

Unsets the organization of this ModelCreator.
@deprecated libSBML internal


=item ModelCreator::unsetOrganisation

Unsets the organization of this ModelCreator.
@deprecated libSBML internal


=item ModelHistory::ModelHistory

Creates a new ModelHistory.


=item ModelHistory::ModelHistory

Copy constructor; creates a copy of the ModelHistory.


=item ModelHistory::clone

Creates and returns a copy of this ModelHistory.
Returns a (deep) copy of this ModelHistory.


=item ModelHistory::getCreatedDate

Returns the createdDate from the ModelHistory.
Returns Date object representing the createdDate
from the ModelHistory.


=item ModelHistory::getModifiedDate

Returns the modifiedDate from the ModelHistory.
Returns Date object representing the modifiedDate
from the ModelHistory.


=item ModelHistory::isSetCreatedDate

Predicate returning C<true> or C<false> depending on whether this
ModelHistory's createdDate has been set.
Returns C<true> if the createdDate of this ModelHistory has been set, 
C<false> otherwise.


=item ModelHistory::isSetModifiedDate

Predicate returning C<true> or C<false> depending on whether this
ModelHistory's modifiedDate has been set.
Returns C<true> if the modifiedDate of this ModelHistory has been set, 
C<false> otherwise.


=item ModelHistory::setCreatedDate

Sets the createdDate.
@param date a Date object representing the date
the ModelHistory was created. 


=item ModelHistory::setModifiedDate

Sets the modifiedDate.
@param date a Date object representing the date
the ModelHistory was modified. 


=item ModelHistory::addModifiedDate

Adds a modifiedDate.
@param date a Date object representing the date
the ModelHistory was modified. 


=item ModelHistory::getListModifiedDates

Get the List of ModifiedDate objects in this 
ModelHistory.

Returns the list of ModifiedDates for this ModelHistory.


=item ModelHistory::getModifiedDate

Get the nth Date object in the list of ModifiedDates
in this ModelHistory.
Returns the nth Date in the list of ModifiedDates of 
this ModelHistory.


=item ModelHistory::getNumModifiedDates

Get the number of ModifiedDate objects in this 
ModelHistory.

Returns the number of ModifiedDates in this 
ModelHistory.



=item ModelHistory::addCreator

Adds a copy of the given ModelCreator object to 
this ModelHistory.
@param mc the ModelCreator to add


=item ModelHistory::getListCreators

Get the List of ModelCreator objects in this 
ModelHistory.

Returns the list of ModelCreators for this ModelHistory.


=item ModelHistory::getCreator

Get the nth ModelCreator object in this ModelHistory.
Returns the nth ModelCreator of this ModelHistory.


=item ModelHistory::getNumCreators

Get the number of ModelCreator objects in this 
ModelHistory.

Returns the number of ModelCreators in this 
ModelHistory.



=item ModelHistory::getNumCreators

Get the number of ModelCreator objects in this 
ModelHistory.

Returns the number of ModelCreators in this 
ModelHistory.

@deprecated libSBML internal


=item ModelHistory::getNumCreators

Get the number of ModelCreator objects in this 
ModelHistory.

Returns the number of ModelCreators in this 
ModelHistory.

@deprecated libSBML internal


=item ModelHistory::getNumCreators

Get the number of ModelCreator objects in this 
ModelHistory.

Returns the number of ModelCreators in this 
ModelHistory.

@deprecated libSBML internal


=item ModelHistory::getNumCreators

Get the number of ModelCreator objects in this 
ModelHistory.

Returns the number of ModelCreators in this 
ModelHistory.

@deprecated libSBML internal


=back

=head2 RDFAnnotationParser

Read/write/manipulate RDF annotations stored in SBML
annotation elements.
@htmlinclude libsbml-not-sbml-warning.html
RDFAnnotationParser is a libSBML construct used as part of the libSBML
support for annotations conforming to the guidelines specified by MIRIAM
("Minimum Information Requested in the Annotation of biochemical
Models", Nature Biotechnology, vol. 23, no. 12, Dec. 2005).  Section 6
of the SBML Level 2 Version 4 specification defines a recommended way
of encoding MIRIAM information as RDF annotations in SBML.  The general
scheme is as follows.  A set of RDF-based annotations attached to a
given SBML C<&lt;annotation&gt;> element are read by
RDFAnnotationParser and converted into a list of CVTerm objects.  There
are different versions of the main method, parseRDFAnnotation(), used
depending on whether the annotation in question concerns the MIRIAM
model history or other MIRIAM resource annotations.  A special object
class (ModelHistory) is used to make it easier to manipulate model
history annotations.
All of the methods on RDFAnnotationParser are static; the class exists
only to encapsulate the annotation and CVTerm parsing and manipulation
functionality.


=over

=item RDFAnnotationParser::parseRDFAnnotation

Parses an annotation (given as an XMLNode tree) into a list of
CVTerms.

This is used to take an annotation that has been read into an SBML
model, identify the RDF elements within it, and create a list of
corresponding CVTerms.
@param annotation XMLNode containing the annotation.
@param CVTerms list of CVTerms to be created.
@see parseRDFAnnotation(const XMLNode  annotation)


=item RDFAnnotationParser::parseRDFAnnotation

Parses an annotation into a ModelHistory class instance.
This is used to take an annotation that has been read into an SBML
model, identify the RDF elements representing model history
information, and create a list of corresponding CVTerms.
@param annotation XMLNode containing the annotation.
Returns a pointer to the ModelHistory created.
@see parseRDFAnnotation(const XMLNode  annotation, List  CVTerms)


=item RDFAnnotationParser::createAnnotation

Creates a blank annotation and returns the XMLNode corresonding to it.
The annotation created by this method is a completely empty SBML
C<&lt;annotation&gt;> element.  One use for this is to
then call createRDFAnnotation() to construct RDF content for this
empty annotation.
Returns a pointer to an XMLNode for the annotation
@see createRDFAnnotation()


=item RDFAnnotationParser::createRDFAnnotation

Creates blank RDF annotation content organized in the form defined in
Section 6 of the SBML Level 2 Version 4 specification .
The annotation created by this method has namespace declarations for
all the relevant XML namespaces used in RDF annotations and also has
an empty RDF element.  Note that this is not the containing
C<&lt;annotation&gt;> element; the method createAnnotation()
is available for that purpose.
Returns a pointer to an XMLNode


=item RDFAnnotationParser::deleteRDFAnnotation

Deletes any RDF annotation found in the given XMLNode tree and returns
any remaining annotation content.
The name of the given XMLNode must be "annotation", or else this
method returns NULL.
@param annotation the annotation tree within which the RDF annotation
is to be found and deleted
Returns the XMLNode structure with any RDF annotations deleted


=item RDFAnnotationParser::createRDFDescription

Takes an SBML object and creates an XMLNode corresponding to an
RDF "Description" element.
This method is a handy way of creating RDF description objects linked
by the appropriate "metaid" field, for insertion into RDF annotations
in a model.  (Note that this method does not create a complete
annotation; it only creates a description element.  For creating empty
RDF annotations that can serve as containers for RDF descriptions, see
createRDFAnnotation().

@param object the object to be annotated
Returns a new XMLNode containing the "rdf:about" structure for an
RDF "Description" element.
@see createRDFAnnotation()


=item RDFAnnotationParser::createCVTerms

Takes a list of CVTerms and creates a the RDF "Description" element.
This essentially takes the given SBML object, reads out the CVTerms
attached to it, calls createRDFDescriptiom() to create an RDF
"Description" element to hold the terms and adds each term with
appropriate qualifiers.
@param object the SBML object to start from
Returns the XMLNode tree corresponding to the Description element of
an RDF annotation.


=item RDFAnnotationParser::parseCVTerms

Takes a list of CVTerms and creates a complete SBML annotation
around it.
This essentially takes the given SBML object, calls createCVTerms
to read out the CVTerms
attached to it, calls createRDFAnnotation() to create an RDF
annotation to hold the terms, and finally calls createAnnotation() to
wrap the result as an SBML C<&lt;annotation&gt;> element.
@param object the SBML object to start from
Returns the XMLNode tree corresponding to the annotation.


=item RDFAnnotationParser::parseModelHistory

Takes an SBML Model object, reads off the model history information
stored in it, and creates a complete SBML annotation to store that
history.

@param object a Model
Returns the XMLNode corresponding to an annotation containing 
MIRIAM-compliant model history information in RDF format


=cut

# ---------- BASE METHODS -------------

package LibSBML;

sub TIEHASH {
    my ($classname,$obj) = @_;
    return bless $obj, $classname;
}

sub CLEAR { }

sub FIRSTKEY { }

sub NEXTKEY { }

sub FETCH {
    my ($self,$field) = @_;
    my $member_func = "swig_${field}_get";
    $self->$member_func();
}

sub STORE {
    my ($self,$field,$newval) = @_;
    my $member_func = "swig_${field}_set";
    $self->$member_func($newval);
}

sub this {
    my $ptr = shift;
    return tied(%$ptr);
}


# ------- FUNCTION WRAPPERS --------

package LibSBML;

*endl = *LibSBMLc::endl;
*getLibSBMLVersion = *LibSBMLc::getLibSBMLVersion;
*getLibSBMLDottedVersion = *LibSBMLc::getLibSBMLDottedVersion;
*getLibSBMLVersionString = *LibSBMLc::getLibSBMLVersionString;
*readSBML = *LibSBMLc::readSBML;
*readSBMLFromString = *LibSBMLc::readSBMLFromString;
*writeSBML = *LibSBMLc::writeSBML;
*writeSBMLToString = *LibSBMLc::writeSBMLToString;
*SBMLTypeCode_toString = *LibSBMLc::SBMLTypeCode_toString;
*UnitKind_equals = *LibSBMLc::UnitKind_equals;
*UnitKind_forName = *LibSBMLc::UnitKind_forName;
*UnitKind_toString = *LibSBMLc::UnitKind_toString;
*UnitKind_isValidUnitKindString = *LibSBMLc::UnitKind_isValidUnitKindString;
*readMathMLFromString = *LibSBMLc::readMathMLFromString;
*writeMathMLToString = *LibSBMLc::writeMathMLToString;
*parseFormula = *LibSBMLc::parseFormula;
*formulaToString = *LibSBMLc::formulaToString;

############# Class : LibSBML::OStream ##############

package LibSBML::OStream;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( LibSBML );
%OWNER = ();
%ITERATORS = ();
*COUT = *LibSBMLc::OStream_COUT;
*CERR = *LibSBMLc::OStream_CERR;
*CLOG = *LibSBMLc::OStream_CLOG;
sub new {
    my $pkg = shift;
    my $self = LibSBMLc::new_OStream(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        LibSBMLc::delete_OStream($self);
        delete $OWNER{$self};
    }
}

*get_ostream = *LibSBMLc::OStream_get_ostream;
*endl = *LibSBMLc::OStream_endl;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : LibSBML::OStringStream ##############

package LibSBML::OStringStream;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( LibSBML::OStream LibSBML );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my $self = LibSBMLc::new_OStringStream(@_);
    bless $self, $pkg if defined($self);
}

*str = *LibSBMLc::OStringStream_str;
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        LibSBMLc::delete_OStringStream($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : LibSBML::SBMLReader ##############

package LibSBML::SBMLReader;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( LibSBML );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my $self = LibSBMLc::new_SBMLReader(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        LibSBMLc::delete_SBMLReader($self);
        delete $OWNER{$self};
    }
}

*readSBML = *LibSBMLc::SBMLReader_readSBML;
*readSBMLFromString = *LibSBMLc::SBMLReader_readSBMLFromString;
*hasZlib = *LibSBMLc::SBMLReader_hasZlib;
*hasBzip2 = *LibSBMLc::SBMLReader_hasBzip2;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : LibSBML::SBMLWriter ##############

package LibSBML::SBMLWriter;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( LibSBML );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my $self = LibSBMLc::new_SBMLWriter(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        LibSBMLc::delete_SBMLWriter($self);
        delete $OWNER{$self};
    }
}

*setProgramName = *LibSBMLc::SBMLWriter_setProgramName;
*setProgramVersion = *LibSBMLc::SBMLWriter_setProgramVersion;
*writeSBML = *LibSBMLc::SBMLWriter_writeSBML;
*writeToString = *LibSBMLc::SBMLWriter_writeToString;
*hasZlib = *LibSBMLc::SBMLWriter_hasZlib;
*hasBzip2 = *LibSBMLc::SBMLWriter_hasBzip2;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : LibSBML::SBase ##############

package LibSBML::SBase;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( LibSBML );
%OWNER = ();
%ITERATORS = ();
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        LibSBMLc::delete_SBase($self);
        delete $OWNER{$self};
    }
}

*clone = *LibSBMLc::SBase_clone;
*getMetaId = *LibSBMLc::SBase_getMetaId;
*getId = *LibSBMLc::SBase_getId;
*getName = *LibSBMLc::SBase_getName;
*getNotes = *LibSBMLc::SBase_getNotes;
*getNotesString = *LibSBMLc::SBase_getNotesString;
*getAnnotation = *LibSBMLc::SBase_getAnnotation;
*getAnnotationString = *LibSBMLc::SBase_getAnnotationString;
*getNamespaces = *LibSBMLc::SBase_getNamespaces;
*getSBMLDocument = *LibSBMLc::SBase_getSBMLDocument;
*getParentSBMLObject = *LibSBMLc::SBase_getParentSBMLObject;
*getAncestorOfType = *LibSBMLc::SBase_getAncestorOfType;
*getSBOTerm = *LibSBMLc::SBase_getSBOTerm;
*getSBOTermID = *LibSBMLc::SBase_getSBOTermID;
*getLine = *LibSBMLc::SBase_getLine;
*getColumn = *LibSBMLc::SBase_getColumn;
*isSetMetaId = *LibSBMLc::SBase_isSetMetaId;
*isSetId = *LibSBMLc::SBase_isSetId;
*isSetName = *LibSBMLc::SBase_isSetName;
*isSetNotes = *LibSBMLc::SBase_isSetNotes;
*isSetAnnotation = *LibSBMLc::SBase_isSetAnnotation;
*isSetSBOTerm = *LibSBMLc::SBase_isSetSBOTerm;
*setMetaId = *LibSBMLc::SBase_setMetaId;
*setId = *LibSBMLc::SBase_setId;
*setName = *LibSBMLc::SBase_setName;
*setAnnotation = *LibSBMLc::SBase_setAnnotation;
*appendAnnotation = *LibSBMLc::SBase_appendAnnotation;
*setNotes = *LibSBMLc::SBase_setNotes;
*appendNotes = *LibSBMLc::SBase_appendNotes;
*setSBMLDocument = *LibSBMLc::SBase_setSBMLDocument;
*setParentSBMLObject = *LibSBMLc::SBase_setParentSBMLObject;
*setSBOTerm = *LibSBMLc::SBase_setSBOTerm;
*setNamespaces = *LibSBMLc::SBase_setNamespaces;
*unsetMetaId = *LibSBMLc::SBase_unsetMetaId;
*unsetId = *LibSBMLc::SBase_unsetId;
*unsetName = *LibSBMLc::SBase_unsetName;
*unsetNotes = *LibSBMLc::SBase_unsetNotes;
*unsetAnnotation = *LibSBMLc::SBase_unsetAnnotation;
*unsetSBOTerm = *LibSBMLc::SBase_unsetSBOTerm;
*addCVTerm = *LibSBMLc::SBase_addCVTerm;
*getNumCVTerms = *LibSBMLc::SBase_getNumCVTerms;
*getCVTerm = *LibSBMLc::SBase_getCVTerm;
*unsetCVTerms = *LibSBMLc::SBase_unsetCVTerms;
*getResourceBiologicalQualifier = *LibSBMLc::SBase_getResourceBiologicalQualifier;
*getResourceModelQualifier = *LibSBMLc::SBase_getResourceModelQualifier;
*getModel = *LibSBMLc::SBase_getModel;
*getLevel = *LibSBMLc::SBase_getLevel;
*getVersion = *LibSBMLc::SBase_getVersion;
*getTypeCode = *LibSBMLc::SBase_getTypeCode;
*getElementName = *LibSBMLc::SBase_getElementName;
*toSBML = *LibSBMLc::SBase_toSBML;
*read = *LibSBMLc::SBase_read;
*write = *LibSBMLc::SBase_write;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : LibSBML::ListOf ##############

package LibSBML::ListOf;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( LibSBML::SBase LibSBML );
%OWNER = ();
%ITERATORS = ();
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        LibSBMLc::delete_ListOf($self);
        delete $OWNER{$self};
    }
}

sub new {
    my $pkg = shift;
    my $self = LibSBMLc::new_ListOf(@_);
    bless $self, $pkg if defined($self);
}

*clone = *LibSBMLc::ListOf_clone;
*append = *LibSBMLc::ListOf_append;
sub appendAndOwn {
  $_[1]->DISOWN() if defined $_[1];
  return LibSBMLc::ListOf_appendAndOwn(@_);
}

*get = *LibSBMLc::ListOf_get;
*clear = *LibSBMLc::ListOf_clear;
*remove = *LibSBMLc::ListOf_remove;
*size = *LibSBMLc::ListOf_size;
*setSBMLDocument = *LibSBMLc::ListOf_setSBMLDocument;
*setParentSBMLObject = *LibSBMLc::ListOf_setParentSBMLObject;
*getTypeCode = *LibSBMLc::ListOf_getTypeCode;
*getItemTypeCode = *LibSBMLc::ListOf_getItemTypeCode;
*getElementName = *LibSBMLc::ListOf_getElementName;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : LibSBML::Model ##############

package LibSBML::Model;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( LibSBML::SBase LibSBML );
%OWNER = ();
%ITERATORS = ();
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        LibSBMLc::delete_Model($self);
        delete $OWNER{$self};
    }
}

sub new {
    my $pkg = shift;
    my $self = LibSBMLc::new_Model(@_);
    bless $self, $pkg if defined($self);
}

*clone = *LibSBMLc::Model_clone;
*getModelHistory = *LibSBMLc::Model_getModelHistory;
*isSetModelHistory = *LibSBMLc::Model_isSetModelHistory;
*setModelHistory = *LibSBMLc::Model_setModelHistory;
*unsetModelHistory = *LibSBMLc::Model_unsetModelHistory;
*addFunctionDefinition = *LibSBMLc::Model_addFunctionDefinition;
*addUnitDefinition = *LibSBMLc::Model_addUnitDefinition;
*addCompartmentType = *LibSBMLc::Model_addCompartmentType;
*addSpeciesType = *LibSBMLc::Model_addSpeciesType;
*addCompartment = *LibSBMLc::Model_addCompartment;
*addSpecies = *LibSBMLc::Model_addSpecies;
*addParameter = *LibSBMLc::Model_addParameter;
*addInitialAssignment = *LibSBMLc::Model_addInitialAssignment;
*addRule = *LibSBMLc::Model_addRule;
*addConstraint = *LibSBMLc::Model_addConstraint;
*addReaction = *LibSBMLc::Model_addReaction;
*addEvent = *LibSBMLc::Model_addEvent;
*createFunctionDefinition = *LibSBMLc::Model_createFunctionDefinition;
*createUnitDefinition = *LibSBMLc::Model_createUnitDefinition;
*createUnit = *LibSBMLc::Model_createUnit;
*createCompartmentType = *LibSBMLc::Model_createCompartmentType;
*createSpeciesType = *LibSBMLc::Model_createSpeciesType;
*createCompartment = *LibSBMLc::Model_createCompartment;
*createSpecies = *LibSBMLc::Model_createSpecies;
*createParameter = *LibSBMLc::Model_createParameter;
*createInitialAssignment = *LibSBMLc::Model_createInitialAssignment;
*createAlgebraicRule = *LibSBMLc::Model_createAlgebraicRule;
*createAssignmentRule = *LibSBMLc::Model_createAssignmentRule;
*createRateRule = *LibSBMLc::Model_createRateRule;
*createConstraint = *LibSBMLc::Model_createConstraint;
*createReaction = *LibSBMLc::Model_createReaction;
*createReactant = *LibSBMLc::Model_createReactant;
*createProduct = *LibSBMLc::Model_createProduct;
*createModifier = *LibSBMLc::Model_createModifier;
*createKineticLaw = *LibSBMLc::Model_createKineticLaw;
*createKineticLawParameter = *LibSBMLc::Model_createKineticLawParameter;
*createEvent = *LibSBMLc::Model_createEvent;
*createEventAssignment = *LibSBMLc::Model_createEventAssignment;
*setAnnotation = *LibSBMLc::Model_setAnnotation;
*appendAnnotation = *LibSBMLc::Model_appendAnnotation;
sub getListOfFunctionDefinitions {
  my $lox = LibSBMLc::Model_getListOfFunctionDefinitions(@_);
  my @lox = ();
  for (my $i=0; $i<$lox->size(); $i++) {
    push @lox, $lox->get($i);
  }
  return wantarray ? @lox : $lox;
}

sub getListOfUnitDefinitions {
  my $lox = LibSBMLc::Model_getListOfUnitDefinitions(@_);
  my @lox = ();
  for (my $i=0; $i<$lox->size(); $i++) {
    push @lox, $lox->get($i);
  }
  return wantarray ? @lox : $lox;
}

sub getListOfCompartmentTypes {
  my $lox = LibSBMLc::Model_getListOfCompartmentTypes(@_);
  my @lox = ();
  for (my $i=0; $i<$lox->size(); $i++) {
    push @lox, $lox->get($i);
  }
  return wantarray ? @lox : $lox;
}

sub getListOfSpeciesTypes {
  my $lox = LibSBMLc::Model_getListOfSpeciesTypes(@_);
  my @lox = ();
  for (my $i=0; $i<$lox->size(); $i++) {
    push @lox, $lox->get($i);
  }
  return wantarray ? @lox : $lox;
}

sub getListOfCompartments {
  my $lox = LibSBMLc::Model_getListOfCompartments(@_);
  my @lox = ();
  for (my $i=0; $i<$lox->size(); $i++) {
    push @lox, $lox->get($i);
  }
  return wantarray ? @lox : $lox;
}

sub getListOfSpecies {
  my $lox = LibSBMLc::Model_getListOfSpecies(@_);
  my @lox = ();
  for (my $i=0; $i<$lox->size(); $i++) {
    push @lox, $lox->get($i);
  }
  return wantarray ? @lox : $lox;
}

sub getListOfParameters {
  my $lox = LibSBMLc::Model_getListOfParameters(@_);
  my @lox = ();
  for (my $i=0; $i<$lox->size(); $i++) {
    push @lox, $lox->get($i);
  }
  return wantarray ? @lox : $lox;
}

sub getListOfInitialAssignments {
  my $lox = LibSBMLc::Model_getListOfInitialAssignments(@_);
  my @lox = ();
  for (my $i=0; $i<$lox->size(); $i++) {
    push @lox, $lox->get($i);
  }
  return wantarray ? @lox : $lox;
}

sub getListOfRules {
  my $lox = LibSBMLc::Model_getListOfRules(@_);
  my @lox = ();
  for (my $i=0; $i<$lox->size(); $i++) {
    push @lox, $lox->get($i);
  }
  return wantarray ? @lox : $lox;
}

sub getListOfConstraints {
  my $lox = LibSBMLc::Model_getListOfConstraints(@_);
  my @lox = ();
  for (my $i=0; $i<$lox->size(); $i++) {
    push @lox, $lox->get($i);
  }
  return wantarray ? @lox : $lox;
}

sub getListOfReactions {
  my $lox = LibSBMLc::Model_getListOfReactions(@_);
  my @lox = ();
  for (my $i=0; $i<$lox->size(); $i++) {
    push @lox, $lox->get($i);
  }
  return wantarray ? @lox : $lox;
}

sub getListOfEvents {
  my $lox = LibSBMLc::Model_getListOfEvents(@_);
  my @lox = ();
  for (my $i=0; $i<$lox->size(); $i++) {
    push @lox, $lox->get($i);
  }
  return wantarray ? @lox : $lox;
}

*getFunctionDefinition = *LibSBMLc::Model_getFunctionDefinition;
*getUnitDefinition = *LibSBMLc::Model_getUnitDefinition;
*getCompartmentType = *LibSBMLc::Model_getCompartmentType;
*getSpeciesType = *LibSBMLc::Model_getSpeciesType;
*getCompartment = *LibSBMLc::Model_getCompartment;
*getSpecies = *LibSBMLc::Model_getSpecies;
*getParameter = *LibSBMLc::Model_getParameter;
*getInitialAssignment = *LibSBMLc::Model_getInitialAssignment;
*getRule = *LibSBMLc::Model_getRule;
*getConstraint = *LibSBMLc::Model_getConstraint;
*getReaction = *LibSBMLc::Model_getReaction;
*getEvent = *LibSBMLc::Model_getEvent;
*getNumFunctionDefinitions = *LibSBMLc::Model_getNumFunctionDefinitions;
*getNumUnitDefinitions = *LibSBMLc::Model_getNumUnitDefinitions;
*getNumCompartmentTypes = *LibSBMLc::Model_getNumCompartmentTypes;
*getNumSpeciesTypes = *LibSBMLc::Model_getNumSpeciesTypes;
*getNumCompartments = *LibSBMLc::Model_getNumCompartments;
*getNumSpecies = *LibSBMLc::Model_getNumSpecies;
*getNumSpeciesWithBoundaryCondition = *LibSBMLc::Model_getNumSpeciesWithBoundaryCondition;
*getNumParameters = *LibSBMLc::Model_getNumParameters;
*getNumInitialAssignments = *LibSBMLc::Model_getNumInitialAssignments;
*getNumRules = *LibSBMLc::Model_getNumRules;
*getNumConstraints = *LibSBMLc::Model_getNumConstraints;
*getNumReactions = *LibSBMLc::Model_getNumReactions;
*getNumEvents = *LibSBMLc::Model_getNumEvents;
*convertToL1 = *LibSBMLc::Model_convertToL1;
*convertToL2 = *LibSBMLc::Model_convertToL2;
*isBoolean = *LibSBMLc::Model_isBoolean;
*setSBMLDocument = *LibSBMLc::Model_setSBMLDocument;
*setParentSBMLObject = *LibSBMLc::Model_setParentSBMLObject;
*getTypeCode = *LibSBMLc::Model_getTypeCode;
*getElementName = *LibSBMLc::Model_getElementName;
*populateListFormulaUnitsData = *LibSBMLc::Model_populateListFormulaUnitsData;
*isPopulatedListFormulaUnitsData = *LibSBMLc::Model_isPopulatedListFormulaUnitsData;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : LibSBML::SBMLDocument ##############

package LibSBML::SBMLDocument;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( LibSBML::SBase LibSBML );
%OWNER = ();
%ITERATORS = ();
*getDefaultLevel = *LibSBMLc::SBMLDocument_getDefaultLevel;
*getDefaultVersion = *LibSBMLc::SBMLDocument_getDefaultVersion;
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        LibSBMLc::delete_SBMLDocument($self);
        delete $OWNER{$self};
    }
}

sub new {
    my $pkg = shift;
    my $self = LibSBMLc::new_SBMLDocument(@_);
    bless $self, $pkg if defined($self);
}

*clone = *LibSBMLc::SBMLDocument_clone;
*getModel = *LibSBMLc::SBMLDocument_getModel;
*setLevelAndVersion = *LibSBMLc::SBMLDocument_setLevelAndVersion;
*setModel = *LibSBMLc::SBMLDocument_setModel;
*createModel = *LibSBMLc::SBMLDocument_createModel;
*setConsistencyChecks = *LibSBMLc::SBMLDocument_setConsistencyChecks;
*checkConsistency = *LibSBMLc::SBMLDocument_checkConsistency;
*checkInternalConsistency = *LibSBMLc::SBMLDocument_checkInternalConsistency;
*checkL1Compatibility = *LibSBMLc::SBMLDocument_checkL1Compatibility;
*checkL2v1Compatibility = *LibSBMLc::SBMLDocument_checkL2v1Compatibility;
*checkL2v2Compatibility = *LibSBMLc::SBMLDocument_checkL2v2Compatibility;
*checkL2v3Compatibility = *LibSBMLc::SBMLDocument_checkL2v3Compatibility;
*checkL2v4Compatibility = *LibSBMLc::SBMLDocument_checkL2v4Compatibility;
*getError = *LibSBMLc::SBMLDocument_getError;
*getNumErrors = *LibSBMLc::SBMLDocument_getNumErrors;
*printErrors = *LibSBMLc::SBMLDocument_printErrors;
*setSBMLDocument = *LibSBMLc::SBMLDocument_setSBMLDocument;
*getTypeCode = *LibSBMLc::SBMLDocument_getTypeCode;
*getElementName = *LibSBMLc::SBMLDocument_getElementName;
*getErrorLog = *LibSBMLc::SBMLDocument_getErrorLog;
*getNamespaces = *LibSBMLc::SBMLDocument_getNamespaces;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : LibSBML::FunctionDefinition ##############

package LibSBML::FunctionDefinition;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( LibSBML::SBase LibSBML );
%OWNER = ();
%ITERATORS = ();
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        LibSBMLc::delete_FunctionDefinition($self);
        delete $OWNER{$self};
    }
}

sub new {
    my $pkg = shift;
    my $self = LibSBMLc::new_FunctionDefinition(@_);
    bless $self, $pkg if defined($self);
}

*clone = *LibSBMLc::FunctionDefinition_clone;
*getMath = *LibSBMLc::FunctionDefinition_getMath;
*isSetMath = *LibSBMLc::FunctionDefinition_isSetMath;
*setMath = *LibSBMLc::FunctionDefinition_setMath;
*getArgument = *LibSBMLc::FunctionDefinition_getArgument;
*getBody = *LibSBMLc::FunctionDefinition_getBody;
*getNumArguments = *LibSBMLc::FunctionDefinition_getNumArguments;
*getTypeCode = *LibSBMLc::FunctionDefinition_getTypeCode;
*getElementName = *LibSBMLc::FunctionDefinition_getElementName;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : LibSBML::ListOfFunctionDefinitions ##############

package LibSBML::ListOfFunctionDefinitions;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( LibSBML::ListOf LibSBML );
%OWNER = ();
%ITERATORS = ();
*clone = *LibSBMLc::ListOfFunctionDefinitions_clone;
*getTypeCode = *LibSBMLc::ListOfFunctionDefinitions_getTypeCode;
*getItemTypeCode = *LibSBMLc::ListOfFunctionDefinitions_getItemTypeCode;
*getElementName = *LibSBMLc::ListOfFunctionDefinitions_getElementName;
*get = *LibSBMLc::ListOfFunctionDefinitions_get;
*remove = *LibSBMLc::ListOfFunctionDefinitions_remove;
sub new {
    my $pkg = shift;
    my $self = LibSBMLc::new_ListOfFunctionDefinitions(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        LibSBMLc::delete_ListOfFunctionDefinitions($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : LibSBML::Unit ##############

package LibSBML::Unit;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( LibSBML::SBase LibSBML );
%OWNER = ();
%ITERATORS = ();
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        LibSBMLc::delete_Unit($self);
        delete $OWNER{$self};
    }
}

sub new {
    my $pkg = shift;
    my $self = LibSBMLc::new_Unit(@_);
    bless $self, $pkg if defined($self);
}

*clone = *LibSBMLc::Unit_clone;
*initDefaults = *LibSBMLc::Unit_initDefaults;
*getKind = *LibSBMLc::Unit_getKind;
*getExponent = *LibSBMLc::Unit_getExponent;
*getScale = *LibSBMLc::Unit_getScale;
*getMultiplier = *LibSBMLc::Unit_getMultiplier;
*getOffset = *LibSBMLc::Unit_getOffset;
*isAmpere = *LibSBMLc::Unit_isAmpere;
*isBecquerel = *LibSBMLc::Unit_isBecquerel;
*isCandela = *LibSBMLc::Unit_isCandela;
*isCelsius = *LibSBMLc::Unit_isCelsius;
*isCoulomb = *LibSBMLc::Unit_isCoulomb;
*isDimensionless = *LibSBMLc::Unit_isDimensionless;
*isFarad = *LibSBMLc::Unit_isFarad;
*isGram = *LibSBMLc::Unit_isGram;
*isGray = *LibSBMLc::Unit_isGray;
*isHenry = *LibSBMLc::Unit_isHenry;
*isHertz = *LibSBMLc::Unit_isHertz;
*isItem = *LibSBMLc::Unit_isItem;
*isJoule = *LibSBMLc::Unit_isJoule;
*isKatal = *LibSBMLc::Unit_isKatal;
*isKelvin = *LibSBMLc::Unit_isKelvin;
*isKilogram = *LibSBMLc::Unit_isKilogram;
*isLitre = *LibSBMLc::Unit_isLitre;
*isLumen = *LibSBMLc::Unit_isLumen;
*isLux = *LibSBMLc::Unit_isLux;
*isMetre = *LibSBMLc::Unit_isMetre;
*isMole = *LibSBMLc::Unit_isMole;
*isNewton = *LibSBMLc::Unit_isNewton;
*isOhm = *LibSBMLc::Unit_isOhm;
*isPascal = *LibSBMLc::Unit_isPascal;
*isRadian = *LibSBMLc::Unit_isRadian;
*isSecond = *LibSBMLc::Unit_isSecond;
*isSiemens = *LibSBMLc::Unit_isSiemens;
*isSievert = *LibSBMLc::Unit_isSievert;
*isSteradian = *LibSBMLc::Unit_isSteradian;
*isTesla = *LibSBMLc::Unit_isTesla;
*isVolt = *LibSBMLc::Unit_isVolt;
*isWatt = *LibSBMLc::Unit_isWatt;
*isWeber = *LibSBMLc::Unit_isWeber;
*isSetKind = *LibSBMLc::Unit_isSetKind;
*setKind = *LibSBMLc::Unit_setKind;
*setExponent = *LibSBMLc::Unit_setExponent;
*setScale = *LibSBMLc::Unit_setScale;
*setMultiplier = *LibSBMLc::Unit_setMultiplier;
*setOffset = *LibSBMLc::Unit_setOffset;
*getTypeCode = *LibSBMLc::Unit_getTypeCode;
*getElementName = *LibSBMLc::Unit_getElementName;
*isBuiltIn = *LibSBMLc::Unit_isBuiltIn;
*isUnitKind = *LibSBMLc::Unit_isUnitKind;
*areIdentical = *LibSBMLc::Unit_areIdentical;
*areEquivalent = *LibSBMLc::Unit_areEquivalent;
*removeScale = *LibSBMLc::Unit_removeScale;
*merge = *LibSBMLc::Unit_merge;
*convertToSI = *LibSBMLc::Unit_convertToSI;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : LibSBML::ListOfUnits ##############

package LibSBML::ListOfUnits;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( LibSBML::ListOf LibSBML );
%OWNER = ();
%ITERATORS = ();
*clone = *LibSBMLc::ListOfUnits_clone;
*getTypeCode = *LibSBMLc::ListOfUnits_getTypeCode;
*getItemTypeCode = *LibSBMLc::ListOfUnits_getItemTypeCode;
*getElementName = *LibSBMLc::ListOfUnits_getElementName;
*get = *LibSBMLc::ListOfUnits_get;
*remove = *LibSBMLc::ListOfUnits_remove;
sub new {
    my $pkg = shift;
    my $self = LibSBMLc::new_ListOfUnits(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        LibSBMLc::delete_ListOfUnits($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : LibSBML::UnitDefinition ##############

package LibSBML::UnitDefinition;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( LibSBML::SBase LibSBML );
%OWNER = ();
%ITERATORS = ();
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        LibSBMLc::delete_UnitDefinition($self);
        delete $OWNER{$self};
    }
}

sub new {
    my $pkg = shift;
    my $self = LibSBMLc::new_UnitDefinition(@_);
    bless $self, $pkg if defined($self);
}

*clone = *LibSBMLc::UnitDefinition_clone;
*isVariantOfArea = *LibSBMLc::UnitDefinition_isVariantOfArea;
*isVariantOfLength = *LibSBMLc::UnitDefinition_isVariantOfLength;
*isVariantOfSubstance = *LibSBMLc::UnitDefinition_isVariantOfSubstance;
*isVariantOfTime = *LibSBMLc::UnitDefinition_isVariantOfTime;
*isVariantOfVolume = *LibSBMLc::UnitDefinition_isVariantOfVolume;
*isVariantOfDimensionless = *LibSBMLc::UnitDefinition_isVariantOfDimensionless;
*isVariantOfMass = *LibSBMLc::UnitDefinition_isVariantOfMass;
*isVariantOfSubstancePerTime = *LibSBMLc::UnitDefinition_isVariantOfSubstancePerTime;
*addUnit = *LibSBMLc::UnitDefinition_addUnit;
*createUnit = *LibSBMLc::UnitDefinition_createUnit;
sub getListOfUnits {
  my $lox = LibSBMLc::UnitDefinition_getListOfUnits(@_);
  my @lox = ();
  for (my $i=0; $i<$lox->size(); $i++) {
    push @lox, $lox->get($i);
  }
  return wantarray ? @lox : $lox;
}

*getUnit = *LibSBMLc::UnitDefinition_getUnit;
*getNumUnits = *LibSBMLc::UnitDefinition_getNumUnits;
*setSBMLDocument = *LibSBMLc::UnitDefinition_setSBMLDocument;
*setParentSBMLObject = *LibSBMLc::UnitDefinition_setParentSBMLObject;
*getTypeCode = *LibSBMLc::UnitDefinition_getTypeCode;
*getElementName = *LibSBMLc::UnitDefinition_getElementName;
*simplify = *LibSBMLc::UnitDefinition_simplify;
*reorder = *LibSBMLc::UnitDefinition_reorder;
*convertToSI = *LibSBMLc::UnitDefinition_convertToSI;
*areIdentical = *LibSBMLc::UnitDefinition_areIdentical;
*areEquivalent = *LibSBMLc::UnitDefinition_areEquivalent;
*combine = *LibSBMLc::UnitDefinition_combine;
*printUnits = *LibSBMLc::UnitDefinition_printUnits;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : LibSBML::ListOfUnitDefinitions ##############

package LibSBML::ListOfUnitDefinitions;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( LibSBML::ListOf LibSBML );
%OWNER = ();
%ITERATORS = ();
*clone = *LibSBMLc::ListOfUnitDefinitions_clone;
*getTypeCode = *LibSBMLc::ListOfUnitDefinitions_getTypeCode;
*getItemTypeCode = *LibSBMLc::ListOfUnitDefinitions_getItemTypeCode;
*getElementName = *LibSBMLc::ListOfUnitDefinitions_getElementName;
*get = *LibSBMLc::ListOfUnitDefinitions_get;
*remove = *LibSBMLc::ListOfUnitDefinitions_remove;
sub new {
    my $pkg = shift;
    my $self = LibSBMLc::new_ListOfUnitDefinitions(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        LibSBMLc::delete_ListOfUnitDefinitions($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : LibSBML::CompartmentType ##############

package LibSBML::CompartmentType;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( LibSBML::SBase LibSBML );
%OWNER = ();
%ITERATORS = ();
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        LibSBMLc::delete_CompartmentType($self);
        delete $OWNER{$self};
    }
}

sub new {
    my $pkg = shift;
    my $self = LibSBMLc::new_CompartmentType(@_);
    bless $self, $pkg if defined($self);
}

*clone = *LibSBMLc::CompartmentType_clone;
*getTypeCode = *LibSBMLc::CompartmentType_getTypeCode;
*getElementName = *LibSBMLc::CompartmentType_getElementName;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : LibSBML::ListOfCompartmentTypes ##############

package LibSBML::ListOfCompartmentTypes;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( LibSBML::ListOf LibSBML );
%OWNER = ();
%ITERATORS = ();
*clone = *LibSBMLc::ListOfCompartmentTypes_clone;
*getTypeCode = *LibSBMLc::ListOfCompartmentTypes_getTypeCode;
*getItemTypeCode = *LibSBMLc::ListOfCompartmentTypes_getItemTypeCode;
*getElementName = *LibSBMLc::ListOfCompartmentTypes_getElementName;
*get = *LibSBMLc::ListOfCompartmentTypes_get;
*remove = *LibSBMLc::ListOfCompartmentTypes_remove;
sub new {
    my $pkg = shift;
    my $self = LibSBMLc::new_ListOfCompartmentTypes(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        LibSBMLc::delete_ListOfCompartmentTypes($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : LibSBML::SpeciesType ##############

package LibSBML::SpeciesType;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( LibSBML::SBase LibSBML );
%OWNER = ();
%ITERATORS = ();
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        LibSBMLc::delete_SpeciesType($self);
        delete $OWNER{$self};
    }
}

sub new {
    my $pkg = shift;
    my $self = LibSBMLc::new_SpeciesType(@_);
    bless $self, $pkg if defined($self);
}

*clone = *LibSBMLc::SpeciesType_clone;
*getTypeCode = *LibSBMLc::SpeciesType_getTypeCode;
*getElementName = *LibSBMLc::SpeciesType_getElementName;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : LibSBML::ListOfSpeciesTypes ##############

package LibSBML::ListOfSpeciesTypes;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( LibSBML::ListOf LibSBML );
%OWNER = ();
%ITERATORS = ();
*clone = *LibSBMLc::ListOfSpeciesTypes_clone;
*getTypeCode = *LibSBMLc::ListOfSpeciesTypes_getTypeCode;
*getItemTypeCode = *LibSBMLc::ListOfSpeciesTypes_getItemTypeCode;
*getElementName = *LibSBMLc::ListOfSpeciesTypes_getElementName;
*get = *LibSBMLc::ListOfSpeciesTypes_get;
*remove = *LibSBMLc::ListOfSpeciesTypes_remove;
sub new {
    my $pkg = shift;
    my $self = LibSBMLc::new_ListOfSpeciesTypes(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        LibSBMLc::delete_ListOfSpeciesTypes($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : LibSBML::Compartment ##############

package LibSBML::Compartment;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( LibSBML::SBase LibSBML );
%OWNER = ();
%ITERATORS = ();
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        LibSBMLc::delete_Compartment($self);
        delete $OWNER{$self};
    }
}

sub new {
    my $pkg = shift;
    my $self = LibSBMLc::new_Compartment(@_);
    bless $self, $pkg if defined($self);
}

*clone = *LibSBMLc::Compartment_clone;
*initDefaults = *LibSBMLc::Compartment_initDefaults;
*getCompartmentType = *LibSBMLc::Compartment_getCompartmentType;
*getSpatialDimensions = *LibSBMLc::Compartment_getSpatialDimensions;
*getSize = *LibSBMLc::Compartment_getSize;
*getVolume = *LibSBMLc::Compartment_getVolume;
*getUnits = *LibSBMLc::Compartment_getUnits;
*getOutside = *LibSBMLc::Compartment_getOutside;
*getConstant = *LibSBMLc::Compartment_getConstant;
*isSetCompartmentType = *LibSBMLc::Compartment_isSetCompartmentType;
*isSetSize = *LibSBMLc::Compartment_isSetSize;
*isSetVolume = *LibSBMLc::Compartment_isSetVolume;
*isSetUnits = *LibSBMLc::Compartment_isSetUnits;
*isSetOutside = *LibSBMLc::Compartment_isSetOutside;
*setCompartmentType = *LibSBMLc::Compartment_setCompartmentType;
*setSpatialDimensions = *LibSBMLc::Compartment_setSpatialDimensions;
*setSize = *LibSBMLc::Compartment_setSize;
*setVolume = *LibSBMLc::Compartment_setVolume;
*setUnits = *LibSBMLc::Compartment_setUnits;
*setOutside = *LibSBMLc::Compartment_setOutside;
*setConstant = *LibSBMLc::Compartment_setConstant;
*unsetCompartmentType = *LibSBMLc::Compartment_unsetCompartmentType;
*unsetSize = *LibSBMLc::Compartment_unsetSize;
*unsetVolume = *LibSBMLc::Compartment_unsetVolume;
*unsetUnits = *LibSBMLc::Compartment_unsetUnits;
*unsetOutside = *LibSBMLc::Compartment_unsetOutside;
*getDerivedUnitDefinition = *LibSBMLc::Compartment_getDerivedUnitDefinition;
*getTypeCode = *LibSBMLc::Compartment_getTypeCode;
*getElementName = *LibSBMLc::Compartment_getElementName;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : LibSBML::ListOfCompartments ##############

package LibSBML::ListOfCompartments;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( LibSBML::ListOf LibSBML );
%OWNER = ();
%ITERATORS = ();
*clone = *LibSBMLc::ListOfCompartments_clone;
*getTypeCode = *LibSBMLc::ListOfCompartments_getTypeCode;
*getItemTypeCode = *LibSBMLc::ListOfCompartments_getItemTypeCode;
*getElementName = *LibSBMLc::ListOfCompartments_getElementName;
*get = *LibSBMLc::ListOfCompartments_get;
*remove = *LibSBMLc::ListOfCompartments_remove;
sub new {
    my $pkg = shift;
    my $self = LibSBMLc::new_ListOfCompartments(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        LibSBMLc::delete_ListOfCompartments($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : LibSBML::Species ##############

package LibSBML::Species;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( LibSBML::SBase LibSBML );
%OWNER = ();
%ITERATORS = ();
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        LibSBMLc::delete_Species($self);
        delete $OWNER{$self};
    }
}

sub new {
    my $pkg = shift;
    my $self = LibSBMLc::new_Species(@_);
    bless $self, $pkg if defined($self);
}

*clone = *LibSBMLc::Species_clone;
*initDefaults = *LibSBMLc::Species_initDefaults;
*getSpeciesType = *LibSBMLc::Species_getSpeciesType;
*getCompartment = *LibSBMLc::Species_getCompartment;
*getInitialAmount = *LibSBMLc::Species_getInitialAmount;
*getInitialConcentration = *LibSBMLc::Species_getInitialConcentration;
*getSubstanceUnits = *LibSBMLc::Species_getSubstanceUnits;
*getSpatialSizeUnits = *LibSBMLc::Species_getSpatialSizeUnits;
*getUnits = *LibSBMLc::Species_getUnits;
*getHasOnlySubstanceUnits = *LibSBMLc::Species_getHasOnlySubstanceUnits;
*getBoundaryCondition = *LibSBMLc::Species_getBoundaryCondition;
*getCharge = *LibSBMLc::Species_getCharge;
*getConstant = *LibSBMLc::Species_getConstant;
*isSetSpeciesType = *LibSBMLc::Species_isSetSpeciesType;
*isSetCompartment = *LibSBMLc::Species_isSetCompartment;
*isSetInitialAmount = *LibSBMLc::Species_isSetInitialAmount;
*isSetInitialConcentration = *LibSBMLc::Species_isSetInitialConcentration;
*isSetSubstanceUnits = *LibSBMLc::Species_isSetSubstanceUnits;
*isSetSpatialSizeUnits = *LibSBMLc::Species_isSetSpatialSizeUnits;
*isSetUnits = *LibSBMLc::Species_isSetUnits;
*isSetCharge = *LibSBMLc::Species_isSetCharge;
*setSpeciesType = *LibSBMLc::Species_setSpeciesType;
*setCompartment = *LibSBMLc::Species_setCompartment;
*setInitialAmount = *LibSBMLc::Species_setInitialAmount;
*setInitialConcentration = *LibSBMLc::Species_setInitialConcentration;
*setSubstanceUnits = *LibSBMLc::Species_setSubstanceUnits;
*setSpatialSizeUnits = *LibSBMLc::Species_setSpatialSizeUnits;
*setUnits = *LibSBMLc::Species_setUnits;
*setHasOnlySubstanceUnits = *LibSBMLc::Species_setHasOnlySubstanceUnits;
*setBoundaryCondition = *LibSBMLc::Species_setBoundaryCondition;
*setCharge = *LibSBMLc::Species_setCharge;
*setConstant = *LibSBMLc::Species_setConstant;
*unsetSpeciesType = *LibSBMLc::Species_unsetSpeciesType;
*unsetInitialAmount = *LibSBMLc::Species_unsetInitialAmount;
*unsetInitialConcentration = *LibSBMLc::Species_unsetInitialConcentration;
*unsetSubstanceUnits = *LibSBMLc::Species_unsetSubstanceUnits;
*unsetSpatialSizeUnits = *LibSBMLc::Species_unsetSpatialSizeUnits;
*unsetUnits = *LibSBMLc::Species_unsetUnits;
*unsetCharge = *LibSBMLc::Species_unsetCharge;
*getDerivedUnitDefinition = *LibSBMLc::Species_getDerivedUnitDefinition;
*getTypeCode = *LibSBMLc::Species_getTypeCode;
*getElementName = *LibSBMLc::Species_getElementName;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : LibSBML::ListOfSpecies ##############

package LibSBML::ListOfSpecies;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( LibSBML::ListOf LibSBML );
%OWNER = ();
%ITERATORS = ();
*clone = *LibSBMLc::ListOfSpecies_clone;
*getTypeCode = *LibSBMLc::ListOfSpecies_getTypeCode;
*getItemTypeCode = *LibSBMLc::ListOfSpecies_getItemTypeCode;
*getElementName = *LibSBMLc::ListOfSpecies_getElementName;
*get = *LibSBMLc::ListOfSpecies_get;
*remove = *LibSBMLc::ListOfSpecies_remove;
sub new {
    my $pkg = shift;
    my $self = LibSBMLc::new_ListOfSpecies(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        LibSBMLc::delete_ListOfSpecies($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : LibSBML::Parameter ##############

package LibSBML::Parameter;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( LibSBML::SBase LibSBML );
%OWNER = ();
%ITERATORS = ();
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        LibSBMLc::delete_Parameter($self);
        delete $OWNER{$self};
    }
}

sub new {
    my $pkg = shift;
    my $self = LibSBMLc::new_Parameter(@_);
    bless $self, $pkg if defined($self);
}

*clone = *LibSBMLc::Parameter_clone;
*initDefaults = *LibSBMLc::Parameter_initDefaults;
*getValue = *LibSBMLc::Parameter_getValue;
*getUnits = *LibSBMLc::Parameter_getUnits;
*getConstant = *LibSBMLc::Parameter_getConstant;
*isSetValue = *LibSBMLc::Parameter_isSetValue;
*isSetUnits = *LibSBMLc::Parameter_isSetUnits;
*setValue = *LibSBMLc::Parameter_setValue;
*setUnits = *LibSBMLc::Parameter_setUnits;
*setConstant = *LibSBMLc::Parameter_setConstant;
*unsetValue = *LibSBMLc::Parameter_unsetValue;
*unsetUnits = *LibSBMLc::Parameter_unsetUnits;
*getDerivedUnitDefinition = *LibSBMLc::Parameter_getDerivedUnitDefinition;
*getTypeCode = *LibSBMLc::Parameter_getTypeCode;
*getElementName = *LibSBMLc::Parameter_getElementName;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : LibSBML::ListOfParameters ##############

package LibSBML::ListOfParameters;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( LibSBML::ListOf LibSBML );
%OWNER = ();
%ITERATORS = ();
*clone = *LibSBMLc::ListOfParameters_clone;
*getTypeCode = *LibSBMLc::ListOfParameters_getTypeCode;
*getItemTypeCode = *LibSBMLc::ListOfParameters_getItemTypeCode;
*getElementName = *LibSBMLc::ListOfParameters_getElementName;
*get = *LibSBMLc::ListOfParameters_get;
*remove = *LibSBMLc::ListOfParameters_remove;
sub new {
    my $pkg = shift;
    my $self = LibSBMLc::new_ListOfParameters(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        LibSBMLc::delete_ListOfParameters($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : LibSBML::InitialAssignment ##############

package LibSBML::InitialAssignment;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( LibSBML::SBase LibSBML );
%OWNER = ();
%ITERATORS = ();
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        LibSBMLc::delete_InitialAssignment($self);
        delete $OWNER{$self};
    }
}

sub new {
    my $pkg = shift;
    my $self = LibSBMLc::new_InitialAssignment(@_);
    bless $self, $pkg if defined($self);
}

*clone = *LibSBMLc::InitialAssignment_clone;
*getSymbol = *LibSBMLc::InitialAssignment_getSymbol;
*getMath = *LibSBMLc::InitialAssignment_getMath;
*isSetSymbol = *LibSBMLc::InitialAssignment_isSetSymbol;
*isSetMath = *LibSBMLc::InitialAssignment_isSetMath;
*setSymbol = *LibSBMLc::InitialAssignment_setSymbol;
*setMath = *LibSBMLc::InitialAssignment_setMath;
*getDerivedUnitDefinition = *LibSBMLc::InitialAssignment_getDerivedUnitDefinition;
*containsUndeclaredUnits = *LibSBMLc::InitialAssignment_containsUndeclaredUnits;
*getTypeCode = *LibSBMLc::InitialAssignment_getTypeCode;
*getElementName = *LibSBMLc::InitialAssignment_getElementName;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : LibSBML::ListOfInitialAssignments ##############

package LibSBML::ListOfInitialAssignments;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( LibSBML::ListOf LibSBML );
%OWNER = ();
%ITERATORS = ();
*clone = *LibSBMLc::ListOfInitialAssignments_clone;
*getTypeCode = *LibSBMLc::ListOfInitialAssignments_getTypeCode;
*getItemTypeCode = *LibSBMLc::ListOfInitialAssignments_getItemTypeCode;
*getElementName = *LibSBMLc::ListOfInitialAssignments_getElementName;
*get = *LibSBMLc::ListOfInitialAssignments_get;
*remove = *LibSBMLc::ListOfInitialAssignments_remove;
sub new {
    my $pkg = shift;
    my $self = LibSBMLc::new_ListOfInitialAssignments(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        LibSBMLc::delete_ListOfInitialAssignments($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : LibSBML::Rule ##############

package LibSBML::Rule;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( LibSBML::SBase LibSBML );
%OWNER = ();
%ITERATORS = ();
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        LibSBMLc::delete_Rule($self);
        delete $OWNER{$self};
    }
}

sub new {
    my $pkg = shift;
    my $self = LibSBMLc::new_Rule(@_);
    bless $self, $pkg if defined($self);
}

*clone = *LibSBMLc::Rule_clone;
*getFormula = *LibSBMLc::Rule_getFormula;
*getMath = *LibSBMLc::Rule_getMath;
*getVariable = *LibSBMLc::Rule_getVariable;
*getUnits = *LibSBMLc::Rule_getUnits;
*isSetFormula = *LibSBMLc::Rule_isSetFormula;
*isSetMath = *LibSBMLc::Rule_isSetMath;
*isSetVariable = *LibSBMLc::Rule_isSetVariable;
*isSetUnits = *LibSBMLc::Rule_isSetUnits;
*setFormula = *LibSBMLc::Rule_setFormula;
*setMath = *LibSBMLc::Rule_setMath;
*setVariable = *LibSBMLc::Rule_setVariable;
*setUnits = *LibSBMLc::Rule_setUnits;
*unsetUnits = *LibSBMLc::Rule_unsetUnits;
*getDerivedUnitDefinition = *LibSBMLc::Rule_getDerivedUnitDefinition;
*containsUndeclaredUnits = *LibSBMLc::Rule_containsUndeclaredUnits;
*getType = *LibSBMLc::Rule_getType;
*isAlgebraic = *LibSBMLc::Rule_isAlgebraic;
*isAssignment = *LibSBMLc::Rule_isAssignment;
*isCompartmentVolume = *LibSBMLc::Rule_isCompartmentVolume;
*isParameter = *LibSBMLc::Rule_isParameter;
*isRate = *LibSBMLc::Rule_isRate;
*isScalar = *LibSBMLc::Rule_isScalar;
*isSpeciesConcentration = *LibSBMLc::Rule_isSpeciesConcentration;
*getTypeCode = *LibSBMLc::Rule_getTypeCode;
*getL1TypeCode = *LibSBMLc::Rule_getL1TypeCode;
*getElementName = *LibSBMLc::Rule_getElementName;
*setL1TypeCode = *LibSBMLc::Rule_setL1TypeCode;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : LibSBML::AlgebraicRule ##############

package LibSBML::AlgebraicRule;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( LibSBML::Rule LibSBML );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my $self = LibSBMLc::new_AlgebraicRule(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        LibSBMLc::delete_AlgebraicRule($self);
        delete $OWNER{$self};
    }
}

*clone = *LibSBMLc::AlgebraicRule_clone;
*setInternalIdOnly = *LibSBMLc::AlgebraicRule_setInternalIdOnly;
*getInternalIdOnly = *LibSBMLc::AlgebraicRule_getInternalIdOnly;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : LibSBML::AssignmentRule ##############

package LibSBML::AssignmentRule;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( LibSBML::Rule LibSBML );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my $self = LibSBMLc::new_AssignmentRule(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        LibSBMLc::delete_AssignmentRule($self);
        delete $OWNER{$self};
    }
}

*clone = *LibSBMLc::AssignmentRule_clone;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : LibSBML::RateRule ##############

package LibSBML::RateRule;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( LibSBML::Rule LibSBML );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my $self = LibSBMLc::new_RateRule(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        LibSBMLc::delete_RateRule($self);
        delete $OWNER{$self};
    }
}

*clone = *LibSBMLc::RateRule_clone;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : LibSBML::ListOfRules ##############

package LibSBML::ListOfRules;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( LibSBML::ListOf LibSBML );
%OWNER = ();
%ITERATORS = ();
*clone = *LibSBMLc::ListOfRules_clone;
*getTypeCode = *LibSBMLc::ListOfRules_getTypeCode;
*getItemTypeCode = *LibSBMLc::ListOfRules_getItemTypeCode;
*getElementName = *LibSBMLc::ListOfRules_getElementName;
*get = *LibSBMLc::ListOfRules_get;
*remove = *LibSBMLc::ListOfRules_remove;
sub new {
    my $pkg = shift;
    my $self = LibSBMLc::new_ListOfRules(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        LibSBMLc::delete_ListOfRules($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : LibSBML::Constraint ##############

package LibSBML::Constraint;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( LibSBML::SBase LibSBML );
%OWNER = ();
%ITERATORS = ();
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        LibSBMLc::delete_Constraint($self);
        delete $OWNER{$self};
    }
}

sub new {
    my $pkg = shift;
    my $self = LibSBMLc::new_Constraint(@_);
    bless $self, $pkg if defined($self);
}

*clone = *LibSBMLc::Constraint_clone;
*getMessage = *LibSBMLc::Constraint_getMessage;
*getMessageString = *LibSBMLc::Constraint_getMessageString;
*getMath = *LibSBMLc::Constraint_getMath;
*isSetMessage = *LibSBMLc::Constraint_isSetMessage;
*isSetMath = *LibSBMLc::Constraint_isSetMath;
*setMessage = *LibSBMLc::Constraint_setMessage;
*setMath = *LibSBMLc::Constraint_setMath;
*unsetMessage = *LibSBMLc::Constraint_unsetMessage;
*getTypeCode = *LibSBMLc::Constraint_getTypeCode;
*getElementName = *LibSBMLc::Constraint_getElementName;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : LibSBML::ListOfConstraints ##############

package LibSBML::ListOfConstraints;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( LibSBML::ListOf LibSBML );
%OWNER = ();
%ITERATORS = ();
*clone = *LibSBMLc::ListOfConstraints_clone;
*getTypeCode = *LibSBMLc::ListOfConstraints_getTypeCode;
*getItemTypeCode = *LibSBMLc::ListOfConstraints_getItemTypeCode;
*getElementName = *LibSBMLc::ListOfConstraints_getElementName;
*get = *LibSBMLc::ListOfConstraints_get;
*remove = *LibSBMLc::ListOfConstraints_remove;
sub new {
    my $pkg = shift;
    my $self = LibSBMLc::new_ListOfConstraints(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        LibSBMLc::delete_ListOfConstraints($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : LibSBML::Reaction ##############

package LibSBML::Reaction;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( LibSBML::SBase LibSBML );
%OWNER = ();
%ITERATORS = ();
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        LibSBMLc::delete_Reaction($self);
        delete $OWNER{$self};
    }
}

sub new {
    my $pkg = shift;
    my $self = LibSBMLc::new_Reaction(@_);
    bless $self, $pkg if defined($self);
}

*clone = *LibSBMLc::Reaction_clone;
*initDefaults = *LibSBMLc::Reaction_initDefaults;
*getKineticLaw = *LibSBMLc::Reaction_getKineticLaw;
*getReversible = *LibSBMLc::Reaction_getReversible;
*getFast = *LibSBMLc::Reaction_getFast;
*isSetKineticLaw = *LibSBMLc::Reaction_isSetKineticLaw;
*isSetFast = *LibSBMLc::Reaction_isSetFast;
*setKineticLaw = *LibSBMLc::Reaction_setKineticLaw;
*setReversible = *LibSBMLc::Reaction_setReversible;
*setFast = *LibSBMLc::Reaction_setFast;
*unsetKineticLaw = *LibSBMLc::Reaction_unsetKineticLaw;
*unsetFast = *LibSBMLc::Reaction_unsetFast;
*addReactant = *LibSBMLc::Reaction_addReactant;
*addProduct = *LibSBMLc::Reaction_addProduct;
*addModifier = *LibSBMLc::Reaction_addModifier;
*createReactant = *LibSBMLc::Reaction_createReactant;
*createProduct = *LibSBMLc::Reaction_createProduct;
*createModifier = *LibSBMLc::Reaction_createModifier;
*createKineticLaw = *LibSBMLc::Reaction_createKineticLaw;
sub getListOfReactants {
  my $lox = LibSBMLc::Reaction_getListOfReactants(@_);
  my @lox = ();
  for (my $i=0; $i<$lox->size(); $i++) {
    push @lox, $lox->get($i);
  }
  return wantarray ? @lox : $lox;
}

sub getListOfProducts {
  my $lox = LibSBMLc::Reaction_getListOfProducts(@_);
  my @lox = ();
  for (my $i=0; $i<$lox->size(); $i++) {
    push @lox, $lox->get($i);
  }
  return wantarray ? @lox : $lox;
}

sub getListOfModifiers {
  my $lox = LibSBMLc::Reaction_getListOfModifiers(@_);
  my @lox = ();
  for (my $i=0; $i<$lox->size(); $i++) {
    push @lox, $lox->get($i);
  }
  return wantarray ? @lox : $lox;
}

*getReactant = *LibSBMLc::Reaction_getReactant;
*getProduct = *LibSBMLc::Reaction_getProduct;
*getModifier = *LibSBMLc::Reaction_getModifier;
*getNumReactants = *LibSBMLc::Reaction_getNumReactants;
*getNumProducts = *LibSBMLc::Reaction_getNumProducts;
*getNumModifiers = *LibSBMLc::Reaction_getNumModifiers;
*setSBMLDocument = *LibSBMLc::Reaction_setSBMLDocument;
*setParentSBMLObject = *LibSBMLc::Reaction_setParentSBMLObject;
*getTypeCode = *LibSBMLc::Reaction_getTypeCode;
*getElementName = *LibSBMLc::Reaction_getElementName;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : LibSBML::ListOfReactions ##############

package LibSBML::ListOfReactions;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( LibSBML::ListOf LibSBML );
%OWNER = ();
%ITERATORS = ();
*clone = *LibSBMLc::ListOfReactions_clone;
*getTypeCode = *LibSBMLc::ListOfReactions_getTypeCode;
*getItemTypeCode = *LibSBMLc::ListOfReactions_getItemTypeCode;
*getElementName = *LibSBMLc::ListOfReactions_getElementName;
*get = *LibSBMLc::ListOfReactions_get;
*remove = *LibSBMLc::ListOfReactions_remove;
sub new {
    my $pkg = shift;
    my $self = LibSBMLc::new_ListOfReactions(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        LibSBMLc::delete_ListOfReactions($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : LibSBML::KineticLaw ##############

package LibSBML::KineticLaw;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( LibSBML::SBase LibSBML );
%OWNER = ();
%ITERATORS = ();
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        LibSBMLc::delete_KineticLaw($self);
        delete $OWNER{$self};
    }
}

sub new {
    my $pkg = shift;
    my $self = LibSBMLc::new_KineticLaw(@_);
    bless $self, $pkg if defined($self);
}

*clone = *LibSBMLc::KineticLaw_clone;
*getFormula = *LibSBMLc::KineticLaw_getFormula;
*getMath = *LibSBMLc::KineticLaw_getMath;
*getTimeUnits = *LibSBMLc::KineticLaw_getTimeUnits;
*getSubstanceUnits = *LibSBMLc::KineticLaw_getSubstanceUnits;
*isSetFormula = *LibSBMLc::KineticLaw_isSetFormula;
*isSetMath = *LibSBMLc::KineticLaw_isSetMath;
*isSetTimeUnits = *LibSBMLc::KineticLaw_isSetTimeUnits;
*isSetSubstanceUnits = *LibSBMLc::KineticLaw_isSetSubstanceUnits;
*setFormula = *LibSBMLc::KineticLaw_setFormula;
*setMath = *LibSBMLc::KineticLaw_setMath;
*setTimeUnits = *LibSBMLc::KineticLaw_setTimeUnits;
*setSubstanceUnits = *LibSBMLc::KineticLaw_setSubstanceUnits;
*unsetTimeUnits = *LibSBMLc::KineticLaw_unsetTimeUnits;
*unsetSubstanceUnits = *LibSBMLc::KineticLaw_unsetSubstanceUnits;
*addParameter = *LibSBMLc::KineticLaw_addParameter;
*createParameter = *LibSBMLc::KineticLaw_createParameter;
sub getListOfParameters {
  my $lox = LibSBMLc::KineticLaw_getListOfParameters(@_);
  my @lox = ();
  for (my $i=0; $i<$lox->size(); $i++) {
    push @lox, $lox->get($i);
  }
  return wantarray ? @lox : $lox;
}

*getParameter = *LibSBMLc::KineticLaw_getParameter;
*getNumParameters = *LibSBMLc::KineticLaw_getNumParameters;
*getDerivedUnitDefinition = *LibSBMLc::KineticLaw_getDerivedUnitDefinition;
*containsUndeclaredUnits = *LibSBMLc::KineticLaw_containsUndeclaredUnits;
*setSBMLDocument = *LibSBMLc::KineticLaw_setSBMLDocument;
*setParentSBMLObject = *LibSBMLc::KineticLaw_setParentSBMLObject;
*getTypeCode = *LibSBMLc::KineticLaw_getTypeCode;
*getElementName = *LibSBMLc::KineticLaw_getElementName;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : LibSBML::SimpleSpeciesReference ##############

package LibSBML::SimpleSpeciesReference;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( LibSBML::SBase LibSBML );
%OWNER = ();
%ITERATORS = ();
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        LibSBMLc::delete_SimpleSpeciesReference($self);
        delete $OWNER{$self};
    }
}

*getSpecies = *LibSBMLc::SimpleSpeciesReference_getSpecies;
*isSetSpecies = *LibSBMLc::SimpleSpeciesReference_isSetSpecies;
*setSpecies = *LibSBMLc::SimpleSpeciesReference_setSpecies;
*isModifier = *LibSBMLc::SimpleSpeciesReference_isModifier;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : LibSBML::SpeciesReference ##############

package LibSBML::SpeciesReference;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( LibSBML::SimpleSpeciesReference LibSBML );
%OWNER = ();
%ITERATORS = ();
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        LibSBMLc::delete_SpeciesReference($self);
        delete $OWNER{$self};
    }
}

sub new {
    my $pkg = shift;
    my $self = LibSBMLc::new_SpeciesReference(@_);
    bless $self, $pkg if defined($self);
}

*clone = *LibSBMLc::SpeciesReference_clone;
*initDefaults = *LibSBMLc::SpeciesReference_initDefaults;
*getStoichiometry = *LibSBMLc::SpeciesReference_getStoichiometry;
*getStoichiometryMath = *LibSBMLc::SpeciesReference_getStoichiometryMath;
*getDenominator = *LibSBMLc::SpeciesReference_getDenominator;
*isSetStoichiometryMath = *LibSBMLc::SpeciesReference_isSetStoichiometryMath;
*setStoichiometry = *LibSBMLc::SpeciesReference_setStoichiometry;
*setStoichiometryMath = *LibSBMLc::SpeciesReference_setStoichiometryMath;
*setDenominator = *LibSBMLc::SpeciesReference_setDenominator;
*unsetStoichiometryMath = *LibSBMLc::SpeciesReference_unsetStoichiometryMath;
*setAnnotation = *LibSBMLc::SpeciesReference_setAnnotation;
*appendAnnotation = *LibSBMLc::SpeciesReference_appendAnnotation;
*getTypeCode = *LibSBMLc::SpeciesReference_getTypeCode;
*getElementName = *LibSBMLc::SpeciesReference_getElementName;
*sortMath = *LibSBMLc::SpeciesReference_sortMath;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : LibSBML::ModifierSpeciesReference ##############

package LibSBML::ModifierSpeciesReference;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( LibSBML::SimpleSpeciesReference LibSBML );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my $self = LibSBMLc::new_ModifierSpeciesReference(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        LibSBMLc::delete_ModifierSpeciesReference($self);
        delete $OWNER{$self};
    }
}

*clone = *LibSBMLc::ModifierSpeciesReference_clone;
*getTypeCode = *LibSBMLc::ModifierSpeciesReference_getTypeCode;
*getElementName = *LibSBMLc::ModifierSpeciesReference_getElementName;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : LibSBML::ListOfSpeciesReferences ##############

package LibSBML::ListOfSpeciesReferences;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( LibSBML::ListOf LibSBML );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my $self = LibSBMLc::new_ListOfSpeciesReferences(@_);
    bless $self, $pkg if defined($self);
}

*clone = *LibSBMLc::ListOfSpeciesReferences_clone;
*getTypeCode = *LibSBMLc::ListOfSpeciesReferences_getTypeCode;
*getItemTypeCode = *LibSBMLc::ListOfSpeciesReferences_getItemTypeCode;
*getElementName = *LibSBMLc::ListOfSpeciesReferences_getElementName;
*get = *LibSBMLc::ListOfSpeciesReferences_get;
*remove = *LibSBMLc::ListOfSpeciesReferences_remove;
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        LibSBMLc::delete_ListOfSpeciesReferences($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : LibSBML::Event ##############

package LibSBML::Event;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( LibSBML::SBase LibSBML );
%OWNER = ();
%ITERATORS = ();
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        LibSBMLc::delete_Event($self);
        delete $OWNER{$self};
    }
}

sub new {
    my $pkg = shift;
    my $self = LibSBMLc::new_Event(@_);
    bless $self, $pkg if defined($self);
}

*clone = *LibSBMLc::Event_clone;
*getTrigger = *LibSBMLc::Event_getTrigger;
*getDelay = *LibSBMLc::Event_getDelay;
*getTimeUnits = *LibSBMLc::Event_getTimeUnits;
*getUseValuesFromTriggerTime = *LibSBMLc::Event_getUseValuesFromTriggerTime;
*isSetTrigger = *LibSBMLc::Event_isSetTrigger;
*isSetDelay = *LibSBMLc::Event_isSetDelay;
*isSetTimeUnits = *LibSBMLc::Event_isSetTimeUnits;
*setTrigger = *LibSBMLc::Event_setTrigger;
*setDelay = *LibSBMLc::Event_setDelay;
*setTimeUnits = *LibSBMLc::Event_setTimeUnits;
*setUseValuesFromTriggerTime = *LibSBMLc::Event_setUseValuesFromTriggerTime;
*unsetDelay = *LibSBMLc::Event_unsetDelay;
*unsetTimeUnits = *LibSBMLc::Event_unsetTimeUnits;
*addEventAssignment = *LibSBMLc::Event_addEventAssignment;
*createEventAssignment = *LibSBMLc::Event_createEventAssignment;
sub getListOfEventAssignments {
  my $lox = LibSBMLc::Event_getListOfEventAssignments(@_);
  my @lox = ();
  for (my $i=0; $i<$lox->size(); $i++) {
    push @lox, $lox->get($i);
  }
  return wantarray ? @lox : $lox;
}

*getEventAssignment = *LibSBMLc::Event_getEventAssignment;
*getNumEventAssignments = *LibSBMLc::Event_getNumEventAssignments;
*setSBMLDocument = *LibSBMLc::Event_setSBMLDocument;
*setParentSBMLObject = *LibSBMLc::Event_setParentSBMLObject;
*getTypeCode = *LibSBMLc::Event_getTypeCode;
*getElementName = *LibSBMLc::Event_getElementName;
*setInternalIdOnly = *LibSBMLc::Event_setInternalIdOnly;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class :