/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.38
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * LibSBML implementation of SBML's UnitDefinition construct.
 * <p>
 * Units of measurement may be supplied in a number of contexts in an SBML
 * model.  The units of the following mathematical entities can be
 * specified explicitly: the size of a compartment, the initial amount of a
 * species, and the units of constant and variable parameter values.  The
 * overall units of any mathematical formula appearing in SBML are those
 * that arise naturally from the components and mathematical expressions
 * comprising the formula, or in other words, the units obtained by doing
 * dimensional analysis on the formula.
 * <p>
 * Rather than requiring a complete unit definition on every construct,
 * SBML provides a facility for defining units that can be referenced
 * throughout a model.  In addition, every kind of SBML mathematical
 * entity has units assigned to it from a set of predefined defaults (listed
 * below); by redefining these predefined default units, it is possible to
 * change the units used throughout a model in a simple and consistent
 * manner.
 * <p>
 * The SBML unit definition facility uses two classes of objects,
 * {@link UnitDefinition} and {@link Unit}.  The approach to defining units in SBML is
 * compositional; for example, <em>meter second<sup> &ndash;2</sup></em> is
 * constructed by combining a {@link Unit} object representing <em>meter</em> with
 * another {@link Unit} object representing <em>second<sup> &ndash;2</sup></em>.
 * The combination is wrapped inside a {@link UnitDefinition}, which provides for
 * assigning an identifier and optional name to the combination.  The
 * identifier can then be referenced from elsewhere in a model.  Thus, the
 * {@link UnitDefinition} class is the container, and {@link Unit} instances are placed
 * inside {@link UnitDefinition} instances.
 * <p>
 * <h2>Summary of the {@link UnitDefinition} construct</h2>
 * <p>
 * {@link UnitDefinition} in SBML Level&nbsp;2 has two attributes and one
 * subelement.  The two attributes are 'id' and 'name', and the subelement
 * is {@link ListOfUnits}.
 * <p>
 * The required attribute 'id' and optional attribute 'name' are both
 * strings.  The 'id' attribute is used to give the defined unit a unique
 * identifier by which other parts of an SBML model definition can refer to
 * it.  The 'name' attribute is intended to be used for giving the unit
 * definition an optional human-readable name.
 * <p>
 * There are two important restrictions about the use of unit definition
 * 'id' values in SBML Level&nbsp;2 Versions&nbsp;3&ndash;4:
 * <ul>
 * <li> The 'id' of a {@link UnitDefinition} must <em>not</em> contain a value from the
 *   list of reserved base unit names (i.e., the strings <code>gram</code>, <code>liter</code>,
 *   etc.; see the definition of {@link Unit} for the complete list).  This
 *   constraint simply prevents the redefinition of the base units.
 * <p>
 * <li> There is a set of reserved identifiers for the predefined
 *   units in SBML; these identifiers are <code>substance</code>, <code>volume</code>, <code>area</code>,
 *   <code>length</code>, and <code>time</code>.  Using one of these values for the attribute
 *   'id' of a {@link UnitDefinition} has the effect of redefining the model-wide
 *   default units for the corresponding quantities.  The list of
 *   predefined units is given in the table below:
 * <p>
 *   <center>
<table border='0' class='text-table width80 normal-font alt-row-colors'>
 <tr>
     <th align='left'>Identifier</th>
     <th align='left'>Possible scalable units</th>
     <th align='left'>Default units</th>
 </tr>
<tr><td><code>substance</code></td><td>mole, item, gram, kilogram, dimensionless</td><td>mole</td></tr>
<tr><td><code>volume</code></td><td>litre, cubic metre, dimensionless</td><td>litre</td></tr>
<tr><td><code>area</code></td><td>square metre, dimensionless</td><td>square metre</td></tr>
<tr><td><code>length</code></td><td>metre, dimensionless</td><td>metre</td></tr>
<tr><td><code>time</code></td><td>second, dimensionless</td><td>second</td></tr>
</table>
</center>

 * <p>
 *   Also, two limitations are imposed on redefining the predefined
 *   unit <code>substance</code>, <code>volume</code>, <code>area</code>, <code>length</code>, and <code>time</code>:
 *   (1) The {@link UnitDefinition} of a predefined SBML unit can only
 *      contain a single {@link Unit} object within it.
 *   (2) The value of the 'kind' attribute in 
 *      a {@link Unit} instance must be drawn from one of the values
 *      in the second column of the table above.
 * </ul>
 * <p>
 * A {@link UnitDefinition} must contain exactly one {@link ListOfUnits}, and this list
 * must contain one or more {@link Unit} definitions; see the definitions of these
 * other object classes for more information about them.  The following
 * example illustrates a complete unit definition (when written in XML)
 * when they all the pieces are combined together.  This defines 'mmls'
 * to be millimoles per litre per second.
 * <div class='fragment'><pre>
 * &lt;listOfUnitDefinitions&gt;
 *     &lt;unitDefinition id='mmls'&gt;
 *         &lt;listOfUnits&gt;
 *             &lt;unit kind='mole'   scale='-3'/&gt;
 *             &lt;unit kind='litre'  exponent='-1'/&gt;
 *             &lt;unit kind='second' exponent='-1'/&gt;
 *         &lt;/listOfUnits&gt;
 *     &lt;/unitDefinition&gt;
 * &lt;/listOfUnitDefinitions&gt;</pre></div>
 * <p>
 * <p>
 * <h2>Further comments about SBML's unit definition system</h2>
 * <p>
 * The vast majority of modeling situations requiring new SBML unit
 * definitions involve simple multiplicative combinations of base units and
 * factors.  An example of this might be <em>moles per litre per
 * second</em>.  What distinguishes these sorts of simpler unit definitions
 * from more complex ones is that they may be expressed without the use of
 * an additive offset from a zero point.  The use of offsets complicates
 * all unit definition systems, yet in the domain of SBML the real-life
 * cases requiring offsets are few (and in fact, to the best of our
 * knowledge, only involve temperature).  Consequently, the SBML unit
 * system has been consciously designed in a way that attempts to simplify
 * implementation of unit support for the most common cases in systems
 * biology.
 * <p>
 * As of SBML Level&nbsp;2 Version&nbsp;2, {@link Unit} no longer has the
 * attribute called 'offset' introduced in SBML Level&nbsp;2
 * Version&nbsp;1.  It turned out that the general case involving units
 * with offsets was incorrectly defined, and few (if any) developers even
 * attempted to support offset-based units in their software.  In the
 * development of Level&nbsp;2 Version&nbsp;2, a consensus among SBML
 * developers emerged that a fully generalized unit scheme is <em>so</em>
 * confusing and complicated that it actually <em>impedes</em> interoperability.
 * SBML Level&nbsp;2 Version&nbsp;2, Version&nbsp;3 and Version&nbsp;4 acknowledge this
 * reality by reducing and simplifying the unit system, specifically by
 * removing the 'offset' attribute on {@link Unit} and <code>Celsius</code> as a pre-defined
 * unit.
 * <p>
 * The following guidelines suggest methods for handling units that do
 * require the use of zero offsets for their definitions:
 * <ul>
 * <li> <em>Handling Celsius</em>.  A model in which certain quantities are
 *   temperatures measured in degrees Celsius can be converted
 *   straightforwardly to a model in which those temperatures are in
 *   kelvin.  A software tool could do this by performing a straightforward
 *   substitution using the following relationship: T<sub> kelvin</sub> =
 *   T<sub> Celsius</sub> + 273.15.  In every mathematical formula of the
 *   model where a quantity (call it <em>x</em>) in degrees Celsius appears,
 *   replace <em>x</em> with x<sub> k</sub>+ 273.15, where x<sub> k</sub> is now
 *   in kelvin.  An alternative approach would be to use a
 *   {@link FunctionDefinition} to define a function encapsulating this
 *   relationship above and then using that in the rest of the model as
 *   needed.  Since Celsius is a commonly-used unit, software tools could
 *   help users by providing users with the ability to express temperatures
 *   in Celsius in the tools' interfaces, and making substitutions
 *   automatically when writing out the SBML.
 * <p>
 * <li> <em>Other units requiring offsets</em>.  One approach to handling
 *   other kinds of units is to use a {@link FunctionDefinition} to define a function
 *   encapsulating the necessary mathematical relationship, then
 *   substituting a call to this function wherever the original quantity
 *   appeared in the model.  For example, here is a possible definition for
 *   converting Fahrenheit to Celsius degrees:
 *   <div class='fragment'><pre>
 * &lt;functionDefinition id='Fahrenheit_to_kelvin'&gt;
 *     &lt;math xmlns='http://www.w3.org/1998/Math/MathML'&gt;
 *         &lt;lambda&gt;
 *             &lt;bvar&gt;&lt;ci&gt; temp_in_fahrenheit &lt;/ci&gt;&lt;/bvar&gt;
 *             &lt;apply&gt;
 *                 &lt;divide/&gt;
 *                 &lt;apply&gt;
 *                     &lt;plus/&gt;
 *                     &lt;ci&gt; temp_in_fahrenheit &lt;/ci&gt;
 *                     &lt;cn&gt; 459.67 &lt;/cn&gt;
 *                 &lt;/apply&gt;
 *                 &lt;cn&gt; 1.8 &lt;/cn&gt;
 *             &lt;/apply&gt;
 *         &lt;/lambda&gt;
 *     &lt;/math&gt;
 * &lt;/functionDefinition&gt;</pre></div>
 * <p>
 * <li> An alternative approach not requiring the use of function definitions
 *   is to use an {@link AssignmentRule} for each variable in Fahrenheit units.
 *   The {@link AssignmentRule} could compute the conversion from Fahrenheit to
 *   (say) kelvin, assign its value to a variable (in Kelvin units), and
 *   then that variable could be used elsewhere in the model.
 * <p>
 * <li> Still another approach is to rewrite the mathematical formulas of a
 *   model to directly incorporate the conversion formula wherever the
 *   original quantity appeared.
 * </ul>
 * <p>
 * Please consult the SBML specifications for more information about this
 * and other issues involving units.
 * <p>
 * <!-- leave this next break as-is to work around some doxygen bug -->
 */

public class UnitDefinition extends SBase {
   private long swigCPtr;

   protected UnitDefinition(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.SWIGUnitDefinitionUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(UnitDefinition obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (UnitDefinition obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      libsbmlJNI.delete_UnitDefinition(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  
  /**
   * Creates a new {@link UnitDefinition} instance, optionally with specific values
   * of <code>id</code> and <code>name</code>.
   * <p>
   * The permitted values of the identifier <code>id</code> <em>exclude</em> the
   * predefined base units in SBML and two spelling variants <code>'meter'</code> and
   * <code>'liter'</code>.  More specifically, the following is the set of base unit
   * names which are <em>excluded</em> from being used as a value of <code>id</code>:
   * <p>
   * <table align='center' style='font-family: Courier, fixed; font-weight: bold; font-size: 12px;' cellspacing='7' border='0'>
<tr><td>ampere</td><td>gram</td><td>katal</td><td>lux</td><td>pascal</td><td>tesla</td></tr>
<tr><td>becquerel</td><td>gray</td><td>kelvin</td><td>meter</td><td>radian</td><td>volt</td></tr>
<tr><td>candela</td><td>henry</td><td>kilogram</td><td>metre</td><td>second</td><td>watt</td></tr>
<tr><td>coulomb</td><td>hertz</td><td>liter</td><td>mole</td><td>siemens</td><td>weber</td></tr>
<tr><td>dimensionless</td><td>item</td><td>litre</td><td>newton</td><td>sievert</td></tr>
<tr><td>farad</td><td>joule</td><td>lumen</td><td>ohm</td><td>steradian</td></tr>
</table>

   * <p>
   * In addition, there is a set of reserved identifiers for the predefined
   * default units in SBML.  These identifiers are <code>substance</code>, <code>volume</code>,
   * <code>area</code>, <code>length</code>, and <code>time</code>.  Using one of these values for the
   * attribute <code>id</code> of a {@link UnitDefinition} has the special meaning of 
   * <em>redefining</em> the model-wide default units for the corresponding
   * quantities.  The list of reserved unit names is given in the table below:
   * <p>
   * <center>
<table border='0' class='text-table width80 normal-font alt-row-colors'>
 <tr>
     <th align='left'>Identifier</th>
     <th align='left'>Possible scalable units</th>
     <th align='left'>Default units</th>
 </tr>
<tr><td><code>substance</code></td><td>mole, item, gram, kilogram, dimensionless</td><td>mole</td></tr>
<tr><td><code>volume</code></td><td>litre, cubic metre, dimensionless</td><td>litre</td></tr>
<tr><td><code>area</code></td><td>square metre, dimensionless</td><td>square metre</td></tr>
<tr><td><code>length</code></td><td>metre, dimensionless</td><td>metre</td></tr>
<tr><td><code>time</code></td><td>second, dimensionless</td><td>second</td></tr>
</table>
</center>

   * <p>
   * Finally, note that SBML imposes two limitations on redefining the
   * predefined units listed above:
   * <ul>
   * <li> The {@link UnitDefinition} of a predefined SBML unit can only
   *      contain a single {@link Unit} object within it.
   * <li> The value of the 'kind' attribute in 
   *      a {@link Unit} instance must be drawn from one of the values
   *      in the second column of the table above.
   * </ul>
   * <p>
   * @param id the identifier to assign to the new unit definition.
   * <p>
   * @param name an optional name to assign to the new unit definition.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public UnitDefinition(String id, String name) {
    this(libsbmlJNI.new_UnitDefinition__SWIG_0(id, name), true);
  }

  
  /**
   * Creates a new {@link UnitDefinition} instance, optionally with specific values
   * of <code>id</code> and <code>name</code>.
   * <p>
   * The permitted values of the identifier <code>id</code> <em>exclude</em> the
   * predefined base units in SBML and two spelling variants <code>'meter'</code> and
   * <code>'liter'</code>.  More specifically, the following is the set of base unit
   * names which are <em>excluded</em> from being used as a value of <code>id</code>:
   * <p>
   * <table align='center' style='font-family: Courier, fixed; font-weight: bold; font-size: 12px;' cellspacing='7' border='0'>
<tr><td>ampere</td><td>gram</td><td>katal</td><td>lux</td><td>pascal</td><td>tesla</td></tr>
<tr><td>becquerel</td><td>gray</td><td>kelvin</td><td>meter</td><td>radian</td><td>volt</td></tr>
<tr><td>candela</td><td>henry</td><td>kilogram</td><td>metre</td><td>second</td><td>watt</td></tr>
<tr><td>coulomb</td><td>hertz</td><td>liter</td><td>mole</td><td>siemens</td><td>weber</td></tr>
<tr><td>dimensionless</td><td>item</td><td>litre</td><td>newton</td><td>sievert</td></tr>
<tr><td>farad</td><td>joule</td><td>lumen</td><td>ohm</td><td>steradian</td></tr>
</table>

   * <p>
   * In addition, there is a set of reserved identifiers for the predefined
   * default units in SBML.  These identifiers are <code>substance</code>, <code>volume</code>,
   * <code>area</code>, <code>length</code>, and <code>time</code>.  Using one of these values for the
   * attribute <code>id</code> of a {@link UnitDefinition} has the special meaning of 
   * <em>redefining</em> the model-wide default units for the corresponding
   * quantities.  The list of reserved unit names is given in the table below:
   * <p>
   * <center>
<table border='0' class='text-table width80 normal-font alt-row-colors'>
 <tr>
     <th align='left'>Identifier</th>
     <th align='left'>Possible scalable units</th>
     <th align='left'>Default units</th>
 </tr>
<tr><td><code>substance</code></td><td>mole, item, gram, kilogram, dimensionless</td><td>mole</td></tr>
<tr><td><code>volume</code></td><td>litre, cubic metre, dimensionless</td><td>litre</td></tr>
<tr><td><code>area</code></td><td>square metre, dimensionless</td><td>square metre</td></tr>
<tr><td><code>length</code></td><td>metre, dimensionless</td><td>metre</td></tr>
<tr><td><code>time</code></td><td>second, dimensionless</td><td>second</td></tr>
</table>
</center>

   * <p>
   * Finally, note that SBML imposes two limitations on redefining the
   * predefined units listed above:
   * <ul>
   * <li> The {@link UnitDefinition} of a predefined SBML unit can only
   *      contain a single {@link Unit} object within it.
   * <li> The value of the 'kind' attribute in 
   *      a {@link Unit} instance must be drawn from one of the values
   *      in the second column of the table above.
   * </ul>
   * <p>
   * @param id the identifier to assign to the new unit definition.
   * <p>
   * @param name an optional name to assign to the new unit definition.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public UnitDefinition(String id) {
    this(libsbmlJNI.new_UnitDefinition__SWIG_1(id), true);
  }

  
  /**
   * Creates a new {@link UnitDefinition} instance, optionally with specific values
   * of <code>id</code> and <code>name</code>.
   * <p>
   * The permitted values of the identifier <code>id</code> <em>exclude</em> the
   * predefined base units in SBML and two spelling variants <code>'meter'</code> and
   * <code>'liter'</code>.  More specifically, the following is the set of base unit
   * names which are <em>excluded</em> from being used as a value of <code>id</code>:
   * <p>
   * <table align='center' style='font-family: Courier, fixed; font-weight: bold; font-size: 12px;' cellspacing='7' border='0'>
<tr><td>ampere</td><td>gram</td><td>katal</td><td>lux</td><td>pascal</td><td>tesla</td></tr>
<tr><td>becquerel</td><td>gray</td><td>kelvin</td><td>meter</td><td>radian</td><td>volt</td></tr>
<tr><td>candela</td><td>henry</td><td>kilogram</td><td>metre</td><td>second</td><td>watt</td></tr>
<tr><td>coulomb</td><td>hertz</td><td>liter</td><td>mole</td><td>siemens</td><td>weber</td></tr>
<tr><td>dimensionless</td><td>item</td><td>litre</td><td>newton</td><td>sievert</td></tr>
<tr><td>farad</td><td>joule</td><td>lumen</td><td>ohm</td><td>steradian</td></tr>
</table>

   * <p>
   * In addition, there is a set of reserved identifiers for the predefined
   * default units in SBML.  These identifiers are <code>substance</code>, <code>volume</code>,
   * <code>area</code>, <code>length</code>, and <code>time</code>.  Using one of these values for the
   * attribute <code>id</code> of a {@link UnitDefinition} has the special meaning of 
   * <em>redefining</em> the model-wide default units for the corresponding
   * quantities.  The list of reserved unit names is given in the table below:
   * <p>
   * <center>
<table border='0' class='text-table width80 normal-font alt-row-colors'>
 <tr>
     <th align='left'>Identifier</th>
     <th align='left'>Possible scalable units</th>
     <th align='left'>Default units</th>
 </tr>
<tr><td><code>substance</code></td><td>mole, item, gram, kilogram, dimensionless</td><td>mole</td></tr>
<tr><td><code>volume</code></td><td>litre, cubic metre, dimensionless</td><td>litre</td></tr>
<tr><td><code>area</code></td><td>square metre, dimensionless</td><td>square metre</td></tr>
<tr><td><code>length</code></td><td>metre, dimensionless</td><td>metre</td></tr>
<tr><td><code>time</code></td><td>second, dimensionless</td><td>second</td></tr>
</table>
</center>

   * <p>
   * Finally, note that SBML imposes two limitations on redefining the
   * predefined units listed above:
   * <ul>
   * <li> The {@link UnitDefinition} of a predefined SBML unit can only
   *      contain a single {@link Unit} object within it.
   * <li> The value of the 'kind' attribute in 
   *      a {@link Unit} instance must be drawn from one of the values
   *      in the second column of the table above.
   * </ul>
   * <p>
   * @param id the identifier to assign to the new unit definition.
   * <p>
   * @param name an optional name to assign to the new unit definition.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public UnitDefinition() {
    this(libsbmlJNI.new_UnitDefinition__SWIG_2(), true);
  }

  
  /**
   * Creates a new {@link UnitDefinition} using the given SBML <code>level</code> and <code>version</code>
   * values and optionally a set of XMLNamespaces.
   * <p>
   * @param level a long integer, the SBML Level to assign to this {@link UnitDefinition}
   * <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link UnitDefinition}
   * <p>
   * @param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
   * assign to this {@link UnitDefinition}
   * <p>
   * @note Once a {@link UnitDefinition} has been added to an {@link SBMLDocument}, the <code>level</code>,
   * <code>version</code> and <code>xmlns</code> namespaces for the document <em>override</em> those used
   * to create the {@link UnitDefinition}.  Despite this, the ability to supply the values
   * at creation time is an important aid to creating valid SBML.  Knowledge of
   * the intented SBML Level and Version determine whether it is valid to
   * assign a particular value to an attribute, or whether it is valid to add
   * an object to an existing {@link SBMLDocument}.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   <p>
 * @deprecated libSBML internal
 */
 public UnitDefinition(long level, long version, XMLNamespaces xmlns) {
    this(libsbmlJNI.new_UnitDefinition__SWIG_3(level, version, XMLNamespaces.getCPtr(xmlns), xmlns), true);
  }

  
  /**
   * Creates a new {@link UnitDefinition} using the given SBML <code>level</code> and <code>version</code>
   * values and optionally a set of XMLNamespaces.
   * <p>
   * @param level a long integer, the SBML Level to assign to this {@link UnitDefinition}
   * <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link UnitDefinition}
   * <p>
   * @param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
   * assign to this {@link UnitDefinition}
   * <p>
   * @note Once a {@link UnitDefinition} has been added to an {@link SBMLDocument}, the <code>level</code>,
   * <code>version</code> and <code>xmlns</code> namespaces for the document <em>override</em> those used
   * to create the {@link UnitDefinition}.  Despite this, the ability to supply the values
   * at creation time is an important aid to creating valid SBML.  Knowledge of
   * the intented SBML Level and Version determine whether it is valid to
   * assign a particular value to an attribute, or whether it is valid to add
   * an object to an existing {@link SBMLDocument}.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   <p>
 * @deprecated libSBML internal
 */
 public UnitDefinition(long level, long version) {
    this(libsbmlJNI.new_UnitDefinition__SWIG_4(level, version), true);
  }

  
  /**
  * Copy constructor; creates a copy of this {@link UnitDefinition}.
  */
 public UnitDefinition(UnitDefinition orig) {
    this(libsbmlJNI.new_UnitDefinition__SWIG_5(UnitDefinition.getCPtr(orig), orig), true);
  }

  
  /**
   * Creates and returns a deep copy of this {@link UnitDefinition}.
   * <p>
   * @return a (deep) copy of this {@link UnitDefinition}.
   */
 public UnitDefinition cloneObject() {
    long cPtr = libsbmlJNI.UnitDefinition_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new UnitDefinition(cPtr, true);
  }

  
  /**
   * Convenience function for testing if a given unit definition is a
   * variant of the predefined unit identifier <code>'area'</code>.
   * <p>
   * @return <code>true</code> if this {@link UnitDefinition} is a variant of the predefined
   * unit <code>area</code>, meaning square metres with only abritrary variations
   * in scale or multiplier values; <code>false</code> otherwise.
   */
 public boolean isVariantOfArea() {
    return libsbmlJNI.UnitDefinition_isVariantOfArea(swigCPtr, this);
  }

  
  /**
   * Convenience function for testing if a given unit definition is a
   * variant of the predefined unit identifier <code>'length'</code>.
   * <p>
   * @return <code>true</code> if this {@link UnitDefinition} is a variant of the predefined
   * unit <code>length</code>, meaning metres with only abritrary variations in scale
   * or multiplier values; <code>false</code> otherwise.
   */
 public boolean isVariantOfLength() {
    return libsbmlJNI.UnitDefinition_isVariantOfLength(swigCPtr, this);
  }

  
  /**
   * Convenience function for testing if a given unit definition is a
   * variant of the predefined unit identifier <code>'substance'</code>.
   * <p>
   * @return <code>true</code> if this {@link UnitDefinition} is a variant of the predefined
   * unit <code>substance</code>, meaning moles or items (and grams or kilograms from
   * SBML Level&nbsp;2 Version&nbsp;2 onwards) with only abritrary variations
   * in scale or multiplier values; <code>false</code> otherwise.
   */
 public boolean isVariantOfSubstance() {
    return libsbmlJNI.UnitDefinition_isVariantOfSubstance(swigCPtr, this);
  }

  
  /**
   * Convenience function for testing if a given unit definition is a
   * variant of the predefined unit identifier <code>'time'</code>.
   * <p>
   * @return <code>true</code> if this {@link UnitDefinition} is a variant of the predefined
   * unit <code>time</code>, meaning seconds with only abritrary variations in scale or
   * multiplier values; <code>false</code> otherwise.
   */
 public boolean isVariantOfTime() {
    return libsbmlJNI.UnitDefinition_isVariantOfTime(swigCPtr, this);
  }

  
  /**
   * Convenience function for testing if a given unit definition is a
   * variant of the predefined unit identifier <code>'volume'</code>.
   * <p>
   * @return <code>true</code> if this {@link UnitDefinition} is a variant of the predefined
   * unit <code>volume</code>, meaning litre or cubic metre with only abritrary
   * variations in scale or multiplier values; <code>false</code> otherwise.
   */
 public boolean isVariantOfVolume() {
    return libsbmlJNI.UnitDefinition_isVariantOfVolume(swigCPtr, this);
  }

  
  /**
   * Convenience function for testing if a given unit definition is a
   * variant of the unit <code>'dimensionless'</code>.
   * <p>
   * @return <code>true</code> if this {@link UnitDefinition} is a variant of 
   * <code>dimensionless</code>, meaning dimensionless with only abritrary variations in
   * scale or multiplier values; <code>false</code> otherwise.
   */
 public boolean isVariantOfDimensionless() {
    return libsbmlJNI.UnitDefinition_isVariantOfDimensionless(swigCPtr, this);
  }

  
  /**
   * Convenience function for testing if a given unit definition is a
   * variant of the predefined unit identifier <code>'mass'</code>.
   * <p>
   * @return <code>true</code> if this {@link UnitDefinition} is a variant of mass units,
   * meaning gram or kilogram with only abritrary variations in scale or
   * multiplier values; <code>false</code> otherwise.
   */
 public boolean isVariantOfMass() {
    return libsbmlJNI.UnitDefinition_isVariantOfMass(swigCPtr, this);
  }

  
  /**
   * Convenience function for testing if a given unit definition is a
   * variant of the predefined unit <code>'substance'</code> divided by the predefined
   * unit <code>'time'</code>.
   * <p>
   * @return <code>true</code> if this {@link UnitDefinition} is a variant of the predefined
   * unit <code>substance</code> per predefined unit <code>time</code>, meaning it contains two
   * units one of which is a variant of substance and the other is a
   * variant of time which an exponent of -1; <code>false</code> otherwise.
   */
 public boolean isVariantOfSubstancePerTime() {
    return libsbmlJNI.UnitDefinition_isVariantOfSubstancePerTime(swigCPtr, this);
  }

  
  /**
   * Adds a copy of the given {@link Unit} to this {@link UnitDefinition}.
   * <p>
   * @param u the {@link Unit} instance to add to this {@link UnitDefinition}.
   * <p>
   * @note This method should be used with some caution.  The fact that
   * this method <em>copies</em> the object passed to it means that the caller
   * will be left holding a physically different object instance than the
   * one contained in this {@link UnitDefinition}.  Changes made to the original
   * object instance (such as resetting attribute values) will <em>not
   * affect the instance in the {@link UnitDefinition}</em>.  In addition, the
   * caller should make sure to free the original object if it is no longer
   * being used, or else a memory leak will result.  Please see
   * {@link UnitDefinition#createUnit()} for a method that does not lead to these
   * issues.
   * <p>
   * @see #createUnit()
   */
 public void addUnit(Unit u) {
    libsbmlJNI.UnitDefinition_addUnit(swigCPtr, this, Unit.getCPtr(u), u);
  }

  
  /**
   * Creates a new and empty {@link Unit}, adds it to this {@link UnitDefinition}'s list of
   * units, and returns it.
   * <p>
   * @return a newly constructed (and empty) {@link Unit} instance.
   * <p>
   * @note It is worth emphasizing that the attribute 'kind' value of a
   * {@link Unit} is a required attribute for a valid {@link Unit} definition.  The
   * createUnit() method does not assign a valid kind to the constructed
   * unit (instead, it sets the 'kind' to <code>UNIT_KIND_INVALID</code>).  Callers
   * are cautioned to set the newly-constructed {@link Unit}'s kind using
   * {@link Unit#setKind()} soon after calling this method.
   * <p>
   * @see #addUnit()
   */
 public Unit createUnit() {
    long cPtr = libsbmlJNI.UnitDefinition_createUnit(swigCPtr, this);
    return (cPtr == 0) ? null : new Unit(cPtr, false);
  }

  
  /**
   * Returns the list of Units for this {@link UnitDefinition} instance.
   * @return the {@link ListOfUnits} value for this {@link UnitDefinition}.
   */
 public ListOfUnits getListOfUnits() {
    long cPtr = libsbmlJNI.UnitDefinition_getListOfUnits__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ListOfUnits(cPtr, false);
  }

  
  /**
   * Returns a specific {@link Unit} instance belonging to this {@link UnitDefinition}.
   * <p>
   * @param n an integer, the index of the {@link Unit} to be returned.
   * <p>
   * @return the nth {@link Unit} of this {@link UnitDefinition}
   * <p>
   * @see #getNumUnits()
   */
 public Unit getUnit(long n) {
    long cPtr = libsbmlJNI.UnitDefinition_getUnit__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new Unit(cPtr, false);
  }

  
  /**
   * Returns the number of {@link Unit} objects contained within this
   * {@link UnitDefinition}.
   * <p>
   * @return an integer representing the number of Units in this
   * {@link UnitDefinition}.
   */
 public long getNumUnits() {
    return libsbmlJNI.UnitDefinition_getNumUnits(swigCPtr, this);
  }

  
  /**
   * Sets the parent {@link SBMLDocument} of this SBML object.
   * <p>
   * @param d the {@link SBMLDocument} to use
   <p>
 * @deprecated libSBML internal
 */
 public void setSBMLDocument(SBMLDocument d) {
    libsbmlJNI.UnitDefinition_setSBMLDocument(swigCPtr, this, SBMLDocument.getCPtr(d), d);
  }

  
  /**
   * Sets the parent SBML object of this SBML object.
   * <p>
   * @param sb the SBML object to use
   <p>
 * @deprecated libSBML internal
 */
 public void setParentSBMLObject(SBase sb) {
    libsbmlJNI.UnitDefinition_setParentSBMLObject(swigCPtr, this, SBase.getCPtr(sb), sb);
  }

  
  /**
   * Returns the libSBML type code for this object instance.
   * <p>
   * LibSBML attaches an
   * identifying code to every kind of SBML object.  These are known as
   * <em>SBML type codes</em>.  In other languages, the set of type codes
   * is stored in an enumeration; in the Java language interface for
   * libSBML, the type codes are defined as static integer constants in
   * interface class {@link libsbmlConstants}.  The names of the type codes
   * all begin with the characters <code>SBML_</code>. 
   * <p>
   * @return the SBML type code for this object, or <code>SBML_UNKNOWN</code> (default).
   * <p>
   * @see #getElementName()
   */
 public int getTypeCode() {
    return libsbmlJNI.UnitDefinition_getTypeCode(swigCPtr, this);
  }

  
  /**
   * Returns the XML element name of this object, which for {@link UnitDefinition},
   * is always <code>'unitDefinition'</code>.
   * <p>
   * @return the name of this element, i.e., <code>'unitDefinition'</code>.
   */
 public String getElementName() {
    return libsbmlJNI.UnitDefinition_getElementName(swigCPtr, this);
  }

  
  /** 
  * Simplifies the {@link UnitDefinition} so that any {@link Unit} objects occurring within
  * the {@link ListOfUnits} occurs only once.
  * <p>
  * For example, the following definition,
  * <div class='fragment'><pre>
  * &lt;unitDefinition&gt;
  *  &lt;listOfUnits&gt;
  *    &lt;unit kind='metre' exponent='1'/&gt;
  *    &lt;unit kind='metre' exponent='2'/&gt;
  *  &lt;/listOfUnits&gt;
  * &lt;unitDefinition&gt;</pre></div>
  * will be simplified to 
  * <div class='fragment'><pre>
  * &lt;unitDefinition&gt;
  *   &lt;listOfUnits&gt;
  *     &lt;unit kind='metre' exponent='3'/&gt;
  *   &lt;/listOfUnits&gt;
  * &lt;unitDefinition&gt;</pre></div>
  * <p>
  * @param ud the {@link UnitDefinition} object to be simplified.
  */
 public static void simplify(UnitDefinition ud) {
    libsbmlJNI.UnitDefinition_simplify(UnitDefinition.getCPtr(ud), ud);
  }

  
  /** 
   * Orders alphabetically the {@link Unit} objects within the {@link ListOfUnits} of a
   * {@link UnitDefinition}.
   * <p>
   * @param ud the {@link UnitDefinition} object whose units are to be reordered.
   */
 public static void reorder(UnitDefinition ud) {
    libsbmlJNI.UnitDefinition_reorder(UnitDefinition.getCPtr(ud), ud);
  }

  
  /**
   * Convert a given {@link UnitDefinition} into a new {@link UnitDefinition} object
   * that uses SI units.
   * <p>
   * @param ud the {@link UnitDefinition} object to convert to SI
   * <p>
   * @return a new {@link UnitDefinition} object representing the results of the
   * conversion.
   */
 public static UnitDefinition convertToSI(UnitDefinition arg0) {
    long cPtr = libsbmlJNI.UnitDefinition_convertToSI(UnitDefinition.getCPtr(arg0), arg0);
    return (cPtr == 0) ? null : new UnitDefinition(cPtr, true);
  }

  
  /** 
   * Predicate returning <code>true</code> or <code>false</code> depending on whether two
   * {@link UnitDefinition} objects are identical.
   * <p>
   * For the purposes of performing this comparison, two {@link UnitDefinition}
   * objects are considered identical when they contain identical lists of
   * {@link Unit} objects.  Pairs of {@link Unit} objects in the lists are in turn
   * considered identical if they satisfy the predicate
   * {@link Unit#areIdentical()}.  The predicate compares every attribute of the
   * {@link Unit} objects.
   * <p>
   * @param ud1 the first {@link UnitDefinition} object to compare
   * @param ud2 the second {@link UnitDefinition} object to compare
   * <p>
   * @return <code>true</code> if all the {@link Unit} objects in ud1 are identical to the
   * {@link Unit} objects of ud2, <code>false</code> otherwise.
   * <p>
   * @see #areEquivalent()
   * @see Unit#areIdentical()
   */
 public static boolean areIdentical(UnitDefinition ud1, UnitDefinition ud2) {
    return libsbmlJNI.UnitDefinition_areIdentical(UnitDefinition.getCPtr(ud1), ud1, UnitDefinition.getCPtr(ud2), ud2);
  }

  
  /** 
   * Predicate returning <code>true</code> or <code>false</code> depending on whether two
   * {@link UnitDefinition} objects are equivalent.
   * <p>
   * For the purposes of performing this comparison, two {@link UnitDefinition}
   * objects are considered equivalent when they contain <em>equivalent</em>
   * list of {@link Unit} objects.  {@link Unit} objects are in turn considered equivalent
   * if they satisfy the predicate {@link Unit#areEquivalent()}.  The predicate
   * tests a subset of the objects's attributes.
   * <p>
   * @param ud1 the first {@link UnitDefinition} object to compare
   * <p>
   * @param ud2 the second {@link UnitDefinition} object to compare
   * <p>
   * @return <code>true</code> if all the {@link Unit} objects in ud1 are equivalent
   * to the {@link Unit} objects in ud2, <code>false</code> otherwise.
   * <p>
   * @see #areIdentical()
   * @see Unit#areEquivalent()
   */
 public static boolean areEquivalent(UnitDefinition ud1, UnitDefinition ud2) {
    return libsbmlJNI.UnitDefinition_areEquivalent(UnitDefinition.getCPtr(ud1), ud1, UnitDefinition.getCPtr(ud2), ud2);
  }

  
  /** 
   * Combines two {@link UnitDefinition} objects into a single {@link UnitDefinition}
   * object which expresses the product of the units of the two
   * {@link UnitDefinition}'s.
   * <p>
   * @param ud1 the first {@link UnitDefinition} object 
   * @param ud2 the second {@link UnitDefinition} object
   * <p>
   * @return a {@link UnitDefinition} which represents the product of the 
   * units of the two argument UnitDefinitions.
   */
 public static UnitDefinition combine(UnitDefinition ud1, UnitDefinition ud2) {
    long cPtr = libsbmlJNI.UnitDefinition_combine(UnitDefinition.getCPtr(ud1), ud1, UnitDefinition.getCPtr(ud2), ud2);
    return (cPtr == 0) ? null : new UnitDefinition(cPtr, true);
  }

  
  /** 
   * Returns a string that expresses the unit definition
   * represented by this {@link UnitDefinition} object.
   * <p>
   * For example printUnits applied to
   * <div class='fragment'><pre>
   * &lt;unitDefinition&gt;
   *  &lt;listOfUnits&gt;
   *    &lt;unit kind='metre' exponent='1'/&gt;
   *    &lt;unit kind='second' exponent='-2'/&gt;
   *  &lt;/listOfUnits&gt;
   * &lt;unitDefinition&gt;</pre></div>
   * will return the string <code>'metre (exponent = 1, multiplier = 1, scale = 0) 
   * second (exponent = -2, multiplier = 1, scale = 0)'</code> or, if 
   * compact = true, the string <code>'(1 metre)^1 (1 second)^-2'</code>
   * This may be useful for printing unit information to
   * human users, or in debugging, or other situations.
   * <p>
   * @param ud the {@link UnitDefinition} object
   * @param compact boolean indicating whether the compact form
   * should be used (defaults to false)
   * <p>
   * @return a string expressing the unit definition
   */
 public static String printUnits(UnitDefinition ud, boolean compact) {
    return libsbmlJNI.UnitDefinition_printUnits__SWIG_0(UnitDefinition.getCPtr(ud), ud, compact);
  }

  
  /** 
   * Returns a string that expresses the unit definition
   * represented by this {@link UnitDefinition} object.
   * <p>
   * For example printUnits applied to
   * <div class='fragment'><pre>
   * &lt;unitDefinition&gt;
   *  &lt;listOfUnits&gt;
   *    &lt;unit kind='metre' exponent='1'/&gt;
   *    &lt;unit kind='second' exponent='-2'/&gt;
   *  &lt;/listOfUnits&gt;
   * &lt;unitDefinition&gt;</pre></div>
   * will return the string <code>'metre (exponent = 1, multiplier = 1, scale = 0) 
   * second (exponent = -2, multiplier = 1, scale = 0)'</code> or, if 
   * compact = true, the string <code>'(1 metre)^1 (1 second)^-2'</code>
   * This may be useful for printing unit information to
   * human users, or in debugging, or other situations.
   * <p>
   * @param ud the {@link UnitDefinition} object
   * @param compact boolean indicating whether the compact form
   * should be used (defaults to false)
   * <p>
   * @return a string expressing the unit definition
   */
 public static String printUnits(UnitDefinition ud) {
    return libsbmlJNI.UnitDefinition_printUnits__SWIG_1(UnitDefinition.getCPtr(ud), ud);
  }

}
