/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.38
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * LibSBML implementation of SBML's Species construct.
 * <p>
 * A <em>species</em> refers to a pool of reacting entities of a specific
 * <em>species type</em> that take part in reactions and are located in a
 * specific <em>compartment</em>.  The {@link Species} data structure is intended to
 * represent these pools.  A {@link Species} definition has several parts: an
 * optional identifier (defined by the attribute 'id'), an optional name
 * (defined by the attribute 'name'), a required attribute 'compartment',
 * and optional attributes 'speciesType', 'initialAmount',
 * 'initialConcentration', 'substanceUnits', 'hasOnlySubstanceUnits',
 * 'boundaryCondition', 'charge' and 'constant'.  These various parts are
 * described next.
 * <p>
 * As with other major structures in SBML, {@link Species} has a mandatory
 * attribute, 'id', used to give the species type an identifier in the
 * model.  The identifier must be a text string conforming to the identifer
 * syntax permitted in SBML.  {@link Species} also has an optional 'name'
 * attribute, of type <code>string</code>.  The 'id' and 'name' must be used
 * according to the guidelines described in the SBML specification (e.g.,
 * Section 3.3 in the Level&nbsp;2 Version&nbsp;4 specification).
 * <p>
 * The required attribute 'compartment' is used to identify the compartment
 * in which the species is located.  The attribute's value must be the
 * identifier of an existing {@link Compartment} structure.  It is important to
 * note that there is no default value for the 'compartment' attribute on
 * {@link Species}; every species in an SBML model must be assigned a compartment,
 * and consequently, a model must define at least one compartment if that
 * model contains any species.
 * <p>
 * Each species in a model may optionally be designated as belonging to a
 * particular species type.  The optional attribute 'speciesType' is used
 * to identify the species type of the chemical entities that make up the
 * pool represented by the {@link Species} structure.  The attribute's value must
 * be the identifier of an existing {@link SpeciesType} structure.  If the
 * 'speciesType' attribute is not present on a particular species
 * definition, it means the pool contains chemical entities of a type
 * unique to that pool; in effect, a virtual species type is assumed for
 * that species, and no other species can belong to that species type.  The
 * value of 'speciesType' attributes on species have no effect on the
 * numerical interpretation of a model; simulators and other numerical
 * analysis software may ignore 'speciesType' attributes.
 * <p>
 * There can be only one species of a given species type in any given
 * compartment of a model.  More specifically, for all {@link Species} structures
 * having a value for the 'speciesType' attribute, the pair
 * <center>
 * ('speciesType' attribute value, 'compartment' attribute value)
 * </center>
 * <p>
 * must be unique across the set of all {@link Species} structures in a model.
 * <p>
 * <p>
 * <h2>The initial amount and concentration of a species</h2>
 * <p>
 * The optional attributes 'initialAmount' and 'initialConcentration', both
 * having a data type of <code>double</code>, are used to set the initial quantity of
 * the species in the compartment where the species is located.  These
 * attributes are mutually exclusive; i.e., <em>only one</em> can have a
 * value on any given instance of a {@link Species} structure.  Missing
 * 'initialAmount' and 'initialConcentration' values implies that their
 * values either are unknown, or to be obtained from an external source, or
 * determined by an {@link InitialAssignment} or {@link Rule} object elsewhere in the
 * model.  In the case where a species' compartment has a
 * 'spatialDimensions' value of <code>0</code> (zero), the species cannot have a
 * value for 'initialConcentration' because the concepts of concentration
 * and density break down when a container has zero dimensions.
 * <p>
 * A species' initial quantity is set by the 'initialAmount' or
 * 'initialConcentration' attributes exactly once.  If the species'
 * 'constant' attribute is <code>true</code> (the default), then the size is fixed
 * and cannot be changed except by an {@link InitialAssignment}.  These methods
 * differ in that the 'initialAmount' and 'initialConcentration' attributes
 * can only be used to set the species quantity to a literal scalar value,
 * whereas {@link InitialAssignment} allows the value to be set using an arbitrary
 * mathematical expression.  If the species' 'constant' attribute is 
 * <code>false</code>, the species' quantity value may be overridden by an
 * {@link InitialAssignment} or changed by {@link AssignmentRule} or {@link AlgebraicRule}, and in
 * addition, for <em>t &lt; 0</em>, it may also be changed by a {@link RateRule} or
 * {@link Event}. (However, some constructs are mutually exclusive; see the SBML
 * specification for more details.)  It is not an error to define
 * 'initialAmount' or 'initialConcentration' on a species and also redefine
 * the value using an {@link InitialAssignment}, but the 'initialAmount' or
 * 'initialConcentration' setting in that case is ignored.
 * <p>
 * <h2>The units of a species' amount or concentration</h2>
 * <p>
 * The units associated with a species' quantity, referred to as the
 * <em>units of the species</em>, are determined via the optional
 * attributes 'substanceUnits' and 'hasOnlySubstanceUnits', in combination
 * with the units of the size defined for the compartment object in which
 * the species are located.  The way this is done is as follows.
 * <p>
 * The units of the value in the 'initialConcentration' attribute are 
 * <em>substance</em>/<em>size</em> units, where the units of <em>substance</em> are those
 * defined by the 'substanceUnits' attribute and the <em>size</em> units are
 * those given in the definition of the size of the {@link Compartment} in which
 * the species is located.  The units of the value in the 'initialAmount'
 * attribute are determined by the 'substanceUnits' attribute of the
 * species structure.  The role of the attribute 'hasOnlySubstanceUnits' is
 * to indicate whether the units of the species, when the species
 * identifier appears in mathematical formulas, are intended to be
 * concentration or amount.  The attribute takes on boolean values and
 * defaults to <code>false</code>.  Although it may seem as though this intention
 * could be determined based on whether 'initialConcentration' or
 * 'initialAmount' is set, the fact that these two attributes are optional
 * means that a separate flag is needed.  (Consider the situation where
 * neither is set, and instead the species' quantity is established by an
 * {@link InitialAssignment} or {@link AssignmentRule}.)
 * <p>
 * The possible values of <em>units of the species</em> are summarized in
 * the following table.  (The dependence on the number of spatial
 * dimensions of the compartment is due to the fact that a zero-dimensional
 * compartment cannot support concentrations or densities.)
 * <p>
 * <center>
<table border='0' class='text-table width80 normal-font alt-row-colors'>
<caption class='top-caption'>Interpretation of species' units.</caption>
 <tr>
     <th align='left' valign='bottom'>
       Value of<br><code>hasOnlySubstanceUnits</code>
     </th>
     <th align='left' valign='bottom'>
       <em>Units of the species</em> when<br><code>spatialDimensions</code> is greater than 0
     </th>
     <th align='left' valign='bottom'>
       <em>Units of the species</em> when<br><code>spatialDimensions</code> is 0
     </th>
 </tr>
 <tr>
     <td><code>false</code> (default)</td>
     <td><em>substance/size</em></td>
     <td><em>substance</em></td>
 </tr>
 <tr>
     <td><code>true</code> (default)</td>
     <td><em>substance</em></td>
     <td><em>substance</em></td>
 </tr>
</table>
</center>

 * <p>
 * The value assigned to 'substanceUnits' must be chosen from one of the
 * following possibilities: one of the base unit identifiers defined in
 * SBML; the built-in unit identifier <code>'substance'</code>; or the identifier of
 * a new unit defined in the list of unit definitions in the enclosing
 * {@link Model} structure.  The chosen units for 'substanceUnits' must be be 
 * <code>'dimensionless'</code>, <code>'mole'</code>, <code>'item'</code>, <code>'kilogram'</code>, <code>'gram'</code>, or
 * units derived from these.  The 'substanceUnits' attribute defaults to
 * the the built-in unit <code>'substance'</code>.
 * <p>
 * The <em>units of the species</em> are used in the following ways:
 * <ul>
 * <li> The species identifier has these units when the identifier appears
 * as a numerical quantity in a mathematical formula expressed in MathML.
 * <p>
 * <li> The 'math' subelement of an {@link AssignmentRule} or {@link InitialAssignment}
 * referring to this species must have identical units.
 * <p>
 * <li> In {@link RateRule} structures that set the rate of change of the species'
 * quantity, the units of the rule's 'math' subelement must be identical to
 * the <em>units of the species</em> divided by the model's <em>time</em> units.
 * </ul>
 * <p>
 * <h2>The 'constant' and 'boundaryCondition' attributes</h2>
 * <p>
 * The {@link Species} structure has two optional boolean attributes named
 * 'constant' and 'boundaryCondition', used to indicate whether and how the
 * quantity of that species can vary during a simulation.  The following
 * table shows how to interpret the combined values of these attributes.
 * <p>
 * <center>
<table border='0' class='text-table width80 normal-font alt-row-colors'>
<caption class='top-caption'>Interpretation
of species' <code>constant</code> and <code>boundaryCondition</code>
attributes.</caption>
 <tr>
     <th align='left' valign='bottom'>
       <code>constant</code><br>value
     </th>
     <th align='left' valign='bottom'>
       <code>boundaryCondition</code><br>value
     </th>
     <th align='left' valign='bottom'>
       Can have<br>assignment<br>or rate rule?
     </th>
     <th align='left' valign='bottom'>
       Can be<br>reactant<br>or product?
     </th>
     <th align='left' valign='bottom'>
       {@link Species}' quantity<br>can be changed by
     </th>
 </tr>
 <tr>
     <td><code>true</code></td>
     <td><code>true</code></td>
     <td>no</td>
     <td>yes</td>
     <td>(never changes)</td>
 </tr>
 <tr>
     <td><code>false</code></td>
     <td><code>true</code></td>
     <td>yes</td>
     <td>yes</td>
     <td>rules and events</td>
 </tr>
 <tr>
     <td><code>true</code></td>
     <td><code>false</code></td>
     <td>no</td>
     <td>no</td>
     <td>(never changes)</td>
 </tr>
 <tr>
     <td><code>false</code></td>
     <td><code>false</code></td>
     <td>yes</td>
     <td>yes</td>
     <td>reactions <em>or</em> rules (but not both at the same time), and events</td>
 </tr>
</table>
</center>

 * <p>
 * By default, when a species is a product or reactant of one or more
 * reactions, its quantity is determined by those reactions.  In SBML, it
 * is possible to indicate that a given species' quantity is <em>not</em>
 * determined by the set of reactions even when that species occurs as a
 * product or reactant; i.e., the species is on the <em>boundary</em> of
 * the reaction system, and its quantity is not determined by the
 * reactions.  The boolean attribute 'boundaryCondition' can be used to
 * indicate this.  The value of the attribute defaults to <code>false</code>,
 * indicating the species <em>is</em> part of the reaction system.
 * <p>
 * The 'constant' attribute indicates whether the species' quantity can be
 * changed at all, regardless of whether by reactions, rules, or constructs
 * other than {@link InitialAssignment}.  The default value is <code>false</code>, indicating
 * that the species' quantity can be changed, since the purpose of most
 * simulations is precisely to calculate changes in species quantities.
 * Note that the initial quantity of a species can be set by an
 * {@link InitialAssignment} irrespective of the value of the 'constant' attribute.
 * <p>
 * In practice, a 'boundaryCondition' value of <code>true</code> means a differential
 * equation derived from the reaction definitions should not be generated
 * for the species.  However, the species' quantity may still be changed by
 * {@link AssignmentRule}, {@link RateRule}, {@link AlgebraicRule}, {@link Event}, and {@link InitialAssignment}
 * constructs if its 'constant' attribute is <code>false</code>.  Conversely, if the
 * species' 'constant' attribute is <code>true</code>, then its value cannot be
 * changed by anything except {@link InitialAssignment}.
 * <p>
 * A species having 'boundaryCondition'=<code>false</code> and 'constant'=<code>false</code>
 * can appear as a product and/or reactant of one or more reactions in the
 * model.  If the species is a reactant or product of a reaction, it must
 * <em>not</em> also appear as the target of any {@link AssignmentRule} or {@link RateRule}
 * structure in the model.  If instead the species has
 * 'boundaryCondition'=<code>false</code> and 'constant'=<code>true</code>, then it cannot
 * appear as a reactant or product, or as the target of any
 * {@link AssignmentRule}, {@link RateRule} or {@link EventAssignment} structure in the model.
 * <p>
 * @warning In versions of SBML Level&nbsp;2 before Version&nbsp;3, the class
 * {@link Species} included an attribute called 'spatialSizeUnits, which allowed
 * explicitly setting the units of size for initial concentration.  LibSBML
 * retains this attribute for compatibility with older definitions of
 * Level&nbsp;2, but its use is strongly discouraged because it is
 * incompatible with Level&nbsp;2 Version&nbsp;3 andLevel&nbsp;2 Version&nbsp;4.
 * <p>
 * <!-- leave this next break as-is to work around some doxygen bug -->
 */

public class Species extends SBase {
   private long swigCPtr;

   protected Species(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.SWIGSpeciesUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(Species obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (Species obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      libsbmlJNI.delete_Species(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  
  /**
   * Creates a new {@link Species}, optionally with the given <code>id</code> and <code>name</code>
   * attribute values.
   * <p>
   * @param id a string, the identifier to assign to this {@link Species}
   * @param name a string, the optional name to assign to this {@link Species}
   * <p>
   * @note It is worth emphasizing that although the identifier is optional
   * for this constructor, in SBML Level&nbsp;2 and beyond, the 'id'
   * (identifier) attribute of a {@link Species} is required to have a value.
   * Thus, callers are cautioned to assign a value after calling this
   * constructor if no identifier is provided as an argument.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public Species(String id, String name) {
    this(libsbmlJNI.new_Species__SWIG_0(id, name), true);
  }

  
  /**
   * Creates a new {@link Species}, optionally with the given <code>id</code> and <code>name</code>
   * attribute values.
   * <p>
   * @param id a string, the identifier to assign to this {@link Species}
   * @param name a string, the optional name to assign to this {@link Species}
   * <p>
   * @note It is worth emphasizing that although the identifier is optional
   * for this constructor, in SBML Level&nbsp;2 and beyond, the 'id'
   * (identifier) attribute of a {@link Species} is required to have a value.
   * Thus, callers are cautioned to assign a value after calling this
   * constructor if no identifier is provided as an argument.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public Species(String id) {
    this(libsbmlJNI.new_Species__SWIG_1(id), true);
  }

  
  /**
   * Creates a new {@link Species}, optionally with the given <code>id</code> and <code>name</code>
   * attribute values.
   * <p>
   * @param id a string, the identifier to assign to this {@link Species}
   * @param name a string, the optional name to assign to this {@link Species}
   * <p>
   * @note It is worth emphasizing that although the identifier is optional
   * for this constructor, in SBML Level&nbsp;2 and beyond, the 'id'
   * (identifier) attribute of a {@link Species} is required to have a value.
   * Thus, callers are cautioned to assign a value after calling this
   * constructor if no identifier is provided as an argument.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public Species() {
    this(libsbmlJNI.new_Species__SWIG_2(), true);
  }

  
  /**
   * Creates a new {@link Species} using the given SBML <code>level</code> and <code>version</code>
   * values and optionally a set of XMLNamespaces.
   * <p>
   * It is worth emphasizing that although this constructor does not take
   * an identifier argument, in SBML Level&nbsp;2 and beyond, the 'id'
   * (identifier) attribute of a {@link Species} is required to have a value.
   * Thus, callers are cautioned to assign a value after calling this
   * constructor.  Setting the identifier can be accomplished using the
   * method {@link SBase#setId(String id)} .
   * <p>
   * @param level a long integer, the SBML Level to assign to this {@link Species}
   * <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link Species}
   * <p>
   * @param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
   * assign to this {@link Species}
   * <p>
   * @note Once a {@link Species} has been added to an {@link SBMLDocument}, the <code>level</code>,
   * <code>version</code> and <code>xmlns</code> namespaces for the document <em>override</em> those used
   * to create the {@link Species}.  Despite this, the ability to supply the values
   * at creation time is an important aid to creating valid SBML.  Knowledge of
   * the intented SBML Level and Version determine whether it is valid to
   * assign a particular value to an attribute, or whether it is valid to add
   * an object to an existing {@link SBMLDocument}.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   <p>
 * @deprecated libSBML internal
 */
 public Species(long level, long version, XMLNamespaces xmlns) {
    this(libsbmlJNI.new_Species__SWIG_3(level, version, XMLNamespaces.getCPtr(xmlns), xmlns), true);
  }

  
  /**
   * Creates a new {@link Species} using the given SBML <code>level</code> and <code>version</code>
   * values and optionally a set of XMLNamespaces.
   * <p>
   * It is worth emphasizing that although this constructor does not take
   * an identifier argument, in SBML Level&nbsp;2 and beyond, the 'id'
   * (identifier) attribute of a {@link Species} is required to have a value.
   * Thus, callers are cautioned to assign a value after calling this
   * constructor.  Setting the identifier can be accomplished using the
   * method {@link SBase#setId(String id)} .
   * <p>
   * @param level a long integer, the SBML Level to assign to this {@link Species}
   * <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link Species}
   * <p>
   * @param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
   * assign to this {@link Species}
   * <p>
   * @note Once a {@link Species} has been added to an {@link SBMLDocument}, the <code>level</code>,
   * <code>version</code> and <code>xmlns</code> namespaces for the document <em>override</em> those used
   * to create the {@link Species}.  Despite this, the ability to supply the values
   * at creation time is an important aid to creating valid SBML.  Knowledge of
   * the intented SBML Level and Version determine whether it is valid to
   * assign a particular value to an attribute, or whether it is valid to add
   * an object to an existing {@link SBMLDocument}.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   <p>
 * @deprecated libSBML internal
 */
 public Species(long level, long version) {
    this(libsbmlJNI.new_Species__SWIG_4(level, version), true);
  }

  
  /**
  * Copy constructor; creates a copy of this {@link Species}.
  */
 public Species(Species orig) {
    this(libsbmlJNI.new_Species__SWIG_5(Species.getCPtr(orig), orig), true);
  }

  
  /**
   * Creates and returns a deep copy of this {@link Species}.
   * <p>
   * @return a (deep) copy of this {@link Species}.
   */
 public Species cloneObject() {
    long cPtr = libsbmlJNI.Species_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new Species(cPtr, true);
  }

  
  /**
   * Initializes the fields of this {@link Species} to the defaults defined
   * in the specification of the relevant Level/Version of SBML.
   * <ul>
   * <li> sets 'boundaryCondition' to <code>1</code> (true)
   * <li> (Level&nbsp;2 only) sets 'constant' to <code>0</code> (false)
   * <li> (Level&nbsp;2 only) sets 'hasOnlySubstanceUnits' to <code>0</code> (false)
   * </ul>
   */
 public void initDefaults() {
    libsbmlJNI.Species_initDefaults(swigCPtr, this);
  }

  
  /**
   * Get the species type of this {@link Species}, as indicated by the
   * {@link Species} object's 'speciesType' attribute value.
   * <p>
   * @return the value of the 'speciesType' attribute of this
   * {@link Species} as a string.
   */
 public String getSpeciesType() {
    return libsbmlJNI.Species_getSpeciesType(swigCPtr, this);
  }

  
  /**
   * Get the compartment in which this species is located.
   * <p>
   * @return the value of the 'compartment' attribute of this {@link Species}, as a
   * string.
   */
 public String getCompartment() {
    return libsbmlJNI.Species_getCompartment(swigCPtr, this);
  }

  
  /**
   * Get the value of the 'initialAmount' attribute.
   * <p>
   * @return the initialAmount of this {@link Species}, as a float-point number.
   */
 public double getInitialAmount() {
    return libsbmlJNI.Species_getInitialAmount(swigCPtr, this);
  }

  
  /**
   * Get the value of the 'initialConcentration' attribute.
   * <p>
   * @return the initialConcentration of this {@link Species},, as a float-point
   * number.
   */
 public double getInitialConcentration() {
    return libsbmlJNI.Species_getInitialConcentration(swigCPtr, this);
  }

  
  /**
   * Get the value of the 'substanceUnit' attribute.
   * <p>
   * @return the substanceUnits of this {@link Species}, as a string.
   */
 public String getSubstanceUnits() {
    return libsbmlJNI.Species_getSubstanceUnits(swigCPtr, this);
  }

  
  /**
   * Get the value of the 'spatialSizeUnits' attribute.
   * <p>
   * @return the spatialSizeUnits of this {@link Species}.
   * <p>
   * @warning In versions of SBML Level~2 before Version&nbsp;3, the class
   * {@link Species} included an attribute called 'spatialSizeUnits', which allowed
   * explicitly setting the units of size for initial concentration.  This
   * attribute was removed in SBML Level&nbsp;2 Version&nbsp;3.  LibSBML
   * retains this attribute for compatibility with older definitions of
   * Level&nbsp;2, but its use is strongly discouraged because it is
   * incompatible with Level&nbsp;2 Version&nbsp;3 and Level&nbsp;2 Version&nbsp;4.
   */
 public String getSpatialSizeUnits() {
    return libsbmlJNI.Species_getSpatialSizeUnits(swigCPtr, this);
  }

  
  /**
   * (SBML Level&nbsp;1 only) Get the value of the 'units' attribute.
   * <p>
   * @return the units of this {@link Species} (L1 only).
   */
 public String getUnits() {
    return libsbmlJNI.Species_getUnits(swigCPtr, this);
  }

  
  /**
   * Get the value of the 'hasOnlySubstanceUnits' attribute.
   * <p>
   * @return <code>true</code> if this {@link Species}' 'hasOnlySubstanceUnits' attribute
   * value is nonzero, <code>false</code> otherwise.
   */
 public boolean getHasOnlySubstanceUnits() {
    return libsbmlJNI.Species_getHasOnlySubstanceUnits(swigCPtr, this);
  }

  
  /**
   * Get the value of the 'boundaryCondition' attribute.
   * <p>
   * @return <code>true</code> if this {@link Species}' 'boundaryCondition' attribute value
   * is nonzero, <code>false</code> otherwise.
   */
 public boolean getBoundaryCondition() {
    return libsbmlJNI.Species_getBoundaryCondition(swigCPtr, this);
  }

  
  /**
   * Get the value of the 'charge' attribute.
   * <p>
   * @return the charge of this {@link Species}.
   * <p>
   * @note Beginning in SBML Level&nbsp;2 Version&nbsp;2, the 'charge'
   * attribute on {@link Species} is deprecated and its use strongly discouraged.
   * Its presence is considered a misfeature in earlier definitions of SBML
   * because its implications for the mathematics of a model were never
   * defined, and in any case, no known modeling system ever used it.
   * Instead, models take account of charge values directly in their
   * definitions of species by (for example) having separate species
   * identities for the charged and uncharged versions of the same species.
   * This allows the condition to affect model mathematics directly.
   * LibSBML retains this method for easier compatibility with SBML
   * Level&nbsp;1.
   */
 public int getCharge() {
    return libsbmlJNI.Species_getCharge(swigCPtr, this);
  }

  
  /**
   * Get the value of the 'constant' attribute.
   * <p>
   * @return <code>true</code> if this {@link Species}'s 'constant' attribute value is
   * nonzero, <code>false</code> otherwise.
   */
 public boolean getConstant() {
    return libsbmlJNI.Species_getConstant(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * {@link Species}'s 'speciesType' attribute has been set.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @return <code>true</code> if the 'speciesType' attribute of this {@link Species} has
   * been set, <code>false</code> otherwise.
   */
 public boolean isSetSpeciesType() {
    return libsbmlJNI.Species_isSetSpeciesType(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * {@link Species}'s 'compartment' attribute has been set.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @return <code>true</code> if the 'compartment' attribute of this {@link Species} has
   * been set, <code>false</code> otherwise.
   */
 public boolean isSetCompartment() {
    return libsbmlJNI.Species_isSetCompartment(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * {@link Species}'s 'initialAmount' attribute has been set.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @return <code>true</code> if the 'initialAmount' attribute of this {@link Species} has
   * been set, <code>false</code> otherwise.
   * <p>
   * @note In SBML Level&nbsp;1, {@link Species}' 'initialAmount' is required and
   * therefore <em>should always be set</em>.  (However, in Level&nbsp;1, the
   * attribute has no default value either, so this method will not return
   * <code>true</code> until a value has been assigned.)  In SBML Level&nbsp;2,
   * 'initialAmount' is optional and as such may or may not be set.
   */
 public boolean isSetInitialAmount() {
    return libsbmlJNI.Species_isSetInitialAmount(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * {@link Species}'s 'initialConcentration' attribute has been set.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @return <code>true</code> if the 'initialConcentration' attribute of this {@link Species} has
   * been set, <code>false</code> otherwise.
   */
 public boolean isSetInitialConcentration() {
    return libsbmlJNI.Species_isSetInitialConcentration(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * {@link Species}'s 'substanceUnits' attribute has been set.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @return <code>true</code> if the 'substanceUnits' attribute of this {@link Species} has
   * been set, <code>false</code> otherwise.
   */
 public boolean isSetSubstanceUnits() {
    return libsbmlJNI.Species_isSetSubstanceUnits(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * {@link Species}'s 'spatialSizeUnits' attribute has been set.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @return <code>true</code> if the 'spatialSizeUnits' attribute of this {@link Species} has
   * been set, <code>false</code> otherwise.
   * <p>
   * @warning In versions of SBML Level~2 before Version&nbsp;3, the class
   * {@link Species} included an attribute called 'spatialSizeUnits', which allowed
   * explicitly setting the units of size for initial concentration.  This
   * attribute was removed in SBML Level&nbsp;2 Version&nbsp;3.  LibSBML
   * retains this attribute for compatibility with older definitions of
   * Level&nbsp;2, but its use is strongly discouraged because it is
   * incompatible with Level&nbsp;2 Version&nbsp;3 and Level&nbsp;2 Version&nbsp;4.
   */
 public boolean isSetSpatialSizeUnits() {
    return libsbmlJNI.Species_isSetSpatialSizeUnits(swigCPtr, this);
  }

  
  /**
   * (SBML Level&nbsp;1 only) Predicate returning <code>true</code> or <code>false</code> depending
   * on whether this {@link Species}'s 'units' attribute has been set.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @return <code>true</code> if the 'units' attribute of this {@link Species} has
   * been set, <code>false</code> otherwise.
   */
 public boolean isSetUnits() {
    return libsbmlJNI.Species_isSetUnits(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * {@link Species}'s 'charge' attribute has been set.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @return <code>true</code> if the 'charge' attribute of this {@link Species} has
   * been set, <code>false</code> otherwise.
   * <p>
   * @note Beginning in SBML Level&nbsp;2 Version&nbsp;2, the 'charge'
   * attribute on {@link Species} in SBML is deprecated and its use strongly
   * discouraged.  Its presence is considered a misfeature in earlier
   * definitions of SBML because its implications for the mathematics of a
   * model were never defined, and in any case, no known modeling system
   * ever used it.  Instead, models take account of charge values directly
   * in their definitions of species by (for example) having separate
   * species identities for the charged and uncharged versions of the same
   * species.  This allows the condition to affect model mathematics
   * directly.  LibSBML retains this method for easier compatibility with
   * SBML Level&nbsp;1.
   */
 public boolean isSetCharge() {
    return libsbmlJNI.Species_isSetCharge(swigCPtr, this);
  }

  
  /**
   * Sets the 'speciesType' attribute of this {@link Species}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @param sid the identifier of a {@link SpeciesType} object defined elsewhere
   * in this {@link Model}.
   */
 public void setSpeciesType(String sid) {
    libsbmlJNI.Species_setSpeciesType(swigCPtr, this, sid);
  }

  
  /**
   * Sets the 'compartment' attribute of this {@link Species}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @param sid the identifier of a {@link Compartment} object defined elsewhere
   * in this {@link Model}.
   */
 public void setCompartment(String sid) {
    libsbmlJNI.Species_setCompartment(swigCPtr, this, sid);
  }

  
  /**
   * Sets the 'initialAmount' attribute of this {@link Species} and marks the field
   * as set.
   * <p>
   * This method also unsets the 'initialConcentration' attribute.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @param value the value to which the 'initialAmount' attribute should
   * be set.
   */
 public void setInitialAmount(double value) {
    libsbmlJNI.Species_setInitialAmount(swigCPtr, this, value);
  }

  
  /**
   * Sets the 'initialConcentration' attribute of this {@link Species} and marks
   * the field as set.
   * <p>
   * This method also unsets the 'initialAmount' attribute.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @param value the value to which the 'initialConcentration' attribute
   * should be set.
   */
 public void setInitialConcentration(double value) {
    libsbmlJNI.Species_setInitialConcentration(swigCPtr, this, value);
  }

  
  /**
   * Sets the 'substanceUnits' attribute of this {@link Species}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @param sid the identifier of the unit to use.
   */
 public void setSubstanceUnits(String sid) {
    libsbmlJNI.Species_setSubstanceUnits(swigCPtr, this, sid);
  }

  
  /**
   * Sets the 'spatialSizeUnits' attribute of this {@link Species}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @param sid the identifier of the unit to use.
   * <p>
   * @warning In versions of SBML Level~2 before Version&nbsp;3, the class
   * {@link Species} included an attribute called 'spatialSizeUnits', which allowed
   * explicitly setting the units of size for initial concentration.  This
   * attribute was removed in SBML Level&nbsp;2 Version&nbsp;3.  LibSBML
   * retains this attribute for compatibility with older definitions of
   * Level&nbsp;2, but its use is strongly discouraged because it is
   * incompatible with Level&nbsp;2 Version&nbsp;3 and Level&nbsp;2 Version&nbsp;4.
   */
 public void setSpatialSizeUnits(String sid) {
    libsbmlJNI.Species_setSpatialSizeUnits(swigCPtr, this, sid);
  }

  
  /**
   * (SBML Level&nbsp;1 only) Sets the units of this {@link Species}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @param sname the identifier of the unit to use.
   */
 public void setUnits(String sname) {
    libsbmlJNI.Species_setUnits(swigCPtr, this, sname);
  }

  
  /**
   * Sets the 'hasOnlySubstanceUnits' attribute of this {@link Species}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @param value boolean value for the 'hasOnlySubstanceUnits' attribute.
   */
 public void setHasOnlySubstanceUnits(boolean value) {
    libsbmlJNI.Species_setHasOnlySubstanceUnits(swigCPtr, this, value);
  }

  
  /**
   * Sets the 'boundaryCondition' attribute of this {@link Species}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @param value boolean value for the 'boundaryCondition' attribute.
   */
 public void setBoundaryCondition(boolean value) {
    libsbmlJNI.Species_setBoundaryCondition(swigCPtr, this, value);
  }

  
  /**
   * Sets the 'charge' attribute of this {@link Species}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @param value an integer to which to set the 'charge' to.
   * <p>
   * @note Beginning in SBML Level&nbsp;2 Version&nbsp;2, the 'charge'
   * attribute on {@link Species} in SBML is deprecated and its use strongly
   * discouraged.  Its presence is considered a misfeature in earlier
   * definitions of SBML because its implications for the mathematics of a
   * model were never defined, and in any case, no known modeling system
   * ever used it.  Instead, models take account of charge values directly
   * in their definitions of species by (for example) having separate
   * species identities for the charged and uncharged versions of the same
   * species.  This allows the condition to affect model mathematics
   * directly.  LibSBML retains this method for easier compatibility with
   * SBML Level&nbsp;1.
   */
 public void setCharge(int value) {
    libsbmlJNI.Species_setCharge(swigCPtr, this, value);
  }

  
  /**
   * Sets the 'constant' attribute of this {@link Species}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @param value a boolean value for the 'constant' attribute
   */
 public void setConstant(boolean value) {
    libsbmlJNI.Species_setConstant(swigCPtr, this, value);
  }

  
  /**
   * Unsets the 'speciesType' attribute value of this {@link Species}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   */
 public void unsetSpeciesType() {
    libsbmlJNI.Species_unsetSpeciesType(swigCPtr, this);
  }

  
  /**
   * Unsets the 'initialAmount' attribute value of this {@link Species}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   */
 public void unsetInitialAmount() {
    libsbmlJNI.Species_unsetInitialAmount(swigCPtr, this);
  }

  
  /**
   * Unsets the 'initialConcentration' attribute value of this {@link Species}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   */
 public void unsetInitialConcentration() {
    libsbmlJNI.Species_unsetInitialConcentration(swigCPtr, this);
  }

  
  /**
   * Unsets the 'substanceUnits' attribute value of this {@link Species}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   */
 public void unsetSubstanceUnits() {
    libsbmlJNI.Species_unsetSubstanceUnits(swigCPtr, this);
  }

  
  /**
   * Unsets the 'spatialSizeUnits' attribute value of this {@link Species}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @warning In versions of SBML Level~2 before Version&nbsp;3, the class
   * {@link Species} included an attribute called 'spatialSizeUnits', which allowed
   * explicitly setting the units of size for initial concentration.  This
   * attribute was removed in SBML Level&nbsp;2 Version&nbsp;3.  LibSBML
   * retains this attribute for compatibility with older definitions of
   * Level&nbsp;2, but its use is strongly discouraged because it is
   * incompatible with Level&nbsp;2 Version&nbsp;3 and Level&nbsp;2 Version&nbsp;4.
   */
 public void unsetSpatialSizeUnits() {
    libsbmlJNI.Species_unsetSpatialSizeUnits(swigCPtr, this);
  }

  
  /**
   * (SBML Level&nbsp;1 only) Unsets the 'units' attribute value of this {@link Species}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   */
 public void unsetUnits() {
    libsbmlJNI.Species_unsetUnits(swigCPtr, this);
  }

  
  /**
   * Unsets the 'charge' attribute value of this {@link Species}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @note Beginning in SBML Level&nbsp;2 Version&nbsp;2, the 'charge'
   * attribute on {@link Species} in SBML is deprecated and its use strongly
   * discouraged.  Its presence is considered a misfeature in earlier
   * definitions of SBML because its implications for the mathematics of a
   * model were never defined, and in any case, no known modeling system
   * ever used it.  Instead, models take account of charge values directly
   * in their definitions of species by (for example) having separate
   * species identities for the charged and uncharged versions of the same
   * species.  This allows the condition to affect model mathematics
   * directly.  LibSBML retains this method for easier compatibility with
   * SBML Level&nbsp;1.
   */
 public void unsetCharge() {
    libsbmlJNI.Species_unsetCharge(swigCPtr, this);
  }

  
  /**
   * Constructs and returns a {@link UnitDefinition} that corresponds to the units
   * of this {@link Species}' amount or concentration.
   * <p>
   * {@link Species} in SBML have an attribute ('substanceUnits') for declaring the
   * units of measurement intended for the species' amount or concentration
   * (depending on which one applies).  In the absence of a value given for
   * 'substanceUnits', the units are taken from the enclosing {@link Model}'s
   * definition of <code>'substance'</code> or <code>'substance'</code>/<em>(size of the
   * compartment)</em> in which the species is located, or finally, if
   * these are not redefined by the {@link Model}, the relevant SBML default units
   * for those quantities.  Following that procedure, the method
   * getDerivedUnitDefinition() returns a {@link UnitDefinition} based on the
   * interpreted units of this species's amount or concentration.
   * <p>
   * Note that method will always return a value, never NULL, because SBML
   * defines default units for species' initial amounts and concentrations.
   * It is thus not possible for the units to be undefined (which is unlike
   * the case of {@link Parameter}).
   * <p>
   * Note also that unit declarations for {@link Species} are in terms of the 
   * <em>identifier</em> of a unit, but this method returns a {@link UnitDefinition} object,
   * not a unit identifier.  It does this by constructing an appropriate
   * {@link UnitDefinition}.  Callers may find this particularly useful when used
   * in conjunction with the helper methods on {@link UnitDefinition} for comparing
   * different {@link UnitDefinition} objects.
   * <p>
   * In SBML Level&nbsp;2 specifications prior to Version&nbsp;3, {@link Species}
   * includes an additional attribute named 'spatialSizeUnits', which
   * allows explicitly setting the units of size for initial concentration.
   * The getDerivedUnitDefinition() takes this into account for models
   * expressed in SBML Level&nbsp;2 Versions&nbsp;1 and&nbsp;2.
   * <p>
   * @return a {@link UnitDefinition} that expresses the units of this 
   * {@link Species}.
   * <p>
   * @see #getSubstanceUnits()
   */
 public UnitDefinition getDerivedUnitDefinition() {
    long cPtr = libsbmlJNI.Species_getDerivedUnitDefinition(swigCPtr, this);
    return (cPtr == 0) ? null : new UnitDefinition(cPtr, false);
  }

  
  /**
   * Returns the libSBML type code for this SBML object.
   * <p>
   * LibSBML attaches an
   * identifying code to every kind of SBML object.  These are known as
   * <em>SBML type codes</em>.  In other languages, the set of type codes
   * is stored in an enumeration; in the Java language interface for
   * libSBML, the type codes are defined as static integer constants in
   * interface class {@link libsbmlConstants}.  The names of the type codes
   * all begin with the characters <code>SBML_</code>. 
   * <p>
   * @return the SBML type code for this object, or <code>SBML_UNKNOWN</code> (default).
   * <p>
   * @see #getElementName()
   */
 public int getTypeCode() {
    return libsbmlJNI.Species_getTypeCode(swigCPtr, this);
  }

  
  /**
   * Returns the XML element name of this object, which for {@link Species}, is
   * always <code>'species'</code>.
   * <p>
   * @return the name of this element, i.e., <code>'species'</code>.
   */
 public String getElementName() {
    return libsbmlJNI.Species_getElementName(swigCPtr, this);
  }

}
