/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.38
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * Representation of MIRIAM-compliant controlled vocabulary annotation.
 * <p>
 * <em style='color: #555'>
This class of objects is defined by libSBML only and has no direct
equivalent in terms of SBML components.  This class is not prescribed by
the SBML specifications, although it is used to implement features
defined in SBML.
</em>

 * <p>
 * {@link CVTerm} is a libSBML construct used as part of the libSBML support for
 * annotations conforming to the guidelines specified by MIRIAM ('Minimum
 * Information Requested in the Annotation of biochemical Models').  The
 * general scheme is as follows.  A set of RDF-based annotations attached
 * to a given SBML <code>&lt;annotation&gt;</code> element are read by
 * RDFAnnotationParser and converted into a list of {@link CVTerm} objects.  Each
 * {@link CVTerm} object instance stores the following components of an annotation:
 * <p>
 * <ul>
 * <li>The qualifier, which can be a MIRIAM 'biological qualifier', a
 * 'model qualifier', or an unknown qualifier (as far as the {@link CVTerm} class
 * is concerned).  Qualifiers are used in MIRIAM to indicate the nature of
 * the relationship between the object being annotated and the resource.
 * In {@link CVTerm}, the qualifiers can be manipulated using the methods
 * getQualifierType(), setQualifierType(), and related methods.
 * <p>
 * <li>The resource, represent by a URI (note: not a URL).  In {@link CVTerm}, the
 * resource component can be manipulated using the methods addResource()
 * and removeResource().
 * </ul>
 */

public class CVTerm {
   private long swigCPtr;
   protected boolean swigCMemOwn;

   protected CVTerm(long cPtr, boolean cMemoryOwn)
   {
     swigCMemOwn = cMemoryOwn;
     swigCPtr    = cPtr;
   }

   protected static long getCPtr(CVTerm obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (CVTerm obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      libsbmlJNI.delete_CVTerm(swigCPtr);
    }
    swigCPtr = 0;
  }

  /**
   * Equality comparison method for CVTerm.
   * <p>
   * Because the Java methods for libSBML are actually wrappers around code
   * implemented in C++ and C, certain operations will not behave as
   * expected.  Equality comparison is one such case.  An instance of a
   * libSBML object class is actually a <em>proxy object</em>
   * wrapping the real underlying C/C++ object.  The normal <code>==</code>
   * equality operator in Java will <em>only compare the Java proxy objects</em>,
   * not the underlying native object.  The result is almost never what you
   * want in practical situations.  Unfortunately, Java does not provide a
   * way to override <code>==</code>.
   *  <p>
   * The alternative that must be followed is to use the
   * <code>equals()</code> method.  The <code>equals</code> method on this
   * class overrides the default java.lang.Object one, and performs an
   * intelligent comparison of instances of objects of this class.  The
   * result is an assessment of whether two libSBML Java objects are truly 
   * the same underlying native-code objects.
   *  <p>
   * The use of this method in practice is the same as the use of any other
   * Java <code>equals</code> method.  For example,
   * <em>a</em><code>.equals(</code><em>b</em><code>)</code> returns
   * <code>true</code> if <em>a</em> and <em>b</em> are references to the
   * same underlying object.
   *
   * @param sb a reference to an object to which the current object
   * instance will be compared
   *
   * @return <code>true</code> if <code>sb</code> refers to the same underlying 
   * native object as this one, <code>false</code> otherwise
   */
  public boolean equals(Object sb)
  {
    if ( this == sb ) 
    {
      return true;
    }
    return swigCPtr == getCPtr((CVTerm)(sb));
  }

  /**
   * Returns a hashcode for this CVTerm object.
   *
   * @return a hash code usable by Java methods that need them.
   */
  public int hashCode()
  {
    return (int)(swigCPtr^(swigCPtr>>>32));
  }

  
  /**
   * Creates a new {@link CVTerm}, optionally with the given #QualifierType_t value
   * <code>type</code>.
   * <p>
   * The possible qualifier types are MODEL_QUALIFIER and
   * BIOLOGICAL_QUALIFIER.  If the given #QualifierType_t value is not
   * given, this method defaults to using UNKNOWN_QUALIFIER.  The
   * #QualifierType_t type value can be set using the setQualifierType()
   * method.
   * <p>
   * @param type a #QualifierType_t value
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public CVTerm(int type) {
    this(libsbmlJNI.new_CVTerm__SWIG_0(type), true);
  }

  
  /**
   * Creates a new {@link CVTerm}, optionally with the given #QualifierType_t value
   * <code>type</code>.
   * <p>
   * The possible qualifier types are MODEL_QUALIFIER and
   * BIOLOGICAL_QUALIFIER.  If the given #QualifierType_t value is not
   * given, this method defaults to using UNKNOWN_QUALIFIER.  The
   * #QualifierType_t type value can be set using the setQualifierType()
   * method.
   * <p>
   * @param type a #QualifierType_t value
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public CVTerm() {
    this(libsbmlJNI.new_CVTerm__SWIG_1(), true);
  }

  
  /**
   * Create a new {@link CVTerm} from the given XMLNode.
   * <p>
   * RDFAnnotations within a model are stored as a List of CVTerms.  This allows
   * the user to interact with the CVTerms directly.  When LibSBML reads in a 
   * model containing RDFAnnotations it parses them into a List of CVTerms and
   * when writing a model it parses the CVTerms into the appropriate annotation
   * structure.  This function creates a CVTerm from the XMLNode supplied.
   * <p>
   * @param node an XMLNode representing a CVTerm.
   * <p>
   * @note this method assumes that the XMLNode is of the correct form
   */
 public CVTerm(XMLNode node) {
    this(libsbmlJNI.new_CVTerm__SWIG_2(XMLNode.getCPtr(node), node), true);
  }

  
  /**
   * Copy constructor; creates a copy of a {@link CVTerm}.
   * <p>
   * @param orig the {@link CVTerm} instance to copy.
   */
 public CVTerm(CVTerm orig) {
    this(libsbmlJNI.new_CVTerm__SWIG_3(CVTerm.getCPtr(orig), orig), true);
  }

  
  /**
   * Creates and returns a deep copy of this {@link CVTerm}.
   * <p>
   * @return a (deep) copy of this {@link CVTerm}.
   */
 public CVTerm cloneObject() {
    long cPtr = libsbmlJNI.CVTerm_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new CVTerm(cPtr, true);
  }

  
  /**
   * Returns the Qualifier Type code for this CVTerm.
   * <p>
   * @return the #QualifierType_t value of this object or UNKNOWN_QUALIFIER
   * (default).
   */
 public int getQualifierType() {
    return libsbmlJNI.CVTerm_getQualifierType(swigCPtr, this);
  }

  
  /**
   * Returns the {@link Model} QualifierType code for this CVTerm.
   * <p>
   * @return the #ModelQualifierType_t value of this object or BQM_UNKNOWN
   * (default).
   */
 public int getModelQualifierType() {
    return libsbmlJNI.CVTerm_getModelQualifierType(swigCPtr, this);
  }

  
  /**
   * Returns the Biological QualifierType code for this CVTerm.
   * <p>
   * @return the #BiolQualifierType_t value of this object or BQB_UNKNOWN
   * (default).
   */
 public int getBiologicalQualifierType() {
    return libsbmlJNI.CVTerm_getBiologicalQualifierType(swigCPtr, this);
  }

  
  /**
   * Returns the resources for this CVTerm.
   * <p>
   * @return the XMLAttributes that store the resources of this CVTerm.
   */
 public XMLAttributes getResources() {
    long cPtr = libsbmlJNI.CVTerm_getResources__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new XMLAttributes(cPtr, false);
  }

  
  /**
   * Returns the number of resources for this CVTerm.
   * <p>
   * @return the number of resources in the set of XMLAttributes
   * of this CVTerm.
   */
 public long getNumResources() {
    return libsbmlJNI.CVTerm_getNumResources(swigCPtr, this);
  }

  
  /**
   * Returns the value of the nth resource for this CVTerm.
   * <p>
   * @param n the index of the resource to query
   * <p>
   * @return string representing the value of the nth resource
   * in the set of XMLAttributes of this CVTerm.
   * <p>
   * @note Since the values of the resource attributes in a {@link CVTerm}
   * are URIs this is a convenience function to facilitate
   * interaction with the {@link CVTerm} class.
   */
 public String getResourceURI(long n) {
    return libsbmlJNI.CVTerm_getResourceURI(swigCPtr, this, n);
  }

  
  /**
   * Sets the #QualifierType_t value of this CVTerm.
   * <p>
   * @param type the #QualifierType_t type value 
   */
 public void setQualifierType(int type) {
    libsbmlJNI.CVTerm_setQualifierType(swigCPtr, this, type);
  }

  
  /**
   * Sets the #ModelQualifierType_t value of this CVTerm.
   * <p>
   * @param type the #ModelQualifierType_t value
   * <p>
   * @note If the Qualifier Type of this object is not MODEL_QUALIFIER,
   * then the ModelQualifierType_t will default to BQM_UNKNOWN.
   */
 public void setModelQualifierType(int type) {
    libsbmlJNI.CVTerm_setModelQualifierType(swigCPtr, this, type);
  }

  
  /**
   * Sets the #BiolQualifierType_t of this CVTerm.
   * <p>
   * @param type the #BiolQualifierType_t value
   * <p>
   * @note if the Qualifier Type of this object is not
   * BIOLOGICAL_QUALIFIER, then the #BiolQualifierType_t value will default
   * to BQB_UNKNOWN.
   */
 public void setBiologicalQualifierType(int type) {
    libsbmlJNI.CVTerm_setBiologicalQualifierType(swigCPtr, this, type);
  }

  
  /**
   * Adds a resource to the {@link CVTerm}.
   * <p>
   * @param resource string representing the resource; e.g.,
   * 'http://www.geneontology.org/#GO:0005892'
   * <p>
   * @note this method adds the name 'rdf:resource' to the attribute prior
   * to adding it to the resources in this {@link CVTerm}.
   */
 public void addResource(String resource) {
    libsbmlJNI.CVTerm_addResource(swigCPtr, this, resource);
  }

  
  /**
   * Removes a resource from the {@link CVTerm}.
   * <p>
   * @param resource string representing the resource; e.g.,
   * 'http://www.geneontology.org/#GO:0005892'
   <p>
 * @deprecated libSBML internal
 */
 public void removeResource(String resource) {
    libsbmlJNI.CVTerm_removeResource(swigCPtr, this, resource);
  }

}
