/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.38
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * LibSBML implementation of SBML's AssignmentRule construct.
 * <p>
 * The rule type {@link AssignmentRule} is derived from the parent class {@link Rule}.  It
 * is used to express equations that set the values of variables.  The
 * left-hand side (the attribute named 'variable') of an assignment rule
 * can refer to the identifier of a {@link Species}, {@link Compartment}, or {@link Parameter}
 * object in the model (but not a {@link Reaction}).  The entity identified must
 * not have its 'constant' attribute set to <code>true</code>.  The effects of an
 * {@link AssignmentRule} are in general terms the same, but differ in the precise
 * details depending on the type of variable being set:
 * <ul>
 * <li> <em>In the case of a species</em>, an {@link AssignmentRule} sets the
 * referenced species' quantity (<em>concentration</em> or <em>amount of
 * substance</em>) to the value determined by the formula in the subelement
 * 'math' of the {@link AssignmentRule} object.  The units of the formula in 'math'
 * should (in SBML Level&nbsp;2 Version&nbsp;4) or must (in previous
 * Versions) be the same as the <em>units of the species</em> for the
 * species identified by the 'variable' attribute of the {@link AssignmentRule}.
 * <em>Restrictions</em>: There must not be both an {@link AssignmentRule}
 * 'variable' attribute and a {@link SpeciesReference} 'species' attribute having
 * the same value, unless that species has its 'boundaryCondition'
 * attribute set to <code>true</code>.  In other words, an assignment rule cannot be
 * defined for a species that is created or destroyed in a reaction unless
 * that species is defined as a boundary condition in the model.
 * <p>
 * <li> <em>In the case of a compartment</em>, an {@link AssignmentRule} sets the
 * referenced compartment's size to the value determined by the formula in
 * the 'math' subelement of the {@link AssignmentRule} object.  The overall units
 * of the formula in 'math' should (in SBML Level&nbsp;2 Version&nbsp;4) or
 * must (in previous Versions) be the same as the units of the size of the
 * compartment.
 * <p>
 * <li> <em>In the case of a parameter</em>, an {@link AssignmentRule} sets the
 * referenced parameter's value to that determined by the formula in the
 * 'math' subelement of the {@link AssignmentRule} object.  The overall units of
 * the formula in the 'math' subelement should (in SBML Level&nbsp;2
 * Version&nbsp;4) or must (in previous Versions) be the same as the units
 * defined for the parameter.  </ul>
 * <p>
 * In the context of a simulation, assignment rules are in effect at all
 * times, <em>t</em> &#8805; <em>0</em>.  For purposes of evaluating
 * expressions that involve the <em>delay</em> 'csymbol' (see the SBML
 * Level&nbsp;2 specification), assignment rules are considered to apply
 * also at <em>t</em> &#8804; <em>0</em>.  The SBML Level&nbsp;2
 * Version&nbsp;4 specification provides additional information about the
 * semantics of assignments, rules, and entity values for simulation time
 * <em>t</em> &#8804; <em>0</em>.
 * <p>
 * A model must not contain more than one {@link AssignmentRule} or {@link RateRule}
 * object having the same value of 'variable'; in other words, in the set
 * of all assignment rules and rate rules in an SBML model, each variable
 * appearing in the left-hand sides can only appear once.  This simply
 * follows from the fact that an indeterminate system would result if a
 * model contained more than one assignment rule for the same variable or
 * both an assignment rule and a rate rule for the same variable.
 * <p>
 * Similarly, a model must also not contain <em>both</em> an {@link AssignmentRule}
 * and an {@link InitialAssignment} for the same variable, because both kinds of
 * constructs apply prior to and at the start of simulation time, i.e.,
 * <em>t</em> &#8804; <em>0</em>.  If a model contained both an initial
 * assignment and an assignment rule for the same variable, an
 * indeterminate system would result.
 * <p>
 * The value calculated by an {@link AssignmentRule} object overrides the value
 * assigned to the given symbol by the object defining that symbol.  For
 * example, if a {@link Compartment}'s 'size' attribute value is set in its
 * definition, and the model also contains an {@link AssignmentRule} having that
 * compartment's 'id' as its 'variable' value, then the 'size' assigned in
 * the {@link Compartment} definition is ignored and the value assigned based on
 * the computation defined in the {@link AssignmentRule}.  This does <em>not</em>
 * mean that a definition for a given symbol can be omitted if there is an
 * {@link AssignmentRule} object for it.  For example, there must be a {@link Parameter}
 * definition for a given parameter if there is an {@link AssignmentRule} for that
 * parameter.  It is only a question of which value definition takes
 * precedence.
 * <p>
 * <p>
 * <!-- leave this next break as-is to work around some doxygen bug -->
 */

public class AssignmentRule extends Rule {
   private long swigCPtr;

   protected AssignmentRule(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.SWIGAssignmentRuleUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(AssignmentRule obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (AssignmentRule obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      libsbmlJNI.delete_AssignmentRule(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  
  /**
   * Creates a new {@link AssignmentRule} and optionally sets its variable and
   * math.
   * <p>
   * There exists another form of this method that allows you to use an
   * {@link ASTNode} as the the formula instead of the text string used by this
   * variant.
   * <p>
   * @param variable the identifier of the variable (a {@link Compartment}, {@link Species}
   * or {@link Parameter} elsewhere in this {@link Model} object) that is being assigned
   * <p>
   * @param formula the mathematical formula placed in the assignment rule,
   * written as a text string.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public AssignmentRule(String variable, String formula) {
    this(libsbmlJNI.new_AssignmentRule__SWIG_0(variable, formula), true);
  }

  
  /**
   * Creates a new {@link AssignmentRule} and optionally sets its variable and
   * math.
   * <p>
   * There exists another form of this method that allows you to use an
   * {@link ASTNode} as the the formula instead of the text string used by this
   * variant.
   * <p>
   * @param variable the identifier of the variable (a {@link Compartment}, {@link Species}
   * or {@link Parameter} elsewhere in this {@link Model} object) that is being assigned
   * <p>
   * @param formula the mathematical formula placed in the assignment rule,
   * written as a text string.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public AssignmentRule(String variable) {
    this(libsbmlJNI.new_AssignmentRule__SWIG_1(variable), true);
  }

  
  /**
   * Creates a new {@link AssignmentRule} and optionally sets its variable and
   * math.
   * <p>
   * There exists another form of this method that allows you to use an
   * {@link ASTNode} as the the formula instead of the text string used by this
   * variant.
   * <p>
   * @param variable the identifier of the variable (a {@link Compartment}, {@link Species}
   * or {@link Parameter} elsewhere in this {@link Model} object) that is being assigned
   * <p>
   * @param formula the mathematical formula placed in the assignment rule,
   * written as a text string.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public AssignmentRule() {
    this(libsbmlJNI.new_AssignmentRule__SWIG_2(), true);
  }

  
  /**
   * Creates a new {@link AssignmentRule} with a given <code>variable</code> and mathematical
   * expression.
   * <p>
   * There exists another form of this method that allows you to use a text
   * string to express the formula instead of the {@link ASTNode} used by this
   * variant.
   * <p>
   * @param variable the identifier of the variable (a {@link Compartment}, {@link Species}
   * or {@link Parameter} elsewhere in this {@link Model} object) that is being assigned
   * <p>
   * @param math an {@link ASTNode} containing the mathematical formula
   * expressing the right-hand side of the assignment equation
   */
 public AssignmentRule(String variable, ASTNode math) {
    this(libsbmlJNI.new_AssignmentRule__SWIG_3(variable, ASTNode.getCPtr(math), math), true);
  }

  
  /**
   * Creates a new {@link AssignmentRule} using the given SBML <code>level</code> and <code>version</code>
   * values and optionally a set of XMLNamespaces.
   * <p>
   * @param level a long integer, the SBML Level to assign to this {@link AssignmentRule}
   * <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link AssignmentRule}
   * <p>
   * @param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
   * assign to this {@link AssignmentRule}
   * <p>
   * @note Once a {@link AssignmentRule} has been added to an {@link SBMLDocument}, the <code>level</code>,
   * <code>version</code> and <code>xmlns</code> namespaces for the document <em>override</em> those used
   * to create the {@link AssignmentRule}.  Despite this, the ability to supply the values
   * at creation time is an important aid to creating valid SBML.  Knowledge of
   * the intented SBML Level and Version determine whether it is valid to
   * assign a particular value to an attribute, or whether it is valid to add
   * an object to an existing {@link SBMLDocument}.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   <p>
 * @deprecated libSBML internal
 */
 public AssignmentRule(long level, long version, XMLNamespaces xmlns) {
    this(libsbmlJNI.new_AssignmentRule__SWIG_4(level, version, XMLNamespaces.getCPtr(xmlns), xmlns), true);
  }

  
  /**
   * Creates a new {@link AssignmentRule} using the given SBML <code>level</code> and <code>version</code>
   * values and optionally a set of XMLNamespaces.
   * <p>
   * @param level a long integer, the SBML Level to assign to this {@link AssignmentRule}
   * <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link AssignmentRule}
   * <p>
   * @param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
   * assign to this {@link AssignmentRule}
   * <p>
   * @note Once a {@link AssignmentRule} has been added to an {@link SBMLDocument}, the <code>level</code>,
   * <code>version</code> and <code>xmlns</code> namespaces for the document <em>override</em> those used
   * to create the {@link AssignmentRule}.  Despite this, the ability to supply the values
   * at creation time is an important aid to creating valid SBML.  Knowledge of
   * the intented SBML Level and Version determine whether it is valid to
   * assign a particular value to an attribute, or whether it is valid to add
   * an object to an existing {@link SBMLDocument}.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   <p>
 * @deprecated libSBML internal
 */
 public AssignmentRule(long level, long version) {
    this(libsbmlJNI.new_AssignmentRule__SWIG_5(level, version), true);
  }

  
  /**
   * Creates and returns a deep copy of this {@link Rule}.
   * <p>
   * @return a (deep) copy of this {@link Rule}.
   */
 public AssignmentRule cloneObject() {
    long cPtr = libsbmlJNI.AssignmentRule_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new AssignmentRule(cPtr, true);
  }

}
