/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.38
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * LibSBML implementation of SBML's AlgebraicRule construct.
 * <p>
 * The rule type {@link AlgebraicRule} is derived from the parent class {@link Rule}.  It
 * is used to express equations that are neither assignments of model
 * variables nor rates of change.  {@link AlgebraicRule} does not add any
 * attributes to the basic {@link Rule}; its role is simply to distinguish this
 * case from the other cases.
 * <p>
 * In the context of a simulation, algebraic rules are in effect at all
 * times, <em>t</em> &#8805; <em>0</em>.  For purposes of evaluating
 * expressions that involve the delay 'csymbol' (see the SBML
 * specification), algebraic rules are considered to apply also at
 * <em>t</em> &#8804; <em>0</em>.  The SBML Level&nbsp;2 Version&nbsp;4
 * specification provides additional information about the semantics of
 * assignments, rules, and entity values for simulation time <em>t</em>
 * &#8804; <em>0</em>.
 * <p>
 * The ability to define arbitrary algebraic expressions in an SBML model
 * introduces the possibility that a model is mathematically overdetermined
 * by the overall system of equations constructed from its rules and
 * reactions.  An SBML model must not be overdetermined; see the
 * description of {@link Rule} and also the SBML Level&nbsp;2 Version&nbsp;4
 * specification.  An SBML model that does not contain {@link AlgebraicRule}
 * structures cannot be overdetermined.
 * <p>
 * Assessing whether a given continuous, deterministic, mathematical model
 * is overdetermined does not require dynamic analysis; it can be done by
 * analyzing the system of equations created from the model.  One approach
 * is to construct a bipartite graph in which one set of vertices
 * represents the variables and the other the set of vertices represents
 * the equations.  Place edges between vertices such that variables in the
 * system are linked to the equations that determine them.  For algebraic
 * equations, there will be edges between the equation and each variable
 * occurring in the equation.  For ordinary differential equations (such as
 * those defined by rate rules or implied by the reaction rate
 * definitions), there will be a single edge between the equation and the
 * variable determined by that differential equation.  A mathematical model
 * is overdetermined if the maximal matchings of the bipartite graph
 * contain disconnected vertexes representing equations.  (If one maximal
 * matching has this property, then all the maximal matchings will have
 * this property; i.e., it is only necessary to find one maximal matching.)
 * Appendix D of the SBML Level&nbsp;2 Version&nbsp;4 specification
 * describes a method of applying this procedure to specific SBML data
 * objects.
 * <p>
 * <p>
 * <!-- leave this next break as-is to work around some doxygen bug -->
 */

public class AlgebraicRule extends Rule {
   private long swigCPtr;

   protected AlgebraicRule(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.SWIGAlgebraicRuleUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(AlgebraicRule obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (AlgebraicRule obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      libsbmlJNI.delete_AlgebraicRule(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  
  /**
   * Creates a new {@link AlgebraicRule}, optionally with the given mathematical
   * formula expressed in text-string form.
   * <p>
   * This is equivalent to the constructor that takes an {@link ASTNode}.  It is
   * provided for convenience.
   * <p>
   * There exists another form of this method that allows you to use an
   * {@link ASTNode} as the the formula instead of the text string used by this
   * variant.
   * <p>
   * @param formula The algebraic expression to be placed in the rule
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public AlgebraicRule(String formula) {
    this(libsbmlJNI.new_AlgebraicRule__SWIG_0(formula), true);
  }

  
  /**
   * Creates a new {@link AlgebraicRule}, optionally with the given mathematical
   * formula expressed in text-string form.
   * <p>
   * This is equivalent to the constructor that takes an {@link ASTNode}.  It is
   * provided for convenience.
   * <p>
   * There exists another form of this method that allows you to use an
   * {@link ASTNode} as the the formula instead of the text string used by this
   * variant.
   * <p>
   * @param formula The algebraic expression to be placed in the rule
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public AlgebraicRule() {
    this(libsbmlJNI.new_AlgebraicRule__SWIG_1(), true);
  }

  
  /**
   * Creates a new {@link AlgebraicRule} and optionally sets its 'math' subelement.
   * <p>
   * There exists another form of this method that allows you to use a text
   * string to express the formula instead of the {@link ASTNode} used by this
   * variant.
   * <p>
   * @param math an {@link ASTNode} containing the mathematical formula expressing
   * the right-hand side of the algebraic equation
   */
 public AlgebraicRule(ASTNode math) {
    this(libsbmlJNI.new_AlgebraicRule__SWIG_2(ASTNode.getCPtr(math), math), true);
  }

  
  /**
   * Creates a new {@link AlgebraicRule} using the given SBML <code>level</code> and <code>version</code>
   * values and optionally a set of XMLNamespaces.
   * <p>
   * @param level a long integer, the SBML Level to assign to this {@link AlgebraicRule}
   * <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link AlgebraicRule}
   * <p>
   * @param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
   * assign to this {@link AlgebraicRule}
   * <p>
   * @note Once a {@link AlgebraicRule} has been added to an {@link SBMLDocument}, the <code>level</code>,
   * <code>version</code> and <code>xmlns</code> namespaces for the document <em>override</em> those used
   * to create the {@link AlgebraicRule}.  Despite this, the ability to supply the values
   * at creation time is an important aid to creating valid SBML.  Knowledge of
   * the intented SBML Level and Version determine whether it is valid to
   * assign a particular value to an attribute, or whether it is valid to add
   * an object to an existing {@link SBMLDocument}.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   <p>
 * @deprecated libSBML internal
 */
 public AlgebraicRule(long level, long version, XMLNamespaces xmlns) {
    this(libsbmlJNI.new_AlgebraicRule__SWIG_3(level, version, XMLNamespaces.getCPtr(xmlns), xmlns), true);
  }

  
  /**
   * Creates a new {@link AlgebraicRule} using the given SBML <code>level</code> and <code>version</code>
   * values and optionally a set of XMLNamespaces.
   * <p>
   * @param level a long integer, the SBML Level to assign to this {@link AlgebraicRule}
   * <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link AlgebraicRule}
   * <p>
   * @param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
   * assign to this {@link AlgebraicRule}
   * <p>
   * @note Once a {@link AlgebraicRule} has been added to an {@link SBMLDocument}, the <code>level</code>,
   * <code>version</code> and <code>xmlns</code> namespaces for the document <em>override</em> those used
   * to create the {@link AlgebraicRule}.  Despite this, the ability to supply the values
   * at creation time is an important aid to creating valid SBML.  Knowledge of
   * the intented SBML Level and Version determine whether it is valid to
   * assign a particular value to an attribute, or whether it is valid to add
   * an object to an existing {@link SBMLDocument}.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   <p>
 * @deprecated libSBML internal
 */
 public AlgebraicRule(long level, long version) {
    this(libsbmlJNI.new_AlgebraicRule__SWIG_4(level, version), true);
  }

  
  /**
   * Creates and returns a deep copy of this {@link Rule}.
   * <p>
   * @return a (deep) copy of this {@link Rule}.
   */
 public AlgebraicRule cloneObject() {
    long cPtr = libsbmlJNI.AlgebraicRule_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new AlgebraicRule(cPtr, true);
  }

  
  /**
   * sets the mInternalIdOnly flag
   <p>
 * @deprecated libSBML internal
 */
 public void setInternalIdOnly() {
    libsbmlJNI.AlgebraicRule_setInternalIdOnly(swigCPtr, this);
  }

  
  /**
   * sets the mInternalIdOnly flag
   <p>
 * @deprecated libSBML internal
 */
 public boolean getInternalIdOnly() {
    return libsbmlJNI.AlgebraicRule_getInternalIdOnly(swigCPtr, this);
  }

}
