/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef TOOL3DBUTTON_H
#define TOOL3DBUTTON_H

#include "mousewidget.h"
#include <qtoolbutton.h>
#include <QEvent>
#include <QToolBar>


/**
@author Juergen Thies
*/

class layout;
class tool3dButton : public QToolButton
{
Q_OBJECT
public:
    tool3dButton ( const QString & textLabel, QToolBar * parent, 
				class layout *l ,int i, helpText helptext  ) ;
    helpText helpMouse;
    ~tool3dButton();
    bool *boolValue;
protected:
    void enterEvent ( QEvent * e );
    void mousePressEvent(QMouseEvent *e);
    void mouseMoveEvent(QMouseEvent *e);
    bool event(QEvent * e);
    class layout *l;
    QPoint presspos;
    int axis;
    void showAngles();
};

#endif
