/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "timewidget.h"

#include <qimage.h>
#include <qstatusbar.h>
#include <qpainter.h>
//#include <q3paintdevicemetrics.h>
#include <qlabel.h>
#include <qpixmap.h>
#include <qstring.h>
//#include <q3whatsthis.h>



timewidget::timewidget(QWidget *parent, const char *)
 : QWidget(parent)
{
QString s="This bar indicates process time of drawing.";
printTimeIcon=new QLabel(this);
printTimeIcon->setWhatsThis(s);
printTimeNumber=new QLabel(this);
printTimeNumber->setWhatsThis(s);
printTimeIcon->setPixmap(QPixmap(":layoutIcon"));
printTimeIcon->setEnabled(false);
printTimeNumber->setText("0 ms");
printTimeIcon->setGeometry(0,0,17,17);
printTimeNumber->setGeometry(18,0,48,17);
s="This bar indicates process time of some operations.";
timeIcon=new QLabel(this);
timeIcon->setWhatsThis(s);
timeNumber=new QLabel(this);
timeNumber->setWhatsThis(s);
timeIcon->setPixmap(QPixmap(":macroIcon"));
timeIcon->setEnabled(false);
timeNumber->setText("0 ms");
timeIcon->setGeometry(49+17,0,17,17);
timeNumber->setGeometry(49+17+18,0,48,17);
/*gridIcon=new QLabel(this);
gridIcon->setWhatsThis(s);
gridNumber=new QLabel(this);
gridNumber->setWhatsThis(s);
autoIcon = QPixmap(gridautoicon);
manualIcon = QPixmap(selectgridicon);
gridIcon->setPixmap(autoIcon);
gridNumber->setText("Auto");*/
setNormal();
}

void timewidget::setOff(){
setFixedSize(0,17);

}

void timewidget::setNormal(){
setFixedSize(131,17);
}
    
timewidget::~timewidget()
{
}

void timewidget::setDrawTime(int t){
printTimeNumber->setText(calcTime(t));
}
void timewidget::setTime(int t){
timeNumber->setText(calcTime(t));
}
void timewidget::setIcon(QString s){
timeIcon->setPixmap(QPixmap(s));
}


QString timewidget::calcTime(int t){
QString s;
if (t>=90000){
	s.setNum(1.0*t/60000,'g',3);
	s=s+" min";
	}
else if (t>=10000) {
	s.setNum(1.0*t/1000,'g',3);
	s=s+" s";
	}
else {
	s.setNum(t);
	s=s+" ms";
	}
return s;
}

void timewidget::setDrawDetail(quint8 l){
switch (l){
case 1:
	printTimeIcon->setPixmap(QPixmap(":icons/paintlevel1.png"));
	break;
case 2:
	printTimeIcon->setPixmap(QPixmap(":icons/paintlevel3.png"));
	break;
case 3:
	printTimeIcon->setPixmap(QPixmap(":icons/paintlevel4.png"));
	break;
case 4:
	printTimeIcon->setPixmap(QPixmap(":icons/paintlevel6.png"));
	break;
case 0:
case 99:
    	printTimeIcon->setPixmap(QPixmap(":icons/paintlevelauto.png"));
	break;
default:
	printTimeIcon->setPixmap(QPixmap(":layoutIcon"));
	break;
}

}

