/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "multitoolbutton.h"
#include <qtoolbutton.h>

#include <qpixmap.h>
#include <qpainter.h>
#include <qimage.h>
#include <qbitmap.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
//#include <q3whatsthis.h>
//Added by qt3to4:
#include <QMouseEvent>
#include <QEvent>
#include <QApplication>
#include <QDesktopWidget>
#include "layout.h"
#include "dialog/helpwindow.h"
#include <QWhatsThis>

multiToolButton::multiToolButton(QToolBar *parent,const QIcon & iconSet):shortKeyToolButton(parent){
  subWidget=new QWidget(0,Qt::Popup);
  fuctionNum=-1;
  setIcon(iconSet);
  setAutoRaise (true );
  parent->addWidget(this);
  setWhatsThis(tr("<p>Select a subfunction.</p>"));
  mode=-1;
}



multiToolButton::~multiToolButton(){
 
}

void multiToolButton::addToolButton(int index, const QIcon & iconSet,const QString & textLabel, const QString & grouptext, QObject *receiver, const char * slot, const char *  ,QString whatthis,helpText help){
  if (button[index].tool!=NULL) delete button[index].tool;
  button[index].tool=new QToolButton(subWidget);
  button[index].tool->setIcon(iconSet);
  button[index].tool->setToolTip(textLabel);
  button[index].tool->setAutoRaise(true);
  button[index].receiver=receiver;
  button[index].slot=slot;
  button[index].whatThis=whatthis;
  button[index].grouptext=grouptext;
  button[index].textLabel=textLabel;
  button[index].num=index;
  button[index].icon=iconSet;
  button[index].helptext=help;
  connect(&(button[index]),SIGNAL(clicked(int)),this,SLOT(activated(int)));
  connect(button[index].tool,SIGNAL(clicked()),&(button[index]),SLOT(activated()));
  button[index].tool->setWhatsThis( whatthis );
}

void multiToolButton::addToolButton(int index, const QString & textLabel,  QObject *receiver, const char * slot ,helpText help,int mode_){
  if (button[index].tool!=NULL) delete button[index].tool;
  button[index].tool=new QToolButton(subWidget);
  button[index].tool->setIcon(layout::helpwindow->getIcon(help));
  button[index].tool->setToolTip(textLabel);
  button[index].tool->setAutoRaise(true);
  button[index].receiver=receiver;
  button[index].slot=slot;
  button[index].mode=mode_;
  button[index].whatThis="No help available.";
  //button[index].grouptext=grouptext;
  button[index].textLabel=textLabel;
  button[index].num=index;
  button[index].icon=layout::helpwindow->getIcon(help);
  button[index].helptext=help;
  connect(&(button[index]),SIGNAL(clicked(int)),this,SLOT(activated(int)));
  connect(button[index].tool,SIGNAL(clicked()),&(button[index]),SLOT(activated()));
  button[index].tool->setWhatsThis("No help available." );
}

void multiToolButton::activated(int num){
 set(num);
 emit clicked();
}

void multiToolButton::modeChanged(int oldMode,int newMode){
if ((oldMode>=0)&&(oldMode==mode)){
	setChecked (false);
	}
if ((newMode>=0)&&(newMode==mode)){
	setChecked (true);
	}
}

void multiToolButton::set(int num){
 setIcon(layout::helpwindow->getIcon(button[num].helptext));
 helpMouse=button[num].helptext;
 mode=button[num].mode;
 if (mode>=0){
	setAutoRaise (true );
	setCheckable ( true);
	setChecked (false);
	}
 else {
	setChecked (false);
	setAutoRaise (false );
	setCheckable ( false);
 }
 //setWhatsThis(button[num].whatThis);
 setWhatsThis("No help available.");
 setToolTip(button[num].textLabel);
 disconnect(this,SIGNAL(clicked()));
 if (fuctionNum>=0) disconnect(this,SIGNAL(clicked()),button[fuctionNum].receiver,(button[fuctionNum].slot));
 connect(this,SIGNAL(clicked()),button[num].receiver,(button[num].slot));
 subWidget->hide();
 fuctionNum=num;
 if (num<0) {
	setWhatsThis(tr("<p>Select a subfunction.</p>"));
	setToolTip(tr("<p>Select a subfunction.</p>"));
	}
}

void multiToolButton::enterEvent ( QEvent * e ){
  if (fuctionNum<0) {
  	mouseWidget::set(setSubfunctionHelp);
  } else
   mouseWidget::setMultifunction(button[fuctionNum].helptext);

  QToolButton::enterEvent(e);
}

void multiToolButton::mouseReleaseEvent(QMouseEvent *e){
  QToolButton::mouseReleaseEvent(e);
}

void multiToolButton::mousePressEvent(QMouseEvent *e){
 
  if (((e->modifiers()==Qt::ControlModifier)&&(e->button()==Qt::LeftButton))){
	subWidget->hide();
	}
  else if ((e->button()==Qt::MidButton)||((e->modifiers()==Qt::ShiftModifier)&&(e->button()==Qt::LeftButton))){
  	makeWidget();
        subWidget->show();
	}
  else if (e->button()==Qt::LeftButton){
       if (fuctionNum>=0) 
             QToolButton::mousePressEvent(e);
       else {
       		makeWidget();
        	subWidget->show();
       	}
	}
}

bool multiToolButton::event(QEvent * event){
  if (event->type() == QEvent::WhatsThis) {
	//QWhatsThis::hideText ();
	if (fuctionNum>=0) {
	  layout::helpwindow->showHelp(button[fuctionNum].helptext);
	  QWhatsThis::leaveWhatsThisMode ();
	  return true;}
	return QToolButton::event( event);
	}
  return QToolButton::event( event);
}

void multiToolButton::makeWidget(){
int x=0,y=0;
int xmax=0,ymax=0;
int h=0;
int count=0;
for (int i=0;i<max_subButton;i++)
  if (button[i].tool!=NULL){ 
	QPixmap pix=button[i].icon.pixmap(16,16);
	int help=pix.height()+10;
 	if (help>h) h=help;
	count++;
 	}
int line=10;
if (count>7) { line=(count+1)/2;}
if (count>14) { line=(count+2)/3;}
if (count>21) { line=(count+3)/4;}
count=0;
for (int i=0;i<max_subButton;i++)
  if (button[i].tool!=NULL){ 
	count++;
	if (count>line) {
		count=0;
		y+=h;
		x=0;
	}
	QPixmap pix=button[i].icon.pixmap(16,16);
	int w=pix.width()+10;
 	button[i].tool->setGeometry(x,y,w,h);
	x+=w;
	if (x>xmax) xmax=x;
	if (y>ymax) ymax=y;
 	}
ymax+=h;
QDesktopWidget *desktop = QApplication::desktop();
int desktopWidth = desktop->width();
int desktopHeight = desktop->height();
QPoint p=this->mapToGlobal(QPoint(0,0));
int px=p.x();
int py=p.y();
//printf("w %d h %d map x %d y %d\n",width,height,p.x(),p.y());
if (px+xmax>desktopWidth) px+=this->width()-xmax;
if (py+ymax>desktopHeight) py-=ymax;
else py+=this->height();
subWidget->setGeometry(px,py,xmax,ymax);
}
