/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef MOUSEWIDGET_H
#define MOUSEWIDGET_H

#include <qwidget.h>
#include <qstring.h>
#include <qlabel.h>
#include <qpixmap.h>
#include <QMutex>

/**
@author Juergen Thies
*/
enum helpText {clear, layerButtonHelp, setSelectEditHelp, setBoxModeHelp, setPathModeHelp, setPolygonModeHelp, setCellrefModeHelp, setCellrefArrayModeHelp, setTextModeHelp, setSubfunctionHelp, setCopyModeHelp, setMoveModeHelp, setMovePointModeHelp,  moveByHelp, setRotateModeHelp, setMirrorModeHelp, copyToLayerHelp,  moveToLayerHelp, mergeHelp, setCutModeHelp, deleteHelp, setPropertiesModeHelp, newDrawingHelp, openFileHelp, attachFileHelp, saveFileHelp, screenshotHelp, printHelp, whatThisHelp, pointSelectHelp, formSelectHelp, cellSelectHelp, pointDeselectHelp, formDeselectHelp, cellDeselectHelp, selectAllHelp, selectVisibleHelp,  deselectAllHelp, scrollUpHelp, scrollDownHelp,  scrollLeftHelp,  scrollRightHelp, zoomPlusHelp, zoomMinusHelp, zoomFullHelp, zoomOneHelp, setZoomModeHelp, setCellnameHelp, newCellHelp, deleteCellHelp, ungroupHelp, groupHelp, undoHelp,  redoHelp, reduceGridHelp, increaseGridHelp, autoGridHelp, showGridHelp, setCircleModeHelp, setSectorModeHelp, setArcModeHelp, setSpiralModeHelp, removeSmallHelp, roundHelp, setscaleModeHelp, sizeAdjustHelp, areaHelp,  setRulerModeHelp, setLayerAHelp, setLayerBHelp, setAHelp, setBHelp, APlusBHelp, AMultiBHelp,  AMinusBHelp, BMinusAHelp, AEorBHelp, snapGridHelp, snapLineHelp, snapMiddleHelp, snapCenterHelp, snapPointHelp, setupHelp, setBezier2ModeHelp, setBezier3ModeHelp, setArc2ModeHelp, saveAsFileHelp, updateFileHelp, flat1Help, flatAllHelp, pathSelectHelp, pathDeselectHelp, polygonSelectHelp, polygonDeselectHelp, boxSelectHelp, boxDeselectHelp, textSelectHelp, textDeselectHelp,toPolygonHelp,toBoxHelp,deselectLayerHelp,selectLayerHelp, drcSetLayerHelp, drcShowReportHelp, drcMinDistanceHelp, drcInsideHelp, drcNoElementHelp, drcNoPathHelp,
drcNoHolesHelp, drcNotchesHelp, drcAnglesHelp, drcDimensionHelp, drcAreaHelp, drcPerimeterHelp, 
 drcNoBoxHelp, drcNoTextHelp,  drcNoPolygonHelp, drcMinSizeHelp, drcMinOverHelp, drcLayerCombinationHelp, setAngleModeHelp, macroReloadHelp, macroStartHelp, macroStopHelp, macroeditHelp, copyCellHelp, extractCellHelp, extractLayerHelp, snapInterHelp, drcOverlapingElementsHelp, invertSelectHelp, toCircleHelp , layerManagerHelp,insertPointHelp,hideUnusedLayersHelp,hideCurUnusedLayersHelp,disableUnusedLayersHelp,enableAllLayersHelp,
gotoxyHelp,copyByHelp,
zoomSelectHelp, setMoveXModeHelp, setMoveYModeHelp,setCircleBoxModeHelp,setCircleFitModeHelp, centerXHelp,centerHelp,centerYHelp,alignXHelp,alignHelp,alignYHelp
,alignValueHelp, alignLeftHelp, alignRightHelp,  alignTopHelp, alignBottomHelp, stripUnneededHelp, clipboardCopyHelp, clipboardPasteHelp ,drcMinElementDisHelp,  view3dallHelp, view3dselectHelp , view3dautoHelp , view3doffHelp,  view3dscreenshotHelp , generate3dSetupMacroHelp,
macroExecuteHelp,view3dsetupHelp,view3dHelp,lengthHelp, lengthelementHelp, selectCellHelp, setGridHelp, exitHelp,commandHelp, view3dRotXHelp, view3dRotYHelp,view3dRotZHelp
,drcOnlyCircleHelp, drcNoCircleHelp, drcOnGridHelp,
drcMinDistanceOrOverlapHelp, drcEnclosureHelp,drcOverlapDistanceHelp,
setSelectCellModeHelp, setElementSizeModeHelp, closeDesignHelp, snapShapesHelp,
setActiveLayerHelp,setVisibilityLayerHelp,setHideOtherLayerHelp,setAllLayerHelp,
helpHelp,aboutHelp,generateTechMacroHelp,nextLayoutHelp,generateViewMacroHelp,setUserunitsHelp,
groupSimpleHelp,groupGlobalHelp,groupStructureHelp,cellUpHelp,stripIdenticalElementsHelp,
netlistLoadHelp,netlistSaveHelp,netlistAddLibraryHelp,netlistRemoveLibraryHelp,netlistRebuildHelp,
technologyLayerRemoveHelp,technologyLayerNewHelp,technologyLayerDownHelp,technologyLayerUpHelp,placeShowConnectionsHelp, cropSharpAnglesHelp,
setPlaceModeHelp,setRouteModeHelp,routeadjustHelp,route45Help,route90Help,routeFineHelp,
setNodeModeHelp,buildConnectHelp,saveGenNetHelp,lvsHelp,registerLicenseHelp,compareCellHelp, toMeshHelp, cropWithSelectionHelp,modifyCornersHelp,setCellOriginHelp,closedPathToPolygonHelp, mergeToHelp,
layer123Help, layerABCHelp, layerBlockHelp, layerListHelp, setPreviousCellHelp, 
stripEmptyCellsHelp, selectCellNameHelp,
removeCellArrayHelp, backgroundsetHelp,backgroundclearHelp ,backgroundallclearHelp, placeBackgroundHelp, centerBackgroundHelp, backgroundSetColorHelp, backgroundChooseColorHelp, backgroundPreviewColorHelp,
removeNotOrthogonalRefHelp, removeScaledRefHelp,
setBarcodeCode39ModeHelp, setBarcodeCode39Mod43ModeHelp, setBarcodeCode128ModeHelp, setBarcodeCode128AModeHelp, setBarcodeCode128BModeHelp, setBarcodeCode128CModeHelp, setDatamatrixModeHelp,

detailsLevel3Help,detailsLevel2Help,detailsLevel1Help,detailsAllHelp,detailsAutoHelp

,schematicHelp,openLayoutHelp,schematicBusHelp,schematicDeleteHelp, schematicNameHelp,schematicNewHelp,schematicTextHelp,schematicArcHelp ,schematicCircleHelp, schematicRectHelp, schematicLineHelp, busportHelp, portHelp, lableNodeHelp, schematicWireHelp, schematicPolygonHelp, addSchematicLibHelp, removeSchematicLibHelp, newComponentHelp, editComponentHelp, schematicLibSelectHelp, schematicGroundHelp, schematicColorHelp, schematicEditHelp, toLayoutHelp,toComponenttHelp,

pointSelectDeselectHelp, cellSelectDeselectHelp, formSelectDeselectHelp, zoomPlusMinusHelp, saveAsSaveFileHelp,openImportFileHelp,deSelectAllHelp, openImportUpdateFileHelp, gridAutoPlusMinusHelp, setSelectCellModecellUpHelp,

execHelp,

oaLibCreateHelp, oaSetLibHelp, oaReadLayerHelp, oaVersionHelp, oaLoadNetHelp, oaOpenHelp, oaCellInfoHelp, oaAddLibHelp
};


class mainWindow;

class mouseWidget : public QWidget
{
Q_OBJECT
public:
    mouseWidget(mainWindow *m, QWidget *parent = 0, const char *name = 0);

    ~mouseWidget();
    static QPixmap *pixmaps[18];
    static mouseWidget *mouseInfo;
    static QString functionText[8];
    static int iconNum[8];
    QLabel *icons[8];
    QLabel *textLabel[8];
    void resizeEvent(QResizeEvent *);
    mainWindow *main;
public slots:
 void update();
    
    
signals:

 void changed();

public:

 static void set(int mode,int modestep);
 static void set(helpText h);
 static void setMultifunction(helpText h);
 static QMutex locked;
protected:
    void contextMenuEvent ( QContextMenuEvent * event );
};

#endif
