/***************************************************************************
 *   Copyright (C) 2009 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#ifdef WINDOWS
#ifdef OPENACCESS
#include <winsock2.h>
// #define _WINSOCKAPI_
#endif
#endif
#include <QMainWindow>
#include <QMenu>
#include <QAction>
#include <QToolBar>
#include <QPrinter>
#include "macro/menus.h"
#include "macro/macromenuentry.h"
#include "general/setup.h"
#include "widgets/multitoolbutton.h"
#include "widgets/singletoolbutton.h"

/**
@author Juergen Thies
*/

class helpWindow;
class lastOpen;

class mainWindow: public QMainWindow
{
    Q_OBJECT
private:
   int lastmode;
public:
    mainWindow();

    ~mainWindow();
public:
    static helpWindow *helpwindow;
    QMenu *getMenu(QString name);

protected:
    multiToolButton *multiButton[30];
    int multiToolButtonNext;
    singleToolButton *singleButton[300];
    int singleToolButtonNext;
    int actionNext;
    QAction *action[300];
    QToolBar *toolBar[30];
    int toolBarNext;
    void addToolbar(QString name, QList<int> list, bool visible=true);
    virtual void spezialToolbar(int){}
    virtual void getFunctionInfo(int , QString *, QObject ** , const char **,helpText *){}
    void addMenu(QString name, QList<int> list);
    
    QMenu *layoutMenu[30];
    int menuNext;
    singleToolButton *undoButton,*redoButton;
    QAction *undoAction, *redoAction;
    QMenu *mainmenu;
    menus *menuList, *mainMenu;
    macroMenuEntry *macroList;
    QString className;
    lastOpen *lastFiles;
    QPrinter *printer;
public slots:
// undo/redo slots
    void undoEnable(bool b){
      if (undoButton==NULL) return;
	undoButton->setEnabled(b);
	  if (undoAction==NULL) return;
	undoAction->setEnabled(b);
	}
    void redoEnable(bool b){
      if (redoButton==NULL) return;
	redoButton->setEnabled(b);
	  if (redoAction==NULL) return;
	redoAction->setEnabled(b);
	}
    void registerLicense();
    void releaseNotes(){setup::releaseNotes();};
    void about();
    void aboutQt();
    void setNewMode(int i);
    void showMainmenu();
    void showMainmenu(QMenu *);
    virtual void macroStart(QString,QString){};
    void updateMacros();
    void initPrinter(){
	if (printer==NULL) printer = new QPrinter(QPrinter::HighResolution);
	}
	
    bool setShortcut(QString function,QString key); 
signals:
    void newMode(int oldMode,int newMode);
    void executePython(QString code);
public:
    void callPython(QString code){emit executePython(code);}
    void callPythonFile(QString filename);
    void addMacros();
    void addMacroTree(QString *path,QString *menuName,QString *parentName);
};

#endif
