/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <QApplication>
#include "layout.h"
#include <qstring.h>
#include <qtextcodec.h>
#include <qtranslator.h>
#include <QLocale>
#include <QPixmap>
#include <QBitmap>
#include <QColor>
#include <stdio.h>
#include "general/splash.h"
#include "general/layers.h"
#include "macro/macro.h"
#include "widgets/mousewidget.h"
#include "general/errorreport.h"
#include "widgets/selectwidget.h"
#include "defines.h"
#include <QDir>
#include "general/project.h"
#ifdef SCHEMATIC
#include "schematic/schematic.h"
#endif
#ifdef CODEMETER
#define _CODEMETER_API_STATIC_LIB
#include "codemeter/cmlicenseconnection.h"
#include "codemeter/CodeMeter.h"
#endif
#ifdef TEXTEDIT
#include "textedit/textedit.h"
#endif
//#include <X11/Xlib.h>
/**
@author Juergen Thies
*/



//#include "qtc-gdbmacros/gdbmacros.cpp"


int main( int argc, char ** argv ) {
  QApplication a( argc, argv );
#ifdef printtime
#ifdef __GNUC__
printf("Compiler version GCC %d %d, ",__GNUC__, __GNUC_MINOR__);
#endif
  setup::centralTimer.start();
#endif
#ifdef CODEMETER
#include "codemeter/maininclude.cpp"
#endif
//    #ifdef Q_WS_X11
//    int i=XInitThreads();
    
//printf("%s\n",QApplication::applicationDirPath().toAscii().data());

// performs global init
setup::init();

    viewModeType viewonly=defaultmode;

    bool help=false;
    bool showLicenseSelector=false;
    bool startWithSchematic=false;
    bool startWithTextEdit=false;
    QString s;

    for (int i=1;i<a.argc();i++) {
        //printf("%s\n",a.argv()[i]);
        s= QString(a.argv()[i]);
        if (s=="-v")
            viewonly=viewermode;
	if (s=="-f")
            viewonly=fullmode;
	if (s=="-b")
            viewonly=basicmode;
	if (s=="-i")
            viewonly=intermediatemode;
	if (s=="-c")
            viewonly=custommode;
        if (s=="--viewonly")
            viewonly=viewermode;
        if (s=="-h")
            help=true;
        if (s=="-s")
            showLicenseSelector=true;
        if (s=="--schematic")
            startWithSchematic=true;
	if (s=="--textedit")
            startWithTextEdit=true;
        if (s=="--help")
            help=true;
	if (s=="--debug") {
            //debug_flag=true;
	    layout::debug=true;
		}
	if (s=="-d"){
            //debug_flag=true;
	    layout::debug=true;
		}
    }
    if (!help) {

        QPixmap pixmap(":/splash");
        QSplashScreen *splashscreen = new splash(pixmap);
        //splashscreen->setMask(pixmap.mask());
	//QString("Version: ")+QString(VERSION), Qt::AlignBottom+Qt::AlignHCenter,QColor ( 255, 255, 255, 200 ));
        //qApp->processEvents();
	//sleep(30);
	//setup::setLang("de");
        /*QTranslator t(0);
        QLocale locale = QLocale::system();
        //printf("%s\n",locale.name().left(2).toAscii().data());
	//bool tloaded=t.load(QString("layout_ru"),"/home/thies/layout/translation"); 
        bool tloaded=t.load(QString("layout_")+locale.name().left(2),".");
	#ifndef WINDOWS 
	if (!tloaded) {  tloaded=t.load(QString("layout_")+locale.name().left(2),"/usr/share/layout"); }
	#else
	if (!tloaded) {  tloaded=t.load(QString("layout_")+locale.name().left(2),"C:/program files/layout"); }
	if (!tloaded) {  tloaded=t.load(QString("layout_")+locale.name().left(2),"C:/Programme/layout"); }
	#endif
	if (!!tloaded) setup::language=locale.name().left(2);
	a.installTranslator(&t);
        QTranslator tqt(0);
 	tloaded=tqt.load(QString("qt_")+locale.name().left(2),".");
	#ifndef WINDOWS 
	if (!tloaded) {  tloaded=tqt.load(QString("qt_")+locale.name().left(2),"/usr/share/layout"); }
	#else
	if (!tloaded) {  tloaded=tqt.load(QString("qt_")+locale.name().left(2),"C:/program files/layout"); }
	if (!tloaded) {  tloaded=tqt.load(QString("qt_")+locale.name().left(2),"C:/Programme/layout"); }
	#endif
	a.installTranslator(&tqt);
	#ifdef TEXTEDIT
        QTranslator tqsci(0);
 	tloaded=tqsci.load(QString("qscintilla_")+locale.name().left(2),".");
	#ifndef WINDOWS 
	if (!tloaded) {  tloaded=tqsci.load(QString("qscintilla_")+locale.name().left(2),"/usr/share/layout"); }
	#else
	if (!tloaded) {  tloaded=tqsci.load(QString("qscintilla_")+locale.name().left(2),"C:/program files/layout"); }
	if (!tloaded) {  tloaded=tqsci.load(QString("qscintilla_")+locale.name().left(2),"C:/Programme/layout"); }
	#endif
	a.installTranslator(&tqt);
	#endif*/
#ifndef GENISYS
#endif

	//schematic *sw2=newSchematic();
	//sw2->show();
#ifdef GENISYS
	splashscreen->show();
	//splashscreen->showMessage("");
	//a.processEvents();
	
	viewonly=genisysmode;
	for (int i=1;i<a.argc();i++) {
            s= QString(a.argv()[i]);
            if (s.left(1)!="-") {
		viewonly=genisysmodenoopen;
		}
		}

	startWithSchematic=false;
#endif
        layout * mw = project::newLayout(viewonly);
        mw->setWindowTitle( "LayoutEditor" );
	splashscreen->finish(mw);
#ifdef printtime
printf("start time: %d ms\n", setup::centralTimer.elapsed());
#endif
	setup::preShowMessage();
	#ifdef SCHEMATIC
	schematic *sw;
	if (startWithSchematic) {
		sw=project::getSchematic(mw);
		sw->setWindowTitle( "LayoutEditor" );
		sw->show();
		}
#ifdef TEXTEDIT
	else if (startWithTextEdit) {
		textEdit *te=new textEdit();
		te->setWindowTitle( "TextEditor" );
		te->show();
		}
#endif
	else {
		mw->show();
	 	}
	#else
	mw->show();
	#endif
#ifndef GENISYS
#endif
        delete splashscreen;
	bool execMacro=false;
	QString macroFileName;
        a.connect( &a, SIGNAL(lastWindowClosed()), &a, SLOT(quit()) );
        int k=0;
        for (int i=1;i<a.argc();i++) {
            s= QString(a.argv()[i]);
            if (s.left(1)!="-") {
                k++;
                if (k==1) {
		    QString s1="", s2="";
		    QString s3=a.arguments().at(i);
		    if (macro::isMacro(&s3, &s1,&s2)){
		    	k--;
			execMacro=true;
			macroFileName=a.arguments().at(i);
		        }
		    else {
                    	mw->drawing->openFile(a.arguments().at(i));
			mw->cellsUpdate();
		    	mw->filename=a.arguments().at(i);
			mw->setWindowTitle( mw->filename );
			mw->drawing->paint();
			}
                } else {
		    layout *l=project::newLayout(viewonly);
                    l->drawing->openFile(a.arguments().at(i));
		    l->cellsUpdate();
		    l->filename=a.arguments().at(i);
		    l->setWindowTitle( l->filename );
			l->drawing->paint();
                }
            }
        }
        	return a.exec();
    } else {
        printf("usage:\n");
        printf("layout [-options] [macro] [filename]\n\n");
        printf("-h  show this help\n");
        printf("-v  viewonly mode\n");
	printf("-f  full mode\n");
	printf("-b  basic mode\n");
	printf("-i  intermediate mode\n");
	printf("-c  custom mode\n");
	printf("-d  turn on debug menu\n");
	printf("-s  show license dialog\n");
	printf("--schematic  start with schematic window\n");
	printf("--textedit  start with text editor window\n");
    }
 return 0;
}


