/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef VARIANT_H
#define VARIANT_H
#include <qstring.h>
//Added by qt3to4:
#include "elements/pointarray.h"
#include "macro.h"

/**
@author Juergen Thies
*/
class layout;
class keywords;
class drawingField;
class cell;
class cellList;
class element;
class elementList;
class QPoint;
class pointArray;
class QRect;
class file;
class drc;
class stringList;
#ifdef netlistutility
	class netListModule;
	class netList;
	class netListDevice;
#endif
#ifdef barcodeutility
	class barcodeModule;
#endif
#ifdef backgroundutility
	class backgroundModule;
#endif
#ifdef USE_3d
	class view3dModule;
#endif
#ifdef SCHEMATIC
	class schematic;
	class schematicDisplay;
	class sheetList;
	class sheet;
	class sElement;
	class sElementList;
#endif
#ifdef TEXTEDIT
 class textEdit;
 class textDisplay;
#endif
class layerTranslator;
class variant {
public:
    variant();
    variant(const variant &ret2);
    ~variant();
    void deleteData();
    varType type;
    bool deleteAfter;
    union {
    void *data;
    int *i;
	qint16 *int16;
	qint32 *int32;
    bool *b;
    double *d;
    QString *s;
    QStringList *sl;
    layout *Layout;
    cell *Cell;
    cellList *CellList;
    drawingField *DrawingField;
    element *Element;
    elementList *ElementList;
    QPoint *Point;
    pointArray *PointArray;
    QRect *Rect;
    file *File;
    drc *Drc;
#ifdef SCHEMATIC
    schematic *Schematic;
    schematicDisplay *SchematicDisplay;
    sheetList *SheetList;
    sheet *Sheet;
    sElement *SElement;
    sElementList *SElementlist;
#endif
#ifdef netlistutility
	netListModule *NetListModule;
	netList *NetList;
	netListDevice *NetListDevice;
#endif
#ifdef barcodeutility
	barcodeModule *BarcodeModule;
#endif
#ifdef backgroundutility
	backgroundModule *BackgroundModule;
#endif
#ifdef USE_3d
	view3dModule *View3dModule;
#endif
#ifdef TEXTEDIT
        textEdit *TextEdit;
        textDisplay *TextDisplay;
#endif
	layerTranslator *LayerTranslator;
      };
    int getInt() const;
    int* getPtrInt() const;
    void setInt(int i);
    double getDouble() const;
    double* getPtrDouble() const;
    void setDouble(double i);
    bool getBool() const;
    void setBool(bool i);
    QString getString() const;
    QString* getPtrString() const;
    void setString(QString i);
    void setPtrString(QString *i);
    QStringList getStringList() const;
    QStringList* getPtrStringList() const;
    void setStringList(QStringList i);
    void setPtrStringList(QStringList *i);
    layerTranslator getLayerTranslator() const;
    layerTranslator* getPtrLayerTranslator() const;
    void setLayerTranslator(layerTranslator i);
    void setPtrLayerTranslator(layerTranslator *i);
    layout* getLayout() const;
    void setPtrLayout(layout* l);
    void setLayout(layout l);
    void setPoint(QPoint p);
    void setPointArray(pointArray l);
    void setCell(cell c);
    void setCellList(cellList l);
    void setElement(element l);
    void setElementList(elementList l);
    void setPtrPoint(QPoint *p);
    void setPtrPointArray(pointArray *l);
    void setPtrCell(cell *c);
    void setPtrCellList(cellList *l);
    void setPtrElement(element *l);
    void setPtrElementList(elementList *l);
    void setPtrDrc(drc *d);
#ifdef netlistutility
	void setPtrNetListModule(netListModule *nlm);
	void setPtrNetList(netList *nl);
	void setPtrNetListDevice(netListDevice *nld);
	void setNetList(netList nl);
	void setNetListDevice(netListDevice nld);
#endif
#ifdef barcodeutility
	void setPtrBarcodeModule(barcodeModule *nlm);
#endif
#ifdef backgroundutility
	void setPtrBackgroundModule(backgroundModule *nlm);
#endif
#ifdef USE_3d
	void setPtrView3dModule(view3dModule *nlm);
#endif
#ifdef SCHEMATIC
    void setPtrSchematic(schematic* l);
    void setSchematic(schematic l);
    schematic* getSchematic() const;

    void setPtrSchematicDisplay(schematicDisplay* l);
    void setSchematicDisplay(schematicDisplay l);
    schematicDisplay* getSchematicDisplay() const;

    void setPtrSheetList(sheetList* l);
    void setSheetList(sheetList l);
    sheetList* getSheetList() const;

    void setPtrSheet(sheet* l);
    void setSheet(sheet l);
    sheet* getSheet() const;

    void setPtrSElement(sElement* l);
    void setSElement(sElement l);
    sElement* getSElement() const;

    
    void setPtrSElementList(sElementList *l);
    void setSElementList(sElementList l);
    sElementList* getSElementList() const;
    
#endif
#ifdef TEXTEDIT
    void setPtrTextEdit(textEdit* l);
    void setTextEdit(textEdit l);
    textEdit* getTextEdit() const;

    void setPtrTextDisplay(textDisplay* l);
    void setTextDisplay(textDisplay l);
    textDisplay* getTextDisplay() const;
#endif
    file getFile() const;
    file* getPtrFile() const;
    void setFile(file f);
    void setPtrFile(file *f);
    void setType(varType);
    cell* getCell() const;
    cellList* getCellList() const;
    drawingField* getDrawingField() const;
    drc* getDrc() const;
#ifdef netlistutility
	netListModule* getNetListModule() const;
	netList* getNetList() const;
	netListDevice* getNetListDevice() const;
#endif
#ifdef barcodeutility
	barcodeModule* getBarcodeModule() const;
#endif
#ifdef backgroundutility
	backgroundModule* getBackgroundModule() const;
#endif
#ifdef USE_3d
	view3dModule* getView3dModule() const;
#endif
    QPoint* getPoint() const;
    pointArray* getPointArray() const;
    QRect* getRect() const;
    element* getElement() const;
    elementList* getElementList() const;
    void setClassHandler(keywords *k);
    variant & operator=(const variant &);
    variant & operator<<(const variant &);
    variant & operator+=(const variant &);
    variant & operator-=(const variant &);
    variant & operator*=(const variant &);
    variant & operator/=(const variant &);
    variant & operator++(int);
    variant & operator--(int);
    variant convertToPtr()const;
    variant convertToVar()const;
    friend const variant operator! (const variant &r1);
    friend const variant operator* (const variant &r1,const variant &r2);
    friend const variant operator/ (const variant &r1,const variant &r2);
    friend const variant operator+ (const variant &r1,const variant &r2);
    friend const variant operator- (const variant &r1,const variant &r2);
    friend const variant operator% (const variant &r1,const variant &r2);
    friend const variant operator== (const variant &r1,const variant &r2);
    friend const variant operator!= (const variant &r1,const variant &r2);
    friend const variant operator<= (const variant &r1,const variant &r2);
    friend const variant operator>= (const variant &r1,const variant &r2);
    friend const variant operator< (const variant &r1,const variant &r2);
    friend const variant operator> (const variant &r1,const variant &r2);
    friend const variant operator&& (const variant &r1,const variant &r2);
    friend const variant operator|| (const variant &r1,const variant &r2);
    int int_;
    double double_;
    bool bool_;
};
 
#endif
