/***************************************************************************
 *   Copyright (C) 2008 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef STRING_H
#define STRING_H
#include <QString>

#include <QDateTime>
/**
@author Juergen Thies
*/


//! string  class
/*!
a  string
*/
class string:public QString{
public:
//! string
/*!
creates a string
@nomacro
*/
    string();
    string(const QString&);

    ~string();
 
 //! contain a string
/*!
@return true if the string contains the string str. Otherwise false.
*/ 
//-bool contains(string str);
 //! left
/*!
@return the left i char of the string
*/
//-string left(int i);
 //! length
/*!
@return length of the string (same as size)
*/ 
//-int length();
 //! mid of string
/*!
@return length a path of the string starting at position i with the length k. 
The rest of the string starting at position i is returned if k is -1 or missing.
*/ 
//-string mid(int i, int k=-1);
//! set number
/*!
Set the string to the number i
*/
string setNum(int i){ return QString::setNum(i,10);};
//! set number
/*!
Set the string to the number d with precision of k
*/
string setNum(double d, int k){ return QString::setNum(d,'f',k);};
//! convert to integer
/*!
The string is converted to a integer.
*/
//-int toInt();
//! convert to double
/*!
The string is converted to a double.
*/
//-double toDouble();
double toEngDouble();
 //! size
/*!
@return length of the string (same as length)
*/
//-int size();
//! split
/*!
The string is is splitten into a stringList
*/
//-void split(QString s);
//! set date and time
/*!
Set the string to the current date and time. With the string format the format can be set. Without the string the date is set to local setup.<br>
The format string may contain:<br>
<table  class="parameter">
<tr>
<th>Expression</th> <th>Output</th>
<tr><td>d</td><td>the day as number without a leading zero (1 to 31)</td> </tr>
<tr><td>dd</td><td>the day as number with a leading zero (01 to 31)</td> </tr>
<tr><td>ddd</td><td>the abbreviated localized day name (e.g. 'Mon' to 'Sun').</td> </tr>
<tr><td>dddd</td><td>the long localized day name (e.g. 'Qt::Monday' to 'Qt::Sunday').</td> </tr>
<tr><td>M</td><td>the month as number without a leading zero (1-12)</td> </tr>
<tr><td>MM</td><td>the month as number with a leading zero (01-12)</td> </tr>
<tr><td>MMM</td><td>the abbreviated localized month name (e.g. 'Jan' to 'Dec').</td> </tr>
<tr><td>MMMM</td><td>the long localized month name (e.g. 'January' to 'December').</td> </tr>
<tr><td>yy</td><td>the year as two digit number (00-99)</td> </tr>
<tr><td>yyyy</td><td>the year as four digit number (1752-8000)</td> </tr>
<tr><td>h</td><td>the hour without a leading zero (0 to 23 or 1 to 12 if AM/PM display)</td> </tr>
<tr><td>hh</td><td>the hour with a leading zero (00 to 23 or 01 to 12 if AM/PM display)</td> </tr>
<tr><td>m</td><td>the minute without a leading zero (0 to 59)</td> </tr>
<tr><td>mm</td><td>the minute with a leading zero (00 to 59)</td> </tr>
<tr><td>s</td><td>the second without a leading zero (0 to 59)</td> </tr>
<tr><td>ss</td><td>the second with a leading zero (00 to 59)</td> </tr>
<tr><td>z</td><td>the milliseconds without leading zeroes (0 to 999)</td> </tr>
<tr><td>zzz</td><td>the milliseconds with leading zeroes (000 to 999)</td> </tr>
<tr><td>AP</td><td>use AM/PM display. AP will be replaced by either "AM" or "PM".</td> </tr>
<tr><td>ap</td><td>use am/pm display. ap will be replaced by either "am" or "pm".</td> </tr>
</table>
*/
string setDateTime(QString format=""){
  if (format=="") (*this)=QDateTime::currentDateTime().toString();
  else (*this)= QDateTime::currentDateTime().toString(format);
  return (*this);
};
//! set time
/*!
Set the string to the current time. With the string format the format can be set. Without the string the date is set to local setup.  @link "setDateTime%Class string;setDateTime" for possible formats
*/
string setTime(QString format=""){
  if (format=="") (*this)=QTime::currentTime().toString();
  else (*this)= QTime::currentTime().toString(format);
  return (*this);
};
//! set date
/*!
Set the string to the current date. With the string format the format can be set. Without the string the date is set to local setup. @link "setDateTime%Class string;setDateTime" for possible formats
*/
string setDate(QString format=""){
  if (format=="") (*this)=QDate::currentDate().toString();
  else (*this)= QDate::currentDate().toString(format);
  return (*this);
};
//! index of
/*!
Returns the index position of the first occurrence of the string str in this string, searching forward from index position from. Returns -1 if str is not found.
*/
//-int indexOf(string str, int index);
//! index of
/*!
Returns the index position of the last occurrence of the string str in this string, searching backward from index position from. If from is -1, the search starts at the last character; if from is -2, at the next to last character and so on. Returns -1 if str is not found.
*/
//-int lastIndexOf(string str, int index);
//! remove
/*!
Remove all str from the string. The removement is case sensitive.
*/
//-string remove(string str);
//! replace
/*!
All existing strings match is replaced with with. The replacement is case sensitive.
*/
//-string replace(string macht,string with);   
//! parameter
/*!
@return the parameter str. <br>
Example: <br>
<code>
string s="type=2 width=4 length=6";<br>
s=s.parameter("width");<br>
// s="4";<br>
</code>
*/
QString parameter(QString s);
 

int matchParenthesis(int start); 

};

#endif
