/***************************************************************************
 *   Copyright (C) 2009 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 ***************************************************************************/
#include "schematic/schematic.h"


void macro::schematicHandler_registerKeywords(keywords **keyword_,schematic *l){
 *keyword_= new keywords(*keyword_);
 (*keyword_)->keyword="schematic";
 (*keyword_)->type=intClass;
 (*keyword_)->r=new returnValue();
 (*keyword_)->r->setType(ptrSchematic);
 (*keyword_)->r->setPtrSchematic(l);
 (*keyword_)->classHandler=&macro::schematicHandler_classHandler;
}

returnValue macro::schematicHandler_classHandler(int *counter, keywords *keyword_,returnValue* r,bool left){
 QString s;
 returnValue ret;
 parserValue p;
 if (r->type==ptrSchematic){
   if (checkClassPointer(counter)) {
   }
   else {
   	if (left) {compute(r,counter,keyword_);return ret;}
     	else return *r;
	}
   }
 //else (r->type==varLayout){}
 schematic *l=r->getSchematic();
#ifdef SCHEMATIC
 if (l==NULL) {
	l = project::getSchematic(layoutWindow);
	}
#endif
 p=next(counter);
 // variables
 if ((p.type==keyword)&&(p.value=="filename")){
 		returnValue r2;
		r2.type=varString;
		r2.deleteAfter=false;
		r2.s=&(l->filename);
		//printf("fn %s\n",l->filename.toAscii().data());
		r2=stringHandler_classHandler(counter,keyword_,&r2,left);
		return r2;
 	}
else if ((p.type==keyword)&&(p.value=="drawing")){
 		returnValue r2;
		r2.setType(ptrSchematicDisplay);
		r2.deleteAfter=false;
		r2.SchematicDisplay=(l->drawing);
		r2=schematicDisplayHandler_classHandler(counter,keyword_,&r2,left);
		return r2;
 	}
else if ((p.type==keyword)&&(p.value=="saveNetList")){
 		testParenOpen(counter);
		returnValue p1=calculate(counter,keyword_);
		testComma(counter);
		returnValue p2=calculate(counter,keyword_);
		testParenClose(counter);
		l->saveNetList(p1.getString(),p2.getString());
 	}
else if ((p.type==keyword)&&(p.value=="generateNetList")){
 		testParenOpen(counter);
		returnValue p1=calculate(counter,keyword_);
		testParenClose(counter);
		ret.setString(l->generateNetList(p1.getString()));
		ret=stringHandler_classHandler(counter,keyword_,&ret,false);
 	}
 else {
  	error->addItem(tr("Class schematic has no member ")+p.value,1,message((*counter)));
	throw 1;
 	}
 if (left)  if (!checkSemicolon(counter)) {throw 15;}  
 return ret;
}

