#ifndef PROCESS_H
#define PROCESS_H

#include <QProcess>

//! process
/*!
The process class is used to start external programs.
*/
class process :public QProcess{
  private:
    process(){};
public:
//! execute
/*!
command is executed with arguments. It waits untill commend terminates and the exitcode is returned.
*/
int execute(QString command,QString arguments){
   return QProcess::execute(command,arguments.split(" "));
};
//! startDetached
/*!
command is executed with arguments. It returns true if the program launch was successfull.
*/
bool startDetached(QString command,QString arguments){
   return QProcess::startDetached(command,arguments.split(" "));};
//! get environment variable
/*!
get environment variable
*/
QString getEnv(QString parameter){
   return QString(getenv(parameter.toAscii().data()));};
//! set environment variable
/*!
set environment variable
*/
int setEnv(QString parameter,QString value){
   
   	/*#ifdef Q_OS_WIN32*/
	QString s=parameter+"="+value;
	return (int)(putenv(s.toAscii().data()));
	/*#else
	return setenv(parameter.toAscii().data(),value.toAscii().data(),1);
	#endif*/
      }
};


#endif
