/***************************************************************************
 *   Copyright (C) 2008 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 ***************************************************************************/

#include "parservalue.h"
#include "keywords.h"
#include "general/errorreport.h"
#include "general/drawingfield.h"

#include "net/netlistmodule.h"




void macro::netListModuleHandler_registerKeywords(keywords **keyword_){
  *keyword_= new keywords(*keyword_);
 (*keyword_)->keyword="netListModule";
 (*keyword_)->type=type;
 (*keyword_)->typeHandler=&macro::netListModuleHandler_typeHandler;
}

void macro::netListModuleHandler_typeHandler(int *counter,keywords **keyword_,bool single){
generalTypeProcessing(counter,keyword_,ptrNetListModule,ptrNetListModule,single);
}

returnValue macro::netListModuleHandler_classHandler(int *counter, keywords *keyword_,returnValue *r,bool left){
 QString s;
 returnValue ret;
 parserValue p;
 if (r->type==ptrNetListModule){
   if (checkClassPointer(counter)) {
   }
   else { 
   	if (left) { compute(r,counter,keyword_);return ret;}
     	else return *r;
	}
   }
 else throw 1;
 netListModule *d= r->getNetListModule();
 p=next(counter);
 // methods
 if (((p.type==keyword)&&(p.value=="libraryAdd"))) { testParenOpen(counter); 
    returnValue par1=calculate(counter,keyword_);
	testParenClose(counter);
	d->libraryAdd(par1.getString());}
 else if (((p.type==keyword)&&(p.value=="libraryRemoveAll"))) { testParenOpen(counter); testParenClose(counter);
	d->libraryRemoveAll();}
 else if (((p.type==keyword)&&(p.value=="technologyLayerRemoveAll"))) { testParenOpen(counter); testParenClose(counter);
	d->technologyLayerRemoveAll();}
 else if (((p.type==keyword)&&(p.value=="technologyLayerAdd"))) { testParenOpen(counter);
	returnValue par1=calculate(counter,keyword_);testComma(counter);
	returnValue par2=calculate(counter,keyword_);testParenClose(counter);
	d->technologyLayerAdd(par1.getInt(),par2.getInt());}
 else if (((p.type==keyword)&&(p.value=="technologyLayerSetParameter"))) { testParenOpen(counter);
	returnValue par1=calculate(counter,keyword_);testComma(counter);
	returnValue par2=calculate(counter,keyword_);testComma(counter);
	returnValue par3=calculate(counter,keyword_);testParenClose(counter);
	d->technologyLayerSetParameter(par1.getInt(),par2.getInt(),par3.getInt());}
 else  if (((p.type==keyword)&&(p.value=="netlistLoad"))) { testParenOpen(counter); 
    returnValue par1=calculate(counter,keyword_);
	testParenClose(counter);
	d->netlistLoad(par1.getString());}
 else if (((p.type==keyword)&&(p.value=="netlistSave"))) { testParenOpen(counter);
	returnValue par1=calculate(counter,keyword_);testComma(counter);
	returnValue par2=calculate(counter,keyword_);testParenClose(counter);
	d->netlistSave(par1.getString(),par2.getInt());}
 else  if (((p.type==keyword)&&(p.value=="clearLVSList"))) { testParenOpen(counter); 
	testParenClose(counter);
	d->clearLVSList();}
 else  if (((p.type==keyword)&&(p.value=="lvs"))) { testParenOpen(counter); 
	testParenClose(counter);
	d->lvs();}
 else  if (((p.type==keyword)&&(p.value=="buildConnect"))) { testParenOpen(counter); 
	testParenClose(counter);
	d->buildConnect();}
 else if (((p.type==keyword)&&(p.value=="addLVSList"))) { testParenOpen(counter);
	returnValue par1=calculate(counter,keyword_);testComma(counter);
	returnValue par2=calculate(counter,keyword_);testParenClose(counter);
	d->addLVSList(par1.getString(),par2.getString());}
 else if (((p.type==keyword)&&(p.value=="extractedNetlistSave"))) { testParenOpen(counter);
	returnValue par1=calculate(counter,keyword_);testComma(counter);
	returnValue par2=calculate(counter,keyword_);testParenClose(counter);
	d->extractedNetlistSave(par1.getString(),par2.getInt());}
 else if (((p.type==keyword)&&(p.value=="technologyLayerConductorSpaceing"))) { testParenOpen(counter);
	returnValue par1=calculate(counter,keyword_);testParenClose(counter);
	ret.setInt(d->technologyLayerConductorSpaceing(par1.getInt()));}
 else if (((p.type==keyword)&&(p.value=="technologyLayerConductorSize"))) { testParenOpen(counter);
	returnValue par1=calculate(counter,keyword_);testParenClose(counter);
	ret.setInt(d->technologyLayerConductorSize(par1.getInt()));}
 else if (((p.type==keyword)&&(p.value=="getLoadedNetList"))) { testParenOpen(counter);
	returnValue par1=calculate(counter,keyword_);testParenClose(counter);
	ret.setPtrNetList(d->getLoadedNetList(par1.getString()));
	ret=netListHandler_classHandler(counter,keyword_,&ret,false);}
 else if (((p.type==keyword)&&(p.value=="getExtracatedNetList"))) { testParenOpen(counter);
	returnValue par1=calculate(counter,keyword_);testParenClose(counter);
	ret.setPtrNetList(d->getExtracatedNetList(par1.getString()));
	ret=netListHandler_classHandler(counter,keyword_,&ret,false);}
 else if (((p.type==keyword)&&(p.value=="getLibrary"))) { testParenOpen(counter); 
	testParenClose(counter);
	ret.setStringList(d->getLibrary());
	ret=stringListHandler_classHandler(counter,keyword_,&ret,false);
	}
 else {
  	error->addItem(tr("Class netlistmodul has no member ")+p.value,1,message((*counter)));
	throw 1;
 	}
 if (left)  if (!checkSemicolon(counter)) {throw 15;}  
 return ret;
}


