/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "splash.h"
#include <QPainter>
#include <QPen>
#include "defines.h"
#include "setup.h"
#include <QApplication>
#include <QBitmap>


splash::splash(QPixmap p)
 : QSplashScreen()
{
  setPixmap(p);
  setMask(p.mask());
}


splash::~splash()
{
}

void splash:: setPixmap( const QPixmap & pixmap){
  QPixmap p=pixmap;
  QPainter paint(&p);
  drawContent(&paint);
  paint.end();
  QSplashScreen::setPixmap(p);
}

void splash::drawContent ( QPainter * painter ){
QFont f("Helvetica");
f.setPixelSize(19);
f.setStyleStrategy(QFont::PreferAntialias);
f.setStyleStrategy(QFont::PreferQuality);
int up=0;
f.setPixelSize(13);
painter->setFont(f);
painter->setPen(qRgb(0,0,0));
painter->drawText(208,265-up,200,20,Qt::AlignRight,QString("Build: ")+QString(VERSION));
f.setPixelSize(10);
painter->setFont(f);
painter->setPen(qRgb(0,0,0));
painter->drawText(QPoint(10,280),QChar(0xA9)+QString("2004-2009 J")+QChar(0xFC)+QString("rgen Thies"));
painter->drawText(QPoint(10,295),QChar(0xA9)+QString("2010 juspertor UG (haftungsbeschr")+QChar(0xE4)+QString("nkt)"));
}
