/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef PAINTPIXMAPTHREAD_H
#define PAINTPIXMAPTHREAD_H

#include <QtGlobal>
#include <QThread>
#include <QMutex>
#include <QWaitCondition>
#include <QTimer>
#include "drawpixmap.h"
#ifdef SCHEMATIC
class schematicDisplay;
#endif
/**
@author Juergen Thies
*/

class drawingField;

class paintPixmapThread : public QThread, public drawpixmap 
{
Q_OBJECT
public:
    paintPixmapThread(drawingField* dr);
#ifdef SCHEMATIC
    paintPixmapThread(schematicDisplay * schem);
#endif
    ~paintPixmapThread();
private:
    drawingField *d;
#ifdef SCHEMATIC
    schematicDisplay * schem;
#endif
    QTimer timer;
private slots:
    void updates();
 protected:
    void run();
signals:
        void updateRequest();
	void timerStart(int time);
 public:
    void startPaint();
    void abortPaint();
    void endPaint();

    bool abort;
    void drawElement(element *e);

private:
	QMutex mutex;
        QWaitCondition condition;
	bool finnished;
	QTime drawTime;

 quint8 paintDetailsLast;
};

#endif
